<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
    version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:sm="http://www.sitemaps.org/schemas/sitemap/0.9">

  <xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

  <xsl:template match="/">
    <html>
      <head>
        <title>Sitemap - SEO Engine</title>
        <meta name="description" content="HTML Sitemap generated by SEO Engine, providing an overview of website structure."/>
        <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
        <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&amp;display=swap" rel="stylesheet"/>
        <style>
          /* Reset and Base Styles */
          * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
          }

          body {
            font-family: 'Roboto', Arial, sans-serif;
            background-color: #f8f9fa; 
            color: #343a40; 
            line-height: 1.6;
            padding: 20px;
            position: relative; 
            overflow-x: hidden; 
          }

          body::before {
            content: '';
            position: fixed;
            left: -50vw;     
            top: -50vh;      
            width: 200vw;    
            height: 200vh;
            z-index: -1;     
            
            background-image: var(--random-emoji-bg); 
            background-size: var(--bg-emoji-size, 60px) var(--bg-emoji-size, 60px); 
            background-repeat: repeat;
            
            opacity: 0.07; 
            
            transform: rotate(-45deg); 
            transform-origin: center center;
            
            animation: scrollOnRotated 150s linear infinite; 
            pointer-events: none; 
          }

          @keyframes scrollOnRotated {
            0% {
              background-position: 0 0;
            }
            100% {

              background-position: calc(var(--bg-emoji-size, 60px) * 10) 0;
            }
          }

          .container {
            max-width: 960px;
            margin: 40px auto;
            padding: 0 15px;
            position: relative;
            z-index: 1;
          }


          h1 {
            font-size: 2.5em;
            font-weight: 700;
            text-align: center;
            margin-bottom: 20px;
            color: #007bff;
            letter-spacing: -1px;
          }
          
          .sitemap-type-emoji {
            font-size: 1.5em;
            vertical-align: middle;
          }

          p.description {
            font-size: 1.1em;
            text-align: center;
            margin-bottom: 40px;
            color: #6c757d;
            max-width: 700px;
            margin-left: auto;
            margin-right: auto;
          }


          table {
            width: 100%;
            border-collapse: collapse;
            background-color: #ffffff;
            border-radius: 8px;
            overflow: hidden; 
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
            margin-bottom: 40px;
            table-layout: fixed;
          }

          table thead tr {
            background-color: #007bff;
            color: #ffffff;
            font-size: 1em;
            font-weight: 500;
            text-align: left;
          }

          table th,
          table td {
            padding: 15px 20px; 
            text-align: left;
            font-size: 0.95em;
            border-bottom: 1px solid #dee2e6; 
          }

          table th {
            font-weight: 700;
          }
          
          table td:first-child,
          table th:first-child {
            text-align: center;
            width: 8%; /* Width for # column */
          }
          
          table th.loc-col, table td.loc-col { width: 50%; } /* URL / Loc column */
          table th.lastmod-col, table td.lastmod-col { width: 20%; }
          table th.priority-col, table td.priority-col { width: 10%; text-align: center; }
          table th.changefreq-col, table td.changefreq-col { width: 12%; text-align: center;}


          table tbody tr {
            transition: background-color 0.25s ease-in-out, box-shadow 0.25s ease-in-out;
          }

          table tbody tr:nth-child(even) {
            background-color: #f8f9fa; 
          }

          table tbody tr:hover {
            background-color: #e9ecef; 
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
          }
          
          table tbody tr:last-child td {
             border-bottom: none;
          }

          table td a {
            color: #0056b3; 
            text-decoration: none;
            font-weight: 500;
            transition: color 0.2s ease-in-out;
            word-break: break-all;
          }

          table td a:hover,
          table td a:focus {
            color: #003875;
            text-decoration: underline;
          }
          
          .no-data {
            color: #6c757d; 
            font-style: italic;
          }

          .footer {
            text-align: center;
            padding: 20px;
            font-size: 0.9em;
            color: #6c757d;
            border-top: 1px solid #dee2e6;
            margin-top: 40px;
          }
          .footer a {
            color: #007bff;
            text-decoration: none;
          }
          .footer a:hover {
            text-decoration: underline;
          }


          @media screen and (max-width: 768px) {
            body { padding: 10px; }
            .container { margin: 20px auto; }
            h1 { font-size: 2em; }
            p.description { font-size: 1em; }

            table {
              display: block;
              overflow-x: auto; 
              box-shadow: none;
              border-radius: 0;
            }
            
            table thead {
              display: none; 
            }

            table tbody tr {
              display: block;
              margin-bottom: 15px;
              border: 1px solid #dee2e6;
              border-radius: 4px;
              background-color: #fff !important; /* Ensure content readability on mobile */
            }
            
            table tbody tr:nth-child(even) {
                background-color: #fff !important; /* Ensure content readability on mobile */
            }

            table td {
              display: block;
              text-align: right; 
              padding-left: 50%; 
              position: relative;
              border-bottom: 1px solid #e9ecef;
            }
            
            table td:last-child {
                border-bottom: none;
            }

            table td:before {
              content: attr(data-label);
              position: absolute;
              left: 15px;
              width: calc(50% - 30px);
              padding-right: 10px;
              font-weight: 700;
              text-align: left; 
              white-space: nowrap;
            }
            
            table td.loc-col { word-break: break-all; }
            
            table td:first-child,
            table th:first-child,
            table th.priority-col, table td.priority-col,
            table th.changefreq-col, table td.changefreq-col {
                text-align: right; 
                width: auto;
            }
          }

          @media screen and (max-width: 480px) {
             h1 { font-size: 1.8em; }
             table td { padding-left: 40%; }
             table td:before { width: calc(40% - 20px); left: 10px; }
          }
        </style>
        <script type="text/javascript">
          // <![CDATA[
          document.addEventListener('DOMContentLoaded', function() {
            const emojis = ['😀', '😂', '😊', '😎', '😍', '🤔', '🥳', '🌟', '🎉', '💡', '✨', '🌍', '🗺️', '🧭', '🕸️', '📄', '📈', '📊', '🔍', '✅', '➡️', '💯', '〰️', '⚙️', '👍', '🌐', '💡'];
            const randomEmoji = emojis[Math.floor(Math.random() * emojis.length)];
            
            const emojiDisplaySize = 120; // in pixels

            const svgInternalSize = 200; // Internal dimension of the SVG
            const svgFontSize = 60;   // Font size of the emoji within the SVG (relative to svgInternalSize)

            const svgText = `<svg xmlns='http://www.w3.org/2000/svg' width='${svgInternalSize}' height='${svgInternalSize}' viewBox='0 0 ${svgInternalSize} ${svgInternalSize}'><text x='50%' y='50%' font-size='${svgFontSize}' dominant-baseline='middle' text-anchor='middle'>${randomEmoji}</text></svg>`;
            const svgDataUri = `url("data:image/svg+xml;charset=utf-8,${encodeURIComponent(svgText)}")`;

            // Set CSS custom properties on the root element (<html>)
            document.documentElement.style.setProperty('--random-emoji-bg', svgDataUri);
            document.documentElement.style.setProperty('--bg-emoji-size', `${emojiDisplaySize}px`);
          });
          // ]]>
        </script>
      </head>
      <body>
        <div class="container">
          <xsl:choose>
            <xsl:when test="sm:sitemapindex">
              <h1>Sitemap Index <span class="sitemap-type-emoji">🗂️</span></h1>
              <p class="description">This is a sitemap index file, listing other sitemaps.</p>
              <table>
                <thead>
                  <tr>
                    <th>#</th>
                    <th class="loc-col">Sitemap Location</th>
                    <th class="lastmod-col">Last Modified</th>
                  </tr>
                </thead>
                <tbody>
                  <xsl:for-each select="sm:sitemapindex/sm:sitemap">
                    <tr>
                      <td data-label="#">
                        <xsl:value-of select="position()"/>
                      </td>
                      <td data-label="Sitemap Location" class="loc-col">
                        <a href="{sm:loc}" target="_blank" rel="noopener noreferrer">
                          <xsl:value-of select="sm:loc"/>
                        </a>
                      </td>
                      <td data-label="Last Modified" class="lastmod-col">
                        <xsl:choose>
                          <xsl:when test="sm:lastmod">
                            <xsl:value-of select="substring-before(sm:lastmod, 'T')"/>
                            <xsl:text> </xsl:text>
                            <xsl:value-of select="substring-before(substring-after(sm:lastmod, 'T'), '+')"/>
                             <xsl:value-of select="substring-before(substring-after(sm:lastmod, 'T'), 'Z')"/>
                          </xsl:when>
                          <xsl:otherwise>
                            <span class="no-data">—</span>
                          </xsl:otherwise>
                        </xsl:choose>
                      </td>
                    </tr>
                  </xsl:for-each>
                </tbody>
              </table>
            </xsl:when>

            <xsl:when test="sm:urlset">
              <h1>Sitemap <span class="sitemap-type-emoji">🗺️</span></h1>
              <p class="description">This sitemap lists all the URLs for this section of the website.</p>
              <table>
                <thead>
                  <tr>
                    <th>#</th>
                    <th class="loc-col">URL</th>
                    <th class="priority-col">Priority</th>
                    <th class="changefreq-col">Change Freq.</th>
                    <th class="lastmod-col">Last Modified</th>
                  </tr>
                </thead>
                <tbody>
                  <xsl:for-each select="sm:urlset/sm:url">
                    <tr>
                      <td data-label="#">
                        <xsl:value-of select="position()"/>
                      </td>
                      <td data-label="URL" class="loc-col">
                        <a href="{sm:loc}" target="_blank" rel="noopener noreferrer">
                          <xsl:value-of select="sm:loc"/>
                        </a>
                      </td>
                      <td data-label="Priority" class="priority-col">
                        <xsl:choose>
                            <xsl:when test="sm:priority and sm:priority != ''">
                                <xsl:value-of select="sm:priority"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <span class="no-data">—</span>
                            </xsl:otherwise>
                        </xsl:choose>
                      </td>
                      <td data-label="Change Freq." class="changefreq-col">
                        <xsl:choose>
                            <xsl:when test="sm:changefreq and sm:changefreq != ''">
                                <xsl:value-of select="sm:changefreq"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <span class="no-data">—</span>
                            </xsl:otherwise>
                        </xsl:choose>
                      </td>
                      <td data-label="Last Modified" class="lastmod-col">
                        <xsl:choose>
                          <xsl:when test="sm:lastmod and sm:lastmod != ''">
                            <xsl:value-of select="substring-before(sm:lastmod, 'T')"/>
                            <xsl:text> </xsl:text>
                            <xsl:value-of select="substring-before(substring-after(sm:lastmod, 'T'), '+')"/>
                             <xsl:value-of select="substring-before(substring-after(sm:lastmod, 'T'), 'Z')"/>
                          </xsl:when>
                          <xsl:otherwise>
                            <span class="no-data">—</span>
                          </xsl:otherwise>
                        </xsl:choose>
                      </td>
                    </tr>
                  </xsl:for-each>
                </tbody>
              </table>
            </xsl:when>

            <xsl:otherwise>
              <div style="text-align: center; padding: 40px;">
                <h1>Unknown Sitemap Format <span class="sitemap-type-emoji">❓</span></h1>
                <p class="description">We couldn’t find a <code>&lt;urlset&gt;</code> or <code>&lt;sitemapindex&gt;</code> root element in the XML file.</p>
                <p><a href="javascript:history.back()" style="color: #007bff; text-decoration:none; font-weight:bold;">Go Back</a></p>
              </div>
            </xsl:otherwise>
          </xsl:choose>

          <div class="footer">
            <p>Generated by <a href="https://meowapps.com/seo-engine/" target="_blank" rel="noopener noreferrer">SEO Engine</a> | HTML Sitemap</p>
          </div>
        </div>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>