/* # site_url: https://ki.zork.no */;
/* # home_url: https://ki.zork.no */;
/* # content_url: https://ki.zork.no/wp-content */;
/* # upload_url: https://ki.zork.no/wp-content/uploads */;
/* # table_prefix: wp_ */;


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `wp_mo_openid_linked_user`
--

DROP TABLE IF EXISTS `wp_mo_openid_linked_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_mo_openid_linked_user` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `linked_social_app` varchar(55) NOT NULL,
  `linked_email` varchar(55) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `identifier` varchar(100) NOT NULL,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_mo_openid_linked_user`
--

LOCK TABLES `wp_mo_openid_linked_user` WRITE;
/*!40000 ALTER TABLE `wp_mo_openid_linked_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp_mo_openid_linked_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_mwai_filemeta`
--

DROP TABLE IF EXISTS `wp_mwai_filemeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_mwai_filemeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `file_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_mwai_filemeta`
--

LOCK TABLES `wp_mwai_filemeta` WRITE;
/*!40000 ALTER TABLE `wp_mwai_filemeta` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp_mwai_filemeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_mwai_files`
--

DROP TABLE IF EXISTS `wp_mwai_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_mwai_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(32) DEFAULT NULL,
  `status` varchar(32) DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `expires` datetime DEFAULT NULL,
  `path` text DEFAULT NULL,
  `url` text DEFAULT NULL,
  `refId` varchar(64) NOT NULL,
  `envId` varchar(128) DEFAULT NULL,
  `userId` bigint(20) unsigned DEFAULT NULL,
  `purpose` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_mwai_files`
--

LOCK TABLES `wp_mwai_files` WRITE;
/*!40000 ALTER TABLE `wp_mwai_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp_mwai_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_mwai_logmeta`
--

DROP TABLE IF EXISTS `wp_mwai_logmeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_mwai_logmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `log_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=InnoDB AUTO_INCREMENT=77503 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_mwai_logmeta`
--

LOCK TABLES `wp_mwai_logmeta` WRITE;
/*!40000 ALTER TABLE `wp_mwai_logmeta` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp_mwai_logmeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_mwai_logs`
--

DROP TABLE IF EXISTS `wp_mwai_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_mwai_logs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `userId` bigint(20) DEFAULT NULL,
  `ip` varchar(64) DEFAULT NULL,
  `session` varchar(64) DEFAULT NULL,
  `model` varchar(64) DEFAULT NULL,
  `mode` varchar(64) DEFAULT NULL,
  `units` int(11) NOT NULL DEFAULT 0,
  `type` varchar(64) DEFAULT NULL,
  `price` float NOT NULL DEFAULT 0,
  `env` varchar(64) DEFAULT NULL,
  `tags` varchar(128) DEFAULT NULL,
  `apiRef` varchar(128) DEFAULT NULL,
  `apiSrv` varchar(128) DEFAULT NULL,
  `apiOwn` varchar(128) DEFAULT NULL,
  `time` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=83929 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_mwai_logs`
--

LOCK TABLES `wp_mwai_logs` WRITE;
/*!40000 ALTER TABLE `wp_mwai_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp_mwai_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_mwai_vectors`
--

DROP TABLE IF EXISTS `wp_mwai_vectors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_mwai_vectors` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `type` varchar(32) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `content` text DEFAULT NULL,
  `behavior` varchar(32) NOT NULL DEFAULT 'context',
  `status` varchar(32) DEFAULT NULL,
  `dbIndex` varchar(64) NOT NULL,
  `dbNS` varchar(64) NOT NULL,
  `refId` bigint(20) DEFAULT NULL,
  `refChecksum` varchar(64) DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `dbId` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_mwai_vectors`
--

LOCK TABLES `wp_mwai_vectors` WRITE;
/*!40000 ALTER TABLE `wp_mwai_vectors` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp_mwai_vectors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_mwcode_snippets`
--

DROP TABLE IF EXISTS `wp_mwcode_snippets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_mwcode_snippets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` tinytext NOT NULL,
  `description` text NOT NULL,
  `code` longtext NOT NULL,
  `tags` longtext NOT NULL,
  `scope` varchar(255) NOT NULL DEFAULT '',
  `priority` smallint(6) NOT NULL DEFAULT 10,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `endpoint` varchar(255) NOT NULL DEFAULT '',
  `token` varchar(255) NOT NULL DEFAULT '',
  `method` varchar(15) NOT NULL DEFAULT 'POST',
  `created` datetime NOT NULL DEFAULT current_timestamp(),
  `updated` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_mwcode_snippets`
--

LOCK TABLES `wp_mwcode_snippets` WRITE;
/*!40000 ALTER TABLE `wp_mwcode_snippets` DISABLE KEYS */;
INSERT INTO `wp_mwcode_snippets` VALUES (1,'Make upload filenames lowercase','Makes sure that image and file uploads have lowercase filenames.\n\nThis is a sample snippet. Feel free to use it, edit it, or remove it.','add_filter( \'sanitize_file_name\', \'mb_strtolower\' );','sample,media,front,admin','front,admin',10,0,'','','POST','2024-04-17 20:59:02','2024-04-17 20:59:02');
INSERT INTO `wp_mwcode_snippets` VALUES (2,'Disable admin bar','Turns off the WordPress admin bar for everyone except administrators.\n\nThis is a sample snippet. Feel free to use it, edit it, or remove it.','add_action( \'wp\', function () {\n	if ( ! current_user_can( \'manage_options\' ) ) {\n		show_admin_bar( false );\n	}\n} );','sample,admin-bar,front','front',10,0,'','','POST','2024-04-17 20:59:02','2024-04-17 20:59:02');
INSERT INTO `wp_mwcode_snippets` VALUES (3,'Allow smilies','Allows smiley conversion in obscure places.\n\nThis is a sample snippet. Feel free to use it, edit it, or remove it.','add_filter( \'widget_text\', \'convert_smilies\' );\nadd_filter( \'the_title\', \'convert_smilies\' );\nadd_filter( \'wp_title\', \'convert_smilies\' );\nadd_filter( \'get_bloginfo\', \'convert_smilies\' );','sample,front,admin','front,admin',10,0,'','','POST','2024-04-17 20:59:02','2024-04-17 20:59:02');
INSERT INTO `wp_mwcode_snippets` VALUES (4,'Current year','Shortcode for inserting the current year into a post or page..\n\nThis is a sample snippet. Feel free to use it, edit it, or remove it.','echo date( \'Y\' ); ?>','sample,dates,content','content',10,0,'','','POST','2024-04-17 20:59:02','2024-04-17 20:59:02');
INSERT INTO `wp_mwcode_snippets` VALUES (5,'AI chatbot','','add_action( \'wp_footer\', function () {\r\n  if ( is_user_logged_in() ) {\r\n    echo do_shortcode( "[mwai_chat t context=\'You are ChatGPT, a large language model trained by OpenAI. Answer as concisely as possible. Use markdown.\' ai_name=\'\' user_name=\'\' start_sentence=\'Hei! Jeg er GPT4 og jeg hjelper deg gjerne med det du lurer på.\' text_input_placeholder=\'Skriv her...\' icon_text=\'Hei! Jeg heter GPT4 og slår gjerne av en prat.\' text_input_maxlength=\'1024\' text_compliance=\'Dette er en test av GPT4. Den er smart, men bruker mer tid på å svare. Husk at en AI kan skrive ting som ikke stemmer med virkeligheten, og den gir ikke beskjed om når den gjør det.\' model=\'gpt-4\' max_tokens=\'512\' fullscreen=\'true\' window=\'true\']" );\r\n  }\r\n} );','front','front',10,0,'','','POST','2024-04-17 20:59:02','2024-04-17 20:59:02');
INSERT INTO `wp_mwcode_snippets` VALUES (6,'image to chatbot','','add_filter( \'mwai_ai_query\', function ( $query ) {\n    // First, check if the ID of the chatbot is \'gpt-4\'\n    if ( $query->chatbotid !== \'gpt-4\' ) {\n        return $query;\n    }\n  \n    // Get the last message sent to the query\n    $last = $query->get_message();\n\n    // Check if the last message starts with "/imagine"\n    if ( strpos( $last, "/imagine" ) !== false ) {\n        // Remove "/imagine" from the message and trim any whitespace\n        $last = trim( str_replace( "/imagine", "", $last ) );\n\n        // Create a new image query with the modified message\n        $query = new Meow_MWAI_Query_Image( $last );\n\n        // Return the modified query\n        return $query;\n    }\n\n    // If none of the conditions above are met, return the original query\n    return $query;\n}, 999, 1 );','front','front',10,0,'','','POST','2024-04-19 07:04:57','2024-04-19 10:27:49');
/*!40000 ALTER TABLE `wp_mwcode_snippets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_pp_activity_logs`
--

DROP TABLE IF EXISTS `wp_pp_activity_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_pp_activity_logs` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `ip` varchar(55) NOT NULL,
  `browser` text NOT NULL,
  `status` tinytext NOT NULL,
  `created_at` varchar(55) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_pp_activity_logs`
--

LOCK TABLES `wp_pp_activity_logs` WRITE;
/*!40000 ALTER TABLE `wp_pp_activity_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp_pp_activity_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_pp_limit_password`
--

DROP TABLE IF EXISTS `wp_pp_limit_password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_pp_limit_password` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `client_ip` varchar(55) NOT NULL,
  `password_attempts` int(11) NOT NULL,
  `attempt_at` varchar(55) NOT NULL,
  `locked_at` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_pp_limit_password`
--

LOCK TABLES `wp_pp_limit_password` WRITE;
/*!40000 ALTER TABLE `wp_pp_limit_password` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp_pp_limit_password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_pp_manage_passwords`
--

DROP TABLE IF EXISTS `wp_pp_manage_passwords`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_pp_manage_passwords` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `password` varchar(55) NOT NULL,
  `encrypted_password` varchar(55) NOT NULL,
  `uses` mediumint(9) NOT NULL,
  `used` mediumint(9) NOT NULL DEFAULT 0,
  `expiry` varchar(55) NOT NULL,
  `status` varchar(55) NOT NULL DEFAULT 'Active',
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_pp_manage_passwords`
--

LOCK TABLES `wp_pp_manage_passwords` WRITE;
/*!40000 ALTER TABLE `wp_pp_manage_passwords` DISABLE KEYS */;
INSERT INTO `wp_pp_manage_passwords` VALUES (6,'allelikerbarn','0079848ad8dc6b5b7306ea418483ca21',1000000,17,'2020464000','Active','2024-01-10 09:39:44');
INSERT INTO `wp_pp_manage_passwords` VALUES (14,'allelikersang','1894cbcf099b657ae20d3f55e8995e04',100000,2,'1859587200','Active','2024-02-05 13:59:34');
INSERT INTO `wp_pp_manage_passwords` VALUES (24,'allelikerserafim','bac843ac7b96bcacea5b5172628465cf',100000,2,'1897689600','Active','2024-02-19 08:38:22');
INSERT INTO `wp_pp_manage_passwords` VALUES (35,'allelikerrandaberg','81778d807fa1a8fce71ee4615eb67985',1000,30,'1717200000','Active','2024-03-21 14:00:46');
INSERT INTO `wp_pp_manage_passwords` VALUES (44,'everybodylikesai','d749d83839dae15ce4f18a8a326ce9a9',10000,17,'1715385600','Expired','2024-04-22 10:15:28');
INSERT INTO `wp_pp_manage_passwords` VALUES (45,'allelikerfag','29d448b9741d892e751457ec29fa67b4',10000,243,'1716076800','Active','2024-04-22 14:54:27');
INSERT INTO `wp_pp_manage_passwords` VALUES (46,'allelikerplaner','ed78b2148005b443dc461e953203775d',1000,0,'1716681600','Active','2024-04-25 14:46:38');
INSERT INTO `wp_pp_manage_passwords` VALUES (48,'allelikergaver','9c94560cd7f17cf6c681061114978752',1000,5,'1716249600','Active','2024-05-06 08:28:28');
INSERT INTO `wp_pp_manage_passwords` VALUES (49,'allelikermatte','0fa380da4de3ae3d54a2fcac30369737',1000,107,'1716249600','Active','2024-05-06 23:54:18');
INSERT INTO `wp_pp_manage_passwords` VALUES (50,'allelikerkorn','19a62e39727b2455ae5e33ed3a225eb7',1000,54,'1716336000','Active','2024-05-06 23:56:00');
INSERT INTO `wp_pp_manage_passwords` VALUES (51,'allelikernrk','8e682719c93f76e9a0ae2dd9026c1aca',1000,1,'1719705600','Active','2024-05-08 10:41:06');
INSERT INTO `wp_pp_manage_passwords` VALUES (52,'allelikertm','33fff0dfe55ab042f334b9a75b7c578e',1000,23,'1719705600','Active','2024-05-08 12:19:10');
/*!40000 ALTER TABLE `wp_pp_manage_passwords` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_pp_taxonomy_passwords`
--

DROP TABLE IF EXISTS `wp_pp_taxonomy_passwords`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_pp_taxonomy_passwords` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `taxonomy_id` varchar(150) NOT NULL,
  `taxonomy` varchar(150) NOT NULL,
  `password` varchar(255) NOT NULL,
  `encrypted_password` varchar(255) NOT NULL,
  `usage_limit` bigint(20) NOT NULL,
  `used` bigint(20) NOT NULL,
  `expiry` varchar(150) NOT NULL,
  `status` varchar(150) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_pp_taxonomy_passwords`
--

LOCK TABLES `wp_pp_taxonomy_passwords` WRITE;
/*!40000 ALTER TABLE `wp_pp_taxonomy_passwords` DISABLE KEYS */;
INSERT INTO `wp_pp_taxonomy_passwords` VALUES (1,'0','category','allelikergruver','cd12e33595ffce25b5f2ec110533f18c',-1,0,'2024-01-10','active');
INSERT INTO `wp_pp_taxonomy_passwords` VALUES (2,'0','category','allelikerkirker','266838769e713100e8a9d56594d90bab',-1,2,'2024-01-10','active');
INSERT INTO `wp_pp_taxonomy_passwords` VALUES (3,'global','category','allelikerpaven','ac4675258900d40f2399a20c6bc2e856',-1,2,'2024-01-15','active');
INSERT INTO `wp_pp_taxonomy_passwords` VALUES (4,'global','category','allelikerks','c0856a2e42a91c2cd5718cc39d5e0e71',-1,3,'2024-01-23','active');
INSERT INTO `wp_pp_taxonomy_passwords` VALUES (5,'global','category','testtest','05a671c66aefea124cc08b76ea6d30bb',-1,0,'2024-01-08','active');
/*!40000 ALTER TABLE `wp_pp_taxonomy_passwords` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_wflocs`
--

DROP TABLE IF EXISTS `wp_wflocs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT 0.0000000,
  `lon` float(10,7) DEFAULT 0.0000000,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_wflocs`
--

LOCK TABLES `wp_wflocs` WRITE;
/*!40000 ALTER TABLE `wp_wflocs` DISABLE KEYS */;
INSERT INTO `wp_wflocs` VALUES (0x00000000000000000000FFFFC1A09521,1699859093,0,'Randaberg','Rogaland','Norway','NO',58.9995995,5.5956001);
INSERT INTO `wp_wflocs` VALUES (0x00000000000000000000FFFFD5340A52,1699888415,0,'Oslo','Oslo County','Norway','NO',59.9550018,10.8590002);
/*!40000 ALTER TABLE `wp_wflocs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_wfls_settings`
--

DROP TABLE IF EXISTS `wp_wfls_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob DEFAULT NULL,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_wfls_settings`
--

LOCK TABLES `wp_wfls_settings` WRITE;
/*!40000 ALTER TABLE `wp_wfls_settings` DISABLE KEYS */;
INSERT INTO `wp_wfls_settings` VALUES ('2fa-user-grace-period',0x3130,'yes');
INSERT INTO `wp_wfls_settings` VALUES ('allow-disabling-ntp',0x31,'yes');
INSERT INTO `wp_wfls_settings` VALUES ('allow-xml-rpc',0x31,'yes');
INSERT INTO `wp_wfls_settings` VALUES ('captcha-stats',0x7B22636F756E7473223A5B302C302C302C302C302C302C302C302C302C302C305D2C22617667223A307D,'yes');
INSERT INTO `wp_wfls_settings` VALUES ('delete-deactivation','','yes');
INSERT INTO `wp_wfls_settings` VALUES ('disable-temporary-tables',0x30,'yes');
INSERT INTO `wp_wfls_settings` VALUES ('enable-auth-captcha','','yes');
INSERT INTO `wp_wfls_settings` VALUES ('enable-login-history-columns',0x31,'yes');
INSERT INTO `wp_wfls_settings` VALUES ('enable-shortcode','','yes');
INSERT INTO `wp_wfls_settings` VALUES ('enable-woocommerce-account-integration','','yes');
INSERT INTO `wp_wfls_settings` VALUES ('enable-woocommerce-integration','','yes');
INSERT INTO `wp_wfls_settings` VALUES ('global-notices',0x5B5D,'yes');
INSERT INTO `wp_wfls_settings` VALUES ('ip-source','','yes');
INSERT INTO `wp_wfls_settings` VALUES ('ip-trusted-proxies','','yes');
INSERT INTO `wp_wfls_settings` VALUES ('last-secret-refresh',0x31363931393437323439,'yes');
INSERT INTO `wp_wfls_settings` VALUES ('recaptcha-threshold',0x302E35,'yes');
INSERT INTO `wp_wfls_settings` VALUES ('remember-device','','yes');
INSERT INTO `wp_wfls_settings` VALUES ('remember-device-duration',0x32353932303030,'yes');
INSERT INTO `wp_wfls_settings` VALUES ('require-2fa-grace-period-enabled','','yes');
INSERT INTO `wp_wfls_settings` VALUES ('require-2fa.administrator','','yes');
INSERT INTO `wp_wfls_settings` VALUES ('schema-version',0x32,'yes');
INSERT INTO `wp_wfls_settings` VALUES ('shared-hash-secret',0x34353565323038356439653435323339393165343132326431393532633534613335386164326139393933353536636536396261353864643463643331643632,'yes');
INSERT INTO `wp_wfls_settings` VALUES ('shared-symmetric-secret',0x62616164623934303564343166623464363764363933633935323137306164663136656431313735303232376431616263306239656163366331663664313235,'yes');
INSERT INTO `wp_wfls_settings` VALUES ('stack-ui-columns',0x31,'yes');
INSERT INTO `wp_wfls_settings` VALUES ('user-count-query-state',0x30,'yes');
INSERT INTO `wp_wfls_settings` VALUES ('whitelisted','','yes');
INSERT INTO `wp_wfls_settings` VALUES ('xmlrpc-enabled',0x31,'yes');
/*!40000 ALTER TABLE `wp_wfls_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_wfreversecache`
--

DROP TABLE IF EXISTS `wp_wfreversecache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_wfreversecache`
--

LOCK TABLES `wp_wfreversecache` WRITE;
/*!40000 ALTER TABLE `wp_wfreversecache` DISABLE KEYS */;
INSERT INTO `wp_wfreversecache` VALUES (0x00000000000000000000FFFFC1A09521,'33-randaberg.kommune.no',1699859093);
INSERT INTO `wp_wfreversecache` VALUES (0x00000000000000000000FFFFD5340A52,'static82.cust.as2116.net',1699888413);
/*!40000 ALTER TABLE `wp_wfreversecache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_wftrafficrates`
--

DROP TABLE IF EXISTS `wp_wftrafficrates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_wftrafficrates` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_wftrafficrates`
--

LOCK TABLES `wp_wftrafficrates` WRITE;
/*!40000 ALTER TABLE `wp_wftrafficrates` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp_wftrafficrates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_wpvivid_unused_uploads_files`
--

DROP TABLE IF EXISTS `wp_wpvivid_unused_uploads_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_wpvivid_unused_uploads_files` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `folder` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=609 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_wpvivid_unused_uploads_files`
--

LOCK TABLES `wp_wpvivid_unused_uploads_files` WRITE;
/*!40000 ALTER TABLE `wp_wpvivid_unused_uploads_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp_wpvivid_unused_uploads_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_links`
--

DROP TABLE IF EXISTS `wp_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_links`
--

LOCK TABLES `wp_links` WRITE;
/*!40000 ALTER TABLE `wp_links` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_mclean_scan`
--

DROP TABLE IF EXISTS `wp_mclean_scan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_mclean_scan` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `type` tinyint(1) NOT NULL,
  `postId` bigint(20) DEFAULT NULL,
  `path` tinytext DEFAULT NULL,
  `size` int(9) DEFAULT NULL,
  `ignored` tinyint(1) NOT NULL DEFAULT 0,
  `deleted` tinyint(1) NOT NULL DEFAULT 0,
  `issue` tinytext NOT NULL,
  `parentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IgnoredIndex` (`ignored`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_mclean_scan`
--

LOCK TABLES `wp_mclean_scan` WRITE;
/*!40000 ALTER TABLE `wp_mclean_scan` DISABLE KEYS */;
INSERT INTO `wp_mclean_scan` VALUES (1,'2025-03-16 12:41:02',1,74,'2023/03/Mitt-prosjekt-6.jpg (+ 4 files)',788349,0,1,'ORPHAN_MEDIA',NULL);
INSERT INTO `wp_mclean_scan` VALUES (2,'2025-03-16 12:41:02',1,299,'2023/04/MyOnlyEye_an_icon_of_a_crowd_studying_pixar_style_2f089151-6ea0-43c0-be30-d98c8ebd267e.jpg (+ 4 files)',468731,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (3,'2025-03-16 12:41:02',1,317,'2023/04/MyOnlyEye_an_icon_of_a_casual_happy_crowd_studying_pixar_style_c7fc8092-3c0a-4429-8ecc-0ed8ff97ca21.jpg (+ 4 files)',334572,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (4,'2025-03-16 12:41:02',1,765,'2023/08/myonlyeye_swahili_casual_happy_pixar_style_white_background_c1b50d77-50ba-4adf-bbdb-8262539a3260.jpg (+ 4 files)',320251,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (5,'2025-03-16 12:41:02',1,1218,'2025/03/kinetica___A_cute_Viking_with_a_surprised_expression_in_a_tradi_0c54d4e4-9dfe-4a2c-b8c3-3d392c288d131.jpg (+ 4 files)',474201,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (6,'2025-03-17 10:23:31',1,71,'2023/03/Mitt-prosjekt-3.jpg (+ 4 files)',304109,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (7,'2025-03-17 10:23:31',1,72,'2023/03/Mitt-prosjekt-4-e1680166322713.jpg (+ 4 files)',343735,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (8,'2025-03-17 10:23:31',1,216,'2023/03/MyOnlyEye_in_icon_of_a_writing_club_style_pixar_444fe45f-82d2-4d13-b0e2-2218150be1c0-e1723884876259.jpg (+ 4 files)',183501,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (9,'2025-03-17 10:23:31',1,217,'2023/03/MyOnlyEye_in_icon_of_a_writing_club_style_pixar_da9c18e9-bae4-4bfe-b16d-96f22e391593.jpg (+ 4 files)',471666,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (10,'2025-03-17 10:23:31',1,253,'2023/03/Mitt-prosjekt-8-e1681720768248.jpg (+ 4 files)',241475,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (11,'2025-03-17 10:23:31',1,254,'2023/03/Mitt-prosjekt-1-2-e1694046969640.jpg (+ 4 files)',191376,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (12,'2025-03-17 10:23:31',1,258,'2023/03/Mitt-prosjekt-5-1.jpg (+ 4 files)',286222,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (13,'2025-03-17 10:23:31',1,304,'2023/04/Mitt-prosjekt-5.jpg (+ 4 files)',240903,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (14,'2025-03-17 10:23:31',1,318,'2023/04/MyOnlyEye_casual_happy_crowd_studying_with_laptops_pixar_style_11b64b1c-8b53-4993-8750-2c1ca85f87a9.jpg (+ 4 files)',403446,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (15,'2025-03-17 10:23:31',1,383,'2023/04/Mitt-prosjekt-6.jpg (+ 4 files)',206775,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (16,'2025-03-17 10:23:31',1,406,'2023/04/MyOnlyEye_an_icon_of_a_female_egg_causal_happy_pixar_style_36387029-e099-4b05-8927-eeb82fb21249.jpg (+ 4 files)',392765,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (17,'2025-03-17 10:23:31',1,533,'2023/04/MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985.jpg (+ 4 files)',315776,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (18,'2025-03-17 10:23:31',1,585,'2023/05/MyOnlyEye_a_female_and_male_teacher_giving_feedback_casual_happ_ba954a98-7956-40a0-9a6a-a1cb175102ca.jpg (+ 4 files)',379302,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (19,'2025-03-17 10:23:31',1,586,'2023/05/MyOnlyEye_an_AI_talking_to_a_boy_and_a_girl_casual_happy_pixar__372a0b04-1764-436b-9b88-ff16d4ebd29d.jpg (+ 4 files)',322532,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (20,'2025-03-17 10:23:31',1,617,'2023/05/MyOnlyEye_behind_the_curtains_pixar_style_e38be4a1-346e-46a9-b376-bd4f0be78708-e1684924115381.jpg (+ 4 files)',427409,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (21,'2025-03-17 10:23:31',1,713,'2023/06/Mitt-prosjekt.jpg (+ 4 files)',482707,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (22,'2025-03-17 10:23:31',1,855,'2023/08/myonlyeye_a_very_polite_writer_pixar_style_white_background_2e9f7252-0cb8-47ae-aa4d-80289454d2b3.jpg (+ 4 files)',375225,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (23,'2025-03-17 10:23:31',1,857,'2023/08/myonlyeye_a_polite_butler_carrying_a_scroll_pixar_style_white_b_de12e82c-1869-452f-b2a7-b012d7103c7a.jpg (+ 4 files)',233467,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (24,'2025-03-17 10:23:31',1,1028,'2023/09/myonlyeye_a_female_pupil_using_a_laptop_style_of_Don_Bluth_flat_52967297-4442-4f18-9fbc-63ad285423cc.jpg (+ 4 files)',225454,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (25,'2025-03-17 10:23:31',1,1225,'2025/03/Mitt-prosjekt-1.png (+ 4 files)',1371747,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (26,'2025-03-17 10:23:31',1,1228,'2025/03/MyOnlyEye_a_glass_ball_of_words_pixar_style_48ba36fd-5c63-4416-b4ea-1a41e8efbe14.jpg (+ 4 files)',314051,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (27,'2025-03-17 10:23:31',1,1229,'2025/03/myonlyeye_a_dragon_style_of_Don_Bluth_flat_animation_Disneys_Fa_4726194e-3717-4a56-adce-33c7ff7ee0e6.jpg (+ 4 files)',431933,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (28,'2025-03-17 10:23:31',1,1230,'2025/03/robot4.png (+ 4 files)',787590,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (29,'2025-03-17 10:23:31',1,1231,'2025/03/MyOnlyEye_an_icon_of_a_treasure_chest_style_pixar_1eb7d463-3c47-4398-9640-41aa4e54bc21.jpg (+ 4 files)',351353,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (30,'2025-03-17 10:23:31',1,1232,'2025/03/myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_47e25d43-95dc-4aa1-beb6-c37d0e815a6a_0.jpg (+ 4 files)',375410,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (31,'2025-03-17 10:23:31',1,1233,'2025/03/myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_47e25d43-95dc-4aa1-beb6-c37d0e815a6a_2.jpg (+ 4 files)',443025,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (32,'2025-03-17 10:23:31',1,1234,'2025/03/myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_79332be8-d98d-40e2-969c-3444fe590fcc_2.jpg (+ 4 files)',433149,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (33,'2025-03-17 10:23:31',1,1235,'2025/03/myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_47e25d43-95dc-4aa1-beb6-c37d0e815a6a_1.jpg (+ 4 files)',476325,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (34,'2025-03-17 10:23:31',1,1236,'2025/03/myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_79332be8-d98d-40e2-969c-3444fe590fcc_0.jpg (+ 4 files)',466021,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (35,'2025-03-17 10:23:31',1,1238,'2025/03/myonlyeye_baby_llama_portrait_white_background_pixar_animatio_b2571457-0400-4a75-aac5-666f30f09103_1.jpg (+ 4 files)',226739,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (36,'2025-03-17 10:23:31',1,1239,'2025/03/ki-randabergskolen-logo.png (+ 4 files)',1269889,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (37,'2025-03-17 10:23:31',1,1240,'2025/03/cropped-ki-randabergskolen-logo.png (+ 3 files)',294120,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (38,'2025-03-17 10:23:31',1,1242,'2025/03/myonlyeye_smiling_socrates_disney_animation_style_neutral_bac_3f5f17a7-6fb6-4a54-8c6f-8c853cc3cc60_1.jpg (+ 4 files)',381040,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (39,'2025-03-17 10:23:31',1,1244,'2025/03/myonlyeye_casual_smiling_kid_portrait_pixar_animation_style_n_1a7ff590-50ab-4a06-a667-1342ae140114_0.jpg (+ 4 files)',323066,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (40,'2025-03-17 10:23:31',1,1246,'2025/03/myonlyeye_a_kind_robot_giving_feedback_to_a_student_pixar_ani_3eb14d92-2e34-4a08-8a59-2f95465c5df8_2.jpg (+ 4 files)',325323,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (41,'2025-03-17 10:23:31',1,1254,'2025/03/myonlyeye_an_argument_pixar_style_neutral_background_1995dd4a-1e90-4d41-8a55-c8fc31556cf9_0.jpg (+ 4 files)',293790,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (42,'2025-03-17 10:23:31',1,1256,'2025/03/myonlyeye_a_happy_pixar_character_writing_in_a_book_neutral_b_51199384-c9b4-4315-9e17-cd74e9f04f44_1.jpg (+ 4 files)',345351,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (43,'2025-03-17 10:23:31',1,1257,'2025/03/superlaerer1.jpg (+ 4 files)',341429,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (44,'2025-03-17 10:23:31',1,1262,'2025/03/myonlyeye_a_robot_in_a_green_shiny_rubber_suit_writing_LaTeX__8d3e07e3-4184-4738-9830-34744295a3d1_0.jpg (+ 4 files)',413472,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (45,'2025-03-17 10:23:31',1,1268,'2025/03/myonlyeye_smart_woman_thinking_style_pixar_-v_6.1_efd87068-8bf2-490d-9805-e6740078881b_1.jpg (+ 4 files)',293505,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (46,'2025-03-17 10:23:31',1,1269,'2025/03/myonlyeye_a_zen_meditation_pixar_style_-v_6.1_d9c64dba-1884-442f-a6c1-eed57daa8ba1_1.jpg (+ 4 files)',378243,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (47,'2025-03-17 10:23:31',1,1270,'2025/03/myonlyeye_a_zen_meditation_pixar_style_-v_6.1_356e3cfa-9df7-4499-b1a7-670a0e78c4fa_3.jpg (+ 4 files)',269548,0,1,'NO_CONTENT',NULL);
INSERT INTO `wp_mclean_scan` VALUES (48,'2025-03-17 10:23:31',1,1279,'2025/03/myonlyeye_exam_talking_casual_happy_style_pixar_-v_6.1_fffb0440-ae2f-4257-9891-98bfb14ce5ec_0-1.jpg (+ 4 files)',348681,0,1,'NO_CONTENT',NULL);
/*!40000 ALTER TABLE `wp_mclean_scan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_mwai_chats`
--

DROP TABLE IF EXISTS `wp_mwai_chats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_mwai_chats` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `chatId` varchar(64) DEFAULT NULL,
  `messages` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `userId` bigint(20) DEFAULT NULL,
  `ip` varchar(64) DEFAULT NULL,
  `botId` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chatId` (`chatId`)
) ENGINE=InnoDB AUTO_INCREMENT=6634 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_mwai_chats`
--

LOCK TABLES `wp_mwai_chats` WRITE;
/*!40000 ALTER TABLE `wp_mwai_chats` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp_mwai_chats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_mwai_tasklogs`
--

DROP TABLE IF EXISTS `wp_mwai_tasklogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_mwai_tasklogs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) unsigned NOT NULL,
  `started` datetime NOT NULL,
  `ended` datetime DEFAULT NULL,
  `status` varchar(16) NOT NULL,
  `message` text DEFAULT NULL,
  `time_taken` float DEFAULT NULL,
  `memory_peak` bigint(20) DEFAULT NULL,
  `step` int(11) DEFAULT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `task_id_started` (`task_id`,`started`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_mwai_tasklogs`
--

LOCK TABLES `wp_mwai_tasklogs` WRITE;
/*!40000 ALTER TABLE `wp_mwai_tasklogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp_mwai_tasklogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_term_relationships`
--

DROP TABLE IF EXISTS `wp_term_relationships`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_term_relationships`
--

LOCK TABLES `wp_term_relationships` WRITE;
/*!40000 ALTER TABLE `wp_term_relationships` DISABLE KEYS */;
INSERT INTO `wp_term_relationships` VALUES (5,2,0);
INSERT INTO `wp_term_relationships` VALUES (7,2,0);
INSERT INTO `wp_term_relationships` VALUES (7,3,0);
INSERT INTO `wp_term_relationships` VALUES (9,18,0);
INSERT INTO `wp_term_relationships` VALUES (9,22,0);
INSERT INTO `wp_term_relationships` VALUES (19,2,0);
INSERT INTO `wp_term_relationships` VALUES (20,2,0);
INSERT INTO `wp_term_relationships` VALUES (20,4,0);
INSERT INTO `wp_term_relationships` VALUES (160,2,0);
INSERT INTO `wp_term_relationships` VALUES (279,5,0);
INSERT INTO `wp_term_relationships` VALUES (280,6,0);
INSERT INTO `wp_term_relationships` VALUES (716,7,0);
INSERT INTO `wp_term_relationships` VALUES (716,8,0);
INSERT INTO `wp_term_relationships` VALUES (716,9,0);
INSERT INTO `wp_term_relationships` VALUES (716,10,0);
INSERT INTO `wp_term_relationships` VALUES (717,9,0);
INSERT INTO `wp_term_relationships` VALUES (717,11,0);
INSERT INTO `wp_term_relationships` VALUES (717,12,0);
INSERT INTO `wp_term_relationships` VALUES (717,13,0);
INSERT INTO `wp_term_relationships` VALUES (717,14,0);
INSERT INTO `wp_term_relationships` VALUES (718,15,0);
INSERT INTO `wp_term_relationships` VALUES (718,16,0);
INSERT INTO `wp_term_relationships` VALUES (719,16,0);
INSERT INTO `wp_term_relationships` VALUES (719,17,0);
INSERT INTO `wp_term_relationships` VALUES (891,18,0);
INSERT INTO `wp_term_relationships` VALUES (891,20,0);
INSERT INTO `wp_term_relationships` VALUES (896,2,0);
INSERT INTO `wp_term_relationships` VALUES (897,2,0);
INSERT INTO `wp_term_relationships` VALUES (966,23,0);
INSERT INTO `wp_term_relationships` VALUES (968,23,0);
INSERT INTO `wp_term_relationships` VALUES (972,23,0);
INSERT INTO `wp_term_relationships` VALUES (974,23,0);
INSERT INTO `wp_term_relationships` VALUES (979,23,0);
INSERT INTO `wp_term_relationships` VALUES (981,23,0);
INSERT INTO `wp_term_relationships` VALUES (983,23,0);
INSERT INTO `wp_term_relationships` VALUES (1058,23,0);
INSERT INTO `wp_term_relationships` VALUES (1071,18,0);
INSERT INTO `wp_term_relationships` VALUES (1071,19,0);
INSERT INTO `wp_term_relationships` VALUES (1071,22,0);
INSERT INTO `wp_term_relationships` VALUES (1189,2,0);
INSERT INTO `wp_term_relationships` VALUES (1222,18,0);
INSERT INTO `wp_term_relationships` VALUES (1222,20,0);
INSERT INTO `wp_term_relationships` VALUES (1222,25,0);
INSERT INTO `wp_term_relationships` VALUES (1294,19,0);
INSERT INTO `wp_term_relationships` VALUES (1294,21,0);
INSERT INTO `wp_term_relationships` VALUES (1296,26,0);
INSERT INTO `wp_term_relationships` VALUES (1299,26,0);
INSERT INTO `wp_term_relationships` VALUES (1302,26,0);
INSERT INTO `wp_term_relationships` VALUES (1306,18,0);
INSERT INTO `wp_term_relationships` VALUES (1306,20,0);
INSERT INTO `wp_term_relationships` VALUES (1306,25,0);
INSERT INTO `wp_term_relationships` VALUES (1306,27,0);
INSERT INTO `wp_term_relationships` VALUES (1308,18,0);
INSERT INTO `wp_term_relationships` VALUES (1308,21,0);
INSERT INTO `wp_term_relationships` VALUES (1308,27,0);
INSERT INTO `wp_term_relationships` VALUES (1311,18,0);
INSERT INTO `wp_term_relationships` VALUES (1311,21,0);
INSERT INTO `wp_term_relationships` VALUES (1311,27,0);
INSERT INTO `wp_term_relationships` VALUES (1313,18,0);
INSERT INTO `wp_term_relationships` VALUES (1313,21,0);
INSERT INTO `wp_term_relationships` VALUES (1313,27,0);
INSERT INTO `wp_term_relationships` VALUES (1315,18,0);
INSERT INTO `wp_term_relationships` VALUES (1315,21,0);
INSERT INTO `wp_term_relationships` VALUES (1315,27,0);
INSERT INTO `wp_term_relationships` VALUES (1317,18,0);
INSERT INTO `wp_term_relationships` VALUES (1317,21,0);
INSERT INTO `wp_term_relationships` VALUES (1317,27,0);
INSERT INTO `wp_term_relationships` VALUES (1319,18,0);
INSERT INTO `wp_term_relationships` VALUES (1319,21,0);
INSERT INTO `wp_term_relationships` VALUES (1319,25,0);
INSERT INTO `wp_term_relationships` VALUES (1319,27,0);
INSERT INTO `wp_term_relationships` VALUES (1321,18,0);
INSERT INTO `wp_term_relationships` VALUES (1321,21,0);
INSERT INTO `wp_term_relationships` VALUES (1321,27,0);
INSERT INTO `wp_term_relationships` VALUES (1323,18,0);
INSERT INTO `wp_term_relationships` VALUES (1323,20,0);
INSERT INTO `wp_term_relationships` VALUES (1323,25,0);
INSERT INTO `wp_term_relationships` VALUES (1323,27,0);
INSERT INTO `wp_term_relationships` VALUES (1325,18,0);
INSERT INTO `wp_term_relationships` VALUES (1325,21,0);
INSERT INTO `wp_term_relationships` VALUES (1325,27,0);
INSERT INTO `wp_term_relationships` VALUES (1327,18,0);
INSERT INTO `wp_term_relationships` VALUES (1327,20,0);
INSERT INTO `wp_term_relationships` VALUES (1327,25,0);
INSERT INTO `wp_term_relationships` VALUES (1329,18,0);
INSERT INTO `wp_term_relationships` VALUES (1329,20,0);
INSERT INTO `wp_term_relationships` VALUES (1329,25,0);
INSERT INTO `wp_term_relationships` VALUES (1331,18,0);
INSERT INTO `wp_term_relationships` VALUES (1331,20,0);
INSERT INTO `wp_term_relationships` VALUES (1331,25,0);
INSERT INTO `wp_term_relationships` VALUES (1333,18,0);
INSERT INTO `wp_term_relationships` VALUES (1333,20,0);
INSERT INTO `wp_term_relationships` VALUES (1333,25,0);
INSERT INTO `wp_term_relationships` VALUES (1333,27,0);
INSERT INTO `wp_term_relationships` VALUES (1335,18,0);
INSERT INTO `wp_term_relationships` VALUES (1335,20,0);
INSERT INTO `wp_term_relationships` VALUES (1335,21,0);
INSERT INTO `wp_term_relationships` VALUES (1335,25,0);
INSERT INTO `wp_term_relationships` VALUES (1335,27,0);
INSERT INTO `wp_term_relationships` VALUES (1337,18,0);
INSERT INTO `wp_term_relationships` VALUES (1337,20,0);
INSERT INTO `wp_term_relationships` VALUES (1337,25,0);
INSERT INTO `wp_term_relationships` VALUES (1337,27,0);
INSERT INTO `wp_term_relationships` VALUES (1339,18,0);
INSERT INTO `wp_term_relationships` VALUES (1339,21,0);
INSERT INTO `wp_term_relationships` VALUES (1339,27,0);
INSERT INTO `wp_term_relationships` VALUES (1341,18,0);
INSERT INTO `wp_term_relationships` VALUES (1341,21,0);
INSERT INTO `wp_term_relationships` VALUES (1341,27,0);
INSERT INTO `wp_term_relationships` VALUES (1343,19,0);
INSERT INTO `wp_term_relationships` VALUES (1343,20,0);
INSERT INTO `wp_term_relationships` VALUES (1343,25,0);
INSERT INTO `wp_term_relationships` VALUES (1345,26,0);
INSERT INTO `wp_term_relationships` VALUES (1348,18,0);
INSERT INTO `wp_term_relationships` VALUES (1348,20,0);
INSERT INTO `wp_term_relationships` VALUES (1348,25,0);
INSERT INTO `wp_term_relationships` VALUES (1350,18,0);
INSERT INTO `wp_term_relationships` VALUES (1350,20,0);
INSERT INTO `wp_term_relationships` VALUES (1350,25,0);
INSERT INTO `wp_term_relationships` VALUES (1352,18,0);
INSERT INTO `wp_term_relationships` VALUES (1352,20,0);
INSERT INTO `wp_term_relationships` VALUES (1352,25,0);
INSERT INTO `wp_term_relationships` VALUES (1357,18,0);
INSERT INTO `wp_term_relationships` VALUES (1357,20,0);
INSERT INTO `wp_term_relationships` VALUES (1357,25,0);
INSERT INTO `wp_term_relationships` VALUES (1359,18,0);
INSERT INTO `wp_term_relationships` VALUES (1359,20,0);
INSERT INTO `wp_term_relationships` VALUES (1359,25,0);
INSERT INTO `wp_term_relationships` VALUES (1361,18,0);
INSERT INTO `wp_term_relationships` VALUES (1361,21,0);
INSERT INTO `wp_term_relationships` VALUES (1363,18,0);
INSERT INTO `wp_term_relationships` VALUES (1363,21,0);
INSERT INTO `wp_term_relationships` VALUES (1365,18,0);
INSERT INTO `wp_term_relationships` VALUES (1365,21,0);
INSERT INTO `wp_term_relationships` VALUES (1367,18,0);
INSERT INTO `wp_term_relationships` VALUES (1367,20,0);
INSERT INTO `wp_term_relationships` VALUES (1367,25,0);
INSERT INTO `wp_term_relationships` VALUES (1369,18,0);
INSERT INTO `wp_term_relationships` VALUES (1369,20,0);
INSERT INTO `wp_term_relationships` VALUES (1369,25,0);
INSERT INTO `wp_term_relationships` VALUES (1371,18,0);
INSERT INTO `wp_term_relationships` VALUES (1371,20,0);
INSERT INTO `wp_term_relationships` VALUES (1371,25,0);
INSERT INTO `wp_term_relationships` VALUES (1373,18,0);
INSERT INTO `wp_term_relationships` VALUES (1373,19,0);
INSERT INTO `wp_term_relationships` VALUES (1373,21,0);
INSERT INTO `wp_term_relationships` VALUES (1375,19,0);
INSERT INTO `wp_term_relationships` VALUES (1375,20,0);
INSERT INTO `wp_term_relationships` VALUES (1375,25,0);
INSERT INTO `wp_term_relationships` VALUES (1377,18,0);
INSERT INTO `wp_term_relationships` VALUES (1377,20,0);
INSERT INTO `wp_term_relationships` VALUES (1377,25,0);
INSERT INTO `wp_term_relationships` VALUES (1379,19,0);
INSERT INTO `wp_term_relationships` VALUES (1379,21,0);
INSERT INTO `wp_term_relationships` VALUES (1381,18,0);
INSERT INTO `wp_term_relationships` VALUES (1381,20,0);
INSERT INTO `wp_term_relationships` VALUES (1381,25,0);
INSERT INTO `wp_term_relationships` VALUES (1383,18,0);
INSERT INTO `wp_term_relationships` VALUES (1383,19,0);
INSERT INTO `wp_term_relationships` VALUES (1383,20,0);
INSERT INTO `wp_term_relationships` VALUES (1383,25,0);
INSERT INTO `wp_term_relationships` VALUES (1387,26,0);
INSERT INTO `wp_term_relationships` VALUES (1390,26,0);
INSERT INTO `wp_term_relationships` VALUES (1410,18,0);
INSERT INTO `wp_term_relationships` VALUES (1410,20,0);
INSERT INTO `wp_term_relationships` VALUES (1410,25,0);
INSERT INTO `wp_term_relationships` VALUES (1413,18,0);
INSERT INTO `wp_term_relationships` VALUES (1413,21,0);
/*!40000 ALTER TABLE `wp_term_relationships` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_wp_phpmyadmin_extension__errors_log`
--

DROP TABLE IF EXISTS `wp_wp_phpmyadmin_extension__errors_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_wp_phpmyadmin_extension__errors_log` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `gmdate` datetime DEFAULT NULL,
  `function_name` longtext NOT NULL,
  `function_args` longtext NOT NULL,
  `message` longtext NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_wp_phpmyadmin_extension__errors_log`
--

LOCK TABLES `wp_wp_phpmyadmin_extension__errors_log` WRITE;
/*!40000 ALTER TABLE `wp_wp_phpmyadmin_extension__errors_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp_wp_phpmyadmin_extension__errors_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_commentmeta`
--

DROP TABLE IF EXISTS `wp_commentmeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_commentmeta`
--

LOCK TABLES `wp_commentmeta` WRITE;
/*!40000 ALTER TABLE `wp_commentmeta` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp_commentmeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_snippets`
--

DROP TABLE IF EXISTS `wp_snippets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_snippets` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` tinytext NOT NULL,
  `description` text NOT NULL,
  `code` longtext NOT NULL,
  `tags` longtext NOT NULL,
  `scope` varchar(15) NOT NULL DEFAULT 'global',
  `priority` smallint(6) NOT NULL DEFAULT 10,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `scope` (`scope`),
  KEY `active` (`active`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_snippets`
--

LOCK TABLES `wp_snippets` WRITE;
/*!40000 ALTER TABLE `wp_snippets` DISABLE KEYS */;
INSERT INTO `wp_snippets` VALUES (1,'Make upload filenames lowercase','Makes sure that image and file uploads have lowercase filenames.\n\nThis is a sample snippet. Feel free to use it, edit it, or remove it.','add_filter( \'sanitize_file_name\', \'mb_strtolower\' );','sample, media','global',10,0,'2023-03-27 10:06:09');
INSERT INTO `wp_snippets` VALUES (2,'Disable admin bar','Turns off the WordPress admin bar for everyone except administrators.\n\nThis is a sample snippet. Feel free to use it, edit it, or remove it.','add_action( \'wp\', function () {\n	if ( ! current_user_can( \'manage_options\' ) ) {\n		show_admin_bar( false );\n	}\n} );','sample, admin-bar','front-end',10,0,'2023-03-27 10:06:09');
INSERT INTO `wp_snippets` VALUES (3,'Allow smilies','Allows smiley conversion in obscure places.\n\nThis is a sample snippet. Feel free to use it, edit it, or remove it.','add_filter( \'widget_text\', \'convert_smilies\' );\nadd_filter( \'the_title\', \'convert_smilies\' );\nadd_filter( \'wp_title\', \'convert_smilies\' );\nadd_filter( \'get_bloginfo\', \'convert_smilies\' );','sample','global',10,0,'2023-03-27 10:06:09');
INSERT INTO `wp_snippets` VALUES (4,'Current year','Shortcode for inserting the current year into a post or page..\n\nThis is a sample snippet. Feel free to use it, edit it, or remove it.','<?php echo date( \'Y\' ); ?>','sample, dates','content',10,0,'2023-03-27 10:06:09');
INSERT INTO `wp_snippets` VALUES (5,'AI chatbot','','add_action( \'wp_footer\', function () {\r\n  if ( is_user_logged_in() ) {\r\n    echo do_shortcode( "[mwai_chat t context=\'You are ChatGPT, a large language model trained by OpenAI. Answer as concisely as possible. Use markdown.\' ai_name=\'\' user_name=\'\' start_sentence=\'Hei! Jeg er GPT4 og jeg hjelper deg gjerne med det du lurer på.\' text_input_placeholder=\'Skriv her...\' icon_text=\'Hei! Jeg heter GPT4 og slår gjerne av en prat.\' text_input_maxlength=\'1024\' text_compliance=\'Dette er en test av GPT4. Den er smart, men bruker mer tid på å svare. Husk at en AI kan skrive ting som ikke stemmer med virkeligheten, og den gir ikke beskjed om når den gjør det.\' model=\'gpt-4\' max_tokens=\'512\' fullscreen=\'true\' window=\'true\']" );\r\n  }\r\n} );','','front-end',10,0,'2023-04-15 18:28:10');
/*!40000 ALTER TABLE `wp_snippets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_term_taxonomy`
--

DROP TABLE IF EXISTS `wp_term_taxonomy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_term_taxonomy`
--

LOCK TABLES `wp_term_taxonomy` WRITE;
/*!40000 ALTER TABLE `wp_term_taxonomy` DISABLE KEYS */;
INSERT INTO `wp_term_taxonomy` VALUES (1,1,'category','',0,0);
INSERT INTO `wp_term_taxonomy` VALUES (2,2,'wp_theme','',0,8);
INSERT INTO `wp_term_taxonomy` VALUES (3,3,'wp_template_part_area','',0,1);
INSERT INTO `wp_term_taxonomy` VALUES (4,4,'wp_template_part_area','',0,1);
INSERT INTO `wp_term_taxonomy` VALUES (5,5,'wp_theme','',0,1);
INSERT INTO `wp_term_taxonomy` VALUES (6,6,'wp_theme','',0,1);
INSERT INTO `wp_term_taxonomy` VALUES (7,7,'wpcode_type','',0,1);
INSERT INTO `wp_term_taxonomy` VALUES (8,8,'wpcode_location','',0,1);
INSERT INTO `wp_term_taxonomy` VALUES (9,9,'wpcode_tags','',0,2);
INSERT INTO `wp_term_taxonomy` VALUES (10,10,'wpcode_tags','',0,1);
INSERT INTO `wp_term_taxonomy` VALUES (11,11,'wpcode_type','',0,1);
INSERT INTO `wp_term_taxonomy` VALUES (12,12,'wpcode_location','',0,1);
INSERT INTO `wp_term_taxonomy` VALUES (13,13,'wpcode_tags','',0,1);
INSERT INTO `wp_term_taxonomy` VALUES (14,14,'wpcode_tags','',0,1);
INSERT INTO `wp_term_taxonomy` VALUES (15,15,'wpcode_type','',0,1);
INSERT INTO `wp_term_taxonomy` VALUES (16,16,'wpcode_location','',0,2);
INSERT INTO `wp_term_taxonomy` VALUES (17,17,'wpcode_type','',0,1);
INSERT INTO `wp_term_taxonomy` VALUES (18,18,'category','',0,37);
INSERT INTO `wp_term_taxonomy` VALUES (19,19,'category','',0,6);
INSERT INTO `wp_term_taxonomy` VALUES (20,20,'category','',0,24);
INSERT INTO `wp_term_taxonomy` VALUES (21,21,'category','',0,18);
INSERT INTO `wp_term_taxonomy` VALUES (22,22,'category','',0,0);
INSERT INTO `wp_term_taxonomy` VALUES (23,23,'category','',0,8);
INSERT INTO `wp_term_taxonomy` VALUES (24,24,'category','',0,0);
INSERT INTO `wp_term_taxonomy` VALUES (25,25,'category','',0,24);
INSERT INTO `wp_term_taxonomy` VALUES (26,26,'category','',0,6);
INSERT INTO `wp_term_taxonomy` VALUES (27,27,'category','',0,15);
/*!40000 ALTER TABLE `wp_term_taxonomy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_termmeta`
--

DROP TABLE IF EXISTS `wp_termmeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_termmeta`
--

LOCK TABLES `wp_termmeta` WRITE;
/*!40000 ALTER TABLE `wp_termmeta` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp_termmeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_terms`
--

DROP TABLE IF EXISTS `wp_terms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_terms`
--

LOCK TABLES `wp_terms` WRITE;
/*!40000 ALTER TABLE `wp_terms` DISABLE KEYS */;
INSERT INTO `wp_terms` VALUES (1,'Ukategorisert','ukategorisert',0);
INSERT INTO `wp_terms` VALUES (2,'twentytwentythree','twentytwentythree',0);
INSERT INTO `wp_terms` VALUES (3,'footer','footer',0);
INSERT INTO `wp_terms` VALUES (4,'header','header',0);
INSERT INTO `wp_terms` VALUES (5,'uniblock','uniblock',0);
INSERT INTO `wp_terms` VALUES (6,'wabi','wabi',0);
INSERT INTO `wp_terms` VALUES (7,'text','text',0);
INSERT INTO `wp_terms` VALUES (8,'after_paragraph','after_paragraph',0);
INSERT INTO `wp_terms` VALUES (9,'sample','sample',0);
INSERT INTO `wp_terms` VALUES (10,'message','message',0);
INSERT INTO `wp_terms` VALUES (11,'php','php',0);
INSERT INTO `wp_terms` VALUES (12,'everywhere','everywhere',0);
INSERT INTO `wp_terms` VALUES (13,'disable','disable',0);
INSERT INTO `wp_terms` VALUES (14,'comments','comments',0);
INSERT INTO `wp_terms` VALUES (15,'js','js',0);
INSERT INTO `wp_terms` VALUES (16,'site_wide_header','site_wide_header',0);
INSERT INTO `wp_terms` VALUES (17,'html','html',0);
INSERT INTO `wp_terms` VALUES (18,'Elever','elever',0);
INSERT INTO `wp_terms` VALUES (19,'Lærere','laerere',0);
INSERT INTO `wp_terms` VALUES (20,'Praterobot','praterobot',0);
INSERT INTO `wp_terms` VALUES (21,'Skjema','skjema',0);
INSERT INTO `wp_terms` VALUES (22,'Bare for gøy','bare-for-goy',0);
INSERT INTO `wp_terms` VALUES (23,'Informasjon','informasjon',0);
INSERT INTO `wp_terms` VALUES (24,'Ikke publisert','ikke-publisert',0);
INSERT INTO `wp_terms` VALUES (25,'Bot med oppdrag','bot-med-oppdrag',0);
INSERT INTO `wp_terms` VALUES (26,'Samlinger','samlinger',0);
INSERT INTO `wp_terms` VALUES (27,'Forsterket opplæring i norsk','forsterket-opplaering-i-norsk',0);
/*!40000 ALTER TABLE `wp_terms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_usermeta`
--

DROP TABLE IF EXISTS `wp_usermeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1410 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_usermeta`
--

LOCK TABLES `wp_usermeta` WRITE;
/*!40000 ALTER TABLE `wp_usermeta` DISABLE KEYS */;
INSERT INTO `wp_usermeta` VALUES (1360,80,'nickname','admin');
INSERT INTO `wp_usermeta` VALUES (1361,80,'first_name','Admin');
INSERT INTO `wp_usermeta` VALUES (1362,80,'last_name','Admin');
INSERT INTO `wp_usermeta` VALUES (1363,80,'description','');
INSERT INTO `wp_usermeta` VALUES (1364,80,'rich_editing','true');
INSERT INTO `wp_usermeta` VALUES (1365,80,'syntax_highlighting','true');
INSERT INTO `wp_usermeta` VALUES (1366,80,'comment_shortcuts','false');
INSERT INTO `wp_usermeta` VALUES (1367,80,'admin_color','fresh');
INSERT INTO `wp_usermeta` VALUES (1368,80,'use_ssl','0');
INSERT INTO `wp_usermeta` VALUES (1369,80,'show_admin_bar_front','true');
INSERT INTO `wp_usermeta` VALUES (1370,80,'locale','');
INSERT INTO `wp_usermeta` VALUES (1371,80,'wp_capabilities','a:1:{s:13:"administrator";b:1;}');
INSERT INTO `wp_usermeta` VALUES (1372,80,'wp_user_level','10');
INSERT INTO `wp_usermeta` VALUES (1373,80,'dismissed_wp_pointers','');
INSERT INTO `wp_usermeta` VALUES (1375,80,'wp_dashboard_quick_press_last_post_id','1404');
INSERT INTO `wp_usermeta` VALUES (1376,80,'community-events-location','a:1:{s:2:"ip";s:13:"193.160.149.0";}');
INSERT INTO `wp_usermeta` VALUES (1377,80,'wp_persisted_preferences','a:4:{s:14:"core/edit-post";a:1:{s:12:"welcomeGuide";b:0;}s:9:"_modified";s:24:"2025-11-12T07:06:47.675Z";s:14:"core/edit-site";a:1:{s:12:"welcomeGuide";b:0;}s:4:"core";a:5:{s:10:"editorMode";s:6:"visual";s:12:"fixedToolbar";b:0;s:9:"focusMode";b:0;s:10:"openPanels";a:4:{i:0;s:11:"post-status";i:1;s:14:"featured-image";i:2;s:12:"post-excerpt";i:3;s:23:"taxonomy-panel-category";}s:26:"isComplementaryAreaVisible";b:1;}}');
INSERT INTO `wp_usermeta` VALUES (1378,80,'wp_user-settings','libraryContent=browse');
INSERT INTO `wp_usermeta` VALUES (1379,80,'wp_user-settings-time','1699533539');
INSERT INTO `wp_usermeta` VALUES (1381,80,'session_tokens','a:1:{s:64:"503ad48cd60739ab1d034669c8923c4eb028e07f55ddeba2706b9a3749090bee";a:4:{s:10:"expiration";i:1763102697;s:2:"ip";s:14:"193.160.149.33";s:2:"ua";s:111:"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36";s:5:"login";i:1762929897;}}');
INSERT INTO `wp_usermeta` VALUES (1382,81,'nickname','Employee');
INSERT INTO `wp_usermeta` VALUES (1383,81,'first_name','Ansatt');
INSERT INTO `wp_usermeta` VALUES (1384,81,'last_name','');
INSERT INTO `wp_usermeta` VALUES (1385,81,'description','');
INSERT INTO `wp_usermeta` VALUES (1386,81,'rich_editing','true');
INSERT INTO `wp_usermeta` VALUES (1387,81,'syntax_highlighting','true');
INSERT INTO `wp_usermeta` VALUES (1388,81,'comment_shortcuts','false');
INSERT INTO `wp_usermeta` VALUES (1389,81,'admin_color','fresh');
INSERT INTO `wp_usermeta` VALUES (1390,81,'use_ssl','0');
INSERT INTO `wp_usermeta` VALUES (1391,81,'show_admin_bar_front','true');
INSERT INTO `wp_usermeta` VALUES (1392,81,'locale','');
INSERT INTO `wp_usermeta` VALUES (1393,81,'wp_capabilities','a:1:{s:11:"contributor";b:1;}');
INSERT INTO `wp_usermeta` VALUES (1394,81,'wp_user_level','1');
INSERT INTO `wp_usermeta` VALUES (1395,81,'dismissed_wp_pointers','');
INSERT INTO `wp_usermeta` VALUES (1396,82,'nickname','Student');
INSERT INTO `wp_usermeta` VALUES (1397,82,'first_name','Elev');
INSERT INTO `wp_usermeta` VALUES (1398,82,'last_name','');
INSERT INTO `wp_usermeta` VALUES (1399,82,'description','');
INSERT INTO `wp_usermeta` VALUES (1400,82,'rich_editing','true');
INSERT INTO `wp_usermeta` VALUES (1401,82,'syntax_highlighting','true');
INSERT INTO `wp_usermeta` VALUES (1402,82,'comment_shortcuts','false');
INSERT INTO `wp_usermeta` VALUES (1403,82,'admin_color','fresh');
INSERT INTO `wp_usermeta` VALUES (1404,82,'use_ssl','0');
INSERT INTO `wp_usermeta` VALUES (1405,82,'show_admin_bar_front','true');
INSERT INTO `wp_usermeta` VALUES (1406,82,'locale','');
INSERT INTO `wp_usermeta` VALUES (1407,82,'wp_capabilities','a:1:{s:10:"subscriber";b:1;}');
INSERT INTO `wp_usermeta` VALUES (1408,82,'wp_user_level','0');
INSERT INTO `wp_usermeta` VALUES (1409,82,'dismissed_wp_pointers','');
/*!40000 ALTER TABLE `wp_usermeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_users`
--

DROP TABLE IF EXISTS `wp_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=83 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_users`
--

LOCK TABLES `wp_users` WRITE;
/*!40000 ALTER TABLE `wp_users` DISABLE KEYS */;
INSERT INTO `wp_users` VALUES (80,'admin','$wp$2y$10$iGaXT/RT16n4KwYC57O0qeczg6.TqD03RQfBbhX9TXU4MuaM2LnEO','admin','admin@admin.admin','','2023-09-24 11:07:12','',0,'Admin Admin');
INSERT INTO `wp_users` VALUES (81,'Employee','$P$BeYUP5E1jx3LW/rz/OborbA3h0I0ns1','employee','employee@virkerikke.epost','','2024-03-29 15:30:43','1711726243:$P$Bgyblo4tYPVN6w.fBsqmdQffLtDrop0',0,'Ansatt');
INSERT INTO `wp_users` VALUES (82,'Student','$P$B2yWY/KWFn5hOi/Oby50madpFyBMKU.','student','student@virkerikke.epost','','2024-03-29 15:31:27','1711726287:$P$Bv/doY4L.TwQAp.EEY9ob58MuB3h/f.',0,'Elev');
/*!40000 ALTER TABLE `wp_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_mclean_refs`
--

DROP TABLE IF EXISTS `wp_mclean_refs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_mclean_refs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `mediaId` bigint(20) DEFAULT NULL,
  `mediaUrl` tinytext DEFAULT NULL,
  `originType` tinytext NOT NULL,
  `parentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=290 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_mclean_refs`
--

LOCK TABLES `wp_mclean_refs` WRITE;
/*!40000 ALTER TABLE `wp_mclean_refs` DISABLE KEYS */;
INSERT INTO `wp_mclean_refs` VALUES (1,1037,NULL,'THEME',NULL);
INSERT INTO `wp_mclean_refs` VALUES (2,NULL,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1.png','THEME',NULL);
INSERT INTO `wp_mclean_refs` VALUES (3,298,NULL,'POST META (ID) [554]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (4,NULL,'2023/04/Mitt-prosjekt-1.png','FEATURED IMAGE (URL) {SAFE} [554]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (5,NULL,'2023/04/Mitt-prosjekt-1-150x150.png','FEATURED IMAGE (URL) {SAFE} [554]',4);
INSERT INTO `wp_mclean_refs` VALUES (6,NULL,'2023/04/Mitt-prosjekt-1-300x300.png','FEATURED IMAGE (URL) {SAFE} [554]',4);
INSERT INTO `wp_mclean_refs` VALUES (7,NULL,'2023/04/Mitt-prosjekt-1-768x768.png','FEATURED IMAGE (URL) {SAFE} [554]',4);
INSERT INTO `wp_mclean_refs` VALUES (8,1060,NULL,'POST META (ID) [1058]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (9,NULL,'2022/11/MyOnlyEye_an_icon_of_a_treasure_chest_style_pixar_1eb7d463-3c47-4398-9640-41aa4e54bc21.jpg','FEATURED IMAGE (URL) {SAFE} [1058]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (10,1241,NULL,'POST META (ID) [891]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (11,NULL,'2025/03/myonlyeye_a_happy_experienced_female_and_male_teacher_pixar_a_7d57adaa-e69e-4405-96d4-bae9ac6ae816_3.jpg','FEATURED IMAGE (URL) {SAFE} [891]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (12,1253,NULL,'POST META (ID) [968]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (13,NULL,'2025/03/MyOnlyEye_behind_the_curtains_pixar_style_e38be4a1-346e-46a9-b376-bd4f0be78708-e1684924115381.jpg','FEATURED IMAGE (URL) {SAFE} [968]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (14,1259,NULL,'POST META (ID) [983]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (15,NULL,'2025/03/laerer02.jpg','FEATURED IMAGE (URL) {SAFE} [983]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (16,NULL,'2022/11/MyOnlyEye_an_icon_of_a_treasure_chest_style_pixar_1eb7d463-3c47-4398-9640-41aa4e54bc21-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1058]',9);
INSERT INTO `wp_mclean_refs` VALUES (17,NULL,'2022/11/MyOnlyEye_an_icon_of_a_treasure_chest_style_pixar_1eb7d463-3c47-4398-9640-41aa4e54bc21-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1058]',9);
INSERT INTO `wp_mclean_refs` VALUES (18,NULL,'2022/11/MyOnlyEye_an_icon_of_a_treasure_chest_style_pixar_1eb7d463-3c47-4398-9640-41aa4e54bc21-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1058]',9);
INSERT INTO `wp_mclean_refs` VALUES (19,NULL,'2025/03/myonlyeye_a_happy_experienced_female_and_male_teacher_pixar_a_7d57adaa-e69e-4405-96d4-bae9ac6ae816_3-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [891]',11);
INSERT INTO `wp_mclean_refs` VALUES (20,NULL,'2025/03/myonlyeye_a_happy_experienced_female_and_male_teacher_pixar_a_7d57adaa-e69e-4405-96d4-bae9ac6ae816_3-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [891]',11);
INSERT INTO `wp_mclean_refs` VALUES (21,NULL,'2025/03/myonlyeye_a_happy_experienced_female_and_male_teacher_pixar_a_7d57adaa-e69e-4405-96d4-bae9ac6ae816_3-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [891]',11);
INSERT INTO `wp_mclean_refs` VALUES (22,NULL,'2025/03/MyOnlyEye_behind_the_curtains_pixar_style_e38be4a1-346e-46a9-b376-bd4f0be78708-e1684924115381-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [968]',13);
INSERT INTO `wp_mclean_refs` VALUES (23,NULL,'2025/03/MyOnlyEye_behind_the_curtains_pixar_style_e38be4a1-346e-46a9-b376-bd4f0be78708-e1684924115381-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [968]',13);
INSERT INTO `wp_mclean_refs` VALUES (24,NULL,'2025/03/MyOnlyEye_behind_the_curtains_pixar_style_e38be4a1-346e-46a9-b376-bd4f0be78708-e1684924115381-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [968]',13);
INSERT INTO `wp_mclean_refs` VALUES (25,NULL,'2025/03/laerer02-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [983]',15);
INSERT INTO `wp_mclean_refs` VALUES (26,NULL,'2025/03/laerer02-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [983]',15);
INSERT INTO `wp_mclean_refs` VALUES (27,NULL,'2025/03/laerer02-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [983]',15);
INSERT INTO `wp_mclean_refs` VALUES (28,1261,NULL,'POST META (ID) [981]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (29,NULL,'2025/03/elevbrukerpc.jpg','FEATURED IMAGE (URL) {SAFE} [981]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (30,1260,NULL,'POST META (ID) [974]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (31,NULL,'2025/03/manual.jpg','FEATURED IMAGE (URL) {SAFE} [974]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (32,1027,NULL,'POST META (ID) [972]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (33,NULL,'2023/09/myonlyeye_a_dragon_style_of_Don_Bluth_flat_animation_Disneys_Fa_4726194e-3717-4a56-adce-33c7ff7ee0e6.jpg','FEATURED IMAGE (URL) {SAFE} [972]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (34,536,NULL,'POST META (ID) [979]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (35,NULL,'2023/04/MyOnlyEye_a_glass_ball_of_words_pixar_style_48ba36fd-5c63-4416-b4ea-1a41e8efbe14.jpg','FEATURED IMAGE (URL) {SAFE} [979]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (36,1258,NULL,'POST META (ID) [966]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (37,NULL,'2025/03/mangemennesker.jpg','FEATURED IMAGE (URL) {SAFE} [966]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (38,NULL,'2025/03/elevbrukerpc-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [981]',29);
INSERT INTO `wp_mclean_refs` VALUES (39,NULL,'2025/03/elevbrukerpc-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [981]',29);
INSERT INTO `wp_mclean_refs` VALUES (40,NULL,'2025/03/elevbrukerpc-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [981]',29);
INSERT INTO `wp_mclean_refs` VALUES (41,NULL,'2025/03/manual-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [974]',31);
INSERT INTO `wp_mclean_refs` VALUES (42,NULL,'2025/03/manual-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [974]',31);
INSERT INTO `wp_mclean_refs` VALUES (43,NULL,'2025/03/manual-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [974]',31);
INSERT INTO `wp_mclean_refs` VALUES (44,NULL,'2023/09/myonlyeye_a_dragon_style_of_Don_Bluth_flat_animation_Disneys_Fa_4726194e-3717-4a56-adce-33c7ff7ee0e6-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [972]',33);
INSERT INTO `wp_mclean_refs` VALUES (45,NULL,'2023/09/myonlyeye_a_dragon_style_of_Don_Bluth_flat_animation_Disneys_Fa_4726194e-3717-4a56-adce-33c7ff7ee0e6-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [972]',33);
INSERT INTO `wp_mclean_refs` VALUES (46,NULL,'2023/09/myonlyeye_a_dragon_style_of_Don_Bluth_flat_animation_Disneys_Fa_4726194e-3717-4a56-adce-33c7ff7ee0e6-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [972]',33);
INSERT INTO `wp_mclean_refs` VALUES (47,NULL,'2023/04/MyOnlyEye_a_glass_ball_of_words_pixar_style_48ba36fd-5c63-4416-b4ea-1a41e8efbe14-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [979]',35);
INSERT INTO `wp_mclean_refs` VALUES (48,NULL,'2023/04/MyOnlyEye_a_glass_ball_of_words_pixar_style_48ba36fd-5c63-4416-b4ea-1a41e8efbe14-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [979]',35);
INSERT INTO `wp_mclean_refs` VALUES (49,NULL,'2023/04/MyOnlyEye_a_glass_ball_of_words_pixar_style_48ba36fd-5c63-4416-b4ea-1a41e8efbe14-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [979]',35);
INSERT INTO `wp_mclean_refs` VALUES (50,NULL,'2025/03/mangemennesker-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [966]',37);
INSERT INTO `wp_mclean_refs` VALUES (51,NULL,'2025/03/mangemennesker-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [966]',37);
INSERT INTO `wp_mclean_refs` VALUES (52,NULL,'2025/03/mangemennesker-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [966]',37);
INSERT INTO `wp_mclean_refs` VALUES (53,1293,NULL,'POST META (ID) [1222]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (54,NULL,'2025/03/myonlyeye_a_theater_stage_dreamy_metaphysical_-v_6.1_0f4692ab-8bef-4198-b02e-2befe068bfec_2-1.png','FEATURED IMAGE (URL) {SAFE} [1222]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (55,1292,NULL,'POST META (ID) [1294]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (56,NULL,'2025/03/myonlyeye_a_casual_happy_helpful_teacher_assistant_writing_st_724bc28a-5b5e-43d1-9783-35618fa1f920_0-1-1.jpg','FEATURED IMAGE (URL) {SAFE} [1294]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (57,1289,NULL,'POST META (ID) [1296]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (58,NULL,'2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_2-1.jpg','FEATURED IMAGE (URL) {SAFE} [1296]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (59,1290,NULL,'POST META (ID) [1299]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (60,NULL,'2025/03/myonlyeye_an_open_chest_filled_with_famous_persons_view_from__7782a14e-35ee-4fdd-ba38-a2d5d9d49366_2-1.jpg','FEATURED IMAGE (URL) {SAFE} [1299]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (61,1291,NULL,'POST META (ID) [1302]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (62,NULL,'2025/03/myonlyeye_an_open_chest_filled_with_different_appliances_view_29e51ea2-91c6-4c93-80f6-8fcdc64b55a6_1-1.jpg','FEATURED IMAGE (URL) {SAFE} [1302]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (63,NULL,'2025/03/myonlyeye_a_theater_stage_dreamy_metaphysical_-v_6.1_0f4692ab-8bef-4198-b02e-2befe068bfec_2-1-150x150.png','FEATURED IMAGE (URL) {SAFE} [1222]',54);
INSERT INTO `wp_mclean_refs` VALUES (64,NULL,'2025/03/myonlyeye_a_theater_stage_dreamy_metaphysical_-v_6.1_0f4692ab-8bef-4198-b02e-2befe068bfec_2-1-300x300.png','FEATURED IMAGE (URL) {SAFE} [1222]',54);
INSERT INTO `wp_mclean_refs` VALUES (65,NULL,'2025/03/myonlyeye_a_theater_stage_dreamy_metaphysical_-v_6.1_0f4692ab-8bef-4198-b02e-2befe068bfec_2-1-768x768.png','FEATURED IMAGE (URL) {SAFE} [1222]',54);
INSERT INTO `wp_mclean_refs` VALUES (66,NULL,'2025/03/myonlyeye_a_casual_happy_helpful_teacher_assistant_writing_st_724bc28a-5b5e-43d1-9783-35618fa1f920_0-1-1-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1294]',56);
INSERT INTO `wp_mclean_refs` VALUES (67,NULL,'2025/03/myonlyeye_a_casual_happy_helpful_teacher_assistant_writing_st_724bc28a-5b5e-43d1-9783-35618fa1f920_0-1-1-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1294]',56);
INSERT INTO `wp_mclean_refs` VALUES (68,NULL,'2025/03/myonlyeye_a_casual_happy_helpful_teacher_assistant_writing_st_724bc28a-5b5e-43d1-9783-35618fa1f920_0-1-1-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1294]',56);
INSERT INTO `wp_mclean_refs` VALUES (69,NULL,'2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_2-1-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1296]',58);
INSERT INTO `wp_mclean_refs` VALUES (70,NULL,'2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_2-1-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1296]',58);
INSERT INTO `wp_mclean_refs` VALUES (71,NULL,'2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_2-1-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1296]',58);
INSERT INTO `wp_mclean_refs` VALUES (72,NULL,'2025/03/myonlyeye_an_open_chest_filled_with_famous_persons_view_from__7782a14e-35ee-4fdd-ba38-a2d5d9d49366_2-1-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1299]',60);
INSERT INTO `wp_mclean_refs` VALUES (73,NULL,'2025/03/myonlyeye_an_open_chest_filled_with_famous_persons_view_from__7782a14e-35ee-4fdd-ba38-a2d5d9d49366_2-1-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1299]',60);
INSERT INTO `wp_mclean_refs` VALUES (74,NULL,'2025/03/myonlyeye_an_open_chest_filled_with_famous_persons_view_from__7782a14e-35ee-4fdd-ba38-a2d5d9d49366_2-1-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1299]',60);
INSERT INTO `wp_mclean_refs` VALUES (75,NULL,'2025/03/myonlyeye_an_open_chest_filled_with_different_appliances_view_29e51ea2-91c6-4c93-80f6-8fcdc64b55a6_1-1-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1302]',62);
INSERT INTO `wp_mclean_refs` VALUES (76,NULL,'2025/03/myonlyeye_an_open_chest_filled_with_different_appliances_view_29e51ea2-91c6-4c93-80f6-8fcdc64b55a6_1-1-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1302]',62);
INSERT INTO `wp_mclean_refs` VALUES (77,NULL,'2025/03/myonlyeye_an_open_chest_filled_with_different_appliances_view_29e51ea2-91c6-4c93-80f6-8fcdc64b55a6_1-1-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1302]',62);
INSERT INTO `wp_mclean_refs` VALUES (78,1288,NULL,'POST META (ID) [1306]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (79,NULL,'2025/03/myonlyeye_a_student_having_a_good_dialog_with_a_robot_happy_p_000e19eb-ab9b-4281-9529-b4d55035c27c_1-1.jpg','FEATURED IMAGE (URL) {SAFE} [1306]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (80,1287,NULL,'POST META (ID) [1308]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (81,NULL,'2025/03/myonlyeye_a_robot_correcting_a_text_style_Pixar_-v_6.1_cf9ea90a-ec47-4eed-a25c-76767f91f262_0-1.jpg','FEATURED IMAGE (URL) {SAFE} [1308]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (82,1286,NULL,'POST META (ID) [1311]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (83,NULL,'2025/03/exuberant_sparrow_76988_A_short_square_humanoid_robot_with_shor_c7763960-86cc-4974-9168-fd575cea354f-1.jpg','FEATURED IMAGE (URL) {SAFE} [1311]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (84,1285,NULL,'POST META (ID) [1313]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (85,NULL,'2025/03/myonlyeye_A_whimsical_text-generating_machine_in_Pixar_animat_362a1a95-c5b2-4cdf-a339-7936e8c8587f_3-1.jpg','FEATURED IMAGE (URL) {SAFE} [1313]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (86,1284,NULL,'POST META (ID) [1315]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (87,NULL,'2025/03/myonlyeye_norwegian_words_-v_6.1_78a13bac-8f8f-4c1f-92c6-6736744334cc_0-1.jpg','FEATURED IMAGE (URL) {SAFE} [1315]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (88,NULL,'2025/03/myonlyeye_a_student_having_a_good_dialog_with_a_robot_happy_p_000e19eb-ab9b-4281-9529-b4d55035c27c_1-1-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1306]',79);
INSERT INTO `wp_mclean_refs` VALUES (89,NULL,'2025/03/myonlyeye_a_student_having_a_good_dialog_with_a_robot_happy_p_000e19eb-ab9b-4281-9529-b4d55035c27c_1-1-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1306]',79);
INSERT INTO `wp_mclean_refs` VALUES (90,NULL,'2025/03/myonlyeye_a_student_having_a_good_dialog_with_a_robot_happy_p_000e19eb-ab9b-4281-9529-b4d55035c27c_1-1-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1306]',79);
INSERT INTO `wp_mclean_refs` VALUES (91,NULL,'2025/03/myonlyeye_a_robot_correcting_a_text_style_Pixar_-v_6.1_cf9ea90a-ec47-4eed-a25c-76767f91f262_0-1-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1308]',81);
INSERT INTO `wp_mclean_refs` VALUES (92,NULL,'2025/03/myonlyeye_a_robot_correcting_a_text_style_Pixar_-v_6.1_cf9ea90a-ec47-4eed-a25c-76767f91f262_0-1-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1308]',81);
INSERT INTO `wp_mclean_refs` VALUES (93,NULL,'2025/03/myonlyeye_a_robot_correcting_a_text_style_Pixar_-v_6.1_cf9ea90a-ec47-4eed-a25c-76767f91f262_0-1-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1308]',81);
INSERT INTO `wp_mclean_refs` VALUES (94,NULL,'2025/03/exuberant_sparrow_76988_A_short_square_humanoid_robot_with_shor_c7763960-86cc-4974-9168-fd575cea354f-1-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1311]',83);
INSERT INTO `wp_mclean_refs` VALUES (95,NULL,'2025/03/exuberant_sparrow_76988_A_short_square_humanoid_robot_with_shor_c7763960-86cc-4974-9168-fd575cea354f-1-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1311]',83);
INSERT INTO `wp_mclean_refs` VALUES (96,NULL,'2025/03/exuberant_sparrow_76988_A_short_square_humanoid_robot_with_shor_c7763960-86cc-4974-9168-fd575cea354f-1-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1311]',83);
INSERT INTO `wp_mclean_refs` VALUES (97,NULL,'2025/03/myonlyeye_A_whimsical_text-generating_machine_in_Pixar_animat_362a1a95-c5b2-4cdf-a339-7936e8c8587f_3-1-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1313]',85);
INSERT INTO `wp_mclean_refs` VALUES (98,NULL,'2025/03/myonlyeye_A_whimsical_text-generating_machine_in_Pixar_animat_362a1a95-c5b2-4cdf-a339-7936e8c8587f_3-1-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1313]',85);
INSERT INTO `wp_mclean_refs` VALUES (99,NULL,'2025/03/myonlyeye_A_whimsical_text-generating_machine_in_Pixar_animat_362a1a95-c5b2-4cdf-a339-7936e8c8587f_3-1-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1313]',85);
INSERT INTO `wp_mclean_refs` VALUES (100,NULL,'2025/03/myonlyeye_norwegian_words_-v_6.1_78a13bac-8f8f-4c1f-92c6-6736744334cc_0-1-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1315]',87);
INSERT INTO `wp_mclean_refs` VALUES (101,NULL,'2025/03/myonlyeye_norwegian_words_-v_6.1_78a13bac-8f8f-4c1f-92c6-6736744334cc_0-1-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1315]',87);
INSERT INTO `wp_mclean_refs` VALUES (102,NULL,'2025/03/myonlyeye_norwegian_words_-v_6.1_78a13bac-8f8f-4c1f-92c6-6736744334cc_0-1-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1315]',87);
INSERT INTO `wp_mclean_refs` VALUES (103,1283,NULL,'POST META (ID) [1317]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (104,NULL,'2025/03/myonlyeye_Dictionary_page_on_the_term_Ordliste_style_pixar_-_88317278-38ce-487f-bc3b-4d3427a309b0_2-1.jpg','FEATURED IMAGE (URL) {SAFE} [1317]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (105,1282,NULL,'POST META (ID) [1319]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (106,NULL,'2025/03/kinetica___A_cute_Viking_with_a_surprised_expression_in_a_tradi_0c54d4e4-9dfe-4a2c-b8c3-3d392c288d13-1.jpg','FEATURED IMAGE (URL) {SAFE} [1319]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (107,1280,NULL,'POST META (ID) [1321]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (108,NULL,'2025/03/myonlyeye_a_machine_the_prints_out_papers_with_questiongs_sty_294f241f-3f39-45b3-92d6-c8c4e52b5fcb_1-1.jpg','FEATURED IMAGE (URL) {SAFE} [1321]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (109,1281,NULL,'POST META (ID) [1323]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (110,NULL,'2025/03/pripovedac9665_a_young_standup_comedian_on_stage_bowing_toward__c3cf7bbf-fcde-467e-8333-e6643d5ed9f5-1.jpg','FEATURED IMAGE (URL) {SAFE} [1323]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (111,1278,NULL,'POST META (ID) [1325]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (112,NULL,'2025/03/myonlyeye_two_people_talking_casual_happy_style_pixar_-v_6.1_1f845975-1ab6-4ac2-a26d-95379fc478e7_3-1.jpg','FEATURED IMAGE (URL) {SAFE} [1325]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (113,NULL,'2025/03/myonlyeye_Dictionary_page_on_the_term_Ordliste_style_pixar_-_88317278-38ce-487f-bc3b-4d3427a309b0_2-1-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1317]',104);
INSERT INTO `wp_mclean_refs` VALUES (114,NULL,'2025/03/myonlyeye_Dictionary_page_on_the_term_Ordliste_style_pixar_-_88317278-38ce-487f-bc3b-4d3427a309b0_2-1-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1317]',104);
INSERT INTO `wp_mclean_refs` VALUES (115,NULL,'2025/03/myonlyeye_Dictionary_page_on_the_term_Ordliste_style_pixar_-_88317278-38ce-487f-bc3b-4d3427a309b0_2-1-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1317]',104);
INSERT INTO `wp_mclean_refs` VALUES (116,NULL,'2025/03/kinetica___A_cute_Viking_with_a_surprised_expression_in_a_tradi_0c54d4e4-9dfe-4a2c-b8c3-3d392c288d13-1-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1319]',106);
INSERT INTO `wp_mclean_refs` VALUES (117,NULL,'2025/03/kinetica___A_cute_Viking_with_a_surprised_expression_in_a_tradi_0c54d4e4-9dfe-4a2c-b8c3-3d392c288d13-1-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1319]',106);
INSERT INTO `wp_mclean_refs` VALUES (118,NULL,'2025/03/kinetica___A_cute_Viking_with_a_surprised_expression_in_a_tradi_0c54d4e4-9dfe-4a2c-b8c3-3d392c288d13-1-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1319]',106);
INSERT INTO `wp_mclean_refs` VALUES (119,NULL,'2025/03/myonlyeye_a_machine_the_prints_out_papers_with_questiongs_sty_294f241f-3f39-45b3-92d6-c8c4e52b5fcb_1-1-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1321]',108);
INSERT INTO `wp_mclean_refs` VALUES (120,NULL,'2025/03/myonlyeye_a_machine_the_prints_out_papers_with_questiongs_sty_294f241f-3f39-45b3-92d6-c8c4e52b5fcb_1-1-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1321]',108);
INSERT INTO `wp_mclean_refs` VALUES (121,NULL,'2025/03/myonlyeye_a_machine_the_prints_out_papers_with_questiongs_sty_294f241f-3f39-45b3-92d6-c8c4e52b5fcb_1-1-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1321]',108);
INSERT INTO `wp_mclean_refs` VALUES (122,NULL,'2025/03/pripovedac9665_a_young_standup_comedian_on_stage_bowing_toward__c3cf7bbf-fcde-467e-8333-e6643d5ed9f5-1-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1323]',110);
INSERT INTO `wp_mclean_refs` VALUES (123,NULL,'2025/03/pripovedac9665_a_young_standup_comedian_on_stage_bowing_toward__c3cf7bbf-fcde-467e-8333-e6643d5ed9f5-1-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1323]',110);
INSERT INTO `wp_mclean_refs` VALUES (124,NULL,'2025/03/pripovedac9665_a_young_standup_comedian_on_stage_bowing_toward__c3cf7bbf-fcde-467e-8333-e6643d5ed9f5-1-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1323]',110);
INSERT INTO `wp_mclean_refs` VALUES (125,NULL,'2025/03/myonlyeye_two_people_talking_casual_happy_style_pixar_-v_6.1_1f845975-1ab6-4ac2-a26d-95379fc478e7_3-1-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1325]',112);
INSERT INTO `wp_mclean_refs` VALUES (126,NULL,'2025/03/myonlyeye_two_people_talking_casual_happy_style_pixar_-v_6.1_1f845975-1ab6-4ac2-a26d-95379fc478e7_3-1-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1325]',112);
INSERT INTO `wp_mclean_refs` VALUES (127,NULL,'2025/03/myonlyeye_two_people_talking_casual_happy_style_pixar_-v_6.1_1f845975-1ab6-4ac2-a26d-95379fc478e7_3-1-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1325]',112);
INSERT INTO `wp_mclean_refs` VALUES (128,1277,NULL,'POST META (ID) [1327]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (129,NULL,'2025/03/myonlyeye_Ingrid_Johansen_a_norwegian_teenager_in_shirt_and_s_353c58e0-1d1e-4f8e-83d6-1706d95d4e01_0.jpg','FEATURED IMAGE (URL) {SAFE} [1327]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (130,1276,NULL,'POST META (ID) [1329]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (131,NULL,'2025/03/sameflagg-1m-e1737368906687.jpg','FEATURED IMAGE (URL) {SAFE} [1329]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (132,1275,NULL,'POST META (ID) [1331]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (133,NULL,'2025/03/myonlyeye_man_of_science_pixar_style_-v_6.1_4d004b6d-6797-4e05-b378-b05725fd5771_1.jpg','FEATURED IMAGE (URL) {SAFE} [1331]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (134,1272,NULL,'POST META (ID) [1333]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (135,NULL,'2025/03/image-1.jpg','FEATURED IMAGE (URL) {SAFE} [1333]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (136,1271,NULL,'POST META (ID) [1335]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (137,NULL,'2025/03/2023-12-14_22-40-45_3828.jpg','FEATURED IMAGE (URL) {SAFE} [1335]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (138,1265,NULL,'CONTENT (ID) [1335]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (139,NULL,'2023/12/yrker.png','CONTENT (URL) [1335]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (140,NULL,'2025/03/myonlyeye_Ingrid_Johansen_a_norwegian_teenager_in_shirt_and_s_353c58e0-1d1e-4f8e-83d6-1706d95d4e01_0-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1327]',129);
INSERT INTO `wp_mclean_refs` VALUES (141,NULL,'2025/03/myonlyeye_Ingrid_Johansen_a_norwegian_teenager_in_shirt_and_s_353c58e0-1d1e-4f8e-83d6-1706d95d4e01_0-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1327]',129);
INSERT INTO `wp_mclean_refs` VALUES (142,NULL,'2025/03/myonlyeye_Ingrid_Johansen_a_norwegian_teenager_in_shirt_and_s_353c58e0-1d1e-4f8e-83d6-1706d95d4e01_0-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1327]',129);
INSERT INTO `wp_mclean_refs` VALUES (143,NULL,'2025/03/sameflagg-1m-e1737368906687-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1329]',131);
INSERT INTO `wp_mclean_refs` VALUES (144,NULL,'2025/03/sameflagg-1m-e1737368906687-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1329]',131);
INSERT INTO `wp_mclean_refs` VALUES (145,NULL,'2025/03/myonlyeye_man_of_science_pixar_style_-v_6.1_4d004b6d-6797-4e05-b378-b05725fd5771_1-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1331]',133);
INSERT INTO `wp_mclean_refs` VALUES (146,NULL,'2025/03/myonlyeye_man_of_science_pixar_style_-v_6.1_4d004b6d-6797-4e05-b378-b05725fd5771_1-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1331]',133);
INSERT INTO `wp_mclean_refs` VALUES (147,NULL,'2025/03/myonlyeye_man_of_science_pixar_style_-v_6.1_4d004b6d-6797-4e05-b378-b05725fd5771_1-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1331]',133);
INSERT INTO `wp_mclean_refs` VALUES (148,NULL,'2025/03/image-1-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1333]',135);
INSERT INTO `wp_mclean_refs` VALUES (149,NULL,'2025/03/image-1-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1333]',135);
INSERT INTO `wp_mclean_refs` VALUES (150,NULL,'2025/03/image-1-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1333]',135);
INSERT INTO `wp_mclean_refs` VALUES (151,NULL,'2025/03/2023-12-14_22-40-45_3828-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1335]',137);
INSERT INTO `wp_mclean_refs` VALUES (152,NULL,'2025/03/2023-12-14_22-40-45_3828-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1335]',137);
INSERT INTO `wp_mclean_refs` VALUES (153,NULL,'2025/03/2023-12-14_22-40-45_3828-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1335]',137);
INSERT INTO `wp_mclean_refs` VALUES (154,NULL,'2023/12/yrker-1024x385.png','CONTENT (URL) [1335]',139);
INSERT INTO `wp_mclean_refs` VALUES (155,1227,NULL,'POST META (ID) [1337]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (156,NULL,'2025/03/MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985.jpg','FEATURED IMAGE (URL) {SAFE} [1337]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (157,1274,NULL,'POST META (ID) [1339]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (158,NULL,'2025/03/image-3-1.jpg','FEATURED IMAGE (URL) {SAFE} [1339]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (159,1273,NULL,'POST META (ID) [1341]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (160,NULL,'2025/03/image-1-1.jpg','FEATURED IMAGE (URL) {SAFE} [1341]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (161,1267,NULL,'POST META (ID) [1343]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (162,NULL,'2025/03/myonlyeye_creative_writer_sitting_by_a_desk_lot_on_notes_on_t_cd76d529-31ac-4d3f-8d06-c378484bcb3a_1.jpg','FEATURED IMAGE (URL) {SAFE} [1343]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (163,1264,NULL,'POST META (ID) [1345]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (164,NULL,'2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_3.jpg','FEATURED IMAGE (URL) {SAFE} [1345]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (165,NULL,'2025/03/MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1337]',156);
INSERT INTO `wp_mclean_refs` VALUES (166,NULL,'2025/03/MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1337]',156);
INSERT INTO `wp_mclean_refs` VALUES (167,NULL,'2025/03/MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1337]',156);
INSERT INTO `wp_mclean_refs` VALUES (168,NULL,'2025/03/image-3-1-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1339]',158);
INSERT INTO `wp_mclean_refs` VALUES (169,NULL,'2025/03/image-3-1-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1339]',158);
INSERT INTO `wp_mclean_refs` VALUES (170,NULL,'2025/03/image-3-1-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1339]',158);
INSERT INTO `wp_mclean_refs` VALUES (171,NULL,'2025/03/image-1-1-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1341]',160);
INSERT INTO `wp_mclean_refs` VALUES (172,NULL,'2025/03/image-1-1-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1341]',160);
INSERT INTO `wp_mclean_refs` VALUES (173,NULL,'2025/03/image-1-1-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1341]',160);
INSERT INTO `wp_mclean_refs` VALUES (174,NULL,'2025/03/myonlyeye_creative_writer_sitting_by_a_desk_lot_on_notes_on_t_cd76d529-31ac-4d3f-8d06-c378484bcb3a_1-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1343]',162);
INSERT INTO `wp_mclean_refs` VALUES (175,NULL,'2025/03/myonlyeye_creative_writer_sitting_by_a_desk_lot_on_notes_on_t_cd76d529-31ac-4d3f-8d06-c378484bcb3a_1-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1343]',162);
INSERT INTO `wp_mclean_refs` VALUES (176,NULL,'2025/03/myonlyeye_creative_writer_sitting_by_a_desk_lot_on_notes_on_t_cd76d529-31ac-4d3f-8d06-c378484bcb3a_1-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1343]',162);
INSERT INTO `wp_mclean_refs` VALUES (177,NULL,'2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_3-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1345]',164);
INSERT INTO `wp_mclean_refs` VALUES (178,NULL,'2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_3-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1345]',164);
INSERT INTO `wp_mclean_refs` VALUES (179,NULL,'2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_3-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1345]',164);
INSERT INTO `wp_mclean_refs` VALUES (180,1266,NULL,'POST META (ID) [1348]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (181,NULL,'2025/03/myonlyeye_religion_and_ethics_symbol_-v_6.1_66ee8d7e-2291-4473-b9b5-4ff9d97eba13_2.jpg','FEATURED IMAGE (URL) {SAFE} [1348]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (182,1265,NULL,'POST META (ID) [1350]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (183,NULL,'2025/03/myonlyeye_stortinget_norway_pixar_animation_style_-cref_http_0e5844bb-95cb-4762-9e16-30cd489d2c1b_0.jpg','FEATURED IMAGE (URL) {SAFE} [1350]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (184,1263,NULL,'POST META (ID) [1352]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (185,NULL,'2025/03/myonlyeye_stone_age_man_inside_ice_style_pixar_-v_6.1_fe0b64dd-deec-4886-95ee-dd81ba573e4d_0.jpg','FEATURED IMAGE (URL) {SAFE} [1352]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (186,1251,NULL,'POST META (ID) [1357]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (187,NULL,'2025/03/myonlyeye_casual_happy_socrates_style_pixar_-turbo_a2b9f20b-43c0-46b0-92f1-1acf4a0cd9d9_1.jpg','FEATURED IMAGE (URL) {SAFE} [1357]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (188,1243,NULL,'POST META (ID) [1359]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (189,NULL,'2025/03/myonlyeye_happy_kid_pixar_animation_style_neutral_background_1679c7b1-4755-4b3e-b017-38e24bfb4de7_1.jpg','FEATURED IMAGE (URL) {SAFE} [1359]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (190,NULL,'2025/03/myonlyeye_religion_and_ethics_symbol_-v_6.1_66ee8d7e-2291-4473-b9b5-4ff9d97eba13_2-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1348]',181);
INSERT INTO `wp_mclean_refs` VALUES (191,NULL,'2025/03/myonlyeye_religion_and_ethics_symbol_-v_6.1_66ee8d7e-2291-4473-b9b5-4ff9d97eba13_2-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1348]',181);
INSERT INTO `wp_mclean_refs` VALUES (192,NULL,'2025/03/myonlyeye_religion_and_ethics_symbol_-v_6.1_66ee8d7e-2291-4473-b9b5-4ff9d97eba13_2-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1348]',181);
INSERT INTO `wp_mclean_refs` VALUES (193,NULL,'2025/03/myonlyeye_stortinget_norway_pixar_animation_style_-cref_http_0e5844bb-95cb-4762-9e16-30cd489d2c1b_0-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1350]',183);
INSERT INTO `wp_mclean_refs` VALUES (194,NULL,'2025/03/myonlyeye_stortinget_norway_pixar_animation_style_-cref_http_0e5844bb-95cb-4762-9e16-30cd489d2c1b_0-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1350]',183);
INSERT INTO `wp_mclean_refs` VALUES (195,NULL,'2025/03/myonlyeye_stortinget_norway_pixar_animation_style_-cref_http_0e5844bb-95cb-4762-9e16-30cd489d2c1b_0-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1350]',183);
INSERT INTO `wp_mclean_refs` VALUES (196,NULL,'2025/03/myonlyeye_stone_age_man_inside_ice_style_pixar_-v_6.1_fe0b64dd-deec-4886-95ee-dd81ba573e4d_0-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1352]',185);
INSERT INTO `wp_mclean_refs` VALUES (197,NULL,'2025/03/myonlyeye_stone_age_man_inside_ice_style_pixar_-v_6.1_fe0b64dd-deec-4886-95ee-dd81ba573e4d_0-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1352]',185);
INSERT INTO `wp_mclean_refs` VALUES (198,NULL,'2025/03/myonlyeye_stone_age_man_inside_ice_style_pixar_-v_6.1_fe0b64dd-deec-4886-95ee-dd81ba573e4d_0-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1352]',185);
INSERT INTO `wp_mclean_refs` VALUES (199,NULL,'2025/03/myonlyeye_casual_happy_socrates_style_pixar_-turbo_a2b9f20b-43c0-46b0-92f1-1acf4a0cd9d9_1-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1357]',187);
INSERT INTO `wp_mclean_refs` VALUES (200,NULL,'2025/03/myonlyeye_casual_happy_socrates_style_pixar_-turbo_a2b9f20b-43c0-46b0-92f1-1acf4a0cd9d9_1-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1357]',187);
INSERT INTO `wp_mclean_refs` VALUES (201,NULL,'2025/03/myonlyeye_casual_happy_socrates_style_pixar_-turbo_a2b9f20b-43c0-46b0-92f1-1acf4a0cd9d9_1-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1357]',187);
INSERT INTO `wp_mclean_refs` VALUES (202,NULL,'2025/03/myonlyeye_happy_kid_pixar_animation_style_neutral_background_1679c7b1-4755-4b3e-b017-38e24bfb4de7_1-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1359]',189);
INSERT INTO `wp_mclean_refs` VALUES (203,NULL,'2025/03/myonlyeye_happy_kid_pixar_animation_style_neutral_background_1679c7b1-4755-4b3e-b017-38e24bfb4de7_1-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1359]',189);
INSERT INTO `wp_mclean_refs` VALUES (204,NULL,'2025/03/myonlyeye_happy_kid_pixar_animation_style_neutral_background_1679c7b1-4755-4b3e-b017-38e24bfb4de7_1-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1359]',189);
INSERT INTO `wp_mclean_refs` VALUES (205,1245,NULL,'POST META (ID) [1361]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (206,NULL,'2025/03/myonlyeye_a_writing_workshop_three_people_pixar_animation_sty_67fc1acd-b10d-4607-956c-efedfa493d9d_0.jpg','FEATURED IMAGE (URL) {SAFE} [1361]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (207,1224,NULL,'POST META (ID) [1363]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (208,NULL,'2025/03/MyOnlyEye_in_icon_of_a_writing_club_style_pixar_da9c18e9-bae4-4bfe-b16d-96f22e391593.jpg','FEATURED IMAGE (URL) {SAFE} [1363]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (209,1247,NULL,'POST META (ID) [1365]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (210,NULL,'2025/03/myonlyeye_an_AI_helping_a_teacher_write_an_assignment_pixar_a_97c80671-d888-4059-a907-8467f477d1cc_0.jpg','FEATURED IMAGE (URL) {SAFE} [1365]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (211,1167,NULL,'POST META (ID) [1367]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (212,NULL,'2023/09/diskusjonen.png','FEATURED IMAGE (URL) {SAFE} [1367]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (213,1250,NULL,'POST META (ID) [1369]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (214,NULL,'2025/03/microbit.jpg','FEATURED IMAGE (URL) {SAFE} [1369]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (215,NULL,'2025/03/myonlyeye_a_writing_workshop_three_people_pixar_animation_sty_67fc1acd-b10d-4607-956c-efedfa493d9d_0-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1361]',206);
INSERT INTO `wp_mclean_refs` VALUES (216,NULL,'2025/03/myonlyeye_a_writing_workshop_three_people_pixar_animation_sty_67fc1acd-b10d-4607-956c-efedfa493d9d_0-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1361]',206);
INSERT INTO `wp_mclean_refs` VALUES (217,NULL,'2025/03/myonlyeye_a_writing_workshop_three_people_pixar_animation_sty_67fc1acd-b10d-4607-956c-efedfa493d9d_0-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1361]',206);
INSERT INTO `wp_mclean_refs` VALUES (218,NULL,'2025/03/MyOnlyEye_in_icon_of_a_writing_club_style_pixar_da9c18e9-bae4-4bfe-b16d-96f22e391593-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1363]',208);
INSERT INTO `wp_mclean_refs` VALUES (219,NULL,'2025/03/MyOnlyEye_in_icon_of_a_writing_club_style_pixar_da9c18e9-bae4-4bfe-b16d-96f22e391593-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1363]',208);
INSERT INTO `wp_mclean_refs` VALUES (220,NULL,'2025/03/MyOnlyEye_in_icon_of_a_writing_club_style_pixar_da9c18e9-bae4-4bfe-b16d-96f22e391593-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1363]',208);
INSERT INTO `wp_mclean_refs` VALUES (221,NULL,'2025/03/myonlyeye_an_AI_helping_a_teacher_write_an_assignment_pixar_a_97c80671-d888-4059-a907-8467f477d1cc_0-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1365]',210);
INSERT INTO `wp_mclean_refs` VALUES (222,NULL,'2025/03/myonlyeye_an_AI_helping_a_teacher_write_an_assignment_pixar_a_97c80671-d888-4059-a907-8467f477d1cc_0-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1365]',210);
INSERT INTO `wp_mclean_refs` VALUES (223,NULL,'2025/03/myonlyeye_an_AI_helping_a_teacher_write_an_assignment_pixar_a_97c80671-d888-4059-a907-8467f477d1cc_0-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1365]',210);
INSERT INTO `wp_mclean_refs` VALUES (224,NULL,'2023/09/diskusjonen-150x150.png','FEATURED IMAGE (URL) {SAFE} [1367]',212);
INSERT INTO `wp_mclean_refs` VALUES (225,NULL,'2023/09/diskusjonen-300x300.png','FEATURED IMAGE (URL) {SAFE} [1367]',212);
INSERT INTO `wp_mclean_refs` VALUES (226,NULL,'2023/09/diskusjonen-768x768.png','FEATURED IMAGE (URL) {SAFE} [1367]',212);
INSERT INTO `wp_mclean_refs` VALUES (227,NULL,'2025/03/microbit-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1369]',214);
INSERT INTO `wp_mclean_refs` VALUES (228,NULL,'2025/03/microbit-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1369]',214);
INSERT INTO `wp_mclean_refs` VALUES (229,NULL,'2025/03/microbit-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1369]',214);
INSERT INTO `wp_mclean_refs` VALUES (230,1252,NULL,'POST META (ID) [1371]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (231,NULL,'2025/03/myonlyeye_a_kind_teacher_pixar_style_neutral_background_-sty_49c0b56f-82cf-4492-99e5-f7117314b7ff_0.jpg','FEATURED IMAGE (URL) {SAFE} [1371]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (232,1255,NULL,'POST META (ID) [1373]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (233,NULL,'2025/03/myonlyeye_a_happy_pixar_character_writing_in_a_book_one_colou_71cb9c48-55ae-40fa-85d3-34c21218ede9_0.jpg','FEATURED IMAGE (URL) {SAFE} [1373]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (234,1249,NULL,'POST META (ID) [1375]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (235,NULL,'2025/03/myonlyeye_a_very_polite_writer_pixar_style_white_background_2e9f7252-0cb8-47ae-aa4d-80289454d2b3.jpg','FEATURED IMAGE (URL) {SAFE} [1375]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (236,1227,NULL,'POST META (ID) [1377]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (237,NULL,'2025/03/MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985.jpg','FEATURED IMAGE (URL) {SAFE} [1377]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (238,1248,NULL,'POST META (ID) [1379]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (239,NULL,'2025/03/myonlyeye_a_polite_butler_carrying_a_scroll_pixar_style_white_b_de12e82c-1869-452f-b2a7-b012d7103c7a.jpg','FEATURED IMAGE (URL) {SAFE} [1379]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (240,NULL,'2025/03/myonlyeye_a_kind_teacher_pixar_style_neutral_background_-sty_49c0b56f-82cf-4492-99e5-f7117314b7ff_0-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1371]',231);
INSERT INTO `wp_mclean_refs` VALUES (241,NULL,'2025/03/myonlyeye_a_kind_teacher_pixar_style_neutral_background_-sty_49c0b56f-82cf-4492-99e5-f7117314b7ff_0-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1371]',231);
INSERT INTO `wp_mclean_refs` VALUES (242,NULL,'2025/03/myonlyeye_a_kind_teacher_pixar_style_neutral_background_-sty_49c0b56f-82cf-4492-99e5-f7117314b7ff_0-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1371]',231);
INSERT INTO `wp_mclean_refs` VALUES (243,NULL,'2025/03/myonlyeye_a_happy_pixar_character_writing_in_a_book_one_colou_71cb9c48-55ae-40fa-85d3-34c21218ede9_0-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1373]',233);
INSERT INTO `wp_mclean_refs` VALUES (244,NULL,'2025/03/myonlyeye_a_happy_pixar_character_writing_in_a_book_one_colou_71cb9c48-55ae-40fa-85d3-34c21218ede9_0-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1373]',233);
INSERT INTO `wp_mclean_refs` VALUES (245,NULL,'2025/03/myonlyeye_a_happy_pixar_character_writing_in_a_book_one_colou_71cb9c48-55ae-40fa-85d3-34c21218ede9_0-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1373]',233);
INSERT INTO `wp_mclean_refs` VALUES (246,NULL,'2025/03/myonlyeye_a_very_polite_writer_pixar_style_white_background_2e9f7252-0cb8-47ae-aa4d-80289454d2b3-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1375]',235);
INSERT INTO `wp_mclean_refs` VALUES (247,NULL,'2025/03/myonlyeye_a_very_polite_writer_pixar_style_white_background_2e9f7252-0cb8-47ae-aa4d-80289454d2b3-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1375]',235);
INSERT INTO `wp_mclean_refs` VALUES (248,NULL,'2025/03/myonlyeye_a_very_polite_writer_pixar_style_white_background_2e9f7252-0cb8-47ae-aa4d-80289454d2b3-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1375]',235);
INSERT INTO `wp_mclean_refs` VALUES (249,NULL,'2025/03/MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1377]',156);
INSERT INTO `wp_mclean_refs` VALUES (250,NULL,'2025/03/MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1377]',156);
INSERT INTO `wp_mclean_refs` VALUES (251,NULL,'2025/03/MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1377]',156);
INSERT INTO `wp_mclean_refs` VALUES (252,NULL,'2025/03/myonlyeye_a_polite_butler_carrying_a_scroll_pixar_style_white_b_de12e82c-1869-452f-b2a7-b012d7103c7a-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1379]',239);
INSERT INTO `wp_mclean_refs` VALUES (253,NULL,'2025/03/myonlyeye_a_polite_butler_carrying_a_scroll_pixar_style_white_b_de12e82c-1869-452f-b2a7-b012d7103c7a-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1379]',239);
INSERT INTO `wp_mclean_refs` VALUES (254,NULL,'2025/03/myonlyeye_a_polite_butler_carrying_a_scroll_pixar_style_white_b_de12e82c-1869-452f-b2a7-b012d7103c7a-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1379]',239);
INSERT INTO `wp_mclean_refs` VALUES (255,1237,NULL,'POST META (ID) [1381]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (256,NULL,'2025/03/myonlyeye_depressed_robot_with_a_huge_head_in_the_animation_s_64eb410b-44c9-4f11-bd93-f078a40b16f2_3.jpg','FEATURED IMAGE (URL) {SAFE} [1381]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (257,1226,NULL,'POST META (ID) [1383]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (258,NULL,'2025/03/MyOnlyEye_an_icon_of_a_female_egg_causal_happy_pixar_style_36387029-e099-4b05-8927-eeb82fb21249.jpg','FEATURED IMAGE (URL) {SAFE} [1383]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (259,1264,NULL,'POST META (ID) [1387]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (260,NULL,'2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_3.jpg','FEATURED IMAGE (URL) {SAFE} [1387]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (261,1290,NULL,'POST META (ID) [1390]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (262,NULL,'2025/03/myonlyeye_an_open_chest_filled_with_famous_persons_view_from__7782a14e-35ee-4fdd-ba38-a2d5d9d49366_2-1.jpg','FEATURED IMAGE (URL) {SAFE} [1390]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (263,NULL,'2025/03/myonlyeye_depressed_robot_with_a_huge_head_in_the_animation_s_64eb410b-44c9-4f11-bd93-f078a40b16f2_3-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1381]',256);
INSERT INTO `wp_mclean_refs` VALUES (264,NULL,'2025/03/myonlyeye_depressed_robot_with_a_huge_head_in_the_animation_s_64eb410b-44c9-4f11-bd93-f078a40b16f2_3-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1381]',256);
INSERT INTO `wp_mclean_refs` VALUES (265,NULL,'2025/03/myonlyeye_depressed_robot_with_a_huge_head_in_the_animation_s_64eb410b-44c9-4f11-bd93-f078a40b16f2_3-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1381]',256);
INSERT INTO `wp_mclean_refs` VALUES (266,NULL,'2025/03/MyOnlyEye_an_icon_of_a_female_egg_causal_happy_pixar_style_36387029-e099-4b05-8927-eeb82fb21249-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1383]',258);
INSERT INTO `wp_mclean_refs` VALUES (267,NULL,'2025/03/MyOnlyEye_an_icon_of_a_female_egg_causal_happy_pixar_style_36387029-e099-4b05-8927-eeb82fb21249-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1383]',258);
INSERT INTO `wp_mclean_refs` VALUES (268,NULL,'2025/03/MyOnlyEye_an_icon_of_a_female_egg_causal_happy_pixar_style_36387029-e099-4b05-8927-eeb82fb21249-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1383]',258);
INSERT INTO `wp_mclean_refs` VALUES (269,NULL,'2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_3-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1387]',164);
INSERT INTO `wp_mclean_refs` VALUES (270,NULL,'2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_3-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1387]',164);
INSERT INTO `wp_mclean_refs` VALUES (271,NULL,'2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_3-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1387]',164);
INSERT INTO `wp_mclean_refs` VALUES (272,NULL,'2025/03/myonlyeye_an_open_chest_filled_with_famous_persons_view_from__7782a14e-35ee-4fdd-ba38-a2d5d9d49366_2-1-150x150.jpg','FEATURED IMAGE (URL) {SAFE} [1390]',60);
INSERT INTO `wp_mclean_refs` VALUES (273,NULL,'2025/03/myonlyeye_an_open_chest_filled_with_famous_persons_view_from__7782a14e-35ee-4fdd-ba38-a2d5d9d49366_2-1-300x300.jpg','FEATURED IMAGE (URL) {SAFE} [1390]',60);
INSERT INTO `wp_mclean_refs` VALUES (274,NULL,'2025/03/myonlyeye_an_open_chest_filled_with_famous_persons_view_from__7782a14e-35ee-4fdd-ba38-a2d5d9d49366_2-1-768x768.jpg','FEATURED IMAGE (URL) {SAFE} [1390]',60);
INSERT INTO `wp_mclean_refs` VALUES (275,1030,NULL,'CONTENT (ID) [19]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (276,1037,NULL,'CONTENT (ID) [19]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (277,NULL,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe.jpg','CONTENT (URL) [19]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (278,NULL,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1.png','CONTENT (URL) [19]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (279,NULL,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe-300x168.jpg','CONTENT (URL) [19]',277);
INSERT INTO `wp_mclean_refs` VALUES (280,NULL,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe-1024x574.jpg','CONTENT (URL) [19]',277);
INSERT INTO `wp_mclean_refs` VALUES (281,NULL,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe-768x430.jpg','CONTENT (URL) [19]',277);
INSERT INTO `wp_mclean_refs` VALUES (282,NULL,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-300x300.png','CONTENT (URL) [19]',2);
INSERT INTO `wp_mclean_refs` VALUES (283,NULL,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-150x150.png','CONTENT (URL) [19]',2);
INSERT INTO `wp_mclean_refs` VALUES (284,NULL,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-768x768.png','CONTENT (URL) [19]',2);
INSERT INTO `wp_mclean_refs` VALUES (285,517,NULL,'CONTENT (ID) [7]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (286,NULL,'2023/04/by-nc-sa.png','CONTENT (URL) [7]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (287,682,NULL,'CONTENT (ID) [20]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (288,NULL,'2023/06/by-nc-sa.png','CONTENT (URL) [20]',NULL);
INSERT INTO `wp_mclean_refs` VALUES (289,NULL,'2023/04/by-nc-sa-300x105.png','CONTENT (URL) [7]',286);
/*!40000 ALTER TABLE `wp_mclean_refs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_mwai_tasks`
--

DROP TABLE IF EXISTS `wp_mwai_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_mwai_tasks` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `task_name` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `category` varchar(32) NOT NULL DEFAULT 'general',
  `schedule` varchar(128) NOT NULL,
  `status` varchar(16) NOT NULL DEFAULT 'pending',
  `next_run` datetime DEFAULT NULL,
  `last_run` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `step` int(11) NOT NULL DEFAULT 0,
  `step_name` varchar(64) DEFAULT NULL,
  `step_data` longtext DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  `meta` longtext DEFAULT NULL,
  `error_count` int(11) NOT NULL DEFAULT 0,
  `max_retries` int(11) NOT NULL DEFAULT 3,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `task_name` (`task_name`),
  KEY `status_next` (`status`,`next_run`),
  KEY `category` (`category`),
  KEY `expires` (`expires_at`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_mwai_tasks`
--

LOCK TABLES `wp_mwai_tasks` WRITE;
/*!40000 ALTER TABLE `wp_mwai_tasks` DISABLE KEYS */;
INSERT INTO `wp_mwai_tasks` VALUES (1,'cleanup_discussions','Remove old discussions beyond retention period.','system','0 3 * * *','pending','2025-11-13 03:00:00',NULL,NULL,0,NULL,NULL,'[]','[]',0,3,'2025-11-12 06:51:22','2025-11-12 07:07:44');
INSERT INTO `wp_mwai_tasks` VALUES (2,'cleanup_files','Delete expired files based on expiration dates.','system','0 4 * * *','pending','2025-11-13 04:00:00',NULL,NULL,0,NULL,NULL,'[]','[]',0,3,'2025-11-12 06:51:22','2025-11-12 07:07:44');
INSERT INTO `wp_mwai_tasks` VALUES (3,'cleanup_tasks','Clean old task logs and failed tasks.','system','0 13 * * *','pending','2025-11-12 13:00:00',NULL,NULL,0,NULL,NULL,'[]','[]',0,3,'2025-11-12 06:51:22','2025-11-12 07:07:44');
/*!40000 ALTER TABLE `wp_mwai_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_wpvivid_scan_result`
--

DROP TABLE IF EXISTS `wp_wpvivid_scan_result`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_wpvivid_scan_result` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `from_post` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=301 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_wpvivid_scan_result`
--

LOCK TABLES `wp_wpvivid_scan_result` WRITE;
/*!40000 ALTER TABLE `wp_wpvivid_scan_result` DISABLE KEYS */;
INSERT INTO `wp_wpvivid_scan_result` VALUES (1,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1.png',0);
INSERT INTO `wp_wpvivid_scan_result` VALUES (2,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-300x300.png',0);
INSERT INTO `wp_wpvivid_scan_result` VALUES (3,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-150x150.png',0);
INSERT INTO `wp_wpvivid_scan_result` VALUES (4,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-768x768.png',0);
INSERT INTO `wp_wpvivid_scan_result` VALUES (5,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1.png',0);
INSERT INTO `wp_wpvivid_scan_result` VALUES (6,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-300x300.png',0);
INSERT INTO `wp_wpvivid_scan_result` VALUES (7,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-150x150.png',0);
INSERT INTO `wp_wpvivid_scan_result` VALUES (8,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-768x768.png',0);
INSERT INTO `wp_wpvivid_scan_result` VALUES (9,'2023/04/Mitt-prosjekt-1-300x300.png',554);
INSERT INTO `wp_wpvivid_scan_result` VALUES (10,'2023/04/Mitt-prosjekt-1-150x150.png',554);
INSERT INTO `wp_wpvivid_scan_result` VALUES (11,'2023/04/Mitt-prosjekt-1-768x768.png',554);
INSERT INTO `wp_wpvivid_scan_result` VALUES (12,'2023/04/Mitt-prosjekt-1.png',554);
INSERT INTO `wp_wpvivid_scan_result` VALUES (13,'2022/11/MyOnlyEye_an_icon_of_a_treasure_chest_style_pixar_1eb7d463-3c47-4398-9640-41aa4e54bc21-300x300.jpg',1058);
INSERT INTO `wp_wpvivid_scan_result` VALUES (14,'2022/11/MyOnlyEye_an_icon_of_a_treasure_chest_style_pixar_1eb7d463-3c47-4398-9640-41aa4e54bc21-150x150.jpg',1058);
INSERT INTO `wp_wpvivid_scan_result` VALUES (15,'2022/11/MyOnlyEye_an_icon_of_a_treasure_chest_style_pixar_1eb7d463-3c47-4398-9640-41aa4e54bc21-768x768.jpg',1058);
INSERT INTO `wp_wpvivid_scan_result` VALUES (16,'2022/11/MyOnlyEye_an_icon_of_a_treasure_chest_style_pixar_1eb7d463-3c47-4398-9640-41aa4e54bc21.jpg',1058);
INSERT INTO `wp_wpvivid_scan_result` VALUES (17,'2025/03/myonlyeye_a_happy_experienced_female_and_male_teacher_pixar_a_7d57adaa-e69e-4405-96d4-bae9ac6ae816_3-300x300.jpg',891);
INSERT INTO `wp_wpvivid_scan_result` VALUES (18,'2025/03/myonlyeye_a_happy_experienced_female_and_male_teacher_pixar_a_7d57adaa-e69e-4405-96d4-bae9ac6ae816_3-150x150.jpg',891);
INSERT INTO `wp_wpvivid_scan_result` VALUES (19,'2025/03/myonlyeye_a_happy_experienced_female_and_male_teacher_pixar_a_7d57adaa-e69e-4405-96d4-bae9ac6ae816_3-768x768.jpg',891);
INSERT INTO `wp_wpvivid_scan_result` VALUES (20,'2025/03/myonlyeye_a_happy_experienced_female_and_male_teacher_pixar_a_7d57adaa-e69e-4405-96d4-bae9ac6ae816_3.jpg',891);
INSERT INTO `wp_wpvivid_scan_result` VALUES (21,'2025/03/MyOnlyEye_behind_the_curtains_pixar_style_e38be4a1-346e-46a9-b376-bd4f0be78708-e1684924115381-300x300.jpg',968);
INSERT INTO `wp_wpvivid_scan_result` VALUES (22,'2025/03/MyOnlyEye_behind_the_curtains_pixar_style_e38be4a1-346e-46a9-b376-bd4f0be78708-e1684924115381-150x150.jpg',968);
INSERT INTO `wp_wpvivid_scan_result` VALUES (23,'2025/03/MyOnlyEye_behind_the_curtains_pixar_style_e38be4a1-346e-46a9-b376-bd4f0be78708-e1684924115381-768x768.jpg',968);
INSERT INTO `wp_wpvivid_scan_result` VALUES (24,'2025/03/MyOnlyEye_behind_the_curtains_pixar_style_e38be4a1-346e-46a9-b376-bd4f0be78708-e1684924115381.jpg',968);
INSERT INTO `wp_wpvivid_scan_result` VALUES (25,'2025/03/laerer02-300x300.jpg',983);
INSERT INTO `wp_wpvivid_scan_result` VALUES (26,'2025/03/laerer02-150x150.jpg',983);
INSERT INTO `wp_wpvivid_scan_result` VALUES (27,'2025/03/laerer02-768x768.jpg',983);
INSERT INTO `wp_wpvivid_scan_result` VALUES (28,'2025/03/laerer02.jpg',983);
INSERT INTO `wp_wpvivid_scan_result` VALUES (29,'2025/03/elevbrukerpc-300x300.jpg',981);
INSERT INTO `wp_wpvivid_scan_result` VALUES (30,'2025/03/elevbrukerpc-150x150.jpg',981);
INSERT INTO `wp_wpvivid_scan_result` VALUES (31,'2025/03/elevbrukerpc-768x768.jpg',981);
INSERT INTO `wp_wpvivid_scan_result` VALUES (32,'2025/03/elevbrukerpc.jpg',981);
INSERT INTO `wp_wpvivid_scan_result` VALUES (33,'2025/03/manual-300x300.jpg',974);
INSERT INTO `wp_wpvivid_scan_result` VALUES (34,'2025/03/manual-150x150.jpg',974);
INSERT INTO `wp_wpvivid_scan_result` VALUES (35,'2025/03/manual-768x768.jpg',974);
INSERT INTO `wp_wpvivid_scan_result` VALUES (36,'2025/03/manual.jpg',974);
INSERT INTO `wp_wpvivid_scan_result` VALUES (37,'2023/09/myonlyeye_a_dragon_style_of_Don_Bluth_flat_animation_Disneys_Fa_4726194e-3717-4a56-adce-33c7ff7ee0e6-300x300.jpg',972);
INSERT INTO `wp_wpvivid_scan_result` VALUES (38,'2023/09/myonlyeye_a_dragon_style_of_Don_Bluth_flat_animation_Disneys_Fa_4726194e-3717-4a56-adce-33c7ff7ee0e6-150x150.jpg',972);
INSERT INTO `wp_wpvivid_scan_result` VALUES (39,'2023/09/myonlyeye_a_dragon_style_of_Don_Bluth_flat_animation_Disneys_Fa_4726194e-3717-4a56-adce-33c7ff7ee0e6-768x768.jpg',972);
INSERT INTO `wp_wpvivid_scan_result` VALUES (40,'2023/09/myonlyeye_a_dragon_style_of_Don_Bluth_flat_animation_Disneys_Fa_4726194e-3717-4a56-adce-33c7ff7ee0e6.jpg',972);
INSERT INTO `wp_wpvivid_scan_result` VALUES (41,'2023/04/MyOnlyEye_a_glass_ball_of_words_pixar_style_48ba36fd-5c63-4416-b4ea-1a41e8efbe14-300x300.jpg',979);
INSERT INTO `wp_wpvivid_scan_result` VALUES (42,'2023/04/MyOnlyEye_a_glass_ball_of_words_pixar_style_48ba36fd-5c63-4416-b4ea-1a41e8efbe14-150x150.jpg',979);
INSERT INTO `wp_wpvivid_scan_result` VALUES (43,'2023/04/MyOnlyEye_a_glass_ball_of_words_pixar_style_48ba36fd-5c63-4416-b4ea-1a41e8efbe14-768x768.jpg',979);
INSERT INTO `wp_wpvivid_scan_result` VALUES (44,'2023/04/MyOnlyEye_a_glass_ball_of_words_pixar_style_48ba36fd-5c63-4416-b4ea-1a41e8efbe14.jpg',979);
INSERT INTO `wp_wpvivid_scan_result` VALUES (45,'2025/03/mangemennesker-300x300.jpg',966);
INSERT INTO `wp_wpvivid_scan_result` VALUES (46,'2025/03/mangemennesker-150x150.jpg',966);
INSERT INTO `wp_wpvivid_scan_result` VALUES (47,'2025/03/mangemennesker-768x768.jpg',966);
INSERT INTO `wp_wpvivid_scan_result` VALUES (48,'2025/03/mangemennesker.jpg',966);
INSERT INTO `wp_wpvivid_scan_result` VALUES (49,'2025/03/myonlyeye_a_theater_stage_dreamy_metaphysical_-v_6.1_0f4692ab-8bef-4198-b02e-2befe068bfec_2-1-300x300.png',1222);
INSERT INTO `wp_wpvivid_scan_result` VALUES (50,'2025/03/myonlyeye_a_theater_stage_dreamy_metaphysical_-v_6.1_0f4692ab-8bef-4198-b02e-2befe068bfec_2-1-150x150.png',1222);
INSERT INTO `wp_wpvivid_scan_result` VALUES (51,'2025/03/myonlyeye_a_theater_stage_dreamy_metaphysical_-v_6.1_0f4692ab-8bef-4198-b02e-2befe068bfec_2-1-768x768.png',1222);
INSERT INTO `wp_wpvivid_scan_result` VALUES (52,'2025/03/myonlyeye_a_theater_stage_dreamy_metaphysical_-v_6.1_0f4692ab-8bef-4198-b02e-2befe068bfec_2-1.png',1222);
INSERT INTO `wp_wpvivid_scan_result` VALUES (53,'2025/03/myonlyeye_a_casual_happy_helpful_teacher_assistant_writing_st_724bc28a-5b5e-43d1-9783-35618fa1f920_0-1-1-300x300.jpg',1294);
INSERT INTO `wp_wpvivid_scan_result` VALUES (54,'2025/03/myonlyeye_a_casual_happy_helpful_teacher_assistant_writing_st_724bc28a-5b5e-43d1-9783-35618fa1f920_0-1-1-150x150.jpg',1294);
INSERT INTO `wp_wpvivid_scan_result` VALUES (55,'2025/03/myonlyeye_a_casual_happy_helpful_teacher_assistant_writing_st_724bc28a-5b5e-43d1-9783-35618fa1f920_0-1-1-768x768.jpg',1294);
INSERT INTO `wp_wpvivid_scan_result` VALUES (56,'2025/03/myonlyeye_a_casual_happy_helpful_teacher_assistant_writing_st_724bc28a-5b5e-43d1-9783-35618fa1f920_0-1-1.jpg',1294);
INSERT INTO `wp_wpvivid_scan_result` VALUES (57,'2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_2-1-300x300.jpg',1296);
INSERT INTO `wp_wpvivid_scan_result` VALUES (58,'2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_2-1-150x150.jpg',1296);
INSERT INTO `wp_wpvivid_scan_result` VALUES (59,'2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_2-1-768x768.jpg',1296);
INSERT INTO `wp_wpvivid_scan_result` VALUES (60,'2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_2-1.jpg',1296);
INSERT INTO `wp_wpvivid_scan_result` VALUES (61,'2025/03/myonlyeye_an_open_chest_filled_with_famous_persons_view_from__7782a14e-35ee-4fdd-ba38-a2d5d9d49366_2-1-300x300.jpg',1299);
INSERT INTO `wp_wpvivid_scan_result` VALUES (62,'2025/03/myonlyeye_an_open_chest_filled_with_famous_persons_view_from__7782a14e-35ee-4fdd-ba38-a2d5d9d49366_2-1-150x150.jpg',1299);
INSERT INTO `wp_wpvivid_scan_result` VALUES (63,'2025/03/myonlyeye_an_open_chest_filled_with_famous_persons_view_from__7782a14e-35ee-4fdd-ba38-a2d5d9d49366_2-1-768x768.jpg',1299);
INSERT INTO `wp_wpvivid_scan_result` VALUES (64,'2025/03/myonlyeye_an_open_chest_filled_with_famous_persons_view_from__7782a14e-35ee-4fdd-ba38-a2d5d9d49366_2-1.jpg',1299);
INSERT INTO `wp_wpvivid_scan_result` VALUES (65,'2025/03/myonlyeye_an_open_chest_filled_with_different_appliances_view_29e51ea2-91c6-4c93-80f6-8fcdc64b55a6_1-1-300x300.jpg',1302);
INSERT INTO `wp_wpvivid_scan_result` VALUES (66,'2025/03/myonlyeye_an_open_chest_filled_with_different_appliances_view_29e51ea2-91c6-4c93-80f6-8fcdc64b55a6_1-1-150x150.jpg',1302);
INSERT INTO `wp_wpvivid_scan_result` VALUES (67,'2025/03/myonlyeye_an_open_chest_filled_with_different_appliances_view_29e51ea2-91c6-4c93-80f6-8fcdc64b55a6_1-1-768x768.jpg',1302);
INSERT INTO `wp_wpvivid_scan_result` VALUES (68,'2025/03/myonlyeye_an_open_chest_filled_with_different_appliances_view_29e51ea2-91c6-4c93-80f6-8fcdc64b55a6_1-1.jpg',1302);
INSERT INTO `wp_wpvivid_scan_result` VALUES (69,'2025/03/myonlyeye_a_student_having_a_good_dialog_with_a_robot_happy_p_000e19eb-ab9b-4281-9529-b4d55035c27c_1-1-300x300.jpg',1306);
INSERT INTO `wp_wpvivid_scan_result` VALUES (70,'2025/03/myonlyeye_a_student_having_a_good_dialog_with_a_robot_happy_p_000e19eb-ab9b-4281-9529-b4d55035c27c_1-1-150x150.jpg',1306);
INSERT INTO `wp_wpvivid_scan_result` VALUES (71,'2025/03/myonlyeye_a_student_having_a_good_dialog_with_a_robot_happy_p_000e19eb-ab9b-4281-9529-b4d55035c27c_1-1-768x768.jpg',1306);
INSERT INTO `wp_wpvivid_scan_result` VALUES (72,'2025/03/myonlyeye_a_student_having_a_good_dialog_with_a_robot_happy_p_000e19eb-ab9b-4281-9529-b4d55035c27c_1-1.jpg',1306);
INSERT INTO `wp_wpvivid_scan_result` VALUES (73,'2025/03/myonlyeye_a_robot_correcting_a_text_style_Pixar_-v_6.1_cf9ea90a-ec47-4eed-a25c-76767f91f262_0-1-300x300.jpg',1308);
INSERT INTO `wp_wpvivid_scan_result` VALUES (74,'2025/03/myonlyeye_a_robot_correcting_a_text_style_Pixar_-v_6.1_cf9ea90a-ec47-4eed-a25c-76767f91f262_0-1-150x150.jpg',1308);
INSERT INTO `wp_wpvivid_scan_result` VALUES (75,'2025/03/myonlyeye_a_robot_correcting_a_text_style_Pixar_-v_6.1_cf9ea90a-ec47-4eed-a25c-76767f91f262_0-1-768x768.jpg',1308);
INSERT INTO `wp_wpvivid_scan_result` VALUES (76,'2025/03/myonlyeye_a_robot_correcting_a_text_style_Pixar_-v_6.1_cf9ea90a-ec47-4eed-a25c-76767f91f262_0-1.jpg',1308);
INSERT INTO `wp_wpvivid_scan_result` VALUES (77,'2025/03/exuberant_sparrow_76988_A_short_square_humanoid_robot_with_shor_c7763960-86cc-4974-9168-fd575cea354f-1-300x300.jpg',1311);
INSERT INTO `wp_wpvivid_scan_result` VALUES (78,'2025/03/exuberant_sparrow_76988_A_short_square_humanoid_robot_with_shor_c7763960-86cc-4974-9168-fd575cea354f-1-150x150.jpg',1311);
INSERT INTO `wp_wpvivid_scan_result` VALUES (79,'2025/03/exuberant_sparrow_76988_A_short_square_humanoid_robot_with_shor_c7763960-86cc-4974-9168-fd575cea354f-1-768x768.jpg',1311);
INSERT INTO `wp_wpvivid_scan_result` VALUES (80,'2025/03/exuberant_sparrow_76988_A_short_square_humanoid_robot_with_shor_c7763960-86cc-4974-9168-fd575cea354f-1.jpg',1311);
INSERT INTO `wp_wpvivid_scan_result` VALUES (81,'2025/03/myonlyeye_A_whimsical_text-generating_machine_in_Pixar_animat_362a1a95-c5b2-4cdf-a339-7936e8c8587f_3-1-300x300.jpg',1313);
INSERT INTO `wp_wpvivid_scan_result` VALUES (82,'2025/03/myonlyeye_A_whimsical_text-generating_machine_in_Pixar_animat_362a1a95-c5b2-4cdf-a339-7936e8c8587f_3-1-150x150.jpg',1313);
INSERT INTO `wp_wpvivid_scan_result` VALUES (83,'2025/03/myonlyeye_A_whimsical_text-generating_machine_in_Pixar_animat_362a1a95-c5b2-4cdf-a339-7936e8c8587f_3-1-768x768.jpg',1313);
INSERT INTO `wp_wpvivid_scan_result` VALUES (84,'2025/03/myonlyeye_A_whimsical_text-generating_machine_in_Pixar_animat_362a1a95-c5b2-4cdf-a339-7936e8c8587f_3-1.jpg',1313);
INSERT INTO `wp_wpvivid_scan_result` VALUES (85,'2025/03/myonlyeye_norwegian_words_-v_6.1_78a13bac-8f8f-4c1f-92c6-6736744334cc_0-1-300x300.jpg',1315);
INSERT INTO `wp_wpvivid_scan_result` VALUES (86,'2025/03/myonlyeye_norwegian_words_-v_6.1_78a13bac-8f8f-4c1f-92c6-6736744334cc_0-1-150x150.jpg',1315);
INSERT INTO `wp_wpvivid_scan_result` VALUES (87,'2025/03/myonlyeye_norwegian_words_-v_6.1_78a13bac-8f8f-4c1f-92c6-6736744334cc_0-1-768x768.jpg',1315);
INSERT INTO `wp_wpvivid_scan_result` VALUES (88,'2025/03/myonlyeye_norwegian_words_-v_6.1_78a13bac-8f8f-4c1f-92c6-6736744334cc_0-1.jpg',1315);
INSERT INTO `wp_wpvivid_scan_result` VALUES (89,'2025/03/myonlyeye_Dictionary_page_on_the_term_Ordliste_style_pixar_-_88317278-38ce-487f-bc3b-4d3427a309b0_2-1-300x300.jpg',1317);
INSERT INTO `wp_wpvivid_scan_result` VALUES (90,'2025/03/myonlyeye_Dictionary_page_on_the_term_Ordliste_style_pixar_-_88317278-38ce-487f-bc3b-4d3427a309b0_2-1-150x150.jpg',1317);
INSERT INTO `wp_wpvivid_scan_result` VALUES (91,'2025/03/myonlyeye_Dictionary_page_on_the_term_Ordliste_style_pixar_-_88317278-38ce-487f-bc3b-4d3427a309b0_2-1-768x768.jpg',1317);
INSERT INTO `wp_wpvivid_scan_result` VALUES (92,'2025/03/myonlyeye_Dictionary_page_on_the_term_Ordliste_style_pixar_-_88317278-38ce-487f-bc3b-4d3427a309b0_2-1.jpg',1317);
INSERT INTO `wp_wpvivid_scan_result` VALUES (93,'2025/03/kinetica___A_cute_Viking_with_a_surprised_expression_in_a_tradi_0c54d4e4-9dfe-4a2c-b8c3-3d392c288d13-1-300x300.jpg',1319);
INSERT INTO `wp_wpvivid_scan_result` VALUES (94,'2025/03/kinetica___A_cute_Viking_with_a_surprised_expression_in_a_tradi_0c54d4e4-9dfe-4a2c-b8c3-3d392c288d13-1-150x150.jpg',1319);
INSERT INTO `wp_wpvivid_scan_result` VALUES (95,'2025/03/kinetica___A_cute_Viking_with_a_surprised_expression_in_a_tradi_0c54d4e4-9dfe-4a2c-b8c3-3d392c288d13-1-768x768.jpg',1319);
INSERT INTO `wp_wpvivid_scan_result` VALUES (96,'2025/03/kinetica___A_cute_Viking_with_a_surprised_expression_in_a_tradi_0c54d4e4-9dfe-4a2c-b8c3-3d392c288d13-1.jpg',1319);
INSERT INTO `wp_wpvivid_scan_result` VALUES (97,'2025/03/myonlyeye_a_machine_the_prints_out_papers_with_questiongs_sty_294f241f-3f39-45b3-92d6-c8c4e52b5fcb_1-1-300x300.jpg',1321);
INSERT INTO `wp_wpvivid_scan_result` VALUES (98,'2025/03/myonlyeye_a_machine_the_prints_out_papers_with_questiongs_sty_294f241f-3f39-45b3-92d6-c8c4e52b5fcb_1-1-150x150.jpg',1321);
INSERT INTO `wp_wpvivid_scan_result` VALUES (99,'2025/03/myonlyeye_a_machine_the_prints_out_papers_with_questiongs_sty_294f241f-3f39-45b3-92d6-c8c4e52b5fcb_1-1-768x768.jpg',1321);
INSERT INTO `wp_wpvivid_scan_result` VALUES (100,'2025/03/myonlyeye_a_machine_the_prints_out_papers_with_questiongs_sty_294f241f-3f39-45b3-92d6-c8c4e52b5fcb_1-1.jpg',1321);
INSERT INTO `wp_wpvivid_scan_result` VALUES (101,'2025/03/pripovedac9665_a_young_standup_comedian_on_stage_bowing_toward__c3cf7bbf-fcde-467e-8333-e6643d5ed9f5-1-300x300.jpg',1323);
INSERT INTO `wp_wpvivid_scan_result` VALUES (102,'2025/03/pripovedac9665_a_young_standup_comedian_on_stage_bowing_toward__c3cf7bbf-fcde-467e-8333-e6643d5ed9f5-1-150x150.jpg',1323);
INSERT INTO `wp_wpvivid_scan_result` VALUES (103,'2025/03/pripovedac9665_a_young_standup_comedian_on_stage_bowing_toward__c3cf7bbf-fcde-467e-8333-e6643d5ed9f5-1-768x768.jpg',1323);
INSERT INTO `wp_wpvivid_scan_result` VALUES (104,'2025/03/pripovedac9665_a_young_standup_comedian_on_stage_bowing_toward__c3cf7bbf-fcde-467e-8333-e6643d5ed9f5-1.jpg',1323);
INSERT INTO `wp_wpvivid_scan_result` VALUES (105,'2025/03/myonlyeye_two_people_talking_casual_happy_style_pixar_-v_6.1_1f845975-1ab6-4ac2-a26d-95379fc478e7_3-1-300x300.jpg',1325);
INSERT INTO `wp_wpvivid_scan_result` VALUES (106,'2025/03/myonlyeye_two_people_talking_casual_happy_style_pixar_-v_6.1_1f845975-1ab6-4ac2-a26d-95379fc478e7_3-1-150x150.jpg',1325);
INSERT INTO `wp_wpvivid_scan_result` VALUES (107,'2025/03/myonlyeye_two_people_talking_casual_happy_style_pixar_-v_6.1_1f845975-1ab6-4ac2-a26d-95379fc478e7_3-1-768x768.jpg',1325);
INSERT INTO `wp_wpvivid_scan_result` VALUES (108,'2025/03/myonlyeye_two_people_talking_casual_happy_style_pixar_-v_6.1_1f845975-1ab6-4ac2-a26d-95379fc478e7_3-1.jpg',1325);
INSERT INTO `wp_wpvivid_scan_result` VALUES (109,'2025/03/myonlyeye_Ingrid_Johansen_a_norwegian_teenager_in_shirt_and_s_353c58e0-1d1e-4f8e-83d6-1706d95d4e01_0-300x300.jpg',1327);
INSERT INTO `wp_wpvivid_scan_result` VALUES (110,'2025/03/myonlyeye_Ingrid_Johansen_a_norwegian_teenager_in_shirt_and_s_353c58e0-1d1e-4f8e-83d6-1706d95d4e01_0-150x150.jpg',1327);
INSERT INTO `wp_wpvivid_scan_result` VALUES (111,'2025/03/myonlyeye_Ingrid_Johansen_a_norwegian_teenager_in_shirt_and_s_353c58e0-1d1e-4f8e-83d6-1706d95d4e01_0-768x768.jpg',1327);
INSERT INTO `wp_wpvivid_scan_result` VALUES (112,'2025/03/myonlyeye_Ingrid_Johansen_a_norwegian_teenager_in_shirt_and_s_353c58e0-1d1e-4f8e-83d6-1706d95d4e01_0.jpg',1327);
INSERT INTO `wp_wpvivid_scan_result` VALUES (113,'2025/03/sameflagg-1m-e1737368906687-300x300.jpg',1329);
INSERT INTO `wp_wpvivid_scan_result` VALUES (114,'2025/03/sameflagg-1m-e1737368906687-150x150.jpg',1329);
INSERT INTO `wp_wpvivid_scan_result` VALUES (115,'2025/03/sameflagg-1m-e1737368906687.jpg',1329);
INSERT INTO `wp_wpvivid_scan_result` VALUES (116,'2025/03/myonlyeye_man_of_science_pixar_style_-v_6.1_4d004b6d-6797-4e05-b378-b05725fd5771_1-300x300.jpg',1331);
INSERT INTO `wp_wpvivid_scan_result` VALUES (117,'2025/03/myonlyeye_man_of_science_pixar_style_-v_6.1_4d004b6d-6797-4e05-b378-b05725fd5771_1-150x150.jpg',1331);
INSERT INTO `wp_wpvivid_scan_result` VALUES (118,'2025/03/myonlyeye_man_of_science_pixar_style_-v_6.1_4d004b6d-6797-4e05-b378-b05725fd5771_1-768x768.jpg',1331);
INSERT INTO `wp_wpvivid_scan_result` VALUES (119,'2025/03/myonlyeye_man_of_science_pixar_style_-v_6.1_4d004b6d-6797-4e05-b378-b05725fd5771_1.jpg',1331);
INSERT INTO `wp_wpvivid_scan_result` VALUES (120,'2025/03/image-1-300x300.jpg',1333);
INSERT INTO `wp_wpvivid_scan_result` VALUES (121,'2025/03/image-1-150x150.jpg',1333);
INSERT INTO `wp_wpvivid_scan_result` VALUES (122,'2025/03/image-1-768x768.jpg',1333);
INSERT INTO `wp_wpvivid_scan_result` VALUES (123,'2025/03/image-1.jpg',1333);
INSERT INTO `wp_wpvivid_scan_result` VALUES (124,'2025/03/myonlyeye_stortinget_norway_pixar_animation_style_-cref_http_0e5844bb-95cb-4762-9e16-30cd489d2c1b_0.jpg',1335);
INSERT INTO `wp_wpvivid_scan_result` VALUES (125,'2025/03/myonlyeye_stortinget_norway_pixar_animation_style_-cref_http_0e5844bb-95cb-4762-9e16-30cd489d2c1b_0-300x300.jpg',1335);
INSERT INTO `wp_wpvivid_scan_result` VALUES (126,'2025/03/myonlyeye_stortinget_norway_pixar_animation_style_-cref_http_0e5844bb-95cb-4762-9e16-30cd489d2c1b_0-150x150.jpg',1335);
INSERT INTO `wp_wpvivid_scan_result` VALUES (127,'2025/03/myonlyeye_stortinget_norway_pixar_animation_style_-cref_http_0e5844bb-95cb-4762-9e16-30cd489d2c1b_0-768x768.jpg',1335);
INSERT INTO `wp_wpvivid_scan_result` VALUES (128,'2025/03/2023-12-14_22-40-45_3828-300x300.jpg',1335);
INSERT INTO `wp_wpvivid_scan_result` VALUES (129,'2025/03/2023-12-14_22-40-45_3828-150x150.jpg',1335);
INSERT INTO `wp_wpvivid_scan_result` VALUES (130,'2025/03/2023-12-14_22-40-45_3828-768x768.jpg',1335);
INSERT INTO `wp_wpvivid_scan_result` VALUES (131,'2025/03/2023-12-14_22-40-45_3828.jpg',1335);
INSERT INTO `wp_wpvivid_scan_result` VALUES (132,'2025/03/MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985-300x300.jpg',1337);
INSERT INTO `wp_wpvivid_scan_result` VALUES (133,'2025/03/MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985-150x150.jpg',1337);
INSERT INTO `wp_wpvivid_scan_result` VALUES (134,'2025/03/MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985-768x768.jpg',1337);
INSERT INTO `wp_wpvivid_scan_result` VALUES (135,'2025/03/MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985.jpg',1337);
INSERT INTO `wp_wpvivid_scan_result` VALUES (136,'2025/03/image-3-1-300x300.jpg',1339);
INSERT INTO `wp_wpvivid_scan_result` VALUES (137,'2025/03/image-3-1-150x150.jpg',1339);
INSERT INTO `wp_wpvivid_scan_result` VALUES (138,'2025/03/image-3-1-768x768.jpg',1339);
INSERT INTO `wp_wpvivid_scan_result` VALUES (139,'2025/03/image-3-1.jpg',1339);
INSERT INTO `wp_wpvivid_scan_result` VALUES (140,'2025/03/image-1-1-300x300.jpg',1341);
INSERT INTO `wp_wpvivid_scan_result` VALUES (141,'2025/03/image-1-1-150x150.jpg',1341);
INSERT INTO `wp_wpvivid_scan_result` VALUES (142,'2025/03/image-1-1-768x768.jpg',1341);
INSERT INTO `wp_wpvivid_scan_result` VALUES (143,'2025/03/image-1-1.jpg',1341);
INSERT INTO `wp_wpvivid_scan_result` VALUES (144,'2025/03/myonlyeye_creative_writer_sitting_by_a_desk_lot_on_notes_on_t_cd76d529-31ac-4d3f-8d06-c378484bcb3a_1-300x300.jpg',1343);
INSERT INTO `wp_wpvivid_scan_result` VALUES (145,'2025/03/myonlyeye_creative_writer_sitting_by_a_desk_lot_on_notes_on_t_cd76d529-31ac-4d3f-8d06-c378484bcb3a_1-150x150.jpg',1343);
INSERT INTO `wp_wpvivid_scan_result` VALUES (146,'2025/03/myonlyeye_creative_writer_sitting_by_a_desk_lot_on_notes_on_t_cd76d529-31ac-4d3f-8d06-c378484bcb3a_1-768x768.jpg',1343);
INSERT INTO `wp_wpvivid_scan_result` VALUES (147,'2025/03/myonlyeye_creative_writer_sitting_by_a_desk_lot_on_notes_on_t_cd76d529-31ac-4d3f-8d06-c378484bcb3a_1.jpg',1343);
INSERT INTO `wp_wpvivid_scan_result` VALUES (148,'2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_3-300x300.jpg',1345);
INSERT INTO `wp_wpvivid_scan_result` VALUES (149,'2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_3-150x150.jpg',1345);
INSERT INTO `wp_wpvivid_scan_result` VALUES (150,'2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_3-768x768.jpg',1345);
INSERT INTO `wp_wpvivid_scan_result` VALUES (151,'2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_3.jpg',1345);
INSERT INTO `wp_wpvivid_scan_result` VALUES (152,'2025/03/myonlyeye_religion_and_ethics_symbol_-v_6.1_66ee8d7e-2291-4473-b9b5-4ff9d97eba13_2-300x300.jpg',1348);
INSERT INTO `wp_wpvivid_scan_result` VALUES (153,'2025/03/myonlyeye_religion_and_ethics_symbol_-v_6.1_66ee8d7e-2291-4473-b9b5-4ff9d97eba13_2-150x150.jpg',1348);
INSERT INTO `wp_wpvivid_scan_result` VALUES (154,'2025/03/myonlyeye_religion_and_ethics_symbol_-v_6.1_66ee8d7e-2291-4473-b9b5-4ff9d97eba13_2-768x768.jpg',1348);
INSERT INTO `wp_wpvivid_scan_result` VALUES (155,'2025/03/myonlyeye_religion_and_ethics_symbol_-v_6.1_66ee8d7e-2291-4473-b9b5-4ff9d97eba13_2.jpg',1348);
INSERT INTO `wp_wpvivid_scan_result` VALUES (156,'2025/03/myonlyeye_stortinget_norway_pixar_animation_style_-cref_http_0e5844bb-95cb-4762-9e16-30cd489d2c1b_0-300x300.jpg',1350);
INSERT INTO `wp_wpvivid_scan_result` VALUES (157,'2025/03/myonlyeye_stortinget_norway_pixar_animation_style_-cref_http_0e5844bb-95cb-4762-9e16-30cd489d2c1b_0-150x150.jpg',1350);
INSERT INTO `wp_wpvivid_scan_result` VALUES (158,'2025/03/myonlyeye_stortinget_norway_pixar_animation_style_-cref_http_0e5844bb-95cb-4762-9e16-30cd489d2c1b_0-768x768.jpg',1350);
INSERT INTO `wp_wpvivid_scan_result` VALUES (159,'2025/03/myonlyeye_stortinget_norway_pixar_animation_style_-cref_http_0e5844bb-95cb-4762-9e16-30cd489d2c1b_0.jpg',1350);
INSERT INTO `wp_wpvivid_scan_result` VALUES (160,'2025/03/myonlyeye_stone_age_man_inside_ice_style_pixar_-v_6.1_fe0b64dd-deec-4886-95ee-dd81ba573e4d_0-300x300.jpg',1352);
INSERT INTO `wp_wpvivid_scan_result` VALUES (161,'2025/03/myonlyeye_stone_age_man_inside_ice_style_pixar_-v_6.1_fe0b64dd-deec-4886-95ee-dd81ba573e4d_0-150x150.jpg',1352);
INSERT INTO `wp_wpvivid_scan_result` VALUES (162,'2025/03/myonlyeye_stone_age_man_inside_ice_style_pixar_-v_6.1_fe0b64dd-deec-4886-95ee-dd81ba573e4d_0-768x768.jpg',1352);
INSERT INTO `wp_wpvivid_scan_result` VALUES (163,'2025/03/myonlyeye_stone_age_man_inside_ice_style_pixar_-v_6.1_fe0b64dd-deec-4886-95ee-dd81ba573e4d_0.jpg',1352);
INSERT INTO `wp_wpvivid_scan_result` VALUES (164,'2025/03/myonlyeye_casual_happy_socrates_style_pixar_-turbo_a2b9f20b-43c0-46b0-92f1-1acf4a0cd9d9_1-300x300.jpg',1357);
INSERT INTO `wp_wpvivid_scan_result` VALUES (165,'2025/03/myonlyeye_casual_happy_socrates_style_pixar_-turbo_a2b9f20b-43c0-46b0-92f1-1acf4a0cd9d9_1-150x150.jpg',1357);
INSERT INTO `wp_wpvivid_scan_result` VALUES (166,'2025/03/myonlyeye_casual_happy_socrates_style_pixar_-turbo_a2b9f20b-43c0-46b0-92f1-1acf4a0cd9d9_1-768x768.jpg',1357);
INSERT INTO `wp_wpvivid_scan_result` VALUES (167,'2025/03/myonlyeye_casual_happy_socrates_style_pixar_-turbo_a2b9f20b-43c0-46b0-92f1-1acf4a0cd9d9_1.jpg',1357);
INSERT INTO `wp_wpvivid_scan_result` VALUES (168,'2025/03/myonlyeye_happy_kid_pixar_animation_style_neutral_background_1679c7b1-4755-4b3e-b017-38e24bfb4de7_1-300x300.jpg',1359);
INSERT INTO `wp_wpvivid_scan_result` VALUES (169,'2025/03/myonlyeye_happy_kid_pixar_animation_style_neutral_background_1679c7b1-4755-4b3e-b017-38e24bfb4de7_1-150x150.jpg',1359);
INSERT INTO `wp_wpvivid_scan_result` VALUES (170,'2025/03/myonlyeye_happy_kid_pixar_animation_style_neutral_background_1679c7b1-4755-4b3e-b017-38e24bfb4de7_1-768x768.jpg',1359);
INSERT INTO `wp_wpvivid_scan_result` VALUES (171,'2025/03/myonlyeye_happy_kid_pixar_animation_style_neutral_background_1679c7b1-4755-4b3e-b017-38e24bfb4de7_1.jpg',1359);
INSERT INTO `wp_wpvivid_scan_result` VALUES (172,'2025/03/myonlyeye_a_writing_workshop_three_people_pixar_animation_sty_67fc1acd-b10d-4607-956c-efedfa493d9d_0-300x300.jpg',1361);
INSERT INTO `wp_wpvivid_scan_result` VALUES (173,'2025/03/myonlyeye_a_writing_workshop_three_people_pixar_animation_sty_67fc1acd-b10d-4607-956c-efedfa493d9d_0-150x150.jpg',1361);
INSERT INTO `wp_wpvivid_scan_result` VALUES (174,'2025/03/myonlyeye_a_writing_workshop_three_people_pixar_animation_sty_67fc1acd-b10d-4607-956c-efedfa493d9d_0-768x768.jpg',1361);
INSERT INTO `wp_wpvivid_scan_result` VALUES (175,'2025/03/myonlyeye_a_writing_workshop_three_people_pixar_animation_sty_67fc1acd-b10d-4607-956c-efedfa493d9d_0.jpg',1361);
INSERT INTO `wp_wpvivid_scan_result` VALUES (176,'2025/03/MyOnlyEye_in_icon_of_a_writing_club_style_pixar_da9c18e9-bae4-4bfe-b16d-96f22e391593-300x300.jpg',1363);
INSERT INTO `wp_wpvivid_scan_result` VALUES (177,'2025/03/MyOnlyEye_in_icon_of_a_writing_club_style_pixar_da9c18e9-bae4-4bfe-b16d-96f22e391593-150x150.jpg',1363);
INSERT INTO `wp_wpvivid_scan_result` VALUES (178,'2025/03/MyOnlyEye_in_icon_of_a_writing_club_style_pixar_da9c18e9-bae4-4bfe-b16d-96f22e391593-768x768.jpg',1363);
INSERT INTO `wp_wpvivid_scan_result` VALUES (179,'2025/03/MyOnlyEye_in_icon_of_a_writing_club_style_pixar_da9c18e9-bae4-4bfe-b16d-96f22e391593.jpg',1363);
INSERT INTO `wp_wpvivid_scan_result` VALUES (180,'2025/03/myonlyeye_an_AI_helping_a_teacher_write_an_assignment_pixar_a_97c80671-d888-4059-a907-8467f477d1cc_0-300x300.jpg',1365);
INSERT INTO `wp_wpvivid_scan_result` VALUES (181,'2025/03/myonlyeye_an_AI_helping_a_teacher_write_an_assignment_pixar_a_97c80671-d888-4059-a907-8467f477d1cc_0-150x150.jpg',1365);
INSERT INTO `wp_wpvivid_scan_result` VALUES (182,'2025/03/myonlyeye_an_AI_helping_a_teacher_write_an_assignment_pixar_a_97c80671-d888-4059-a907-8467f477d1cc_0-768x768.jpg',1365);
INSERT INTO `wp_wpvivid_scan_result` VALUES (183,'2025/03/myonlyeye_an_AI_helping_a_teacher_write_an_assignment_pixar_a_97c80671-d888-4059-a907-8467f477d1cc_0.jpg',1365);
INSERT INTO `wp_wpvivid_scan_result` VALUES (184,'2023/09/diskusjonen-300x300.png',1367);
INSERT INTO `wp_wpvivid_scan_result` VALUES (185,'2023/09/diskusjonen-150x150.png',1367);
INSERT INTO `wp_wpvivid_scan_result` VALUES (186,'2023/09/diskusjonen-768x768.png',1367);
INSERT INTO `wp_wpvivid_scan_result` VALUES (187,'2023/09/diskusjonen.png',1367);
INSERT INTO `wp_wpvivid_scan_result` VALUES (188,'2025/03/microbit-300x300.jpg',1369);
INSERT INTO `wp_wpvivid_scan_result` VALUES (189,'2025/03/microbit-150x150.jpg',1369);
INSERT INTO `wp_wpvivid_scan_result` VALUES (190,'2025/03/microbit-768x768.jpg',1369);
INSERT INTO `wp_wpvivid_scan_result` VALUES (191,'2025/03/microbit.jpg',1369);
INSERT INTO `wp_wpvivid_scan_result` VALUES (192,'2025/03/myonlyeye_a_kind_teacher_pixar_style_neutral_background_-sty_49c0b56f-82cf-4492-99e5-f7117314b7ff_0-300x300.jpg',1371);
INSERT INTO `wp_wpvivid_scan_result` VALUES (193,'2025/03/myonlyeye_a_kind_teacher_pixar_style_neutral_background_-sty_49c0b56f-82cf-4492-99e5-f7117314b7ff_0-150x150.jpg',1371);
INSERT INTO `wp_wpvivid_scan_result` VALUES (194,'2025/03/myonlyeye_a_kind_teacher_pixar_style_neutral_background_-sty_49c0b56f-82cf-4492-99e5-f7117314b7ff_0-768x768.jpg',1371);
INSERT INTO `wp_wpvivid_scan_result` VALUES (195,'2025/03/myonlyeye_a_kind_teacher_pixar_style_neutral_background_-sty_49c0b56f-82cf-4492-99e5-f7117314b7ff_0.jpg',1371);
INSERT INTO `wp_wpvivid_scan_result` VALUES (196,'2025/03/myonlyeye_a_happy_pixar_character_writing_in_a_book_one_colou_71cb9c48-55ae-40fa-85d3-34c21218ede9_0-300x300.jpg',1373);
INSERT INTO `wp_wpvivid_scan_result` VALUES (197,'2025/03/myonlyeye_a_happy_pixar_character_writing_in_a_book_one_colou_71cb9c48-55ae-40fa-85d3-34c21218ede9_0-150x150.jpg',1373);
INSERT INTO `wp_wpvivid_scan_result` VALUES (198,'2025/03/myonlyeye_a_happy_pixar_character_writing_in_a_book_one_colou_71cb9c48-55ae-40fa-85d3-34c21218ede9_0-768x768.jpg',1373);
INSERT INTO `wp_wpvivid_scan_result` VALUES (199,'2025/03/myonlyeye_a_happy_pixar_character_writing_in_a_book_one_colou_71cb9c48-55ae-40fa-85d3-34c21218ede9_0.jpg',1373);
INSERT INTO `wp_wpvivid_scan_result` VALUES (200,'2025/03/myonlyeye_a_very_polite_writer_pixar_style_white_background_2e9f7252-0cb8-47ae-aa4d-80289454d2b3-300x300.jpg',1375);
INSERT INTO `wp_wpvivid_scan_result` VALUES (201,'2025/03/myonlyeye_a_very_polite_writer_pixar_style_white_background_2e9f7252-0cb8-47ae-aa4d-80289454d2b3-150x150.jpg',1375);
INSERT INTO `wp_wpvivid_scan_result` VALUES (202,'2025/03/myonlyeye_a_very_polite_writer_pixar_style_white_background_2e9f7252-0cb8-47ae-aa4d-80289454d2b3-768x768.jpg',1375);
INSERT INTO `wp_wpvivid_scan_result` VALUES (203,'2025/03/myonlyeye_a_very_polite_writer_pixar_style_white_background_2e9f7252-0cb8-47ae-aa4d-80289454d2b3.jpg',1375);
INSERT INTO `wp_wpvivid_scan_result` VALUES (204,'2025/03/MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985-300x300.jpg',1377);
INSERT INTO `wp_wpvivid_scan_result` VALUES (205,'2025/03/MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985-150x150.jpg',1377);
INSERT INTO `wp_wpvivid_scan_result` VALUES (206,'2025/03/MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985-768x768.jpg',1377);
INSERT INTO `wp_wpvivid_scan_result` VALUES (207,'2025/03/MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985.jpg',1377);
INSERT INTO `wp_wpvivid_scan_result` VALUES (208,'2025/03/myonlyeye_a_polite_butler_carrying_a_scroll_pixar_style_white_b_de12e82c-1869-452f-b2a7-b012d7103c7a-300x300.jpg',1379);
INSERT INTO `wp_wpvivid_scan_result` VALUES (209,'2025/03/myonlyeye_a_polite_butler_carrying_a_scroll_pixar_style_white_b_de12e82c-1869-452f-b2a7-b012d7103c7a-150x150.jpg',1379);
INSERT INTO `wp_wpvivid_scan_result` VALUES (210,'2025/03/myonlyeye_a_polite_butler_carrying_a_scroll_pixar_style_white_b_de12e82c-1869-452f-b2a7-b012d7103c7a-768x768.jpg',1379);
INSERT INTO `wp_wpvivid_scan_result` VALUES (211,'2025/03/myonlyeye_a_polite_butler_carrying_a_scroll_pixar_style_white_b_de12e82c-1869-452f-b2a7-b012d7103c7a.jpg',1379);
INSERT INTO `wp_wpvivid_scan_result` VALUES (212,'2025/03/myonlyeye_depressed_robot_with_a_huge_head_in_the_animation_s_64eb410b-44c9-4f11-bd93-f078a40b16f2_3-300x300.jpg',1381);
INSERT INTO `wp_wpvivid_scan_result` VALUES (213,'2025/03/myonlyeye_depressed_robot_with_a_huge_head_in_the_animation_s_64eb410b-44c9-4f11-bd93-f078a40b16f2_3-150x150.jpg',1381);
INSERT INTO `wp_wpvivid_scan_result` VALUES (214,'2025/03/myonlyeye_depressed_robot_with_a_huge_head_in_the_animation_s_64eb410b-44c9-4f11-bd93-f078a40b16f2_3-768x768.jpg',1381);
INSERT INTO `wp_wpvivid_scan_result` VALUES (215,'2025/03/myonlyeye_depressed_robot_with_a_huge_head_in_the_animation_s_64eb410b-44c9-4f11-bd93-f078a40b16f2_3.jpg',1381);
INSERT INTO `wp_wpvivid_scan_result` VALUES (216,'2025/03/MyOnlyEye_an_icon_of_a_female_egg_causal_happy_pixar_style_36387029-e099-4b05-8927-eeb82fb21249-300x300.jpg',1383);
INSERT INTO `wp_wpvivid_scan_result` VALUES (217,'2025/03/MyOnlyEye_an_icon_of_a_female_egg_causal_happy_pixar_style_36387029-e099-4b05-8927-eeb82fb21249-150x150.jpg',1383);
INSERT INTO `wp_wpvivid_scan_result` VALUES (218,'2025/03/MyOnlyEye_an_icon_of_a_female_egg_causal_happy_pixar_style_36387029-e099-4b05-8927-eeb82fb21249-768x768.jpg',1383);
INSERT INTO `wp_wpvivid_scan_result` VALUES (219,'2025/03/MyOnlyEye_an_icon_of_a_female_egg_causal_happy_pixar_style_36387029-e099-4b05-8927-eeb82fb21249.jpg',1383);
INSERT INTO `wp_wpvivid_scan_result` VALUES (220,'2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_3-300x300.jpg',1387);
INSERT INTO `wp_wpvivid_scan_result` VALUES (221,'2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_3-150x150.jpg',1387);
INSERT INTO `wp_wpvivid_scan_result` VALUES (222,'2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_3-768x768.jpg',1387);
INSERT INTO `wp_wpvivid_scan_result` VALUES (223,'2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_3.jpg',1387);
INSERT INTO `wp_wpvivid_scan_result` VALUES (224,'2025/03/myonlyeye_an_open_chest_filled_with_famous_persons_view_from__7782a14e-35ee-4fdd-ba38-a2d5d9d49366_2-1-300x300.jpg',1390);
INSERT INTO `wp_wpvivid_scan_result` VALUES (225,'2025/03/myonlyeye_an_open_chest_filled_with_famous_persons_view_from__7782a14e-35ee-4fdd-ba38-a2d5d9d49366_2-1-150x150.jpg',1390);
INSERT INTO `wp_wpvivid_scan_result` VALUES (226,'2025/03/myonlyeye_an_open_chest_filled_with_famous_persons_view_from__7782a14e-35ee-4fdd-ba38-a2d5d9d49366_2-1-768x768.jpg',1390);
INSERT INTO `wp_wpvivid_scan_result` VALUES (227,'2025/03/myonlyeye_an_open_chest_filled_with_famous_persons_view_from__7782a14e-35ee-4fdd-ba38-a2d5d9d49366_2-1.jpg',1390);
INSERT INTO `wp_wpvivid_scan_result` VALUES (228,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe.jpg',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (229,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe.jpg',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (230,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe-300x168.jpg',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (231,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe-1024x574.jpg',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (232,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe-768x430.jpg',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (233,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1.png',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (234,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1.png',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (235,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-300x300.png',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (236,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-150x150.png',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (237,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-768x768.png',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (238,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1.png',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (239,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1.png',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (240,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-300x300.png',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (241,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-150x150.png',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (242,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-768x768.png',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (243,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe.jpg',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (244,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe-300x168.jpg',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (245,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe-1024x574.jpg',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (246,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe-150x150.jpg',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (247,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe-768x430.jpg',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (248,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1.png',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (249,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-300x300.png',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (250,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-150x150.png',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (251,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-768x768.png',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (252,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1.png',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (253,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-300x300.png',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (254,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-150x150.png',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (255,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-768x768.png',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (256,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe.jpg',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (257,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1.png',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (258,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1.png',19);
INSERT INTO `wp_wpvivid_scan_result` VALUES (259,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe.jpg',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (260,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe.jpg',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (261,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe-300x168.jpg',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (262,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe-1024x574.jpg',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (263,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe-768x430.jpg',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (264,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1.png',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (265,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1.png',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (266,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-300x300.png',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (267,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-150x150.png',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (268,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-768x768.png',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (269,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1.png',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (270,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1.png',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (271,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-300x300.png',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (272,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-150x150.png',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (273,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-768x768.png',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (274,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe.jpg',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (275,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe-300x168.jpg',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (276,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe-1024x574.jpg',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (277,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe-150x150.jpg',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (278,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe-768x430.jpg',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (279,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1.png',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (280,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-300x300.png',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (281,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-150x150.png',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (282,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-768x768.png',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (283,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1.png',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (284,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-300x300.png',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (285,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-150x150.png',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (286,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1-768x768.png',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (287,'2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe.jpg',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (288,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1.png',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (289,'2023/09/myonlyeye_a_smiling_robot_friendly_logo_icon_white_background_206d14d4-f14b-4050-9ad8-52660d52ed1e-1.png',1189);
INSERT INTO `wp_wpvivid_scan_result` VALUES (290,'2023/04/by-nc-sa.png',7);
INSERT INTO `wp_wpvivid_scan_result` VALUES (291,'2023/04/by-nc-sa.png',7);
INSERT INTO `wp_wpvivid_scan_result` VALUES (292,'2023/04/by-nc-sa-300x105.png',7);
INSERT INTO `wp_wpvivid_scan_result` VALUES (293,'2023/04/by-nc-sa.png',7);
INSERT INTO `wp_wpvivid_scan_result` VALUES (294,'2023/04/by-nc-sa-300x105.png',7);
INSERT INTO `wp_wpvivid_scan_result` VALUES (295,'2023/04/by-nc-sa-150x141.png',7);
INSERT INTO `wp_wpvivid_scan_result` VALUES (296,'2023/04/by-nc-sa.png',7);
INSERT INTO `wp_wpvivid_scan_result` VALUES (297,'2023/06/by-nc-sa.png',20);
INSERT INTO `wp_wpvivid_scan_result` VALUES (298,'2023/06/by-nc-sa.png',20);
INSERT INTO `wp_wpvivid_scan_result` VALUES (299,'2023/06/by-nc-sa-150x50.png',20);
INSERT INTO `wp_wpvivid_scan_result` VALUES (300,'2023/06/by-nc-sa.png',20);
/*!40000 ALTER TABLE `wp_wpvivid_scan_result` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_comments`
--

DROP TABLE IF EXISTS `wp_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_comments`
--

LOCK TABLES `wp_comments` WRITE;
/*!40000 ALTER TABLE `wp_comments` DISABLE KEYS */;
INSERT INTO `wp_comments` VALUES (1,1070,'','','','','2024-04-18 22:29:24','2024-04-18 20:29:24','',0,'active','','rua_member',0,81);
/*!40000 ALTER TABLE `wp_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_postmeta`
--

DROP TABLE IF EXISTS `wp_postmeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1729 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_postmeta`
--

LOCK TABLES `wp_postmeta` WRITE;
/*!40000 ALTER TABLE `wp_postmeta` DISABLE KEYS */;
INSERT INTO `wp_postmeta` VALUES (2,3,'_wp_page_template','default');
INSERT INTO `wp_postmeta` VALUES (5,7,'origin','theme');
INSERT INTO `wp_postmeta` VALUES (9,8,'_edit_last','80');
INSERT INTO `wp_postmeta` VALUES (10,8,'_ca_handle','0');
INSERT INTO `wp_postmeta` VALUES (11,8,'_ca_duration','a:2:{s:5:"count";s:1:"0";s:4:"unit";s:3:"day";}');
INSERT INTO `wp_postmeta` VALUES (12,8,'_ca_caps','a:0:{}');
INSERT INTO `wp_postmeta` VALUES (13,8,'_ca_hide_admin_bar','1');
INSERT INTO `wp_postmeta` VALUES (14,8,'_ca_default_access','1');
INSERT INTO `wp_postmeta` VALUES (15,8,'_ca_admin_access','0');
INSERT INTO `wp_postmeta` VALUES (16,8,'_ca_member_automations','a:1:{i:0;a:2:{s:4:"name";s:5:"login";s:5:"value";s:5:"login";}}');
INSERT INTO `wp_postmeta` VALUES (17,8,'_edit_lock','1713366114:80');
INSERT INTO `wp_postmeta` VALUES (18,8,'_ca_page','678');
INSERT INTO `wp_postmeta` VALUES (37,19,'origin','theme');
INSERT INTO `wp_postmeta` VALUES (38,20,'origin','theme');
INSERT INTO `wp_postmeta` VALUES (102,71,'_wp_attached_file','2023/03/Mitt-prosjekt-3.jpg');
INSERT INTO `wp_postmeta` VALUES (103,71,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:27:"2023/03/Mitt-prosjekt-3.jpg";s:8:"filesize";i:186423;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:27:"Mitt-prosjekt-3-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:22644;}s:9:"thumbnail";a:5:{s:4:"file";s:27:"Mitt-prosjekt-3-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:8038;}s:12:"medium_large";a:5:{s:4:"file";s:27:"Mitt-prosjekt-3-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:87004;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (104,72,'_wp_attached_file','2023/03/Mitt-prosjekt-4-e1680166322713.jpg');
INSERT INTO `wp_postmeta` VALUES (105,72,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:42:"2023/03/Mitt-prosjekt-4-e1680166322713.jpg";s:8:"filesize";i:217975;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:42:"Mitt-prosjekt-4-e1680166322713-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:23491;}s:9:"thumbnail";a:5:{s:4:"file";s:42:"Mitt-prosjekt-4-e1680166322713-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:8026;}s:12:"medium_large";a:5:{s:4:"file";s:42:"Mitt-prosjekt-4-e1680166322713-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:94243;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (108,74,'_wp_attached_file','2023/03/Mitt-prosjekt-6.jpg');
INSERT INTO `wp_postmeta` VALUES (109,74,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:27:"2023/03/Mitt-prosjekt-6.jpg";s:8:"filesize";i:1074261;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:27:"Mitt-prosjekt-6-300x300.png";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:113821;}s:9:"thumbnail";a:5:{s:4:"file";s:27:"Mitt-prosjekt-6-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:34166;}s:12:"medium_large";a:5:{s:4:"file";s:27:"Mitt-prosjekt-6-768x768.png";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:640362;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (124,74,'wp-smush-lossy','1');
INSERT INTO `wp_postmeta` VALUES (125,74,'wp-smpro-smush-data','a:2:{s:5:"stats";a:8:{s:7:"percent";d:49.528869576066306;s:5:"bytes";i:651056;s:11:"size_before";i:1314498;s:10:"size_after";i:663442;s:4:"time";d:0.48;s:11:"api_version";s:3:"1.0";s:5:"lossy";b:0;s:9:"keep_exif";i:0;}s:5:"sizes";a:4:{s:9:"thumbnail";O:8:"stdClass":5:{s:7:"percent";d:0.09;s:5:"bytes";i:15361;s:11:"size_before";i:21961;s:10:"size_after";i:21942;s:4:"time";d:0.04;}s:6:"medium";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:53323;s:11:"size_before";i:71991;s:10:"size_after";i:71991;s:4:"time";d:0.07;}s:4:"full";O:8:"stdClass":5:{s:7:"percent";d:80.52;s:5:"bytes";i:651037;s:11:"size_before";i:808531;s:10:"size_after";i:157494;s:4:"time";d:0.14;}s:12:"medium_large";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:305840;s:11:"size_before";i:412015;s:10:"size_after";i:412015;s:4:"time";d:0.23;}}}');
INSERT INTO `wp_postmeta` VALUES (128,72,'wp-smush-lossy','1');
INSERT INTO `wp_postmeta` VALUES (129,72,'wp-smpro-smush-data','a:2:{s:5:"stats";a:8:{s:7:"percent";d:42.6135112080907;s:5:"bytes";i:864753;s:11:"size_before";i:2029293;s:10:"size_after";i:1164540;s:4:"time";d:1.5;s:11:"api_version";s:3:"1.0";s:5:"lossy";b:0;s:9:"keep_exif";i:0;}s:5:"sizes";a:4:{s:9:"thumbnail";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:22992;s:11:"size_before";i:33716;s:10:"size_after";i:33716;s:4:"time";d:0.03;}s:6:"medium";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:78767;s:11:"size_before";i:112006;s:10:"size_after";i:112006;s:4:"time";d:0.06;}s:12:"medium_large";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:443144;s:11:"size_before";i:676006;s:10:"size_after";i:676006;s:4:"time";d:0.35;}s:4:"full";O:8:"stdClass":5:{s:7:"percent";d:71.61;s:5:"bytes";i:1361981;s:11:"size_before";i:1207565;s:10:"size_after";i:342812;s:4:"time";d:1.06;}}}');
INSERT INTO `wp_postmeta` VALUES (130,71,'wp-smush-lossy','1');
INSERT INTO `wp_postmeta` VALUES (131,71,'wp-smpro-smush-data','a:2:{s:5:"stats";a:8:{s:7:"percent";d:46.87225174470857;s:5:"bytes";i:777081;s:11:"size_before";i:1657870;s:10:"size_after";i:880789;s:4:"time";d:0.69;s:11:"api_version";s:3:"1.0";s:5:"lossy";b:0;s:9:"keep_exif";i:0;}s:5:"sizes";a:4:{s:9:"thumbnail";O:8:"stdClass":5:{s:7:"percent";d:1.29;s:5:"bytes";i:17425;s:11:"size_before";i:26554;s:10:"size_after";i:26212;s:4:"time";d:0.02;}s:6:"medium";O:8:"stdClass":5:{s:7:"percent";d:1.52;s:5:"bytes";i:62278;s:11:"size_before";i:88201;s:10:"size_after";i:86859;s:4:"time";d:0.05;}s:12:"medium_large";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:361055;s:11:"size_before";i:512961;s:10:"size_after";i:512961;s:4:"time";d:0.21;}s:4:"full";O:8:"stdClass":5:{s:7:"percent";d:75.27;s:5:"bytes";i:775397;s:11:"size_before";i:1030154;s:10:"size_after";i:254757;s:4:"time";d:0.41;}}}');
INSERT INTO `wp_postmeta` VALUES (216,160,'origin','theme');
INSERT INTO `wp_postmeta` VALUES (245,72,'_wp_attachment_backup_sizes','a:4:{s:9:"full-orig";a:3:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:19:"Mitt-prosjekt-4.png";}s:14:"thumbnail-orig";a:5:{s:4:"file";s:27:"Mitt-prosjekt-4-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:33081;}s:11:"medium-orig";a:5:{s:4:"file";s:27:"Mitt-prosjekt-4-300x300.png";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:108149;}s:17:"medium_large-orig";a:5:{s:4:"file";s:27:"Mitt-prosjekt-4-768x768.png";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:593899;}}');
INSERT INTO `wp_postmeta` VALUES (247,216,'_wp_attached_file','2023/03/MyOnlyEye_in_icon_of_a_writing_club_style_pixar_444fe45f-82d2-4d13-b0e2-2218150be1c0-e1723884876259.jpg');
INSERT INTO `wp_postmeta` VALUES (248,216,'_wp_attachment_metadata','a:6:{s:5:"width";i:600;s:6:"height";i:600;s:4:"file";s:111:"2023/03/MyOnlyEye_in_icon_of_a_writing_club_style_pixar_444fe45f-82d2-4d13-b0e2-2218150be1c0-e1723884876259.jpg";s:8:"filesize";i:255038;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:111:"MyOnlyEye_in_icon_of_a_writing_club_style_pixar_444fe45f-82d2-4d13-b0e2-2218150be1c0-e1723884876259-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:18380;}s:9:"thumbnail";a:5:{s:4:"file";s:111:"MyOnlyEye_in_icon_of_a_writing_club_style_pixar_444fe45f-82d2-4d13-b0e2-2218150be1c0-e1723884876259-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6398;}s:12:"medium_large";a:5:{s:4:"file";s:96:"MyOnlyEye_in_icon_of_a_writing_club_style_pixar_444fe45f-82d2-4d13-b0e2-2218150be1c0-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:98772;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (249,216,'wp-smpro-smush-data','a:2:{s:5:"stats";a:8:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:2240912;s:10:"size_after";i:2240912;s:4:"time";d:1.01;s:11:"api_version";s:3:"1.0";s:5:"lossy";b:0;s:9:"keep_exif";i:0;}s:5:"sizes";a:4:{s:9:"thumbnail";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:42419;s:10:"size_after";i:42419;s:4:"time";d:0.01;}s:6:"medium";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:143326;s:10:"size_after";i:143326;s:4:"time";d:0.05;}s:12:"medium_large";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:791387;s:10:"size_after";i:791387;s:4:"time";d:0.43;}s:4:"full";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:1263780;s:10:"size_after";i:1263780;s:4:"time";d:0.52;}}}');
INSERT INTO `wp_postmeta` VALUES (250,217,'_wp_attached_file','2023/03/MyOnlyEye_in_icon_of_a_writing_club_style_pixar_da9c18e9-bae4-4bfe-b16d-96f22e391593.jpg');
INSERT INTO `wp_postmeta` VALUES (251,217,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:96:"2023/03/MyOnlyEye_in_icon_of_a_writing_club_style_pixar_da9c18e9-bae4-4bfe-b16d-96f22e391593.jpg";s:8:"filesize";i:303971;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:96:"MyOnlyEye_in_icon_of_a_writing_club_style_pixar_da9c18e9-bae4-4bfe-b16d-96f22e391593-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:30696;}s:9:"thumbnail";a:5:{s:4:"file";s:96:"MyOnlyEye_in_icon_of_a_writing_club_style_pixar_da9c18e9-bae4-4bfe-b16d-96f22e391593-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:10376;}s:12:"medium_large";a:5:{s:4:"file";s:96:"MyOnlyEye_in_icon_of_a_writing_club_style_pixar_da9c18e9-bae4-4bfe-b16d-96f22e391593-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:126623;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (252,217,'wp-smpro-smush-data','a:2:{s:5:"stats";a:8:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:2663578;s:10:"size_after";i:2663578;s:4:"time";d:0.9199999999999999;s:11:"api_version";s:3:"1.0";s:5:"lossy";b:0;s:9:"keep_exif";i:0;}s:5:"sizes";a:4:{s:9:"thumbnail";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:49143;s:10:"size_after";i:49143;s:4:"time";d:0.02;}s:6:"medium";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:167095;s:10:"size_after";i:167095;s:4:"time";d:0.13;}s:12:"medium_large";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:936389;s:10:"size_after";i:936389;s:4:"time";d:0.44;}s:4:"full";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:1510951;s:10:"size_after";i:1510951;s:4:"time";d:0.33;}}}');
INSERT INTO `wp_postmeta` VALUES (255,72,'_edit_lock','1680191145:1');
INSERT INTO `wp_postmeta` VALUES (258,253,'_wp_attached_file','2023/03/Mitt-prosjekt-8-e1681720768248.jpg');
INSERT INTO `wp_postmeta` VALUES (259,253,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:42:"2023/03/Mitt-prosjekt-8-e1681720768248.jpg";s:8:"filesize";i:148586;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:42:"Mitt-prosjekt-8-e1681720768248-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:18440;}s:9:"thumbnail";a:5:{s:4:"file";s:42:"Mitt-prosjekt-8-e1681720768248-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6910;}s:12:"medium_large";a:5:{s:4:"file";s:42:"Mitt-prosjekt-8-e1681720768248-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:67539;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (260,253,'wp-smpro-smush-data','a:2:{s:5:"stats";a:8:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:1361108;s:10:"size_after";i:1361108;s:4:"time";d:0.8300000000000001;s:11:"api_version";s:3:"1.0";s:5:"lossy";b:0;s:9:"keep_exif";i:0;}s:5:"sizes";a:4:{s:6:"medium";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:74117;s:10:"size_after";i:74117;s:4:"time";d:0.05;}s:9:"thumbnail";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:22979;s:10:"size_after";i:22979;s:4:"time";d:0.02;}s:12:"medium_large";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:403103;s:10:"size_after";i:403103;s:4:"time";d:0.3;}s:4:"full";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:860909;s:10:"size_after";i:860909;s:4:"time";d:0.46;}}}');
INSERT INTO `wp_postmeta` VALUES (261,254,'_wp_attached_file','2023/03/Mitt-prosjekt-1-2-e1694046969640.jpg');
INSERT INTO `wp_postmeta` VALUES (262,254,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:44:"2023/03/Mitt-prosjekt-1-2-e1694046969640.jpg";s:8:"filesize";i:120859;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:44:"Mitt-prosjekt-1-2-e1694046969640-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:13757;}s:9:"thumbnail";a:5:{s:4:"file";s:44:"Mitt-prosjekt-1-2-e1694046969640-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:5155;}s:12:"medium_large";a:5:{s:4:"file";s:44:"Mitt-prosjekt-1-2-e1694046969640-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:51605;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (263,254,'wp-smpro-smush-data','a:2:{s:5:"stats";a:8:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:912329;s:10:"size_after";i:912329;s:4:"time";d:0.77;s:11:"api_version";s:3:"1.0";s:5:"lossy";b:0;s:9:"keep_exif";i:0;}s:5:"sizes";a:4:{s:9:"thumbnail";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:17354;s:10:"size_after";i:17354;s:4:"time";d:0.02;}s:6:"medium";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:55107;s:10:"size_after";i:55107;s:4:"time";d:0.08;}s:12:"medium_large";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:273598;s:10:"size_after";i:273598;s:4:"time";d:0.22;}s:4:"full";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:566270;s:10:"size_after";i:566270;s:4:"time";d:0.45;}}}');
INSERT INTO `wp_postmeta` VALUES (270,258,'_wp_attached_file','2023/03/Mitt-prosjekt-5-1.jpg');
INSERT INTO `wp_postmeta` VALUES (271,258,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:29:"2023/03/Mitt-prosjekt-5-1.jpg";s:8:"filesize";i:177469;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:29:"Mitt-prosjekt-5-1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:20842;}s:9:"thumbnail";a:5:{s:4:"file";s:29:"Mitt-prosjekt-5-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:7524;}s:12:"medium_large";a:5:{s:4:"file";s:29:"Mitt-prosjekt-5-1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:80387;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (272,258,'wp-smpro-smush-data','a:2:{s:5:"stats";a:8:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:1362698;s:10:"size_after";i:1362698;s:4:"time";d:0.9800000000000001;s:11:"api_version";s:3:"1.0";s:5:"lossy";b:0;s:9:"keep_exif";i:0;}s:5:"sizes";a:4:{s:9:"thumbnail";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:24850;s:10:"size_after";i:24850;s:4:"time";d:0.04;}s:6:"medium";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:79456;s:10:"size_after";i:79456;s:4:"time";d:0.07;}s:12:"medium_large";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:403655;s:10:"size_after";i:403655;s:4:"time";d:0.31;}s:4:"full";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:854737;s:10:"size_after";i:854737;s:4:"time";d:0.56;}}}');
INSERT INTO `wp_postmeta` VALUES (282,298,'_wp_attached_file','2023/04/Mitt-prosjekt-1.png');
INSERT INTO `wp_postmeta` VALUES (283,298,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:27:"2023/04/Mitt-prosjekt-1.png";s:8:"filesize";s:6:"849440";s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:27:"Mitt-prosjekt-1-300x300.png";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";s:8:"filesize";s:5:"75252";}s:9:"thumbnail";a:5:{s:4:"file";s:27:"Mitt-prosjekt-1-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";s:8:"filesize";s:5:"23822";}s:12:"medium_large";a:5:{s:4:"file";s:27:"Mitt-prosjekt-1-768x768.png";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:9:"image/png";s:8:"filesize";s:6:"402472";}}s:10:"image_meta";a:11:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";}}');
INSERT INTO `wp_postmeta` VALUES (284,298,'wp-smpro-smush-data','a:2:{s:5:"stats";a:8:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:1350986;s:10:"size_after";i:1350986;s:4:"time";d:1.2000000000000002;s:11:"api_version";s:3:"1.0";s:5:"lossy";b:0;s:9:"keep_exif";i:0;}s:5:"sizes";a:4:{s:9:"thumbnail";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:23822;s:10:"size_after";i:23822;s:4:"time";d:0.04;}s:6:"medium";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:75252;s:10:"size_after";i:75252;s:4:"time";d:0.2;}s:12:"medium_large";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:402472;s:10:"size_after";i:402472;s:4:"time";d:0.33;}s:4:"full";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:849440;s:10:"size_after";i:849440;s:4:"time";d:0.63;}}}');
INSERT INTO `wp_postmeta` VALUES (285,299,'_wp_attached_file','2023/04/MyOnlyEye_an_icon_of_a_crowd_studying_pixar_style_2f089151-6ea0-43c0-be30-d98c8ebd267e.jpg');
INSERT INTO `wp_postmeta` VALUES (286,299,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:98:"2023/04/MyOnlyEye_an_icon_of_a_crowd_studying_pixar_style_2f089151-6ea0-43c0-be30-d98c8ebd267e.jpg";s:8:"filesize";i:287992;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:98:"MyOnlyEye_an_icon_of_a_crowd_studying_pixar_style_2f089151-6ea0-43c0-be30-d98c8ebd267e-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:34604;}s:9:"thumbnail";a:5:{s:4:"file";s:98:"MyOnlyEye_an_icon_of_a_crowd_studying_pixar_style_2f089151-6ea0-43c0-be30-d98c8ebd267e-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:11269;}s:12:"medium_large";a:5:{s:4:"file";s:98:"MyOnlyEye_an_icon_of_a_crowd_studying_pixar_style_2f089151-6ea0-43c0-be30-d98c8ebd267e-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:134866;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (287,299,'wp-smpro-smush-data','a:2:{s:5:"stats";a:8:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:2541523;s:10:"size_after";i:2541523;s:4:"time";d:1.3599999999999999;s:11:"api_version";s:3:"1.0";s:5:"lossy";b:0;s:9:"keep_exif";i:0;}s:5:"sizes";a:4:{s:9:"thumbnail";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:51745;s:10:"size_after";i:51745;s:4:"time";d:0.02;}s:6:"medium";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:175795;s:10:"size_after";i:175795;s:4:"time";d:0.07;}s:12:"medium_large";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:922608;s:10:"size_after";i:922608;s:4:"time";d:0.69;}s:4:"full";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:1391375;s:10:"size_after";i:1391375;s:4:"time";d:0.58;}}}');
INSERT INTO `wp_postmeta` VALUES (300,304,'_wp_attached_file','2023/04/Mitt-prosjekt-5.jpg');
INSERT INTO `wp_postmeta` VALUES (301,304,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:27:"2023/04/Mitt-prosjekt-5.jpg";s:8:"filesize";i:150700;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:27:"Mitt-prosjekt-5-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:16844;}s:9:"thumbnail";a:5:{s:4:"file";s:27:"Mitt-prosjekt-5-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6158;}s:12:"medium_large";a:5:{s:4:"file";s:27:"Mitt-prosjekt-5-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:67201;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (302,304,'wp-smpro-smush-data','a:2:{s:5:"stats";a:8:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:1549554;s:10:"size_after";i:1549554;s:4:"time";d:0.73;s:11:"api_version";s:3:"1.0";s:5:"lossy";b:0;s:9:"keep_exif";i:0;}s:5:"sizes";a:4:{s:9:"thumbnail";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:29952;s:10:"size_after";i:29952;s:4:"time";d:0.02;}s:6:"medium";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:95283;s:10:"size_after";i:95283;s:4:"time";d:0.06;}s:12:"medium_large";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:477025;s:10:"size_after";i:477025;s:4:"time";d:0.25;}s:4:"full";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:947294;s:10:"size_after";i:947294;s:4:"time";d:0.4;}}}');
INSERT INTO `wp_postmeta` VALUES (303,3,'_edit_lock','1728907399:80');
INSERT INTO `wp_postmeta` VALUES (306,304,'_wp_attachment_image_alt','Mange voksne som leser i bøker.');
INSERT INTO `wp_postmeta` VALUES (310,299,'_wp_attachment_image_alt','Mange mennesker som leser bøker.');
INSERT INTO `wp_postmeta` VALUES (311,298,'_wp_attachment_image_alt','En bok med et stort øye.');
INSERT INTO `wp_postmeta` VALUES (313,258,'_wp_attachment_image_alt','To lærere');
INSERT INTO `wp_postmeta` VALUES (316,254,'_wp_attachment_image_alt','To lærere');
INSERT INTO `wp_postmeta` VALUES (317,253,'_wp_attachment_image_alt','To lærere');
INSERT INTO `wp_postmeta` VALUES (327,317,'_wp_attached_file','2023/04/MyOnlyEye_an_icon_of_a_casual_happy_crowd_studying_pixar_style_c7fc8092-3c0a-4429-8ecc-0ed8ff97ca21.jpg');
INSERT INTO `wp_postmeta` VALUES (328,317,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:111:"2023/04/MyOnlyEye_an_icon_of_a_casual_happy_crowd_studying_pixar_style_c7fc8092-3c0a-4429-8ecc-0ed8ff97ca21.jpg";s:8:"filesize";i:212083;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:111:"MyOnlyEye_an_icon_of_a_casual_happy_crowd_studying_pixar_style_c7fc8092-3c0a-4429-8ecc-0ed8ff97ca21-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:23102;}s:9:"thumbnail";a:5:{s:4:"file";s:111:"MyOnlyEye_an_icon_of_a_casual_happy_crowd_studying_pixar_style_c7fc8092-3c0a-4429-8ecc-0ed8ff97ca21-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:8209;}s:12:"medium_large";a:5:{s:4:"file";s:111:"MyOnlyEye_an_icon_of_a_casual_happy_crowd_studying_pixar_style_c7fc8092-3c0a-4429-8ecc-0ed8ff97ca21-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:91178;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (330,317,'wp-smpro-smush-data','a:2:{s:5:"stats";a:8:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:2022787;s:10:"size_after";i:2022787;s:4:"time";d:1.04;s:11:"api_version";s:3:"1.0";s:5:"lossy";b:0;s:9:"keep_exif";i:0;}s:5:"sizes";a:4:{s:9:"thumbnail";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:38345;s:10:"size_after";i:38345;s:4:"time";d:0.03;}s:6:"medium";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:130085;s:10:"size_after";i:130085;s:4:"time";d:0.09;}s:12:"medium_large";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:711679;s:10:"size_after";i:711679;s:4:"time";d:0.36;}s:4:"full";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:1142678;s:10:"size_after";i:1142678;s:4:"time";d:0.56;}}}');
INSERT INTO `wp_postmeta` VALUES (331,318,'_wp_attached_file','2023/04/MyOnlyEye_casual_happy_crowd_studying_with_laptops_pixar_style_11b64b1c-8b53-4993-8750-2c1ca85f87a9.jpg');
INSERT INTO `wp_postmeta` VALUES (332,318,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:111:"2023/04/MyOnlyEye_casual_happy_crowd_studying_with_laptops_pixar_style_11b64b1c-8b53-4993-8750-2c1ca85f87a9.jpg";s:8:"filesize";i:247023;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:111:"MyOnlyEye_casual_happy_crowd_studying_with_laptops_pixar_style_11b64b1c-8b53-4993-8750-2c1ca85f87a9-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:30948;}s:9:"thumbnail";a:5:{s:4:"file";s:111:"MyOnlyEye_casual_happy_crowd_studying_with_laptops_pixar_style_11b64b1c-8b53-4993-8750-2c1ca85f87a9-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:10721;}s:12:"medium_large";a:5:{s:4:"file";s:111:"MyOnlyEye_casual_happy_crowd_studying_with_laptops_pixar_style_11b64b1c-8b53-4993-8750-2c1ca85f87a9-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:114754;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (334,318,'wp-smpro-smush-data','a:2:{s:5:"stats";a:8:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:1909446;s:10:"size_after";i:1909446;s:4:"time";d:4.08;s:11:"api_version";s:3:"1.0";s:5:"lossy";b:0;s:9:"keep_exif";i:0;}s:5:"sizes";a:4:{s:9:"thumbnail";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:36702;s:10:"size_after";i:36702;s:4:"time";d:0.02;}s:6:"medium";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:124530;s:10:"size_after";i:124530;s:4:"time";d:0.09;}s:12:"medium_large";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:674307;s:10:"size_after";i:674307;s:4:"time";d:1.37;}s:4:"full";O:8:"stdClass":5:{s:7:"percent";i:0;s:5:"bytes";i:0;s:11:"size_before";i:1073907;s:10:"size_after";i:1073907;s:4:"time";d:2.6;}}}');
INSERT INTO `wp_postmeta` VALUES (375,383,'_wp_attached_file','2023/04/Mitt-prosjekt-6.jpg');
INSERT INTO `wp_postmeta` VALUES (376,383,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:27:"2023/04/Mitt-prosjekt-6.jpg";s:8:"filesize";i:129490;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:27:"Mitt-prosjekt-6-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:14782;}s:9:"thumbnail";a:5:{s:4:"file";s:27:"Mitt-prosjekt-6-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:5415;}s:12:"medium_large";a:5:{s:4:"file";s:27:"Mitt-prosjekt-6-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:57088;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (377,383,'_wp_attachment_image_alt','Marvin the paranoid android');
INSERT INTO `wp_postmeta` VALUES (389,406,'_wp_attached_file','2023/04/MyOnlyEye_an_icon_of_a_female_egg_causal_happy_pixar_style_36387029-e099-4b05-8927-eeb82fb21249.jpg');
INSERT INTO `wp_postmeta` VALUES (390,406,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:107:"2023/04/MyOnlyEye_an_icon_of_a_female_egg_causal_happy_pixar_style_36387029-e099-4b05-8927-eeb82fb21249.jpg";s:8:"filesize";i:252017;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:107:"MyOnlyEye_an_icon_of_a_female_egg_causal_happy_pixar_style_36387029-e099-4b05-8927-eeb82fb21249-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:25253;}s:9:"thumbnail";a:5:{s:4:"file";s:107:"MyOnlyEye_an_icon_of_a_female_egg_causal_happy_pixar_style_36387029-e099-4b05-8927-eeb82fb21249-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:8429;}s:12:"medium_large";a:5:{s:4:"file";s:107:"MyOnlyEye_an_icon_of_a_female_egg_causal_happy_pixar_style_36387029-e099-4b05-8927-eeb82fb21249-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:107066;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (391,406,'_wp_attachment_image_alt','Et egg');
INSERT INTO `wp_postmeta` VALUES (400,253,'_wp_attachment_backup_sizes','a:4:{s:9:"full-orig";a:3:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:19:"Mitt-prosjekt-8.png";}s:14:"thumbnail-orig";a:5:{s:4:"file";s:27:"Mitt-prosjekt-8-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";s:8:"filesize";s:5:"22979";}s:11:"medium-orig";a:5:{s:4:"file";s:27:"Mitt-prosjekt-8-300x300.png";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";s:8:"filesize";s:5:"74117";}s:17:"medium_large-orig";a:5:{s:4:"file";s:27:"Mitt-prosjekt-8-768x768.png";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:9:"image/png";s:8:"filesize";s:6:"403103";}}');
INSERT INTO `wp_postmeta` VALUES (425,72,'_wp_attachment_image_alt','En gutt');
INSERT INTO `wp_postmeta` VALUES (431,71,'_wp_attachment_image_alt','Sokrates');
INSERT INTO `wp_postmeta` VALUES (449,517,'_wp_attached_file','2023/04/by-nc-sa.png');
INSERT INTO `wp_postmeta` VALUES (450,517,'_wp_attachment_metadata','a:6:{s:5:"width";i:403;s:6:"height";i:141;s:4:"file";s:20:"2023/04/by-nc-sa.png";s:8:"filesize";i:22475;s:5:"sizes";a:2:{s:6:"medium";a:5:{s:4:"file";s:20:"by-nc-sa-300x105.png";s:5:"width";i:300;s:6:"height";i:105;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:22954;}s:9:"thumbnail";a:5:{s:4:"file";s:20:"by-nc-sa-150x141.png";s:5:"width";i:150;s:6:"height";i:141;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:8287;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (459,517,'_wp_attachment_image_alt','CC-BY-NC-SA');
INSERT INTO `wp_postmeta` VALUES (467,533,'_wp_attached_file','2023/04/MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985.jpg');
INSERT INTO `wp_postmeta` VALUES (468,533,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:97:"2023/04/MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985.jpg";s:8:"filesize";i:223362;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:97:"MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:15077;}s:9:"thumbnail";a:5:{s:4:"file";s:97:"MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:5237;}s:12:"medium_large";a:5:{s:4:"file";s:97:"MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:72100;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (469,533,'_wp_attachment_image_alt','En ukjent mann.');
INSERT INTO `wp_postmeta` VALUES (470,536,'_wp_attached_file','2023/04/MyOnlyEye_a_glass_ball_of_words_pixar_style_48ba36fd-5c63-4416-b4ea-1a41e8efbe14.jpg');
INSERT INTO `wp_postmeta` VALUES (471,536,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:92:"2023/04/MyOnlyEye_a_glass_ball_of_words_pixar_style_48ba36fd-5c63-4416-b4ea-1a41e8efbe14.jpg";s:8:"filesize";i:211991;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:92:"MyOnlyEye_a_glass_ball_of_words_pixar_style_48ba36fd-5c63-4416-b4ea-1a41e8efbe14-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:23316;}s:9:"thumbnail";a:5:{s:4:"file";s:92:"MyOnlyEye_a_glass_ball_of_words_pixar_style_48ba36fd-5c63-4416-b4ea-1a41e8efbe14-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:7720;}s:12:"medium_large";a:5:{s:4:"file";s:92:"MyOnlyEye_a_glass_ball_of_words_pixar_style_48ba36fd-5c63-4416-b4ea-1a41e8efbe14-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:94714;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (472,536,'_wp_attachment_image_alt','En glassball med tegn');
INSERT INTO `wp_postmeta` VALUES (473,554,'_edit_lock','1731972876:80');
INSERT INTO `wp_postmeta` VALUES (474,554,'_thumbnail_id','298');
INSERT INTO `wp_postmeta` VALUES (475,554,'_oembed_3de4418c2d8aaeadc22e48766c4abc08','{{unknown}}');
INSERT INTO `wp_postmeta` VALUES (483,585,'_wp_attached_file','2023/05/MyOnlyEye_a_female_and_male_teacher_giving_feedback_casual_happ_ba954a98-7956-40a0-9a6a-a1cb175102ca.jpg');
INSERT INTO `wp_postmeta` VALUES (484,585,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:112:"2023/05/MyOnlyEye_a_female_and_male_teacher_giving_feedback_casual_happ_ba954a98-7956-40a0-9a6a-a1cb175102ca.jpg";s:8:"filesize";i:242415;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:112:"MyOnlyEye_a_female_and_male_teacher_giving_feedback_casual_happ_ba954a98-7956-40a0-9a6a-a1cb175102ca-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:24824;}s:9:"thumbnail";a:5:{s:4:"file";s:112:"MyOnlyEye_a_female_and_male_teacher_giving_feedback_casual_happ_ba954a98-7956-40a0-9a6a-a1cb175102ca-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:8224;}s:12:"medium_large";a:5:{s:4:"file";s:112:"MyOnlyEye_a_female_and_male_teacher_giving_feedback_casual_happ_ba954a98-7956-40a0-9a6a-a1cb175102ca-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:103839;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (485,586,'_wp_attached_file','2023/05/MyOnlyEye_an_AI_talking_to_a_boy_and_a_girl_casual_happy_pixar__372a0b04-1764-436b-9b88-ff16d4ebd29d.jpg');
INSERT INTO `wp_postmeta` VALUES (486,586,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:112:"2023/05/MyOnlyEye_an_AI_talking_to_a_boy_and_a_girl_casual_happy_pixar__372a0b04-1764-436b-9b88-ff16d4ebd29d.jpg";s:8:"filesize";i:204386;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:112:"MyOnlyEye_an_AI_talking_to_a_boy_and_a_girl_casual_happy_pixar__372a0b04-1764-436b-9b88-ff16d4ebd29d-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:21421;}s:9:"thumbnail";a:5:{s:4:"file";s:112:"MyOnlyEye_an_AI_talking_to_a_boy_and_a_girl_casual_happy_pixar__372a0b04-1764-436b-9b88-ff16d4ebd29d-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:7321;}s:12:"medium_large";a:5:{s:4:"file";s:112:"MyOnlyEye_an_AI_talking_to_a_boy_and_a_girl_casual_happy_pixar__372a0b04-1764-436b-9b88-ff16d4ebd29d-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:89404;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (488,617,'_wp_attached_file','2023/05/MyOnlyEye_behind_the_curtains_pixar_style_e38be4a1-346e-46a9-b376-bd4f0be78708-e1684924115381.jpg');
INSERT INTO `wp_postmeta` VALUES (489,617,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:105:"2023/05/MyOnlyEye_behind_the_curtains_pixar_style_e38be4a1-346e-46a9-b376-bd4f0be78708-e1684924115381.jpg";s:8:"filesize";i:275309;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:105:"MyOnlyEye_behind_the_curtains_pixar_style_e38be4a1-346e-46a9-b376-bd4f0be78708-e1684924115381-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:27510;}s:9:"thumbnail";a:5:{s:4:"file";s:105:"MyOnlyEye_behind_the_curtains_pixar_style_e38be4a1-346e-46a9-b376-bd4f0be78708-e1684924115381-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:8666;}s:12:"medium_large";a:5:{s:4:"file";s:105:"MyOnlyEye_behind_the_curtains_pixar_style_e38be4a1-346e-46a9-b376-bd4f0be78708-e1684924115381-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:115924;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (492,617,'_wp_attachment_image_alt','Bak sceneteppet');
INSERT INTO `wp_postmeta` VALUES (494,617,'_wp_attachment_backup_sizes','a:5:{s:9:"full-orig";a:3:{s:5:"width";i:1456;s:6:"height";i:816;s:4:"file";s:82:"MyOnlyEye_behind_the_curtains_pixar_style_e38be4a1-346e-46a9-b376-bd4f0be78708.png";}s:14:"thumbnail-orig";a:5:{s:4:"file";s:90:"MyOnlyEye_behind_the_curtains_pixar_style_e38be4a1-346e-46a9-b376-bd4f0be78708-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:34732;}s:11:"medium-orig";a:5:{s:4:"file";s:90:"MyOnlyEye_behind_the_curtains_pixar_style_e38be4a1-346e-46a9-b376-bd4f0be78708-300x168.png";s:5:"width";i:300;s:6:"height";i:168;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:69004;}s:17:"medium_large-orig";a:5:{s:4:"file";s:90:"MyOnlyEye_behind_the_curtains_pixar_style_e38be4a1-346e-46a9-b376-bd4f0be78708-768x430.png";s:5:"width";i:768;s:6:"height";i:430;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:400944;}s:10:"large-orig";a:5:{s:4:"file";s:91:"MyOnlyEye_behind_the_curtains_pixar_style_e38be4a1-346e-46a9-b376-bd4f0be78708-1024x574.png";s:5:"width";i:1024;s:6:"height";i:574;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:685511;}}');
INSERT INTO `wp_postmeta` VALUES (510,678,'_edit_lock','1699344621:1');
INSERT INTO `wp_postmeta` VALUES (515,682,'_wp_attached_file','2023/06/by-nc-sa.png');
INSERT INTO `wp_postmeta` VALUES (516,682,'_wp_attachment_metadata','a:6:{s:5:"width";i:267;s:6:"height";i:50;s:4:"file";s:20:"2023/06/by-nc-sa.png";s:8:"filesize";i:5724;s:5:"sizes";a:1:{s:9:"thumbnail";a:5:{s:4:"file";s:19:"by-nc-sa-150x50.png";s:5:"width";i:150;s:6:"height";i:50;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:3365;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (518,713,'_wp_attached_file','2023/06/Mitt-prosjekt.jpg');
INSERT INTO `wp_postmeta` VALUES (519,713,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:25:"2023/06/Mitt-prosjekt.jpg";s:8:"filesize";i:312503;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:25:"Mitt-prosjekt-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:30534;}s:9:"thumbnail";a:5:{s:4:"file";s:25:"Mitt-prosjekt-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:9555;}s:12:"medium_large";a:5:{s:4:"file";s:25:"Mitt-prosjekt-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:130115;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (523,713,'_wp_attachment_image_alt','micro:bit med øyne');
INSERT INTO `wp_postmeta` VALUES (524,716,'_wpcode_auto_insert','1');
INSERT INTO `wp_postmeta` VALUES (525,716,'_wpcode_auto_insert_number','1');
INSERT INTO `wp_postmeta` VALUES (526,717,'_wpcode_auto_insert','1');
INSERT INTO `wp_postmeta` VALUES (527,717,'_wpcode_library_id','12');
INSERT INTO `wp_postmeta` VALUES (528,718,'_wpcode_auto_insert','1');
INSERT INTO `wp_postmeta` VALUES (529,718,'_wpcode_auto_insert_number','1');
INSERT INTO `wp_postmeta` VALUES (530,718,'_wpcode_conditional_logic_enabled','');
INSERT INTO `wp_postmeta` VALUES (531,718,'_wpcode_priority','10');
INSERT INTO `wp_postmeta` VALUES (532,718,'_wpcode_note','');
INSERT INTO `wp_postmeta` VALUES (533,718,'_wpcode_location_extra','');
INSERT INTO `wp_postmeta` VALUES (534,718,'_wpcode_shortcode_attributes','a:0:{}');
INSERT INTO `wp_postmeta` VALUES (535,719,'_wpcode_auto_insert','1');
INSERT INTO `wp_postmeta` VALUES (536,719,'_wpcode_auto_insert_number','1');
INSERT INTO `wp_postmeta` VALUES (537,719,'_wpcode_conditional_logic_enabled','');
INSERT INTO `wp_postmeta` VALUES (538,719,'_wpcode_priority','10');
INSERT INTO `wp_postmeta` VALUES (539,719,'_wpcode_note','');
INSERT INTO `wp_postmeta` VALUES (540,719,'_wpcode_location_extra','');
INSERT INTO `wp_postmeta` VALUES (541,719,'_wpcode_shortcode_attributes','a:0:{}');
INSERT INTO `wp_postmeta` VALUES (560,765,'_wp_attached_file','2023/08/myonlyeye_swahili_casual_happy_pixar_style_white_background_c1b50d77-50ba-4adf-bbdb-8262539a3260.jpg');
INSERT INTO `wp_postmeta` VALUES (561,765,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:108:"2023/08/myonlyeye_swahili_casual_happy_pixar_style_white_background_c1b50d77-50ba-4adf-bbdb-8262539a3260.jpg";s:8:"filesize";i:196546;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:108:"myonlyeye_swahili_casual_happy_pixar_style_white_background_c1b50d77-50ba-4adf-bbdb-8262539a3260-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:24381;}s:9:"thumbnail";a:5:{s:4:"file";s:108:"myonlyeye_swahili_casual_happy_pixar_style_white_background_c1b50d77-50ba-4adf-bbdb-8262539a3260-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:8621;}s:12:"medium_large";a:5:{s:4:"file";s:108:"myonlyeye_swahili_casual_happy_pixar_style_white_background_c1b50d77-50ba-4adf-bbdb-8262539a3260-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:90703;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (574,554,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (575,554,'_edit_last','1');
INSERT INTO `wp_postmeta` VALUES (594,585,'_wp_attachment_image_alt','To lærere');
INSERT INTO `wp_postmeta` VALUES (613,855,'_wp_attached_file','2023/08/myonlyeye_a_very_polite_writer_pixar_style_white_background_2e9f7252-0cb8-47ae-aa4d-80289454d2b3.jpg');
INSERT INTO `wp_postmeta` VALUES (614,855,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:108:"2023/08/myonlyeye_a_very_polite_writer_pixar_style_white_background_2e9f7252-0cb8-47ae-aa4d-80289454d2b3.jpg";s:8:"filesize";i:236486;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:108:"myonlyeye_a_very_polite_writer_pixar_style_white_background_2e9f7252-0cb8-47ae-aa4d-80289454d2b3-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:25440;}s:9:"thumbnail";a:5:{s:4:"file";s:108:"myonlyeye_a_very_polite_writer_pixar_style_white_background_2e9f7252-0cb8-47ae-aa4d-80289454d2b3-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:8332;}s:12:"medium_large";a:5:{s:4:"file";s:108:"myonlyeye_a_very_polite_writer_pixar_style_white_background_2e9f7252-0cb8-47ae-aa4d-80289454d2b3-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:104967;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (617,857,'_wp_attached_file','2023/08/myonlyeye_a_polite_butler_carrying_a_scroll_pixar_style_white_b_de12e82c-1869-452f-b2a7-b012d7103c7a.jpg');
INSERT INTO `wp_postmeta` VALUES (618,857,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:112:"2023/08/myonlyeye_a_polite_butler_carrying_a_scroll_pixar_style_white_b_de12e82c-1869-452f-b2a7-b012d7103c7a.jpg";s:8:"filesize";i:144387;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:112:"myonlyeye_a_polite_butler_carrying_a_scroll_pixar_style_white_b_de12e82c-1869-452f-b2a7-b012d7103c7a-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:17533;}s:9:"thumbnail";a:5:{s:4:"file";s:112:"myonlyeye_a_polite_butler_carrying_a_scroll_pixar_style_white_b_de12e82c-1869-452f-b2a7-b012d7103c7a-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6477;}s:12:"medium_large";a:5:{s:4:"file";s:112:"myonlyeye_a_polite_butler_carrying_a_scroll_pixar_style_white_b_de12e82c-1869-452f-b2a7-b012d7103c7a-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:65070;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (619,857,'_wp_attachment_image_alt','Høflig butler med en tekstrull');
INSERT INTO `wp_postmeta` VALUES (628,855,'_wp_attachment_image_alt','En person som skriver i en bok');
INSERT INTO `wp_postmeta` VALUES (632,765,'_wp_attachment_image_alt','En elev');
INSERT INTO `wp_postmeta` VALUES (650,217,'_wp_attachment_image_alt','Collage av folk som skriver');
INSERT INTO `wp_postmeta` VALUES (674,891,'_edit_lock','1762930678:80');
INSERT INTO `wp_postmeta` VALUES (676,891,'_thumbnail_id','1241');
INSERT INTO `wp_postmeta` VALUES (677,891,'_edit_last','80');
INSERT INTO `wp_postmeta` VALUES (682,896,'origin','theme');
INSERT INTO `wp_postmeta` VALUES (683,897,'origin','theme');
INSERT INTO `wp_postmeta` VALUES (700,216,'_wp_attachment_image_alt','Skriveøkt rundt et bord');
INSERT INTO `wp_postmeta` VALUES (713,586,'_wp_attachment_image_alt','En robot som snakker med to elever');
INSERT INTO `wp_postmeta` VALUES (772,891,'_wp_page_template','default');
INSERT INTO `wp_postmeta` VALUES (785,891,'_wp_old_date','2023-09-04');
INSERT INTO `wp_postmeta` VALUES (816,966,'_edit_lock','1742203146:80');
INSERT INTO `wp_postmeta` VALUES (817,318,'_wp_attachment_image_alt','Elever i gruppe');
INSERT INTO `wp_postmeta` VALUES (819,966,'_thumbnail_id','1258');
INSERT INTO `wp_postmeta` VALUES (820,966,'_edit_last','1');
INSERT INTO `wp_postmeta` VALUES (821,968,'_edit_lock','1742203249:80');
INSERT INTO `wp_postmeta` VALUES (823,968,'_thumbnail_id','1253');
INSERT INTO `wp_postmeta` VALUES (824,968,'_edit_last','1');
INSERT INTO `wp_postmeta` VALUES (829,972,'_edit_lock','1731926927:80');
INSERT INTO `wp_postmeta` VALUES (832,972,'_edit_last','1');
INSERT INTO `wp_postmeta` VALUES (833,974,'_edit_lock','1742203185:80');
INSERT INTO `wp_postmeta` VALUES (835,974,'_thumbnail_id','1260');
INSERT INTO `wp_postmeta` VALUES (836,974,'_edit_last','1');
INSERT INTO `wp_postmeta` VALUES (842,979,'_edit_lock','1762930557:80');
INSERT INTO `wp_postmeta` VALUES (843,979,'_oembed_623dde6e09951835af1cf03e3697f987','{{unknown}}');
INSERT INTO `wp_postmeta` VALUES (844,979,'_oembed_time_623dde6e09951835af1cf03e3697f987','1702907911');
INSERT INTO `wp_postmeta` VALUES (845,979,'_oembed_85c3222700219dd4720f47700da440c8','<iframe title="AI i Randabergskolen - Hvordan virker en språkmodell?" width="500" height="281" src="https://www.youtube.com/embed/w5YG5QIDTjA?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>');
INSERT INTO `wp_postmeta` VALUES (846,979,'_oembed_time_85c3222700219dd4720f47700da440c8','1699344846');
INSERT INTO `wp_postmeta` VALUES (847,979,'_oembed_9c21f61a957b282187faee5363b20bf7','<iframe title="AI i Randabergskolen - Skadepotensiale eller nytteverdi?" width="500" height="281" src="https://www.youtube.com/embed/vL-66LeC-m4?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>');
INSERT INTO `wp_postmeta` VALUES (848,979,'_oembed_time_9c21f61a957b282187faee5363b20bf7','1711655352');
INSERT INTO `wp_postmeta` VALUES (850,979,'_thumbnail_id','536');
INSERT INTO `wp_postmeta` VALUES (851,979,'_edit_last','1');
INSERT INTO `wp_postmeta` VALUES (852,981,'_edit_lock','1742203205:80');
INSERT INTO `wp_postmeta` VALUES (856,981,'_edit_last','1');
INSERT INTO `wp_postmeta` VALUES (857,983,'_edit_lock','1742203225:80');
INSERT INTO `wp_postmeta` VALUES (859,983,'_thumbnail_id','1259');
INSERT INTO `wp_postmeta` VALUES (860,983,'_edit_last','1');
INSERT INTO `wp_postmeta` VALUES (865,966,'_wp_page_template','default');
INSERT INTO `wp_postmeta` VALUES (867,979,'_wp_page_template','default');
INSERT INTO `wp_postmeta` VALUES (869,972,'_wp_page_template','default');
INSERT INTO `wp_postmeta` VALUES (871,983,'_wp_page_template','default');
INSERT INTO `wp_postmeta` VALUES (873,981,'_wp_page_template','default');
INSERT INTO `wp_postmeta` VALUES (875,968,'_wp_page_template','default');
INSERT INTO `wp_postmeta` VALUES (882,891,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (927,979,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (929,254,'_wp_attachment_backup_sizes','a:4:{s:9:"full-orig";a:3:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:21:"Mitt-prosjekt-1-2.png";}s:14:"thumbnail-orig";a:5:{s:4:"file";s:29:"Mitt-prosjekt-1-2-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";s:8:"filesize";s:5:"17354";}s:11:"medium-orig";a:5:{s:4:"file";s:29:"Mitt-prosjekt-1-2-300x300.png";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";s:8:"filesize";s:5:"55107";}s:17:"medium_large-orig";a:5:{s:4:"file";s:29:"Mitt-prosjekt-1-2-768x768.png";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:9:"image/png";s:8:"filesize";s:6:"273598";}}');
INSERT INTO `wp_postmeta` VALUES (967,72,'_media_version','3');
INSERT INTO `wp_postmeta` VALUES (968,71,'_media_version','3');
INSERT INTO `wp_postmeta` VALUES (969,216,'_media_version','3');
INSERT INTO `wp_postmeta` VALUES (971,857,'_media_version','2');
INSERT INTO `wp_postmeta` VALUES (972,855,'_media_version','2');
INSERT INTO `wp_postmeta` VALUES (973,765,'_media_version','2');
INSERT INTO `wp_postmeta` VALUES (974,586,'_media_version','2');
INSERT INTO `wp_postmeta` VALUES (975,383,'_media_version','2');
INSERT INTO `wp_postmeta` VALUES (976,253,'_media_version','4');
INSERT INTO `wp_postmeta` VALUES (977,74,'_media_version','2');
INSERT INTO `wp_postmeta` VALUES (978,254,'_media_version','2');
INSERT INTO `wp_postmeta` VALUES (979,617,'_media_version','2');
INSERT INTO `wp_postmeta` VALUES (980,1027,'_wp_attached_file','2023/09/myonlyeye_a_dragon_style_of_Don_Bluth_flat_animation_Disneys_Fa_4726194e-3717-4a56-adce-33c7ff7ee0e6.jpg');
INSERT INTO `wp_postmeta` VALUES (981,1027,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:112:"2023/09/myonlyeye_a_dragon_style_of_Don_Bluth_flat_animation_Disneys_Fa_4726194e-3717-4a56-adce-33c7ff7ee0e6.jpg";s:8:"filesize";i:310807;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:112:"myonlyeye_a_dragon_style_of_Don_Bluth_flat_animation_Disneys_Fa_4726194e-3717-4a56-adce-33c7ff7ee0e6-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:25457;}s:9:"thumbnail";a:5:{s:4:"file";s:112:"myonlyeye_a_dragon_style_of_Don_Bluth_flat_animation_Disneys_Fa_4726194e-3717-4a56-adce-33c7ff7ee0e6-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:8441;}s:12:"medium_large";a:5:{s:4:"file";s:112:"myonlyeye_a_dragon_style_of_Don_Bluth_flat_animation_Disneys_Fa_4726194e-3717-4a56-adce-33c7ff7ee0e6-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:115487;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (982,1027,'_wp_attachment_image_alt','En drage');
INSERT INTO `wp_postmeta` VALUES (984,972,'_thumbnail_id','1027');
INSERT INTO `wp_postmeta` VALUES (985,1028,'_wp_attached_file','2023/09/myonlyeye_a_female_pupil_using_a_laptop_style_of_Don_Bluth_flat_52967297-4442-4f18-9fbc-63ad285423cc.jpg');
INSERT INTO `wp_postmeta` VALUES (986,1028,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:112:"2023/09/myonlyeye_a_female_pupil_using_a_laptop_style_of_Don_Bluth_flat_52967297-4442-4f18-9fbc-63ad285423cc.jpg";s:8:"filesize";i:138798;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:112:"myonlyeye_a_female_pupil_using_a_laptop_style_of_Don_Bluth_flat_52967297-4442-4f18-9fbc-63ad285423cc-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:16878;}s:9:"thumbnail";a:5:{s:4:"file";s:112:"myonlyeye_a_female_pupil_using_a_laptop_style_of_Don_Bluth_flat_52967297-4442-4f18-9fbc-63ad285423cc-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6187;}s:12:"medium_large";a:5:{s:4:"file";s:112:"myonlyeye_a_female_pupil_using_a_laptop_style_of_Don_Bluth_flat_52967297-4442-4f18-9fbc-63ad285423cc-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:63591;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (987,1028,'_wp_attachment_image_alt','En jente som jobber på en laptop.');
INSERT INTO `wp_postmeta` VALUES (989,981,'_thumbnail_id','1261');
INSERT INTO `wp_postmeta` VALUES (990,1030,'_wp_attached_file','2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe.jpg');
INSERT INTO `wp_postmeta` VALUES (991,1030,'_wp_attachment_metadata','a:6:{s:5:"width";i:1456;s:6:"height";i:816;s:4:"file";s:112:"2023/09/myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe.jpg";s:8:"filesize";i:392374;s:5:"sizes";a:4:{s:6:"medium";a:5:{s:4:"file";s:112:"myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe-300x168.jpg";s:5:"width";i:300;s:6:"height";i:168;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:21966;}s:5:"large";a:5:{s:4:"file";s:113:"myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe-1024x574.jpg";s:5:"width";i:1024;s:6:"height";i:574;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:159735;}s:9:"thumbnail";a:5:{s:4:"file";s:112:"myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:10160;}s:12:"medium_large";a:5:{s:4:"file";s:112:"myonlyeye_a_close_up_of_a_computer_board_style_of_Don_Bluth_fla_79a2b9dd-7c7d-4ef6-8a88-8d3edb5f49fe-768x430.jpg";s:5:"width";i:768;s:6:"height";i:430;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:103006;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (997,585,'_media_version','2');
INSERT INTO `wp_postmeta` VALUES (998,406,'_media_version','2');
INSERT INTO `wp_postmeta` VALUES (999,318,'_media_version','3');
INSERT INTO `wp_postmeta` VALUES (1000,304,'_media_version','3');
INSERT INTO `wp_postmeta` VALUES (1003,258,'_media_version','2');
INSERT INTO `wp_postmeta` VALUES (1004,713,'_media_version','2');
INSERT INTO `wp_postmeta` VALUES (1009,972,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1033,979,'_wp_old_slug','pa-hvilken-mate-er-chatgpt-intelligent-videoutgaven');
INSERT INTO `wp_postmeta` VALUES (1039,968,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1041,1058,'_edit_lock','1699533566:80');
INSERT INTO `wp_postmeta` VALUES (1044,1058,'_wp_old_date','2023-11-09');
INSERT INTO `wp_postmeta` VALUES (1045,1060,'_wp_attached_file','2022/11/MyOnlyEye_an_icon_of_a_treasure_chest_style_pixar_1eb7d463-3c47-4398-9640-41aa4e54bc21.jpg');
INSERT INTO `wp_postmeta` VALUES (1046,1060,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:98:"2022/11/MyOnlyEye_an_icon_of_a_treasure_chest_style_pixar_1eb7d463-3c47-4398-9640-41aa4e54bc21.jpg";s:8:"filesize";i:255704;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:98:"MyOnlyEye_an_icon_of_a_treasure_chest_style_pixar_1eb7d463-3c47-4398-9640-41aa4e54bc21-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:19859;}s:9:"thumbnail";a:5:{s:4:"file";s:98:"MyOnlyEye_an_icon_of_a_treasure_chest_style_pixar_1eb7d463-3c47-4398-9640-41aa4e54bc21-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6879;}s:12:"medium_large";a:5:{s:4:"file";s:98:"MyOnlyEye_an_icon_of_a_treasure_chest_style_pixar_1eb7d463-3c47-4398-9640-41aa4e54bc21-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:85370;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1047,1060,'_wp_attachment_image_alt','Skattkisten');
INSERT INTO `wp_postmeta` VALUES (1049,1058,'_thumbnail_id','1060');
INSERT INTO `wp_postmeta` VALUES (1050,1058,'_edit_last','80');
INSERT INTO `wp_postmeta` VALUES (1051,1058,'_wp_page_template','default');
INSERT INTO `wp_postmeta` VALUES (1058,1060,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1061,1030,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1062,1028,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1063,1027,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1064,857,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1065,855,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1066,765,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1067,713,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1068,682,'transparency','1');
INSERT INTO `wp_postmeta` VALUES (1069,617,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1070,586,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1071,585,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1072,536,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1073,533,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1075,517,'transparency','1');
INSERT INTO `wp_postmeta` VALUES (1076,406,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1077,383,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1081,318,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1082,317,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1083,304,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1084,299,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1085,298,'transparency','1');
INSERT INTO `wp_postmeta` VALUES (1086,258,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1087,254,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1088,253,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1089,217,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1090,216,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1091,74,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1092,72,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1093,71,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1094,1060,'png_converted','89728');
INSERT INTO `wp_postmeta` VALUES (1096,1030,'png_converted','1442241');
INSERT INTO `wp_postmeta` VALUES (1097,1028,'png_converted','935463');
INSERT INTO `wp_postmeta` VALUES (1098,1027,'png_converted','1372418');
INSERT INTO `wp_postmeta` VALUES (1099,857,'png_converted','800636');
INSERT INTO `wp_postmeta` VALUES (1100,855,'png_converted','1045194');
INSERT INTO `wp_postmeta` VALUES (1101,765,'png_converted','954633');
INSERT INTO `wp_postmeta` VALUES (1102,713,'png_converted','928461');
INSERT INTO `wp_postmeta` VALUES (1103,617,'png_converted','1194051');
INSERT INTO `wp_postmeta` VALUES (1104,586,'png_converted','987799');
INSERT INTO `wp_postmeta` VALUES (1105,585,'png_converted','1030670');
INSERT INTO `wp_postmeta` VALUES (1106,536,'png_converted','1021532');
INSERT INTO `wp_postmeta` VALUES (1107,533,'png_converted','1276664');
INSERT INTO `wp_postmeta` VALUES (1108,406,'png_converted','945759');
INSERT INTO `wp_postmeta` VALUES (1109,383,'png_converted','677747');
INSERT INTO `wp_postmeta` VALUES (1110,318,'png_converted','1060413');
INSERT INTO `wp_postmeta` VALUES (1111,317,'png_converted','930595');
INSERT INTO `wp_postmeta` VALUES (1112,304,'png_converted','852841');
INSERT INTO `wp_postmeta` VALUES (1113,299,'png_converted','1103383');
INSERT INTO `wp_postmeta` VALUES (1114,258,'png_converted','861833');
INSERT INTO `wp_postmeta` VALUES (1115,254,'png_converted','574652');
INSERT INTO `wp_postmeta` VALUES (1116,253,'png_converted','847864');
INSERT INTO `wp_postmeta` VALUES (1117,217,'png_converted','1206980');
INSERT INTO `wp_postmeta` VALUES (1118,216,'png_converted','1200442');
INSERT INTO `wp_postmeta` VALUES (1119,72,'png_converted','1029422');
INSERT INTO `wp_postmeta` VALUES (1120,71,'png_converted','930251');
INSERT INTO `wp_postmeta` VALUES (1122,9,'_ca_taxonomy','-1');
INSERT INTO `wp_postmeta` VALUES (1124,1071,'_ca_taxonomy','-1');
INSERT INTO `wp_postmeta` VALUES (1126,979,'_oembed_821bf891802171cfa88ea4aee5e90bdc','<iframe title="KI i Randabergskolen - Hvordan virker en språkmodell" width="500" height="281" src="https://www.youtube.com/embed/Nja5FYCLwjY?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>');
INSERT INTO `wp_postmeta` VALUES (1127,979,'_oembed_time_821bf891802171cfa88ea4aee5e90bdc','1711655351');
INSERT INTO `wp_postmeta` VALUES (1129,1080,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1149,891,'_wp_old_slug','ai-en-flink-og-hjelpsom-chatbot');
INSERT INTO `wp_postmeta` VALUES (1150,1094,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1195,1115,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1225,1136,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1229,9,'_ca_taxonomy','-1');
INSERT INTO `wp_postmeta` VALUES (1230,1071,'_ca_taxonomy','-1');
INSERT INTO `wp_postmeta` VALUES (1231,1070,'_edit_lock','1713366044:80');
INSERT INTO `wp_postmeta` VALUES (1232,1070,'_edit_last','80');
INSERT INTO `wp_postmeta` VALUES (1233,1070,'_ca_handle','0');
INSERT INTO `wp_postmeta` VALUES (1234,1070,'_ca_page','678');
INSERT INTO `wp_postmeta` VALUES (1235,1070,'_ca_duration','a:2:{s:5:"count";s:1:"0";s:4:"unit";s:3:"day";}');
INSERT INTO `wp_postmeta` VALUES (1236,1070,'_ca_caps','a:0:{}');
INSERT INTO `wp_postmeta` VALUES (1237,1070,'_ca_hide_admin_bar','1');
INSERT INTO `wp_postmeta` VALUES (1238,1070,'_ca_default_access','1');
INSERT INTO `wp_postmeta` VALUES (1239,1070,'_ca_admin_access','0');
INSERT INTO `wp_postmeta` VALUES (1240,1070,'_ca_member_automations','a:1:{i:0;a:2:{s:4:"name";s:14:"user_role_sync";s:5:"value";s:11:"contributor";}}');
INSERT INTO `wp_postmeta` VALUES (1241,979,'_oembed_43ee3537fe753e22c9c5e7779efd2d40','<iframe title="KI i Randabergskolen - Hva er kunstig intelligens?" width="500" height="281" src="https://www.youtube.com/embed/hSL-Urwy5us?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>');
INSERT INTO `wp_postmeta` VALUES (1242,979,'_oembed_time_43ee3537fe753e22c9c5e7779efd2d40','1715447180');
INSERT INTO `wp_postmeta` VALUES (1243,979,'_oembed_6bc1a5bba9249ed307823039777af077','<iframe title="KI i Randabergskolen - Hvordan virker en språkmodell" width="500" height="281" src="https://www.youtube.com/embed/Nja5FYCLwjY?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>');
INSERT INTO `wp_postmeta` VALUES (1244,979,'_oembed_time_6bc1a5bba9249ed307823039777af077','1715447181');
INSERT INTO `wp_postmeta` VALUES (1245,979,'_oembed_74fd29be4ace7feb003800d78c4b45b5','<iframe title="AI i Randabergskolen - Skadepotensiale eller nytteverdi?" width="500" height="281" src="https://www.youtube.com/embed/vL-66LeC-m4?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>');
INSERT INTO `wp_postmeta` VALUES (1246,979,'_oembed_time_74fd29be4ace7feb003800d78c4b45b5','1715447181');
INSERT INTO `wp_postmeta` VALUES (1248,1144,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1249,979,'_oembed_1306a682855ba2fc99ca608bc6312778','<iframe title="KI i Randabergskolen - Skadepotensiale eller nytteverdi" width="500" height="281" src="https://www.youtube.com/embed/TBW37nYPhxE?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>');
INSERT INTO `wp_postmeta` VALUES (1250,979,'_oembed_time_1306a682855ba2fc99ca608bc6312778','1715447224');
INSERT INTO `wp_postmeta` VALUES (1252,1145,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1255,1150,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1257,1151,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1258,216,'_wp_attachment_backup_sizes','a:4:{s:9:"full-orig";a:3:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:88:"MyOnlyEye_in_icon_of_a_writing_club_style_pixar_444fe45f-82d2-4d13-b0e2-2218150be1c0.jpg";}s:14:"thumbnail-orig";a:5:{s:4:"file";s:96:"MyOnlyEye_in_icon_of_a_writing_club_style_pixar_444fe45f-82d2-4d13-b0e2-2218150be1c0-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:7106;}s:11:"medium-orig";a:5:{s:4:"file";s:96:"MyOnlyEye_in_icon_of_a_writing_club_style_pixar_444fe45f-82d2-4d13-b0e2-2218150be1c0-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:22021;}s:17:"medium_large-orig";a:5:{s:4:"file";s:96:"MyOnlyEye_in_icon_of_a_writing_club_style_pixar_444fe45f-82d2-4d13-b0e2-2218150be1c0-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:98772;}}');
INSERT INTO `wp_postmeta` VALUES (1274,1167,'_wp_attached_file','2023/09/diskusjonen.jpg');
INSERT INTO `wp_postmeta` VALUES (1275,1167,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:23:"2023/09/diskusjonen.jpg";s:8:"filesize";i:214573;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:23:"diskusjonen-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:12615;}s:9:"thumbnail";a:5:{s:4:"file";s:23:"diskusjonen-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:4650;}s:12:"medium_large";a:5:{s:4:"file";s:23:"diskusjonen-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:61952;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1279,979,'_wp_old_slug','pa-hvilken-mate-er-chatgpt-intelligent');
INSERT INTO `wp_postmeta` VALUES (1280,1170,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1283,1172,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1285,1173,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1302,1187,'_edit_lock','1728907261:80');
INSERT INTO `wp_postmeta` VALUES (1303,1189,'is_wp_suggestion','1');
INSERT INTO `wp_postmeta` VALUES (1305,891,'_wp_old_slug','ki-en-flink-og-hjelpsom-chatbot');
INSERT INTO `wp_postmeta` VALUES (1306,1194,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1341,1209,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1343,1210,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1345,1211,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1346,1212,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1347,1213,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1348,1214,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1351,1218,'_wp_attached_file','2025/03/kinetica___A_cute_Viking_with_a_surprised_expression_in_a_tradi_0c54d4e4-9dfe-4a2c-b8c3-3d392c288d131.jpg');
INSERT INTO `wp_postmeta` VALUES (1352,1218,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:113:"2025/03/kinetica___A_cute_Viking_with_a_surprised_expression_in_a_tradi_0c54d4e4-9dfe-4a2c-b8c3-3d392c288d131.jpg";s:8:"filesize";i:337609;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:113:"kinetica___A_cute_Viking_with_a_surprised_expression_in_a_tradi_0c54d4e4-9dfe-4a2c-b8c3-3d392c288d131-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:19927;}s:9:"thumbnail";a:5:{s:4:"file";s:113:"kinetica___A_cute_Viking_with_a_surprised_expression_in_a_tradi_0c54d4e4-9dfe-4a2c-b8c3-3d392c288d131-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6314;}s:12:"medium_large";a:5:{s:4:"file";s:113:"kinetica___A_cute_Viking_with_a_surprised_expression_in_a_tradi_0c54d4e4-9dfe-4a2c-b8c3-3d392c288d131-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:110351;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1354,1219,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1356,1220,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1402,1222,'_edit_lock','1742152932:80');
INSERT INTO `wp_postmeta` VALUES (1404,1224,'_wp_attached_file','2025/03/MyOnlyEye_in_icon_of_a_writing_club_style_pixar_da9c18e9-bae4-4bfe-b16d-96f22e391593.jpg');
INSERT INTO `wp_postmeta` VALUES (1405,1224,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:96:"2025/03/MyOnlyEye_in_icon_of_a_writing_club_style_pixar_da9c18e9-bae4-4bfe-b16d-96f22e391593.jpg";s:8:"filesize";i:303971;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:96:"MyOnlyEye_in_icon_of_a_writing_club_style_pixar_da9c18e9-bae4-4bfe-b16d-96f22e391593-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:25590;}s:9:"thumbnail";a:5:{s:4:"file";s:96:"MyOnlyEye_in_icon_of_a_writing_club_style_pixar_da9c18e9-bae4-4bfe-b16d-96f22e391593-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:9087;}s:12:"medium_large";a:5:{s:4:"file";s:96:"MyOnlyEye_in_icon_of_a_writing_club_style_pixar_da9c18e9-bae4-4bfe-b16d-96f22e391593-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:102067;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1406,1225,'_wp_attached_file','2025/03/Mitt-prosjekt-1.png');
INSERT INTO `wp_postmeta` VALUES (1407,1225,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:27:"2025/03/Mitt-prosjekt-1.png";s:8:"filesize";i:849440;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:27:"Mitt-prosjekt-1-300x300.png";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:86675;}s:9:"thumbnail";a:5:{s:4:"file";s:27:"Mitt-prosjekt-1-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:25679;}s:12:"medium_large";a:5:{s:4:"file";s:27:"Mitt-prosjekt-1-768x768.png";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:409953;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1408,1226,'_wp_attached_file','2025/03/MyOnlyEye_an_icon_of_a_female_egg_causal_happy_pixar_style_36387029-e099-4b05-8927-eeb82fb21249.jpg');
INSERT INTO `wp_postmeta` VALUES (1409,1226,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:107:"2025/03/MyOnlyEye_an_icon_of_a_female_egg_causal_happy_pixar_style_36387029-e099-4b05-8927-eeb82fb21249.jpg";s:8:"filesize";i:252017;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:107:"MyOnlyEye_an_icon_of_a_female_egg_causal_happy_pixar_style_36387029-e099-4b05-8927-eeb82fb21249-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:19501;}s:9:"thumbnail";a:5:{s:4:"file";s:107:"MyOnlyEye_an_icon_of_a_female_egg_causal_happy_pixar_style_36387029-e099-4b05-8927-eeb82fb21249-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6862;}s:12:"medium_large";a:5:{s:4:"file";s:107:"MyOnlyEye_an_icon_of_a_female_egg_causal_happy_pixar_style_36387029-e099-4b05-8927-eeb82fb21249-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:81204;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1410,1227,'_wp_attached_file','2025/03/MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985.jpg');
INSERT INTO `wp_postmeta` VALUES (1411,1227,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:97:"2025/03/MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985.jpg";s:8:"filesize";i:223362;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:97:"MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:12707;}s:9:"thumbnail";a:5:{s:4:"file";s:97:"MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:4668;}s:12:"medium_large";a:5:{s:4:"file";s:97:"MyOnlyEye_Le_fils_de_lhomme_magritte_pixar_style_808902b7-b5b1-4c7f-8a46-b679c0a41985-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:62974;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1412,1228,'_wp_attached_file','2025/03/MyOnlyEye_a_glass_ball_of_words_pixar_style_48ba36fd-5c63-4416-b4ea-1a41e8efbe14.jpg');
INSERT INTO `wp_postmeta` VALUES (1413,1228,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:92:"2025/03/MyOnlyEye_a_glass_ball_of_words_pixar_style_48ba36fd-5c63-4416-b4ea-1a41e8efbe14.jpg";s:8:"filesize";i:211991;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:92:"MyOnlyEye_a_glass_ball_of_words_pixar_style_48ba36fd-5c63-4416-b4ea-1a41e8efbe14-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:19243;}s:9:"thumbnail";a:5:{s:4:"file";s:92:"MyOnlyEye_a_glass_ball_of_words_pixar_style_48ba36fd-5c63-4416-b4ea-1a41e8efbe14-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6812;}s:12:"medium_large";a:5:{s:4:"file";s:92:"MyOnlyEye_a_glass_ball_of_words_pixar_style_48ba36fd-5c63-4416-b4ea-1a41e8efbe14-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:76005;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1414,1229,'_wp_attached_file','2025/03/myonlyeye_a_dragon_style_of_Don_Bluth_flat_animation_Disneys_Fa_4726194e-3717-4a56-adce-33c7ff7ee0e6.jpg');
INSERT INTO `wp_postmeta` VALUES (1415,1229,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:112:"2025/03/myonlyeye_a_dragon_style_of_Don_Bluth_flat_animation_Disneys_Fa_4726194e-3717-4a56-adce-33c7ff7ee0e6.jpg";s:8:"filesize";i:310807;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:112:"myonlyeye_a_dragon_style_of_Don_Bluth_flat_animation_Disneys_Fa_4726194e-3717-4a56-adce-33c7ff7ee0e6-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:20877;}s:9:"thumbnail";a:5:{s:4:"file";s:112:"myonlyeye_a_dragon_style_of_Don_Bluth_flat_animation_Disneys_Fa_4726194e-3717-4a56-adce-33c7ff7ee0e6-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:7316;}s:12:"medium_large";a:5:{s:4:"file";s:112:"myonlyeye_a_dragon_style_of_Don_Bluth_flat_animation_Disneys_Fa_4726194e-3717-4a56-adce-33c7ff7ee0e6-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:92933;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1416,1230,'_wp_attached_file','2025/03/robot4.png');
INSERT INTO `wp_postmeta` VALUES (1417,1230,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:18:"2025/03/robot4.png";s:8:"filesize";i:451160;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:18:"robot4-300x300.png";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:67396;}s:9:"thumbnail";a:5:{s:4:"file";s:18:"robot4-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:18518;}s:12:"medium_large";a:5:{s:4:"file";s:18:"robot4-768x768.png";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:250516;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1418,1231,'_wp_attached_file','2025/03/MyOnlyEye_an_icon_of_a_treasure_chest_style_pixar_1eb7d463-3c47-4398-9640-41aa4e54bc21.jpg');
INSERT INTO `wp_postmeta` VALUES (1419,1231,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:98:"2025/03/MyOnlyEye_an_icon_of_a_treasure_chest_style_pixar_1eb7d463-3c47-4398-9640-41aa4e54bc21.jpg";s:8:"filesize";i:255704;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:98:"MyOnlyEye_an_icon_of_a_treasure_chest_style_pixar_1eb7d463-3c47-4398-9640-41aa4e54bc21-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:17144;}s:9:"thumbnail";a:5:{s:4:"file";s:98:"MyOnlyEye_an_icon_of_a_treasure_chest_style_pixar_1eb7d463-3c47-4398-9640-41aa4e54bc21-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6260;}s:12:"medium_large";a:5:{s:4:"file";s:98:"MyOnlyEye_an_icon_of_a_treasure_chest_style_pixar_1eb7d463-3c47-4398-9640-41aa4e54bc21-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:72245;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1420,1232,'_wp_attached_file','2025/03/myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_47e25d43-95dc-4aa1-beb6-c37d0e815a6a_0.jpg');
INSERT INTO `wp_postmeta` VALUES (1421,1232,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:108:"2025/03/myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_47e25d43-95dc-4aa1-beb6-c37d0e815a6a_0.jpg";s:8:"filesize";i:260722;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:108:"myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_47e25d43-95dc-4aa1-beb6-c37d0e815a6a_0-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:18683;}s:9:"thumbnail";a:5:{s:4:"file";s:108:"myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_47e25d43-95dc-4aa1-beb6-c37d0e815a6a_0-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:5865;}s:12:"medium_large";a:5:{s:4:"file";s:108:"myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_47e25d43-95dc-4aa1-beb6-c37d0e815a6a_0-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:90140;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1422,1233,'_wp_attached_file','2025/03/myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_47e25d43-95dc-4aa1-beb6-c37d0e815a6a_2.jpg');
INSERT INTO `wp_postmeta` VALUES (1423,1233,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:108:"2025/03/myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_47e25d43-95dc-4aa1-beb6-c37d0e815a6a_2.jpg";s:8:"filesize";i:302176;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:108:"myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_47e25d43-95dc-4aa1-beb6-c37d0e815a6a_2-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:22094;}s:9:"thumbnail";a:5:{s:4:"file";s:108:"myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_47e25d43-95dc-4aa1-beb6-c37d0e815a6a_2-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6627;}s:12:"medium_large";a:5:{s:4:"file";s:108:"myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_47e25d43-95dc-4aa1-beb6-c37d0e815a6a_2-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:112128;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1424,1234,'_wp_attached_file','2025/03/myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_79332be8-d98d-40e2-969c-3444fe590fcc_2.jpg');
INSERT INTO `wp_postmeta` VALUES (1425,1234,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:108:"2025/03/myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_79332be8-d98d-40e2-969c-3444fe590fcc_2.jpg";s:8:"filesize";i:287757;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:108:"myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_79332be8-d98d-40e2-969c-3444fe590fcc_2-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:24196;}s:9:"thumbnail";a:5:{s:4:"file";s:108:"myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_79332be8-d98d-40e2-969c-3444fe590fcc_2-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:7584;}s:12:"medium_large";a:5:{s:4:"file";s:108:"myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_79332be8-d98d-40e2-969c-3444fe590fcc_2-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:113612;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1426,1235,'_wp_attached_file','2025/03/myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_47e25d43-95dc-4aa1-beb6-c37d0e815a6a_1.jpg');
INSERT INTO `wp_postmeta` VALUES (1427,1235,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:108:"2025/03/myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_47e25d43-95dc-4aa1-beb6-c37d0e815a6a_1.jpg";s:8:"filesize";i:334457;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:108:"myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_47e25d43-95dc-4aa1-beb6-c37d0e815a6a_1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:21830;}s:9:"thumbnail";a:5:{s:4:"file";s:108:"myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_47e25d43-95dc-4aa1-beb6-c37d0e815a6a_1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6882;}s:12:"medium_large";a:5:{s:4:"file";s:108:"myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_47e25d43-95dc-4aa1-beb6-c37d0e815a6a_1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:113156;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1428,1236,'_wp_attached_file','2025/03/myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_79332be8-d98d-40e2-969c-3444fe590fcc_0.jpg');
INSERT INTO `wp_postmeta` VALUES (1429,1236,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:108:"2025/03/myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_79332be8-d98d-40e2-969c-3444fe590fcc_0.jpg";s:8:"filesize";i:328724;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:108:"myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_79332be8-d98d-40e2-969c-3444fe590fcc_0-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:21815;}s:9:"thumbnail";a:5:{s:4:"file";s:108:"myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_79332be8-d98d-40e2-969c-3444fe590fcc_0-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6893;}s:12:"medium_large";a:5:{s:4:"file";s:108:"myonlyeye_sketch_of_unfinished_robot_happy_smiling_-turbo_79332be8-d98d-40e2-969c-3444fe590fcc_0-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:108589;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1430,1237,'_wp_attached_file','2025/03/myonlyeye_depressed_robot_with_a_huge_head_in_the_animation_s_64eb410b-44c9-4f11-bd93-f078a40b16f2_3.jpg');
INSERT INTO `wp_postmeta` VALUES (1431,1237,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:112:"2025/03/myonlyeye_depressed_robot_with_a_huge_head_in_the_animation_s_64eb410b-44c9-4f11-bd93-f078a40b16f2_3.jpg";s:8:"filesize";i:197652;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:112:"myonlyeye_depressed_robot_with_a_huge_head_in_the_animation_s_64eb410b-44c9-4f11-bd93-f078a40b16f2_3-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:10776;}s:9:"thumbnail";a:5:{s:4:"file";s:112:"myonlyeye_depressed_robot_with_a_huge_head_in_the_animation_s_64eb410b-44c9-4f11-bd93-f078a40b16f2_3-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:4145;}s:12:"medium_large";a:5:{s:4:"file";s:112:"myonlyeye_depressed_robot_with_a_huge_head_in_the_animation_s_64eb410b-44c9-4f11-bd93-f078a40b16f2_3-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:49422;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1432,1238,'_wp_attached_file','2025/03/myonlyeye_baby_llama_portrait_white_background_pixar_animatio_b2571457-0400-4a75-aac5-666f30f09103_1.jpg');
INSERT INTO `wp_postmeta` VALUES (1433,1238,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:112:"2025/03/myonlyeye_baby_llama_portrait_white_background_pixar_animatio_b2571457-0400-4a75-aac5-666f30f09103_1.jpg";s:8:"filesize";i:171200;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:112:"myonlyeye_baby_llama_portrait_white_background_pixar_animatio_b2571457-0400-4a75-aac5-666f30f09103_1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:9413;}s:9:"thumbnail";a:5:{s:4:"file";s:112:"myonlyeye_baby_llama_portrait_white_background_pixar_animatio_b2571457-0400-4a75-aac5-666f30f09103_1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:3709;}s:12:"medium_large";a:5:{s:4:"file";s:112:"myonlyeye_baby_llama_portrait_white_background_pixar_animatio_b2571457-0400-4a75-aac5-666f30f09103_1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:42417;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1434,1239,'_wp_attached_file','2025/03/ki-randabergskolen-logo.png');
INSERT INTO `wp_postmeta` VALUES (1435,1239,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:35:"2025/03/ki-randabergskolen-logo.png";s:8:"filesize";i:780876;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:35:"ki-randabergskolen-logo-300x300.png";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:82401;}s:9:"thumbnail";a:5:{s:4:"file";s:35:"ki-randabergskolen-logo-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:24526;}s:12:"medium_large";a:5:{s:4:"file";s:35:"ki-randabergskolen-logo-768x768.png";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:382086;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1436,1240,'_wp_attached_file','2025/03/cropped-ki-randabergskolen-logo.png');
INSERT INTO `wp_postmeta` VALUES (1437,1240,'_wp_attachment_metadata','a:6:{s:5:"width";i:512;s:6:"height";i:512;s:4:"file";s:43:"2025/03/cropped-ki-randabergskolen-logo.png";s:8:"filesize";i:182427;s:5:"sizes";a:2:{s:6:"medium";a:5:{s:4:"file";s:43:"cropped-ki-randabergskolen-logo-300x300.png";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:85640;}s:9:"thumbnail";a:5:{s:4:"file";s:43:"cropped-ki-randabergskolen-logo-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:26053;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1438,1241,'_wp_attached_file','2025/03/myonlyeye_a_happy_experienced_female_and_male_teacher_pixar_a_7d57adaa-e69e-4405-96d4-bae9ac6ae816_3.jpg');
INSERT INTO `wp_postmeta` VALUES (1439,1241,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:112:"2025/03/myonlyeye_a_happy_experienced_female_and_male_teacher_pixar_a_7d57adaa-e69e-4405-96d4-bae9ac6ae816_3.jpg";s:8:"filesize";i:205304;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:112:"myonlyeye_a_happy_experienced_female_and_male_teacher_pixar_a_7d57adaa-e69e-4405-96d4-bae9ac6ae816_3-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:15447;}s:9:"thumbnail";a:5:{s:4:"file";s:112:"myonlyeye_a_happy_experienced_female_and_male_teacher_pixar_a_7d57adaa-e69e-4405-96d4-bae9ac6ae816_3-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:5851;}s:12:"medium_large";a:5:{s:4:"file";s:112:"myonlyeye_a_happy_experienced_female_and_male_teacher_pixar_a_7d57adaa-e69e-4405-96d4-bae9ac6ae816_3-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:62631;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1440,1242,'_wp_attached_file','2025/03/myonlyeye_smiling_socrates_disney_animation_style_neutral_bac_3f5f17a7-6fb6-4a54-8c6f-8c853cc3cc60_1.jpg');
INSERT INTO `wp_postmeta` VALUES (1441,1242,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:112:"2025/03/myonlyeye_smiling_socrates_disney_animation_style_neutral_bac_3f5f17a7-6fb6-4a54-8c6f-8c853cc3cc60_1.jpg";s:8:"filesize";i:277554;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:112:"myonlyeye_smiling_socrates_disney_animation_style_neutral_bac_3f5f17a7-6fb6-4a54-8c6f-8c853cc3cc60_1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:17328;}s:9:"thumbnail";a:5:{s:4:"file";s:112:"myonlyeye_smiling_socrates_disney_animation_style_neutral_bac_3f5f17a7-6fb6-4a54-8c6f-8c853cc3cc60_1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6109;}s:12:"medium_large";a:5:{s:4:"file";s:112:"myonlyeye_smiling_socrates_disney_animation_style_neutral_bac_3f5f17a7-6fb6-4a54-8c6f-8c853cc3cc60_1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:80049;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1442,1243,'_wp_attached_file','2025/03/myonlyeye_happy_kid_pixar_animation_style_neutral_background_1679c7b1-4755-4b3e-b017-38e24bfb4de7_1.jpg');
INSERT INTO `wp_postmeta` VALUES (1443,1243,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:111:"2025/03/myonlyeye_happy_kid_pixar_animation_style_neutral_background_1679c7b1-4755-4b3e-b017-38e24bfb4de7_1.jpg";s:8:"filesize";i:253233;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:111:"myonlyeye_happy_kid_pixar_animation_style_neutral_background_1679c7b1-4755-4b3e-b017-38e24bfb4de7_1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:14862;}s:9:"thumbnail";a:5:{s:4:"file";s:111:"myonlyeye_happy_kid_pixar_animation_style_neutral_background_1679c7b1-4755-4b3e-b017-38e24bfb4de7_1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:5223;}s:12:"medium_large";a:5:{s:4:"file";s:111:"myonlyeye_happy_kid_pixar_animation_style_neutral_background_1679c7b1-4755-4b3e-b017-38e24bfb4de7_1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:76182;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1444,1244,'_wp_attached_file','2025/03/myonlyeye_casual_smiling_kid_portrait_pixar_animation_style_n_1a7ff590-50ab-4a06-a667-1342ae140114_0.jpg');
INSERT INTO `wp_postmeta` VALUES (1445,1244,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:112:"2025/03/myonlyeye_casual_smiling_kid_portrait_pixar_animation_style_n_1a7ff590-50ab-4a06-a667-1342ae140114_0.jpg";s:8:"filesize";i:232168;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:112:"myonlyeye_casual_smiling_kid_portrait_pixar_animation_style_n_1a7ff590-50ab-4a06-a667-1342ae140114_0-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:13895;}s:9:"thumbnail";a:5:{s:4:"file";s:112:"myonlyeye_casual_smiling_kid_portrait_pixar_animation_style_n_1a7ff590-50ab-4a06-a667-1342ae140114_0-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:4939;}s:12:"medium_large";a:5:{s:4:"file";s:112:"myonlyeye_casual_smiling_kid_portrait_pixar_animation_style_n_1a7ff590-50ab-4a06-a667-1342ae140114_0-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:72064;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1446,1245,'_wp_attached_file','2025/03/myonlyeye_a_writing_workshop_three_people_pixar_animation_sty_67fc1acd-b10d-4607-956c-efedfa493d9d_0.jpg');
INSERT INTO `wp_postmeta` VALUES (1447,1245,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:112:"2025/03/myonlyeye_a_writing_workshop_three_people_pixar_animation_sty_67fc1acd-b10d-4607-956c-efedfa493d9d_0.jpg";s:8:"filesize";i:263554;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:112:"myonlyeye_a_writing_workshop_three_people_pixar_animation_sty_67fc1acd-b10d-4607-956c-efedfa493d9d_0-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:21952;}s:9:"thumbnail";a:5:{s:4:"file";s:112:"myonlyeye_a_writing_workshop_three_people_pixar_animation_sty_67fc1acd-b10d-4607-956c-efedfa493d9d_0-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:7727;}s:12:"medium_large";a:5:{s:4:"file";s:112:"myonlyeye_a_writing_workshop_three_people_pixar_animation_sty_67fc1acd-b10d-4607-956c-efedfa493d9d_0-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:87844;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1448,1246,'_wp_attached_file','2025/03/myonlyeye_a_kind_robot_giving_feedback_to_a_student_pixar_ani_3eb14d92-2e34-4a08-8a59-2f95465c5df8_2.jpg');
INSERT INTO `wp_postmeta` VALUES (1449,1246,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:112:"2025/03/myonlyeye_a_kind_robot_giving_feedback_to_a_student_pixar_ani_3eb14d92-2e34-4a08-8a59-2f95465c5df8_2.jpg";s:8:"filesize";i:223185;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:112:"myonlyeye_a_kind_robot_giving_feedback_to_a_student_pixar_ani_3eb14d92-2e34-4a08-8a59-2f95465c5df8_2-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:19507;}s:9:"thumbnail";a:5:{s:4:"file";s:112:"myonlyeye_a_kind_robot_giving_feedback_to_a_student_pixar_ani_3eb14d92-2e34-4a08-8a59-2f95465c5df8_2-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:7352;}s:12:"medium_large";a:5:{s:4:"file";s:112:"myonlyeye_a_kind_robot_giving_feedback_to_a_student_pixar_ani_3eb14d92-2e34-4a08-8a59-2f95465c5df8_2-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:75279;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1450,1247,'_wp_attached_file','2025/03/myonlyeye_an_AI_helping_a_teacher_write_an_assignment_pixar_a_97c80671-d888-4059-a907-8467f477d1cc_0.jpg');
INSERT INTO `wp_postmeta` VALUES (1451,1247,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:112:"2025/03/myonlyeye_an_AI_helping_a_teacher_write_an_assignment_pixar_a_97c80671-d888-4059-a907-8467f477d1cc_0.jpg";s:8:"filesize";i:222422;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:112:"myonlyeye_an_AI_helping_a_teacher_write_an_assignment_pixar_a_97c80671-d888-4059-a907-8467f477d1cc_0-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:19617;}s:9:"thumbnail";a:5:{s:4:"file";s:112:"myonlyeye_an_AI_helping_a_teacher_write_an_assignment_pixar_a_97c80671-d888-4059-a907-8467f477d1cc_0-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:7385;}s:12:"medium_large";a:5:{s:4:"file";s:112:"myonlyeye_an_AI_helping_a_teacher_write_an_assignment_pixar_a_97c80671-d888-4059-a907-8467f477d1cc_0-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:74333;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1452,1248,'_wp_attached_file','2025/03/myonlyeye_a_polite_butler_carrying_a_scroll_pixar_style_white_b_de12e82c-1869-452f-b2a7-b012d7103c7a.jpg');
INSERT INTO `wp_postmeta` VALUES (1453,1248,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:112:"2025/03/myonlyeye_a_polite_butler_carrying_a_scroll_pixar_style_white_b_de12e82c-1869-452f-b2a7-b012d7103c7a.jpg";s:8:"filesize";i:103378;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:112:"myonlyeye_a_polite_butler_carrying_a_scroll_pixar_style_white_b_de12e82c-1869-452f-b2a7-b012d7103c7a-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:9648;}s:9:"thumbnail";a:5:{s:4:"file";s:112:"myonlyeye_a_polite_butler_carrying_a_scroll_pixar_style_white_b_de12e82c-1869-452f-b2a7-b012d7103c7a-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:4011;}s:12:"medium_large";a:5:{s:4:"file";s:112:"myonlyeye_a_polite_butler_carrying_a_scroll_pixar_style_white_b_de12e82c-1869-452f-b2a7-b012d7103c7a-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:36016;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1454,1249,'_wp_attached_file','2025/03/myonlyeye_a_very_polite_writer_pixar_style_white_background_2e9f7252-0cb8-47ae-aa4d-80289454d2b3.jpg');
INSERT INTO `wp_postmeta` VALUES (1455,1249,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:108:"2025/03/myonlyeye_a_very_polite_writer_pixar_style_white_background_2e9f7252-0cb8-47ae-aa4d-80289454d2b3.jpg";s:8:"filesize";i:139329;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:108:"myonlyeye_a_very_polite_writer_pixar_style_white_background_2e9f7252-0cb8-47ae-aa4d-80289454d2b3-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:12256;}s:9:"thumbnail";a:5:{s:4:"file";s:108:"myonlyeye_a_very_polite_writer_pixar_style_white_background_2e9f7252-0cb8-47ae-aa4d-80289454d2b3-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:4768;}s:12:"medium_large";a:5:{s:4:"file";s:108:"myonlyeye_a_very_polite_writer_pixar_style_white_background_2e9f7252-0cb8-47ae-aa4d-80289454d2b3-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:48367;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1456,1250,'_wp_attached_file','2025/03/microbit.jpg');
INSERT INTO `wp_postmeta` VALUES (1457,1250,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:20:"2025/03/microbit.jpg";s:8:"filesize";i:102693;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:20:"microbit-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:10238;}s:9:"thumbnail";a:5:{s:4:"file";s:20:"microbit-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:4147;}s:12:"medium_large";a:5:{s:4:"file";s:20:"microbit-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:37268;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1458,1251,'_wp_attached_file','2025/03/myonlyeye_casual_happy_socrates_style_pixar_-turbo_a2b9f20b-43c0-46b0-92f1-1acf4a0cd9d9_1.jpg');
INSERT INTO `wp_postmeta` VALUES (1459,1251,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:101:"2025/03/myonlyeye_casual_happy_socrates_style_pixar_-turbo_a2b9f20b-43c0-46b0-92f1-1acf4a0cd9d9_1.jpg";s:8:"filesize";i:240254;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:101:"myonlyeye_casual_happy_socrates_style_pixar_-turbo_a2b9f20b-43c0-46b0-92f1-1acf4a0cd9d9_1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:14437;}s:9:"thumbnail";a:5:{s:4:"file";s:101:"myonlyeye_casual_happy_socrates_style_pixar_-turbo_a2b9f20b-43c0-46b0-92f1-1acf4a0cd9d9_1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:5175;}s:12:"medium_large";a:5:{s:4:"file";s:101:"myonlyeye_casual_happy_socrates_style_pixar_-turbo_a2b9f20b-43c0-46b0-92f1-1acf4a0cd9d9_1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:70686;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1460,1252,'_wp_attached_file','2025/03/myonlyeye_a_kind_teacher_pixar_style_neutral_background_-sty_49c0b56f-82cf-4492-99e5-f7117314b7ff_0.jpg');
INSERT INTO `wp_postmeta` VALUES (1461,1252,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:111:"2025/03/myonlyeye_a_kind_teacher_pixar_style_neutral_background_-sty_49c0b56f-82cf-4492-99e5-f7117314b7ff_0.jpg";s:8:"filesize";i:188222;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:111:"myonlyeye_a_kind_teacher_pixar_style_neutral_background_-sty_49c0b56f-82cf-4492-99e5-f7117314b7ff_0-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:12576;}s:9:"thumbnail";a:5:{s:4:"file";s:111:"myonlyeye_a_kind_teacher_pixar_style_neutral_background_-sty_49c0b56f-82cf-4492-99e5-f7117314b7ff_0-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:4743;}s:12:"medium_large";a:5:{s:4:"file";s:111:"myonlyeye_a_kind_teacher_pixar_style_neutral_background_-sty_49c0b56f-82cf-4492-99e5-f7117314b7ff_0-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:58764;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1462,1253,'_wp_attached_file','2025/03/MyOnlyEye_behind_the_curtains_pixar_style_e38be4a1-346e-46a9-b376-bd4f0be78708-e1684924115381.jpg');
INSERT INTO `wp_postmeta` VALUES (1463,1253,'_wp_attachment_metadata','a:6:{s:5:"width";i:815;s:6:"height";i:815;s:4:"file";s:105:"2025/03/MyOnlyEye_behind_the_curtains_pixar_style_e38be4a1-346e-46a9-b376-bd4f0be78708-e1684924115381.jpg";s:8:"filesize";i:116656;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:105:"MyOnlyEye_behind_the_curtains_pixar_style_e38be4a1-346e-46a9-b376-bd4f0be78708-e1684924115381-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:13962;}s:9:"thumbnail";a:5:{s:4:"file";s:105:"MyOnlyEye_behind_the_curtains_pixar_style_e38be4a1-346e-46a9-b376-bd4f0be78708-e1684924115381-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:5072;}s:12:"medium_large";a:5:{s:4:"file";s:105:"MyOnlyEye_behind_the_curtains_pixar_style_e38be4a1-346e-46a9-b376-bd4f0be78708-e1684924115381-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:56766;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1464,1254,'_wp_attached_file','2025/03/myonlyeye_an_argument_pixar_style_neutral_background_1995dd4a-1e90-4d41-8a55-c8fc31556cf9_0.jpg');
INSERT INTO `wp_postmeta` VALUES (1465,1254,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:103:"2025/03/myonlyeye_an_argument_pixar_style_neutral_background_1995dd4a-1e90-4d41-8a55-c8fc31556cf9_0.jpg";s:8:"filesize";i:214573;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:103:"myonlyeye_an_argument_pixar_style_neutral_background_1995dd4a-1e90-4d41-8a55-c8fc31556cf9_0-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:12615;}s:9:"thumbnail";a:5:{s:4:"file";s:103:"myonlyeye_an_argument_pixar_style_neutral_background_1995dd4a-1e90-4d41-8a55-c8fc31556cf9_0-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:4650;}s:12:"medium_large";a:5:{s:4:"file";s:103:"myonlyeye_an_argument_pixar_style_neutral_background_1995dd4a-1e90-4d41-8a55-c8fc31556cf9_0-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:61952;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1466,1255,'_wp_attached_file','2025/03/myonlyeye_a_happy_pixar_character_writing_in_a_book_one_colou_71cb9c48-55ae-40fa-85d3-34c21218ede9_0.jpg');
INSERT INTO `wp_postmeta` VALUES (1467,1255,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:112:"2025/03/myonlyeye_a_happy_pixar_character_writing_in_a_book_one_colou_71cb9c48-55ae-40fa-85d3-34c21218ede9_0.jpg";s:8:"filesize";i:288422;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:112:"myonlyeye_a_happy_pixar_character_writing_in_a_book_one_colou_71cb9c48-55ae-40fa-85d3-34c21218ede9_0-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:18417;}s:9:"thumbnail";a:5:{s:4:"file";s:112:"myonlyeye_a_happy_pixar_character_writing_in_a_book_one_colou_71cb9c48-55ae-40fa-85d3-34c21218ede9_0-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6482;}s:12:"medium_large";a:5:{s:4:"file";s:112:"myonlyeye_a_happy_pixar_character_writing_in_a_book_one_colou_71cb9c48-55ae-40fa-85d3-34c21218ede9_0-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:86118;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1468,1256,'_wp_attached_file','2025/03/myonlyeye_a_happy_pixar_character_writing_in_a_book_neutral_b_51199384-c9b4-4315-9e17-cd74e9f04f44_1.jpg');
INSERT INTO `wp_postmeta` VALUES (1469,1256,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:112:"2025/03/myonlyeye_a_happy_pixar_character_writing_in_a_book_neutral_b_51199384-c9b4-4315-9e17-cd74e9f04f44_1.jpg";s:8:"filesize";i:245318;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:112:"myonlyeye_a_happy_pixar_character_writing_in_a_book_neutral_b_51199384-c9b4-4315-9e17-cd74e9f04f44_1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:16369;}s:9:"thumbnail";a:5:{s:4:"file";s:112:"myonlyeye_a_happy_pixar_character_writing_in_a_book_neutral_b_51199384-c9b4-4315-9e17-cd74e9f04f44_1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:5719;}s:12:"medium_large";a:5:{s:4:"file";s:112:"myonlyeye_a_happy_pixar_character_writing_in_a_book_neutral_b_51199384-c9b4-4315-9e17-cd74e9f04f44_1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:77945;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1470,1257,'_wp_attached_file','2025/03/superlaerer1.jpg');
INSERT INTO `wp_postmeta` VALUES (1471,1257,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:24:"2025/03/superlaerer1.jpg";s:8:"filesize";i:241391;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:24:"superlaerer1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:17497;}s:9:"thumbnail";a:5:{s:4:"file";s:24:"superlaerer1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6374;}s:12:"medium_large";a:5:{s:4:"file";s:24:"superlaerer1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:76167;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1472,1258,'_wp_attached_file','2025/03/mangemennesker.jpg');
INSERT INTO `wp_postmeta` VALUES (1473,1258,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:26:"2025/03/mangemennesker.jpg";s:8:"filesize";i:450230;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:26:"mangemennesker-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:31848;}s:9:"thumbnail";a:5:{s:4:"file";s:26:"mangemennesker-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:10515;}s:12:"medium_large";a:5:{s:4:"file";s:26:"mangemennesker-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:141039;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1474,1259,'_wp_attached_file','2025/03/laerer02.jpg');
INSERT INTO `wp_postmeta` VALUES (1475,1259,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:20:"2025/03/laerer02.jpg";s:8:"filesize";i:321895;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:20:"laerer02-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:21253;}s:9:"thumbnail";a:5:{s:4:"file";s:20:"laerer02-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:7241;}s:12:"medium_large";a:5:{s:4:"file";s:20:"laerer02-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:106561;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1476,1260,'_wp_attached_file','2025/03/manual.jpg');
INSERT INTO `wp_postmeta` VALUES (1477,1260,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:18:"2025/03/manual.jpg";s:8:"filesize";i:301041;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:18:"manual-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:20160;}s:9:"thumbnail";a:5:{s:4:"file";s:18:"manual-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6937;}s:12:"medium_large";a:5:{s:4:"file";s:18:"manual-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:93780;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1478,1261,'_wp_attached_file','2025/03/elevbrukerpc.jpg');
INSERT INTO `wp_postmeta` VALUES (1479,1261,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:24:"2025/03/elevbrukerpc.jpg";s:8:"filesize";i:254818;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:24:"elevbrukerpc-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:17079;}s:9:"thumbnail";a:5:{s:4:"file";s:24:"elevbrukerpc-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6022;}s:12:"medium_large";a:5:{s:4:"file";s:24:"elevbrukerpc-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:73891;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1480,1262,'_wp_attached_file','2025/03/myonlyeye_a_robot_in_a_green_shiny_rubber_suit_writing_LaTeX__8d3e07e3-4184-4738-9830-34744295a3d1_0.jpg');
INSERT INTO `wp_postmeta` VALUES (1481,1262,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:112:"2025/03/myonlyeye_a_robot_in_a_green_shiny_rubber_suit_writing_LaTeX__8d3e07e3-4184-4738-9830-34744295a3d1_0.jpg";s:8:"filesize";i:291726;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:112:"myonlyeye_a_robot_in_a_green_shiny_rubber_suit_writing_LaTeX__8d3e07e3-4184-4738-9830-34744295a3d1_0-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:20454;}s:9:"thumbnail";a:5:{s:4:"file";s:112:"myonlyeye_a_robot_in_a_green_shiny_rubber_suit_writing_LaTeX__8d3e07e3-4184-4738-9830-34744295a3d1_0-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6872;}s:12:"medium_large";a:5:{s:4:"file";s:112:"myonlyeye_a_robot_in_a_green_shiny_rubber_suit_writing_LaTeX__8d3e07e3-4184-4738-9830-34744295a3d1_0-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:94420;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1482,1263,'_wp_attached_file','2025/03/myonlyeye_stone_age_man_inside_ice_style_pixar_-v_6.1_fe0b64dd-deec-4886-95ee-dd81ba573e4d_0.jpg');
INSERT INTO `wp_postmeta` VALUES (1483,1263,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:104:"2025/03/myonlyeye_stone_age_man_inside_ice_style_pixar_-v_6.1_fe0b64dd-deec-4886-95ee-dd81ba573e4d_0.jpg";s:8:"filesize";i:312630;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:104:"myonlyeye_stone_age_man_inside_ice_style_pixar_-v_6.1_fe0b64dd-deec-4886-95ee-dd81ba573e4d_0-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:24327;}s:9:"thumbnail";a:5:{s:4:"file";s:104:"myonlyeye_stone_age_man_inside_ice_style_pixar_-v_6.1_fe0b64dd-deec-4886-95ee-dd81ba573e4d_0-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:7743;}s:12:"medium_large";a:5:{s:4:"file";s:104:"myonlyeye_stone_age_man_inside_ice_style_pixar_-v_6.1_fe0b64dd-deec-4886-95ee-dd81ba573e4d_0-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:114556;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1484,1264,'_wp_attached_file','2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_3.jpg');
INSERT INTO `wp_postmeta` VALUES (1485,1264,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:112:"2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_3.jpg";s:8:"filesize";i:281983;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:112:"myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_3-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:18196;}s:9:"thumbnail";a:5:{s:4:"file";s:112:"myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_3-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6211;}s:12:"medium_large";a:5:{s:4:"file";s:112:"myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_3-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:87671;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1486,1265,'_wp_attached_file','2025/03/myonlyeye_stortinget_norway_pixar_animation_style_-cref_http_0e5844bb-95cb-4762-9e16-30cd489d2c1b_0.jpg');
INSERT INTO `wp_postmeta` VALUES (1487,1265,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:111:"2025/03/myonlyeye_stortinget_norway_pixar_animation_style_-cref_http_0e5844bb-95cb-4762-9e16-30cd489d2c1b_0.jpg";s:8:"filesize";i:275864;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:111:"myonlyeye_stortinget_norway_pixar_animation_style_-cref_http_0e5844bb-95cb-4762-9e16-30cd489d2c1b_0-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:19723;}s:9:"thumbnail";a:5:{s:4:"file";s:111:"myonlyeye_stortinget_norway_pixar_animation_style_-cref_http_0e5844bb-95cb-4762-9e16-30cd489d2c1b_0-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6468;}s:12:"medium_large";a:5:{s:4:"file";s:111:"myonlyeye_stortinget_norway_pixar_animation_style_-cref_http_0e5844bb-95cb-4762-9e16-30cd489d2c1b_0-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:93165;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1488,1266,'_wp_attached_file','2025/03/myonlyeye_religion_and_ethics_symbol_-v_6.1_66ee8d7e-2291-4473-b9b5-4ff9d97eba13_2.jpg');
INSERT INTO `wp_postmeta` VALUES (1489,1266,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:94:"2025/03/myonlyeye_religion_and_ethics_symbol_-v_6.1_66ee8d7e-2291-4473-b9b5-4ff9d97eba13_2.jpg";s:8:"filesize";i:418652;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:94:"myonlyeye_religion_and_ethics_symbol_-v_6.1_66ee8d7e-2291-4473-b9b5-4ff9d97eba13_2-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:26080;}s:9:"thumbnail";a:5:{s:4:"file";s:94:"myonlyeye_religion_and_ethics_symbol_-v_6.1_66ee8d7e-2291-4473-b9b5-4ff9d97eba13_2-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:7900;}s:12:"medium_large";a:5:{s:4:"file";s:94:"myonlyeye_religion_and_ethics_symbol_-v_6.1_66ee8d7e-2291-4473-b9b5-4ff9d97eba13_2-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:139323;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1490,1267,'_wp_attached_file','2025/03/myonlyeye_creative_writer_sitting_by_a_desk_lot_on_notes_on_t_cd76d529-31ac-4d3f-8d06-c378484bcb3a_1.jpg');
INSERT INTO `wp_postmeta` VALUES (1491,1267,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:112:"2025/03/myonlyeye_creative_writer_sitting_by_a_desk_lot_on_notes_on_t_cd76d529-31ac-4d3f-8d06-c378484bcb3a_1.jpg";s:8:"filesize";i:250200;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:112:"myonlyeye_creative_writer_sitting_by_a_desk_lot_on_notes_on_t_cd76d529-31ac-4d3f-8d06-c378484bcb3a_1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:20618;}s:9:"thumbnail";a:5:{s:4:"file";s:112:"myonlyeye_creative_writer_sitting_by_a_desk_lot_on_notes_on_t_cd76d529-31ac-4d3f-8d06-c378484bcb3a_1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6298;}s:12:"medium_large";a:5:{s:4:"file";s:112:"myonlyeye_creative_writer_sitting_by_a_desk_lot_on_notes_on_t_cd76d529-31ac-4d3f-8d06-c378484bcb3a_1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:103109;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1492,1268,'_wp_attached_file','2025/03/myonlyeye_smart_woman_thinking_style_pixar_-v_6.1_efd87068-8bf2-490d-9805-e6740078881b_1.jpg');
INSERT INTO `wp_postmeta` VALUES (1493,1268,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:100:"2025/03/myonlyeye_smart_woman_thinking_style_pixar_-v_6.1_efd87068-8bf2-490d-9805-e6740078881b_1.jpg";s:8:"filesize";i:204348;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:100:"myonlyeye_smart_woman_thinking_style_pixar_-v_6.1_efd87068-8bf2-490d-9805-e6740078881b_1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:15243;}s:9:"thumbnail";a:5:{s:4:"file";s:100:"myonlyeye_smart_woman_thinking_style_pixar_-v_6.1_efd87068-8bf2-490d-9805-e6740078881b_1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:5728;}s:12:"medium_large";a:5:{s:4:"file";s:100:"myonlyeye_smart_woman_thinking_style_pixar_-v_6.1_efd87068-8bf2-490d-9805-e6740078881b_1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:68186;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1494,1269,'_wp_attached_file','2025/03/myonlyeye_a_zen_meditation_pixar_style_-v_6.1_d9c64dba-1884-442f-a6c1-eed57daa8ba1_1.jpg');
INSERT INTO `wp_postmeta` VALUES (1495,1269,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:96:"2025/03/myonlyeye_a_zen_meditation_pixar_style_-v_6.1_d9c64dba-1884-442f-a6c1-eed57daa8ba1_1.jpg";s:8:"filesize";i:267695;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:96:"myonlyeye_a_zen_meditation_pixar_style_-v_6.1_d9c64dba-1884-442f-a6c1-eed57daa8ba1_1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:18445;}s:9:"thumbnail";a:5:{s:4:"file";s:96:"myonlyeye_a_zen_meditation_pixar_style_-v_6.1_d9c64dba-1884-442f-a6c1-eed57daa8ba1_1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6321;}s:12:"medium_large";a:5:{s:4:"file";s:96:"myonlyeye_a_zen_meditation_pixar_style_-v_6.1_d9c64dba-1884-442f-a6c1-eed57daa8ba1_1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:85782;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1496,1270,'_wp_attached_file','2025/03/myonlyeye_a_zen_meditation_pixar_style_-v_6.1_356e3cfa-9df7-4499-b1a7-670a0e78c4fa_3.jpg');
INSERT INTO `wp_postmeta` VALUES (1497,1270,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:96:"2025/03/myonlyeye_a_zen_meditation_pixar_style_-v_6.1_356e3cfa-9df7-4499-b1a7-670a0e78c4fa_3.jpg";s:8:"filesize";i:187235;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:96:"myonlyeye_a_zen_meditation_pixar_style_-v_6.1_356e3cfa-9df7-4499-b1a7-670a0e78c4fa_3-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:15357;}s:9:"thumbnail";a:5:{s:4:"file";s:96:"myonlyeye_a_zen_meditation_pixar_style_-v_6.1_356e3cfa-9df7-4499-b1a7-670a0e78c4fa_3-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:5981;}s:12:"medium_large";a:5:{s:4:"file";s:96:"myonlyeye_a_zen_meditation_pixar_style_-v_6.1_356e3cfa-9df7-4499-b1a7-670a0e78c4fa_3-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:60975;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1498,1271,'_wp_attached_file','2025/03/2023-12-14_22-40-45_3828.jpg');
INSERT INTO `wp_postmeta` VALUES (1499,1271,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:36:"2025/03/2023-12-14_22-40-45_3828.jpg";s:8:"filesize";i:300735;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:36:"2023-12-14_22-40-45_3828-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:27856;}s:9:"thumbnail";a:5:{s:4:"file";s:36:"2023-12-14_22-40-45_3828-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:9756;}s:12:"medium_large";a:5:{s:4:"file";s:36:"2023-12-14_22-40-45_3828-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:109567;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1500,1272,'_wp_attached_file','2025/03/image-1.jpg');
INSERT INTO `wp_postmeta` VALUES (1501,1272,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:19:"2025/03/image-1.jpg";s:8:"filesize";i:271806;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:19:"image-1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:23762;}s:9:"thumbnail";a:5:{s:4:"file";s:19:"image-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:8273;}s:12:"medium_large";a:5:{s:4:"file";s:19:"image-1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:94314;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1502,1273,'_wp_attached_file','2025/03/image-1-1.jpg');
INSERT INTO `wp_postmeta` VALUES (1503,1273,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:21:"2025/03/image-1-1.jpg";s:8:"filesize";i:176746;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:21:"image-1-1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:17914;}s:9:"thumbnail";a:5:{s:4:"file";s:21:"image-1-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6856;}s:12:"medium_large";a:5:{s:4:"file";s:21:"image-1-1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:64960;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1504,1274,'_wp_attached_file','2025/03/image-3-1.jpg');
INSERT INTO `wp_postmeta` VALUES (1505,1274,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:21:"2025/03/image-3-1.jpg";s:8:"filesize";i:197618;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:21:"image-3-1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:15251;}s:9:"thumbnail";a:5:{s:4:"file";s:21:"image-3-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:5511;}s:12:"medium_large";a:5:{s:4:"file";s:21:"image-3-1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:65811;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1506,1275,'_wp_attached_file','2025/03/myonlyeye_man_of_science_pixar_style_-v_6.1_4d004b6d-6797-4e05-b378-b05725fd5771_1.jpg');
INSERT INTO `wp_postmeta` VALUES (1507,1275,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:94:"2025/03/myonlyeye_man_of_science_pixar_style_-v_6.1_4d004b6d-6797-4e05-b378-b05725fd5771_1.jpg";s:8:"filesize";i:228824;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:94:"myonlyeye_man_of_science_pixar_style_-v_6.1_4d004b6d-6797-4e05-b378-b05725fd5771_1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:18055;}s:9:"thumbnail";a:5:{s:4:"file";s:94:"myonlyeye_man_of_science_pixar_style_-v_6.1_4d004b6d-6797-4e05-b378-b05725fd5771_1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6788;}s:12:"medium_large";a:5:{s:4:"file";s:94:"myonlyeye_man_of_science_pixar_style_-v_6.1_4d004b6d-6797-4e05-b378-b05725fd5771_1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:76333;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1508,1276,'_wp_attached_file','2025/03/sameflagg-1m-e1737368906687.jpg');
INSERT INTO `wp_postmeta` VALUES (1509,1276,'_wp_attachment_metadata','a:6:{s:5:"width";i:577;s:6:"height";i:577;s:4:"file";s:39:"2025/03/sameflagg-1m-e1737368906687.jpg";s:8:"filesize";i:21900;s:5:"sizes";a:2:{s:6:"medium";a:5:{s:4:"file";s:39:"sameflagg-1m-e1737368906687-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:9244;}s:9:"thumbnail";a:5:{s:4:"file";s:39:"sameflagg-1m-e1737368906687-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:4230;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1510,1277,'_wp_attached_file','2025/03/myonlyeye_Ingrid_Johansen_a_norwegian_teenager_in_shirt_and_s_353c58e0-1d1e-4f8e-83d6-1706d95d4e01_0.jpg');
INSERT INTO `wp_postmeta` VALUES (1511,1277,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:112:"2025/03/myonlyeye_Ingrid_Johansen_a_norwegian_teenager_in_shirt_and_s_353c58e0-1d1e-4f8e-83d6-1706d95d4e01_0.jpg";s:8:"filesize";i:250283;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:112:"myonlyeye_Ingrid_Johansen_a_norwegian_teenager_in_shirt_and_s_353c58e0-1d1e-4f8e-83d6-1706d95d4e01_0-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:16638;}s:9:"thumbnail";a:5:{s:4:"file";s:112:"myonlyeye_Ingrid_Johansen_a_norwegian_teenager_in_shirt_and_s_353c58e0-1d1e-4f8e-83d6-1706d95d4e01_0-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:5773;}s:12:"medium_large";a:5:{s:4:"file";s:112:"myonlyeye_Ingrid_Johansen_a_norwegian_teenager_in_shirt_and_s_353c58e0-1d1e-4f8e-83d6-1706d95d4e01_0-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:76303;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1512,1278,'_wp_attached_file','2025/03/myonlyeye_two_people_talking_casual_happy_style_pixar_-v_6.1_1f845975-1ab6-4ac2-a26d-95379fc478e7_3-1.jpg');
INSERT INTO `wp_postmeta` VALUES (1513,1278,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:113:"2025/03/myonlyeye_two_people_talking_casual_happy_style_pixar_-v_6.1_1f845975-1ab6-4ac2-a26d-95379fc478e7_3-1.jpg";s:8:"filesize";i:196264;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:113:"myonlyeye_two_people_talking_casual_happy_style_pixar_-v_6.1_1f845975-1ab6-4ac2-a26d-95379fc478e7_3-1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:14073;}s:9:"thumbnail";a:5:{s:4:"file";s:113:"myonlyeye_two_people_talking_casual_happy_style_pixar_-v_6.1_1f845975-1ab6-4ac2-a26d-95379fc478e7_3-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:5291;}s:12:"medium_large";a:5:{s:4:"file";s:113:"myonlyeye_two_people_talking_casual_happy_style_pixar_-v_6.1_1f845975-1ab6-4ac2-a26d-95379fc478e7_3-1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:60293;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1514,1279,'_wp_attached_file','2025/03/myonlyeye_exam_talking_casual_happy_style_pixar_-v_6.1_fffb0440-ae2f-4257-9891-98bfb14ce5ec_0-1.jpg');
INSERT INTO `wp_postmeta` VALUES (1515,1279,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:107:"2025/03/myonlyeye_exam_talking_casual_happy_style_pixar_-v_6.1_fffb0440-ae2f-4257-9891-98bfb14ce5ec_0-1.jpg";s:8:"filesize";i:244874;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:107:"myonlyeye_exam_talking_casual_happy_style_pixar_-v_6.1_fffb0440-ae2f-4257-9891-98bfb14ce5ec_0-1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:18436;}s:9:"thumbnail";a:5:{s:4:"file";s:107:"myonlyeye_exam_talking_casual_happy_style_pixar_-v_6.1_fffb0440-ae2f-4257-9891-98bfb14ce5ec_0-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6836;}s:12:"medium_large";a:5:{s:4:"file";s:107:"myonlyeye_exam_talking_casual_happy_style_pixar_-v_6.1_fffb0440-ae2f-4257-9891-98bfb14ce5ec_0-1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:78535;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1516,1280,'_wp_attached_file','2025/03/myonlyeye_a_machine_the_prints_out_papers_with_questiongs_sty_294f241f-3f39-45b3-92d6-c8c4e52b5fcb_1-1.jpg');
INSERT INTO `wp_postmeta` VALUES (1517,1280,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:114:"2025/03/myonlyeye_a_machine_the_prints_out_papers_with_questiongs_sty_294f241f-3f39-45b3-92d6-c8c4e52b5fcb_1-1.jpg";s:8:"filesize";i:258745;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:114:"myonlyeye_a_machine_the_prints_out_papers_with_questiongs_sty_294f241f-3f39-45b3-92d6-c8c4e52b5fcb_1-1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:22621;}s:9:"thumbnail";a:5:{s:4:"file";s:114:"myonlyeye_a_machine_the_prints_out_papers_with_questiongs_sty_294f241f-3f39-45b3-92d6-c8c4e52b5fcb_1-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:7854;}s:12:"medium_large";a:5:{s:4:"file";s:114:"myonlyeye_a_machine_the_prints_out_papers_with_questiongs_sty_294f241f-3f39-45b3-92d6-c8c4e52b5fcb_1-1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:92282;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1518,1281,'_wp_attached_file','2025/03/pripovedac9665_a_young_standup_comedian_on_stage_bowing_toward__c3cf7bbf-fcde-467e-8333-e6643d5ed9f5-1.jpg');
INSERT INTO `wp_postmeta` VALUES (1519,1281,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:114:"2025/03/pripovedac9665_a_young_standup_comedian_on_stage_bowing_toward__c3cf7bbf-fcde-467e-8333-e6643d5ed9f5-1.jpg";s:8:"filesize";i:218461;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:114:"pripovedac9665_a_young_standup_comedian_on_stage_bowing_toward__c3cf7bbf-fcde-467e-8333-e6643d5ed9f5-1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:15597;}s:9:"thumbnail";a:5:{s:4:"file";s:114:"pripovedac9665_a_young_standup_comedian_on_stage_bowing_toward__c3cf7bbf-fcde-467e-8333-e6643d5ed9f5-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:5562;}s:12:"medium_large";a:5:{s:4:"file";s:114:"pripovedac9665_a_young_standup_comedian_on_stage_bowing_toward__c3cf7bbf-fcde-467e-8333-e6643d5ed9f5-1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:67930;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1520,1282,'_wp_attached_file','2025/03/kinetica___A_cute_Viking_with_a_surprised_expression_in_a_tradi_0c54d4e4-9dfe-4a2c-b8c3-3d392c288d13-1.jpg');
INSERT INTO `wp_postmeta` VALUES (1521,1282,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:114:"2025/03/kinetica___A_cute_Viking_with_a_surprised_expression_in_a_tradi_0c54d4e4-9dfe-4a2c-b8c3-3d392c288d13-1.jpg";s:8:"filesize";i:337609;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:114:"kinetica___A_cute_Viking_with_a_surprised_expression_in_a_tradi_0c54d4e4-9dfe-4a2c-b8c3-3d392c288d13-1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:19927;}s:9:"thumbnail";a:5:{s:4:"file";s:114:"kinetica___A_cute_Viking_with_a_surprised_expression_in_a_tradi_0c54d4e4-9dfe-4a2c-b8c3-3d392c288d13-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6314;}s:12:"medium_large";a:5:{s:4:"file";s:114:"kinetica___A_cute_Viking_with_a_surprised_expression_in_a_tradi_0c54d4e4-9dfe-4a2c-b8c3-3d392c288d13-1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:110351;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1522,1283,'_wp_attached_file','2025/03/myonlyeye_Dictionary_page_on_the_term_Ordliste_style_pixar_-_88317278-38ce-487f-bc3b-4d3427a309b0_2-1.jpg');
INSERT INTO `wp_postmeta` VALUES (1523,1283,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:113:"2025/03/myonlyeye_Dictionary_page_on_the_term_Ordliste_style_pixar_-_88317278-38ce-487f-bc3b-4d3427a309b0_2-1.jpg";s:8:"filesize";i:448822;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:113:"myonlyeye_Dictionary_page_on_the_term_Ordliste_style_pixar_-_88317278-38ce-487f-bc3b-4d3427a309b0_2-1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:25125;}s:9:"thumbnail";a:5:{s:4:"file";s:113:"myonlyeye_Dictionary_page_on_the_term_Ordliste_style_pixar_-_88317278-38ce-487f-bc3b-4d3427a309b0_2-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6957;}s:12:"medium_large";a:5:{s:4:"file";s:113:"myonlyeye_Dictionary_page_on_the_term_Ordliste_style_pixar_-_88317278-38ce-487f-bc3b-4d3427a309b0_2-1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:152465;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1524,1284,'_wp_attached_file','2025/03/myonlyeye_norwegian_words_-v_6.1_78a13bac-8f8f-4c1f-92c6-6736744334cc_0-1.jpg');
INSERT INTO `wp_postmeta` VALUES (1525,1284,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:85:"2025/03/myonlyeye_norwegian_words_-v_6.1_78a13bac-8f8f-4c1f-92c6-6736744334cc_0-1.jpg";s:8:"filesize";i:311828;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:85:"myonlyeye_norwegian_words_-v_6.1_78a13bac-8f8f-4c1f-92c6-6736744334cc_0-1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:18234;}s:9:"thumbnail";a:5:{s:4:"file";s:85:"myonlyeye_norwegian_words_-v_6.1_78a13bac-8f8f-4c1f-92c6-6736744334cc_0-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:5456;}s:12:"medium_large";a:5:{s:4:"file";s:85:"myonlyeye_norwegian_words_-v_6.1_78a13bac-8f8f-4c1f-92c6-6736744334cc_0-1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:103345;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1526,1285,'_wp_attached_file','2025/03/myonlyeye_A_whimsical_text-generating_machine_in_Pixar_animat_362a1a95-c5b2-4cdf-a339-7936e8c8587f_3-1.jpg');
INSERT INTO `wp_postmeta` VALUES (1527,1285,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:114:"2025/03/myonlyeye_A_whimsical_text-generating_machine_in_Pixar_animat_362a1a95-c5b2-4cdf-a339-7936e8c8587f_3-1.jpg";s:8:"filesize";i:431527;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:114:"myonlyeye_A_whimsical_text-generating_machine_in_Pixar_animat_362a1a95-c5b2-4cdf-a339-7936e8c8587f_3-1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:27106;}s:9:"thumbnail";a:5:{s:4:"file";s:114:"myonlyeye_A_whimsical_text-generating_machine_in_Pixar_animat_362a1a95-c5b2-4cdf-a339-7936e8c8587f_3-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:8521;}s:12:"medium_large";a:5:{s:4:"file";s:114:"myonlyeye_A_whimsical_text-generating_machine_in_Pixar_animat_362a1a95-c5b2-4cdf-a339-7936e8c8587f_3-1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:132665;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1528,1286,'_wp_attached_file','2025/03/exuberant_sparrow_76988_A_short_square_humanoid_robot_with_shor_c7763960-86cc-4974-9168-fd575cea354f-1.jpg');
INSERT INTO `wp_postmeta` VALUES (1529,1286,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:114:"2025/03/exuberant_sparrow_76988_A_short_square_humanoid_robot_with_shor_c7763960-86cc-4974-9168-fd575cea354f-1.jpg";s:8:"filesize";i:209329;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:114:"exuberant_sparrow_76988_A_short_square_humanoid_robot_with_shor_c7763960-86cc-4974-9168-fd575cea354f-1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:14743;}s:9:"thumbnail";a:5:{s:4:"file";s:114:"exuberant_sparrow_76988_A_short_square_humanoid_robot_with_shor_c7763960-86cc-4974-9168-fd575cea354f-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:5894;}s:12:"medium_large";a:5:{s:4:"file";s:114:"exuberant_sparrow_76988_A_short_square_humanoid_robot_with_shor_c7763960-86cc-4974-9168-fd575cea354f-1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:61818;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1530,1287,'_wp_attached_file','2025/03/myonlyeye_a_robot_correcting_a_text_style_Pixar_-v_6.1_cf9ea90a-ec47-4eed-a25c-76767f91f262_0-1.jpg');
INSERT INTO `wp_postmeta` VALUES (1531,1287,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:107:"2025/03/myonlyeye_a_robot_correcting_a_text_style_Pixar_-v_6.1_cf9ea90a-ec47-4eed-a25c-76767f91f262_0-1.jpg";s:8:"filesize";i:218508;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:107:"myonlyeye_a_robot_correcting_a_text_style_Pixar_-v_6.1_cf9ea90a-ec47-4eed-a25c-76767f91f262_0-1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:17866;}s:9:"thumbnail";a:5:{s:4:"file";s:107:"myonlyeye_a_robot_correcting_a_text_style_Pixar_-v_6.1_cf9ea90a-ec47-4eed-a25c-76767f91f262_0-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6567;}s:12:"medium_large";a:5:{s:4:"file";s:107:"myonlyeye_a_robot_correcting_a_text_style_Pixar_-v_6.1_cf9ea90a-ec47-4eed-a25c-76767f91f262_0-1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:74917;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1532,1288,'_wp_attached_file','2025/03/myonlyeye_a_student_having_a_good_dialog_with_a_robot_happy_p_000e19eb-ab9b-4281-9529-b4d55035c27c_1-1.jpg');
INSERT INTO `wp_postmeta` VALUES (1533,1288,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:114:"2025/03/myonlyeye_a_student_having_a_good_dialog_with_a_robot_happy_p_000e19eb-ab9b-4281-9529-b4d55035c27c_1-1.jpg";s:8:"filesize";i:284443;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:114:"myonlyeye_a_student_having_a_good_dialog_with_a_robot_happy_p_000e19eb-ab9b-4281-9529-b4d55035c27c_1-1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:19617;}s:9:"thumbnail";a:5:{s:4:"file";s:114:"myonlyeye_a_student_having_a_good_dialog_with_a_robot_happy_p_000e19eb-ab9b-4281-9529-b4d55035c27c_1-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6927;}s:12:"medium_large";a:5:{s:4:"file";s:114:"myonlyeye_a_student_having_a_good_dialog_with_a_robot_happy_p_000e19eb-ab9b-4281-9529-b4d55035c27c_1-1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:88699;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1534,1289,'_wp_attached_file','2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_2-1.jpg');
INSERT INTO `wp_postmeta` VALUES (1535,1289,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:114:"2025/03/myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_2-1.jpg";s:8:"filesize";i:266105;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:114:"myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_2-1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:17951;}s:9:"thumbnail";a:5:{s:4:"file";s:114:"myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_2-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6042;}s:12:"medium_large";a:5:{s:4:"file";s:114:"myonlyeye_an_open_chest_filled_with_famous_characters_view_fr_5e92c553-b83b-4e7b-8523-e9e603ec41ad_2-1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:86797;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1536,1290,'_wp_attached_file','2025/03/myonlyeye_an_open_chest_filled_with_famous_persons_view_from__7782a14e-35ee-4fdd-ba38-a2d5d9d49366_2-1.jpg');
INSERT INTO `wp_postmeta` VALUES (1537,1290,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:114:"2025/03/myonlyeye_an_open_chest_filled_with_famous_persons_view_from__7782a14e-35ee-4fdd-ba38-a2d5d9d49366_2-1.jpg";s:8:"filesize";i:317617;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:114:"myonlyeye_an_open_chest_filled_with_famous_persons_view_from__7782a14e-35ee-4fdd-ba38-a2d5d9d49366_2-1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:21156;}s:9:"thumbnail";a:5:{s:4:"file";s:114:"myonlyeye_an_open_chest_filled_with_famous_persons_view_from__7782a14e-35ee-4fdd-ba38-a2d5d9d49366_2-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6858;}s:12:"medium_large";a:5:{s:4:"file";s:114:"myonlyeye_an_open_chest_filled_with_famous_persons_view_from__7782a14e-35ee-4fdd-ba38-a2d5d9d49366_2-1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:101343;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1538,1291,'_wp_attached_file','2025/03/myonlyeye_an_open_chest_filled_with_different_appliances_view_29e51ea2-91c6-4c93-80f6-8fcdc64b55a6_1-1.jpg');
INSERT INTO `wp_postmeta` VALUES (1539,1291,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:114:"2025/03/myonlyeye_an_open_chest_filled_with_different_appliances_view_29e51ea2-91c6-4c93-80f6-8fcdc64b55a6_1-1.jpg";s:8:"filesize";i:189631;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:114:"myonlyeye_an_open_chest_filled_with_different_appliances_view_29e51ea2-91c6-4c93-80f6-8fcdc64b55a6_1-1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:16047;}s:9:"thumbnail";a:5:{s:4:"file";s:114:"myonlyeye_an_open_chest_filled_with_different_appliances_view_29e51ea2-91c6-4c93-80f6-8fcdc64b55a6_1-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:5723;}s:12:"medium_large";a:5:{s:4:"file";s:114:"myonlyeye_an_open_chest_filled_with_different_appliances_view_29e51ea2-91c6-4c93-80f6-8fcdc64b55a6_1-1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:66825;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1540,1292,'_wp_attached_file','2025/03/myonlyeye_a_casual_happy_helpful_teacher_assistant_writing_st_724bc28a-5b5e-43d1-9783-35618fa1f920_0-1-1.jpg');
INSERT INTO `wp_postmeta` VALUES (1541,1292,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:116:"2025/03/myonlyeye_a_casual_happy_helpful_teacher_assistant_writing_st_724bc28a-5b5e-43d1-9783-35618fa1f920_0-1-1.jpg";s:8:"filesize";i:278006;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:116:"myonlyeye_a_casual_happy_helpful_teacher_assistant_writing_st_724bc28a-5b5e-43d1-9783-35618fa1f920_0-1-1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:20960;}s:9:"thumbnail";a:5:{s:4:"file";s:116:"myonlyeye_a_casual_happy_helpful_teacher_assistant_writing_st_724bc28a-5b5e-43d1-9783-35618fa1f920_0-1-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:7252;}s:12:"medium_large";a:5:{s:4:"file";s:116:"myonlyeye_a_casual_happy_helpful_teacher_assistant_writing_st_724bc28a-5b5e-43d1-9783-35618fa1f920_0-1-1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:91250;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1542,1293,'_wp_attached_file','2025/03/myonlyeye_a_theater_stage_dreamy_metaphysical_-v_6.1_0f4692ab-8bef-4198-b02e-2befe068bfec_2-1.jpg');
INSERT INTO `wp_postmeta` VALUES (1543,1293,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:105:"2025/03/myonlyeye_a_theater_stage_dreamy_metaphysical_-v_6.1_0f4692ab-8bef-4198-b02e-2befe068bfec_2-1.jpg";s:8:"filesize";i:339144;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:105:"myonlyeye_a_theater_stage_dreamy_metaphysical_-v_6.1_0f4692ab-8bef-4198-b02e-2befe068bfec_2-1-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:20050;}s:9:"thumbnail";a:5:{s:4:"file";s:105:"myonlyeye_a_theater_stage_dreamy_metaphysical_-v_6.1_0f4692ab-8bef-4198-b02e-2befe068bfec_2-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6483;}s:12:"medium_large";a:5:{s:4:"file";s:105:"myonlyeye_a_theater_stage_dreamy_metaphysical_-v_6.1_0f4692ab-8bef-4198-b02e-2befe068bfec_2-1-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:99704;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1545,1222,'_thumbnail_id','1293');
INSERT INTO `wp_postmeta` VALUES (1546,1294,'_edit_lock','1762931205:80');
INSERT INTO `wp_postmeta` VALUES (1548,1294,'_thumbnail_id','1292');
INSERT INTO `wp_postmeta` VALUES (1549,1296,'_edit_lock','1742198291:80');
INSERT INTO `wp_postmeta` VALUES (1552,1296,'_thumbnail_id','1289');
INSERT INTO `wp_postmeta` VALUES (1553,1299,'_edit_lock','1742153232:80');
INSERT INTO `wp_postmeta` VALUES (1556,1299,'_thumbnail_id','1290');
INSERT INTO `wp_postmeta` VALUES (1557,1302,'_edit_lock','1742153267:80');
INSERT INTO `wp_postmeta` VALUES (1560,1302,'_thumbnail_id','1291');
INSERT INTO `wp_postmeta` VALUES (1562,1306,'_edit_lock','1742158981:80');
INSERT INTO `wp_postmeta` VALUES (1564,1306,'_thumbnail_id','1288');
INSERT INTO `wp_postmeta` VALUES (1565,1308,'_edit_lock','1742158964:80');
INSERT INTO `wp_postmeta` VALUES (1567,1308,'_thumbnail_id','1287');
INSERT INTO `wp_postmeta` VALUES (1569,1311,'_edit_lock','1742159027:80');
INSERT INTO `wp_postmeta` VALUES (1571,1311,'_thumbnail_id','1286');
INSERT INTO `wp_postmeta` VALUES (1572,1313,'_edit_lock','1742159103:80');
INSERT INTO `wp_postmeta` VALUES (1574,1313,'_thumbnail_id','1285');
INSERT INTO `wp_postmeta` VALUES (1575,1315,'_edit_lock','1742159142:80');
INSERT INTO `wp_postmeta` VALUES (1577,1315,'_thumbnail_id','1284');
INSERT INTO `wp_postmeta` VALUES (1578,1317,'_edit_lock','1742159193:80');
INSERT INTO `wp_postmeta` VALUES (1580,1317,'_thumbnail_id','1283');
INSERT INTO `wp_postmeta` VALUES (1581,1319,'_edit_lock','1742159231:80');
INSERT INTO `wp_postmeta` VALUES (1583,1319,'_thumbnail_id','1282');
INSERT INTO `wp_postmeta` VALUES (1584,1321,'_edit_lock','1742159260:80');
INSERT INTO `wp_postmeta` VALUES (1586,1321,'_thumbnail_id','1280');
INSERT INTO `wp_postmeta` VALUES (1587,1323,'_edit_lock','1742159310:80');
INSERT INTO `wp_postmeta` VALUES (1589,1323,'_thumbnail_id','1281');
INSERT INTO `wp_postmeta` VALUES (1590,1325,'_edit_lock','1742159361:80');
INSERT INTO `wp_postmeta` VALUES (1592,1325,'_thumbnail_id','1278');
INSERT INTO `wp_postmeta` VALUES (1593,1327,'_edit_lock','1742159654:80');
INSERT INTO `wp_postmeta` VALUES (1595,1327,'_thumbnail_id','1277');
INSERT INTO `wp_postmeta` VALUES (1596,1329,'_edit_lock','1742160006:80');
INSERT INTO `wp_postmeta` VALUES (1598,1329,'_thumbnail_id','1276');
INSERT INTO `wp_postmeta` VALUES (1599,1331,'_edit_lock','1742197246:80');
INSERT INTO `wp_postmeta` VALUES (1601,1331,'_thumbnail_id','1275');
INSERT INTO `wp_postmeta` VALUES (1602,1333,'_edit_lock','1742197283:80');
INSERT INTO `wp_postmeta` VALUES (1604,1333,'_thumbnail_id','1272');
INSERT INTO `wp_postmeta` VALUES (1605,1335,'_edit_lock','1742197347:80');
INSERT INTO `wp_postmeta` VALUES (1607,1335,'_thumbnail_id','1271');
INSERT INTO `wp_postmeta` VALUES (1608,1337,'_edit_lock','1742197394:80');
INSERT INTO `wp_postmeta` VALUES (1610,1337,'_thumbnail_id','1227');
INSERT INTO `wp_postmeta` VALUES (1611,1339,'_edit_lock','1742197425:80');
INSERT INTO `wp_postmeta` VALUES (1613,1339,'_thumbnail_id','1274');
INSERT INTO `wp_postmeta` VALUES (1614,1341,'_edit_lock','1742197457:80');
INSERT INTO `wp_postmeta` VALUES (1616,1341,'_thumbnail_id','1273');
INSERT INTO `wp_postmeta` VALUES (1617,1343,'_edit_lock','1742197547:80');
INSERT INTO `wp_postmeta` VALUES (1619,1343,'_thumbnail_id','1267');
INSERT INTO `wp_postmeta` VALUES (1620,1345,'_edit_lock','1742202775:80');
INSERT INTO `wp_postmeta` VALUES (1623,1345,'_thumbnail_id','1264');
INSERT INTO `wp_postmeta` VALUES (1624,1348,'_edit_lock','1742197677:80');
INSERT INTO `wp_postmeta` VALUES (1626,1348,'_thumbnail_id','1266');
INSERT INTO `wp_postmeta` VALUES (1627,1350,'_edit_lock','1742197722:80');
INSERT INTO `wp_postmeta` VALUES (1629,1350,'_thumbnail_id','1265');
INSERT INTO `wp_postmeta` VALUES (1630,1352,'_edit_lock','1742197753:80');
INSERT INTO `wp_postmeta` VALUES (1632,1352,'_thumbnail_id','1263');
INSERT INTO `wp_postmeta` VALUES (1635,1357,'_edit_lock','1742200019:80');
INSERT INTO `wp_postmeta` VALUES (1637,1357,'_thumbnail_id','1251');
INSERT INTO `wp_postmeta` VALUES (1638,1359,'_edit_lock','1742200077:80');
INSERT INTO `wp_postmeta` VALUES (1640,1359,'_thumbnail_id','1243');
INSERT INTO `wp_postmeta` VALUES (1641,1361,'_edit_lock','1762930806:80');
INSERT INTO `wp_postmeta` VALUES (1643,1361,'_thumbnail_id','1245');
INSERT INTO `wp_postmeta` VALUES (1644,1363,'_edit_lock','1742200226:80');
INSERT INTO `wp_postmeta` VALUES (1646,1363,'_thumbnail_id','1224');
INSERT INTO `wp_postmeta` VALUES (1647,1365,'_edit_lock','1762930768:80');
INSERT INTO `wp_postmeta` VALUES (1649,1365,'_thumbnail_id','1247');
INSERT INTO `wp_postmeta` VALUES (1650,1367,'_edit_lock','1742200485:80');
INSERT INTO `wp_postmeta` VALUES (1652,1367,'_thumbnail_id','1167');
INSERT INTO `wp_postmeta` VALUES (1653,1369,'_edit_lock','1742200566:80');
INSERT INTO `wp_postmeta` VALUES (1655,1369,'_thumbnail_id','1250');
INSERT INTO `wp_postmeta` VALUES (1656,1371,'_edit_lock','1742200696:80');
INSERT INTO `wp_postmeta` VALUES (1658,1371,'_thumbnail_id','1252');
INSERT INTO `wp_postmeta` VALUES (1659,1373,'_edit_lock','1742200981:80');
INSERT INTO `wp_postmeta` VALUES (1661,1373,'_thumbnail_id','1255');
INSERT INTO `wp_postmeta` VALUES (1662,1375,'_edit_lock','1742201066:80');
INSERT INTO `wp_postmeta` VALUES (1664,1375,'_thumbnail_id','1249');
INSERT INTO `wp_postmeta` VALUES (1665,1377,'_edit_lock','1748863702:80');
INSERT INTO `wp_postmeta` VALUES (1667,1377,'_thumbnail_id','1227');
INSERT INTO `wp_postmeta` VALUES (1668,1379,'_edit_lock','1742201371:80');
INSERT INTO `wp_postmeta` VALUES (1670,1379,'_thumbnail_id','1248');
INSERT INTO `wp_postmeta` VALUES (1671,1381,'_edit_lock','1742201456:80');
INSERT INTO `wp_postmeta` VALUES (1673,1381,'_thumbnail_id','1237');
INSERT INTO `wp_postmeta` VALUES (1674,1383,'_edit_lock','1742201828:80');
INSERT INTO `wp_postmeta` VALUES (1676,1383,'_thumbnail_id','1226');
INSERT INTO `wp_postmeta` VALUES (1678,1387,'_edit_lock','1742202726:80');
INSERT INTO `wp_postmeta` VALUES (1679,1387,'_thumbnail_id','1264');
INSERT INTO `wp_postmeta` VALUES (1681,1390,'_edit_lock','1742202997:80');
INSERT INTO `wp_postmeta` VALUES (1685,1390,'_thumbnail_id','1290');
INSERT INTO `wp_postmeta` VALUES (1692,1394,'_wp_attached_file','2025/03/KI-i-Randabergskolen.png');
INSERT INTO `wp_postmeta` VALUES (1693,1394,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:32:"2025/03/KI-i-Randabergskolen.png";s:8:"filesize";i:780876;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:32:"KI-i-Randabergskolen-300x300.png";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:82401;}s:9:"thumbnail";a:5:{s:4:"file";s:32:"KI-i-Randabergskolen-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:24526;}s:12:"medium_large";a:5:{s:4:"file";s:32:"KI-i-Randabergskolen-768x768.png";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:382086;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1694,1395,'_wp_attached_file','2025/03/cropped-KI-i-Randabergskolen.png');
INSERT INTO `wp_postmeta` VALUES (1695,1395,'_wp_attachment_context','site-icon');
INSERT INTO `wp_postmeta` VALUES (1696,1395,'_wp_attachment_metadata','a:6:{s:5:"width";i:512;s:6:"height";i:512;s:4:"file";s:40:"2025/03/cropped-KI-i-Randabergskolen.png";s:8:"filesize";i:182427;s:5:"sizes";a:6:{s:6:"medium";a:5:{s:4:"file";s:40:"cropped-KI-i-Randabergskolen-300x300.png";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:85640;}s:9:"thumbnail";a:5:{s:4:"file";s:40:"cropped-KI-i-Randabergskolen-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:26053;}s:13:"site_icon-270";a:5:{s:4:"file";s:40:"cropped-KI-i-Randabergskolen-270x270.png";s:5:"width";i:270;s:6:"height";i:270;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:72160;}s:13:"site_icon-192";a:5:{s:4:"file";s:40:"cropped-KI-i-Randabergskolen-192x192.png";s:5:"width";i:192;s:6:"height";i:192;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:35221;}s:13:"site_icon-180";a:5:{s:4:"file";s:40:"cropped-KI-i-Randabergskolen-180x180.png";s:5:"width";i:180;s:6:"height";i:180;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:35926;}s:12:"site_icon-32";a:5:{s:4:"file";s:38:"cropped-KI-i-Randabergskolen-32x32.png";s:5:"width";i:32;s:6:"height";i:32;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:1993;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1699,1395,'transparency','1');
INSERT INTO `wp_postmeta` VALUES (1700,1394,'transparency','1');
INSERT INTO `wp_postmeta` VALUES (1701,1293,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1702,1167,'transparency','0');
INSERT INTO `wp_postmeta` VALUES (1703,1293,'png_converted','1264895');
INSERT INTO `wp_postmeta` VALUES (1704,1167,'png_converted','1261442');
INSERT INTO `wp_postmeta` VALUES (1705,1167,'_wp_old_slug','diskusjonen');
INSERT INTO `wp_postmeta` VALUES (1709,1405,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1711,979,'_wp_old_slug','pa-hvilken-mate-er-en-praterobot-intelligent');
INSERT INTO `wp_postmeta` VALUES (1712,1406,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1714,1407,'footnotes','');
INSERT INTO `wp_postmeta` VALUES (1717,1410,'_edit_lock','1762930985:80');
INSERT INTO `wp_postmeta` VALUES (1718,1411,'_wp_attached_file','2025/11/myonlyeye_a_friendly_barista._style_pixar_animation._-v_7_fb960928-8e5e-46ae-86e6-a310face24b2_0.png');
INSERT INTO `wp_postmeta` VALUES (1719,1411,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:108:"2025/11/myonlyeye_a_friendly_barista._style_pixar_animation._-v_7_fb960928-8e5e-46ae-86e6-a310face24b2_0.png";s:8:"filesize";i:1073891;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:108:"myonlyeye_a_friendly_barista._style_pixar_animation._-v_7_fb960928-8e5e-46ae-86e6-a310face24b2_0-300x300.png";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:134501;}s:9:"thumbnail";a:5:{s:4:"file";s:108:"myonlyeye_a_friendly_barista._style_pixar_animation._-v_7_fb960928-8e5e-46ae-86e6-a310face24b2_0-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:41822;}s:12:"medium_large";a:5:{s:4:"file";s:108:"myonlyeye_a_friendly_barista._style_pixar_animation._-v_7_fb960928-8e5e-46ae-86e6-a310face24b2_0-768x768.png";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:707800;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1721,1410,'_thumbnail_id','1411');
INSERT INTO `wp_postmeta` VALUES (1722,1413,'_edit_lock','1762931105:80');
INSERT INTO `wp_postmeta` VALUES (1723,1414,'_wp_attached_file','2025/11/myonlyeye_a_casual_happy_journalist_sitting_behind_a_bussy_ne_1cb412af-c33a-48f0-a810-279d7ff6edbb_0.jpg');
INSERT INTO `wp_postmeta` VALUES (1724,1414,'_wp_attachment_metadata','a:6:{s:5:"width";i:1024;s:6:"height";i:1024;s:4:"file";s:112:"2025/11/myonlyeye_a_casual_happy_journalist_sitting_behind_a_bussy_ne_1cb412af-c33a-48f0-a810-279d7ff6edbb_0.jpg";s:8:"filesize";i:193028;s:5:"sizes";a:3:{s:6:"medium";a:5:{s:4:"file";s:112:"myonlyeye_a_casual_happy_journalist_sitting_behind_a_bussy_ne_1cb412af-c33a-48f0-a810-279d7ff6edbb_0-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:18114;}s:9:"thumbnail";a:5:{s:4:"file";s:112:"myonlyeye_a_casual_happy_journalist_sitting_behind_a_bussy_ne_1cb412af-c33a-48f0-a810-279d7ff6edbb_0-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6631;}s:12:"medium_large";a:5:{s:4:"file";s:112:"myonlyeye_a_casual_happy_journalist_sitting_behind_a_bussy_ne_1cb412af-c33a-48f0-a810-279d7ff6edbb_0-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:68839;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp_postmeta` VALUES (1726,1413,'_thumbnail_id','1414');
/*!40000 ALTER TABLE `wp_postmeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_options`
--

DROP TABLE IF EXISTS `wp_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=117506 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_options`
--

LOCK TABLES `wp_options` WRITE;
/*!40000 ALTER TABLE `wp_options` DISABLE KEYS */;
INSERT INTO `wp_options` VALUES (1,'siteurl','https://ki.zork.no','yes');
INSERT INTO `wp_options` VALUES (2,'home','https://ki.zork.no','yes');
INSERT INTO `wp_options` VALUES (3,'blogname','[nettstedet]','yes');
INSERT INTO `wp_options` VALUES (4,'blogdescription','','yes');
INSERT INTO `wp_options` VALUES (5,'users_can_register','0','yes');
INSERT INTO `wp_options` VALUES (6,'admin_email','noemail@noemail.noemail','yes');
INSERT INTO `wp_options` VALUES (7,'start_of_week','1','yes');
INSERT INTO `wp_options` VALUES (8,'use_balanceTags','0','yes');
INSERT INTO `wp_options` VALUES (9,'use_smilies','1','yes');
INSERT INTO `wp_options` VALUES (10,'require_name_email','','yes');
INSERT INTO `wp_options` VALUES (11,'comments_notify','1','yes');
INSERT INTO `wp_options` VALUES (12,'posts_per_rss','10','yes');
INSERT INTO `wp_options` VALUES (13,'rss_use_excerpt','1','yes');
INSERT INTO `wp_options` VALUES (14,'mailserver_url','mail.example.com','yes');
INSERT INTO `wp_options` VALUES (15,'mailserver_login','login@example.com','yes');
INSERT INTO `wp_options` VALUES (16,'mailserver_pass','password','yes');
INSERT INTO `wp_options` VALUES (17,'mailserver_port','110','yes');
INSERT INTO `wp_options` VALUES (18,'default_category','1','yes');
INSERT INTO `wp_options` VALUES (20,'default_ping_status','open','yes');
INSERT INTO `wp_options` VALUES (21,'default_pingback_flag','','yes');
INSERT INTO `wp_options` VALUES (22,'posts_per_page','9','yes');
INSERT INTO `wp_options` VALUES (23,'date_format','j. F Y','yes');
INSERT INTO `wp_options` VALUES (24,'time_format','H:i','yes');
INSERT INTO `wp_options` VALUES (25,'links_updated_date_format','j. F Y H:i','yes');
INSERT INTO `wp_options` VALUES (26,'comment_moderation','','yes');
INSERT INTO `wp_options` VALUES (27,'moderation_notify','1','yes');
INSERT INTO `wp_options` VALUES (28,'permalink_structure','/%postname%/','yes');
INSERT INTO `wp_options` VALUES (29,'rewrite_rules','a:95:{s:11:"^wp-json/?$";s:22:"index.php?rest_route=/";s:14:"^wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:21:"^index.php/wp-json/?$";s:22:"index.php?rest_route=/";s:24:"^index.php/wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:17:"^wp-sitemap\\.xml$";s:23:"index.php?sitemap=index";s:17:"^wp-sitemap\\.xsl$";s:36:"index.php?sitemap-stylesheet=sitemap";s:23:"^wp-sitemap-index\\.xsl$";s:34:"index.php?sitemap-stylesheet=index";s:48:"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$";s:75:"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]";s:34:"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$";s:47:"index.php?sitemap=$matches[1]&paged=$matches[2]";s:47:"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:42:"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:23:"category/(.+?)/embed/?$";s:46:"index.php?category_name=$matches[1]&embed=true";s:35:"category/(.+?)/page/?([0-9]{1,})/?$";s:53:"index.php?category_name=$matches[1]&paged=$matches[2]";s:17:"category/(.+?)/?$";s:35:"index.php?category_name=$matches[1]";s:44:"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:39:"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:20:"tag/([^/]+)/embed/?$";s:36:"index.php?tag=$matches[1]&embed=true";s:32:"tag/([^/]+)/page/?([0-9]{1,})/?$";s:43:"index.php?tag=$matches[1]&paged=$matches[2]";s:14:"tag/([^/]+)/?$";s:25:"index.php?tag=$matches[1]";s:45:"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:40:"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:21:"type/([^/]+)/embed/?$";s:44:"index.php?post_format=$matches[1]&embed=true";s:33:"type/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?post_format=$matches[1]&paged=$matches[2]";s:15:"type/([^/]+)/?$";s:33:"index.php?post_format=$matches[1]";s:12:"robots\\.txt$";s:18:"index.php?robots=1";s:13:"favicon\\.ico$";s:19:"index.php?favicon=1";s:12:"sitemap\\.xml";s:24:"index.php??sitemap=index";s:48:".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$";s:18:"index.php?feed=old";s:20:".*wp-app\\.php(/.*)?$";s:19:"index.php?error=403";s:18:".*wp-register.php$";s:23:"index.php?register=true";s:32:"feed/(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:27:"(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:8:"embed/?$";s:21:"index.php?&embed=true";s:20:"page/?([0-9]{1,})/?$";s:28:"index.php?&paged=$matches[1]";s:27:"comment-page-([0-9]{1,})/?$";s:41:"index.php?&page_id=1187&cpage=$matches[1]";s:41:"comments/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:36:"comments/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:17:"comments/embed/?$";s:21:"index.php?&embed=true";s:44:"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:39:"search/(.+)/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:20:"search/(.+)/embed/?$";s:34:"index.php?s=$matches[1]&embed=true";s:32:"search/(.+)/page/?([0-9]{1,})/?$";s:41:"index.php?s=$matches[1]&paged=$matches[2]";s:14:"search/(.+)/?$";s:23:"index.php?s=$matches[1]";s:47:"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:42:"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:23:"author/([^/]+)/embed/?$";s:44:"index.php?author_name=$matches[1]&embed=true";s:35:"author/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?author_name=$matches[1]&paged=$matches[2]";s:17:"author/([^/]+)/?$";s:33:"index.php?author_name=$matches[1]";s:69:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:45:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$";s:74:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]";s:39:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$";s:63:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]";s:56:"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:51:"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:32:"([0-9]{4})/([0-9]{1,2})/embed/?$";s:58:"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true";s:44:"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]";s:26:"([0-9]{4})/([0-9]{1,2})/?$";s:47:"index.php?year=$matches[1]&monthnum=$matches[2]";s:43:"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:38:"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:19:"([0-9]{4})/embed/?$";s:37:"index.php?year=$matches[1]&embed=true";s:31:"([0-9]{4})/page/?([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&paged=$matches[2]";s:13:"([0-9]{4})/?$";s:26:"index.php?year=$matches[1]";s:27:".?.+?/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:".?.+?/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:33:".?.+?/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:16:"(.?.+?)/embed/?$";s:41:"index.php?pagename=$matches[1]&embed=true";s:20:"(.?.+?)/trackback/?$";s:35:"index.php?pagename=$matches[1]&tb=1";s:40:"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:35:"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:28:"(.?.+?)/page/?([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&paged=$matches[2]";s:35:"(.?.+?)/comment-page-([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&cpage=$matches[2]";s:24:"(.?.+?)(?:/([0-9]+))?/?$";s:47:"index.php?pagename=$matches[1]&page=$matches[2]";s:27:"[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:"[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:33:"[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:16:"([^/]+)/embed/?$";s:37:"index.php?name=$matches[1]&embed=true";s:20:"([^/]+)/trackback/?$";s:31:"index.php?name=$matches[1]&tb=1";s:40:"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?name=$matches[1]&feed=$matches[2]";s:35:"([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?name=$matches[1]&feed=$matches[2]";s:28:"([^/]+)/page/?([0-9]{1,})/?$";s:44:"index.php?name=$matches[1]&paged=$matches[2]";s:35:"([^/]+)/comment-page-([0-9]{1,})/?$";s:44:"index.php?name=$matches[1]&cpage=$matches[2]";s:24:"([^/]+)(?:/([0-9]+))?/?$";s:43:"index.php?name=$matches[1]&page=$matches[2]";s:16:"[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:26:"[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:46:"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:41:"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:41:"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:22:"[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";}','yes');
INSERT INTO `wp_options` VALUES (30,'hack_file','0','yes');
INSERT INTO `wp_options` VALUES (31,'blog_charset','UTF-8','yes');
INSERT INTO `wp_options` VALUES (32,'moderation_keys','','no');
INSERT INTO `wp_options` VALUES (33,'active_plugins','a:7:{i:0;s:23:"ai-engine/ai-engine.php";i:1;s:37:"block-visibility/block-visibility.php";i:2;s:31:"media-cleaner/media-cleaner.php";i:3;s:41:"password-protected/password-protected.php";i:4;s:25:"png-to-jpg/png-to-jpg.php";i:5;s:53:"query-loop-post-selector/query-loop-post-selector.php";i:6;s:47:"wpvivid-backuprestore/wpvivid-backuprestore.php";}','yes');
INSERT INTO `wp_options` VALUES (34,'category_base','','yes');
INSERT INTO `wp_options` VALUES (35,'ping_sites','http://rpc.pingomatic.com/','yes');
INSERT INTO `wp_options` VALUES (36,'comment_max_links','2','yes');
INSERT INTO `wp_options` VALUES (37,'gmt_offset','','yes');
INSERT INTO `wp_options` VALUES (38,'default_email_category','1','yes');
INSERT INTO `wp_options` VALUES (39,'recently_edited','a:5:{i:0;s:82:"/storage/html/ai.randabergskolen.no/wp-content/plugins/ai-engine-pro/dev-notes.txt";i:1;s:96:"/storage/html/ai.randabergskolen.no/wp-content/plugins/ai-engine-pro/themes/Messages.module.scss";i:2;s:94:"/storage/html/ai.randabergskolen.no/wp-content/plugins/ai-engine-pro/themes/ChatGPT.module.css";i:3;s:95:"/storage/html/ai.randabergskolen.no/wp-content/plugins/ai-engine-pro/themes/Messages.module.css";i:4;s:86:"/storage/html/ai.randabergskolen.no/wp-content/plugins/ai-engine-pro/ai-engine-pro.php";}','no');
INSERT INTO `wp_options` VALUES (40,'template','twentytwentythree','yes');
INSERT INTO `wp_options` VALUES (41,'stylesheet','twentytwentythree','yes');
INSERT INTO `wp_options` VALUES (42,'comment_registration','1','yes');
INSERT INTO `wp_options` VALUES (43,'html_type','text/html','yes');
INSERT INTO `wp_options` VALUES (44,'use_trackback','0','yes');
INSERT INTO `wp_options` VALUES (45,'default_role','subscriber','yes');
INSERT INTO `wp_options` VALUES (46,'db_version','60421','yes');
INSERT INTO `wp_options` VALUES (47,'uploads_use_yearmonth_folders','1','yes');
INSERT INTO `wp_options` VALUES (48,'upload_path','','yes');
INSERT INTO `wp_options` VALUES (49,'blog_public','0','yes');
INSERT INTO `wp_options` VALUES (50,'default_link_category','2','yes');
INSERT INTO `wp_options` VALUES (51,'show_on_front','page','yes');
INSERT INTO `wp_options` VALUES (52,'tag_base','','yes');
INSERT INTO `wp_options` VALUES (53,'show_avatars','1','yes');
INSERT INTO `wp_options` VALUES (54,'avatar_rating','G','yes');
INSERT INTO `wp_options` VALUES (55,'upload_url_path','','yes');
INSERT INTO `wp_options` VALUES (56,'thumbnail_size_w','150','yes');
INSERT INTO `wp_options` VALUES (57,'thumbnail_size_h','150','yes');
INSERT INTO `wp_options` VALUES (58,'thumbnail_crop','1','yes');
INSERT INTO `wp_options` VALUES (59,'medium_size_w','300','yes');
INSERT INTO `wp_options` VALUES (60,'medium_size_h','300','yes');
INSERT INTO `wp_options` VALUES (61,'avatar_default','mystery','yes');
INSERT INTO `wp_options` VALUES (62,'large_size_w','1024','yes');
INSERT INTO `wp_options` VALUES (63,'large_size_h','1024','yes');
INSERT INTO `wp_options` VALUES (64,'image_default_link_type','none','yes');
INSERT INTO `wp_options` VALUES (65,'image_default_size','','yes');
INSERT INTO `wp_options` VALUES (66,'image_default_align','','yes');
INSERT INTO `wp_options` VALUES (67,'close_comments_for_old_posts','','yes');
INSERT INTO `wp_options` VALUES (68,'close_comments_days_old','14','yes');
INSERT INTO `wp_options` VALUES (69,'thread_comments','1','yes');
INSERT INTO `wp_options` VALUES (70,'thread_comments_depth','5','yes');
INSERT INTO `wp_options` VALUES (71,'page_comments','','yes');
INSERT INTO `wp_options` VALUES (72,'comments_per_page','50','yes');
INSERT INTO `wp_options` VALUES (73,'default_comments_page','newest','yes');
INSERT INTO `wp_options` VALUES (74,'comment_order','asc','yes');
INSERT INTO `wp_options` VALUES (75,'sticky_posts','a:0:{}','yes');
INSERT INTO `wp_options` VALUES (76,'widget_categories','a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (77,'widget_text','a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (78,'widget_rss','a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (79,'uninstall_plugins','a:3:{s:27:"wp-optimize/wp-optimize.php";a:2:{i:0;s:13:"WPO_Uninstall";i:1;s:7:"actions";}s:49:"advanced-database-cleaner/advanced-db-cleaner.php";a:2:{i:0;s:24:"ADBC_Advanced_DB_Cleaner";i:1;s:14:"aDBc_uninstall";}s:45:"restrict-user-access/restrict-user-access.php";a:2:{i:0;s:8:"Freemius";i:1;s:22:"_uninstall_plugin_hook";}}','no');
INSERT INTO `wp_options` VALUES (80,'timezone_string','Europe/Oslo','yes');
INSERT INTO `wp_options` VALUES (81,'page_for_posts','0','yes');
INSERT INTO `wp_options` VALUES (82,'page_on_front','1187','yes');
INSERT INTO `wp_options` VALUES (83,'default_post_format','0','yes');
INSERT INTO `wp_options` VALUES (84,'link_manager_enabled','0','yes');
INSERT INTO `wp_options` VALUES (85,'finished_splitting_shared_terms','1','yes');
INSERT INTO `wp_options` VALUES (86,'site_icon','1394','yes');
INSERT INTO `wp_options` VALUES (87,'medium_large_size_w','768','yes');
INSERT INTO `wp_options` VALUES (88,'medium_large_size_h','0','yes');
INSERT INTO `wp_options` VALUES (89,'wp_page_for_privacy_policy','3','yes');
INSERT INTO `wp_options` VALUES (90,'show_comments_cookies_opt_in','1','yes');
INSERT INTO `wp_options` VALUES (91,'admin_email_lifespan','1763793089','yes');
INSERT INTO `wp_options` VALUES (92,'disallowed_keys','','no');
INSERT INTO `wp_options` VALUES (93,'comment_previously_approved','1','yes');
INSERT INTO `wp_options` VALUES (94,'auto_plugin_theme_update_emails','a:0:{}','no');
INSERT INTO `wp_options` VALUES (95,'auto_update_core_dev','enabled','yes');
INSERT INTO `wp_options` VALUES (96,'auto_update_core_minor','enabled','yes');
INSERT INTO `wp_options` VALUES (97,'auto_update_core_major','enabled','yes');
INSERT INTO `wp_options` VALUES (98,'wp_force_deactivated_plugins','a:0:{}','off');
INSERT INTO `wp_options` VALUES (99,'initial_db_version','53496','yes');
INSERT INTO `wp_options` VALUES (100,'wp_user_roles','a:5:{s:13:"administrator";a:2:{s:4:"name";s:13:"Administrator";s:12:"capabilities";a:66:{s:13:"switch_themes";b:1;s:11:"edit_themes";b:1;s:16:"activate_plugins";b:1;s:12:"edit_plugins";b:1;s:10:"edit_users";b:1;s:10:"edit_files";b:1;s:14:"manage_options";b:1;s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:6:"import";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:8:"level_10";b:1;s:7:"level_9";b:1;s:7:"level_8";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:12:"delete_users";b:1;s:12:"create_users";b:1;s:17:"unfiltered_upload";b:1;s:14:"edit_dashboard";b:1;s:14:"update_plugins";b:1;s:14:"delete_plugins";b:1;s:15:"install_plugins";b:1;s:13:"update_themes";b:1;s:14:"install_themes";b:1;s:11:"update_core";b:1;s:10:"list_users";b:1;s:12:"remove_users";b:1;s:13:"promote_users";b:1;s:18:"edit_theme_options";b:1;s:13:"delete_themes";b:1;s:6:"export";b:1;s:19:"wp-piwik_read_stats";b:1;s:16:"wp-piwik_stealth";b:1;s:23:"wf2fa_activate_2fa_self";b:1;s:25:"wf2fa_activate_2fa_others";b:1;s:21:"wf2fa_manage_settings";b:1;}}s:6:"editor";a:2:{s:4:"name";s:6:"Editor";s:12:"capabilities";a:34:{s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;}}s:6:"author";a:2:{s:4:"name";s:6:"Author";s:12:"capabilities";a:10:{s:12:"upload_files";b:1;s:10:"edit_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:4:"read";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;s:22:"delete_published_posts";b:1;}}s:11:"contributor";a:2:{s:4:"name";s:11:"Contributor";s:12:"capabilities";a:5:{s:10:"edit_posts";b:1;s:4:"read";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;}}s:10:"subscriber";a:2:{s:4:"name";s:10:"Subscriber";s:12:"capabilities";a:2:{s:4:"read";b:1;s:7:"level_0";b:1;}}}','yes');
INSERT INTO `wp_options` VALUES (101,'fresh_site','0','off');
INSERT INTO `wp_options` VALUES (102,'WPLANG','nb_NO','yes');
INSERT INTO `wp_options` VALUES (103,'user_count','3','no');
INSERT INTO `wp_options` VALUES (104,'widget_block','a:6:{i:2;a:1:{s:7:"content";s:19:"<!-- wp:search /-->";}i:3;a:1:{s:7:"content";s:155:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Siste innlegg</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->";}i:4;a:1:{s:7:"content";s:229:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Siste kommentarer</h2><!-- /wp:heading --><!-- wp:latest-comments {"displayAvatar":false,"displayDate":false,"displayExcerpt":false} /--></div><!-- /wp:group -->";}i:5;a:1:{s:7:"content";s:143:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Arkiv</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->";}i:6;a:1:{s:7:"content";s:150:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Kategorier</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->";}s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (105,'sidebars_widgets','a:6:{s:19:"wp_inactive_widgets";a:0:{}s:10:"footer-one";a:2:{i:0;s:7:"block-5";i:1;s:7:"block-6";}s:10:"footer-two";a:0:{}s:9:"sidebar-1";a:3:{i:0;s:7:"block-2";i:1;s:7:"block-3";i:2;s:7:"block-4";}s:9:"sidebar-2";a:0:{}s:13:"array_version";i:3;}','yes');
INSERT INTO `wp_options` VALUES (106,'cron','a:12:{i:1762931307;a:1:{s:23:"mwai_tasks_internal_run";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"one_minute";s:4:"args";a:0:{}s:8:"interval";i:60;}}}i:1762931324;a:1:{s:33:"wpvivid_clean_backup_record_event";a:1:{s:32:"a8cf63fecab3eb3edf6760bc02f258a6";a:2:{s:8:"schedule";b:0;s:4:"args";a:1:{i:0;b:0;}}}}i:1762931384;a:1:{s:28:"wpvivid_task_monitor_event_2";a:1:{s:32:"2252f2de755830fe6c0cd2fd37ed590a";a:2:{s:8:"schedule";b:0;s:4:"args";a:1:{i:0;s:21:"wpvivid-c3a034d9b4de2";}}}}i:1762932260;a:1:{s:34:"wp_privacy_delete_old_export_files";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"hourly";s:4:"args";a:0:{}s:8:"interval";i:3600;}}}i:1762953860;a:4:{s:32:"recovery_mode_clean_expired_keys";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:16:"wp_version_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:17:"wp_update_plugins";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:16:"wp_update_themes";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1762953870;a:4:{s:19:"wp_scheduled_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:25:"delete_expired_transients";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:30:"wp_scheduled_auto_draft_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:21:"wp_update_user_counts";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1762992000;a:1:{s:22:"wdev_logger_clear_logs";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1762995600;a:1:{s:26:"wpca/cache_condition_types";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1762998494;a:1:{s:36:"fs_data_sync_password-protected-free";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1763125175;a:1:{s:30:"wp_delete_temp_updater_backups";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}}i:1763213060;a:1:{s:30:"wp_site_health_scheduled_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}}s:7:"version";i:2;}','on');
INSERT INTO `wp_options` VALUES (107,'widget_pages','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (108,'widget_calendar','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (109,'widget_archives','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (110,'widget_media_audio','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (111,'widget_media_image','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (112,'widget_media_gallery','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (113,'widget_media_video','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (114,'widget_meta','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (115,'widget_search','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (116,'widget_recent-posts','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (117,'widget_recent-comments','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (118,'widget_tag_cloud','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (119,'widget_nav_menu','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (120,'widget_custom_html','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (122,'recovery_keys','a:0:{}','off');
INSERT INTO `wp_options` VALUES (125,'theme_mods_twentytwentythree','a:4:{s:18:"custom_css_post_id";i:-1;s:16:"sidebars_widgets";a:2:{s:4:"time";i:1681155374;s:4:"data";a:5:{s:19:"wp_inactive_widgets";a:0:{}s:10:"footer-one";a:0:{}s:10:"footer-two";a:0:{}s:9:"sidebar-1";a:3:{i:0;s:7:"block-2";i:1;s:7:"block-3";i:2;s:7:"block-4";}s:9:"sidebar-2";a:2:{i:0;s:7:"block-5";i:1;s:7:"block-6";}}}s:19:"wp_classic_sidebars";a:2:{s:10:"footer-one";a:11:{s:4:"name";s:9:"Footer #1";s:2:"id";s:10:"footer-one";s:11:"description";s:67:"Widgeter i dette området vil vises i første kolonne i sidebunnen.";s:5:"class";s:0:"";s:13:"before_widget";s:53:"<div class="widget %2$s"><div class="widget-content">";s:12:"after_widget";s:12:"</div></div>";s:12:"before_title";s:51:"<h2 class="widget-title subheading heading-size-3">";s:11:"after_title";s:5:"</h2>";s:14:"before_sidebar";s:0:"";s:13:"after_sidebar";s:0:"";s:12:"show_in_rest";b:0;}s:10:"footer-two";a:11:{s:4:"name";s:9:"Footer #2";s:2:"id";s:10:"footer-two";s:11:"description";s:66:"Widgeter i dette området vil vises i andre kolonner i sidebunnen.";s:5:"class";s:0:"";s:13:"before_widget";s:53:"<div class="widget %2$s"><div class="widget-content">";s:12:"after_widget";s:12:"</div></div>";s:12:"before_title";s:51:"<h2 class="widget-title subheading heading-size-3">";s:11:"after_title";s:5:"</h2>";s:14:"before_sidebar";s:0:"";s:13:"after_sidebar";s:0:"";s:12:"show_in_rest";b:0;}}s:18:"nav_menu_locations";a:0:{}}','yes');
INSERT INTO `wp_options` VALUES (128,'https_detection_errors','a:1:{s:19:"bad_response_source";a:1:{i:0;s:55:"Det ser ut som om svaret ikke kom fra dette nettstedet.";}}','off');
INSERT INTO `wp_options` VALUES (167,'recently_activated','a:0:{}','off');
INSERT INTO `wp_options` VALUES (170,'finished_updating_comment_type','1','yes');
INSERT INTO `wp_options` VALUES (179,'mwai_rating_date','1839358269','no');
INSERT INTO `wp_options` VALUES (180,'meowapps_news','a:2:{s:5:"topic";s:8:"mwai-1.0";s:4:"date";i:1680155319;}','no');
INSERT INTO `wp_options` VALUES (185,'edd_sl_9bb7c3f354bda668975895478a4f2607','a:2:{s:7:"timeout";i:1679675310;s:5:"value";s:50194:"{"new_version":"1.3.74","stable_version":"1.3.74","name":"AI Engine Pro","slug":"ai-engine-pro","url":"https:\\/\\/meowapps.com\\/products\\/ai-engine-pro\\/?changelog=1","last_updated":"2023-03-23 23:24:57","homepage":"https:\\/\\/meowapps.com\\/products\\/ai-engine-pro\\/","package":"","download_link":"","sections":{"description":"<p>Create a ChatGPT-like chatbot (or many of them, with different features and behaviors), generate content, images, quickly suggest titles and excerpts, track your OpenAI usage stats, and much more!<\\/p>\\n","changelog":"<p>1.3.74 (2023\\/03\\/24)<\\/p>\\n<ul>\\n<li>Fix: On some installs, floats would be echoed with commas instead of dots.<\\/li>\\n<li>Info: It\'s my birthday &#x270c;&#xfe0f;&#x1f973;<\\/li>\\n<li>Info: Motivate me with <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/reviews\\/\\">a little review here<\\/a>. Thank you!<\\/li>\\n<\\/ul>\\n<p>1.3.73 (2023\\/03\\/23)<\\/p>\\n<ul>\\n<li>Add: Post Type for Content Generator.<\\/li>\\n<li>Fix: Avoid a crash for the server which didn\'t install mbstring.<\\/li>\\n<li>Fix: The Meow Apps dashboard is back, with PHP Error Logs and evergthing.<\\/li>\\n<li>Info: Help or discuss with other users on <a href=\\"https:\\/\\/discord.gg\\/bHDGh38\\">my Discord<\\/a>.<\\/li>\\n<li>Info: Share your feedbacks\\/issues in the <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/\\">Support Threads<\\/a>.<\\/li>\\n<\\/ul>\\n<p>1.3.69 (2023\\/03\\/22)<\\/p>\\n<ul>\\n<li>Fix: Issue with non-default models in the forms.<\\/li>\\n<li>Add: Default value and rows for textarea and input fields.<\\/li>\\n<li>Fix: Assistants weren\'t really disabled (depending on the settings).<\\/li>\\n<li>Fix: Simplified a few UI elements.<\\/li>\\n<\\/ul>\\n<p>1.3.67 (2023\\/03\\/21)<\\/p>\\n<ul>\\n<li>Update: The Finetunes are now a module, that can be completely disabled (and it is, by default).<\\/li>\\n<li>Update: Overhaul of the language system. It\'s now unified, and I\'ll make it even better a bit later.<\\/li>\\n<li>Update: AI Engine automatically makes sure the texts aren\'t too long for some operations; it now uses the number of tokens rather than the number of characters. Give better results.<\\/li>\\n<li>Fix: Issue in the Content Generator.<\\/li>\\n<\\/ul>\\n<p>1.3.65 (2023\\/03\\/20)<\\/p>\\n<ul>\\n<li>Update: Handle the finetuned models a bit differently, for a faster UI, and lot of improvements (like the ability to cancel a finetune, calculate historical spent amount on deleted models, etc).<\\/li>\\n<\\/ul>\\n<p>1.3.64 (2023\\/03\\/19)<\\/p>\\n<ul>\\n<li>Update: Retrieve post types rather than only proposing post\\/page.<\\/li>\\n<li>Update: Handle errors from OpenAI a bit better in the admin (there is currently a huge one!).<\\/li>\\n<\\/ul>\\n<p>1.3.63 (2023\\/03\\/18)<\\/p>\\n<ul>\\n<li>Add: New GPT-4 and GPT-4 32k models.<\\/li>\\n<li>Update: Enhanced the way the prices are calculated to handle the new models.<\\/li>\\n<li>Fix: Better handling on the status icon for the OpenAI servers status.<\\/li>\\n<li>Add: Additional servers for Pinecone.<\\/li>\\n<\\/ul>\\n<p>1.3.60 (2023\\/03\\/17)<\\/p>\\n<ul>\\n<li>Add: Discussions tab, with embedding\'s title displayed in the message, when used.<\\/li>\\n<li>Add: Catch errors in the statistics if OpenAI returns something unexpected.<\\/li>\\n<li>Update: New colors framework.<\\/li>\\n<\\/ul>\\n<p>1.3.57 (2023\\/03\\/16)<\\/p>\\n<ul>\\n<li>Fix: Temperature was sometimes a bit too rounded.<\\/li>\\n<li>Update: Clean the admin screens a little.<\\/li>\\n<li>Update: Allow other models in the Content Generator.<\\/li>\\n<\\/ul>\\n<p>1.3.54 (2023\\/03\\/15)<\\/p>\\n<ul>\\n<li>Update: In the Content Generator, sections (headings) are not mandatory anymore. You can simply delete the associated prompt, and the sections fields will be removed as well. You can save it as your new template.<\\/li>\\n<li>Add: Width and Max Height for the Chatbot Popup in the Settings.<\\/li>\\n<li>Fix: Compatibility issues with older versions of PHP.<\\/li>\\n<li>Fix: Make sure the extra context brought by embedding doesn\'t break the maximum number of tokens.<\\/li>\\n<li>Fix: For some reason, some models didn\'t have the mode and that was leading to the UI to crash.<\\/li>\\n<\\/ul>\\n<p>1.3.49 (2023\\/03\\/14)<\\/p>\\n<ul>\\n<li>Add: Sanitize the content of the context for the shortcode.<\\/li>\\n<li>Add: Parameter in the builder for text_input_maxlength.<\\/li>\\n<li>Update: Enhanced handling of tokens.<\\/li>\\n<\\/ul>\\n<p>1.3.47 (2023\\/03\\/13)<\\/p>\\n<ul>\\n<li>Add: More Pinecone servers.<\\/li>\\n<li>Fix: Enhanced the tokens prediction; client-side also automatically limits the total content depending on it.<\\/li>\\n<\\/ul>\\n<p>1.3.44 (2023\\/03\\/12)<\\/p>\\n<ul>\\n<li>Update: Enhanced the whole bulk system.<\\/li>\\n<li>Update: Enhanced the tokens prediction for non-latin languages.<\\/li>\\n<\\/ul>\\n<p>1.3.42 (2023\\/03\\/11)<\\/p>\\n<ul>\\n<li>Fix: Better guess to lower the limit of max tokens dynamically.<\\/li>\\n<li>Update: Supports multilingual websites with embedddings (WPML, Polylang).<\\/li>\\n<li>Update: Huge update on the way embeddings are created, synchronized and managed.<\\/li>\\n<\\/ul>\\n<p>1.3.37 (2023\\/03\\/10)<\\/p>\\n<ul>\\n<li>Fix: Role management and capabilities.<\\/li>\\n<li>Fix: Avoid issue with wp_enqueue_script called at the wrong place.<\\/li>\\n<li>Add: Simplified API.<\\/li>\\n<li>Add: Maxlength for the chatbot input.<\\/li>\\n<li>Update: Working on the UI framework (dark theme will be possible on the WP side).<\\/li>\\n<\\/ul>\\n<p>1.3.34 (2023\\/03\\/09)<\\/p>\\n<ul>\\n<li>Fix: The shortcode builder when tackling empty values.<\\/li>\\n<li>Fix: Make it so that the context doesn\'t break anything whatever the language. Hey, not easy somehow!<\\/li>\\n<li>Fix: The embeddings dashboard handles cancellation of bulk operations better.<\\/li>\\n<\\/ul>\\n<p>1.3.32 (2023\\/03\\/08)<\\/p>\\n<ul>\\n<li>Add: Sync embeddings and posts.<\\/li>\\n<li>Add: Copy button to reuse the answer. Enabled by default, will add the UI for it later.<\\/li>\\n<li>Fix: Support of basics HTML in the compliance text.<\\/li>\\n<li>Fix: Avoid issues with Japanese.<\\/li>\\n<li>Fix: Enhanced the ChatGPT CSS (better header icons and fullscreen mode).<\\/li>\\n<\\/ul>\\n<p>1.3.2 (2023\\/03\\/07)<\\/p>\\n<ul>\\n<li>Add: New icon_alt parameter to add an Alt Text to the chatbot icon.<\\/li>\\n<li>Add: Styles for the tables in the chabot.<\\/li>\\n<li>Fix: Moved the external JS\\/CSS locally.<\\/li>\\n<li>Fix: Escaping and sanitization issues.<\\/li>\\n<li>Fix: General code cleaning and refactoring.<\\/li>\\n<li>Fix: The icon displaying OpenAI status was not showing the warning sign when needed.<\\/li>\\n<\\/ul>\\n<p>1.2.30 (2023\\/03\\/06)<\\/p>\\n<ul>\\n<li>Add: Embeddings. Add more context to your chatbot based on your data.<\\/li>\\n<li>Update: Better translations.<\\/li>\\n<li>Fix: Better format for the system error messages in the chatbot.&#x1f3b5;<\\/li>\\n<\\/ul>\\n<p>1.2.21 (2023\\/03\\/05)<\\/p>\\n<ul>\\n<li>Add: A little tool to play with Text-to-Speech using Whisper API.<\\/li>\\n<li>Add: Quick Usage Costs in the Content Generation (same system as in the Playground).<\\/li>\\n<li>Fix: There was an issue for new users without an OpenAI key.<\\/li>\\n<li>Fix: There was an issue when picking a different model for finetune.<\\/li>\\n<li>Add: The Content Generator now supports {TOPIC} and {TITLE} everywhere.<\\/li>\\n<\\/ul>\\n<p>1.2.0 (2023\\/03\\/04)<\\/p>\\n<ul>\\n<li>Update: Huge refactoring to make the plugin more extensible.<\\/li>\\n<li>Fix: UI issue in the Images Generator.<\\/li>\\n<\\/ul>\\n<p>1.1.8 (2023\\/03\\/03)<\\/p>\\n<ul>\\n<li>Fix: TextFields in Forms were broken.<\\/li>\\n<li>Fix: Some UI issues on the admin side.<\\/li>\\n<li>Update: Make sur the forms are filled (we can add a better validation system at a later point).<\\/li>\\n<\\/ul>\\n<p>1.1.6 (2023\\/03\\/02)<\\/p>\\n<ul>\\n<li>Add: The ChatGPT model is finally here! It\'s \\"gpt-3.5-turbo\\" and you can already use it with your chatbots, forms, in the playground, etc. It\'s very new so let me know if you find any issues, in the <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/\\">forums<\\/a>. Set as the new default.<\\/li>\\n<li>Add: Max Length for the Input and TextArea in AI Forms.<\\/li>\\n<li>Update: Many little enhancements here and there.<\\/li>\\n<li>Fix: Minor bug in the AI Playground.<\\/li>\\n<\\/ul>\\n<p>1.1.3 (2023\\/03\\/01)<\\/p>\\n<ul>\\n<li>Fix: UI issues in the Content Generator linked to the framework update.<\\/li>\\n<li>Add: Typewriter effect. I don\'t recommend it, but if you want to play with it, it\'s there :)<\\/li>\\n<li>Add: New filter: mwai_forms_params.<\\/li>\\n<li>Update: Refactoring and minor fixes. Making sure everything is stable and nice.<\\/li>\\n<\\/ul>\\n<p>1.1.1 (2023\\/02\\/28)<\\/p>\\n<ul>\\n<li>Add: New Moderation Module; it\'s beta, check it out and play with it.<\\/li>\\n<li>Update: Big update in my framework.<\\/li>\\n<\\/ul>\\n<p>1.1.0 (2023\\/02\\/26)<\\/p>\\n<ul>\\n<li>Update: Enhanced the whole flow of the chatbot (which also fixed minor issue).<\\/li>\\n<li>Update: Better handling of time in the statistics.<\\/li>\\n<\\/ul>\\n<p>1.0.8 (2023\\/02\\/25)<\\/p>\\n<ul>\\n<li>Add: Filter to takeover the conversation programmatically.<\\/li>\\n<li>Add: Compliance Text and Max Sentences.<\\/li>\\n<li>Add: Hyperparams for finetuning.<\\/li>\\n<li>Add: Queries viewer.<\\/li>\\n<\\/ul>\\n<p>1.0.6 (2023\\/02\\/24)<\\/p>\\n<ul>\\n<li>Fixes: There were few issues with my Casually Fine-Tuned system.<\\/li>\\n<li>Add: Option to resolve shortcodes.<\\/li>\\n<\\/ul>\\n<p>1.0.5 (2023\\/02\\/23)<\\/p>\\n<ul>\\n<li>Add: Limit can be applied on a daily-basis.<\\/li>\\n<li>Add: Added ID for AI Submit so that we can hook and customize the advanced params for the AI Forms.<\\/li>\\n<li>Add: Parameters to hide\\/show values in the statistics shortcode.<\\/li>\\n<li>Add: The mwai-clear class has been added to the Clear button.<\\/li>\\n<\\/ul>\\n<p>1.0.3 (2023\\/02\\/22)<\\/p>\\n<ul>\\n<li>Fix: There was an alert popping in the AI Forms.<\\/li>\\n<li>Update: Better handling of user errors in the AI Forms.<\\/li>\\n<li>Update: The ChatGPT theme, if choosen, is applied to AI Forms too.<\\/li>\\n<\\/ul>\\n<p>1.0.1 (2023\\/02\\/21)<\\/p>\\n<ul>\\n<li>Fix: The Form Select wasn\'t working properly.<\\/li>\\n<li>Update: Translation framework.<\\/li>\\n<\\/ul>\\n<p>1.0.0 (2023\\/02\\/20)<\\/p>\\n<ul>\\n<li>Update: Enhance the chabot\'s input field visually.<\\/li>\\n<li>Update: Translation framework.<\\/li>\\n<\\/ul>\\n<p>0.9.99 (2023\\/02\\/19)<\\/p>\\n<ul>\\n<li>Update: Translation framework.<\\/li>\\n<\\/ul>\\n<p>0.9.98 (2023\\/02\\/18)<\\/p>\\n<ul>\\n<li>Fix: There was an exit applied if WP_DEBUG was used.<\\/li>\\n<li>Update: Default max_tokens for forms is now 2048.<\\/li>\\n<li>Add: New \'max_sentences\' parameter to limit the number of sentences in the prompt for the chatbot.<\\/li>\\n<li>Add: AI Submit now handles using element based on their ID. Use it like this: {#myid}.<\\/li>\\n<li>Update: Enhance the internal API with better helpers.<\\/li>\\n<\\/ul>\\n<p>0.9.95 (2023\\/02\\/17)<\\/p>\\n<ul>\\n<li>Fix: Minor fixes related to notices and translations.<\\/li>\\n<li>Update: Enhanced Shortcode Builder.<\\/li>\\n<li>Add: UI for Custom Icon, Icon Message.<\\/li>\\n<li>Fix: Better control of the dirty state of the Post Editor.<\\/li>\\n<li>Add: Warn when the AI Forms are not properly set up to avoid issues.<\\/li>\\n<\\/ul>\\n<p>0.9.89 (2023\\/02\\/16)<\\/p>\\n<ul>\\n<li>Fix: Enhancement in the models screen.<\\/li>\\n<li>Fix: Better session control.<\\/li>\\n<li>Add: New placeholders {TITLE} and {URL} for the Q&amp;A Generator module.<\\/li>\\n<li>Update: Avoid an useless warning or two.<\\/li>\\n<\\/ul>\\n<p>0.9.86 (2023\\/02\\/15)<\\/p>\\n<ul>\\n<li>Update: Handle the colors more naturally depending on the CSS variables.<\\/li>\\n<li>Update: Make sure the max tokens are respected and not over-setted.<\\/li>\\n<li>Update: Better handling of max tokens with forms.<\\/li>\\n<li>Add: Enhanced the way the models and managed.<\\/li>\\n<li>Fix: Issues with forms using non-latin characters.<\\/li>\\n<\\/ul>\\n<p>0.9.85 (2023\\/02\\/14)<\\/p>\\n<ul>\\n<li>Fix: Minor issues related to max tokens.<\\/li>\\n<li>Fix: Some issues with forms, now also better layouts, more types, etc.<\\/li>\\n<li>Info: Happy Valentine\'s Day! &#x1f495; I\'ll take a few hours off &#x1f60a;<\\/li>\\n<\\/ul>\\n<p>0.9.84 (2023\\/02\\/13)<\\/p>\\n<ul>\\n<li>Fix: Compile conversations in order to avoid overwhelming the AI.<\\/li>\\n<li>Fix: When over the limits, forms display an alert nicely.<\\/li>\\n<li>Fix: Quick fix for Rank Math.<\\/li>\\n<li>Update: Optimized the way the fields and handled and reset in the Content Generator and the Templates.<\\/li>\\n<li>Add: Support of custom language (or type of language) in the Content Generator.<\\/li>\\n<li>Info: I would like to focus on making everything amazingly perfect for the version 1.x. I keep the new features for a bit later, and make sure everything we have now is stable and nice, as well as the code quality. Please share your feedback in the <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/\\">Support Threads<\\/a>.<\\/li>\\n<li>Info: If you enjoy this, don\'t hesitate to <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/reviews\\/\\">write a review<\\/a> :)<\\/li>\\n<\\/ul>\\n<p>0.9.82 (2023\\/02\\/12)<\\/p>\\n<ul>\\n<li>Add: Chat logs.<\\/li>\\n<li>Update: Cleaning the UI.<\\/li>\\n<li>Update: Refactoring.<\\/li>\\n<\\/ul>\\n<p>0.9.8 (2023\\/02\\/11)<\\/p>\\n<ul>\\n<li>Update: Quite a bit of refactoring.<\\/li>\\n<li>Add: Forms has the ability to work with DALL-E.<\\/li>\\n<li>Add: Position of the popup chatbot is now also in the settings.<\\/li>\\n<\\/ul>\\n<p>0.9.6 (2023\\/02\\/10)<\\/p>\\n<ul>\\n<li>Fix: There was an issue with statistics\\/logging related to the current API Key.<\\/li>\\n<li>Update: Enhanced the shortcode builder to avoid user mistakes.<\\/li>\\n<li>Update: Better sizes for chatbot icons.<\\/li>\\n<li>Update: Markdown support in AI Forms.<\\/li>\\n<li>Update: Dataset Generator allows replaying the bulk generation from a certain offset.<\\/li>\\n<li>Update: Better text validation before quickly generating titles and excerpts.<\\/li>\\n<li>Add: Timer in the chatbot button if the query takes more than 1 second.<\\/li>\\n<\\/ul>\\n<p>0.9.3 (2023\\/02\\/09)<\\/p>\\n<ul>\\n<li>Add: Debug Mode.<\\/li>\\n<li>Fix: There were issues when both limits were set to zero and special conditions were set through a filter.<\\/li>\\n<\\/ul>\\n<p>0.9.0 (2023\\/02\\/08)<\\/p>\\n<ul>\\n<li>Update: Can handle multiple apiKeys for statistics and limits.<\\/li>\\n<li>Update: Enhancements of the AI Forms.<\\/li>\\n<li>Update: Enhancements of Content-Aware, avoid repeated sentences, shorten content, etc.<\\/li>\\n<li>Fix: Some validations work, to avoid issues and hacks.<\\/li>\\n<\\/ul>\\n<p>0.8.8 (2023\\/02\\/07)<\\/p>\\n<ul>\\n<li>Add: New param for the chatbot: guest_name.<\\/li>\\n<li>Update: Better consistency in the UI.<\\/li>\\n<li>Fix: Minor fixes.<\\/li>\\n<li>Fix: There was a little inconsistency with \\"Use Topics as Titles\\".<\\/li>\\n<li>Update: Reviewed the styles - but this still need a lot of improvements.<\\/li>\\n<\\/ul>\\n<p>0.8.5 (2023\\/02\\/06)<\\/p>\\n<ul>\\n<li>Add: Pro Users: Visit the Statistics Tab and check the <a href=\\"https:\\/\\/meowapps.com\\/ai-engine\\/faq\\/\\">FAQ<\\/a>. Lots of fun ahead!<\\/li>\\n<li>Update: You can now enable\\/disable every feature to make the UI yours and for a better UX (that will also allow role-based access to different features).<\\/li>\\n<li>Info 1: Templates are super cool! I\'d be happy if you could join this <a href=\\"https:\\/\\/wordpress.org\\/support\\/topic\\/common-use-cases-for-templates\\/\\">discussion<\\/a> in the WordPress forums.<\\/li>\\n<li>Info 2: Share with me your feedback in the <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/\\">Support Threads<\\/a>, I\'ll make it better for you! And of course, if you like the plugin, please leave a review on <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/reviews\\/\\">WordPress.org<\\/a>. Thank you!<\\/li>\\n<\\/ul>\\n<p>0.8.2 (2023\\/02\\/05)<\\/p>\\n<ul>\\n<li>Update: Enhancements and fixes to the AI Forms + a ChatGPT theme for them.<\\/li>\\n<li>Update: A bit of tidying on the UI, and added warning messages to avoid common mistakes.<\\/li>\\n<li>Add: Words count in Playground and Content Generator.<\\/li>\\n<li>Add: The icon_text parameter to add a text next to the icon of the chatbot.<\\/li>\\n<li>Update: Made the CSS of the chatbot slighlty more specific to avoid being overriden by pagebuilders.<\\/li>\\n<\\/ul>\\n<p>0.7.6 (2023\\/02\\/04)<\\/p>\\n<ul>\\n<li>Fix: The icon of the chatbot was not applied.<\\/li>\\n<li>Update: Better AI Forms.<\\/li>\\n<li>Add: Templates for Content Generator. Templates are now available everywhere I wanted. I\'d be happy if you could join this <a href=\\"https:\\/\\/wordpress.org\\/support\\/topic\\/common-use-cases-for-templates\\/\\">discussion<\\/a> in the WordPress forums.<\\/li>\\n<\\/ul>\\n<p>0.7.2 (2023\\/02\\/03)<\\/p>\\n<ul>\\n<li>Update: \\"casually_fined_tuned\\" is now \\"casually_fine_tuned\\".<\\/li>\\n<li>Fix: Editor also have access to the AI features (but not the Settings). This behavior can be filtered.<\\/li>\\n<li>Add: AI Forms for Pro (extremely beta but it works).<\\/li>\\n<\\/ul>\\n<p>0.6.9 (2023\\/02\\/02)<\\/p>\\n<ul>\\n<li>Fix: The chatbot could potentially be over other clickable elements.<\\/li>\\n<li>Fix: Create Post has an issue in Single Generate mode.<\\/li>\\n<li>Add: The Templates Editor is now available in the Images Generator.<\\/li>\\n<\\/ul>\\n<p>0.6.6 (2023\\/02\\/01)<\\/p>\\n<ul>\\n<li>Add: Templates in the Playground are now editable.<\\/li>\\n<li>Fix: Avoid the content-aware to take too many tokens.<\\/li>\\n<li>Update: Many little enhancements in the UI elements.<\\/li>\\n<li>Update: Handles timeouts better. More and more buttons will display the time elapsed.<\\/li>\\n<\\/ul>\\n<p>0.6.2 (2023\\/01\\/31)<\\/p>\\n<ul>\\n<li>Add: The Post Bulk Generate feature is now working nicely.<\\/li>\\n<li>Fix: Issue with missing file.<\\/li>\\n<li>Add: WooCommerce fields generator for products.<\\/li>\\n<li>Update: More modularity to increase UI tidyness and website\'s performance.<\\/li>\\n<\\/ul>\\n<p>0.5.7 (2023\\/01\\/30)<\\/p>\\n<ul>\\n<li>Update: The chatbot icon is now refered as \\"icon\\" (instead of \\"avatar\\" previously, which was confusing). We have an icon and an icon_position parameters for the chatbot.<\\/li>\\n<li>Fix: Crash while adding rows to the dataset.<\\/li>\\n<li>Add: Placeholders for the user name in the chatbot.<\\/li>\\n<li>Add: URL support for avatars for the user and\\/or the AI.<\\/li>\\n<\\/ul>\\n<p>0.5.4 (2023\\/01\\/29)<\\/p>\\n<ul>\\n<li>Add: Avatar position (avatar_position) can be set to \\"bottom-right\\", \\"top-left\\", etc.<\\/li>\\n<li>Add: You can specify an avatar URL for each chatbot (avatar parameter, in the shortcode).<\\/li>\\n<li>Fix: The expand icon was always displayed for the popup chatbot, even with fullsize set to false.<\\/li>\\n<li>Add: Entries Generator for the Dataset Builder. Use with caution!<\\/li>\\n<\\/ul>\\n<p>0.5.1 (2023\\/01\\/28)<\\/p>\\n<ul>\\n<li>Add: Chatbot avatars.<\\/li>\\n<li>Add: Color for the Header Buttons for the Chatbot Popup Window.<\\/li>\\n<li>Update: Enhanced the UI of the Settings, Chatbot and Content Generator.<\\/li>\\n<li>Update: The ID is now available in the Settings (reminder: ID allows you to set CSS more easily if you do it statically, it also keeps the conversations recorded in the browser between pages).<\\/li>\\n<li>Update: Enhancements relative to prompts, their placeholders, and UI visual adaption based on those.<\\/li>\\n<\\/ul>\\n<p>0.4.8 (2023\\/01\\/27)<\\/p>\\n<ul>\\n<li>Add: If no user_name and ai_name are mentioned, avatars will be used.<\\/li>\\n<li>Add: Status of OpenAI servers (a little warning sign will also be added on the tab if something is wrong).<\\/li>\\n<li>Add: Possibility to modify or remove the error messages through a filter.<\\/li>\\n<\\/ul>\\n<p>0.4.6 (2023\\/01\\/26)<\\/p>\\n<ul>\\n<li>Fixed: Resolved a potential issue with session (used for logging purposes).<\\/li>\\n<li>Fixed: The chatbot was not working properly on iPhones.<\\/li>\\n<\\/ul>\\n<p>0.4.5 (2023\\/01\\/25)<\\/p>\\n<ul>\\n<li>Add: Style the chatbot easily in the Settings.<\\/li>\\n<li>Add: Allow extra models to be added.<\\/li>\\n<li>Fix: Clean the context and the content-aware feature.<\\/li>\\n<\\/ul>\\n<p>0.4.3 (2023\\/01\\/24)<\\/p>\\n<ul>\\n<li>Update: Allow re-train a fined-tuned model.<\\/li>\\n<li>Fix: The session was started too late, potentially causing a warning.<\\/li>\\n<\\/ul>\\n<p>0.4.1 (2023\\/01\\/23)<\\/p>\\n<ul>\\n<li>Update: Better and simpler UI, make it a bit easier overall.<\\/li>\\n<li>Add: Statistics and Content-Aware features for Pro.<\\/li>\\n<li>Update: Make sure that all the AI requests have an \\"env\\" and a logical \\"session\\" associated (for logging purposes).<\\/li>\\n<\\/ul>\\n<p>0.3.5 (2023\\/01\\/22)<\\/p>\\n<ul>\\n<li>Update: Better calculation of the OpenAI \\"Usage\\".<\\/li>\\n<li>Update: Lot of refactoring and code enhancements to allow other AI services to be integrated.<\\/li>\\n<li>Add: Generate based on Topic (Content Generator).<\\/li>\\n<li>Update: Various enhancements in the UI.<\\/li>\\n<\\/ul>\\n<p>0.3.4 (2023\\/01\\/22)<\\/p>\\n<ul>\\n<li>Add: Code enhancements to support many new actions and filters.<\\/li>\\n<li>Add: Added actions and filters to modify the answers, limit the users, etc. More to come soon.<\\/li>\\n<\\/ul>\\n<p>0.3.3 (2023\\/01\\/21)<\\/p>\\n<ul>\\n<li>Add: Languages management (check <a href=\\"https:\\/\\/meowapps.com\\/ai-engine\\/tutorial\\/#add-or-remove-languages\\">https:\\/\\/meowapps.com\\/ai-engine\\/tutorial\\/#add-or-remove-languages<\\/a>).<\\/li>\\n<li>Add: The chatbot can be displayed in fullscreen (use fullscreen=\\"true\\" in the shortcode). It works logically with the window\\/popup mode: no popup? Fullscreen right away! Popup? Fullscreen on click :)<\\/li>\\n<li>Fix: A few potential issues that coult break a few things.<\\/li>\\n<li>Update: Cleaned the JS, CSS and HTML. I like when it\'s very tidy before going forward!<\\/li>\\n<\\/ul>\\n<p>0.2.9 (2023\\/01\\/19)<\\/p>\\n<ul>\\n<li>Fix: Responsive.<\\/li>\\n<li>Add: Shortcode builder for the chatbot. This makes it much easier!<\\/li>\\n<li>Add: Bunch of new options to inject the chatbot everywhere.<\\/li>\\n<li>Add: Syntax highlighting for the code potentially generated by the AI.<\\/li>\\n<li>Add: The chatbot can be displayed as a window\\/popup. Sorry, only one icon for now, but will add more!<\\/li>\\n<li>Add: Bunch of WordPress filters to modify everything and do everything :)<\\/li>\\n<\\/ul>\\n<p>0.2.6 (2023\\/01\\/18)<\\/p>\\n<ul>\\n<li>Update: Little UI enhancements and fixes.<\\/li>\\n<li>Add: \\"max_tokens\\" parameter for the chatbot shortcode.<\\/li>\\n<li>Add: \\"casually_fine_tuned\\" parameter for the chatbot shorcode (for fine-tuned models).<\\/li>\\n<\\/ul>\\n<p>0.2.4 (2023\\/01\\/17)<\\/p>\\n<ul>\\n<li>Update: Perfected the fine-tuning module (UI and features).<\\/li>\\n<li>Update: A few UI fixes but a lot more to come.<\\/li>\\n<\\/ul>\\n<p>0.2.3 (2023\\/01\\/16)<\\/p>\\n<ul>\\n<li>Add: Module to train your own AI model (visit the Settings &gt; Fine Tuning). My user interface makes it look easy, but creating datasets and training models is not easy. Let\'s go through this together and I\'ll enhance AI Engine to make it easier.<\\/li>\\n<li>Update: Possible to add new lines in the requests to the chatbot.<\\/li>\\n<\\/ul>\\n<p>0.2.2 (2023\\/01\\/13)<\\/p>\\n<ul>\\n<li>Add: Shortcode that creates an images generator bot.<\\/li>\\n<li>Fix: Bots are now responsive.<\\/li>\\n<li>Add: Button and placeholder of the bots can be translated.<\\/li>\\n<\\/ul>\\n<p>0.2.1 (2023\\/01\\/12)<\\/p>\\n<ul>\\n<li>Add: Images Generator! After getting your feedback, I will implement this Image Generator in a modal in the Post Editor.<\\/li>\\n<\\/ul>\\n<p>0.1.9 (2023\\/01\\/09)<\\/p>\\n<ul>\\n<li>Add: Many improvements to the chatbot! By default, it now uses ChatGPT style, and it also support replies from the AI using Markdown (and will convert it properly into HTML). Basically, you can have properly displayed code and better formatting in the chat!<\\/li>\\n<\\/ul>\\n<p>0.1.7 (2023\\/01\\/08)<\\/p>\\n<ul>\\n<li>Add: Handle the errors better in the UI.<\\/li>\\n<li>Add: The chatbot can be styled a bit more easily.<\\/li>\\n<\\/ul>\\n<p>0.1.6 (2023\\/01\\/07)<\\/p>\\n<ul>\\n<li>Fix: The timeout was 5s, which was too short for some requests. It\'s now 60s.<\\/li>\\n<\\/ul>\\n<p>0.1.5 (2023\\/01\\/06)<\\/p>\\n<ul>\\n<li>Add: New \'api_key\' parameter for the shortcode. The API Key can now be filtered, added through the shortcode, the filters, depending on your conditions.<\\/li>\\n<li>Fix: Better handling of errors.<\\/li>\\n<\\/ul>\\n<p>0.1.4 (2023\\/01\\/05)<\\/p>\\n<ul>\\n<li>Update: Sorry, the name of the parameters in the chatbot were confusing. I\'ve changed them to make it more clear.<\\/li>\\n<li>Add: New filter, and the possibility to add some CSS to the chatbot, directly through coding. Have a look on <a href=\\"https:\\/\\/meowapps.com\\/ai-engine\\/\\">https:\\/\\/meowapps.com\\/ai-engine\\/<\\/a>.<\\/li>\\n<\\/ul>\\n<p>0.1.0 (2023\\/01\\/01)<\\/p>\\n<ul>\\n<li>Fix: A few fixes in the playground.<\\/li>\\n<li>Add: Content Generator (available under Tools and Posts).<\\/li>\\n<\\/ul>\\n<p>0.0.7 (2022\\/12\\/30)<\\/p>\\n<ul>\\n<li>Fix: Little issue in the playground.<\\/li>\\n<li>Add: Model and temperature in the playground.<\\/li>\\n<li>Updated: Improved the chatbot, with more parameters (temperature, model), and a better layout (HTML only).<\\/li>\\n<\\/ul>\\n<p>0.0.3 (2022\\/12\\/29)<\\/p>\\n<ul>\\n<li>Add: Lightweight chatbot (beta).<\\/li>\\n<li>Fix: Missing icon.<\\/li>\\n<\\/ul>\\n<p>0.0.1 (2022\\/12\\/27)<\\/p>\\n<ul>\\n<li>First release.<\\/li>\\n<\\/ul>\\n"},"banners":{"high":"","low":""},"icons":{"1x":"https:\\/\\/meowapps.com\\/wp-content\\/uploads\\/Magician.png","2x":"https:\\/\\/meowapps.com\\/wp-content\\/uploads\\/Magician.png"},"msg":"No license key has been provided.","description":["<p>Create a ChatGPT-like chatbot (or many of them, with different features and behaviors), generate content, images, quickly suggest titles and excerpts, track your OpenAI usage stats, and much more!<\\/p>\\n"],"changelog":["<p>1.3.74 (2023\\/03\\/24)<\\/p>\\n<ul>\\n<li>Fix: On some installs, floats would be echoed with commas instead of dots.<\\/li>\\n<li>Info: It\'s my birthday &#x270c;&#xfe0f;&#x1f973;<\\/li>\\n<li>Info: Motivate me with <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/reviews\\/\\">a little review here<\\/a>. Thank you!<\\/li>\\n<\\/ul>\\n<p>1.3.73 (2023\\/03\\/23)<\\/p>\\n<ul>\\n<li>Add: Post Type for Content Generator.<\\/li>\\n<li>Fix: Avoid a crash for the server which didn\'t install mbstring.<\\/li>\\n<li>Fix: The Meow Apps dashboard is back, with PHP Error Logs and evergthing.<\\/li>\\n<li>Info: Help or discuss with other users on <a href=\\"https:\\/\\/discord.gg\\/bHDGh38\\">my Discord<\\/a>.<\\/li>\\n<li>Info: Share your feedbacks\\/issues in the <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/\\">Support Threads<\\/a>.<\\/li>\\n<\\/ul>\\n<p>1.3.69 (2023\\/03\\/22)<\\/p>\\n<ul>\\n<li>Fix: Issue with non-default models in the forms.<\\/li>\\n<li>Add: Default value and rows for textarea and input fields.<\\/li>\\n<li>Fix: Assistants weren\'t really disabled (depending on the settings).<\\/li>\\n<li>Fix: Simplified a few UI elements.<\\/li>\\n<\\/ul>\\n<p>1.3.67 (2023\\/03\\/21)<\\/p>\\n<ul>\\n<li>Update: The Finetunes are now a module, that can be completely disabled (and it is, by default).<\\/li>\\n<li>Update: Overhaul of the language system. It\'s now unified, and I\'ll make it even better a bit later.<\\/li>\\n<li>Update: AI Engine automatically makes sure the texts aren\'t too long for some operations; it now uses the number of tokens rather than the number of characters. Give better results.<\\/li>\\n<li>Fix: Issue in the Content Generator.<\\/li>\\n<\\/ul>\\n<p>1.3.65 (2023\\/03\\/20)<\\/p>\\n<ul>\\n<li>Update: Handle the finetuned models a bit differently, for a faster UI, and lot of improvements (like the ability to cancel a finetune, calculate historical spent amount on deleted models, etc).<\\/li>\\n<\\/ul>\\n<p>1.3.64 (2023\\/03\\/19)<\\/p>\\n<ul>\\n<li>Update: Retrieve post types rather than only proposing post\\/page.<\\/li>\\n<li>Update: Handle errors from OpenAI a bit better in the admin (there is currently a huge one!).<\\/li>\\n<\\/ul>\\n<p>1.3.63 (2023\\/03\\/18)<\\/p>\\n<ul>\\n<li>Add: New GPT-4 and GPT-4 32k models.<\\/li>\\n<li>Update: Enhanced the way the prices are calculated to handle the new models.<\\/li>\\n<li>Fix: Better handling on the status icon for the OpenAI servers status.<\\/li>\\n<li>Add: Additional servers for Pinecone.<\\/li>\\n<\\/ul>\\n<p>1.3.60 (2023\\/03\\/17)<\\/p>\\n<ul>\\n<li>Add: Discussions tab, with embedding\'s title displayed in the message, when used.<\\/li>\\n<li>Add: Catch errors in the statistics if OpenAI returns something unexpected.<\\/li>\\n<li>Update: New colors framework.<\\/li>\\n<\\/ul>\\n<p>1.3.57 (2023\\/03\\/16)<\\/p>\\n<ul>\\n<li>Fix: Temperature was sometimes a bit too rounded.<\\/li>\\n<li>Update: Clean the admin screens a little.<\\/li>\\n<li>Update: Allow other models in the Content Generator.<\\/li>\\n<\\/ul>\\n<p>1.3.54 (2023\\/03\\/15)<\\/p>\\n<ul>\\n<li>Update: In the Content Generator, sections (headings) are not mandatory anymore. You can simply delete the associated prompt, and the sections fields will be removed as well. You can save it as your new template.<\\/li>\\n<li>Add: Width and Max Height for the Chatbot Popup in the Settings.<\\/li>\\n<li>Fix: Compatibility issues with older versions of PHP.<\\/li>\\n<li>Fix: Make sure the extra context brought by embedding doesn\'t break the maximum number of tokens.<\\/li>\\n<li>Fix: For some reason, some models didn\'t have the mode and that was leading to the UI to crash.<\\/li>\\n<\\/ul>\\n<p>1.3.49 (2023\\/03\\/14)<\\/p>\\n<ul>\\n<li>Add: Sanitize the content of the context for the shortcode.<\\/li>\\n<li>Add: Parameter in the builder for text_input_maxlength.<\\/li>\\n<li>Update: Enhanced handling of tokens.<\\/li>\\n<\\/ul>\\n<p>1.3.47 (2023\\/03\\/13)<\\/p>\\n<ul>\\n<li>Add: More Pinecone servers.<\\/li>\\n<li>Fix: Enhanced the tokens prediction; client-side also automatically limits the total content depending on it.<\\/li>\\n<\\/ul>\\n<p>1.3.44 (2023\\/03\\/12)<\\/p>\\n<ul>\\n<li>Update: Enhanced the whole bulk system.<\\/li>\\n<li>Update: Enhanced the tokens prediction for non-latin languages.<\\/li>\\n<\\/ul>\\n<p>1.3.42 (2023\\/03\\/11)<\\/p>\\n<ul>\\n<li>Fix: Better guess to lower the limit of max tokens dynamically.<\\/li>\\n<li>Update: Supports multilingual websites with embedddings (WPML, Polylang).<\\/li>\\n<li>Update: Huge update on the way embeddings are created, synchronized and managed.<\\/li>\\n<\\/ul>\\n<p>1.3.37 (2023\\/03\\/10)<\\/p>\\n<ul>\\n<li>Fix: Role management and capabilities.<\\/li>\\n<li>Fix: Avoid issue with wp_enqueue_script called at the wrong place.<\\/li>\\n<li>Add: Simplified API.<\\/li>\\n<li>Add: Maxlength for the chatbot input.<\\/li>\\n<li>Update: Working on the UI framework (dark theme will be possible on the WP side).<\\/li>\\n<\\/ul>\\n<p>1.3.34 (2023\\/03\\/09)<\\/p>\\n<ul>\\n<li>Fix: The shortcode builder when tackling empty values.<\\/li>\\n<li>Fix: Make it so that the context doesn\'t break anything whatever the language. Hey, not easy somehow!<\\/li>\\n<li>Fix: The embeddings dashboard handles cancellation of bulk operations better.<\\/li>\\n<\\/ul>\\n<p>1.3.32 (2023\\/03\\/08)<\\/p>\\n<ul>\\n<li>Add: Sync embeddings and posts.<\\/li>\\n<li>Add: Copy button to reuse the answer. Enabled by default, will add the UI for it later.<\\/li>\\n<li>Fix: Support of basics HTML in the compliance text.<\\/li>\\n<li>Fix: Avoid issues with Japanese.<\\/li>\\n<li>Fix: Enhanced the ChatGPT CSS (better header icons and fullscreen mode).<\\/li>\\n<\\/ul>\\n<p>1.3.2 (2023\\/03\\/07)<\\/p>\\n<ul>\\n<li>Add: New icon_alt parameter to add an Alt Text to the chatbot icon.<\\/li>\\n<li>Add: Styles for the tables in the chabot.<\\/li>\\n<li>Fix: Moved the external JS\\/CSS locally.<\\/li>\\n<li>Fix: Escaping and sanitization issues.<\\/li>\\n<li>Fix: General code cleaning and refactoring.<\\/li>\\n<li>Fix: The icon displaying OpenAI status was not showing the warning sign when needed.<\\/li>\\n<\\/ul>\\n<p>1.2.30 (2023\\/03\\/06)<\\/p>\\n<ul>\\n<li>Add: Embeddings. Add more context to your chatbot based on your data.<\\/li>\\n<li>Update: Better translations.<\\/li>\\n<li>Fix: Better format for the system error messages in the chatbot.&#x1f3b5;<\\/li>\\n<\\/ul>\\n<p>1.2.21 (2023\\/03\\/05)<\\/p>\\n<ul>\\n<li>Add: A little tool to play with Text-to-Speech using Whisper API.<\\/li>\\n<li>Add: Quick Usage Costs in the Content Generation (same system as in the Playground).<\\/li>\\n<li>Fix: There was an issue for new users without an OpenAI key.<\\/li>\\n<li>Fix: There was an issue when picking a different model for finetune.<\\/li>\\n<li>Add: The Content Generator now supports {TOPIC} and {TITLE} everywhere.<\\/li>\\n<\\/ul>\\n<p>1.2.0 (2023\\/03\\/04)<\\/p>\\n<ul>\\n<li>Update: Huge refactoring to make the plugin more extensible.<\\/li>\\n<li>Fix: UI issue in the Images Generator.<\\/li>\\n<\\/ul>\\n<p>1.1.8 (2023\\/03\\/03)<\\/p>\\n<ul>\\n<li>Fix: TextFields in Forms were broken.<\\/li>\\n<li>Fix: Some UI issues on the admin side.<\\/li>\\n<li>Update: Make sur the forms are filled (we can add a better validation system at a later point).<\\/li>\\n<\\/ul>\\n<p>1.1.6 (2023\\/03\\/02)<\\/p>\\n<ul>\\n<li>Add: The ChatGPT model is finally here! It\'s \\"gpt-3.5-turbo\\" and you can already use it with your chatbots, forms, in the playground, etc. It\'s very new so let me know if you find any issues, in the <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/\\">forums<\\/a>. Set as the new default.<\\/li>\\n<li>Add: Max Length for the Input and TextArea in AI Forms.<\\/li>\\n<li>Update: Many little enhancements here and there.<\\/li>\\n<li>Fix: Minor bug in the AI Playground.<\\/li>\\n<\\/ul>\\n<p>1.1.3 (2023\\/03\\/01)<\\/p>\\n<ul>\\n<li>Fix: UI issues in the Content Generator linked to the framework update.<\\/li>\\n<li>Add: Typewriter effect. I don\'t recommend it, but if you want to play with it, it\'s there :)<\\/li>\\n<li>Add: New filter: mwai_forms_params.<\\/li>\\n<li>Update: Refactoring and minor fixes. Making sure everything is stable and nice.<\\/li>\\n<\\/ul>\\n<p>1.1.1 (2023\\/02\\/28)<\\/p>\\n<ul>\\n<li>Add: New Moderation Module; it\'s beta, check it out and play with it.<\\/li>\\n<li>Update: Big update in my framework.<\\/li>\\n<\\/ul>\\n<p>1.1.0 (2023\\/02\\/26)<\\/p>\\n<ul>\\n<li>Update: Enhanced the whole flow of the chatbot (which also fixed minor issue).<\\/li>\\n<li>Update: Better handling of time in the statistics.<\\/li>\\n<\\/ul>\\n<p>1.0.8 (2023\\/02\\/25)<\\/p>\\n<ul>\\n<li>Add: Filter to takeover the conversation programmatically.<\\/li>\\n<li>Add: Compliance Text and Max Sentences.<\\/li>\\n<li>Add: Hyperparams for finetuning.<\\/li>\\n<li>Add: Queries viewer.<\\/li>\\n<\\/ul>\\n<p>1.0.6 (2023\\/02\\/24)<\\/p>\\n<ul>\\n<li>Fixes: There were few issues with my Casually Fine-Tuned system.<\\/li>\\n<li>Add: Option to resolve shortcodes.<\\/li>\\n<\\/ul>\\n<p>1.0.5 (2023\\/02\\/23)<\\/p>\\n<ul>\\n<li>Add: Limit can be applied on a daily-basis.<\\/li>\\n<li>Add: Added ID for AI Submit so that we can hook and customize the advanced params for the AI Forms.<\\/li>\\n<li>Add: Parameters to hide\\/show values in the statistics shortcode.<\\/li>\\n<li>Add: The mwai-clear class has been added to the Clear button.<\\/li>\\n<\\/ul>\\n<p>1.0.3 (2023\\/02\\/22)<\\/p>\\n<ul>\\n<li>Fix: There was an alert popping in the AI Forms.<\\/li>\\n<li>Update: Better handling of user errors in the AI Forms.<\\/li>\\n<li>Update: The ChatGPT theme, if choosen, is applied to AI Forms too.<\\/li>\\n<\\/ul>\\n<p>1.0.1 (2023\\/02\\/21)<\\/p>\\n<ul>\\n<li>Fix: The Form Select wasn\'t working properly.<\\/li>\\n<li>Update: Translation framework.<\\/li>\\n<\\/ul>\\n<p>1.0.0 (2023\\/02\\/20)<\\/p>\\n<ul>\\n<li>Update: Enhance the chabot\'s input field visually.<\\/li>\\n<li>Update: Translation framework.<\\/li>\\n<\\/ul>\\n<p>0.9.99 (2023\\/02\\/19)<\\/p>\\n<ul>\\n<li>Update: Translation framework.<\\/li>\\n<\\/ul>\\n<p>0.9.98 (2023\\/02\\/18)<\\/p>\\n<ul>\\n<li>Fix: There was an exit applied if WP_DEBUG was used.<\\/li>\\n<li>Update: Default max_tokens for forms is now 2048.<\\/li>\\n<li>Add: New \'max_sentences\' parameter to limit the number of sentences in the prompt for the chatbot.<\\/li>\\n<li>Add: AI Submit now handles using element based on their ID. Use it like this: {#myid}.<\\/li>\\n<li>Update: Enhance the internal API with better helpers.<\\/li>\\n<\\/ul>\\n<p>0.9.95 (2023\\/02\\/17)<\\/p>\\n<ul>\\n<li>Fix: Minor fixes related to notices and translations.<\\/li>\\n<li>Update: Enhanced Shortcode Builder.<\\/li>\\n<li>Add: UI for Custom Icon, Icon Message.<\\/li>\\n<li>Fix: Better control of the dirty state of the Post Editor.<\\/li>\\n<li>Add: Warn when the AI Forms are not properly set up to avoid issues.<\\/li>\\n<\\/ul>\\n<p>0.9.89 (2023\\/02\\/16)<\\/p>\\n<ul>\\n<li>Fix: Enhancement in the models screen.<\\/li>\\n<li>Fix: Better session control.<\\/li>\\n<li>Add: New placeholders {TITLE} and {URL} for the Q&amp;A Generator module.<\\/li>\\n<li>Update: Avoid an useless warning or two.<\\/li>\\n<\\/ul>\\n<p>0.9.86 (2023\\/02\\/15)<\\/p>\\n<ul>\\n<li>Update: Handle the colors more naturally depending on the CSS variables.<\\/li>\\n<li>Update: Make sure the max tokens are respected and not over-setted.<\\/li>\\n<li>Update: Better handling of max tokens with forms.<\\/li>\\n<li>Add: Enhanced the way the models and managed.<\\/li>\\n<li>Fix: Issues with forms using non-latin characters.<\\/li>\\n<\\/ul>\\n<p>0.9.85 (2023\\/02\\/14)<\\/p>\\n<ul>\\n<li>Fix: Minor issues related to max tokens.<\\/li>\\n<li>Fix: Some issues with forms, now also better layouts, more types, etc.<\\/li>\\n<li>Info: Happy Valentine\'s Day! &#x1f495; I\'ll take a few hours off &#x1f60a;<\\/li>\\n<\\/ul>\\n<p>0.9.84 (2023\\/02\\/13)<\\/p>\\n<ul>\\n<li>Fix: Compile conversations in order to avoid overwhelming the AI.<\\/li>\\n<li>Fix: When over the limits, forms display an alert nicely.<\\/li>\\n<li>Fix: Quick fix for Rank Math.<\\/li>\\n<li>Update: Optimized the way the fields and handled and reset in the Content Generator and the Templates.<\\/li>\\n<li>Add: Support of custom language (or type of language) in the Content Generator.<\\/li>\\n<li>Info: I would like to focus on making everything amazingly perfect for the version 1.x. I keep the new features for a bit later, and make sure everything we have now is stable and nice, as well as the code quality. Please share your feedback in the <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/\\">Support Threads<\\/a>.<\\/li>\\n<li>Info: If you enjoy this, don\'t hesitate to <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/reviews\\/\\">write a review<\\/a> :)<\\/li>\\n<\\/ul>\\n<p>0.9.82 (2023\\/02\\/12)<\\/p>\\n<ul>\\n<li>Add: Chat logs.<\\/li>\\n<li>Update: Cleaning the UI.<\\/li>\\n<li>Update: Refactoring.<\\/li>\\n<\\/ul>\\n<p>0.9.8 (2023\\/02\\/11)<\\/p>\\n<ul>\\n<li>Update: Quite a bit of refactoring.<\\/li>\\n<li>Add: Forms has the ability to work with DALL-E.<\\/li>\\n<li>Add: Position of the popup chatbot is now also in the settings.<\\/li>\\n<\\/ul>\\n<p>0.9.6 (2023\\/02\\/10)<\\/p>\\n<ul>\\n<li>Fix: There was an issue with statistics\\/logging related to the current API Key.<\\/li>\\n<li>Update: Enhanced the shortcode builder to avoid user mistakes.<\\/li>\\n<li>Update: Better sizes for chatbot icons.<\\/li>\\n<li>Update: Markdown support in AI Forms.<\\/li>\\n<li>Update: Dataset Generator allows replaying the bulk generation from a certain offset.<\\/li>\\n<li>Update: Better text validation before quickly generating titles and excerpts.<\\/li>\\n<li>Add: Timer in the chatbot button if the query takes more than 1 second.<\\/li>\\n<\\/ul>\\n<p>0.9.3 (2023\\/02\\/09)<\\/p>\\n<ul>\\n<li>Add: Debug Mode.<\\/li>\\n<li>Fix: There were issues when both limits were set to zero and special conditions were set through a filter.<\\/li>\\n<\\/ul>\\n<p>0.9.0 (2023\\/02\\/08)<\\/p>\\n<ul>\\n<li>Update: Can handle multiple apiKeys for statistics and limits.<\\/li>\\n<li>Update: Enhancements of the AI Forms.<\\/li>\\n<li>Update: Enhancements of Content-Aware, avoid repeated sentences, shorten content, etc.<\\/li>\\n<li>Fix: Some validations work, to avoid issues and hacks.<\\/li>\\n<\\/ul>\\n<p>0.8.8 (2023\\/02\\/07)<\\/p>\\n<ul>\\n<li>Add: New param for the chatbot: guest_name.<\\/li>\\n<li>Update: Better consistency in the UI.<\\/li>\\n<li>Fix: Minor fixes.<\\/li>\\n<li>Fix: There was a little inconsistency with \\"Use Topics as Titles\\".<\\/li>\\n<li>Update: Reviewed the styles - but this still need a lot of improvements.<\\/li>\\n<\\/ul>\\n<p>0.8.5 (2023\\/02\\/06)<\\/p>\\n<ul>\\n<li>Add: Pro Users: Visit the Statistics Tab and check the <a href=\\"https:\\/\\/meowapps.com\\/ai-engine\\/faq\\/\\">FAQ<\\/a>. Lots of fun ahead!<\\/li>\\n<li>Update: You can now enable\\/disable every feature to make the UI yours and for a better UX (that will also allow role-based access to different features).<\\/li>\\n<li>Info 1: Templates are super cool! I\'d be happy if you could join this <a href=\\"https:\\/\\/wordpress.org\\/support\\/topic\\/common-use-cases-for-templates\\/\\">discussion<\\/a> in the WordPress forums.<\\/li>\\n<li>Info 2: Share with me your feedback in the <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/\\">Support Threads<\\/a>, I\'ll make it better for you! And of course, if you like the plugin, please leave a review on <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/reviews\\/\\">WordPress.org<\\/a>. Thank you!<\\/li>\\n<\\/ul>\\n<p>0.8.2 (2023\\/02\\/05)<\\/p>\\n<ul>\\n<li>Update: Enhancements and fixes to the AI Forms + a ChatGPT theme for them.<\\/li>\\n<li>Update: A bit of tidying on the UI, and added warning messages to avoid common mistakes.<\\/li>\\n<li>Add: Words count in Playground and Content Generator.<\\/li>\\n<li>Add: The icon_text parameter to add a text next to the icon of the chatbot.<\\/li>\\n<li>Update: Made the CSS of the chatbot slighlty more specific to avoid being overriden by pagebuilders.<\\/li>\\n<\\/ul>\\n<p>0.7.6 (2023\\/02\\/04)<\\/p>\\n<ul>\\n<li>Fix: The icon of the chatbot was not applied.<\\/li>\\n<li>Update: Better AI Forms.<\\/li>\\n<li>Add: Templates for Content Generator. Templates are now available everywhere I wanted. I\'d be happy if you could join this <a href=\\"https:\\/\\/wordpress.org\\/support\\/topic\\/common-use-cases-for-templates\\/\\">discussion<\\/a> in the WordPress forums.<\\/li>\\n<\\/ul>\\n<p>0.7.2 (2023\\/02\\/03)<\\/p>\\n<ul>\\n<li>Update: \\"casually_fined_tuned\\" is now \\"casually_fine_tuned\\".<\\/li>\\n<li>Fix: Editor also have access to the AI features (but not the Settings). This behavior can be filtered.<\\/li>\\n<li>Add: AI Forms for Pro (extremely beta but it works).<\\/li>\\n<\\/ul>\\n<p>0.6.9 (2023\\/02\\/02)<\\/p>\\n<ul>\\n<li>Fix: The chatbot could potentially be over other clickable elements.<\\/li>\\n<li>Fix: Create Post has an issue in Single Generate mode.<\\/li>\\n<li>Add: The Templates Editor is now available in the Images Generator.<\\/li>\\n<\\/ul>\\n<p>0.6.6 (2023\\/02\\/01)<\\/p>\\n<ul>\\n<li>Add: Templates in the Playground are now editable.<\\/li>\\n<li>Fix: Avoid the content-aware to take too many tokens.<\\/li>\\n<li>Update: Many little enhancements in the UI elements.<\\/li>\\n<li>Update: Handles timeouts better. More and more buttons will display the time elapsed.<\\/li>\\n<\\/ul>\\n<p>0.6.2 (2023\\/01\\/31)<\\/p>\\n<ul>\\n<li>Add: The Post Bulk Generate feature is now working nicely.<\\/li>\\n<li>Fix: Issue with missing file.<\\/li>\\n<li>Add: WooCommerce fields generator for products.<\\/li>\\n<li>Update: More modularity to increase UI tidyness and website\'s performance.<\\/li>\\n<\\/ul>\\n<p>0.5.7 (2023\\/01\\/30)<\\/p>\\n<ul>\\n<li>Update: The chatbot icon is now refered as \\"icon\\" (instead of \\"avatar\\" previously, which was confusing). We have an icon and an icon_position parameters for the chatbot.<\\/li>\\n<li>Fix: Crash while adding rows to the dataset.<\\/li>\\n<li>Add: Placeholders for the user name in the chatbot.<\\/li>\\n<li>Add: URL support for avatars for the user and\\/or the AI.<\\/li>\\n<\\/ul>\\n<p>0.5.4 (2023\\/01\\/29)<\\/p>\\n<ul>\\n<li>Add: Avatar position (avatar_position) can be set to \\"bottom-right\\", \\"top-left\\", etc.<\\/li>\\n<li>Add: You can specify an avatar URL for each chatbot (avatar parameter, in the shortcode).<\\/li>\\n<li>Fix: The expand icon was always displayed for the popup chatbot, even with fullsize set to false.<\\/li>\\n<li>Add: Entries Generator for the Dataset Builder. Use with caution!<\\/li>\\n<\\/ul>\\n<p>0.5.1 (2023\\/01\\/28)<\\/p>\\n<ul>\\n<li>Add: Chatbot avatars.<\\/li>\\n<li>Add: Color for the Header Buttons for the Chatbot Popup Window.<\\/li>\\n<li>Update: Enhanced the UI of the Settings, Chatbot and Content Generator.<\\/li>\\n<li>Update: The ID is now available in the Settings (reminder: ID allows you to set CSS more easily if you do it statically, it also keeps the conversations recorded in the browser between pages).<\\/li>\\n<li>Update: Enhancements relative to prompts, their placeholders, and UI visual adaption based on those.<\\/li>\\n<\\/ul>\\n<p>0.4.8 (2023\\/01\\/27)<\\/p>\\n<ul>\\n<li>Add: If no user_name and ai_name are mentioned, avatars will be used.<\\/li>\\n<li>Add: Status of OpenAI servers (a little warning sign will also be added on the tab if something is wrong).<\\/li>\\n<li>Add: Possibility to modify or remove the error messages through a filter.<\\/li>\\n<\\/ul>\\n<p>0.4.6 (2023\\/01\\/26)<\\/p>\\n<ul>\\n<li>Fixed: Resolved a potential issue with session (used for logging purposes).<\\/li>\\n<li>Fixed: The chatbot was not working properly on iPhones.<\\/li>\\n<\\/ul>\\n<p>0.4.5 (2023\\/01\\/25)<\\/p>\\n<ul>\\n<li>Add: Style the chatbot easily in the Settings.<\\/li>\\n<li>Add: Allow extra models to be added.<\\/li>\\n<li>Fix: Clean the context and the content-aware feature.<\\/li>\\n<\\/ul>\\n<p>0.4.3 (2023\\/01\\/24)<\\/p>\\n<ul>\\n<li>Update: Allow re-train a fined-tuned model.<\\/li>\\n<li>Fix: The session was started too late, potentially causing a warning.<\\/li>\\n<\\/ul>\\n<p>0.4.1 (2023\\/01\\/23)<\\/p>\\n<ul>\\n<li>Update: Better and simpler UI, make it a bit easier overall.<\\/li>\\n<li>Add: Statistics and Content-Aware features for Pro.<\\/li>\\n<li>Update: Make sure that all the AI requests have an \\"env\\" and a logical \\"session\\" associated (for logging purposes).<\\/li>\\n<\\/ul>\\n<p>0.3.5 (2023\\/01\\/22)<\\/p>\\n<ul>\\n<li>Update: Better calculation of the OpenAI \\"Usage\\".<\\/li>\\n<li>Update: Lot of refactoring and code enhancements to allow other AI services to be integrated.<\\/li>\\n<li>Add: Generate based on Topic (Content Generator).<\\/li>\\n<li>Update: Various enhancements in the UI.<\\/li>\\n<\\/ul>\\n<p>0.3.4 (2023\\/01\\/22)<\\/p>\\n<ul>\\n<li>Add: Code enhancements to support many new actions and filters.<\\/li>\\n<li>Add: Added actions and filters to modify the answers, limit the users, etc. More to come soon.<\\/li>\\n<\\/ul>\\n<p>0.3.3 (2023\\/01\\/21)<\\/p>\\n<ul>\\n<li>Add: Languages management (check <a href=\\"https:\\/\\/meowapps.com\\/ai-engine\\/tutorial\\/#add-or-remove-languages\\">https:\\/\\/meowapps.com\\/ai-engine\\/tutorial\\/#add-or-remove-languages<\\/a>).<\\/li>\\n<li>Add: The chatbot can be displayed in fullscreen (use fullscreen=\\"true\\" in the shortcode). It works logically with the window\\/popup mode: no popup? Fullscreen right away! Popup? Fullscreen on click :)<\\/li>\\n<li>Fix: A few potential issues that coult break a few things.<\\/li>\\n<li>Update: Cleaned the JS, CSS and HTML. I like when it\'s very tidy before going forward!<\\/li>\\n<\\/ul>\\n<p>0.2.9 (2023\\/01\\/19)<\\/p>\\n<ul>\\n<li>Fix: Responsive.<\\/li>\\n<li>Add: Shortcode builder for the chatbot. This makes it much easier!<\\/li>\\n<li>Add: Bunch of new options to inject the chatbot everywhere.<\\/li>\\n<li>Add: Syntax highlighting for the code potentially generated by the AI.<\\/li>\\n<li>Add: The chatbot can be displayed as a window\\/popup. Sorry, only one icon for now, but will add more!<\\/li>\\n<li>Add: Bunch of WordPress filters to modify everything and do everything :)<\\/li>\\n<\\/ul>\\n<p>0.2.6 (2023\\/01\\/18)<\\/p>\\n<ul>\\n<li>Update: Little UI enhancements and fixes.<\\/li>\\n<li>Add: \\"max_tokens\\" parameter for the chatbot shortcode.<\\/li>\\n<li>Add: \\"casually_fine_tuned\\" parameter for the chatbot shorcode (for fine-tuned models).<\\/li>\\n<\\/ul>\\n<p>0.2.4 (2023\\/01\\/17)<\\/p>\\n<ul>\\n<li>Update: Perfected the fine-tuning module (UI and features).<\\/li>\\n<li>Update: A few UI fixes but a lot more to come.<\\/li>\\n<\\/ul>\\n<p>0.2.3 (2023\\/01\\/16)<\\/p>\\n<ul>\\n<li>Add: Module to train your own AI model (visit the Settings &gt; Fine Tuning). My user interface makes it look easy, but creating datasets and training models is not easy. Let\'s go through this together and I\'ll enhance AI Engine to make it easier.<\\/li>\\n<li>Update: Possible to add new lines in the requests to the chatbot.<\\/li>\\n<\\/ul>\\n<p>0.2.2 (2023\\/01\\/13)<\\/p>\\n<ul>\\n<li>Add: Shortcode that creates an images generator bot.<\\/li>\\n<li>Fix: Bots are now responsive.<\\/li>\\n<li>Add: Button and placeholder of the bots can be translated.<\\/li>\\n<\\/ul>\\n<p>0.2.1 (2023\\/01\\/12)<\\/p>\\n<ul>\\n<li>Add: Images Generator! After getting your feedback, I will implement this Image Generator in a modal in the Post Editor.<\\/li>\\n<\\/ul>\\n<p>0.1.9 (2023\\/01\\/09)<\\/p>\\n<ul>\\n<li>Add: Many improvements to the chatbot! By default, it now uses ChatGPT style, and it also support replies from the AI using Markdown (and will convert it properly into HTML). Basically, you can have properly displayed code and better formatting in the chat!<\\/li>\\n<\\/ul>\\n<p>0.1.7 (2023\\/01\\/08)<\\/p>\\n<ul>\\n<li>Add: Handle the errors better in the UI.<\\/li>\\n<li>Add: The chatbot can be styled a bit more easily.<\\/li>\\n<\\/ul>\\n<p>0.1.6 (2023\\/01\\/07)<\\/p>\\n<ul>\\n<li>Fix: The timeout was 5s, which was too short for some requests. It\'s now 60s.<\\/li>\\n<\\/ul>\\n<p>0.1.5 (2023\\/01\\/06)<\\/p>\\n<ul>\\n<li>Add: New \'api_key\' parameter for the shortcode. The API Key can now be filtered, added through the shortcode, the filters, depending on your conditions.<\\/li>\\n<li>Fix: Better handling of errors.<\\/li>\\n<\\/ul>\\n<p>0.1.4 (2023\\/01\\/05)<\\/p>\\n<ul>\\n<li>Update: Sorry, the name of the parameters in the chatbot were confusing. I\'ve changed them to make it more clear.<\\/li>\\n<li>Add: New filter, and the possibility to add some CSS to the chatbot, directly through coding. Have a look on <a href=\\"https:\\/\\/meowapps.com\\/ai-engine\\/\\">https:\\/\\/meowapps.com\\/ai-engine\\/<\\/a>.<\\/li>\\n<\\/ul>\\n<p>0.1.0 (2023\\/01\\/01)<\\/p>\\n<ul>\\n<li>Fix: A few fixes in the playground.<\\/li>\\n<li>Add: Content Generator (available under Tools and Posts).<\\/li>\\n<\\/ul>\\n<p>0.0.7 (2022\\/12\\/30)<\\/p>\\n<ul>\\n<li>Fix: Little issue in the playground.<\\/li>\\n<li>Add: Model and temperature in the playground.<\\/li>\\n<li>Updated: Improved the chatbot, with more parameters (temperature, model), and a better layout (HTML only).<\\/li>\\n<\\/ul>\\n<p>0.0.3 (2022\\/12\\/29)<\\/p>\\n<ul>\\n<li>Add: Lightweight chatbot (beta).<\\/li>\\n<li>Fix: Missing icon.<\\/li>\\n<\\/ul>\\n<p>0.0.1 (2022\\/12\\/27)<\\/p>\\n<ul>\\n<li>First release.<\\/li>\\n<\\/ul>\\n"],"plugin":"ai-engine-pro\\/ai-engine-pro.php","id":"ai-engine-pro\\/ai-engine-pro.php"}";}','no');
INSERT INTO `wp_options` VALUES (187,'edd_sl_d446cf69d6d1320ddcc48aa3aeb2b2a5','a:2:{s:7:"timeout";i:1695563915;s:5:"value";s:105270:"{"new_version":"1.9.83","stable_version":"1.9.83","name":"AI Engine Pro","slug":"ai-engine-pro","url":"https:\\/\\/meowapps.com\\/products\\/ai-engine-pro\\/?changelog=1","last_updated":"2023-09-24 04:04:34","homepage":"https:\\/\\/meowapps.com\\/products\\/ai-engine-pro\\/","package":"https:\\/\\/meowapps.com\\/edd-sl\\/package_download\\/MTY5NTY3MTkxNTpiNDdiMDZiZmM5ZDY2NThmOThjMTAwNzU3NjA2YTAzODoxNzYzMTgzMzpiYTA5YWU5NzViOTBjNDBkYmFjNDk3MzA2NWYzMGQyMDpodHRwc0AvL3d3dy56b3JrLm5vOjA=","download_link":"https:\\/\\/meowapps.com\\/edd-sl\\/package_download\\/MTY5NTY3MTkxNTpiNDdiMDZiZmM5ZDY2NThmOThjMTAwNzU3NjA2YTAzODoxNzYzMTgzMzpiYTA5YWU5NzViOTBjNDBkYmFjNDk3MzA2NWYzMGQyMDpodHRwc0AvL3d3dy56b3JrLm5vOjA=","sections":{"description":"<p>Create a ChatGPT-like chatbot (or many of them, with different features and behaviors), generate content, images, quickly suggest titles and excerpts, track your OpenAI usage stats, and much more!<\\/p>\\n","changelog":"<p>1.9.83 (2023\\/09\\/23)<\\/p>\\n<ul>\\n<li>Fix: Avoid deprecation issues with PHP 8.2+.<\\/li>\\n<li>&#x1f3b5; Discuss with other users about features and issues on <a href=\\"https:\\/\\/discord.gg\\/bHDGh38\\">my Discord<\\/a>.<\\/li>\\n<li>&#x1f334; Keep me motivated with <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/reviews\\/\\">a little review here<\\/a>. Thank you!<\\/li>\\n<\\/ul>\\n<p>1.9.82 (2023\\/09\\/22)<\\/p>\\n<ul>\\n<li>Fix: The value of external select fields was not interpreted correctly.<\\/li>\\n<li>Fix: Better validation in the AI Forms.<\\/li>\\n<li>Fix: Empty chatbot shorcode will automatically switch to the default chatbot.<\\/li>\\n<li>Fix: Issues on mobile with the chatbot.<\\/li>\\n<li>Fix: Avoid displaying the rendered HTML in the chatbot when typed by the user.<\\/li>\\n<li>Update: Accept function calls without parameters, and make sure the types are correct.<\\/li>\\n<\\/ul>\\n<p>1.9.81 (2023\\/09\\/20)<\\/p>\\n<ul>\\n<li>Add: New gpt-3.5-turbo-instruct model. Have a look at <a href=\\"https:\\/\\/openai.com\\/research\\/instruction-following\\">this<\\/a>.<\\/li>\\n<li>Fix: AI Forms work better with external input fields (such as radios and checkboxes). The debugging mode is also now more verbose.<\\/li>\\n<li>Update: Consolidate the way ID and Custom ID are handled. That fixes a few issues with custom chatbots too.<\\/li>\\n<\\/ul>\\n<p>1.9.7 (2023\\/09\\/16)<\\/p>\\n<ul>\\n<li>Fix: Rewrite Content (in Embeddings) uses the right value as Max Tokens.<\\/li>\\n<li>Add: The Intro Message in the Settings can now be disabled, for a slighlty cleaner UI.<\\/li>\\n<li>Update: Optimized the way the UI is built and refreshed, for a better performance.<\\/li>\\n<\\/ul>\\n<p>1.9.6 (2023\\/09\\/13)<\\/p>\\n<ul>\\n<li>Add: The simpleChatbotQuery has now a memory of the discussion.<\\/li>\\n<li>Fix: Handle errors more gracefully when importing data.<\\/li>\\n<li>Fix: The data in the Copy Button in the Forms was missing line returns.<\\/li>\\n<li>Fix: Some issues with forms if the JS was loaded too early.<\\/li>\\n<li>&#x2728; The clientId was renamed into chatId (update your custom code if you use any).<\\/li>\\n<\\/ul>\\n<p>1.9.5 (2023\\/09\\/11)<\\/p>\\n<ul>\\n<li>Fix: Error when finetuning new models.<\\/li>\\n<li>Fix: Chatbot fullscreen issue.<\\/li>\\n<li>Update: AI Submit can be used outside a AI Container.<\\/li>\\n<li>Update: Register the user to the conversation with the chatbot if the user logs in.<\\/li>\\n<\\/ul>\\n<p>1.9.4 (2023\\/09\\/09)<\\/p>\\n<ul>\\n<li>Fix: Bulk Generate for the new finetunes.<\\/li>\\n<li>Fix: Issues with the dropdown position.<\\/li>\\n<li>Add: Copy Button in Forms.<\\/li>\\n<li>&#x1f607; The Public REST API is now only accessible if the requests are authenticated, to avoid abuse. The process can however be completely overriden. More information <a href=\\"https:\\/\\/meowapps.com\\/ai-engine\\/api\\/#public-rest-api\\">here<\\/a>.<\\/li>\\n<\\/ul>\\n<p>1.9.3 (2023\\/09\\/02)<\\/p>\\n<ul>\\n<li>Add: Added a new \\"simpleChatbotQuery\\" endpoint.<\\/li>\\n<li>Add: Embeddings Export to JSON.<\\/li>\\n<li>Fix: Embeddings Rewrite, Finetunes Entries Generator and WooCommerce Assistant now use correctly the Default Model set in the Settings.<\\/li>\\n<li>Update: Set the Batch Size (Hyperparameters) to 4 by default, rather than null.<\\/li>\\n<\\/ul>\\n<p>1.9.2 (2023\\/08\\/28)<\\/p>\\n<ul>\\n<li>Add: The \\"Finetunes\\" tab is now about the new models (and new format of JSONL). The former \\"Finetunes\\" tab has been renamed into \\"Legacy Finetunes\\" (and is only accessible if you enable it in the \\"Settings\\"). Try to finetune your own models using GPT 3.5! &#x1f973; More info <a href=\\"https:\\/\\/openai.com\\/blog\\/gpt-3-5-turbo-fine-tuning-and-api-updates\\">here<\\/a>.<\\/li>\\n<li>Info: It will take some time for me to update the documentation, as everything has just been announced by OpenAI and not much of it has been tested by the community (I am also testing it myself). I will update the documentation as soon as I can.<\\/li>\\n<\\/ul>\\n<p>1.9.1 (2023\\/08\\/22)<\\/p>\\n<ul>\\n<li>Fix: Issue with broken avatars.<\\/li>\\n<li>Fix: Security limitations were a bit too strict.<\\/li>\\n<li>Fix: Issue with forms when using external input elements.<\\/li>\\n<li>Update: Optimized content cleaning when used to create embeddings or by other parts of AI Engine.<\\/li>\\n<\\/ul>\\n<p>1.9.0 (2023\\/08\\/18)<\\/p>\\n<ul>\\n<li>Add: Added missing servers for Pinecone.<\\/li>\\n<li>Fix: Avoid the double slashes in some URLs.<\\/li>\\n<\\/ul>\\n<p>1.8.8 (2023\\/07\\/30)<\\/p>\\n<ul>\\n<li>Add: Public API. This is really beta, use with caution (and the endpoints might change).<\\/li>\\n<\\/ul>\\n<p>1.8.7 (2023\\/07\\/22)<\\/p>\\n<ul>\\n<li>Add: Support of <a href=\\"https:\\/\\/meowapps.com\\/ai-engine\\/api\\/#function-calling\\">Function Calling<\\/a> in the AI Engine API.<\\/li>\\n<li>Fix: Import Embeddings was not displaying progress accurately, and some error messages were wrong.<\\/li>\\n<\\/ul>\\n<p>1.8.6 (2023\\/07\\/20)<\\/p>\\n<ul>\\n<li>Add: New JS API filter: <a href=\\"https:\\/\\/meowapps.com\\/ai-engine\\/api\\/#js-filters\\">ai.reply<\\/a>.<\\/li>\\n<li>Add: Embeddings Import (CSV or JSON). Thanks, Mike! &#x263a;&#xfe0f;<\\/li>\\n<li>Fix: Few issues related to embeddings and their default values.<\\/li>\\n<li>Update: Enhanced the checkboxes.<\\/li>\\n<li>Update: Added the botId to the Query object.<\\/li>\\n<\\/ul>\\n<p>1.8.5 (2023\\/07\\/12)<\\/p>\\n<ul>\\n<li>Add: New filter \\"mwai_openai_models\\" to customize the models list. Check <a href=\\"https:\\/\\/wordpress.org\\/support\\/topic\\/how-to-use-gpt-4-0314\\/#post-16886291\\">this example<\\/a>.<\\/li>\\n<li>Fix: Avoid flooding the chatbot via the JS API.<\\/li>\\n<li>Fix: Avoid crashing when Deployment Name for Azure is empty.<\\/li>\\n<li>&#x26a0;&#xfe0f; Modernized AI form fields to use styles from the block editor. This will crash the forms already made, but they can be restored easily by clicking on the \\"Attempt Block Recovery\\" button.<\\/li>\\n<\\/ul>\\n<p>1.8.3 (2023\\/07\\/05)<\\/p>\\n<ul>\\n<li>Fix: Models list.<\\/li>\\n<li>Fix: Pricing.<\\/li>\\n<li>Fix: Tab handling when the botId is modified.<\\/li>\\n<li>Fix: Submit Block was broken in some cases.<\\/li>\\n<li>Update: Enhance the errors management in some cases.<\\/li>\\n<\\/ul>\\n<p>1.8.2 (2023\\/07\\/04)<\\/p>\\n<ul>\\n<li>Update: New OpenAI prices and upgraded the calculation system.<\\/li>\\n<li>Fix: There was no env for the forms.<\\/li>\\n<li>Fix: Weird issues with non-ASCII characters in tabs and Chatbot IDs.<\\/li>\\n<li>Fix: The languages filter was not working anymore.<\\/li>\\n<li>Fix: Embeddings were not working with the new forms.<\\/li>\\n<li>Fix: The Client-Side JS API was not using the latest context.<\\/li>\\n<\\/ul>\\n<p>1.8.1 (2023\\/07\\/29)<\\/p>\\n<ul>\\n<li>Fix: Little issue with radio fields.<\\/li>\\n<\\/ul>\\n<p>1.8.0 (2023\\/07\\/26)<\\/p>\\n<ul>\\n<li>Fix: Issue with how the logs table was created (it was only working for MySQL 5.6.5+, now works for older MySQL as well).<\\/li>\\n<\\/ul>\\n<p>1.7.9 (2023\\/06\\/25)<\\/p>\\n<ul>\\n<li>Add: DevTools tab for AI Engine. It will be used for advanced debugging and development by developers. I will add more and more little tools there.<\\/li>\\n<li>Fix: Avoid some errors if the stats object (from statistics queries) is null.<\\/li>\\n<\\/ul>\\n<p>1.7.8 (2023\\/06\\/23)<\\/p>\\n<ul>\\n<li>Update: The non-public post-types can now be \'Sync All\' if they are mentioned in the settings of \'Sync Posts\'.<\\/li>\\n<\\/ul>\\n<p>1.7.7 (2023\\/06\\/18)<\\/p>\\n<ul>\\n<li>Add: Many namespaces can now be used at the same time.<\\/li>\\n<li>Fix: Issue with the ask() function for the Chatbot JS API.<\\/li>\\n<\\/ul>\\n<p>1.7.6 (2023\\/06\\/15)<\\/p>\\n<ul>\\n<li>Add: Streaming in Playground.<\\/li>\\n<li>Update: Enhanced the UI of the Playground.<\\/li>\\n<li>Update: Better handling of the errors from OpenAI and Pinecone.<\\/li>\\n<\\/ul>\\n<p>1.7.5 (2023\\/06\\/14)<\\/p>\\n<ul>\\n<li>Add: Added the Turbo 16k model.<\\/li>\\n<li>Fix: Issue where \\"0\\" was considered as empty in the case of streaming.<\\/li>\\n<li>Fix: The AI Output can now be outside of the AI Container.<\\/li>\\n<\\/ul>\\n<p>1.7.3 (2023\\/06\\/11)<\\/p>\\n<ul>\\n<li>Add: Embeddings Export (no worries, Import will be next!).<\\/li>\\n<li>Update: Added a Sync button directly next to the outdated embeddings.<\\/li>\\n<li>Fix: Remove a few warnings and notices.<\\/li>\\n<\\/ul>\\n<p>1.7.2 (2023\\/06\\/07)<\\/p>\\n<ul>\\n<li>Fix: Randomize the file used to record streams on the server.<\\/li>\\n<li>Fix: New forms now works with selectors as inputs.<\\/li>\\n<\\/ul>\\n<p>1.7.1 (2023\\/06\\/06)<\\/p>\\n<ul>\\n<li>Fix: Limits work better.<\\/li>\\n<li>Update: This is really alpha, but discussions work a little bit. Check <a href=\\"https:\\/\\/meowapps.com\\/ai-engine\\/tutorial\\/#discussions\\">this<\\/a>.<\\/li>\\n<\\/ul>\\n<p>1.7.0 (2023\\/06\\/04)<\\/p>\\n<ul>\\n<li>Update: Forms have been rewritten to be more flexible, including streaming. Parameters are kept only on the server (your users can\'t see them). If any issue, you can switch back to the Legacy Forms (check the settings).<\\/li>\\n<li>Fix: Params relative to UI were not being overriden by the filters.<\\/li>\\n<li>Fix: Connection errors with OpenAI or Azure should be displayed.<\\/li>\\n<li>Fix: Limits were overriden by a misplaced line of code. Sorry about that!<\\/li>\\n<\\/ul>\\n<p>1.6.98 (2023\\/06\\/01)<\\/p>\\n<ul>\\n<li>Update: Huge improvements on streaming! When it\'s confirmed (by you dear users) that it works perfectly for the chatbot, I will add streaming to every other parts of AI Engine.<\\/li>\\n<\\/ul>\\n<p>1.6.97 (2023\\/05\\/31)<\\/p>\\n<ul>\\n<li>Fix: Additional fix for limits for admins and editors.<\\/li>\\n<li>Fix: Errors weren\'t sent correctly to the chatbot with stream.<\\/li>\\n<li>Fix: Avoid limits override to affect the system limits.<\\/li>\\n<li>Update: Removed the condition on apiRef (which was the API KEY used for the requests), as it\'s not clear how it will behave based on the usage of Azure.<\\/li>\\n<\\/ul>\\n<p>1.6.95 (2023\\/05\\/29)<\\/p>\\n<ul>\\n<li>Fix: There were issues with custom roles.<\\/li>\\n<li>Fix: Bypass security filters on words and IPs for embeddings for users with the right capability.<\\/li>\\n<li>Fix: Avoid the typewriter and the streaming to collide.<\\/li>\\n<\\/ul>\\n<p>1.6.94 (2023\\/05\\/28)<\\/p>\\n<ul>\\n<li>Add: Streaming for the chatbot (beta). Depending on the server configuration, it might not work.<\\/li>\\n<li>Fix: The styles of the syntax highlighting were overriden.<\\/li>\\n<li>Fix: Various issues with ID collisions (themes and chatbots).<\\/li>\\n<li>Update: The chatbots tab got a little lifting. Might be easier to figure things out for new users.<\\/li>\\n<\\/ul>\\n<p>1.6.92 (2023\\/05\\/27)<\\/p>\\n<ul>\\n<li>Fix: Issues with the new chatbot and finetunes.<\\/li>\\n<li>Fix: Improved and fixed issues related to the finetuned models management (the way it was handled was not optimal). Please refresh your models in the Finetunes tab.<\\/li>\\n<li>Fix: A variable in the chatbot might not be initialized, thus causing a warning.<\\/li>\\n<\\/ul>\\n<p>1.6.90 (2023\\/05\\/25)<\\/p>\\n<ul>\\n<li>Update: Support of Dall-E through Azure.<\\/li>\\n<li>Update: More refactoring (that will allow support of new engines in the future).<\\/li>\\n<\\/ul>\\n<p>1.6.89 (2023\\/05\\/24)<\\/p>\\n<ul>\\n<li>Fix: Issues related to finetuned models with the new chatbot v2.<\\/li>\\n<li>Update: The client-side discussions module got a bit better.<\\/li>\\n<li>Update: The system messages (usually, errors) are now displayed with a red background in the chatbot.<\\/li>\\n<li>Update: Improved the <a href=\\"https:\\/\\/meowapps.com\\/ai-engine\\/api\\/#simple-server-side-api-js\\">JS API<\\/a>.<\\/li>\\n<li>Update: Optimized the CSS of the ChatGPT theme.<\\/li>\\n<li>Fix: Sanitization for Text Compliance.<\\/li>\\n<\\/ul>\\n<p>1.6.88 (2023\\/05\\/21)<\\/p>\\n<ul>\\n<li>Update: Slighlty cleaner API for context. If you want to implement you own web search for AI Engine, have a look at <a href=\\"https:\\/\\/gist.github.com\\/jordymeow\\/c570826db8f72502f5f46a95cda30be5\\">this<\\/a>.<\\/li>\\n<li>Fix: Avoid the double slash when loading the script.<\\/li>\\n<li>Fix: Crash when embeddings\' subtype is set to something else than null or a string.<\\/li>\\n<li>Fix: Sanitization of the context shouldn\'t removed the line returns.<\\/li>\\n<\\/ul>\\n<p>1.6.85 (2023\\/05\\/20)<\\/p>\\n<ul>\\n<li>Update: Pinecone servers.<\\/li>\\n<li>Fix: Make it simpler for caching system to work with the plugin (nonce \\/ cookie issue).<\\/li>\\n<li>Fix: Secured the plugin against potential XSS attacks (thanks to WPScan).<\\/li>\\n<li>Fix: Line return support for users input.<\\/li>\\n<li>Fix: The filter related to rewriting errors was not always kicking in.<\\/li>\\n<li>Update: Enhancements in the discussions UI module. It\'s very alpha, but you can try it by adding [mwai_discussions id=\\"default\\"] to a page where the chatbot is.<\\/li>\\n<li>Update: Architectural changes. Moving towards the discussions (almost work).<\\/li>\\n<\\/ul>\\n<p>1.6.81 (2023\\/05\\/17)<\\/p>\\n<ul>\\n<li>Fix: Display SQL errors related to logging.<\\/li>\\n<li>Update: The MwaiAPI (for developers) is evolving a lot - discussions will be handled by it soon.<\\/li>\\n<\\/ul>\\n<p>1.6.79 (2023\\/05\\/14)<\\/p>\\n<ul>\\n<li>Update: Refactoring and cleaning.<\\/li>\\n<li>Fix: Issues with the chatbot when using DALL-E.<\\/li>\\n<li>Fix: Remove some potential PHP warnings.<\\/li>\\n<\\/ul>\\n<p>1.6.78 (2023\\/05\\/13)<\\/p>\\n<ul>\\n<li>Add: The messages coming through the API are now all overridable.<\\/li>\\n<li>Fix: Rounding issue for price calculation.<\\/li>\\n<\\/ul>\\n<p>1.6.77 (2023\\/05\\/12)<\\/p>\\n<ul>\\n<li>Add: Display of the Post Type for embeddings related to local content.<\\/li>\\n<li>Add: Button to duplicate a chatbot.<\\/li>\\n<li>Add: Reset button for overall settings.<\\/li>\\n<li>Fix: The default service is set to OpenAI (it wasn\'t set to anything at first).<\\/li>\\n<li>Update: Cleaned a bit more the REST API.<\\/li>\\n<li>Update: Move the Legacy Chatbot in the Chatbot Settings (it will be hidden to new users).<\\/li>\\n<\\/ul>\\n<p>1.6.76 (2023\\/05\\/11)<\\/p>\\n<ul>\\n<li>Add: Search for Discussions (it\'s done through the filter in the Preview column).<\\/li>\\n<li>Add: Delete Selected\\/All for the Discussions.<\\/li>\\n<li>Add: Reset button for chatbot.<\\/li>\\n<li>Update: The REST API has been cleaned out completely, simplified, rectified and improved.<\\/li>\\n<\\/ul>\\n<p>1.6.75 (2023\\/05\\/10)<\\/p>\\n<ul>\\n<li>Fix: Various issues related to the Chatbots\'s ID and ChatId.<\\/li>\\n<\\/ul>\\n<p>1.6.74 (2023\\/05\\/09)<\\/p>\\n<ul>\\n<li>Fix: Issue with non-string parameters in AI Forms.<\\/li>\\n<\\/ul>\\n<p>1.6.73 (2023\\/05\\/08)<\\/p>\\n<ul>\\n<li>Fix: Issue wih the chatbot\'s timer.<\\/li>\\n<\\/ul>\\n<p>1.6.72 (2023\\/05\\/07)<\\/p>\\n<ul>\\n<li>Update: Refactoring of the code to handle new features later.<\\/li>\\n<li>Add: Usage costs of audio models are now handled and accounted.<\\/li>\\n<li>Fix: Issue with custom chatbots that were not truly custom.<\\/li>\\n<li>Update: Enhancing how exceptions are being handled for a better error management.<\\/li>\\n<\\/ul>\\n<p>1.6.70 (2023\\/05\\/06)<\\/p>\\n<ul>\\n<li>Fix: Added \'Local Memory\' to the parameters.<\\/li>\\n<li>Fix: Issue with how Local Memory was handled with multiple IDs.<\\/li>\\n<\\/ul>\\n<p>1.6.69 (2023\\/05\\/05)<\\/p>\\n<ul>\\n<li>Fix: Tokens estimation was happening too early.<\\/li>\\n<li>Fix: Issue with chatbot names using only non-ASCII characters.<\\/li>\\n<li>Update &amp; Fix: Custom Shortcodes (for Chatbot v2) got much simpler and better.<\\/li>\\n<\\/ul>\\n<p>1.6.66 (2023\\/05\\/04)<\\/p>\\n<ul>\\n<li>Fix: Entries Generator was not getting the right counts.<\\/li>\\n<li>Fix: Messages theme had little visual glitches.<\\/li>\\n<li>Update: The chatbot scrolls to the bottom of the content when re-opened.<\\/li>\\n<li>Update: The paragraphs are back for the ChatGPT Theme.<\\/li>\\n<li>Update: The AI Wands is nicer to use, with better busy states.<\\/li>\\n<li>Update: More adaptability for the AI Engine API.<\\/li>\\n<li>Add: Shortcode \\"builder\\" for new chatbots.<\\/li>\\n<\\/ul>\\n<p>1.6.64 (2023\\/05\\/03)<\\/p>\\n<ul>\\n<li>Add: User\\/IP filter for the Discussions tab.<\\/li>\\n<li>Add: User\\/IP and Env filter for the Queries tab.<\\/li>\\n<li>Update: Optimized the way the scrolling is handled when typewriter is used.<\\/li>\\n<\\/ul>\\n<p>1.6.63 (2023\\/05\\/01)<\\/p>\\n<ul>\\n<li>Fix: Removed a notice.<\\/li>\\n<li>Update: Refactoring of the code to make it more consistent.<\\/li>\\n<li>Update: Attempt to avoid an issue with old plugins loading the JS media library in the footer.<\\/li>\\n<\\/ul>\\n<p>1.6.61 (2023\\/04\\/30)<\\/p>\\n<ul>\\n<li>Update: Some parts of the UI got improved, that will allow for more features to be developed.<\\/li>\\n<li>Update: Clean the API, class names, and the files hierarchy to make it more consistant.<\\/li>\\n<\\/ul>\\n<p>1.6.59 (2023\\/04\\/29)<\\/p>\\n<ul>\\n<li>Add: Logs the real issue when rejecting a query.<\\/li>\\n<li>Fix: Spinners wasn\'t working for Messages theme.<\\/li>\\n<li>Fix: The AI Wands were not using the language set in the current post.<\\/li>\\n<li>Update: Light enhancements to the Messages theme.<\\/li>\\n<\\/ul>\\n<p>1.6.58 (2023\\/04\\/28)<\\/p>\\n<ul>\\n<li>Fix: The input fields were not always focuses in the best way, should be much better now!<\\/li>\\n<li>Add: The Speech Recognition of the Web Speech API, just for fun (it\'s fast and free).<\\/li>\\n<\\/ul>\\n<p>1.6.57 (2023\\/04\\/27)<\\/p>\\n<ul>\\n<li>Update: The chatbot and its shortcode are much more powerful in the way they manage their settings and parameters. If you are still using the old shortcode, switch to the new one. Make sure to test all your chatbots, there are major changes, and let me know if there are issues.<\\/li>\\n<li>Update: Chatbot settings are now perfectly opaque (except when related to UI).<\\/li>\\n<li>Fix: Some issues with embeddings management.<\\/li>\\n<li>Fix: The assistants could not be disabled.<\\/li>\\n<li>Fix: Japanese, Chinese (and other languages) typing issues in AI Copilot.<\\/li>\\n<\\/ul>\\n<p>1.6.55 (2023\\/04\\/26)<\\/p>\\n<ul>\\n<li>Update: Using POST instead of PUT for the API calls (that avoid issues with with ModSecurity and other security plugins; though it was gramatically correct to use PUT to update data rather than POST).<\\/li>\\n<li>Update: Better error handling for templates.<\\/li>\\n<li>Update: Optimized the speed of retrieving logs data.<\\/li>\\n<li>Fix: Avoid issue with naming new chatbots \'default\'.<\\/li>\\n<li>Fix: Issue with models not appearing in the dropdown for finetuning.<\\/li>\\n<\\/ul>\\n<p>1.6.53 (2023\\/04\\/25)<\\/p>\\n<ul>\\n<li>Add: Ability to see the content of the query and reply objects, for any request that goes through AI Engine. This is in the Statistics Tab. API Keys are not logged however, for security reason.<\\/li>\\n<li>Fix: Code highlighting was not always working.<\\/li>\\n<li>Fix: Issues with Embeddings and PHP 7.3.<\\/li>\\n<li>Fix: Show a nicer placeholder than broken images with expired DALL-E images.<\\/li>\\n<li>Fix: The Send button which was sending circular data to the stringifyer.<\\/li>\\n<\\/ul>\\n<p>1.6.4 (2023\\/04\\/24)<\\/p>\\n<ul>\\n<li>Add: The JS API. Allows more control over the chatbot (to open it, to modify the typewriter speed, etc). You can find a few examples <a href=\\"https:\\/\\/meowapps.com\\/ai-engine\\/faq\\/#control-the-chatbot\\">here<\\/a>.<\\/li>\\n<li>Add: AI Forms support Speech-to-Text (through whisper).<\\/li>\\n<li>Update: A few enhancements on the AI Forms, for more clarity.<\\/li>\\n<li>Fix: Japanese keyboard was not supported in the chat textfield.<\\/li>\\n<li>Fix: The new chatbot was not working with images yet. Now works with DALL-E.<\\/li>\\n<li>Fix: Issue with Safari (the loading animation was staying - looks like a bug in Safari however)<\\/li>\\n<li>Fix: Too many parameters were injected in the front chatbot in the case of site-wide.<\\/li>\\n<\\/ul>\\n<p>1.6.2 (2023\\/04\\/23)<\\/p>\\n<ul>\\n<li>Add: Status for Posts Syncing for Embeddings.<\\/li>\\n<li>Fix: Scrolldown issue.<\\/li>\\n<li>Fix: Issue when placeholders for User Name (in chatbot) didn\'t have any data. Will now display Guest Name.<\\/li>\\n<li>Fix: The admin could crash if OpenAI incidents were not available.<\\/li>\\n<li>Add: Added the chatbotId as the ID for the chatbot in the HTML.<\\/li>\\n<\\/ul>\\n<p>1.6.0 (2023\\/04\\/22)<\\/p>\\n<ul>\\n<li>Add: You can choose a different model for the AI Tools (Magic Wand, AI Copilot and Suggestions). It uses to be only Turbo, but you can now pick another one like GPT-4. Look in Settings &gt; Admin Tools.<\\/li>\\n<li>Fix: Timeout for Images Generator was too short.<\\/li>\\n<li>Fix: Copy issue when typewriter was enabled.<\\/li>\\n<li>Update: Optimized the API behind the API Wand and AI Copilot.<\\/li>\\n<li>Update: Pinecone servers.<\\/li>\\n<li>Update: Improved the errors handling in Content Generator, Playground and Images Generator.<\\/li>\\n<\\/ul>\\n<p>1.5.9 (2023\\/04\\/21)<\\/p>\\n<ul>\\n<li>Update: Errors are handled better.<\\/li>\\n<li>Fix: Fullwidth for non-popup chatbot.<\\/li>\\n<\\/ul>\\n<p>1.5.8 (2023\\/04\\/20)<\\/p>\\n<ul>\\n<li>Fix: There were issues with the Audio Transcription.<\\/li>\\n<li>Fix: Unhandled role (which was a system role when an error is thrown).<\\/li>\\n<li>Fix: Pinecone servers could not been seen easily.<\\/li>\\n<li>Add: Possibility to disable local memory.<\\/li>\\n<\\/ul>\\n<p>1.5.6 (2023\\/04\\/19)<\\/p>\\n<ul>\\n<li>Add: Typewriter effect for the chatbot v2, should play well with the syntax coloring and everything else.<\\/li>\\n<li>Update: More refactoring and optimization of the chatbot v2. Ready to go forward!<\\/li>\\n<\\/ul>\\n<p>1.5.3 (2023\\/04\\/18)<\\/p>\\n<ul>\\n<li>Fix: Removed a few annoying PHP notices.<\\/li>\\n<li>Add: Max Messages for the new chatbot (now the new chatbot has everything and more).<\\/li>\\n<li>Add: Statistics tab displays more information, such as the service used (generally, it\'s OpenAI, but it could be Azure), and if the API Key used was the one set in the admin or if it was a custom one (added by the user for example).<\\/li>\\n<li>Update: Enhanced how everything is displayed in Statistics to spot potential issues more easily.<\\/li>\\n<li>Update: Reviewed the Settings tab for more clarity.<\\/li>\\n<li>Info: Moved the legacy chatbot tab on the very right end to encourage legacy users to switch to the new one.<\\/li>\\n<\\/ul>\\n<p>1.5.2 (2023\\/04\\/17)<\\/p>\\n<ul>\\n<li>Fix: The Chatbot V2 wasn\'t getting initialized with some themes.<\\/li>\\n<li>Add: Context Max Tokens allows truncating the context dynamically (for content-aware, embeddings, etc).<\\/li>\\n<li>Add: Better support for Azure (can link instances with models), and a big refactoring or the querying system.<\\/li>\\n<li>Fix: The copy button for the new chatbot was not implemented.<\\/li>\\n<\\/ul>\\n<p>1.5.1 (2023\\/04\\/16)<\\/p>\\n<ul>\\n<li>Add: Gutenberg Block for Chatbot.<\\/li>\\n<li>Add: Embeddings in Forms.<\\/li>\\n<li>Update: Enhance the AI Copilot and Blocks Tooks.<\\/li>\\n<li>Fix: Forms were a bit difficult to use (useful indications were hidden by mistake).<\\/li>\\n<\\/ul>\\n<p>1.4.8 (2023\\/04\\/15)<\\/p>\\n<ul>\\n<li>Add: Messages Theme.<\\/li>\\n<li>Update: Enhanced the theme system extensively.<\\/li>\\n<li>Fix: Many various little fixes.<\\/li>\\n<\\/ul>\\n<p>1.4.7 (2023\\/04\\/14)<\\/p>\\n<ul>\\n<li>Add: Slowing moving to a system for the Chatbot V2 that can handle animations.<\\/li>\\n<li>Fix: With the Chatbot V2, always the default chatbot was displayed.<\\/li>\\n<\\/ul>\\n<p>1.4.6 (2023\\/04\\/13)<\\/p>\\n<ul>\\n<li>Add: Friendly message to those who don\'t have access to GPT-4.<\\/li>\\n<li>Fix: Many fixed related to the Chatbot V2.<\\/li>\\n<li>Update: Enhanced the content-aware feature (and fixed it for the Chatbot V2)<\\/li>\\n<li>Add: Remove failed and cancelled finetuning jobs.<\\/li>\\n<li>Update: Cleaned the internal API.<\\/li>\\n<\\/ul>\\n<p>1.4.4 (2023\\/04\\/12)<\\/p>\\n<ul>\\n<li>Add: Site-wide V2 chatbot.<\\/li>\\n<li>Add: Remember chats for V2 chatbot.<\\/li>\\n<li>Update: Rejected messages will be removed from the conversation and will not be reused in further requests.<\\/li>\\n<li>Update: The \'finetuned\' status of the models now stand out more in the UI.<\\/li>\\n<\\/ul>\\n<p>1.4.3 (2023\\/04\\/11)<\\/p>\\n<ul>\\n<li>Add: Delete all discussions at once.<\\/li>\\n<li>Update: Refresh of the tables and checkboxes (better to keep everything consistent).<\\/li>\\n<\\/ul>\\n<p>1.4.2 (2023\\/04\\/09)<\\/p>\\n<ul>\\n<li>Update: Icon and Avatar for AI are now a bit more unified in the new chatbot system.<\\/li>\\n<li>Info: If you miss it, I released a new chabots system, check it out. It\'s beta!<\\/li>\\n<\\/ul>\\n<p>1.4.1 (2023\\/04\\/08)<\\/p>\\n<ul>\\n<li>Add: New system for chatbots. It\'s in beta, not everything is working, but as you can see, it will be easier and better to handle the chatbots from now on (and new features will be much easier to add too). You can try them out by heading to the Chatbots tab.<\\/li>\\n<li>Update: Pinecone servers.<\\/li>\\n<\\/ul>\\n<p>1.4.0 (2023\\/04\\/05)<\\/p>\\n<ul>\\n<li>Update: Pinecone servers.<\\/li>\\n<li>Add: System-wise limits (in order to prevent many kinds of abuse).<\\/li>\\n<li>Add: Limits can be set with minutes and seconds.<\\/li>\\n<\\/ul>\\n<p>1.3.98 (2023\\/04\\/03)<\\/p>\\n<ul>\\n<li>Fix: An issue related to memorizing the chats with GPT-Turbo.<\\/li>\\n<li>Fix: The Magic Wand was going a bit wild because of my previous optimization.<\\/li>\\n<li>Add: {EXCERPT} is now also usable via content aware.<\\/li>\\n<\\/ul>\\n<p>1.3.96 (2023\\/04\\/02)<\\/p>\\n<ul>\\n<li>Fix: Fixes and enhancements related to embeddings.<\\/li>\\n<li>Add: Post types filter for Sync Posts for embeddings.<\\/li>\\n<li>Add: Security improvements, avoid empty requests, banned words and banned IPs (CIDR ranges supported).<\\/li>\\n<\\/ul>\\n<p>1.3.94 (2023\\/04\\/01)<\\/p>\\n<ul>\\n<li>Fix: Icon param and query-&gt;replace (which caused AI Translate not to use the right language).<\\/li>\\n<li>Update: Since some of you suddently asked for it, the Magic Wand is back (and it will evolve).<\\/li>\\n<li>Fix: The situation with the \\"Clear\\" button has been... clarified!<\\/li>\\n<li>Fix: Various fix related to how the Gutenberg librairies are used to avoid collisions.<\\/li>\\n<\\/ul>\\n<p>1.3.92 (2023\\/03\\/31)<\\/p>\\n<ul>\\n<li>Fix: Post Edit links were not working.<\\/li>\\n<li>Fix: Issue with finetuned models when their suffix contained a number.<\\/li>\\n<li>Update: UI elements.<\\/li>\\n<li>Update: Improved internal API.<\\/li>\\n<\\/ul>\\n<p>1.3.90 (2023\\/03\\/30)<\\/p>\\n<ul>\\n<li>Add: Sync Posts with Embeddings (on Publish, on Update, and on Trash).<\\/li>\\n<li>Update: When missing orphan embeddings are found (a vector is in Pinecone, but not in WordPress), a specific orphan entry will be created. You can safely delete it. Best to keep everything clean.<\\/li>\\n<li>Update: Pinecone servers.<\\/li>\\n<\\/ul>\\n<p>1.3.88 (2023\\/03\\/29)<\\/p>\\n<ul>\\n<li>Update: Content Settings for Embeddings can be saved.<\\/li>\\n<li>Add: Support for OpenAI on Microsoft Azure (it\'s faster than Open AI servers).<\\/li>\\n<li>Fix: Issue with Sync All for embeddings.<\\/li>\\n<li>Update: Better layouts and colors when code is embedded in the chat.<\\/li>\\n<li>Update: Updated dashboard, and lighter bundles.<\\/li>\\n<\\/ul>\\n<p>1.3.83 (2023\\/03\\/27)<\\/p>\\n<ul>\\n<li>Add: New filters to handle the content of the posts.<\\/li>\\n<li>Update: Enhanced the discussions management.<\\/li>\\n<li>Update: Enhanced the embeddings management.<\\/li>\\n<li>Update: Translations.<\\/li>\\n<\\/ul>\\n<p>1.3.80 (2023\\/03\\/26)<\\/p>\\n<ul>\\n<li>Update: Embeddings are more dynamic, handle better hashes, better bulk actions, more placeholders.<\\/li>\\n<li>Add: Customization of the admin bar.<\\/li>\\n<li>Update: Enhanced the language picker to remember current user choice.<\\/li>\\n<li>Fix: The limits were off of one unit.<\\/li>\\n<li>Add: Copy button for the output field in the AI Forms.<\\/li>\\n<\\/ul>\\n<p>1.3.77 (2023\\/03\\/25)<\\/p>\\n<ul>\\n<li>Add: Max Tokens for the Forms.<\\/li>\\n<li>Add: Discussions tab has now a setting to be disabled (or not).<\\/li>\\n<li>Update: Pinecone servers.<\\/li>\\n<li>Fix: Color of the progress bars.<\\/li>\\n<\\/ul>\\n<p>1.3.75 (2023\\/03\\/24)<\\/p>\\n<ul>\\n<li>Fix: The TextArea in AI Forms was not working correctly with a default value.<\\/li>\\n<li>Fix: Casually Fined Tuned should be turn off if the model is not finetuned.<\\/li>\\n<li>Fix: On some installs, floats would be echoed with commas instead of dots.<\\/li>\\n<li>Info: It\'s my birthday &#x270c;&#xfe0f;&#x1f973;<\\/li>\\n<\\/ul>\\n<p>1.3.73 (2023\\/03\\/23)<\\/p>\\n<ul>\\n<li>Add: Post Type for Content Generator.<\\/li>\\n<li>Fix: Avoid a crash for the server which didn\'t install mbstring.<\\/li>\\n<li>Fix: The Meow Apps dashboard is back, with PHP Error Logs and evergthing.<\\/li>\\n<\\/ul>\\n<p>1.3.69 (2023\\/03\\/22)<\\/p>\\n<ul>\\n<li>Fix: Issue with non-default models in the forms.<\\/li>\\n<li>Add: Default value and rows for textarea and input fields.<\\/li>\\n<li>Fix: Assistants weren\'t really disabled (depending on the settings).<\\/li>\\n<li>Fix: Simplified a few UI elements.<\\/li>\\n<\\/ul>\\n<p>1.3.67 (2023\\/03\\/21)<\\/p>\\n<ul>\\n<li>Update: The Finetunes are now a module, that can be completely disabled (and it is, by default).<\\/li>\\n<li>Update: Overhaul of the language system. It\'s now unified, and I\'ll make it even better a bit later.<\\/li>\\n<li>Update: AI Engine automatically makes sure the texts aren\'t too long for some operations; it now uses the number of tokens rather than the number of characters. Give better results.<\\/li>\\n<li>Fix: Issue in the Content Generator.<\\/li>\\n<\\/ul>\\n<p>1.3.65 (2023\\/03\\/20)<\\/p>\\n<ul>\\n<li>Update: Handle the finetuned models a bit differently, for a faster UI, and lot of improvements (like the ability to cancel a finetune, calculate historical spent amount on deleted models, etc).<\\/li>\\n<\\/ul>\\n<p>1.3.64 (2023\\/03\\/19)<\\/p>\\n<ul>\\n<li>Update: Retrieve post types rather than only proposing post\\/page.<\\/li>\\n<li>Update: Handle errors from OpenAI a bit better in the admin (there is currently a huge one!).<\\/li>\\n<\\/ul>\\n<p>1.3.63 (2023\\/03\\/18)<\\/p>\\n<ul>\\n<li>Add: New GPT-4 and GPT-4 32k models.<\\/li>\\n<li>Update: Enhanced the way the prices are calculated to handle the new models.<\\/li>\\n<li>Fix: Better handling on the status icon for the OpenAI servers status.<\\/li>\\n<li>Add: Additional servers for Pinecone.<\\/li>\\n<\\/ul>\\n<p>1.3.60 (2023\\/03\\/17)<\\/p>\\n<ul>\\n<li>Add: Discussions tab, with embedding\'s title displayed in the message, when used.<\\/li>\\n<li>Add: Catch errors in the statistics if OpenAI returns something unexpected.<\\/li>\\n<li>Update: New colors framework.<\\/li>\\n<\\/ul>\\n<p>1.3.57 (2023\\/03\\/16)<\\/p>\\n<ul>\\n<li>Fix: Temperature was sometimes a bit too rounded.<\\/li>\\n<li>Update: Clean the admin screens a little.<\\/li>\\n<li>Update: Allow other models in the Content Generator.<\\/li>\\n<\\/ul>\\n<p>1.3.54 (2023\\/03\\/15)<\\/p>\\n<ul>\\n<li>Update: In the Content Generator, sections (headings) are not mandatory anymore. You can simply delete the associated prompt, and the sections fields will be removed as well. You can save it as your new template.<\\/li>\\n<li>Add: Width and Max Height for the Chatbot Popup in the Settings.<\\/li>\\n<li>Fix: Compatibility issues with older versions of PHP.<\\/li>\\n<li>Fix: Make sure the extra context brought by embedding doesn\'t break the maximum number of tokens.<\\/li>\\n<li>Fix: For some reason, some models didn\'t have the mode and that was leading to the UI to crash.<\\/li>\\n<\\/ul>\\n<p>1.3.49 (2023\\/03\\/14)<\\/p>\\n<ul>\\n<li>Add: Sanitize the content of the context for the shortcode.<\\/li>\\n<li>Add: Parameter in the builder for text_input_maxlength.<\\/li>\\n<li>Update: Enhanced handling of tokens.<\\/li>\\n<\\/ul>\\n<p>1.3.47 (2023\\/03\\/13)<\\/p>\\n<ul>\\n<li>Add: More Pinecone servers.<\\/li>\\n<li>Fix: Enhanced the tokens prediction; client-side also automatically limits the total content depending on it.<\\/li>\\n<\\/ul>\\n<p>1.3.44 (2023\\/03\\/12)<\\/p>\\n<ul>\\n<li>Update: Enhanced the whole bulk system.<\\/li>\\n<li>Update: Enhanced the tokens prediction for non-latin languages.<\\/li>\\n<\\/ul>\\n<p>1.3.42 (2023\\/03\\/11)<\\/p>\\n<ul>\\n<li>Fix: Better guess to lower the limit of max tokens dynamically.<\\/li>\\n<li>Update: Supports multilingual websites with embedddings (WPML, Polylang).<\\/li>\\n<li>Update: Huge update on the way embeddings are created, synchronized and managed.<\\/li>\\n<\\/ul>\\n<p>1.3.37 (2023\\/03\\/10)<\\/p>\\n<ul>\\n<li>Fix: Role management and capabilities.<\\/li>\\n<li>Fix: Avoid issue with wp_enqueue_script called at the wrong place.<\\/li>\\n<li>Add: Simplified API.<\\/li>\\n<li>Add: Maxlength for the chatbot input.<\\/li>\\n<li>Update: Working on the UI framework (dark theme will be possible on the WP side).<\\/li>\\n<\\/ul>\\n<p>1.3.34 (2023\\/03\\/09)<\\/p>\\n<ul>\\n<li>Fix: The shortcode builder when tackling empty values.<\\/li>\\n<li>Fix: Make it so that the context doesn\'t break anything whatever the language. Hey, not easy somehow!<\\/li>\\n<li>Fix: The embeddings dashboard handles cancellation of bulk operations better.<\\/li>\\n<\\/ul>\\n<p>1.3.32 (2023\\/03\\/08)<\\/p>\\n<ul>\\n<li>Add: Sync embeddings and posts.<\\/li>\\n<li>Add: Copy button to reuse the reply. Enabled by default, will add the UI for it later.<\\/li>\\n<li>Fix: Support of basics HTML in the compliance text.<\\/li>\\n<li>Fix: Avoid issues with Japanese.<\\/li>\\n<li>Fix: Enhanced the ChatGPT CSS (better header icons and fullscreen mode).<\\/li>\\n<\\/ul>\\n<p>1.3.2 (2023\\/03\\/07)<\\/p>\\n<ul>\\n<li>Add: New icon_alt parameter to add an Alt Text to the chatbot icon.<\\/li>\\n<li>Add: Styles for the tables in the chabot.<\\/li>\\n<li>Fix: Moved the external JS\\/CSS locally.<\\/li>\\n<li>Fix: Escaping and sanitization issues.<\\/li>\\n<li>Fix: General code cleaning and refactoring.<\\/li>\\n<li>Fix: The icon displaying OpenAI status was not showing the warning sign when needed.<\\/li>\\n<\\/ul>\\n<p>1.2.30 (2023\\/03\\/06)<\\/p>\\n<ul>\\n<li>Add: Embeddings. Add more context to your chatbot based on your data.<\\/li>\\n<li>Update: Better translations.<\\/li>\\n<li>Fix: Better format for the system error messages in the chatbot.&#x1f3b5;<\\/li>\\n<\\/ul>\\n<p>1.2.21 (2023\\/03\\/05)<\\/p>\\n<ul>\\n<li>Add: A little tool to play with Text-to-Speech using Whisper API.<\\/li>\\n<li>Add: Quick Usage Costs in the Content Generation (same system as in the Playground).<\\/li>\\n<li>Fix: There was an issue for new users without an OpenAI key.<\\/li>\\n<li>Fix: There was an issue when picking a different model for finetune.<\\/li>\\n<li>Add: The Content Generator now supports {TOPIC} and {TITLE} everywhere.<\\/li>\\n<\\/ul>\\n<p>1.2.0 (2023\\/03\\/04)<\\/p>\\n<ul>\\n<li>Update: Huge refactoring to make the plugin more extensible.<\\/li>\\n<li>Fix: UI issue in the Images Generator.<\\/li>\\n<\\/ul>\\n<p>1.1.8 (2023\\/03\\/03)<\\/p>\\n<ul>\\n<li>Fix: TextFields in Forms were broken.<\\/li>\\n<li>Fix: Some UI issues on the admin side.<\\/li>\\n<li>Update: Make sur the forms are filled (we can add a better validation system at a later point).<\\/li>\\n<\\/ul>\\n<p>1.1.6 (2023\\/03\\/02)<\\/p>\\n<ul>\\n<li>Add: The ChatGPT model is finally here! It\'s \\"gpt-3.5-turbo\\" and you can already use it with your chatbots, forms, in the playground, etc. It\'s very new so let me know if you find any issues, in the <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/\\">forums<\\/a>. Set as the new default.<\\/li>\\n<li>Add: Max Length for the Input and TextArea in AI Forms.<\\/li>\\n<li>Update: Many little enhancements here and there.<\\/li>\\n<li>Fix: Minor bug in the AI Playground.<\\/li>\\n<\\/ul>\\n<p>1.1.3 (2023\\/03\\/01)<\\/p>\\n<ul>\\n<li>Fix: UI issues in the Content Generator linked to the framework update.<\\/li>\\n<li>Add: Typewriter effect. I don\'t recommend it, but if you want to play with it, it\'s there :)<\\/li>\\n<li>Add: New filter: mwai_forms_params.<\\/li>\\n<li>Update: Refactoring and minor fixes. Making sure everything is stable and nice.<\\/li>\\n<\\/ul>\\n<p>1.1.1 (2023\\/02\\/28)<\\/p>\\n<ul>\\n<li>Add: New Moderation Module; it\'s beta, check it out and play with it.<\\/li>\\n<li>Update: Big update in my framework.<\\/li>\\n<\\/ul>\\n<p>1.1.0 (2023\\/02\\/26)<\\/p>\\n<ul>\\n<li>Update: Enhanced the whole flow of the chatbot (which also fixed minor issue).<\\/li>\\n<li>Update: Better handling of time in the statistics.<\\/li>\\n<\\/ul>\\n<p>1.0.8 (2023\\/02\\/25)<\\/p>\\n<ul>\\n<li>Add: Filter to takeover the conversation programmatically.<\\/li>\\n<li>Add: Compliance Text and Max Messages.<\\/li>\\n<li>Add: Hyperparams for finetuning.<\\/li>\\n<li>Add: Queries viewer.<\\/li>\\n<\\/ul>\\n<p>1.0.6 (2023\\/02\\/24)<\\/p>\\n<ul>\\n<li>Fixes: There were few issues with my Casually Fine-Tuned system.<\\/li>\\n<li>Add: Option to resolve shortcodes.<\\/li>\\n<\\/ul>\\n<p>1.0.5 (2023\\/02\\/23)<\\/p>\\n<ul>\\n<li>Add: Limit can be applied on a daily-basis.<\\/li>\\n<li>Add: Added ID for AI Submit so that we can hook and customize the advanced params for the AI Forms.<\\/li>\\n<li>Add: Parameters to hide\\/show values in the statistics shortcode.<\\/li>\\n<li>Add: The mwai-clear class has been added to the Clear button.<\\/li>\\n<\\/ul>\\n<p>1.0.3 (2023\\/02\\/22)<\\/p>\\n<ul>\\n<li>Fix: There was an alert popping in the AI Forms.<\\/li>\\n<li>Update: Better handling of user errors in the AI Forms.<\\/li>\\n<li>Update: The ChatGPT theme, if choosen, is applied to AI Forms too.<\\/li>\\n<\\/ul>\\n<p>1.0.1 (2023\\/02\\/21)<\\/p>\\n<ul>\\n<li>Fix: The Form Select wasn\'t working properly.<\\/li>\\n<li>Update: Translation framework.<\\/li>\\n<\\/ul>\\n<p>1.0.0 (2023\\/02\\/20)<\\/p>\\n<ul>\\n<li>Update: Enhance the chabot\'s input field visually.<\\/li>\\n<li>Update: Translation framework.<\\/li>\\n<\\/ul>\\n<p>0.9.99 (2023\\/02\\/19)<\\/p>\\n<ul>\\n<li>Update: Translation framework.<\\/li>\\n<\\/ul>\\n<p>0.9.98 (2023\\/02\\/18)<\\/p>\\n<ul>\\n<li>Fix: There was an exit applied if WP_DEBUG was used.<\\/li>\\n<li>Update: Default max_tokens for forms is now 2048.<\\/li>\\n<li>Add: New \'max_messages\' parameter to limit the number of sentences in the prompt for the chatbot.<\\/li>\\n<li>Add: AI Submit now handles using element based on their ID. Use it like this: {#myid}.<\\/li>\\n<li>Update: Enhance the internal API with better helpers.<\\/li>\\n<\\/ul>\\n<p>0.9.95 (2023\\/02\\/17)<\\/p>\\n<ul>\\n<li>Fix: Minor fixes related to notices and translations.<\\/li>\\n<li>Update: Enhanced Shortcode Builder.<\\/li>\\n<li>Add: UI for Custom Icon, Icon Message.<\\/li>\\n<li>Fix: Better control of the dirty state of the Post Editor.<\\/li>\\n<li>Add: Warn when the AI Forms are not properly set up to avoid issues.<\\/li>\\n<\\/ul>\\n<p>0.9.89 (2023\\/02\\/16)<\\/p>\\n<ul>\\n<li>Fix: Enhancement in the models screen.<\\/li>\\n<li>Fix: Better session control.<\\/li>\\n<li>Add: New placeholders {TITLE} and {URL} for the Q&amp;A Generator module.<\\/li>\\n<li>Update: Avoid an useless warning or two.<\\/li>\\n<\\/ul>\\n<p>0.9.86 (2023\\/02\\/15)<\\/p>\\n<ul>\\n<li>Update: Handle the colors more naturally depending on the CSS variables.<\\/li>\\n<li>Update: Make sure the max tokens are respected and not over-setted.<\\/li>\\n<li>Update: Better handling of max tokens with forms.<\\/li>\\n<li>Add: Enhanced the way the models and managed.<\\/li>\\n<li>Fix: Issues with forms using non-latin characters.<\\/li>\\n<\\/ul>\\n<p>0.9.85 (2023\\/02\\/14)<\\/p>\\n<ul>\\n<li>Fix: Minor issues related to max tokens.<\\/li>\\n<li>Fix: Some issues with forms, now also better layouts, more types, etc.<\\/li>\\n<li>Info: Happy Valentine\'s Day! &#x1f495; I\'ll take a few hours off &#x1f60a;<\\/li>\\n<\\/ul>\\n<p>0.9.84 (2023\\/02\\/13)<\\/p>\\n<ul>\\n<li>Fix: Compile conversations in order to avoid overwhelming the AI.<\\/li>\\n<li>Fix: When over the limits, forms display an alert nicely.<\\/li>\\n<li>Fix: Quick fix for Rank Math.<\\/li>\\n<li>Update: Optimized the way the fields and handled and reset in the Content Generator and the Templates.<\\/li>\\n<li>Add: Support of custom language (or type of language) in the Content Generator.<\\/li>\\n<li>Info: I would like to focus on making everything amazingly perfect for the version 1.x. I keep the new features for a bit later, and make sure everything we have now is stable and nice, as well as the code quality. Please share your feedback in the <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/\\">Support Threads<\\/a>.<\\/li>\\n<li>Info: If you enjoy this, don\'t hesitate to <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/reviews\\/\\">write a review<\\/a> :)<\\/li>\\n<\\/ul>\\n<p>0.9.82 (2023\\/02\\/12)<\\/p>\\n<ul>\\n<li>Add: Chat logs.<\\/li>\\n<li>Update: Cleaning the UI.<\\/li>\\n<li>Update: Refactoring.<\\/li>\\n<\\/ul>\\n<p>0.9.8 (2023\\/02\\/11)<\\/p>\\n<ul>\\n<li>Update: Quite a bit of refactoring.<\\/li>\\n<li>Add: Forms has the ability to work with DALL-E.<\\/li>\\n<li>Add: Position of the popup chatbot is now also in the settings.<\\/li>\\n<\\/ul>\\n<p>0.9.6 (2023\\/02\\/10)<\\/p>\\n<ul>\\n<li>Fix: There was an issue with statistics\\/logging related to the current API Key.<\\/li>\\n<li>Update: Enhanced the shortcode builder to avoid user mistakes.<\\/li>\\n<li>Update: Better sizes for chatbot icons.<\\/li>\\n<li>Update: Markdown support in AI Forms.<\\/li>\\n<li>Update: Dataset Generator allows replaying the bulk generation from a certain offset.<\\/li>\\n<li>Update: Better text validation before quickly generating titles and excerpts.<\\/li>\\n<li>Add: Timer in the chatbot button if the query takes more than 1 second.<\\/li>\\n<\\/ul>\\n<p>0.9.3 (2023\\/02\\/09)<\\/p>\\n<ul>\\n<li>Add: Debug Mode.<\\/li>\\n<li>Fix: There were issues when both limits were set to zero and special conditions were set through a filter.<\\/li>\\n<\\/ul>\\n<p>0.9.0 (2023\\/02\\/08)<\\/p>\\n<ul>\\n<li>Update: Can handle multiple apiKeys for statistics and limits.<\\/li>\\n<li>Update: Enhancements of the AI Forms.<\\/li>\\n<li>Update: Enhancements of Content-Aware, avoid repeated sentences, shorten content, etc.<\\/li>\\n<li>Fix: Some validations work, to avoid issues and hacks.<\\/li>\\n<\\/ul>\\n<p>0.8.8 (2023\\/02\\/07)<\\/p>\\n<ul>\\n<li>Add: New param for the chatbot: guest_name.<\\/li>\\n<li>Update: Better consistency in the UI.<\\/li>\\n<li>Fix: Minor fixes.<\\/li>\\n<li>Fix: There was a little inconsistency with \\"Use Topics as Titles\\".<\\/li>\\n<li>Update: Reviewed the styles - but this still need a lot of improvements.<\\/li>\\n<\\/ul>\\n<p>0.8.5 (2023\\/02\\/06)<\\/p>\\n<ul>\\n<li>Add: Pro Users: Visit the Statistics Tab and check the <a href=\\"https:\\/\\/meowapps.com\\/ai-engine\\/faq\\/\\">FAQ<\\/a>. Lots of fun ahead!<\\/li>\\n<li>Update: You can now enable\\/disable every feature to make the UI yours and for a better UX (that will also allow role-based access to different features).<\\/li>\\n<li>Info 1: Templates are super cool! I\'d be happy if you could join this <a href=\\"https:\\/\\/wordpress.org\\/support\\/topic\\/common-use-cases-for-templates\\/\\">discussion<\\/a> in the WordPress forums.<\\/li>\\n<li>Info 2: Share with me your feedback in the <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/\\">Support Threads<\\/a>, I\'ll make it better for you! And of course, if you like the plugin, please leave a review on <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/reviews\\/\\">WordPress.org<\\/a>. Thank you!<\\/li>\\n<\\/ul>\\n<p>0.8.2 (2023\\/02\\/05)<\\/p>\\n<ul>\\n<li>Update: Enhancements and fixes to the AI Forms + a ChatGPT theme for them.<\\/li>\\n<li>Update: A bit of tidying on the UI, and added warning messages to avoid common mistakes.<\\/li>\\n<li>Add: Words count in Playground and Content Generator.<\\/li>\\n<li>Add: The icon_text parameter to add a text next to the icon of the chatbot.<\\/li>\\n<li>Update: Made the CSS of the chatbot slighlty more specific to avoid being overriden by pagebuilders.<\\/li>\\n<\\/ul>\\n<p>0.7.6 (2023\\/02\\/04)<\\/p>\\n<ul>\\n<li>Fix: The icon of the chatbot was not applied.<\\/li>\\n<li>Update: Better AI Forms.<\\/li>\\n<li>Add: Templates for Content Generator. Templates are now available everywhere I wanted. I\'d be happy if you could join this <a href=\\"https:\\/\\/wordpress.org\\/support\\/topic\\/common-use-cases-for-templates\\/\\">discussion<\\/a> in the WordPress forums.<\\/li>\\n<\\/ul>\\n<p>0.7.2 (2023\\/02\\/03)<\\/p>\\n<ul>\\n<li>Update: \\"casually_fined_tuned\\" is now \\"casually_fine_tuned\\".<\\/li>\\n<li>Fix: Editor also have access to the AI features (but not the Settings). This behavior can be filtered.<\\/li>\\n<li>Add: AI Forms for Pro (extremely beta but it works).<\\/li>\\n<\\/ul>\\n<p>0.6.9 (2023\\/02\\/02)<\\/p>\\n<ul>\\n<li>Fix: The chatbot could potentially be over other clickable elements.<\\/li>\\n<li>Fix: Create Post has an issue in Single Generate mode.<\\/li>\\n<li>Add: The Templates Editor is now available in the Images Generator.<\\/li>\\n<\\/ul>\\n<p>0.6.6 (2023\\/02\\/01)<\\/p>\\n<ul>\\n<li>Add: Templates in the Playground are now editable.<\\/li>\\n<li>Fix: Avoid the content-aware to take too many tokens.<\\/li>\\n<li>Update: Many little enhancements in the UI elements.<\\/li>\\n<li>Update: Handles timeouts better. More and more buttons will display the time elapsed.<\\/li>\\n<\\/ul>\\n<p>0.6.2 (2023\\/01\\/31)<\\/p>\\n<ul>\\n<li>Add: The Post Bulk Generate feature is now working nicely.<\\/li>\\n<li>Fix: Issue with missing file.<\\/li>\\n<li>Add: WooCommerce fields generator for products.<\\/li>\\n<li>Update: More modularity to increase UI tidyness and website\'s performance.<\\/li>\\n<\\/ul>\\n<p>0.5.7 (2023\\/01\\/30)<\\/p>\\n<ul>\\n<li>Update: The chatbot icon is now refered as \\"icon\\" (instead of \\"avatar\\" previously, which was confusing). We have an icon and an icon_position parameters for the chatbot.<\\/li>\\n<li>Fix: Crash while adding rows to the dataset.<\\/li>\\n<li>Add: Placeholders for the user name in the chatbot.<\\/li>\\n<li>Add: URL support for avatars for the user and\\/or the AI.<\\/li>\\n<\\/ul>\\n<p>0.5.4 (2023\\/01\\/29)<\\/p>\\n<ul>\\n<li>Add: Avatar position (avatar_position) can be set to \\"bottom-right\\", \\"top-left\\", etc.<\\/li>\\n<li>Add: You can specify an avatar URL for each chatbot (avatar parameter, in the shortcode).<\\/li>\\n<li>Fix: The expand icon was always displayed for the popup chatbot, even with fullsize set to false.<\\/li>\\n<li>Add: Entries Generator for the Dataset Builder. Use with caution!<\\/li>\\n<\\/ul>\\n<p>0.5.1 (2023\\/01\\/28)<\\/p>\\n<ul>\\n<li>Add: Chatbot avatars.<\\/li>\\n<li>Add: Color for the Header Buttons for the Chatbot Popup Window.<\\/li>\\n<li>Update: Enhanced the UI of the Settings, Chatbot and Content Generator.<\\/li>\\n<li>Update: The ID is now available in the Settings (reminder: ID allows you to set CSS more easily if you do it statically, it also keeps the conversations recorded in the browser between pages).<\\/li>\\n<li>Update: Enhancements relative to prompts, their placeholders, and UI visual adaption based on those.<\\/li>\\n<\\/ul>\\n<p>0.4.8 (2023\\/01\\/27)<\\/p>\\n<ul>\\n<li>Add: If no user_name and ai_name are mentioned, avatars will be used.<\\/li>\\n<li>Add: Status of OpenAI servers (a little warning sign will also be added on the tab if something is wrong).<\\/li>\\n<li>Add: Possibility to modify or remove the error messages through a filter.<\\/li>\\n<\\/ul>\\n<p>0.4.6 (2023\\/01\\/26)<\\/p>\\n<ul>\\n<li>Fixed: Resolved a potential issue with session (used for logging purposes).<\\/li>\\n<li>Fixed: The chatbot was not working properly on iPhones.<\\/li>\\n<\\/ul>\\n<p>0.4.5 (2023\\/01\\/25)<\\/p>\\n<ul>\\n<li>Add: Style the chatbot easily in the Settings.<\\/li>\\n<li>Add: Allow extra models to be added.<\\/li>\\n<li>Fix: Clean the context and the content-aware feature.<\\/li>\\n<\\/ul>\\n<p>0.4.3 (2023\\/01\\/24)<\\/p>\\n<ul>\\n<li>Update: Allow re-train a fined-tuned model.<\\/li>\\n<li>Fix: The session was started too late, potentially causing a warning.<\\/li>\\n<\\/ul>\\n<p>0.4.1 (2023\\/01\\/23)<\\/p>\\n<ul>\\n<li>Update: Better and simpler UI, make it a bit easier overall.<\\/li>\\n<li>Add: Statistics and Content-Aware features for Pro.<\\/li>\\n<li>Update: Make sure that all the AI requests have an \\"env\\" and a logical \\"session\\" associated (for logging purposes).<\\/li>\\n<\\/ul>\\n<p>0.3.5 (2023\\/01\\/22)<\\/p>\\n<ul>\\n<li>Update: Better calculation of the OpenAI \\"Usage\\".<\\/li>\\n<li>Update: Lot of refactoring and code enhancements to allow other AI services to be integrated.<\\/li>\\n<li>Add: Generate based on Topic (Content Generator).<\\/li>\\n<li>Update: Various enhancements in the UI.<\\/li>\\n<\\/ul>\\n<p>0.3.4 (2023\\/01\\/22)<\\/p>\\n<ul>\\n<li>Add: Code enhancements to support many new actions and filters.<\\/li>\\n<li>Add: Added actions and filters to modify the answers, limit the users, etc. More to come soon.<\\/li>\\n<\\/ul>\\n<p>0.3.3 (2023\\/01\\/21)<\\/p>\\n<ul>\\n<li>Add: Languages management (check <a href=\\"https:\\/\\/meowapps.com\\/ai-engine\\/tutorial\\/#add-or-remove-languages\\">https:\\/\\/meowapps.com\\/ai-engine\\/tutorial\\/#add-or-remove-languages<\\/a>).<\\/li>\\n<li>Add: The chatbot can be displayed in fullscreen (use fullscreen=\\"true\\" in the shortcode). It works logically with the window\\/popup mode: no popup? Fullscreen right away! Popup? Fullscreen on click :)<\\/li>\\n<li>Fix: A few potential issues that coult break a few things.<\\/li>\\n<li>Update: Cleaned the JS, CSS and HTML. I like when it\'s very tidy before going forward!<\\/li>\\n<\\/ul>\\n<p>0.2.9 (2023\\/01\\/19)<\\/p>\\n<ul>\\n<li>Fix: Responsive.<\\/li>\\n<li>Add: Shortcode builder for the chatbot. This makes it much easier!<\\/li>\\n<li>Add: Bunch of new options to inject the chatbot everywhere.<\\/li>\\n<li>Add: Syntax highlighting for the code potentially generated by the AI.<\\/li>\\n<li>Add: The chatbot can be displayed as a window\\/popup. Sorry, only one icon for now, but will add more!<\\/li>\\n<li>Add: Bunch of WordPress filters to modify everything and do everything :)<\\/li>\\n<\\/ul>\\n<p>0.2.6 (2023\\/01\\/18)<\\/p>\\n<ul>\\n<li>Update: Little UI enhancements and fixes.<\\/li>\\n<li>Add: \\"max_tokens\\" parameter for the chatbot shortcode.<\\/li>\\n<li>Add: \\"casually_fine_tuned\\" parameter for the chatbot shorcode (for fine-tuned models).<\\/li>\\n<\\/ul>\\n<p>0.2.4 (2023\\/01\\/17)<\\/p>\\n<ul>\\n<li>Update: Perfected the fine-tuning module (UI and features).<\\/li>\\n<li>Update: A few UI fixes but a lot more to come.<\\/li>\\n<\\/ul>\\n<p>0.2.3 (2023\\/01\\/16)<\\/p>\\n<ul>\\n<li>Add: Module to train your own AI model (visit the Settings &gt; Fine Tuning). My user interface makes it look easy, but creating datasets and training models is not easy. Let\'s go through this together and I\'ll enhance AI Engine to make it easier.<\\/li>\\n<li>Update: Possible to add new lines in the requests to the chatbot.<\\/li>\\n<\\/ul>\\n<p>0.2.2 (2023\\/01\\/13)<\\/p>\\n<ul>\\n<li>Add: Shortcode that creates an images generator bot.<\\/li>\\n<li>Fix: Bots are now responsive.<\\/li>\\n<li>Add: Button and placeholder of the bots can be translated.<\\/li>\\n<\\/ul>\\n<p>0.2.1 (2023\\/01\\/12)<\\/p>\\n<ul>\\n<li>Add: Images Generator! After getting your feedback, I will implement this Image Generator in a modal in the Post Editor.<\\/li>\\n<\\/ul>\\n<p>0.1.9 (2023\\/01\\/09)<\\/p>\\n<ul>\\n<li>Add: Many improvements to the chatbot! By default, it now uses ChatGPT style, and it also support replies from the AI using Markdown (and will convert it properly into HTML). Basically, you can have properly displayed code and better formatting in the chat!<\\/li>\\n<\\/ul>\\n<p>0.1.7 (2023\\/01\\/08)<\\/p>\\n<ul>\\n<li>Add: Handle the errors better in the UI.<\\/li>\\n<li>Add: The chatbot can be styled a bit more easily.<\\/li>\\n<\\/ul>\\n<p>0.1.6 (2023\\/01\\/07)<\\/p>\\n<ul>\\n<li>Fix: The timeout was 5s, which was too short for some requests. It\'s now 60s.<\\/li>\\n<\\/ul>\\n<p>0.1.5 (2023\\/01\\/06)<\\/p>\\n<ul>\\n<li>Add: New \'api_key\' parameter for the shortcode. The API Key can now be filtered, added through the shortcode, the filters, depending on your conditions.<\\/li>\\n<li>Fix: Better handling of errors.<\\/li>\\n<\\/ul>\\n<p>0.1.4 (2023\\/01\\/05)<\\/p>\\n<ul>\\n<li>Update: Sorry, the name of the parameters in the chatbot were confusing. I\'ve changed them to make it more clear.<\\/li>\\n<li>Add: New filter, and the possibility to add some CSS to the chatbot, directly through coding. Have a look on <a href=\\"https:\\/\\/meowapps.com\\/ai-engine\\/\\">https:\\/\\/meowapps.com\\/ai-engine\\/<\\/a>.<\\/li>\\n<\\/ul>\\n<p>0.1.0 (2023\\/01\\/01)<\\/p>\\n<ul>\\n<li>Fix: A few fixes in the playground.<\\/li>\\n<li>Add: Content Generator (available under Tools and Posts).<\\/li>\\n<\\/ul>\\n<p>0.0.7 (2022\\/12\\/30)<\\/p>\\n<ul>\\n<li>Fix: Little issue in the playground.<\\/li>\\n<li>Add: Model and temperature in the playground.<\\/li>\\n<li>Updated: Improved the chatbot, with more parameters (temperature, model), and a better layout (HTML only).<\\/li>\\n<\\/ul>\\n<p>0.0.3 (2022\\/12\\/29)<\\/p>\\n<ul>\\n<li>Add: Lightweight chatbot (beta).<\\/li>\\n<li>Fix: Missing icon.<\\/li>\\n<\\/ul>\\n<p>0.0.1 (2022\\/12\\/27)<\\/p>\\n<ul>\\n<li>First release.<\\/li>\\n<\\/ul>\\n"},"banners":{"high":"","low":""},"icons":{"1x":"https:\\/\\/meowapps.com\\/wp-content\\/uploads\\/Magician.png","2x":"https:\\/\\/meowapps.com\\/wp-content\\/uploads\\/Magician.png"},"description":["<p>Create a ChatGPT-like chatbot (or many of them, with different features and behaviors), generate content, images, quickly suggest titles and excerpts, track your OpenAI usage stats, and much more!<\\/p>\\n"],"changelog":["<p>1.9.83 (2023\\/09\\/23)<\\/p>\\n<ul>\\n<li>Fix: Avoid deprecation issues with PHP 8.2+.<\\/li>\\n<li>&#x1f3b5; Discuss with other users about features and issues on <a href=\\"https:\\/\\/discord.gg\\/bHDGh38\\">my Discord<\\/a>.<\\/li>\\n<li>&#x1f334; Keep me motivated with <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/reviews\\/\\">a little review here<\\/a>. Thank you!<\\/li>\\n<\\/ul>\\n<p>1.9.82 (2023\\/09\\/22)<\\/p>\\n<ul>\\n<li>Fix: The value of external select fields was not interpreted correctly.<\\/li>\\n<li>Fix: Better validation in the AI Forms.<\\/li>\\n<li>Fix: Empty chatbot shorcode will automatically switch to the default chatbot.<\\/li>\\n<li>Fix: Issues on mobile with the chatbot.<\\/li>\\n<li>Fix: Avoid displaying the rendered HTML in the chatbot when typed by the user.<\\/li>\\n<li>Update: Accept function calls without parameters, and make sure the types are correct.<\\/li>\\n<\\/ul>\\n<p>1.9.81 (2023\\/09\\/20)<\\/p>\\n<ul>\\n<li>Add: New gpt-3.5-turbo-instruct model. Have a look at <a href=\\"https:\\/\\/openai.com\\/research\\/instruction-following\\">this<\\/a>.<\\/li>\\n<li>Fix: AI Forms work better with external input fields (such as radios and checkboxes). The debugging mode is also now more verbose.<\\/li>\\n<li>Update: Consolidate the way ID and Custom ID are handled. That fixes a few issues with custom chatbots too.<\\/li>\\n<\\/ul>\\n<p>1.9.7 (2023\\/09\\/16)<\\/p>\\n<ul>\\n<li>Fix: Rewrite Content (in Embeddings) uses the right value as Max Tokens.<\\/li>\\n<li>Add: The Intro Message in the Settings can now be disabled, for a slighlty cleaner UI.<\\/li>\\n<li>Update: Optimized the way the UI is built and refreshed, for a better performance.<\\/li>\\n<\\/ul>\\n<p>1.9.6 (2023\\/09\\/13)<\\/p>\\n<ul>\\n<li>Add: The simpleChatbotQuery has now a memory of the discussion.<\\/li>\\n<li>Fix: Handle errors more gracefully when importing data.<\\/li>\\n<li>Fix: The data in the Copy Button in the Forms was missing line returns.<\\/li>\\n<li>Fix: Some issues with forms if the JS was loaded too early.<\\/li>\\n<li>&#x2728; The clientId was renamed into chatId (update your custom code if you use any).<\\/li>\\n<\\/ul>\\n<p>1.9.5 (2023\\/09\\/11)<\\/p>\\n<ul>\\n<li>Fix: Error when finetuning new models.<\\/li>\\n<li>Fix: Chatbot fullscreen issue.<\\/li>\\n<li>Update: AI Submit can be used outside a AI Container.<\\/li>\\n<li>Update: Register the user to the conversation with the chatbot if the user logs in.<\\/li>\\n<\\/ul>\\n<p>1.9.4 (2023\\/09\\/09)<\\/p>\\n<ul>\\n<li>Fix: Bulk Generate for the new finetunes.<\\/li>\\n<li>Fix: Issues with the dropdown position.<\\/li>\\n<li>Add: Copy Button in Forms.<\\/li>\\n<li>&#x1f607; The Public REST API is now only accessible if the requests are authenticated, to avoid abuse. The process can however be completely overriden. More information <a href=\\"https:\\/\\/meowapps.com\\/ai-engine\\/api\\/#public-rest-api\\">here<\\/a>.<\\/li>\\n<\\/ul>\\n<p>1.9.3 (2023\\/09\\/02)<\\/p>\\n<ul>\\n<li>Add: Added a new \\"simpleChatbotQuery\\" endpoint.<\\/li>\\n<li>Add: Embeddings Export to JSON.<\\/li>\\n<li>Fix: Embeddings Rewrite, Finetunes Entries Generator and WooCommerce Assistant now use correctly the Default Model set in the Settings.<\\/li>\\n<li>Update: Set the Batch Size (Hyperparameters) to 4 by default, rather than null.<\\/li>\\n<\\/ul>\\n<p>1.9.2 (2023\\/08\\/28)<\\/p>\\n<ul>\\n<li>Add: The \\"Finetunes\\" tab is now about the new models (and new format of JSONL). The former \\"Finetunes\\" tab has been renamed into \\"Legacy Finetunes\\" (and is only accessible if you enable it in the \\"Settings\\"). Try to finetune your own models using GPT 3.5! &#x1f973; More info <a href=\\"https:\\/\\/openai.com\\/blog\\/gpt-3-5-turbo-fine-tuning-and-api-updates\\">here<\\/a>.<\\/li>\\n<li>Info: It will take some time for me to update the documentation, as everything has just been announced by OpenAI and not much of it has been tested by the community (I am also testing it myself). I will update the documentation as soon as I can.<\\/li>\\n<\\/ul>\\n<p>1.9.1 (2023\\/08\\/22)<\\/p>\\n<ul>\\n<li>Fix: Issue with broken avatars.<\\/li>\\n<li>Fix: Security limitations were a bit too strict.<\\/li>\\n<li>Fix: Issue with forms when using external input elements.<\\/li>\\n<li>Update: Optimized content cleaning when used to create embeddings or by other parts of AI Engine.<\\/li>\\n<\\/ul>\\n<p>1.9.0 (2023\\/08\\/18)<\\/p>\\n<ul>\\n<li>Add: Added missing servers for Pinecone.<\\/li>\\n<li>Fix: Avoid the double slashes in some URLs.<\\/li>\\n<\\/ul>\\n<p>1.8.8 (2023\\/07\\/30)<\\/p>\\n<ul>\\n<li>Add: Public API. This is really beta, use with caution (and the endpoints might change).<\\/li>\\n<\\/ul>\\n<p>1.8.7 (2023\\/07\\/22)<\\/p>\\n<ul>\\n<li>Add: Support of <a href=\\"https:\\/\\/meowapps.com\\/ai-engine\\/api\\/#function-calling\\">Function Calling<\\/a> in the AI Engine API.<\\/li>\\n<li>Fix: Import Embeddings was not displaying progress accurately, and some error messages were wrong.<\\/li>\\n<\\/ul>\\n<p>1.8.6 (2023\\/07\\/20)<\\/p>\\n<ul>\\n<li>Add: New JS API filter: <a href=\\"https:\\/\\/meowapps.com\\/ai-engine\\/api\\/#js-filters\\">ai.reply<\\/a>.<\\/li>\\n<li>Add: Embeddings Import (CSV or JSON). Thanks, Mike! &#x263a;&#xfe0f;<\\/li>\\n<li>Fix: Few issues related to embeddings and their default values.<\\/li>\\n<li>Update: Enhanced the checkboxes.<\\/li>\\n<li>Update: Added the botId to the Query object.<\\/li>\\n<\\/ul>\\n<p>1.8.5 (2023\\/07\\/12)<\\/p>\\n<ul>\\n<li>Add: New filter \\"mwai_openai_models\\" to customize the models list. Check <a href=\\"https:\\/\\/wordpress.org\\/support\\/topic\\/how-to-use-gpt-4-0314\\/#post-16886291\\">this example<\\/a>.<\\/li>\\n<li>Fix: Avoid flooding the chatbot via the JS API.<\\/li>\\n<li>Fix: Avoid crashing when Deployment Name for Azure is empty.<\\/li>\\n<li>&#x26a0;&#xfe0f; Modernized AI form fields to use styles from the block editor. This will crash the forms already made, but they can be restored easily by clicking on the \\"Attempt Block Recovery\\" button.<\\/li>\\n<\\/ul>\\n<p>1.8.3 (2023\\/07\\/05)<\\/p>\\n<ul>\\n<li>Fix: Models list.<\\/li>\\n<li>Fix: Pricing.<\\/li>\\n<li>Fix: Tab handling when the botId is modified.<\\/li>\\n<li>Fix: Submit Block was broken in some cases.<\\/li>\\n<li>Update: Enhance the errors management in some cases.<\\/li>\\n<\\/ul>\\n<p>1.8.2 (2023\\/07\\/04)<\\/p>\\n<ul>\\n<li>Update: New OpenAI prices and upgraded the calculation system.<\\/li>\\n<li>Fix: There was no env for the forms.<\\/li>\\n<li>Fix: Weird issues with non-ASCII characters in tabs and Chatbot IDs.<\\/li>\\n<li>Fix: The languages filter was not working anymore.<\\/li>\\n<li>Fix: Embeddings were not working with the new forms.<\\/li>\\n<li>Fix: The Client-Side JS API was not using the latest context.<\\/li>\\n<\\/ul>\\n<p>1.8.1 (2023\\/07\\/29)<\\/p>\\n<ul>\\n<li>Fix: Little issue with radio fields.<\\/li>\\n<\\/ul>\\n<p>1.8.0 (2023\\/07\\/26)<\\/p>\\n<ul>\\n<li>Fix: Issue with how the logs table was created (it was only working for MySQL 5.6.5+, now works for older MySQL as well).<\\/li>\\n<\\/ul>\\n<p>1.7.9 (2023\\/06\\/25)<\\/p>\\n<ul>\\n<li>Add: DevTools tab for AI Engine. It will be used for advanced debugging and development by developers. I will add more and more little tools there.<\\/li>\\n<li>Fix: Avoid some errors if the stats object (from statistics queries) is null.<\\/li>\\n<\\/ul>\\n<p>1.7.8 (2023\\/06\\/23)<\\/p>\\n<ul>\\n<li>Update: The non-public post-types can now be \'Sync All\' if they are mentioned in the settings of \'Sync Posts\'.<\\/li>\\n<\\/ul>\\n<p>1.7.7 (2023\\/06\\/18)<\\/p>\\n<ul>\\n<li>Add: Many namespaces can now be used at the same time.<\\/li>\\n<li>Fix: Issue with the ask() function for the Chatbot JS API.<\\/li>\\n<\\/ul>\\n<p>1.7.6 (2023\\/06\\/15)<\\/p>\\n<ul>\\n<li>Add: Streaming in Playground.<\\/li>\\n<li>Update: Enhanced the UI of the Playground.<\\/li>\\n<li>Update: Better handling of the errors from OpenAI and Pinecone.<\\/li>\\n<\\/ul>\\n<p>1.7.5 (2023\\/06\\/14)<\\/p>\\n<ul>\\n<li>Add: Added the Turbo 16k model.<\\/li>\\n<li>Fix: Issue where \\"0\\" was considered as empty in the case of streaming.<\\/li>\\n<li>Fix: The AI Output can now be outside of the AI Container.<\\/li>\\n<\\/ul>\\n<p>1.7.3 (2023\\/06\\/11)<\\/p>\\n<ul>\\n<li>Add: Embeddings Export (no worries, Import will be next!).<\\/li>\\n<li>Update: Added a Sync button directly next to the outdated embeddings.<\\/li>\\n<li>Fix: Remove a few warnings and notices.<\\/li>\\n<\\/ul>\\n<p>1.7.2 (2023\\/06\\/07)<\\/p>\\n<ul>\\n<li>Fix: Randomize the file used to record streams on the server.<\\/li>\\n<li>Fix: New forms now works with selectors as inputs.<\\/li>\\n<\\/ul>\\n<p>1.7.1 (2023\\/06\\/06)<\\/p>\\n<ul>\\n<li>Fix: Limits work better.<\\/li>\\n<li>Update: This is really alpha, but discussions work a little bit. Check <a href=\\"https:\\/\\/meowapps.com\\/ai-engine\\/tutorial\\/#discussions\\">this<\\/a>.<\\/li>\\n<\\/ul>\\n<p>1.7.0 (2023\\/06\\/04)<\\/p>\\n<ul>\\n<li>Update: Forms have been rewritten to be more flexible, including streaming. Parameters are kept only on the server (your users can\'t see them). If any issue, you can switch back to the Legacy Forms (check the settings).<\\/li>\\n<li>Fix: Params relative to UI were not being overriden by the filters.<\\/li>\\n<li>Fix: Connection errors with OpenAI or Azure should be displayed.<\\/li>\\n<li>Fix: Limits were overriden by a misplaced line of code. Sorry about that!<\\/li>\\n<\\/ul>\\n<p>1.6.98 (2023\\/06\\/01)<\\/p>\\n<ul>\\n<li>Update: Huge improvements on streaming! When it\'s confirmed (by you dear users) that it works perfectly for the chatbot, I will add streaming to every other parts of AI Engine.<\\/li>\\n<\\/ul>\\n<p>1.6.97 (2023\\/05\\/31)<\\/p>\\n<ul>\\n<li>Fix: Additional fix for limits for admins and editors.<\\/li>\\n<li>Fix: Errors weren\'t sent correctly to the chatbot with stream.<\\/li>\\n<li>Fix: Avoid limits override to affect the system limits.<\\/li>\\n<li>Update: Removed the condition on apiRef (which was the API KEY used for the requests), as it\'s not clear how it will behave based on the usage of Azure.<\\/li>\\n<\\/ul>\\n<p>1.6.95 (2023\\/05\\/29)<\\/p>\\n<ul>\\n<li>Fix: There were issues with custom roles.<\\/li>\\n<li>Fix: Bypass security filters on words and IPs for embeddings for users with the right capability.<\\/li>\\n<li>Fix: Avoid the typewriter and the streaming to collide.<\\/li>\\n<\\/ul>\\n<p>1.6.94 (2023\\/05\\/28)<\\/p>\\n<ul>\\n<li>Add: Streaming for the chatbot (beta). Depending on the server configuration, it might not work.<\\/li>\\n<li>Fix: The styles of the syntax highlighting were overriden.<\\/li>\\n<li>Fix: Various issues with ID collisions (themes and chatbots).<\\/li>\\n<li>Update: The chatbots tab got a little lifting. Might be easier to figure things out for new users.<\\/li>\\n<\\/ul>\\n<p>1.6.92 (2023\\/05\\/27)<\\/p>\\n<ul>\\n<li>Fix: Issues with the new chatbot and finetunes.<\\/li>\\n<li>Fix: Improved and fixed issues related to the finetuned models management (the way it was handled was not optimal). Please refresh your models in the Finetunes tab.<\\/li>\\n<li>Fix: A variable in the chatbot might not be initialized, thus causing a warning.<\\/li>\\n<\\/ul>\\n<p>1.6.90 (2023\\/05\\/25)<\\/p>\\n<ul>\\n<li>Update: Support of Dall-E through Azure.<\\/li>\\n<li>Update: More refactoring (that will allow support of new engines in the future).<\\/li>\\n<\\/ul>\\n<p>1.6.89 (2023\\/05\\/24)<\\/p>\\n<ul>\\n<li>Fix: Issues related to finetuned models with the new chatbot v2.<\\/li>\\n<li>Update: The client-side discussions module got a bit better.<\\/li>\\n<li>Update: The system messages (usually, errors) are now displayed with a red background in the chatbot.<\\/li>\\n<li>Update: Improved the <a href=\\"https:\\/\\/meowapps.com\\/ai-engine\\/api\\/#simple-server-side-api-js\\">JS API<\\/a>.<\\/li>\\n<li>Update: Optimized the CSS of the ChatGPT theme.<\\/li>\\n<li>Fix: Sanitization for Text Compliance.<\\/li>\\n<\\/ul>\\n<p>1.6.88 (2023\\/05\\/21)<\\/p>\\n<ul>\\n<li>Update: Slighlty cleaner API for context. If you want to implement you own web search for AI Engine, have a look at <a href=\\"https:\\/\\/gist.github.com\\/jordymeow\\/c570826db8f72502f5f46a95cda30be5\\">this<\\/a>.<\\/li>\\n<li>Fix: Avoid the double slash when loading the script.<\\/li>\\n<li>Fix: Crash when embeddings\' subtype is set to something else than null or a string.<\\/li>\\n<li>Fix: Sanitization of the context shouldn\'t removed the line returns.<\\/li>\\n<\\/ul>\\n<p>1.6.85 (2023\\/05\\/20)<\\/p>\\n<ul>\\n<li>Update: Pinecone servers.<\\/li>\\n<li>Fix: Make it simpler for caching system to work with the plugin (nonce \\/ cookie issue).<\\/li>\\n<li>Fix: Secured the plugin against potential XSS attacks (thanks to WPScan).<\\/li>\\n<li>Fix: Line return support for users input.<\\/li>\\n<li>Fix: The filter related to rewriting errors was not always kicking in.<\\/li>\\n<li>Update: Enhancements in the discussions UI module. It\'s very alpha, but you can try it by adding [mwai_discussions id=\\"default\\"] to a page where the chatbot is.<\\/li>\\n<li>Update: Architectural changes. Moving towards the discussions (almost work).<\\/li>\\n<\\/ul>\\n<p>1.6.81 (2023\\/05\\/17)<\\/p>\\n<ul>\\n<li>Fix: Display SQL errors related to logging.<\\/li>\\n<li>Update: The MwaiAPI (for developers) is evolving a lot - discussions will be handled by it soon.<\\/li>\\n<\\/ul>\\n<p>1.6.79 (2023\\/05\\/14)<\\/p>\\n<ul>\\n<li>Update: Refactoring and cleaning.<\\/li>\\n<li>Fix: Issues with the chatbot when using DALL-E.<\\/li>\\n<li>Fix: Remove some potential PHP warnings.<\\/li>\\n<\\/ul>\\n<p>1.6.78 (2023\\/05\\/13)<\\/p>\\n<ul>\\n<li>Add: The messages coming through the API are now all overridable.<\\/li>\\n<li>Fix: Rounding issue for price calculation.<\\/li>\\n<\\/ul>\\n<p>1.6.77 (2023\\/05\\/12)<\\/p>\\n<ul>\\n<li>Add: Display of the Post Type for embeddings related to local content.<\\/li>\\n<li>Add: Button to duplicate a chatbot.<\\/li>\\n<li>Add: Reset button for overall settings.<\\/li>\\n<li>Fix: The default service is set to OpenAI (it wasn\'t set to anything at first).<\\/li>\\n<li>Update: Cleaned a bit more the REST API.<\\/li>\\n<li>Update: Move the Legacy Chatbot in the Chatbot Settings (it will be hidden to new users).<\\/li>\\n<\\/ul>\\n<p>1.6.76 (2023\\/05\\/11)<\\/p>\\n<ul>\\n<li>Add: Search for Discussions (it\'s done through the filter in the Preview column).<\\/li>\\n<li>Add: Delete Selected\\/All for the Discussions.<\\/li>\\n<li>Add: Reset button for chatbot.<\\/li>\\n<li>Update: The REST API has been cleaned out completely, simplified, rectified and improved.<\\/li>\\n<\\/ul>\\n<p>1.6.75 (2023\\/05\\/10)<\\/p>\\n<ul>\\n<li>Fix: Various issues related to the Chatbots\'s ID and ChatId.<\\/li>\\n<\\/ul>\\n<p>1.6.74 (2023\\/05\\/09)<\\/p>\\n<ul>\\n<li>Fix: Issue with non-string parameters in AI Forms.<\\/li>\\n<\\/ul>\\n<p>1.6.73 (2023\\/05\\/08)<\\/p>\\n<ul>\\n<li>Fix: Issue wih the chatbot\'s timer.<\\/li>\\n<\\/ul>\\n<p>1.6.72 (2023\\/05\\/07)<\\/p>\\n<ul>\\n<li>Update: Refactoring of the code to handle new features later.<\\/li>\\n<li>Add: Usage costs of audio models are now handled and accounted.<\\/li>\\n<li>Fix: Issue with custom chatbots that were not truly custom.<\\/li>\\n<li>Update: Enhancing how exceptions are being handled for a better error management.<\\/li>\\n<\\/ul>\\n<p>1.6.70 (2023\\/05\\/06)<\\/p>\\n<ul>\\n<li>Fix: Added \'Local Memory\' to the parameters.<\\/li>\\n<li>Fix: Issue with how Local Memory was handled with multiple IDs.<\\/li>\\n<\\/ul>\\n<p>1.6.69 (2023\\/05\\/05)<\\/p>\\n<ul>\\n<li>Fix: Tokens estimation was happening too early.<\\/li>\\n<li>Fix: Issue with chatbot names using only non-ASCII characters.<\\/li>\\n<li>Update &amp; Fix: Custom Shortcodes (for Chatbot v2) got much simpler and better.<\\/li>\\n<\\/ul>\\n<p>1.6.66 (2023\\/05\\/04)<\\/p>\\n<ul>\\n<li>Fix: Entries Generator was not getting the right counts.<\\/li>\\n<li>Fix: Messages theme had little visual glitches.<\\/li>\\n<li>Update: The chatbot scrolls to the bottom of the content when re-opened.<\\/li>\\n<li>Update: The paragraphs are back for the ChatGPT Theme.<\\/li>\\n<li>Update: The AI Wands is nicer to use, with better busy states.<\\/li>\\n<li>Update: More adaptability for the AI Engine API.<\\/li>\\n<li>Add: Shortcode \\"builder\\" for new chatbots.<\\/li>\\n<\\/ul>\\n<p>1.6.64 (2023\\/05\\/03)<\\/p>\\n<ul>\\n<li>Add: User\\/IP filter for the Discussions tab.<\\/li>\\n<li>Add: User\\/IP and Env filter for the Queries tab.<\\/li>\\n<li>Update: Optimized the way the scrolling is handled when typewriter is used.<\\/li>\\n<\\/ul>\\n<p>1.6.63 (2023\\/05\\/01)<\\/p>\\n<ul>\\n<li>Fix: Removed a notice.<\\/li>\\n<li>Update: Refactoring of the code to make it more consistent.<\\/li>\\n<li>Update: Attempt to avoid an issue with old plugins loading the JS media library in the footer.<\\/li>\\n<\\/ul>\\n<p>1.6.61 (2023\\/04\\/30)<\\/p>\\n<ul>\\n<li>Update: Some parts of the UI got improved, that will allow for more features to be developed.<\\/li>\\n<li>Update: Clean the API, class names, and the files hierarchy to make it more consistant.<\\/li>\\n<\\/ul>\\n<p>1.6.59 (2023\\/04\\/29)<\\/p>\\n<ul>\\n<li>Add: Logs the real issue when rejecting a query.<\\/li>\\n<li>Fix: Spinners wasn\'t working for Messages theme.<\\/li>\\n<li>Fix: The AI Wands were not using the language set in the current post.<\\/li>\\n<li>Update: Light enhancements to the Messages theme.<\\/li>\\n<\\/ul>\\n<p>1.6.58 (2023\\/04\\/28)<\\/p>\\n<ul>\\n<li>Fix: The input fields were not always focuses in the best way, should be much better now!<\\/li>\\n<li>Add: The Speech Recognition of the Web Speech API, just for fun (it\'s fast and free).<\\/li>\\n<\\/ul>\\n<p>1.6.57 (2023\\/04\\/27)<\\/p>\\n<ul>\\n<li>Update: The chatbot and its shortcode are much more powerful in the way they manage their settings and parameters. If you are still using the old shortcode, switch to the new one. Make sure to test all your chatbots, there are major changes, and let me know if there are issues.<\\/li>\\n<li>Update: Chatbot settings are now perfectly opaque (except when related to UI).<\\/li>\\n<li>Fix: Some issues with embeddings management.<\\/li>\\n<li>Fix: The assistants could not be disabled.<\\/li>\\n<li>Fix: Japanese, Chinese (and other languages) typing issues in AI Copilot.<\\/li>\\n<\\/ul>\\n<p>1.6.55 (2023\\/04\\/26)<\\/p>\\n<ul>\\n<li>Update: Using POST instead of PUT for the API calls (that avoid issues with with ModSecurity and other security plugins; though it was gramatically correct to use PUT to update data rather than POST).<\\/li>\\n<li>Update: Better error handling for templates.<\\/li>\\n<li>Update: Optimized the speed of retrieving logs data.<\\/li>\\n<li>Fix: Avoid issue with naming new chatbots \'default\'.<\\/li>\\n<li>Fix: Issue with models not appearing in the dropdown for finetuning.<\\/li>\\n<\\/ul>\\n<p>1.6.53 (2023\\/04\\/25)<\\/p>\\n<ul>\\n<li>Add: Ability to see the content of the query and reply objects, for any request that goes through AI Engine. This is in the Statistics Tab. API Keys are not logged however, for security reason.<\\/li>\\n<li>Fix: Code highlighting was not always working.<\\/li>\\n<li>Fix: Issues with Embeddings and PHP 7.3.<\\/li>\\n<li>Fix: Show a nicer placeholder than broken images with expired DALL-E images.<\\/li>\\n<li>Fix: The Send button which was sending circular data to the stringifyer.<\\/li>\\n<\\/ul>\\n<p>1.6.4 (2023\\/04\\/24)<\\/p>\\n<ul>\\n<li>Add: The JS API. Allows more control over the chatbot (to open it, to modify the typewriter speed, etc). You can find a few examples <a href=\\"https:\\/\\/meowapps.com\\/ai-engine\\/faq\\/#control-the-chatbot\\">here<\\/a>.<\\/li>\\n<li>Add: AI Forms support Speech-to-Text (through whisper).<\\/li>\\n<li>Update: A few enhancements on the AI Forms, for more clarity.<\\/li>\\n<li>Fix: Japanese keyboard was not supported in the chat textfield.<\\/li>\\n<li>Fix: The new chatbot was not working with images yet. Now works with DALL-E.<\\/li>\\n<li>Fix: Issue with Safari (the loading animation was staying - looks like a bug in Safari however)<\\/li>\\n<li>Fix: Too many parameters were injected in the front chatbot in the case of site-wide.<\\/li>\\n<\\/ul>\\n<p>1.6.2 (2023\\/04\\/23)<\\/p>\\n<ul>\\n<li>Add: Status for Posts Syncing for Embeddings.<\\/li>\\n<li>Fix: Scrolldown issue.<\\/li>\\n<li>Fix: Issue when placeholders for User Name (in chatbot) didn\'t have any data. Will now display Guest Name.<\\/li>\\n<li>Fix: The admin could crash if OpenAI incidents were not available.<\\/li>\\n<li>Add: Added the chatbotId as the ID for the chatbot in the HTML.<\\/li>\\n<\\/ul>\\n<p>1.6.0 (2023\\/04\\/22)<\\/p>\\n<ul>\\n<li>Add: You can choose a different model for the AI Tools (Magic Wand, AI Copilot and Suggestions). It uses to be only Turbo, but you can now pick another one like GPT-4. Look in Settings &gt; Admin Tools.<\\/li>\\n<li>Fix: Timeout for Images Generator was too short.<\\/li>\\n<li>Fix: Copy issue when typewriter was enabled.<\\/li>\\n<li>Update: Optimized the API behind the API Wand and AI Copilot.<\\/li>\\n<li>Update: Pinecone servers.<\\/li>\\n<li>Update: Improved the errors handling in Content Generator, Playground and Images Generator.<\\/li>\\n<\\/ul>\\n<p>1.5.9 (2023\\/04\\/21)<\\/p>\\n<ul>\\n<li>Update: Errors are handled better.<\\/li>\\n<li>Fix: Fullwidth for non-popup chatbot.<\\/li>\\n<\\/ul>\\n<p>1.5.8 (2023\\/04\\/20)<\\/p>\\n<ul>\\n<li>Fix: There were issues with the Audio Transcription.<\\/li>\\n<li>Fix: Unhandled role (which was a system role when an error is thrown).<\\/li>\\n<li>Fix: Pinecone servers could not been seen easily.<\\/li>\\n<li>Add: Possibility to disable local memory.<\\/li>\\n<\\/ul>\\n<p>1.5.6 (2023\\/04\\/19)<\\/p>\\n<ul>\\n<li>Add: Typewriter effect for the chatbot v2, should play well with the syntax coloring and everything else.<\\/li>\\n<li>Update: More refactoring and optimization of the chatbot v2. Ready to go forward!<\\/li>\\n<\\/ul>\\n<p>1.5.3 (2023\\/04\\/18)<\\/p>\\n<ul>\\n<li>Fix: Removed a few annoying PHP notices.<\\/li>\\n<li>Add: Max Messages for the new chatbot (now the new chatbot has everything and more).<\\/li>\\n<li>Add: Statistics tab displays more information, such as the service used (generally, it\'s OpenAI, but it could be Azure), and if the API Key used was the one set in the admin or if it was a custom one (added by the user for example).<\\/li>\\n<li>Update: Enhanced how everything is displayed in Statistics to spot potential issues more easily.<\\/li>\\n<li>Update: Reviewed the Settings tab for more clarity.<\\/li>\\n<li>Info: Moved the legacy chatbot tab on the very right end to encourage legacy users to switch to the new one.<\\/li>\\n<\\/ul>\\n<p>1.5.2 (2023\\/04\\/17)<\\/p>\\n<ul>\\n<li>Fix: The Chatbot V2 wasn\'t getting initialized with some themes.<\\/li>\\n<li>Add: Context Max Tokens allows truncating the context dynamically (for content-aware, embeddings, etc).<\\/li>\\n<li>Add: Better support for Azure (can link instances with models), and a big refactoring or the querying system.<\\/li>\\n<li>Fix: The copy button for the new chatbot was not implemented.<\\/li>\\n<\\/ul>\\n<p>1.5.1 (2023\\/04\\/16)<\\/p>\\n<ul>\\n<li>Add: Gutenberg Block for Chatbot.<\\/li>\\n<li>Add: Embeddings in Forms.<\\/li>\\n<li>Update: Enhance the AI Copilot and Blocks Tooks.<\\/li>\\n<li>Fix: Forms were a bit difficult to use (useful indications were hidden by mistake).<\\/li>\\n<\\/ul>\\n<p>1.4.8 (2023\\/04\\/15)<\\/p>\\n<ul>\\n<li>Add: Messages Theme.<\\/li>\\n<li>Update: Enhanced the theme system extensively.<\\/li>\\n<li>Fix: Many various little fixes.<\\/li>\\n<\\/ul>\\n<p>1.4.7 (2023\\/04\\/14)<\\/p>\\n<ul>\\n<li>Add: Slowing moving to a system for the Chatbot V2 that can handle animations.<\\/li>\\n<li>Fix: With the Chatbot V2, always the default chatbot was displayed.<\\/li>\\n<\\/ul>\\n<p>1.4.6 (2023\\/04\\/13)<\\/p>\\n<ul>\\n<li>Add: Friendly message to those who don\'t have access to GPT-4.<\\/li>\\n<li>Fix: Many fixed related to the Chatbot V2.<\\/li>\\n<li>Update: Enhanced the content-aware feature (and fixed it for the Chatbot V2)<\\/li>\\n<li>Add: Remove failed and cancelled finetuning jobs.<\\/li>\\n<li>Update: Cleaned the internal API.<\\/li>\\n<\\/ul>\\n<p>1.4.4 (2023\\/04\\/12)<\\/p>\\n<ul>\\n<li>Add: Site-wide V2 chatbot.<\\/li>\\n<li>Add: Remember chats for V2 chatbot.<\\/li>\\n<li>Update: Rejected messages will be removed from the conversation and will not be reused in further requests.<\\/li>\\n<li>Update: The \'finetuned\' status of the models now stand out more in the UI.<\\/li>\\n<\\/ul>\\n<p>1.4.3 (2023\\/04\\/11)<\\/p>\\n<ul>\\n<li>Add: Delete all discussions at once.<\\/li>\\n<li>Update: Refresh of the tables and checkboxes (better to keep everything consistent).<\\/li>\\n<\\/ul>\\n<p>1.4.2 (2023\\/04\\/09)<\\/p>\\n<ul>\\n<li>Update: Icon and Avatar for AI are now a bit more unified in the new chatbot system.<\\/li>\\n<li>Info: If you miss it, I released a new chabots system, check it out. It\'s beta!<\\/li>\\n<\\/ul>\\n<p>1.4.1 (2023\\/04\\/08)<\\/p>\\n<ul>\\n<li>Add: New system for chatbots. It\'s in beta, not everything is working, but as you can see, it will be easier and better to handle the chatbots from now on (and new features will be much easier to add too). You can try them out by heading to the Chatbots tab.<\\/li>\\n<li>Update: Pinecone servers.<\\/li>\\n<\\/ul>\\n<p>1.4.0 (2023\\/04\\/05)<\\/p>\\n<ul>\\n<li>Update: Pinecone servers.<\\/li>\\n<li>Add: System-wise limits (in order to prevent many kinds of abuse).<\\/li>\\n<li>Add: Limits can be set with minutes and seconds.<\\/li>\\n<\\/ul>\\n<p>1.3.98 (2023\\/04\\/03)<\\/p>\\n<ul>\\n<li>Fix: An issue related to memorizing the chats with GPT-Turbo.<\\/li>\\n<li>Fix: The Magic Wand was going a bit wild because of my previous optimization.<\\/li>\\n<li>Add: {EXCERPT} is now also usable via content aware.<\\/li>\\n<\\/ul>\\n<p>1.3.96 (2023\\/04\\/02)<\\/p>\\n<ul>\\n<li>Fix: Fixes and enhancements related to embeddings.<\\/li>\\n<li>Add: Post types filter for Sync Posts for embeddings.<\\/li>\\n<li>Add: Security improvements, avoid empty requests, banned words and banned IPs (CIDR ranges supported).<\\/li>\\n<\\/ul>\\n<p>1.3.94 (2023\\/04\\/01)<\\/p>\\n<ul>\\n<li>Fix: Icon param and query-&gt;replace (which caused AI Translate not to use the right language).<\\/li>\\n<li>Update: Since some of you suddently asked for it, the Magic Wand is back (and it will evolve).<\\/li>\\n<li>Fix: The situation with the \\"Clear\\" button has been... clarified!<\\/li>\\n<li>Fix: Various fix related to how the Gutenberg librairies are used to avoid collisions.<\\/li>\\n<\\/ul>\\n<p>1.3.92 (2023\\/03\\/31)<\\/p>\\n<ul>\\n<li>Fix: Post Edit links were not working.<\\/li>\\n<li>Fix: Issue with finetuned models when their suffix contained a number.<\\/li>\\n<li>Update: UI elements.<\\/li>\\n<li>Update: Improved internal API.<\\/li>\\n<\\/ul>\\n<p>1.3.90 (2023\\/03\\/30)<\\/p>\\n<ul>\\n<li>Add: Sync Posts with Embeddings (on Publish, on Update, and on Trash).<\\/li>\\n<li>Update: When missing orphan embeddings are found (a vector is in Pinecone, but not in WordPress), a specific orphan entry will be created. You can safely delete it. Best to keep everything clean.<\\/li>\\n<li>Update: Pinecone servers.<\\/li>\\n<\\/ul>\\n<p>1.3.88 (2023\\/03\\/29)<\\/p>\\n<ul>\\n<li>Update: Content Settings for Embeddings can be saved.<\\/li>\\n<li>Add: Support for OpenAI on Microsoft Azure (it\'s faster than Open AI servers).<\\/li>\\n<li>Fix: Issue with Sync All for embeddings.<\\/li>\\n<li>Update: Better layouts and colors when code is embedded in the chat.<\\/li>\\n<li>Update: Updated dashboard, and lighter bundles.<\\/li>\\n<\\/ul>\\n<p>1.3.83 (2023\\/03\\/27)<\\/p>\\n<ul>\\n<li>Add: New filters to handle the content of the posts.<\\/li>\\n<li>Update: Enhanced the discussions management.<\\/li>\\n<li>Update: Enhanced the embeddings management.<\\/li>\\n<li>Update: Translations.<\\/li>\\n<\\/ul>\\n<p>1.3.80 (2023\\/03\\/26)<\\/p>\\n<ul>\\n<li>Update: Embeddings are more dynamic, handle better hashes, better bulk actions, more placeholders.<\\/li>\\n<li>Add: Customization of the admin bar.<\\/li>\\n<li>Update: Enhanced the language picker to remember current user choice.<\\/li>\\n<li>Fix: The limits were off of one unit.<\\/li>\\n<li>Add: Copy button for the output field in the AI Forms.<\\/li>\\n<\\/ul>\\n<p>1.3.77 (2023\\/03\\/25)<\\/p>\\n<ul>\\n<li>Add: Max Tokens for the Forms.<\\/li>\\n<li>Add: Discussions tab has now a setting to be disabled (or not).<\\/li>\\n<li>Update: Pinecone servers.<\\/li>\\n<li>Fix: Color of the progress bars.<\\/li>\\n<\\/ul>\\n<p>1.3.75 (2023\\/03\\/24)<\\/p>\\n<ul>\\n<li>Fix: The TextArea in AI Forms was not working correctly with a default value.<\\/li>\\n<li>Fix: Casually Fined Tuned should be turn off if the model is not finetuned.<\\/li>\\n<li>Fix: On some installs, floats would be echoed with commas instead of dots.<\\/li>\\n<li>Info: It\'s my birthday &#x270c;&#xfe0f;&#x1f973;<\\/li>\\n<\\/ul>\\n<p>1.3.73 (2023\\/03\\/23)<\\/p>\\n<ul>\\n<li>Add: Post Type for Content Generator.<\\/li>\\n<li>Fix: Avoid a crash for the server which didn\'t install mbstring.<\\/li>\\n<li>Fix: The Meow Apps dashboard is back, with PHP Error Logs and evergthing.<\\/li>\\n<\\/ul>\\n<p>1.3.69 (2023\\/03\\/22)<\\/p>\\n<ul>\\n<li>Fix: Issue with non-default models in the forms.<\\/li>\\n<li>Add: Default value and rows for textarea and input fields.<\\/li>\\n<li>Fix: Assistants weren\'t really disabled (depending on the settings).<\\/li>\\n<li>Fix: Simplified a few UI elements.<\\/li>\\n<\\/ul>\\n<p>1.3.67 (2023\\/03\\/21)<\\/p>\\n<ul>\\n<li>Update: The Finetunes are now a module, that can be completely disabled (and it is, by default).<\\/li>\\n<li>Update: Overhaul of the language system. It\'s now unified, and I\'ll make it even better a bit later.<\\/li>\\n<li>Update: AI Engine automatically makes sure the texts aren\'t too long for some operations; it now uses the number of tokens rather than the number of characters. Give better results.<\\/li>\\n<li>Fix: Issue in the Content Generator.<\\/li>\\n<\\/ul>\\n<p>1.3.65 (2023\\/03\\/20)<\\/p>\\n<ul>\\n<li>Update: Handle the finetuned models a bit differently, for a faster UI, and lot of improvements (like the ability to cancel a finetune, calculate historical spent amount on deleted models, etc).<\\/li>\\n<\\/ul>\\n<p>1.3.64 (2023\\/03\\/19)<\\/p>\\n<ul>\\n<li>Update: Retrieve post types rather than only proposing post\\/page.<\\/li>\\n<li>Update: Handle errors from OpenAI a bit better in the admin (there is currently a huge one!).<\\/li>\\n<\\/ul>\\n<p>1.3.63 (2023\\/03\\/18)<\\/p>\\n<ul>\\n<li>Add: New GPT-4 and GPT-4 32k models.<\\/li>\\n<li>Update: Enhanced the way the prices are calculated to handle the new models.<\\/li>\\n<li>Fix: Better handling on the status icon for the OpenAI servers status.<\\/li>\\n<li>Add: Additional servers for Pinecone.<\\/li>\\n<\\/ul>\\n<p>1.3.60 (2023\\/03\\/17)<\\/p>\\n<ul>\\n<li>Add: Discussions tab, with embedding\'s title displayed in the message, when used.<\\/li>\\n<li>Add: Catch errors in the statistics if OpenAI returns something unexpected.<\\/li>\\n<li>Update: New colors framework.<\\/li>\\n<\\/ul>\\n<p>1.3.57 (2023\\/03\\/16)<\\/p>\\n<ul>\\n<li>Fix: Temperature was sometimes a bit too rounded.<\\/li>\\n<li>Update: Clean the admin screens a little.<\\/li>\\n<li>Update: Allow other models in the Content Generator.<\\/li>\\n<\\/ul>\\n<p>1.3.54 (2023\\/03\\/15)<\\/p>\\n<ul>\\n<li>Update: In the Content Generator, sections (headings) are not mandatory anymore. You can simply delete the associated prompt, and the sections fields will be removed as well. You can save it as your new template.<\\/li>\\n<li>Add: Width and Max Height for the Chatbot Popup in the Settings.<\\/li>\\n<li>Fix: Compatibility issues with older versions of PHP.<\\/li>\\n<li>Fix: Make sure the extra context brought by embedding doesn\'t break the maximum number of tokens.<\\/li>\\n<li>Fix: For some reason, some models didn\'t have the mode and that was leading to the UI to crash.<\\/li>\\n<\\/ul>\\n<p>1.3.49 (2023\\/03\\/14)<\\/p>\\n<ul>\\n<li>Add: Sanitize the content of the context for the shortcode.<\\/li>\\n<li>Add: Parameter in the builder for text_input_maxlength.<\\/li>\\n<li>Update: Enhanced handling of tokens.<\\/li>\\n<\\/ul>\\n<p>1.3.47 (2023\\/03\\/13)<\\/p>\\n<ul>\\n<li>Add: More Pinecone servers.<\\/li>\\n<li>Fix: Enhanced the tokens prediction; client-side also automatically limits the total content depending on it.<\\/li>\\n<\\/ul>\\n<p>1.3.44 (2023\\/03\\/12)<\\/p>\\n<ul>\\n<li>Update: Enhanced the whole bulk system.<\\/li>\\n<li>Update: Enhanced the tokens prediction for non-latin languages.<\\/li>\\n<\\/ul>\\n<p>1.3.42 (2023\\/03\\/11)<\\/p>\\n<ul>\\n<li>Fix: Better guess to lower the limit of max tokens dynamically.<\\/li>\\n<li>Update: Supports multilingual websites with embedddings (WPML, Polylang).<\\/li>\\n<li>Update: Huge update on the way embeddings are created, synchronized and managed.<\\/li>\\n<\\/ul>\\n<p>1.3.37 (2023\\/03\\/10)<\\/p>\\n<ul>\\n<li>Fix: Role management and capabilities.<\\/li>\\n<li>Fix: Avoid issue with wp_enqueue_script called at the wrong place.<\\/li>\\n<li>Add: Simplified API.<\\/li>\\n<li>Add: Maxlength for the chatbot input.<\\/li>\\n<li>Update: Working on the UI framework (dark theme will be possible on the WP side).<\\/li>\\n<\\/ul>\\n<p>1.3.34 (2023\\/03\\/09)<\\/p>\\n<ul>\\n<li>Fix: The shortcode builder when tackling empty values.<\\/li>\\n<li>Fix: Make it so that the context doesn\'t break anything whatever the language. Hey, not easy somehow!<\\/li>\\n<li>Fix: The embeddings dashboard handles cancellation of bulk operations better.<\\/li>\\n<\\/ul>\\n<p>1.3.32 (2023\\/03\\/08)<\\/p>\\n<ul>\\n<li>Add: Sync embeddings and posts.<\\/li>\\n<li>Add: Copy button to reuse the reply. Enabled by default, will add the UI for it later.<\\/li>\\n<li>Fix: Support of basics HTML in the compliance text.<\\/li>\\n<li>Fix: Avoid issues with Japanese.<\\/li>\\n<li>Fix: Enhanced the ChatGPT CSS (better header icons and fullscreen mode).<\\/li>\\n<\\/ul>\\n<p>1.3.2 (2023\\/03\\/07)<\\/p>\\n<ul>\\n<li>Add: New icon_alt parameter to add an Alt Text to the chatbot icon.<\\/li>\\n<li>Add: Styles for the tables in the chabot.<\\/li>\\n<li>Fix: Moved the external JS\\/CSS locally.<\\/li>\\n<li>Fix: Escaping and sanitization issues.<\\/li>\\n<li>Fix: General code cleaning and refactoring.<\\/li>\\n<li>Fix: The icon displaying OpenAI status was not showing the warning sign when needed.<\\/li>\\n<\\/ul>\\n<p>1.2.30 (2023\\/03\\/06)<\\/p>\\n<ul>\\n<li>Add: Embeddings. Add more context to your chatbot based on your data.<\\/li>\\n<li>Update: Better translations.<\\/li>\\n<li>Fix: Better format for the system error messages in the chatbot.&#x1f3b5;<\\/li>\\n<\\/ul>\\n<p>1.2.21 (2023\\/03\\/05)<\\/p>\\n<ul>\\n<li>Add: A little tool to play with Text-to-Speech using Whisper API.<\\/li>\\n<li>Add: Quick Usage Costs in the Content Generation (same system as in the Playground).<\\/li>\\n<li>Fix: There was an issue for new users without an OpenAI key.<\\/li>\\n<li>Fix: There was an issue when picking a different model for finetune.<\\/li>\\n<li>Add: The Content Generator now supports {TOPIC} and {TITLE} everywhere.<\\/li>\\n<\\/ul>\\n<p>1.2.0 (2023\\/03\\/04)<\\/p>\\n<ul>\\n<li>Update: Huge refactoring to make the plugin more extensible.<\\/li>\\n<li>Fix: UI issue in the Images Generator.<\\/li>\\n<\\/ul>\\n<p>1.1.8 (2023\\/03\\/03)<\\/p>\\n<ul>\\n<li>Fix: TextFields in Forms were broken.<\\/li>\\n<li>Fix: Some UI issues on the admin side.<\\/li>\\n<li>Update: Make sur the forms are filled (we can add a better validation system at a later point).<\\/li>\\n<\\/ul>\\n<p>1.1.6 (2023\\/03\\/02)<\\/p>\\n<ul>\\n<li>Add: The ChatGPT model is finally here! It\'s \\"gpt-3.5-turbo\\" and you can already use it with your chatbots, forms, in the playground, etc. It\'s very new so let me know if you find any issues, in the <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/\\">forums<\\/a>. Set as the new default.<\\/li>\\n<li>Add: Max Length for the Input and TextArea in AI Forms.<\\/li>\\n<li>Update: Many little enhancements here and there.<\\/li>\\n<li>Fix: Minor bug in the AI Playground.<\\/li>\\n<\\/ul>\\n<p>1.1.3 (2023\\/03\\/01)<\\/p>\\n<ul>\\n<li>Fix: UI issues in the Content Generator linked to the framework update.<\\/li>\\n<li>Add: Typewriter effect. I don\'t recommend it, but if you want to play with it, it\'s there :)<\\/li>\\n<li>Add: New filter: mwai_forms_params.<\\/li>\\n<li>Update: Refactoring and minor fixes. Making sure everything is stable and nice.<\\/li>\\n<\\/ul>\\n<p>1.1.1 (2023\\/02\\/28)<\\/p>\\n<ul>\\n<li>Add: New Moderation Module; it\'s beta, check it out and play with it.<\\/li>\\n<li>Update: Big update in my framework.<\\/li>\\n<\\/ul>\\n<p>1.1.0 (2023\\/02\\/26)<\\/p>\\n<ul>\\n<li>Update: Enhanced the whole flow of the chatbot (which also fixed minor issue).<\\/li>\\n<li>Update: Better handling of time in the statistics.<\\/li>\\n<\\/ul>\\n<p>1.0.8 (2023\\/02\\/25)<\\/p>\\n<ul>\\n<li>Add: Filter to takeover the conversation programmatically.<\\/li>\\n<li>Add: Compliance Text and Max Messages.<\\/li>\\n<li>Add: Hyperparams for finetuning.<\\/li>\\n<li>Add: Queries viewer.<\\/li>\\n<\\/ul>\\n<p>1.0.6 (2023\\/02\\/24)<\\/p>\\n<ul>\\n<li>Fixes: There were few issues with my Casually Fine-Tuned system.<\\/li>\\n<li>Add: Option to resolve shortcodes.<\\/li>\\n<\\/ul>\\n<p>1.0.5 (2023\\/02\\/23)<\\/p>\\n<ul>\\n<li>Add: Limit can be applied on a daily-basis.<\\/li>\\n<li>Add: Added ID for AI Submit so that we can hook and customize the advanced params for the AI Forms.<\\/li>\\n<li>Add: Parameters to hide\\/show values in the statistics shortcode.<\\/li>\\n<li>Add: The mwai-clear class has been added to the Clear button.<\\/li>\\n<\\/ul>\\n<p>1.0.3 (2023\\/02\\/22)<\\/p>\\n<ul>\\n<li>Fix: There was an alert popping in the AI Forms.<\\/li>\\n<li>Update: Better handling of user errors in the AI Forms.<\\/li>\\n<li>Update: The ChatGPT theme, if choosen, is applied to AI Forms too.<\\/li>\\n<\\/ul>\\n<p>1.0.1 (2023\\/02\\/21)<\\/p>\\n<ul>\\n<li>Fix: The Form Select wasn\'t working properly.<\\/li>\\n<li>Update: Translation framework.<\\/li>\\n<\\/ul>\\n<p>1.0.0 (2023\\/02\\/20)<\\/p>\\n<ul>\\n<li>Update: Enhance the chabot\'s input field visually.<\\/li>\\n<li>Update: Translation framework.<\\/li>\\n<\\/ul>\\n<p>0.9.99 (2023\\/02\\/19)<\\/p>\\n<ul>\\n<li>Update: Translation framework.<\\/li>\\n<\\/ul>\\n<p>0.9.98 (2023\\/02\\/18)<\\/p>\\n<ul>\\n<li>Fix: There was an exit applied if WP_DEBUG was used.<\\/li>\\n<li>Update: Default max_tokens for forms is now 2048.<\\/li>\\n<li>Add: New \'max_messages\' parameter to limit the number of sentences in the prompt for the chatbot.<\\/li>\\n<li>Add: AI Submit now handles using element based on their ID. Use it like this: {#myid}.<\\/li>\\n<li>Update: Enhance the internal API with better helpers.<\\/li>\\n<\\/ul>\\n<p>0.9.95 (2023\\/02\\/17)<\\/p>\\n<ul>\\n<li>Fix: Minor fixes related to notices and translations.<\\/li>\\n<li>Update: Enhanced Shortcode Builder.<\\/li>\\n<li>Add: UI for Custom Icon, Icon Message.<\\/li>\\n<li>Fix: Better control of the dirty state of the Post Editor.<\\/li>\\n<li>Add: Warn when the AI Forms are not properly set up to avoid issues.<\\/li>\\n<\\/ul>\\n<p>0.9.89 (2023\\/02\\/16)<\\/p>\\n<ul>\\n<li>Fix: Enhancement in the models screen.<\\/li>\\n<li>Fix: Better session control.<\\/li>\\n<li>Add: New placeholders {TITLE} and {URL} for the Q&amp;A Generator module.<\\/li>\\n<li>Update: Avoid an useless warning or two.<\\/li>\\n<\\/ul>\\n<p>0.9.86 (2023\\/02\\/15)<\\/p>\\n<ul>\\n<li>Update: Handle the colors more naturally depending on the CSS variables.<\\/li>\\n<li>Update: Make sure the max tokens are respected and not over-setted.<\\/li>\\n<li>Update: Better handling of max tokens with forms.<\\/li>\\n<li>Add: Enhanced the way the models and managed.<\\/li>\\n<li>Fix: Issues with forms using non-latin characters.<\\/li>\\n<\\/ul>\\n<p>0.9.85 (2023\\/02\\/14)<\\/p>\\n<ul>\\n<li>Fix: Minor issues related to max tokens.<\\/li>\\n<li>Fix: Some issues with forms, now also better layouts, more types, etc.<\\/li>\\n<li>Info: Happy Valentine\'s Day! &#x1f495; I\'ll take a few hours off &#x1f60a;<\\/li>\\n<\\/ul>\\n<p>0.9.84 (2023\\/02\\/13)<\\/p>\\n<ul>\\n<li>Fix: Compile conversations in order to avoid overwhelming the AI.<\\/li>\\n<li>Fix: When over the limits, forms display an alert nicely.<\\/li>\\n<li>Fix: Quick fix for Rank Math.<\\/li>\\n<li>Update: Optimized the way the fields and handled and reset in the Content Generator and the Templates.<\\/li>\\n<li>Add: Support of custom language (or type of language) in the Content Generator.<\\/li>\\n<li>Info: I would like to focus on making everything amazingly perfect for the version 1.x. I keep the new features for a bit later, and make sure everything we have now is stable and nice, as well as the code quality. Please share your feedback in the <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/\\">Support Threads<\\/a>.<\\/li>\\n<li>Info: If you enjoy this, don\'t hesitate to <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/reviews\\/\\">write a review<\\/a> :)<\\/li>\\n<\\/ul>\\n<p>0.9.82 (2023\\/02\\/12)<\\/p>\\n<ul>\\n<li>Add: Chat logs.<\\/li>\\n<li>Update: Cleaning the UI.<\\/li>\\n<li>Update: Refactoring.<\\/li>\\n<\\/ul>\\n<p>0.9.8 (2023\\/02\\/11)<\\/p>\\n<ul>\\n<li>Update: Quite a bit of refactoring.<\\/li>\\n<li>Add: Forms has the ability to work with DALL-E.<\\/li>\\n<li>Add: Position of the popup chatbot is now also in the settings.<\\/li>\\n<\\/ul>\\n<p>0.9.6 (2023\\/02\\/10)<\\/p>\\n<ul>\\n<li>Fix: There was an issue with statistics\\/logging related to the current API Key.<\\/li>\\n<li>Update: Enhanced the shortcode builder to avoid user mistakes.<\\/li>\\n<li>Update: Better sizes for chatbot icons.<\\/li>\\n<li>Update: Markdown support in AI Forms.<\\/li>\\n<li>Update: Dataset Generator allows replaying the bulk generation from a certain offset.<\\/li>\\n<li>Update: Better text validation before quickly generating titles and excerpts.<\\/li>\\n<li>Add: Timer in the chatbot button if the query takes more than 1 second.<\\/li>\\n<\\/ul>\\n<p>0.9.3 (2023\\/02\\/09)<\\/p>\\n<ul>\\n<li>Add: Debug Mode.<\\/li>\\n<li>Fix: There were issues when both limits were set to zero and special conditions were set through a filter.<\\/li>\\n<\\/ul>\\n<p>0.9.0 (2023\\/02\\/08)<\\/p>\\n<ul>\\n<li>Update: Can handle multiple apiKeys for statistics and limits.<\\/li>\\n<li>Update: Enhancements of the AI Forms.<\\/li>\\n<li>Update: Enhancements of Content-Aware, avoid repeated sentences, shorten content, etc.<\\/li>\\n<li>Fix: Some validations work, to avoid issues and hacks.<\\/li>\\n<\\/ul>\\n<p>0.8.8 (2023\\/02\\/07)<\\/p>\\n<ul>\\n<li>Add: New param for the chatbot: guest_name.<\\/li>\\n<li>Update: Better consistency in the UI.<\\/li>\\n<li>Fix: Minor fixes.<\\/li>\\n<li>Fix: There was a little inconsistency with \\"Use Topics as Titles\\".<\\/li>\\n<li>Update: Reviewed the styles - but this still need a lot of improvements.<\\/li>\\n<\\/ul>\\n<p>0.8.5 (2023\\/02\\/06)<\\/p>\\n<ul>\\n<li>Add: Pro Users: Visit the Statistics Tab and check the <a href=\\"https:\\/\\/meowapps.com\\/ai-engine\\/faq\\/\\">FAQ<\\/a>. Lots of fun ahead!<\\/li>\\n<li>Update: You can now enable\\/disable every feature to make the UI yours and for a better UX (that will also allow role-based access to different features).<\\/li>\\n<li>Info 1: Templates are super cool! I\'d be happy if you could join this <a href=\\"https:\\/\\/wordpress.org\\/support\\/topic\\/common-use-cases-for-templates\\/\\">discussion<\\/a> in the WordPress forums.<\\/li>\\n<li>Info 2: Share with me your feedback in the <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/\\">Support Threads<\\/a>, I\'ll make it better for you! And of course, if you like the plugin, please leave a review on <a href=\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/ai-engine\\/reviews\\/\\">WordPress.org<\\/a>. Thank you!<\\/li>\\n<\\/ul>\\n<p>0.8.2 (2023\\/02\\/05)<\\/p>\\n<ul>\\n<li>Update: Enhancements and fixes to the AI Forms + a ChatGPT theme for them.<\\/li>\\n<li>Update: A bit of tidying on the UI, and added warning messages to avoid common mistakes.<\\/li>\\n<li>Add: Words count in Playground and Content Generator.<\\/li>\\n<li>Add: The icon_text parameter to add a text next to the icon of the chatbot.<\\/li>\\n<li>Update: Made the CSS of the chatbot slighlty more specific to avoid being overriden by pagebuilders.<\\/li>\\n<\\/ul>\\n<p>0.7.6 (2023\\/02\\/04)<\\/p>\\n<ul>\\n<li>Fix: The icon of the chatbot was not applied.<\\/li>\\n<li>Update: Better AI Forms.<\\/li>\\n<li>Add: Templates for Content Generator. Templates are now available everywhere I wanted. I\'d be happy if you could join this <a href=\\"https:\\/\\/wordpress.org\\/support\\/topic\\/common-use-cases-for-templates\\/\\">discussion<\\/a> in the WordPress forums.<\\/li>\\n<\\/ul>\\n<p>0.7.2 (2023\\/02\\/03)<\\/p>\\n<ul>\\n<li>Update: \\"casually_fined_tuned\\" is now \\"casually_fine_tuned\\".<\\/li>\\n<li>Fix: Editor also have access to the AI features (but not the Settings). This behavior can be filtered.<\\/li>\\n<li>Add: AI Forms for Pro (extremely beta but it works).<\\/li>\\n<\\/ul>\\n<p>0.6.9 (2023\\/02\\/02)<\\/p>\\n<ul>\\n<li>Fix: The chatbot could potentially be over other clickable elements.<\\/li>\\n<li>Fix: Create Post has an issue in Single Generate mode.<\\/li>\\n<li>Add: The Templates Editor is now available in the Images Generator.<\\/li>\\n<\\/ul>\\n<p>0.6.6 (2023\\/02\\/01)<\\/p>\\n<ul>\\n<li>Add: Templates in the Playground are now editable.<\\/li>\\n<li>Fix: Avoid the content-aware to take too many tokens.<\\/li>\\n<li>Update: Many little enhancements in the UI elements.<\\/li>\\n<li>Update: Handles timeouts better. More and more buttons will display the time elapsed.<\\/li>\\n<\\/ul>\\n<p>0.6.2 (2023\\/01\\/31)<\\/p>\\n<ul>\\n<li>Add: The Post Bulk Generate feature is now working nicely.<\\/li>\\n<li>Fix: Issue with missing file.<\\/li>\\n<li>Add: WooCommerce fields generator for products.<\\/li>\\n<li>Update: More modularity to increase UI tidyness and website\'s performance.<\\/li>\\n<\\/ul>\\n<p>0.5.7 (2023\\/01\\/30)<\\/p>\\n<ul>\\n<li>Update: The chatbot icon is now refered as \\"icon\\" (instead of \\"avatar\\" previously, which was confusing). We have an icon and an icon_position parameters for the chatbot.<\\/li>\\n<li>Fix: Crash while adding rows to the dataset.<\\/li>\\n<li>Add: Placeholders for the user name in the chatbot.<\\/li>\\n<li>Add: URL support for avatars for the user and\\/or the AI.<\\/li>\\n<\\/ul>\\n<p>0.5.4 (2023\\/01\\/29)<\\/p>\\n<ul>\\n<li>Add: Avatar position (avatar_position) can be set to \\"bottom-right\\", \\"top-left\\", etc.<\\/li>\\n<li>Add: You can specify an avatar URL for each chatbot (avatar parameter, in the shortcode).<\\/li>\\n<li>Fix: The expand icon was always displayed for the popup chatbot, even with fullsize set to false.<\\/li>\\n<li>Add: Entries Generator for the Dataset Builder. Use with caution!<\\/li>\\n<\\/ul>\\n<p>0.5.1 (2023\\/01\\/28)<\\/p>\\n<ul>\\n<li>Add: Chatbot avatars.<\\/li>\\n<li>Add: Color for the Header Buttons for the Chatbot Popup Window.<\\/li>\\n<li>Update: Enhanced the UI of the Settings, Chatbot and Content Generator.<\\/li>\\n<li>Update: The ID is now available in the Settings (reminder: ID allows you to set CSS more easily if you do it statically, it also keeps the conversations recorded in the browser between pages).<\\/li>\\n<li>Update: Enhancements relative to prompts, their placeholders, and UI visual adaption based on those.<\\/li>\\n<\\/ul>\\n<p>0.4.8 (2023\\/01\\/27)<\\/p>\\n<ul>\\n<li>Add: If no user_name and ai_name are mentioned, avatars will be used.<\\/li>\\n<li>Add: Status of OpenAI servers (a little warning sign will also be added on the tab if something is wrong).<\\/li>\\n<li>Add: Possibility to modify or remove the error messages through a filter.<\\/li>\\n<\\/ul>\\n<p>0.4.6 (2023\\/01\\/26)<\\/p>\\n<ul>\\n<li>Fixed: Resolved a potential issue with session (used for logging purposes).<\\/li>\\n<li>Fixed: The chatbot was not working properly on iPhones.<\\/li>\\n<\\/ul>\\n<p>0.4.5 (2023\\/01\\/25)<\\/p>\\n<ul>\\n<li>Add: Style the chatbot easily in the Settings.<\\/li>\\n<li>Add: Allow extra models to be added.<\\/li>\\n<li>Fix: Clean the context and the content-aware feature.<\\/li>\\n<\\/ul>\\n<p>0.4.3 (2023\\/01\\/24)<\\/p>\\n<ul>\\n<li>Update: Allow re-train a fined-tuned model.<\\/li>\\n<li>Fix: The session was started too late, potentially causing a warning.<\\/li>\\n<\\/ul>\\n<p>0.4.1 (2023\\/01\\/23)<\\/p>\\n<ul>\\n<li>Update: Better and simpler UI, make it a bit easier overall.<\\/li>\\n<li>Add: Statistics and Content-Aware features for Pro.<\\/li>\\n<li>Update: Make sure that all the AI requests have an \\"env\\" and a logical \\"session\\" associated (for logging purposes).<\\/li>\\n<\\/ul>\\n<p>0.3.5 (2023\\/01\\/22)<\\/p>\\n<ul>\\n<li>Update: Better calculation of the OpenAI \\"Usage\\".<\\/li>\\n<li>Update: Lot of refactoring and code enhancements to allow other AI services to be integrated.<\\/li>\\n<li>Add: Generate based on Topic (Content Generator).<\\/li>\\n<li>Update: Various enhancements in the UI.<\\/li>\\n<\\/ul>\\n<p>0.3.4 (2023\\/01\\/22)<\\/p>\\n<ul>\\n<li>Add: Code enhancements to support many new actions and filters.<\\/li>\\n<li>Add: Added actions and filters to modify the answers, limit the users, etc. More to come soon.<\\/li>\\n<\\/ul>\\n<p>0.3.3 (2023\\/01\\/21)<\\/p>\\n<ul>\\n<li>Add: Languages management (check <a href=\\"https:\\/\\/meowapps.com\\/ai-engine\\/tutorial\\/#add-or-remove-languages\\">https:\\/\\/meowapps.com\\/ai-engine\\/tutorial\\/#add-or-remove-languages<\\/a>).<\\/li>\\n<li>Add: The chatbot can be displayed in fullscreen (use fullscreen=\\"true\\" in the shortcode). It works logically with the window\\/popup mode: no popup? Fullscreen right away! Popup? Fullscreen on click :)<\\/li>\\n<li>Fix: A few potential issues that coult break a few things.<\\/li>\\n<li>Update: Cleaned the JS, CSS and HTML. I like when it\'s very tidy before going forward!<\\/li>\\n<\\/ul>\\n<p>0.2.9 (2023\\/01\\/19)<\\/p>\\n<ul>\\n<li>Fix: Responsive.<\\/li>\\n<li>Add: Shortcode builder for the chatbot. This makes it much easier!<\\/li>\\n<li>Add: Bunch of new options to inject the chatbot everywhere.<\\/li>\\n<li>Add: Syntax highlighting for the code potentially generated by the AI.<\\/li>\\n<li>Add: The chatbot can be displayed as a window\\/popup. Sorry, only one icon for now, but will add more!<\\/li>\\n<li>Add: Bunch of WordPress filters to modify everything and do everything :)<\\/li>\\n<\\/ul>\\n<p>0.2.6 (2023\\/01\\/18)<\\/p>\\n<ul>\\n<li>Update: Little UI enhancements and fixes.<\\/li>\\n<li>Add: \\"max_tokens\\" parameter for the chatbot shortcode.<\\/li>\\n<li>Add: \\"casually_fine_tuned\\" parameter for the chatbot shorcode (for fine-tuned models).<\\/li>\\n<\\/ul>\\n<p>0.2.4 (2023\\/01\\/17)<\\/p>\\n<ul>\\n<li>Update: Perfected the fine-tuning module (UI and features).<\\/li>\\n<li>Update: A few UI fixes but a lot more to come.<\\/li>\\n<\\/ul>\\n<p>0.2.3 (2023\\/01\\/16)<\\/p>\\n<ul>\\n<li>Add: Module to train your own AI model (visit the Settings &gt; Fine Tuning). My user interface makes it look easy, but creating datasets and training models is not easy. Let\'s go through this together and I\'ll enhance AI Engine to make it easier.<\\/li>\\n<li>Update: Possible to add new lines in the requests to the chatbot.<\\/li>\\n<\\/ul>\\n<p>0.2.2 (2023\\/01\\/13)<\\/p>\\n<ul>\\n<li>Add: Shortcode that creates an images generator bot.<\\/li>\\n<li>Fix: Bots are now responsive.<\\/li>\\n<li>Add: Button and placeholder of the bots can be translated.<\\/li>\\n<\\/ul>\\n<p>0.2.1 (2023\\/01\\/12)<\\/p>\\n<ul>\\n<li>Add: Images Generator! After getting your feedback, I will implement this Image Generator in a modal in the Post Editor.<\\/li>\\n<\\/ul>\\n<p>0.1.9 (2023\\/01\\/09)<\\/p>\\n<ul>\\n<li>Add: Many improvements to the chatbot! By default, it now uses ChatGPT style, and it also support replies from the AI using Markdown (and will convert it properly into HTML). Basically, you can have properly displayed code and better formatting in the chat!<\\/li>\\n<\\/ul>\\n<p>0.1.7 (2023\\/01\\/08)<\\/p>\\n<ul>\\n<li>Add: Handle the errors better in the UI.<\\/li>\\n<li>Add: The chatbot can be styled a bit more easily.<\\/li>\\n<\\/ul>\\n<p>0.1.6 (2023\\/01\\/07)<\\/p>\\n<ul>\\n<li>Fix: The timeout was 5s, which was too short for some requests. It\'s now 60s.<\\/li>\\n<\\/ul>\\n<p>0.1.5 (2023\\/01\\/06)<\\/p>\\n<ul>\\n<li>Add: New \'api_key\' parameter for the shortcode. The API Key can now be filtered, added through the shortcode, the filters, depending on your conditions.<\\/li>\\n<li>Fix: Better handling of errors.<\\/li>\\n<\\/ul>\\n<p>0.1.4 (2023\\/01\\/05)<\\/p>\\n<ul>\\n<li>Update: Sorry, the name of the parameters in the chatbot were confusing. I\'ve changed them to make it more clear.<\\/li>\\n<li>Add: New filter, and the possibility to add some CSS to the chatbot, directly through coding. Have a look on <a href=\\"https:\\/\\/meowapps.com\\/ai-engine\\/\\">https:\\/\\/meowapps.com\\/ai-engine\\/<\\/a>.<\\/li>\\n<\\/ul>\\n<p>0.1.0 (2023\\/01\\/01)<\\/p>\\n<ul>\\n<li>Fix: A few fixes in the playground.<\\/li>\\n<li>Add: Content Generator (available under Tools and Posts).<\\/li>\\n<\\/ul>\\n<p>0.0.7 (2022\\/12\\/30)<\\/p>\\n<ul>\\n<li>Fix: Little issue in the playground.<\\/li>\\n<li>Add: Model and temperature in the playground.<\\/li>\\n<li>Updated: Improved the chatbot, with more parameters (temperature, model), and a better layout (HTML only).<\\/li>\\n<\\/ul>\\n<p>0.0.3 (2022\\/12\\/29)<\\/p>\\n<ul>\\n<li>Add: Lightweight chatbot (beta).<\\/li>\\n<li>Fix: Missing icon.<\\/li>\\n<\\/ul>\\n<p>0.0.1 (2022\\/12\\/27)<\\/p>\\n<ul>\\n<li>First release.<\\/li>\\n<\\/ul>\\n"],"plugin":"ai-engine-pro\\/ai-engine-pro.php","id":"ai-engine-pro\\/ai-engine-pro.php"}";}','no');
INSERT INTO `wp_options` VALUES (207,'app_pos_premium','apple#paypal#wordpress#github#hubspot#mailru#gitlab#steam#slack#trello#disqus#pinterest#yandex#spotify#reddit#tumblr#twitch#vimeo#kakao#flickr#line#meetup#dropbox#stackexchange#livejournal#foursquare#teamsnap#naver#odnoklassniki#wiebo#wechat#baidu#renren#qq#fitbit#stackoverflow#mailchimp#youtube#strava#zoom','yes');
INSERT INTO `wp_options` VALUES (12837,'mwai_themes','a:2:{i:0;a:5:{s:4:"type";s:8:"internal";s:4:"name";s:7:"ChatGPT";s:7:"themeId";s:7:"chatgpt";s:8:"settings";a:1:{s:8:"fontSize";s:4:"17px";}s:5:"style";s:0:"";}i:1;a:5:{s:4:"type";s:8:"internal";s:4:"name";s:8:"Messages";s:7:"themeId";s:8:"messages";s:8:"settings";a:1:{s:8:"fontSize";s:4:"17px";}s:5:"style";s:0:"";}}','yes');
INSERT INTO `wp_options` VALUES (18772,'auto_core_update_notified','a:4:{s:4:"type";s:7:"success";s:5:"email";s:23:"noemail@noemail.noemail";s:7:"version";s:5:"6.8.3";s:9:"timestamp";i:1759283262;}','off');
INSERT INTO `wp_options` VALUES (21040,'wp-piwik_global-require_consent','disabled','yes');
INSERT INTO `wp_options` VALUES (30275,'hide_wp_admin','off','yes');
INSERT INTO `wp_options` VALUES (30276,'hide_wp_login','off','yes');
INSERT INTO `wp_options` VALUES (30277,'hide_remember_me','off','yes');
INSERT INTO `wp_options` VALUES (30278,'hide_login_fields','off','yes');
INSERT INTO `wp_options` VALUES (30279,'hide_lost_password','off','yes');
INSERT INTO `wp_options` VALUES (30280,'isAddCustomizeCssEnabled','off','yes');
INSERT INTO `wp_options` VALUES (30281,'addCustomizeCssText','','yes');
INSERT INTO `wp_options` VALUES (30282,'isCustomizeBtnNameEnable','on','yes');
INSERT INTO `wp_options` VALUES (30283,'addCustomizeBtnName','FEIDE','yes');
INSERT INTO `wp_options` VALUES (30368,'oc_enableDefaultRole','','yes');
INSERT INTO `wp_options` VALUES (30369,'oc_defaultRoleSelected','subscriber','yes');
INSERT INTO `wp_options` VALUES (30397,'login_customizer_options','a:26:{i:0;s:14:"logincust_logo";i:1;s:20:"logincust_logo_width";i:2;s:21:"logincust_logo_height";i:3;s:22:"logincust_logo_padding";i:4;s:18:"logincust_bg_image";i:5;s:18:"logincust_bg_color";i:6;s:17:"logincust_bg_size";i:7;s:23:"logincust_form_bg_image";i:8;s:23:"logincust_form_bg_color";i:9;s:20:"logincust_form_width";i:10;s:21:"logincust_form_height";i:11;s:22:"logincust_form_padding";i:12;s:21:"logincust_field_width";i:13;s:22:"logincust_field_margin";i:14;s:18:"logincust_field_bg";i:15;s:21:"logincust_field_color";i:16;s:21:"logincust_field_label";i:17;s:19:"logincust_button_bg";i:18;s:23:"logincust_button_border";i:19;s:23:"logincust_button_shadow";i:20;s:22:"logincust_button_color";i:21;s:25:"logincust_button_hover_bg";i:22;s:29:"logincust_button_hover_border";i:23;s:21:"logincust_other_color";i:24;s:27:"logincust_other_color_hover";i:25;s:19:"logincust_other_css";}','yes');
INSERT INTO `wp_options` VALUES (30398,'login_customizer_settings','a:2:{s:4:"page";i:680;s:7:"version";s:5:"2.2.0";}','yes');
INSERT INTO `wp_options` VALUES (30401,'logincust_setting','','yes');
INSERT INTO `wp_options` VALUES (30402,'logincustomizer_active_time','1686299181','no');
INSERT INTO `wp_options` VALUES (32087,'widget_theme-my-login','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (32088,'_tml_installed_at','1686612768','no');
INSERT INTO `wp_options` VALUES (32089,'_tml_updated_at','1686612768','no');
INSERT INTO `wp_options` VALUES (32090,'_tml_version','7.1.5','no');
INSERT INTO `wp_options` VALUES (32093,'tml_ajax','','yes');
INSERT INTO `wp_options` VALUES (32094,'tml_login_type','default','yes');
INSERT INTO `wp_options` VALUES (32095,'tml_registration_type','default','yes');
INSERT INTO `wp_options` VALUES (32096,'tml_user_passwords','','yes');
INSERT INTO `wp_options` VALUES (32097,'tml_auto_login','','yes');
INSERT INTO `wp_options` VALUES (32098,'tml_dashboard_slug','dashboard','yes');
INSERT INTO `wp_options` VALUES (32099,'tml_login_slug','login','yes');
INSERT INTO `wp_options` VALUES (32100,'tml_logout_slug','logout','yes');
INSERT INTO `wp_options` VALUES (32101,'tml_register_slug','register','yes');
INSERT INTO `wp_options` VALUES (32102,'tml_lostpassword_slug','lostpassword','yes');
INSERT INTO `wp_options` VALUES (32103,'tml_resetpass_slug','resetpass','yes');
INSERT INTO `wp_options` VALUES (39723,'ihaf_activated','a:2:{s:6:"wpcode";i:1688399938;s:7:"version";s:7:"2.1.3.1";}','yes');
INSERT INTO `wp_options` VALUES (39724,'wpcode_snippets','a:3:{s:15:"after_paragraph";a:0:{}s:16:"site_wide_header";a:0:{}s:10:"everywhere";a:0:{}}','yes');
INSERT INTO `wp_options` VALUES (39725,'wpcode_admin_notices','a:2:{s:14:"review_request";a:2:{s:4:"time";i:1688399938;s:9:"dismissed";b:0;}s:27:"wpcode-library-connect-lite";a:2:{s:4:"time";i:1688400029;s:9:"dismissed";b:1;}}','yes');
INSERT INTO `wp_options` VALUES (39728,'_transient_wpcode_used_library_snippets','a:1:{i:12;i:717;}','yes');
INSERT INTO `wp_options` VALUES (60758,'db_upgraded','','on');
INSERT INTO `wp_options` VALUES (64057,'wordfence_version','7.10.3','yes');
INSERT INTO `wp_options` VALUES (64058,'wordfence_case','1','yes');
INSERT INTO `wp_options` VALUES (64059,'wordfenceActivated','0','yes');
INSERT INTO `wp_options` VALUES (86481,'wpvivid_remote_init','init','no');
INSERT INTO `wp_options` VALUES (86483,'wpvivid_check_htaccess_rule_free','1','yes');
INSERT INTO `wp_options` VALUES (86489,'clean_task','a:1:{i:0;b:0;}','off');
INSERT INTO `wp_options` VALUES (86526,'default_comment_status','','yes');
INSERT INTO `wp_options` VALUES (86578,'password_protected_version','2.7.1','yes');
INSERT INTO `wp_options` VALUES (86579,'_site_transient_timeout_fs_locked_1','2009642877','no');
INSERT INTO `wp_options` VALUES (86580,'_site_transient_fs_locked_1','1','no');
INSERT INTO `wp_options` VALUES (86582,'password_protected_status','1','yes');
INSERT INTO `wp_options` VALUES (86583,'password_protected_feeds','0','yes');
INSERT INTO `wp_options` VALUES (86584,'password_protected_rest','0','yes');
INSERT INTO `wp_options` VALUES (86585,'password_protected_administrators','1','yes');
INSERT INTO `wp_options` VALUES (86586,'password_protected_users','0','yes');
INSERT INTO `wp_options` VALUES (86587,'password_protected_password','1ef3b67001f3075bf20d9ed6a6714b07','yes');
INSERT INTO `wp_options` VALUES (86588,'password_protected_allowed_ip_addresses','','yes');
INSERT INTO `wp_options` VALUES (86589,'password_protected_remember_me','1','yes');
INSERT INTO `wp_options` VALUES (86590,'password_protected_remember_me_lifetime','14','yes');
INSERT INTO `wp_options` VALUES (86593,'password_protected_use_transient','','yes');
INSERT INTO `wp_options` VALUES (86594,'password_protected_text_above_password','Hei! Noen må gi deg passordet!','yes');
INSERT INTO `wp_options` VALUES (86595,'password_protected_text_below_password','','yes');
INSERT INTO `wp_options` VALUES (86596,'password_protected_recaptcha','a:8:{s:7:"version";s:19:"google_recaptcha_v2";s:11:"v2_site_key";s:0:"";s:11:"v3_site_key";s:0:"";s:13:"v2_secret_key";s:0:"";s:13:"v3_secret_key";s:0:"";s:8:"v3_score";s:3:"0.3";s:8:"v3_badge";s:11:"bottomright";s:8:"v2_theme";s:5:"light";}','yes');
INSERT INTO `wp_options` VALUES (86737,'fs_clone_management','a:2:{s:30:"clone_identification_timestamp";i:1694532520;s:22:"hide_manual_resolution";b:0;}','yes');
INSERT INTO `wp_options` VALUES (87068,'site_logo','1394','yes');
INSERT INTO `wp_options` VALUES (87573,'wpvivid_backup_success_count','23','off');
INSERT INTO `wp_options` VALUES (87574,'wpvivid_backup_reports','a:23:{s:21:"wpvivid-653796b1f3cc8";a:3:{s:7:"task_id";s:21:"wpvivid-653796b1f3cc8";s:11:"backup_time";i:1698141874;s:6:"status";s:34:"The last backup message not found.";}s:21:"wpvivid-654cd6ffe310f";a:3:{s:7:"task_id";s:21:"wpvivid-654cd6ffe310f";s:11:"backup_time";i:1699534592;s:6:"status";s:34:"The last backup message not found.";}s:21:"wpvivid-6552bf0d6075c";a:3:{s:7:"task_id";s:21:"wpvivid-6552bf0d6075c";s:11:"backup_time";i:1699921677;s:6:"status";s:34:"The last backup message not found.";}s:21:"wpvivid-6554665e5d625";a:3:{s:7:"task_id";s:21:"wpvivid-6554665e5d625";s:11:"backup_time";i:1700030046;s:6:"status";s:34:"The last backup message not found.";}s:21:"wpvivid-6568d98cb3766";a:3:{s:7:"task_id";s:21:"wpvivid-6568d98cb3766";s:11:"backup_time";i:1701370252;s:6:"status";s:34:"The last backup message not found.";}s:21:"wpvivid-65690162b69ee";a:3:{s:7:"task_id";s:21:"wpvivid-65690162b69ee";s:11:"backup_time";i:1701380450;s:6:"status";s:34:"The last backup message not found.";}s:21:"wpvivid-65698ed394f22";a:3:{s:7:"task_id";s:21:"wpvivid-65698ed394f22";s:11:"backup_time";i:1701416659;s:6:"status";s:34:"The last backup message not found.";}s:21:"wpvivid-6571a5a413119";a:3:{s:7:"task_id";s:21:"wpvivid-6571a5a413119";s:11:"backup_time";i:1701946788;s:6:"status";s:34:"The last backup message not found.";}s:21:"wpvivid-6580386e44915";a:3:{s:7:"task_id";s:21:"wpvivid-6580386e44915";s:11:"backup_time";i:1702901870;s:6:"status";s:34:"The last backup message not found.";}s:21:"wpvivid-65bf7c98b0cbd";a:3:{s:7:"task_id";s:21:"wpvivid-65bf7c98b0cbd";s:11:"backup_time";i:1707048088;s:6:"status";s:34:"The last backup message not found.";}s:21:"wpvivid-65bf7d4437264";a:3:{s:7:"task_id";s:21:"wpvivid-65bf7d4437264";s:11:"backup_time";i:1707048260;s:6:"status";s:34:"The last backup message not found.";}s:21:"wpvivid-6606e1b5c3025";a:3:{s:7:"task_id";s:21:"wpvivid-6606e1b5c3025";s:11:"backup_time";i:1711727029;s:6:"status";s:34:"The last backup message not found.";}s:21:"wpvivid-663fa6fa09845";a:3:{s:7:"task_id";s:21:"wpvivid-663fa6fa09845";s:11:"backup_time";i:1715447546;s:6:"status";s:34:"The last backup message not found.";}s:21:"wpvivid-66696ea3dae09";a:3:{s:7:"task_id";s:21:"wpvivid-66696ea3dae09";s:11:"backup_time";i:1718185635;s:6:"status";s:34:"The last backup message not found.";}s:21:"wpvivid-66c20cb4a6645";a:3:{s:7:"task_id";s:21:"wpvivid-66c20cb4a6645";s:11:"backup_time";i:1723993268;s:6:"status";s:34:"The last backup message not found.";}s:21:"wpvivid-9be8b35747315";a:3:{s:7:"task_id";s:21:"wpvivid-9be8b35747315";s:11:"backup_time";i:1726815242;s:6:"status";s:34:"The last backup message not found.";}s:21:"wpvivid-859501c89e9ac";a:3:{s:7:"task_id";s:21:"wpvivid-859501c89e9ac";s:11:"backup_time";i:1727778552;s:6:"status";s:34:"The last backup message not found.";}s:21:"wpvivid-87170d7735be8";a:3:{s:7:"task_id";s:21:"wpvivid-87170d7735be8";s:11:"backup_time";i:1731972235;s:6:"status";s:34:"The last backup message not found.";}s:21:"wpvivid-9734db96071ff";a:3:{s:7:"task_id";s:21:"wpvivid-9734db96071ff";s:11:"backup_time";i:1731972922;s:6:"status";s:34:"The last backup message not found.";}s:21:"wpvivid-b41e2e7a8a627";a:3:{s:7:"task_id";s:21:"wpvivid-b41e2e7a8a627";s:11:"backup_time";i:1738770667;s:6:"status";s:34:"The last backup message not found.";}s:21:"wpvivid-6ade06b58cdad";a:3:{s:7:"task_id";s:21:"wpvivid-6ade06b58cdad";s:11:"backup_time";i:1742470344;s:6:"status";s:34:"The last backup message not found.";}s:21:"wpvivid-fe2c80391cbed";a:3:{s:7:"task_id";s:21:"wpvivid-fe2c80391cbed";s:11:"backup_time";i:1748863899;s:6:"status";s:34:"The last backup message not found.";}s:21:"wpvivid-92a0b60a1a858";a:3:{s:7:"task_id";s:21:"wpvivid-92a0b60a1a858";s:11:"backup_time";i:1749456081;s:6:"status";s:34:"The last backup message not found.";}}','off');
INSERT INTO `wp_options` VALUES (87815,'wp_attachment_pages_enabled','1','yes');
INSERT INTO `wp_options` VALUES (87881,'new_admin_email','noemail@noemail.noemail','yes');
INSERT INTO `wp_options` VALUES (87981,'png_to_jpg_settings','a:1:{s:7:"general";a:5:{s:11:"jpg_quality";i:90;s:14:"upload_convert";i:0;s:10:"only_lower";s:7:"checked";s:10:"autodetect";s:7:"checked";s:15:"images_per_page";i:-1;}}','yes');
INSERT INTO `wp_options` VALUES (88483,'wp-phpmyadmin-extension','a:23:{s:16:"randomCookieName";s:20:"pma_675UXIofHcbVzDkh";s:17:"randomCookieValue";s:20:"pma_gevfciTowDAsCq9J";s:18:"RandomFolderSuffix";s:24:"_ZeQj3uONlXi4c8Bo9RCqKFT";s:20:"manual_pma_login_url";s:0:"";s:10:"require_ip";b:1;s:16:"hide_phma_errors";b:0;s:13:"strip_slashes";b:1;s:9:"use_https";b:0;s:12:"is_localhost";b:0;s:15:"has_pro_version";i:0;s:9:"show_opts";b:1;s:19:"show_rating_message";b:1;s:20:"show_donation_footer";b:1;s:19:"show_donation_popup";b:1;s:10:"menu_pages";a:1:{s:5:"first";a:7:{s:5:"title";s:13:"WP-phpMyAdmin";s:15:"default_managed";s:7:"network";s:13:"required_role";s:15:"install_plugins";s:5:"level";s:8:"mainmenu";s:4:"icon";s:88:"https://ki.zork.no/wp-content/plugins/wp-phpmyadmin-extension/assets/media/menu_icon.png";s:10:"page_title";s:26:"WP phpMyAdmin Options page";s:4:"tabs";a:0:{}}}s:4:"name";s:13:"WP phpMyAdmin";s:5:"title";s:109:"<a href="https://puvox.software/software/wordpress-plugins/?plugin=wp-phpmyadmin-extension">WP phpMyAdmin</a>";s:7:"version";s:8:"5.2.1.12";s:18:"first_install_date";i:1701379900;s:16:"last_update_time";i:1701379900;s:12:"last_updates";a:0:{}s:12:"last_version";s:8:"5.2.1.12";s:15:"ssl_error_shown";i:1;}','no');
INSERT INTO `wp_options` VALUES (88484,'wp-phpmyadmin-extension_transl_lastvers','5.2.1.12','no');
INSERT INTO `wp_options` VALUES (88658,'mwai_options','a:73:{s:6:"addons";a:10:{i:0;a:7:{s:4:"slug";s:18:"mwai-notifications";s:4:"name";s:13:"Notifications";s:11:"description";s:95:"Get real-time alerts for new discussions in your chatbot, so you never miss a chance to engage.";s:11:"install_url";s:49:"https://meowapps.com/products/mwai-notifications/";s:12:"settings_url";N;s:5:"stars";i:4;s:7:"enabled";b:0;}i:1;a:7:{s:4:"slug";s:11:"mwai-ollama";s:4:"name";s:6:"Ollama";s:11:"description";s:114:"Leverage local LLM integration through Ollama; refresh and use your own models for a flexible, cost-free approach.";s:11:"install_url";s:42:"https://meowapps.com/products/mwai-ollama/";s:12:"settings_url";N;s:5:"stars";i:3;s:7:"enabled";b:0;}i:2;a:7:{s:4:"slug";s:13:"mwai-deepseek";s:4:"name";s:8:"DeepSeek";s:11:"description";s:87:"Support for DeepSeek, a Chinese AI company that provides extremely powerful LLM models.";s:11:"install_url";s:39:"https://meowapps.com/products/deepseek/";s:12:"settings_url";N;s:5:"stars";i:3;s:7:"enabled";b:0;}i:3;a:7:{s:4:"slug";s:14:"mwai-websearch";s:4:"name";s:10:"Web Search";s:11:"description";s:102:"Enhance chatbot responses by pulling context from Google and Tavily, delivering more accurate answers.";s:11:"install_url";s:45:"https://meowapps.com/products/mwai-websearch/";s:12:"settings_url";N;s:5:"stars";i:5;s:7:"enabled";b:0;}i:4;a:7:{s:4:"slug";s:17:"mwai-better-links";s:4:"name";s:12:"Better Links";s:11:"description";s:120:"Validate internal and external links and map specific terms to custom URLs, ensuring smoother navigation and references.";s:11:"install_url";s:48:"https://meowapps.com/products/mwai-better-links/";s:12:"settings_url";N;s:5:"stars";i:3;s:7:"enabled";b:0;}i:5;a:7:{s:4:"slug";s:15:"mwai-woo-basics";s:4:"name";s:10:"Woo Basics";s:11:"description";s:125:"Access essential WooCommerce data so your chatbot can understand products, orders, and more for a richer shopping experience.";s:11:"install_url";s:46:"https://meowapps.com/products/mwai-woo-basics/";s:12:"settings_url";N;s:5:"stars";i:2;s:7:"enabled";b:0;}i:6;a:7:{s:4:"slug";s:18:"mwai-quick-actions";s:4:"name";s:13:"Quick Actions";s:11:"description";s:102:"Enable dynamic quick actions at chat start or during events, helping users find what they need faster.";s:11:"install_url";s:49:"https://meowapps.com/products/mwai-quick-actions/";s:12:"settings_url";N;s:5:"stars";i:3;s:7:"enabled";b:0;}i:7;a:7:{s:4:"slug";s:19:"mwai-content-parser";s:4:"name";s:14:"Content Parser";s:11:"description";s:123:"Parse complex website content, including ACF fields and page builders, for more precise embeddings and knowledge retrieval.";s:11:"install_url";s:50:"https://meowapps.com/products/mwai-content-parser/";s:12:"settings_url";N;s:5:"stars";i:2;s:7:"enabled";b:0;}i:8;a:7:{s:4:"slug";s:17:"mwai-visitor-form";s:4:"name";s:12:"Visitor Form";s:11:"description";s:115:"Add a customizable form triggered by specific events in your chatbot to collect key visitor information seamlessly.";s:11:"install_url";s:48:"https://meowapps.com/products/mwai-visitor-form/";s:12:"settings_url";N;s:5:"stars";i:2;s:7:"enabled";b:0;}i:9;a:7:{s:4:"slug";s:17:"mwai-dynamic-keys";s:4:"name";s:12:"Dynamic Keys";s:11:"description";s:106:"Rotate multiple API keys dynamically for any environment, balancing usage and ensuring smooth performance.";s:11:"install_url";s:48:"https://meowapps.com/products/mwai-dynamic-keys/";s:12:"settings_url";N;s:5:"stars";i:1;s:7:"enabled";b:0;}}s:20:"ai_audio_default_env";s:8:"93cc0ve0";s:22:"ai_audio_default_model";s:9:"whisper-1";s:14:"ai_default_env";s:8:"93cc0ve0";s:16:"ai_default_model";s:11:"gpt-4o-mini";s:25:"ai_embeddings_default_env";s:8:"93cc0ve0";s:27:"ai_embeddings_default_model";s:22:"text-embedding-ada-002";s:10:"ai_engines";a:8:{i:0;a:5:{s:4:"name";s:6:"OpenAI";s:4:"type";s:6:"openai";s:6:"inputs";a:2:{i:0;s:6:"apikey";i:1;s:14:"organizationId";}s:8:"internal";b:1;s:6:"models";a:22:{i:0;a:11:{s:5:"model";s:7:"gpt-4.1";s:4:"name";s:7:"GPT-4.1";s:6:"family";s:5:"gpt41";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:2:{s:2:"in";i:2;s:3:"out";i:8;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:32768;s:19:"maxContextualTokens";i:1047576;s:8:"finetune";b:0;s:4:"tags";a:6:{i:0;s:4:"core";i:1;s:4:"chat";i:2;s:6:"vision";i:3;s:9:"functions";i:4;s:4:"json";i:5;s:8:"finetune";}}i:1;a:11:{s:5:"model";s:12:"gpt-4.1-mini";s:4:"name";s:12:"GPT-4.1 Mini";s:6:"family";s:5:"gpt41";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:2:{s:2:"in";d:0.4;s:3:"out";d:1.6;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:32768;s:19:"maxContextualTokens";i:1047576;s:8:"finetune";b:0;s:4:"tags";a:6:{i:0;s:4:"core";i:1;s:4:"chat";i:2;s:6:"vision";i:3;s:9:"functions";i:4;s:4:"json";i:5;s:8:"finetune";}}i:2;a:11:{s:5:"model";s:12:"gpt-4.1-nano";s:4:"name";s:12:"GPT-4.1 Nano";s:6:"family";s:5:"gpt41";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:2:{s:2:"in";d:0.1;s:3:"out";d:0.4;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:32768;s:19:"maxContextualTokens";i:1047576;s:8:"finetune";b:0;s:4:"tags";a:6:{i:0;s:4:"core";i:1;s:4:"chat";i:2;s:6:"vision";i:3;s:9:"functions";i:4;s:4:"json";i:5;s:8:"finetune";}}i:3;a:11:{s:5:"model";s:6:"gpt-4o";s:4:"name";s:6:"GPT-4o";s:6:"family";s:4:"gpt4";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:2:{s:2:"in";d:2.5;s:3:"out";i:10;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:16384;s:19:"maxContextualTokens";i:128000;s:8:"finetune";b:0;s:4:"tags";a:6:{i:0;s:4:"core";i:1;s:4:"chat";i:2;s:6:"vision";i:3;s:9:"functions";i:4;s:4:"json";i:5;s:8:"finetune";}}i:4;a:11:{s:5:"model";s:11:"gpt-4o-mini";s:4:"name";s:11:"GPT-4o Mini";s:6:"family";s:4:"gpt4";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:2:{s:2:"in";d:0.15;s:3:"out";d:0.6;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:16384;s:19:"maxContextualTokens";i:128000;s:8:"finetune";a:3:{s:2:"in";d:0.15;s:3:"out";d:0.6;s:5:"train";i:3;}s:4:"tags";a:6:{i:0;s:4:"core";i:1;s:4:"chat";i:2;s:6:"vision";i:3;s:9:"functions";i:4;s:4:"json";i:5;s:8:"finetune";}}i:5;a:10:{s:5:"model";s:2:"o1";s:4:"name";s:2:"o1";s:6:"family";s:2:"o1";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:2:{s:2:"in";i:15;s:3:"out";i:60;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:100000;s:19:"maxContextualTokens";i:200000;s:4:"tags";a:4:{i:0;s:4:"core";i:1;s:4:"chat";i:2;s:8:"o1-model";i:3;s:9:"reasoning";}}i:6;a:10:{s:5:"model";s:7:"o1-mini";s:4:"name";s:7:"o1 Mini";s:6:"family";s:2:"o1";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:2:{s:2:"in";d:1.1;s:3:"out";d:4.4;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:65536;s:19:"maxContextualTokens";i:128000;s:4:"tags";a:4:{i:0;s:4:"core";i:1;s:4:"chat";i:2;s:8:"o1-model";i:3;s:9:"reasoning";}}i:7;a:10:{s:5:"model";s:7:"o3-mini";s:4:"name";s:7:"o3 Mini";s:6:"family";s:2:"o3";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:2:{s:2:"in";d:1.1;s:3:"out";d:4.4;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:100000;s:19:"maxContextualTokens";i:200000;s:4:"tags";a:4:{i:0;s:4:"core";i:1;s:4:"chat";i:2;s:8:"o1-model";i:3;s:9:"reasoning";}}i:8;a:11:{s:5:"model";s:23:"gpt-4o-realtime-preview";s:4:"name";s:25:"GPT-4o Realtime (Preview)";s:6:"family";s:15:"gpt4-o-realtime";s:8:"features";a:3:{i:0;s:4:"core";i:1;s:8:"realtime";i:2;s:9:"functions";}s:5:"price";a:2:{s:4:"text";a:3:{s:2:"in";i:5;s:5:"cache";d:2.5;s:3:"out";i:20;}s:5:"audio";a:3:{s:2:"in";i:100;s:5:"cache";i:20;s:3:"out";i:200;}}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:4096;s:19:"maxContextualTokens";i:128000;s:8:"finetune";b:0;s:4:"tags";a:3:{i:0;s:4:"core";i:1;s:8:"realtime";i:2;s:9:"functions";}}i:9;a:11:{s:5:"model";s:28:"gpt-4o-mini-realtime-preview";s:4:"name";s:30:"GPT-4o Mini Realtime (Preview)";s:6:"family";s:15:"gpt4-o-realtime";s:8:"features";a:3:{i:0;s:4:"core";i:1;s:8:"realtime";i:2;s:9:"functions";}s:5:"price";a:2:{s:4:"text";a:3:{s:2:"in";d:0.6;s:5:"cache";d:0.3;s:3:"out";d:2.4;}s:5:"audio";a:3:{s:2:"in";i:10;s:5:"cache";d:0.3;s:3:"out";i:20;}}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:4096;s:19:"maxContextualTokens";i:128000;s:8:"finetune";b:0;s:4:"tags";a:3:{i:0;s:4:"core";i:1;s:8:"realtime";i:2;s:9:"functions";}}i:10;a:11:{s:5:"model";s:5:"gpt-4";s:4:"name";s:5:"GPT-4";s:6:"family";s:4:"gpt4";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:2:{s:2:"in";i:30;s:3:"out";i:60;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:8192;s:19:"maxContextualTokens";i:8192;s:8:"finetune";b:0;s:4:"tags";a:3:{i:0;s:4:"core";i:1;s:4:"chat";i:2;s:9:"functions";}}i:11;a:11:{s:5:"model";s:11:"gpt-4-turbo";s:4:"name";s:11:"GPT-4 Turbo";s:6:"family";s:4:"gpt4";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:2:{s:2:"in";i:10;s:3:"out";i:30;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:4096;s:19:"maxContextualTokens";i:128000;s:8:"finetune";b:0;s:4:"tags";a:5:{i:0;s:4:"core";i:1;s:4:"chat";i:2;s:6:"vision";i:3;s:9:"functions";i:4;s:4:"json";}}i:12;a:11:{s:5:"model";s:13:"gpt-3.5-turbo";s:4:"name";s:13:"GPT-3.5 Turbo";s:6:"family";s:5:"turbo";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:2:{s:2:"in";d:0.5;s:3:"out";d:1.5;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:4096;s:19:"maxContextualTokens";i:16385;s:8:"finetune";a:3:{s:2:"in";i:3;s:3:"out";i:6;s:5:"train";i:8;}s:4:"tags";a:5:{i:0;s:4:"core";i:1;s:4:"chat";i:2;s:2:"4k";i:3;s:8:"finetune";i:4;s:9:"functions";}}i:13;a:9:{s:5:"model";s:11:"gpt-image-1";s:4:"name";s:18:"GPT Image 1 (High)";s:6:"family";s:9:"gpt-image";s:8:"features";a:1:{i:0;s:13:"text-to-image";}s:11:"resolutions";a:3:{i:0;a:3:{s:4:"name";s:9:"1024x1024";s:5:"label";s:9:"1024x1024";s:5:"price";d:0.167;}i:1;a:3:{s:4:"name";s:9:"1024x1536";s:5:"label";s:9:"1024x1536";s:5:"price";d:0.25;}i:2;a:3:{s:4:"name";s:9:"1536x1024";s:5:"label";s:9:"1536x1024";s:5:"price";d:0.25;}}s:4:"type";s:5:"image";s:4:"unit";i:1;s:8:"finetune";b:0;s:4:"tags";a:3:{i:0;s:4:"core";i:1;s:5:"image";i:2;s:10:"image-edit";}}i:14;a:9:{s:5:"model";s:8:"dall-e-3";s:4:"name";s:8:"DALL-E 3";s:6:"family";s:6:"dall-e";s:8:"features";a:1:{i:0;s:13:"text-to-image";}s:11:"resolutions";a:3:{i:0;a:3:{s:4:"name";s:9:"1024x1024";s:5:"label";s:9:"1024x1024";s:5:"price";d:0.04;}i:1;a:3:{s:4:"name";s:9:"1024x1792";s:5:"label";s:9:"1024x1792";s:5:"price";d:0.08;}i:2;a:3:{s:4:"name";s:9:"1792x1024";s:5:"label";s:9:"1792x1024";s:5:"price";d:0.08;}}s:4:"type";s:5:"image";s:4:"unit";i:1;s:8:"finetune";b:0;s:4:"tags";a:2:{i:0;s:4:"core";i:1;s:5:"image";}}i:15;a:9:{s:5:"model";s:11:"dall-e-3-hd";s:4:"name";s:13:"DALL-E 3 (HD)";s:6:"family";s:6:"dall-e";s:8:"features";a:1:{i:0;s:13:"text-to-image";}s:11:"resolutions";a:3:{i:0;a:3:{s:4:"name";s:9:"1024x1024";s:5:"label";s:9:"1024x1024";s:5:"price";d:0.08;}i:1;a:3:{s:4:"name";s:9:"1024x1792";s:5:"label";s:9:"1024x1792";s:5:"price";d:0.12;}i:2;a:3:{s:4:"name";s:9:"1792x1024";s:5:"label";s:9:"1792x1024";s:5:"price";d:0.12;}}s:4:"type";s:5:"image";s:4:"unit";i:1;s:8:"finetune";b:0;s:4:"tags";a:2:{i:0;s:4:"core";i:1;s:5:"image";}}i:16;a:10:{s:5:"model";s:22:"text-embedding-3-small";s:4:"name";s:17:"Embedding 3-Small";s:6:"family";s:14:"text-embedding";s:8:"features";a:1:{i:0;s:9:"embedding";}s:5:"price";d:0.02;s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:8:"finetune";b:0;s:10:"dimensions";a:2:{i:0;i:512;i:1;i:1536;}s:4:"tags";a:2:{i:0;s:4:"core";i:1;s:9:"embedding";}}i:17;a:10:{s:5:"model";s:22:"text-embedding-3-large";s:4:"name";s:17:"Embedding 3-Large";s:6:"family";s:14:"text-embedding";s:8:"features";a:1:{i:0;s:9:"embedding";}s:5:"price";d:0.13;s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:8:"finetune";b:0;s:10:"dimensions";a:3:{i:0;i:256;i:1;i:1024;i:2;i:3072;}s:4:"tags";a:2:{i:0;s:4:"core";i:1;s:9:"embedding";}}i:18;a:10:{s:5:"model";s:22:"text-embedding-ada-002";s:4:"name";s:17:"Embedding Ada-002";s:6:"family";s:14:"text-embedding";s:8:"features";a:1:{i:0;s:9:"embedding";}s:5:"price";d:0.1;s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:8:"finetune";b:0;s:10:"dimensions";a:1:{i:0;i:1536;}s:4:"tags";a:2:{i:0;s:4:"core";i:1;s:9:"embedding";}}i:19;a:9:{s:5:"model";s:9:"whisper-1";s:4:"name";s:7:"Whisper";s:6:"family";s:7:"whisper";s:8:"features";a:1:{i:0;s:14:"speech-to-text";}s:5:"price";d:0.006;s:4:"type";s:6:"second";s:4:"unit";i:1;s:8:"finetune";b:0;s:4:"tags";a:2:{i:0;s:4:"core";i:1;s:5:"audio";}}i:20;a:11:{s:5:"model";s:15:"gpt-4.5-preview";s:4:"name";s:17:"GPT-4.5 (Preview)";s:6:"family";s:6:"gpt4.5";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:2:{s:2:"in";i:75;s:3:"out";i:150;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:16384;s:19:"maxContextualTokens";i:128000;s:8:"finetune";b:0;s:4:"tags";a:6:{i:0;s:4:"core";i:1;s:4:"chat";i:2;s:6:"vision";i:3;s:9:"functions";i:4;s:4:"json";i:5;s:10:"deprecated";}}i:21;a:9:{s:5:"model";s:6:"dall-e";s:4:"name";s:8:"DALL-E 2";s:6:"family";s:6:"dall-e";s:8:"features";a:1:{i:0;s:13:"text-to-image";}s:11:"resolutions";a:3:{i:0;a:3:{s:4:"name";s:7:"256x256";s:5:"label";s:7:"256x256";s:5:"price";d:0.016;}i:1;a:3:{s:4:"name";s:7:"512x512";s:5:"label";s:7:"512x512";s:5:"price";d:0.018;}i:2;a:3:{s:4:"name";s:9:"1024x1024";s:5:"label";s:9:"1024x1024";s:5:"price";d:0.02;}}s:4:"type";s:5:"image";s:4:"unit";i:1;s:8:"finetune";b:0;s:4:"tags";a:3:{i:0;s:4:"core";i:1;s:5:"image";i:2;s:10:"deprecated";}}}}i:1;a:5:{s:4:"name";s:9:"Anthropic";s:4:"type";s:9:"anthropic";s:6:"inputs";a:1:{i:0;s:6:"apikey";}s:8:"internal";b:1;s:6:"models";a:11:{i:0;a:11:{s:5:"model";s:22:"claude-opus-4-20250514";s:4:"name";s:26:"Claude-4 Opus (2025/05/14)";s:6:"family";s:6:"claude";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:2:{s:2:"in";i:15;s:3:"out";i:75;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:32000;s:19:"maxContextualTokens";i:200000;s:8:"finetune";b:0;s:4:"tags";a:5:{i:0;s:4:"core";i:1;s:4:"chat";i:2;s:6:"vision";i:3;s:9:"functions";i:4;s:9:"reasoning";}}i:1;a:11:{s:5:"model";s:24:"claude-sonnet-4-20250514";s:4:"name";s:28:"Claude-4 Sonnet (2025/05/14)";s:6:"family";s:6:"claude";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:2:{s:2:"in";i:3;s:3:"out";i:15;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:64000;s:19:"maxContextualTokens";i:200000;s:8:"finetune";b:0;s:4:"tags";a:5:{i:0;s:4:"core";i:1;s:4:"chat";i:2;s:6:"vision";i:3;s:9:"functions";i:4;s:9:"reasoning";}}i:2;a:11:{s:5:"model";s:24:"claude-3-7-sonnet-latest";s:4:"name";s:17:"Claude-3.7 Sonnet";s:6:"family";s:6:"claude";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:2:{s:2:"in";i:3;s:3:"out";i:15;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:64000;s:19:"maxContextualTokens";i:200000;s:8:"finetune";b:0;s:4:"tags";a:5:{i:0;s:4:"core";i:1;s:4:"chat";i:2;s:6:"vision";i:3;s:9:"functions";i:4;s:9:"reasoning";}}i:3;a:11:{s:5:"model";s:24:"claude-3-5-sonnet-latest";s:4:"name";s:17:"Claude-3.5 Sonnet";s:6:"family";s:6:"claude";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:2:{s:2:"in";i:3;s:3:"out";i:15;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:4096;s:19:"maxContextualTokens";i:200000;s:8:"finetune";b:0;s:4:"tags";a:4:{i:0;s:4:"core";i:1;s:4:"chat";i:2;s:6:"vision";i:3;s:9:"functions";}}i:4;a:11:{s:5:"model";s:26:"claude-3-5-sonnet-20241022";s:4:"name";s:30:"Claude-3.5 Sonnet (2024/10/22)";s:6:"family";s:6:"claude";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:2:{s:2:"in";i:3;s:3:"out";i:15;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:4096;s:19:"maxContextualTokens";i:200000;s:8:"finetune";b:0;s:4:"tags";a:5:{i:0;s:4:"core";i:1;s:4:"chat";i:2;s:6:"vision";i:3;s:5:"files";i:4;s:9:"functions";}}i:5;a:11:{s:5:"model";s:26:"claude-3-5-sonnet-20240620";s:4:"name";s:30:"Claude-3.5 Sonnet (2024/06/20)";s:6:"family";s:6:"claude";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:2:{s:2:"in";i:3;s:3:"out";i:15;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:4096;s:19:"maxContextualTokens";i:200000;s:8:"finetune";b:0;s:4:"tags";a:4:{i:0;s:4:"core";i:1;s:4:"chat";i:2;s:6:"vision";i:3;s:9:"functions";}}i:6;a:11:{s:5:"model";s:24:"claude-3-sonnet-20240229";s:4:"name";s:28:"Claude-3 Sonnet (2024/02/29)";s:6:"family";s:6:"claude";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:2:{s:2:"in";i:3;s:3:"out";i:15;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:4096;s:19:"maxContextualTokens";i:200000;s:8:"finetune";b:0;s:4:"tags";a:5:{i:0;s:4:"core";i:1;s:4:"chat";i:2;s:6:"vision";i:3;s:9:"functions";i:4;s:10:"deprecated";}}i:7;a:11:{s:5:"model";s:20:"claude-3-opus-latest";s:4:"name";s:22:"Claude-3 Opus (Latest)";s:6:"family";s:6:"claude";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:2:{s:2:"in";i:15;s:3:"out";i:75;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:4096;s:19:"maxContextualTokens";i:200000;s:8:"finetune";b:0;s:4:"tags";a:4:{i:0;s:4:"core";i:1;s:4:"chat";i:2;s:6:"vision";i:3;s:9:"functions";}}i:8;a:11:{s:5:"model";s:22:"claude-3-opus-20240229";s:4:"name";s:26:"Claude-3 Opus (2024/02/29)";s:6:"family";s:6:"claude";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:2:{s:2:"in";i:15;s:3:"out";i:75;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:4096;s:19:"maxContextualTokens";i:200000;s:8:"finetune";b:0;s:4:"tags";a:4:{i:0;s:4:"core";i:1;s:4:"chat";i:2;s:6:"vision";i:3;s:9:"functions";}}i:9;a:11:{s:5:"model";s:25:"claude-3-5-haiku-20241022";s:4:"name";s:29:"Claude-3.5 Haiku (2024/10/22)";s:6:"family";s:6:"claude";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:2:{s:2:"in";i:1;s:3:"out";i:5;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:8192;s:19:"maxContextualTokens";i:200000;s:8:"finetune";b:0;s:4:"tags";a:2:{i:0;s:4:"core";i:1;s:4:"chat";}}i:10;a:11:{s:5:"model";s:23:"claude-3-haiku-20240307";s:4:"name";s:27:"Claude-3 Haiku (2024/03/07)";s:6:"family";s:6:"claude";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:2:{s:2:"in";d:0.25;s:3:"out";d:1.25;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:19:"maxCompletionTokens";i:4096;s:19:"maxContextualTokens";i:200000;s:8:"finetune";b:0;s:4:"tags";a:4:{i:0;s:4:"core";i:1;s:4:"chat";i:2;s:6:"vision";i:3;s:9:"functions";}}}}i:2;a:5:{s:4:"name";s:14:"Azure (OpenAI)";s:4:"type";s:5:"azure";s:6:"inputs";a:2:{i:0;s:6:"apikey";i:1;s:8:"endpoint";}s:8:"internal";b:1;s:6:"models";a:0:{}}i:3;a:5:{s:4:"name";s:6:"Google";s:4:"type";s:6:"google";s:6:"inputs";a:3:{i:0;s:6:"apikey";i:1;s:9:"projectId";i:2;s:13:"dynamicModels";}s:8:"internal";b:1;s:6:"models";a:0:{}}i:4;a:5:{s:4:"name";s:10:"OpenRouter";s:4:"type";s:10:"openrouter";s:6:"inputs";a:2:{i:0;s:6:"apikey";i:1;s:13:"dynamicModels";}s:8:"internal";b:1;s:6:"models";a:0:{}}i:5;a:5:{s:4:"name";s:12:"Hugging Face";s:4:"type";s:11:"huggingface";s:6:"inputs";a:1:{i:0;s:6:"apikey";}s:8:"internal";b:1;s:6:"models";a:0:{}}i:6;a:5:{s:4:"name";s:9:"Replicate";s:4:"type";s:9:"replicate";s:6:"inputs";a:2:{i:0;s:6:"apikey";i:1;s:13:"dynamicModels";}s:8:"internal";b:1;s:6:"models";a:0:{}}i:7;a:5:{s:4:"name";s:10:"Perplexity";s:4:"type";s:10:"perplexity";s:6:"inputs";a:1:{i:0;s:6:"apikey";}s:8:"internal";b:1;s:6:"models";a:2:{i:0;a:12:{s:5:"model";s:9:"sonar-pro";s:4:"name";s:9:"Sonar Pro";s:6:"family";s:5:"sonar";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:3:{s:2:"in";i:3;s:3:"out";i:15;s:6:"search";i:5;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:10:"searchUnit";d:0.001;s:19:"maxCompletionTokens";i:8192;s:19:"maxContextualTokens";i:200000;s:8:"finetune";b:0;s:4:"tags";a:2:{i:0;s:4:"core";i:1;s:4:"chat";}}i:1;a:12:{s:5:"model";s:5:"sonar";s:4:"name";s:5:"Sonar";s:6:"family";s:5:"sonar";s:8:"features";a:1:{i:0;s:10:"completion";}s:5:"price";a:3:{s:2:"in";i:1;s:3:"out";i:1;s:6:"search";i:5;}s:4:"type";s:5:"token";s:4:"unit";d:1.0E-6;s:10:"searchUnit";d:0.001;s:19:"maxCompletionTokens";i:4096;s:19:"maxContextualTokens";i:127000;s:8:"finetune";b:0;s:4:"tags";a:2:{i:0;s:4:"core";i:1;s:4:"chat";}}}}}s:7:"ai_envs";a:1:{i:0;a:8:{s:2:"id";s:8:"93cc0ve0";s:4:"name";s:6:"OpenAI";s:4:"type";s:6:"openai";s:6:"apikey";s:0:"";s:9:"finetunes";a:0:{}s:17:"finetunes_deleted";a:0:{}s:16:"legacy_finetunes";a:0:{}s:24:"legacy_finetunes_deleted";a:0:{}}}s:21:"ai_images_default_env";s:8:"93cc0ve0";s:23:"ai_images_default_model";s:11:"dall-e-3-hd";s:19:"ai_json_default_env";s:8:"93cc0ve0";s:21:"ai_json_default_model";s:18:"gpt-4-1106-preview";s:9:"ai_models";a:0:{}s:15:"ai_models_usage";a:0:{}s:12:"ai_streaming";b:1;s:21:"ai_vision_default_env";s:8:"93cc0ve0";s:23:"ai_vision_default_model";s:20:"gpt-4-vision-preview";s:10:"banned_ips";a:0:{}s:12:"banned_words";a:0:{}s:16:"chatbot_defaults";a:33:{s:6:"aiName";s:4:"AI: ";s:8:"userName";s:6:"User: ";s:9:"guestName";s:7:"Guest: ";s:8:"textSend";s:4:"Send";s:9:"textClear";s:5:"Clear";s:20:"textInputPlaceholder";s:20:"Type your message...";s:18:"textInputMaxLength";i:512;s:14:"textCompliance";s:0:"";s:13:"startSentence";s:23:"Hi! How can I help you?";s:7:"themeId";s:7:"chatgpt";s:6:"window";b:0;s:4:"icon";s:0:"";s:8:"iconText";s:0:"";s:13:"iconTextDelay";i:1;s:7:"iconAlt";s:17:"AI Engine Chatbot";s:12:"iconPosition";s:12:"bottom-right";s:10:"iconBubble";b:0;s:10:"fullscreen";b:0;s:10:"copyButton";b:0;s:14:"headerSubtitle";s:12:"Discuss with";s:11:"localMemory";b:1;s:5:"botId";N;s:12:"instructions";s:63:"Converse as if you were an AI assistant. Be friendly, creative.";s:5:"scope";s:7:"chatbot";s:4:"mode";s:4:"chat";s:12:"contentAware";b:0;s:15:"embeddingsEnvId";s:0:"";s:5:"model";s:12:"gpt-4.1-nano";s:11:"temperature";d:0.8;s:11:"maxMessages";i:15;s:9:"maxTokens";i:1024;s:10:"maxResults";i:1;s:6:"apiKey";N;}s:19:"chatbot_discussions";b:0;s:19:"chatbot_gdpr_button";s:12:"I understand";s:20:"chatbot_gdpr_consent";b:0;s:17:"chatbot_gdpr_text";s:163:"By using this chatbot, you agree to the recording and processing of your data by our website and the external services it might use (LLMs, vector databases, etc.).";s:18:"chatbot_moderation";b:0;s:14:"chatbot_select";s:8:"dropdown";s:18:"chatbot_typewriter";b:0;s:15:"clean_uninstall";b:0;s:18:"context_max_length";i:4096;s:10:"debug_mode";b:1;s:14:"default_limits";a:4:{s:7:"enabled";b:1;s:6:"guests";a:5:{s:7:"credits";i:3;s:10:"creditType";s:7:"queries";s:9:"timeFrame";s:3:"day";s:10:"isAbsolute";b:0;s:16:"overLimitMessage";s:70:"You have reached the limit (check the Insights Tab > Limits > Guests).";}s:5:"users";a:6:{s:7:"credits";i:10;s:10:"creditType";s:5:"price";s:9:"timeFrame";s:5:"month";s:10:"isAbsolute";b:0;s:16:"overLimitMessage";s:69:"You have reached the limit (check the Insights Tab > Limits > Users).";s:12:"ignoredUsers";s:20:"administrator,editor";}s:6:"system";a:6:{s:7:"credits";i:20;s:10:"creditType";s:5:"price";s:9:"timeFrame";s:5:"month";s:10:"isAbsolute";b:0;s:16:"overLimitMessage";s:50:"Our chatbot went to sleep. Please try again later.";s:12:"ignoredUsers";s:0:"";}}s:10:"embeddings";a:9:{s:14:"rewriteContent";b:1;s:13:"rewritePrompt";s:486:"Rewrite the content concisely in {LANGUAGE}, maintaining the same style and information. The revised text should be under 800 words, with paragraphs ranging from 160-280 words each. Omit non-textual elements and avoid unnecessary repetition. Conclude with a statement directing readers to find more information at {URL}. If you cannot meet these requirements, please leave a blank response. The content is below, between \'== START ==\' and \'== END ==\'.\n\n== START ==\n{CONTENT}\n== END ==\n\n";s:13:"forceRecreate";b:0;s:9:"maxSelect";i:1;s:8:"minScore";i:75;s:9:"syncPosts";b:0;s:12:"syncPostsEnv";N;s:13:"syncPostTypes";a:3:{i:0;s:4:"post";i:1;s:4:"page";i:2;s:7:"product";}s:14:"syncPostStatus";a:1:{i:0;s:7:"publish";}}s:22:"embeddings_default_env";s:8:"focbep64";s:15:"embeddings_envs";a:1:{i:0;a:8:{s:2:"id";s:8:"focbep64";s:4:"name";s:8:"Pinecone";s:4:"type";s:8:"pinecone";s:6:"apikey";s:0:"";s:6:"server";s:11:"gcp-starter";s:7:"indexes";a:0:{}s:10:"namespaces";a:0:{}s:5:"index";N;}}s:9:"functions";a:0:{}s:13:"image_expires";i:3600;s:18:"image_local_upload";s:7:"uploads";s:19:"image_remote_upload";s:4:"data";s:13:"intro_message";b:0;s:9:"languages";a:8:{s:2:"en";s:7:"English";s:2:"de";s:6:"German";s:2:"fr";s:6:"French";s:2:"es";s:7:"Spanish";s:2:"it";s:7:"Italian";s:2:"zh";s:7:"Chinese";s:2:"ja";s:8:"Japanese";s:2:"pt";s:10:"Portuguese";}s:6:"limits";a:4:{s:7:"enabled";b:1;s:6:"guests";a:5:{s:7:"credits";i:3;s:10:"creditType";s:7:"queries";s:9:"timeFrame";s:3:"day";s:10:"isAbsolute";b:0;s:16:"overLimitMessage";s:27:"You have reached the limit.";}s:5:"users";a:6:{s:7:"credits";i:10;s:10:"creditType";s:5:"price";s:9:"timeFrame";s:5:"month";s:10:"isAbsolute";b:0;s:16:"overLimitMessage";s:27:"You have reached the limit.";s:12:"ignoredUsers";s:20:"administrator,editor";}s:6:"system";a:6:{s:7:"credits";i:20;s:10:"creditType";s:5:"price";s:9:"timeFrame";s:5:"month";s:10:"isAbsolute";b:0;s:16:"overLimitMessage";s:50:"Our chatbot went to sleep. Please try again later.";s:12:"ignoredUsers";s:0:"";}}s:9:"logs_path";s:61:"/var/www/html/ki.zork.no/wp-content/uploads/mwai_Lez5awKC.log";s:13:"module_addons";b:0;s:14:"module_advisor";b:0;s:13:"module_blocks";b:0;s:15:"module_chatbots";b:1;s:17:"module_embeddings";b:0;s:16:"module_finetunes";b:0;s:12:"module_forms";b:0;s:24:"module_generator_content";b:0;s:23:"module_generator_images";b:0;s:17:"module_moderation";b:0;s:17:"module_playground";b:0;s:17:"module_statistics";b:0;s:18:"module_suggestions";b:1;s:20:"module_transcription";b:0;s:18:"module_woocommerce";b:0;s:10:"public_api";b:0;s:18:"resolve_shortcodes";b:0;s:17:"server_debug_mode";b:1;s:18:"speech_recognition";b:1;s:16:"speech_synthesis";b:0;s:16:"syntax_highlight";b:1;s:20:"virtual_keyboard_fix";b:0;s:27:"chatbot_discussions_titling";b:1;s:22:"ignore_word_boundaries";b:0;s:9:"admin_bar";a:2:{i:0;s:8:"settings";s:8:"settings";b:1;}s:10:"module_mcp";b:0;s:13:"privacy_first";b:0;s:19:"ai_fast_default_env";s:8:"93cc0ve0";s:21:"ai_fast_default_model";s:12:"gpt-4.1-nano";s:8:"dev_mode";b:0;}','off');
INSERT INTO `wp_options` VALUES (88659,'fs_active_plugins','O:8:"stdClass":3:{s:7:"plugins";a:1:{s:27:"password-protected/freemius";O:8:"stdClass":4:{s:7:"version";s:6:"2.12.2";s:4:"type";s:6:"plugin";s:9:"timestamp";i:1762930282;s:11:"plugin_path";s:41:"password-protected/password-protected.php";}}s:7:"abspath";s:25:"/var/www/html/ki.zork.no/";s:6:"newest";O:8:"stdClass":5:{s:11:"plugin_path";s:41:"password-protected/password-protected.php";s:8:"sdk_path";s:27:"password-protected/freemius";s:7:"version";s:6:"2.12.2";s:13:"in_activation";b:0;s:9:"timestamp";i:1762930282;}}','yes');
INSERT INTO `wp_options` VALUES (88660,'fs_debug_mode','','yes');
INSERT INTO `wp_options` VALUES (88661,'fs_accounts','a:8:{s:21:"id_slug_type_path_map";a:1:{i:12503;a:3:{s:4:"slug";s:23:"password-protected-free";s:4:"type";s:6:"plugin";s:4:"path";s:41:"password-protected/password-protected.php";}}s:11:"plugin_data";a:1:{s:23:"password-protected-free";a:18:{s:16:"plugin_main_file";O:8:"stdClass":1:{s:4:"path";s:41:"password-protected/password-protected.php";}s:20:"is_network_activated";b:0;s:17:"install_timestamp";i:1701944855;s:16:"sdk_last_version";s:6:"2.11.0";s:11:"sdk_version";s:6:"2.12.2";s:16:"sdk_upgrade_mode";b:1;s:18:"sdk_downgrade_mode";b:0;s:19:"plugin_last_version";s:5:"2.7.8";s:14:"plugin_version";s:6:"2.7.12";s:19:"plugin_upgrade_mode";b:1;s:21:"plugin_downgrade_mode";b:0;s:17:"was_plugin_loaded";b:1;s:21:"is_plugin_new_install";b:0;s:17:"connectivity_test";a:6:{s:12:"is_connected";N;s:4:"host";s:11:"www.zork.no";s:9:"server_ip";s:14:"194.63.248.121";s:9:"is_active";b:1;s:9:"timestamp";i:1701944976;s:7:"version";s:5:"2.6.6";}s:15:"prev_is_premium";b:0;s:12:"is_anonymous";a:3:{s:2:"is";b:1;s:9:"timestamp";i:1705769351;s:7:"version";s:5:"2.6.6";}s:14:"sync_timestamp";i:1762929886;s:19:"last_load_timestamp";i:1762875897;}}s:13:"file_slug_map";a:1:{s:41:"password-protected/password-protected.php";s:23:"password-protected-free";}s:7:"plugins";a:1:{s:23:"password-protected-free";O:9:"FS_Plugin":24:{s:2:"id";s:5:"12503";s:7:"updated";N;s:7:"created";N;s:22:"\0FS_Entity\0_is_updated";b:1;s:10:"public_key";s:32:"pk_e9210517721d27b5112fa7773a600";s:10:"secret_key";N;s:16:"parent_plugin_id";N;s:5:"title";s:18:"Password Protected";s:4:"slug";s:23:"password-protected-free";s:12:"premium_slug";s:34:"password-protected-premium-premium";s:4:"type";s:6:"plugin";s:20:"affiliate_moderation";b:0;s:19:"is_wp_org_compliant";b:1;s:22:"premium_releases_count";N;s:4:"file";s:41:"password-protected/password-protected.php";s:7:"version";s:6:"2.7.12";s:11:"auto_update";N;s:4:"info";N;s:10:"is_premium";b:0;s:14:"premium_suffix";s:9:"(Premium)";s:7:"is_live";b:1;s:9:"bundle_id";N;s:17:"bundle_public_key";N;s:17:"opt_in_moderation";N;}}s:13:"admin_notices";a:1:{s:23:"password-protected-free";a:0:{}}s:9:"unique_id";s:32:"aebd436e6839340db25e1d04402dd00b";s:12:"gc_timestamp";a:0:{}s:10:"theme_data";a:0:{}}','yes');
INSERT INTO `wp_options` VALUES (88709,'_transient_health-check-site-status-result','{"good":18,"recommended":4,"critical":1}','yes');
INSERT INTO `wp_options` VALUES (88881,'mwai_chatbots','a:2:{i:0;a:57:{s:6:"aiName";s:4:"AI: ";s:8:"userName";s:6:"User: ";s:9:"guestName";s:6:"Guest:";s:8:"textSend";s:4:"Send";s:9:"textClear";s:5:"Clear";s:20:"textInputPlaceholder";s:20:"Type your message...";s:18:"textInputMaxLength";s:3:"512";s:14:"textCompliance";s:0:"";s:13:"startSentence";s:23:"Hi! How can I help you?";s:12:"maxSentences";s:2:"15";s:7:"themeId";s:7:"chatgpt";s:6:"window";s:0:"";s:4:"icon";s:0:"";s:8:"iconText";s:0:"";s:7:"iconAlt";s:17:"AI Chatbot Avatar";s:12:"iconPosition";s:12:"bottom-right";s:10:"fullscreen";s:0:"";s:10:"copyButton";s:0:"";s:11:"localMemory";s:0:"";s:5:"botId";s:7:"default";s:4:"mode";s:4:"chat";s:12:"contentAware";s:0:"";s:15:"embeddingsEnvId";s:0:"";s:17:"casuallyFineTuned";s:0:"";s:12:"promptEnding";s:0:"";s:16:"completionEnding";s:0:"";s:5:"model";s:0:"";s:11:"temperature";s:3:"0.8";s:9:"maxTokens";s:0:"";s:10:"maxResults";s:1:"1";s:6:"apiKey";s:0:"";s:4:"name";s:7:"Default";s:11:"maxMessages";s:2:"15";s:12:"instructions";s:63:"Converse as if you were an AI assistant. Be friendly, creative.";s:5:"scope";s:7:"chatbot";s:13:"iconTextDelay";s:1:"1";s:10:"iconBubble";s:0:"";s:14:"headerSubtitle";s:12:"Discuss with";s:10:"centerOpen";b:0;s:5:"width";s:0:"";s:9:"openDelay";s:0:"";s:15:"windowAnimation";s:4:"zoom";s:11:"multiUpload";b:0;s:13:"containerType";s:8:"standard";s:10:"headerType";s:8:"standard";s:12:"messagesType";s:8:"standard";s:9:"inputType";s:8:"standard";s:10:"footerType";s:8:"standard";s:5:"voice";N;s:9:"functions";a:0:{}s:10:"mcpServers";a:0:{}s:15:"historyStrategy";N;s:9:"crossSite";a:2:{s:7:"enabled";b:0;s:14:"allowedDomains";a:0:{}}s:10:"fileUpload";b:0;s:10:"maxUploads";i:1;s:11:"fileUploads";i:0;s:11:"imageUpload";b:0;}i:1;a:58:{s:6:"aiName";s:0:"";s:8:"userName";s:0:"";s:9:"guestName";s:0:"";s:8:"textSend";s:4:"Send";s:9:"textClear";s:5:"Slett";s:20:"textInputPlaceholder";s:12:"Skriv her...";s:18:"textInputMaxLength";s:5:"20000";s:14:"textCompliance";s:135:"Husk at en KI ikke er et menneske og kan skrive ting som ikke stemmer med virkeligheten, og den gir ikke beskjed om når den gjør det.";s:13:"startSentence";s:38:"Hei! Hva kan jeg gjøre for deg i dag?";s:7:"themeId";s:7:"chatgpt";s:6:"window";s:0:"";s:4:"icon";s:0:"";s:8:"iconText";s:0:"";s:13:"iconTextDelay";s:1:"1";s:7:"iconAlt";s:17:"AI Engine Chatbot";s:12:"iconPosition";s:12:"bottom-right";s:10:"iconBubble";s:0:"";s:10:"fullscreen";s:0:"";s:10:"copyButton";s:1:"1";s:14:"headerSubtitle";s:12:"Discuss with";s:11:"localMemory";s:0:"";s:5:"botId";s:14:"chatbot-4620ex";s:12:"instructions";s:128:"You are a large language model. Follow the instructions. Do not use bullet points unless it is necessary. Do not reply in LaTeX.";s:5:"scope";s:7:"chatbot";s:4:"mode";s:4:"chat";s:12:"contentAware";s:0:"";s:15:"embeddingsEnvId";s:0:"";s:5:"model";s:0:"";s:11:"temperature";s:3:"0.8";s:11:"maxMessages";s:2:"30";s:9:"maxTokens";s:0:"";s:10:"maxResults";s:1:"1";s:6:"apiKey";s:0:"";s:4:"name";s:10:"praterobot";s:16:"contextMaxLength";s:4:"4096";s:8:"aiAvatar";s:1:"1";s:10:"userAvatar";s:1:"1";s:11:"guestAvatar";s:1:"1";s:14:"guestAvatarUrl";s:15:"avatar-user.svg";s:10:"centerOpen";b:0;s:5:"width";s:0:"";s:9:"openDelay";s:0:"";s:15:"windowAnimation";s:4:"zoom";s:11:"multiUpload";b:0;s:13:"containerType";s:8:"standard";s:10:"headerType";s:8:"standard";s:12:"messagesType";s:8:"standard";s:9:"inputType";s:8:"standard";s:10:"footerType";s:8:"standard";s:5:"voice";N;s:9:"functions";a:0:{}s:10:"mcpServers";a:0:{}s:15:"historyStrategy";N;s:9:"crossSite";a:2:{s:7:"enabled";b:0;s:14:"allowedDomains";a:0:{}}s:10:"fileUpload";b:0;s:10:"maxUploads";i:1;s:11:"fileUploads";i:0;s:11:"imageUpload";b:0;}}','yes');
INSERT INTO `wp_options` VALUES (89894,'password_protected_1.5_update_database','1','yes');
INSERT INTO `wp_options` VALUES (89988,'mo_oauth_activation_time','O:8:"DateTime":3:{s:4:"date";s:26:"2024-03-29 15:19:20.479205";s:13:"timezone_type";i:3;s:8:"timezone";s:3:"UTC";}','yes');
INSERT INTO `wp_options` VALUES (89990,'widget_mooauth_widget','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (90000,'fs_api_cache','a:0:{}','no');
INSERT INTO `wp_options` VALUES (90003,'rua_plugin_version','2.6.1','yes');
INSERT INTO `wp_options` VALUES (90004,'_ca_condition_type_cache','a:1:{s:11:"restriction";a:1:{i:0;s:8:"taxonomy";}}','yes');
INSERT INTO `wp_options` VALUES (90048,'_site_transient_wp_plugin_dependencies_plugin_data','a:0:{}','no');
INSERT INTO `wp_options` VALUES (100284,'_transient_wp_styles_for_blocks','a:2:{s:4:"hash";s:32:"eff4648b63bc4fbc22f4f81a2066e7a2";s:6:"blocks";a:52:{s:11:"core/button";s:0:"";s:14:"core/site-logo";s:0:"";s:18:"core/post-template";s:0:"";s:12:"core/columns";s:0:"";s:14:"core/pullquote";s:272:":root :where(.wp-block-pullquote){border-width: 1px 0;border-style: solid;font-size: clamp(0.984em, 0.984rem + ((1vw - 0.2em) * 0.938), 1.5em);line-height: 1.3;margin-top: var(--wp--preset--spacing--40) !important;margin-bottom: var(--wp--preset--spacing--40) !important;}";s:32:"c48738dcb285a3f6ab83acff204fc486";s:127:":root :where(.wp-block-pullquote cite){font-size: var(--wp--preset--font-size--small);font-style: normal;text-transform: none;}";s:15:"core/navigation";s:83:":root :where(.wp-block-navigation){font-size: var(--wp--preset--font-size--small);}";s:32:"25289a01850f5a0264ddb79a9a3baf3d";s:92:":root :where(.wp-block-navigation a:where(:not(.wp-element-button))){text-decoration: none;}";s:32:"026c04da08398d655a95047f1f235d97";s:103:":root :where(.wp-block-navigation a:where(:not(.wp-element-button)):hover){text-decoration: underline;}";s:32:"d29336949e8ff45ab25278f69ae48aa5";s:110:":root :where(.wp-block-navigation a:where(:not(.wp-element-button)):focus){text-decoration: underline dashed;}";s:32:"351cbe3371c430e0059260af4561e940";s:99:":root :where(.wp-block-navigation a:where(:not(.wp-element-button)):active){text-decoration: none;}";s:16:"core/post-author";s:84:":root :where(.wp-block-post-author){font-size: var(--wp--preset--font-size--small);}";s:17:"core/post-content";s:0:"";s:32:"d81df30b68b32ad91c8a25bce2427ff0";s:115:":root :where(.wp-block-post-content a:where(:not(.wp-element-button))){color: var(--wp--preset--color--secondary);}";s:17:"core/post-excerpt";s:86:":root :where(.wp-block-post-excerpt){font-size: var(--wp--preset--font-size--medium);}";s:14:"core/post-date";s:99:":root :where(.wp-block-post-date){font-size: var(--wp--preset--font-size--small);font-weight: 400;}";s:32:"ac0d4e00f5ec22d14451759983e5bd43";s:91:":root :where(.wp-block-post-date a:where(:not(.wp-element-button))){text-decoration: none;}";s:32:"0ae6ffd1b886044c2da62d75d05ab13d";s:102:":root :where(.wp-block-post-date a:where(:not(.wp-element-button)):hover){text-decoration: underline;}";s:15:"core/post-terms";s:83:":root :where(.wp-block-post-terms){font-size: var(--wp--preset--font-size--small);}";s:15:"core/post-title";s:96:":root :where(.wp-block-post-title){font-weight: 400;margin-top: 1.25rem;margin-bottom: 1.25rem;}";s:32:"bb496d3fcd9be3502ce57ff8281e5687";s:92:":root :where(.wp-block-post-title a:where(:not(.wp-element-button))){text-decoration: none;}";s:32:"12380ab98fdc81351bb32a39bbfc9249";s:103:":root :where(.wp-block-post-title a:where(:not(.wp-element-button)):hover){text-decoration: underline;}";s:32:"db7080b413e40eaaccb138491d6550ee";s:110:":root :where(.wp-block-post-title a:where(:not(.wp-element-button)):focus){text-decoration: underline dashed;}";s:32:"6449d53deb0a7a970244f284c6743423";s:142:":root :where(.wp-block-post-title a:where(:not(.wp-element-button)):active){color: var(--wp--preset--color--secondary);text-decoration: none;}";s:19:"core/comments-title";s:133:":root :where(.wp-block-comments-title){font-size: var(--wp--preset--font-size--large);margin-bottom: var(--wp--preset--spacing--40);}";s:24:"core/comment-author-name";s:0:"";s:32:"c0002c260f8238c4212f3e4c369fc4f7";s:101:":root :where(.wp-block-comment-author-name a:where(:not(.wp-element-button))){text-decoration: none;}";s:32:"1e7c38b45537b325dbbbaec17a301676";s:112:":root :where(.wp-block-comment-author-name a:where(:not(.wp-element-button)):hover){text-decoration: underline;}";s:32:"f8e1a3f238d0ab1fccaff3b4fd131f24";s:119:":root :where(.wp-block-comment-author-name a:where(:not(.wp-element-button)):focus){text-decoration: underline dashed;}";s:32:"d0552d8fd858236f51abd8249b8438b7";s:151:":root :where(.wp-block-comment-author-name a:where(:not(.wp-element-button)):active){color: var(--wp--preset--color--secondary);text-decoration: none;}";s:17:"core/comment-date";s:85:":root :where(.wp-block-comment-date){font-size: var(--wp--preset--font-size--small);}";s:32:"c83ca7b3e52884c70f7830c54f99b318";s:94:":root :where(.wp-block-comment-date a:where(:not(.wp-element-button))){text-decoration: none;}";s:32:"7a05169cd0e6c7a5390492b955f8fd3d";s:105:":root :where(.wp-block-comment-date a:where(:not(.wp-element-button)):hover){text-decoration: underline;}";s:32:"349941f9bf2b82371084c5557167f361";s:112:":root :where(.wp-block-comment-date a:where(:not(.wp-element-button)):focus){text-decoration: underline dashed;}";s:32:"a8e8be38e88349efcca0e5621507a56e";s:144:":root :where(.wp-block-comment-date a:where(:not(.wp-element-button)):active){color: var(--wp--preset--color--secondary);text-decoration: none;}";s:22:"core/comment-edit-link";s:90:":root :where(.wp-block-comment-edit-link){font-size: var(--wp--preset--font-size--small);}";s:23:"core/comment-reply-link";s:91:":root :where(.wp-block-comment-reply-link){font-size: var(--wp--preset--font-size--small);}";s:24:"core/comments-pagination";s:88:":root :where(.wp-block-comments-pagination){margin-top: var(--wp--preset--spacing--40);}";s:32:"fede273dd696ea58b55b0ff2bcb53c08";s:101:":root :where(.wp-block-comments-pagination a:where(:not(.wp-element-button))){text-decoration: none;}";s:10:"core/query";s:0:"";s:32:"8c83951e484ccedf2bb7797ef5c4135f";s:83:":root :where(.wp-block-query h2){font-size: var(--wp--preset--font-size--x-large);}";s:21:"core/query-pagination";s:106:":root :where(.wp-block-query-pagination){font-size: var(--wp--preset--font-size--small);font-weight: 400;}";s:32:"13846eb06306dcbaa7c8e94667a2c0eb";s:98:":root :where(.wp-block-query-pagination a:where(:not(.wp-element-button))){text-decoration: none;}";s:32:"97117f9959d427c62680a83361e38d34";s:109:":root :where(.wp-block-query-pagination a:where(:not(.wp-element-button)):hover){text-decoration: underline;}";s:10:"core/quote";s:197:":root :where(.wp-block-quote){border-left-color: inherit;border-left-width: 1px;border-left-style: solid;padding-right: var(--wp--preset--spacing--30);padding-left: var(--wp--preset--spacing--30);}";s:32:"1de7a22e22013106efc5be82788cb6c0";s:102:":root :where(.wp-block-quote cite){font-size: var(--wp--preset--font-size--small);font-style: normal;}";s:15:"core/site-title";s:121:":root :where(.wp-block-site-title){font-size: var(--wp--preset--font-size--medium);font-weight: normal;line-height: 1.4;}";s:32:"f513d889cf971b13995cc3fffed2f39b";s:92:":root :where(.wp-block-site-title a:where(:not(.wp-element-button))){text-decoration: none;}";s:32:"22c37a317cc0ebd50155b5ad78564f37";s:103:":root :where(.wp-block-site-title a:where(:not(.wp-element-button)):hover){text-decoration: underline;}";s:32:"7f820b72d910bcef4934213eb41c9295";s:110:":root :where(.wp-block-site-title a:where(:not(.wp-element-button)):focus){text-decoration: underline dashed;}";s:32:"3e354d1ec2923ae3c9aef1b41e1c823d";s:142:":root :where(.wp-block-site-title a:where(:not(.wp-element-button)):active){color: var(--wp--preset--color--secondary);text-decoration: none;}";s:14:"core/separator";s:154:":root :where(.wp-block-separator){}:root :where(.wp-block-separator:not(.is-style-wide):not(.is-style-dots):not(.alignwide):not(.alignfull)){width: 100px}";}}','on');
INSERT INTO `wp_options` VALUES (102734,'wpmc_options','a:29:{s:6:"method";s:5:"media";s:7:"content";b:1;s:18:"filesystem_content";b:0;s:13:"media_library";b:1;s:12:"live_content";b:0;s:9:"debuglogs";b:0;s:11:"images_only";b:0;s:13:"attach_is_use";b:0;s:15:"thumbnails_only";b:0;s:11:"dirs_filter";s:0:"";s:12:"files_filter";s:0:"";s:15:"hide_thumbnails";b:0;s:12:"hide_warning";b:0;s:10:"skip_trash";b:0;s:13:"medias_buffer";i:100;s:12:"posts_buffer";i:5;s:15:"analysis_buffer";i:100;s:14:"file_op_buffer";i:20;s:5:"delay";i:100;s:19:"shortcodes_disabled";b:0;s:31:"output_buffer_cleaning_disabled";b:0;s:14:"php_error_logs";b:0;s:14:"posts_per_page";i:1000;s:15:"clean_uninstall";b:0;s:11:"repair_mode";b:0;s:11:"expert_mode";b:0;s:9:"logs_path";N;s:20:"incompatible_plugins";a:0:{}s:21:"use_cached_references";b:1;}','off');
INSERT INTO `wp_options` VALUES (102735,'wpmc_rating_date','1906007737','off');
INSERT INTO `wp_options` VALUES (102745,'wpvivid_init','init','off');
INSERT INTO `wp_options` VALUES (102746,'wpvivid_schedule_setting','a:2:{s:6:"enable";b:0;s:4:"lock";i:0;}','off');
INSERT INTO `wp_options` VALUES (102747,'wpvivid_compress_setting','a:7:{s:13:"compress_type";s:3:"zip";s:13:"max_file_size";i:200;s:11:"no_compress";b:1;s:13:"use_temp_file";i:1;s:13:"use_temp_size";i:16;s:17:"exclude_file_size";i:0;s:24:"subpackage_plugin_upload";b:0;}','off');
INSERT INTO `wp_options` VALUES (102748,'wpvivid_local_setting','a:2:{s:4:"path";s:14:"wpvividbackups";s:10:"save_local";i:1;}','off');
INSERT INTO `wp_options` VALUES (102749,'wpvivid_upload_setting','a:1:{s:15:"remote_selected";a:0:{}}','off');
INSERT INTO `wp_options` VALUES (102750,'wpvivid_common_setting','a:10:{s:18:"max_execution_time";i:300;s:16:"max_backup_count";i:3;s:14:"show_admin_bar";b:1;s:14:"domain_include";b:1;s:15:"estimate_backup";b:1;s:16:"max_resume_count";i:6;s:12:"memory_limit";s:4:"256M";s:20:"restore_memory_limit";s:4:"512M";s:12:"migrate_size";s:4:"2048";s:17:"log_save_location";s:26:"wpvividbackups/wpvivid_log";}','off');
INSERT INTO `wp_options` VALUES (102751,'wpvivid_email_setting','a:3:{s:7:"send_to";a:0:{}s:6:"always";b:1;s:12:"email_enable";b:0;}','off');
INSERT INTO `wp_options` VALUES (102752,'wpvivid_saved_api_token','a:0:{}','off');
INSERT INTO `wp_options` VALUES (102754,'wpvivid_last_msg','a:8:{s:2:"id";s:21:"wpvivid-92a0b60a1a858";s:4:"type";s:6:"Manual";s:7:"options";a:22:{s:7:"ismerge";s:1:"1";s:4:"lock";s:1:"0";s:12:"backup_files";s:8:"files+db";s:5:"local";s:1:"1";s:6:"remote";s:1:"0";s:4:"type";s:6:"Manual";s:10:"save_local";i:1;s:13:"backup_prefix";s:10:"ki.zork.no";s:11:"file_prefix";s:49:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01";s:13:"log_file_name";s:28:"wpvivid-92a0b60a1a858_backup";s:13:"log_file_path";s:99:"/var/www/html/ki.zork.no/wp-content/wpvividbackups/wpvivid_log/wpvivid-92a0b60a1a858_backup_log.txt";s:6:"prefix";s:49:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01";s:3:"dir";s:50:"/var/www/html/ki.zork.no/wp-content/wpvividbackups";s:10:"backup_dir";s:14:"wpvividbackups";s:14:"exclude-tables";a:6:{i:0;s:14:"wp_wpvivid_log";i:1;s:28:"wp_wpvivid_increment_big_ids";i:2;s:18:"wp_wpvivid_options";i:3;s:22:"wp_wpvivid_record_task";i:4;s:19:"wp_wpvivid_merge_db";i:5;s:20:"wp_wpvivid_merge_ids";}s:14:"include-tables";a:0:{}s:13:"exclude_files";a:9:{i:0;s:79:"#^\\/var\\/www\\/html\\/ki\\.zork\\.no\\/wp\\-content\\/plugins\\/wpvivid\\-backuprestore#";i:1;s:59:"#^\\/var\\/www\\/html\\/ki\\.zork\\.no\\/wp\\-content\\/plugins\\/\\.#";i:2;s:77:"#^\\/var\\/www\\/html\\/ki\\.zork\\.no\\/wp\\-content\\/plugins\\/wpvivid\\-backup\\-pro#";i:3;s:73:"#^\\/var\\/www\\/html\\/ki\\.zork\\.no\\/wp\\-content\\/plugins\\/wpvividdashboard#";i:4;s:55:"#^\\/var\\/www\\/html\\/ki\\.zork\\.no\\/wp\\-content\\/upgrade#";i:5;s:63:"#^\\/var\\/www\\/html\\/ki\\.zork\\.no\\/wp\\-content\\/wpvivid_uploads#";i:6;s:55:"#^\\/var\\/www\\/html\\/ki\\.zork\\.no\\/wp\\-content\\/wpvivid#";i:7;s:62:"#^\\/var\\/www\\/html\\/ki\\.zork\\.no\\/wp\\-content\\/wpvividbackups#";i:8;s:72:"#^\\/var\\/www\\/html\\/ki\\.zork\\.no\\/wp\\-content\\/wpvivid_uploads\\/Isolate#";}s:13:"include_files";a:3:{i:0;s:44:"#^\\/var\\/www\\/html\\/ki\\.zork\\.no\\/wp\\-admin#";i:1;s:47:"#^\\/var\\/www\\/html\\/ki\\.zork\\.no\\/wp\\-includes#";i:2;s:42:"#^\\/var\\/www\\/html\\/ki\\.zork\\.no\\/lotties#";}s:15:"include_plugins";a:0:{}s:14:"include_themes";a:0:{}s:14:"backup_options";a:1:{s:8:"compress";a:1:{s:13:"compress_type";s:3:"zip";}}s:14:"remote_options";b:0;}s:6:"status";a:7:{s:15:"task_start_time";i:1749456081;s:13:"task_end_time";i:1749456091;s:10:"start_time";i:1749456081;s:8:"run_time";i:1749456091;s:7:"timeout";i:1749456090;s:3:"str";s:7:"running";s:12:"resume_count";i:0;}s:7:"setting";a:13:{s:17:"db_connect_method";s:4:"wpdb";s:12:"memory_limit";s:4:"256M";s:18:"max_execution_time";i:300;s:23:"compress_file_use_cache";b:0;s:19:"compress_file_count";i:500;s:13:"max_file_size";i:200;s:17:"max_sql_file_size";i:200;s:17:"exclude_file_size";i:0;s:16:"max_resume_count";i:6;s:10:"zip_method";s:10:"ziparchive";s:8:"is_merge";b:1;s:10:"save_local";b:0;s:21:"backup_symlink_folder";b:0;}s:4:"data";a:3:{s:5:"doing";s:6:"backup";s:6:"backup";a:3:{s:5:"doing";s:12:"backup_merge";s:8:"progress";i:100;s:7:"sub_job";a:7:{s:9:"backup_db";a:2:{s:8:"progress";s:30:"Backing up backup_db finished.";s:8:"job_data";a:0:{}}s:13:"backup_themes";a:2:{s:8:"progress";s:34:"Backing up backup_themes finished.";s:8:"job_data";a:0:{}}s:13:"backup_plugin";a:2:{s:8:"progress";s:34:"Backing up backup_plugin finished.";s:8:"job_data";a:0:{}}s:14:"backup_uploads";a:2:{s:8:"progress";s:35:"Backing up backup_uploads finished.";s:8:"job_data";a:0:{}}s:14:"backup_content";a:2:{s:8:"progress";s:35:"Backing up backup_content finished.";s:8:"job_data";a:0:{}}s:11:"backup_core";a:2:{s:8:"progress";s:32:"Backing up backup_core finished.";s:8:"job_data";a:0:{}}s:12:"backup_merge";a:2:{s:8:"progress";s:33:"Backing up backup_merge finished.";s:8:"job_data";a:0:{}}}}s:6:"upload";a:5:{s:5:"doing";s:0:"";s:8:"finished";i:0;s:8:"progress";i:0;s:8:"job_data";a:0:{}s:7:"sub_job";a:0:{}}}s:4:"jobs";a:7:{i:0;a:8:{s:11:"backup_type";s:9:"backup_db";s:8:"finished";i:1;s:8:"progress";i:0;s:10:"file_index";i:1;s:16:"mysql_file_index";i:2;s:8:"sub_jobs";a:34:{s:24:"wp_mo_openid_linked_user";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:24:"wp_mo_openid_linked_user";s:4:"size";i:16384;s:4:"rows";s:1:"0";}s:16:"wp_mwai_filemeta";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:16:"wp_mwai_filemeta";s:4:"size";i:16384;s:4:"rows";s:1:"0";}s:13:"wp_mwai_files";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:13:"wp_mwai_files";s:4:"size";i:16384;s:4:"rows";s:1:"0";}s:15:"wp_mwai_logmeta";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:15:"wp_mwai_logmeta";s:4:"size";i:16384;s:4:"rows";s:1:"0";}s:12:"wp_mwai_logs";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:12:"wp_mwai_logs";s:4:"size";i:16384;s:4:"rows";s:1:"0";}s:15:"wp_mwai_vectors";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:15:"wp_mwai_vectors";s:4:"size";i:16384;s:4:"rows";s:1:"0";}s:18:"wp_mwcode_snippets";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:18:"wp_mwcode_snippets";s:4:"size";i:16384;s:4:"rows";s:1:"6";}s:19:"wp_pp_activity_logs";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:19:"wp_pp_activity_logs";s:4:"size";i:16384;s:4:"rows";s:1:"0";}s:20:"wp_pp_limit_password";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:20:"wp_pp_limit_password";s:4:"size";i:16384;s:4:"rows";s:1:"0";}s:22:"wp_pp_manage_passwords";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:22:"wp_pp_manage_passwords";s:4:"size";i:16384;s:4:"rows";s:2:"12";}s:24:"wp_pp_taxonomy_passwords";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:24:"wp_pp_taxonomy_passwords";s:4:"size";i:16384;s:4:"rows";s:1:"5";}s:9:"wp_wflocs";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:9:"wp_wflocs";s:4:"size";i:16384;s:4:"rows";s:1:"2";}s:16:"wp_wfls_settings";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:16:"wp_wfls_settings";s:4:"size";i:16384;s:4:"rows";s:2:"27";}s:17:"wp_wfreversecache";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:17:"wp_wfreversecache";s:4:"size";i:16384;s:4:"rows";s:1:"2";}s:17:"wp_wftrafficrates";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:17:"wp_wftrafficrates";s:4:"size";i:16384;s:4:"rows";s:1:"0";}s:31:"wp_wpvivid_unused_uploads_files";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:31:"wp_wpvivid_unused_uploads_files";s:4:"size";i:16384;s:4:"rows";s:1:"0";}s:8:"wp_links";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:8:"wp_links";s:4:"size";i:32768;s:4:"rows";s:1:"0";}s:14:"wp_mclean_scan";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:14:"wp_mclean_scan";s:4:"size";i:32768;s:4:"rows";s:2:"48";}s:13:"wp_mwai_chats";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:13:"wp_mwai_chats";s:4:"size";i:32768;s:4:"rows";s:1:"0";}s:21:"wp_term_relationships";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:21:"wp_term_relationships";s:4:"size";i:32768;s:4:"rows";s:3:"173";}s:38:"wp_wp_phpmyadmin_extension__errors_log";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:38:"wp_wp_phpmyadmin_extension__errors_log";s:4:"size";i:32768;s:4:"rows";s:1:"0";}s:14:"wp_commentmeta";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:14:"wp_commentmeta";s:4:"size";i:49152;s:4:"rows";s:1:"0";}s:11:"wp_snippets";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:11:"wp_snippets";s:4:"size";i:49152;s:4:"rows";s:1:"5";}s:16:"wp_term_taxonomy";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:16:"wp_term_taxonomy";s:4:"size";i:49152;s:4:"rows";s:2:"27";}s:11:"wp_termmeta";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:11:"wp_termmeta";s:4:"size";i:49152;s:4:"rows";s:1:"0";}s:8:"wp_terms";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:8:"wp_terms";s:4:"size";i:49152;s:4:"rows";s:2:"24";}s:11:"wp_usermeta";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:11:"wp_usermeta";s:4:"size";i:49152;s:4:"rows";s:2:"48";}s:8:"wp_users";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:8:"wp_users";s:4:"size";i:65536;s:4:"rows";s:1:"3";}s:14:"wp_mclean_refs";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:14:"wp_mclean_refs";s:4:"size";i:81920;s:4:"rows";s:3:"289";}s:22:"wp_wpvivid_scan_result";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:22:"wp_wpvivid_scan_result";s:4:"size";i:81920;s:4:"rows";s:3:"300";}s:11:"wp_comments";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:11:"wp_comments";s:4:"size";i:98304;s:4:"rows";s:1:"0";}s:11:"wp_postmeta";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:11:"wp_postmeta";s:4:"size";i:311296;s:4:"rows";s:3:"565";}s:10:"wp_options";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:10:"wp_options";s:4:"size";i:2392064;s:4:"rows";s:3:"263";}s:8:"wp_posts";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:8:"wp_posts";s:4:"size";i:3588096;s:4:"rows";s:3:"267";}}s:16:"mysql_dump_files";a:1:{i:0;s:61:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01.part001.sql";}s:8:"zip_file";a:1:{s:63:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_db.zip";a:2:{s:8:"filename";s:63:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_db.zip";s:8:"finished";i:1;}}}i:1;a:6:{s:11:"backup_type";s:13:"backup_themes";s:8:"finished";i:1;s:8:"progress";i:0;s:10:"file_index";i:1;s:5:"index";i:283;s:8:"zip_file";a:1:{s:67:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_themes.zip";a:2:{s:8:"filename";s:67:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_themes.zip";s:8:"finished";i:1;}}}i:2;a:6:{s:11:"backup_type";s:13:"backup_plugin";s:8:"finished";i:1;s:8:"progress";i:0;s:10:"file_index";i:1;s:5:"index";i:1241;s:8:"zip_file";a:1:{s:67:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_plugin.zip";a:2:{s:8:"filename";s:67:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_plugin.zip";s:8:"finished";i:1;}}}i:3;a:6:{s:11:"backup_type";s:14:"backup_uploads";s:8:"finished";i:1;s:8:"progress";i:0;s:10:"file_index";i:1;s:5:"index";i:346;s:8:"zip_file";a:1:{s:68:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_uploads.zip";a:2:{s:8:"filename";s:68:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_uploads.zip";s:8:"finished";i:1;}}}i:4;a:6:{s:11:"backup_type";s:14:"backup_content";s:8:"finished";i:1;s:8:"progress";i:0;s:10:"file_index";i:1;s:5:"index";i:703;s:8:"zip_file";a:1:{s:68:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_content.zip";a:2:{s:8:"filename";s:68:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_content.zip";s:8:"finished";i:1;}}}i:5;a:6:{s:11:"backup_type";s:11:"backup_core";s:8:"finished";i:1;s:8:"progress";i:0;s:10:"file_index";i:1;s:5:"index";i:2801;s:8:"zip_file";a:1:{s:65:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_core.zip";a:2:{s:8:"filename";s:65:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_core.zip";s:8:"finished";i:1;}}}i:6;a:7:{s:11:"backup_type";s:12:"backup_merge";s:8:"finished";i:1;s:8:"progress";i:0;s:10:"file_index";i:1;s:10:"child_file";a:6:{s:63:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_db.zip";a:11:{s:5:"files";a:1:{i:0;s:63:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_db.sql";}s:6:"tables";a:34:{i:0;a:3:{s:4:"name";s:24:"wp_mo_openid_linked_user";s:4:"size";i:16384;s:4:"rows";s:1:"0";}i:1;a:3:{s:4:"name";s:16:"wp_mwai_filemeta";s:4:"size";i:16384;s:4:"rows";s:1:"0";}i:2;a:3:{s:4:"name";s:13:"wp_mwai_files";s:4:"size";i:16384;s:4:"rows";s:1:"0";}i:3;a:3:{s:4:"name";s:15:"wp_mwai_logmeta";s:4:"size";i:16384;s:4:"rows";s:1:"0";}i:4;a:3:{s:4:"name";s:12:"wp_mwai_logs";s:4:"size";i:16384;s:4:"rows";s:1:"0";}i:5;a:3:{s:4:"name";s:15:"wp_mwai_vectors";s:4:"size";i:16384;s:4:"rows";s:1:"0";}i:6;a:3:{s:4:"name";s:18:"wp_mwcode_snippets";s:4:"size";i:16384;s:4:"rows";s:1:"6";}i:7;a:3:{s:4:"name";s:19:"wp_pp_activity_logs";s:4:"size";i:16384;s:4:"rows";s:1:"0";}i:8;a:3:{s:4:"name";s:20:"wp_pp_limit_password";s:4:"size";i:16384;s:4:"rows";s:1:"0";}i:9;a:3:{s:4:"name";s:22:"wp_pp_manage_passwords";s:4:"size";i:16384;s:4:"rows";s:2:"12";}i:10;a:3:{s:4:"name";s:24:"wp_pp_taxonomy_passwords";s:4:"size";i:16384;s:4:"rows";s:1:"5";}i:11;a:3:{s:4:"name";s:9:"wp_wflocs";s:4:"size";i:16384;s:4:"rows";s:1:"2";}i:12;a:3:{s:4:"name";s:16:"wp_wfls_settings";s:4:"size";i:16384;s:4:"rows";s:2:"27";}i:13;a:3:{s:4:"name";s:17:"wp_wfreversecache";s:4:"size";i:16384;s:4:"rows";s:1:"2";}i:14;a:3:{s:4:"name";s:17:"wp_wftrafficrates";s:4:"size";i:16384;s:4:"rows";s:1:"0";}i:15;a:3:{s:4:"name";s:31:"wp_wpvivid_unused_uploads_files";s:4:"size";i:16384;s:4:"rows";s:1:"0";}i:16;a:3:{s:4:"name";s:8:"wp_links";s:4:"size";i:32768;s:4:"rows";s:1:"0";}i:17;a:3:{s:4:"name";s:14:"wp_mclean_scan";s:4:"size";i:32768;s:4:"rows";s:2:"48";}i:18;a:3:{s:4:"name";s:13:"wp_mwai_chats";s:4:"size";i:32768;s:4:"rows";s:1:"0";}i:19;a:3:{s:4:"name";s:21:"wp_term_relationships";s:4:"size";i:32768;s:4:"rows";s:3:"173";}i:20;a:3:{s:4:"name";s:38:"wp_wp_phpmyadmin_extension__errors_log";s:4:"size";i:32768;s:4:"rows";s:1:"0";}i:21;a:3:{s:4:"name";s:14:"wp_commentmeta";s:4:"size";i:49152;s:4:"rows";s:1:"0";}i:22;a:3:{s:4:"name";s:11:"wp_snippets";s:4:"size";i:49152;s:4:"rows";s:1:"5";}i:23;a:3:{s:4:"name";s:16:"wp_term_taxonomy";s:4:"size";i:49152;s:4:"rows";s:2:"27";}i:24;a:3:{s:4:"name";s:11:"wp_termmeta";s:4:"size";i:49152;s:4:"rows";s:1:"0";}i:25;a:3:{s:4:"name";s:8:"wp_terms";s:4:"size";i:49152;s:4:"rows";s:2:"24";}i:26;a:3:{s:4:"name";s:11:"wp_usermeta";s:4:"size";i:49152;s:4:"rows";s:2:"48";}i:27;a:3:{s:4:"name";s:8:"wp_users";s:4:"size";i:65536;s:4:"rows";s:1:"3";}i:28;a:3:{s:4:"name";s:14:"wp_mclean_refs";s:4:"size";i:81920;s:4:"rows";s:3:"289";}i:29;a:3:{s:4:"name";s:22:"wp_wpvivid_scan_result";s:4:"size";i:81920;s:4:"rows";s:3:"300";}i:30;a:3:{s:4:"name";s:11:"wp_comments";s:4:"size";i:98304;s:4:"rows";s:1:"0";}i:31;a:3:{s:4:"name";s:11:"wp_postmeta";s:4:"size";i:311296;s:4:"rows";s:3:"565";}i:32;a:3:{s:4:"name";s:10:"wp_options";s:4:"size";i:2392064;s:4:"rows";s:3:"263";}i:33;a:3:{s:4:"name";s:8:"wp_posts";s:4:"size";i:3588096;s:4:"rows";s:3:"267";}}s:7:"dump_db";i:1;s:9:"file_type";s:9:"databases";s:8:"home_url";s:18:"https://ki.zork.no";s:9:"root_flag";s:6:"custom";s:11:"php_version";s:6:"8.2.25";s:13:"mysql_version";s:7:"10.5.27";s:10:"wp_version";s:5:"6.8.1";s:14:"find_zero_date";i:1;s:4:"file";s:71:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_db.part001.zip";}s:67:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_themes.zip";a:7:{s:9:"file_type";s:6:"themes";s:9:"root_flag";s:10:"wp-content";s:11:"php_version";s:6:"8.2.25";s:13:"mysql_version";s:7:"10.5.27";s:10:"wp_version";s:5:"6.8.1";s:6:"themes";a:2:{s:16:"twentytwentyfive";a:1:{s:4:"slug";s:16:"twentytwentyfive";}s:17:"twentytwentythree";a:1:{s:4:"slug";s:17:"twentytwentythree";}}s:4:"file";s:75:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_themes.part001.zip";}s:67:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_plugin.zip";a:7:{s:9:"file_type";s:6:"plugin";s:9:"root_flag";s:10:"wp-content";s:11:"php_version";s:6:"8.2.25";s:13:"mysql_version";s:7:"10.5.27";s:10:"wp_version";s:5:"6.8.1";s:6:"plugin";a:10:{s:9:"ai-engine";a:1:{s:4:"slug";s:9:"ai-engine";}s:7:"akismet";a:1:{s:4:"slug";s:7:"akismet";}s:16:"block-visibility";a:1:{s:4:"slug";s:16:"block-visibility";}s:13:"media-cleaner";a:1:{s:4:"slug";s:13:"media-cleaner";}s:48:"miniorange-login-with-eve-online-google-facebook";a:1:{s:4:"slug";s:48:"miniorange-login-with-eve-online-google-facebook";}s:18:"password-protected";a:1:{s:4:"slug";s:18:"password-protected";}s:10:"png-to-jpg";a:1:{s:4:"slug";s:10:"png-to-jpg";}s:24:"query-loop-post-selector";a:1:{s:4:"slug";s:24:"query-loop-post-selector";}s:20:"restrict-user-access";a:1:{s:4:"slug";s:20:"restrict-user-access";}s:10:"seo-engine";a:1:{s:4:"slug";s:10:"seo-engine";}}s:4:"file";s:75:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_plugin.part001.zip";}s:68:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_uploads.zip";a:6:{s:9:"file_type";s:6:"upload";s:9:"root_flag";s:10:"wp-content";s:11:"php_version";s:6:"8.2.25";s:13:"mysql_version";s:7:"10.5.27";s:10:"wp_version";s:5:"6.8.1";s:4:"file";s:76:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_uploads.part001.zip";}s:68:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_content.zip";a:6:{s:9:"file_type";s:10:"wp-content";s:9:"root_flag";s:10:"wp-content";s:11:"php_version";s:6:"8.2.25";s:13:"mysql_version";s:7:"10.5.27";s:10:"wp_version";s:5:"6.8.1";s:4:"file";s:76:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_content.part001.zip";}s:65:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_core.zip";a:6:{s:9:"file_type";s:7:"wp-core";s:12:"include_path";a:2:{i:0;s:11:"wp-includes";i:1;s:8:"wp-admin";}s:7:"wp_core";i:1;s:9:"root_flag";s:4:"root";s:8:"home_url";s:18:"https://ki.zork.no";s:4:"file";s:73:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_core.part001.zip";}}s:5:"index";i:6;s:8:"zip_file";a:1:{s:64:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_all.zip";a:2:{s:8:"filename";s:64:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01_backup_all.zip";s:8:"finished";i:1;}}}}s:12:"dump_setting";a:14:{s:8:"database";s:7:"ki-zork";s:4:"host";s:9:"localhost";s:4:"user";s:4:"root";s:4:"pass";s:13:"allelikerfisk";s:8:"site_url";s:18:"https://ki.zork.no";s:8:"home_url";s:18:"https://ki.zork.no";s:11:"content_url";s:29:"https://ki.zork.no/wp-content";s:6:"prefix";s:3:"wp_";s:17:"db_connect_method";s:4:"wpdb";s:11:"file_prefix";s:49:"ki.zork.no_wpvivid-92a0b60a1a858_2025-06-09-10-01";s:4:"path";s:50:"/var/www/html/ki.zork.no/wp-content/wpvividbackups";s:13:"max_file_size";i:209715200;s:14:"exclude-tables";a:6:{i:0;s:14:"wp_wpvivid_log";i:1;s:28:"wp_wpvivid_increment_big_ids";i:2;s:18:"wp_wpvivid_options";i:3;s:22:"wp_wpvivid_record_task";i:4;s:19:"wp_wpvivid_merge_db";i:5;s:20:"wp_wpvivid_merge_ids";}s:14:"include-tables";a:0:{}}}','off');
INSERT INTO `wp_options` VALUES (102755,'wpvivid_user_history','a:0:{}','off');
INSERT INTO `wp_options` VALUES (102756,'wpvivid_backup_list','a:0:{}','off');
INSERT INTO `wp_options` VALUES (102757,'wpvivid_need_review','do_not_ask','off');
INSERT INTO `wp_options` VALUES (102758,'cron_backup_count','a:0:{}','off');
INSERT INTO `wp_options` VALUES (102759,'wpvivid_review_msg','Backup successful! If you\'re happy with WPvivid Backup Plugin, a 5-star rating would mean the world to us and help us make it even better.','off');
INSERT INTO `wp_options` VALUES (102760,'wpvivid_review_type','manual','off');
INSERT INTO `wp_options` VALUES (102762,'_transient_wp_core_block_css_files','a:2:{s:7:"version";s:5:"6.8.3";s:5:"files";a:536:{i:0;s:23:"archives/editor-rtl.css";i:1;s:27:"archives/editor-rtl.min.css";i:2;s:19:"archives/editor.css";i:3;s:23:"archives/editor.min.css";i:4;s:22:"archives/style-rtl.css";i:5;s:26:"archives/style-rtl.min.css";i:6;s:18:"archives/style.css";i:7;s:22:"archives/style.min.css";i:8;s:20:"audio/editor-rtl.css";i:9;s:24:"audio/editor-rtl.min.css";i:10;s:16:"audio/editor.css";i:11;s:20:"audio/editor.min.css";i:12;s:19:"audio/style-rtl.css";i:13;s:23:"audio/style-rtl.min.css";i:14;s:15:"audio/style.css";i:15;s:19:"audio/style.min.css";i:16;s:19:"audio/theme-rtl.css";i:17;s:23:"audio/theme-rtl.min.css";i:18;s:15:"audio/theme.css";i:19;s:19:"audio/theme.min.css";i:20;s:21:"avatar/editor-rtl.css";i:21;s:25:"avatar/editor-rtl.min.css";i:22;s:17:"avatar/editor.css";i:23;s:21:"avatar/editor.min.css";i:24;s:20:"avatar/style-rtl.css";i:25;s:24:"avatar/style-rtl.min.css";i:26;s:16:"avatar/style.css";i:27;s:20:"avatar/style.min.css";i:28;s:21:"button/editor-rtl.css";i:29;s:25:"button/editor-rtl.min.css";i:30;s:17:"button/editor.css";i:31;s:21:"button/editor.min.css";i:32;s:20:"button/style-rtl.css";i:33;s:24:"button/style-rtl.min.css";i:34;s:16:"button/style.css";i:35;s:20:"button/style.min.css";i:36;s:22:"buttons/editor-rtl.css";i:37;s:26:"buttons/editor-rtl.min.css";i:38;s:18:"buttons/editor.css";i:39;s:22:"buttons/editor.min.css";i:40;s:21:"buttons/style-rtl.css";i:41;s:25:"buttons/style-rtl.min.css";i:42;s:17:"buttons/style.css";i:43;s:21:"buttons/style.min.css";i:44;s:22:"calendar/style-rtl.css";i:45;s:26:"calendar/style-rtl.min.css";i:46;s:18:"calendar/style.css";i:47;s:22:"calendar/style.min.css";i:48;s:25:"categories/editor-rtl.css";i:49;s:29:"categories/editor-rtl.min.css";i:50;s:21:"categories/editor.css";i:51;s:25:"categories/editor.min.css";i:52;s:24:"categories/style-rtl.css";i:53;s:28:"categories/style-rtl.min.css";i:54;s:20:"categories/style.css";i:55;s:24:"categories/style.min.css";i:56;s:19:"code/editor-rtl.css";i:57;s:23:"code/editor-rtl.min.css";i:58;s:15:"code/editor.css";i:59;s:19:"code/editor.min.css";i:60;s:18:"code/style-rtl.css";i:61;s:22:"code/style-rtl.min.css";i:62;s:14:"code/style.css";i:63;s:18:"code/style.min.css";i:64;s:18:"code/theme-rtl.css";i:65;s:22:"code/theme-rtl.min.css";i:66;s:14:"code/theme.css";i:67;s:18:"code/theme.min.css";i:68;s:22:"columns/editor-rtl.css";i:69;s:26:"columns/editor-rtl.min.css";i:70;s:18:"columns/editor.css";i:71;s:22:"columns/editor.min.css";i:72;s:21:"columns/style-rtl.css";i:73;s:25:"columns/style-rtl.min.css";i:74;s:17:"columns/style.css";i:75;s:21:"columns/style.min.css";i:76;s:33:"comment-author-name/style-rtl.css";i:77;s:37:"comment-author-name/style-rtl.min.css";i:78;s:29:"comment-author-name/style.css";i:79;s:33:"comment-author-name/style.min.css";i:80;s:29:"comment-content/style-rtl.css";i:81;s:33:"comment-content/style-rtl.min.css";i:82;s:25:"comment-content/style.css";i:83;s:29:"comment-content/style.min.css";i:84;s:26:"comment-date/style-rtl.css";i:85;s:30:"comment-date/style-rtl.min.css";i:86;s:22:"comment-date/style.css";i:87;s:26:"comment-date/style.min.css";i:88;s:31:"comment-edit-link/style-rtl.css";i:89;s:35:"comment-edit-link/style-rtl.min.css";i:90;s:27:"comment-edit-link/style.css";i:91;s:31:"comment-edit-link/style.min.css";i:92;s:32:"comment-reply-link/style-rtl.css";i:93;s:36:"comment-reply-link/style-rtl.min.css";i:94;s:28:"comment-reply-link/style.css";i:95;s:32:"comment-reply-link/style.min.css";i:96;s:30:"comment-template/style-rtl.css";i:97;s:34:"comment-template/style-rtl.min.css";i:98;s:26:"comment-template/style.css";i:99;s:30:"comment-template/style.min.css";i:100;s:42:"comments-pagination-numbers/editor-rtl.css";i:101;s:46:"comments-pagination-numbers/editor-rtl.min.css";i:102;s:38:"comments-pagination-numbers/editor.css";i:103;s:42:"comments-pagination-numbers/editor.min.css";i:104;s:34:"comments-pagination/editor-rtl.css";i:105;s:38:"comments-pagination/editor-rtl.min.css";i:106;s:30:"comments-pagination/editor.css";i:107;s:34:"comments-pagination/editor.min.css";i:108;s:33:"comments-pagination/style-rtl.css";i:109;s:37:"comments-pagination/style-rtl.min.css";i:110;s:29:"comments-pagination/style.css";i:111;s:33:"comments-pagination/style.min.css";i:112;s:29:"comments-title/editor-rtl.css";i:113;s:33:"comments-title/editor-rtl.min.css";i:114;s:25:"comments-title/editor.css";i:115;s:29:"comments-title/editor.min.css";i:116;s:23:"comments/editor-rtl.css";i:117;s:27:"comments/editor-rtl.min.css";i:118;s:19:"comments/editor.css";i:119;s:23:"comments/editor.min.css";i:120;s:22:"comments/style-rtl.css";i:121;s:26:"comments/style-rtl.min.css";i:122;s:18:"comments/style.css";i:123;s:22:"comments/style.min.css";i:124;s:20:"cover/editor-rtl.css";i:125;s:24:"cover/editor-rtl.min.css";i:126;s:16:"cover/editor.css";i:127;s:20:"cover/editor.min.css";i:128;s:19:"cover/style-rtl.css";i:129;s:23:"cover/style-rtl.min.css";i:130;s:15:"cover/style.css";i:131;s:19:"cover/style.min.css";i:132;s:22:"details/editor-rtl.css";i:133;s:26:"details/editor-rtl.min.css";i:134;s:18:"details/editor.css";i:135;s:22:"details/editor.min.css";i:136;s:21:"details/style-rtl.css";i:137;s:25:"details/style-rtl.min.css";i:138;s:17:"details/style.css";i:139;s:21:"details/style.min.css";i:140;s:20:"embed/editor-rtl.css";i:141;s:24:"embed/editor-rtl.min.css";i:142;s:16:"embed/editor.css";i:143;s:20:"embed/editor.min.css";i:144;s:19:"embed/style-rtl.css";i:145;s:23:"embed/style-rtl.min.css";i:146;s:15:"embed/style.css";i:147;s:19:"embed/style.min.css";i:148;s:19:"embed/theme-rtl.css";i:149;s:23:"embed/theme-rtl.min.css";i:150;s:15:"embed/theme.css";i:151;s:19:"embed/theme.min.css";i:152;s:19:"file/editor-rtl.css";i:153;s:23:"file/editor-rtl.min.css";i:154;s:15:"file/editor.css";i:155;s:19:"file/editor.min.css";i:156;s:18:"file/style-rtl.css";i:157;s:22:"file/style-rtl.min.css";i:158;s:14:"file/style.css";i:159;s:18:"file/style.min.css";i:160;s:23:"footnotes/style-rtl.css";i:161;s:27:"footnotes/style-rtl.min.css";i:162;s:19:"footnotes/style.css";i:163;s:23:"footnotes/style.min.css";i:164;s:23:"freeform/editor-rtl.css";i:165;s:27:"freeform/editor-rtl.min.css";i:166;s:19:"freeform/editor.css";i:167;s:23:"freeform/editor.min.css";i:168;s:22:"gallery/editor-rtl.css";i:169;s:26:"gallery/editor-rtl.min.css";i:170;s:18:"gallery/editor.css";i:171;s:22:"gallery/editor.min.css";i:172;s:21:"gallery/style-rtl.css";i:173;s:25:"gallery/style-rtl.min.css";i:174;s:17:"gallery/style.css";i:175;s:21:"gallery/style.min.css";i:176;s:21:"gallery/theme-rtl.css";i:177;s:25:"gallery/theme-rtl.min.css";i:178;s:17:"gallery/theme.css";i:179;s:21:"gallery/theme.min.css";i:180;s:20:"group/editor-rtl.css";i:181;s:24:"group/editor-rtl.min.css";i:182;s:16:"group/editor.css";i:183;s:20:"group/editor.min.css";i:184;s:19:"group/style-rtl.css";i:185;s:23:"group/style-rtl.min.css";i:186;s:15:"group/style.css";i:187;s:19:"group/style.min.css";i:188;s:19:"group/theme-rtl.css";i:189;s:23:"group/theme-rtl.min.css";i:190;s:15:"group/theme.css";i:191;s:19:"group/theme.min.css";i:192;s:21:"heading/style-rtl.css";i:193;s:25:"heading/style-rtl.min.css";i:194;s:17:"heading/style.css";i:195;s:21:"heading/style.min.css";i:196;s:19:"html/editor-rtl.css";i:197;s:23:"html/editor-rtl.min.css";i:198;s:15:"html/editor.css";i:199;s:19:"html/editor.min.css";i:200;s:20:"image/editor-rtl.css";i:201;s:24:"image/editor-rtl.min.css";i:202;s:16:"image/editor.css";i:203;s:20:"image/editor.min.css";i:204;s:19:"image/style-rtl.css";i:205;s:23:"image/style-rtl.min.css";i:206;s:15:"image/style.css";i:207;s:19:"image/style.min.css";i:208;s:19:"image/theme-rtl.css";i:209;s:23:"image/theme-rtl.min.css";i:210;s:15:"image/theme.css";i:211;s:19:"image/theme.min.css";i:212;s:29:"latest-comments/style-rtl.css";i:213;s:33:"latest-comments/style-rtl.min.css";i:214;s:25:"latest-comments/style.css";i:215;s:29:"latest-comments/style.min.css";i:216;s:27:"latest-posts/editor-rtl.css";i:217;s:31:"latest-posts/editor-rtl.min.css";i:218;s:23:"latest-posts/editor.css";i:219;s:27:"latest-posts/editor.min.css";i:220;s:26:"latest-posts/style-rtl.css";i:221;s:30:"latest-posts/style-rtl.min.css";i:222;s:22:"latest-posts/style.css";i:223;s:26:"latest-posts/style.min.css";i:224;s:18:"list/style-rtl.css";i:225;s:22:"list/style-rtl.min.css";i:226;s:14:"list/style.css";i:227;s:18:"list/style.min.css";i:228;s:22:"loginout/style-rtl.css";i:229;s:26:"loginout/style-rtl.min.css";i:230;s:18:"loginout/style.css";i:231;s:22:"loginout/style.min.css";i:232;s:25:"media-text/editor-rtl.css";i:233;s:29:"media-text/editor-rtl.min.css";i:234;s:21:"media-text/editor.css";i:235;s:25:"media-text/editor.min.css";i:236;s:24:"media-text/style-rtl.css";i:237;s:28:"media-text/style-rtl.min.css";i:238;s:20:"media-text/style.css";i:239;s:24:"media-text/style.min.css";i:240;s:19:"more/editor-rtl.css";i:241;s:23:"more/editor-rtl.min.css";i:242;s:15:"more/editor.css";i:243;s:19:"more/editor.min.css";i:244;s:30:"navigation-link/editor-rtl.css";i:245;s:34:"navigation-link/editor-rtl.min.css";i:246;s:26:"navigation-link/editor.css";i:247;s:30:"navigation-link/editor.min.css";i:248;s:29:"navigation-link/style-rtl.css";i:249;s:33:"navigation-link/style-rtl.min.css";i:250;s:25:"navigation-link/style.css";i:251;s:29:"navigation-link/style.min.css";i:252;s:33:"navigation-submenu/editor-rtl.css";i:253;s:37:"navigation-submenu/editor-rtl.min.css";i:254;s:29:"navigation-submenu/editor.css";i:255;s:33:"navigation-submenu/editor.min.css";i:256;s:25:"navigation/editor-rtl.css";i:257;s:29:"navigation/editor-rtl.min.css";i:258;s:21:"navigation/editor.css";i:259;s:25:"navigation/editor.min.css";i:260;s:24:"navigation/style-rtl.css";i:261;s:28:"navigation/style-rtl.min.css";i:262;s:20:"navigation/style.css";i:263;s:24:"navigation/style.min.css";i:264;s:23:"nextpage/editor-rtl.css";i:265;s:27:"nextpage/editor-rtl.min.css";i:266;s:19:"nextpage/editor.css";i:267;s:23:"nextpage/editor.min.css";i:268;s:24:"page-list/editor-rtl.css";i:269;s:28:"page-list/editor-rtl.min.css";i:270;s:20:"page-list/editor.css";i:271;s:24:"page-list/editor.min.css";i:272;s:23:"page-list/style-rtl.css";i:273;s:27:"page-list/style-rtl.min.css";i:274;s:19:"page-list/style.css";i:275;s:23:"page-list/style.min.css";i:276;s:24:"paragraph/editor-rtl.css";i:277;s:28:"paragraph/editor-rtl.min.css";i:278;s:20:"paragraph/editor.css";i:279;s:24:"paragraph/editor.min.css";i:280;s:23:"paragraph/style-rtl.css";i:281;s:27:"paragraph/style-rtl.min.css";i:282;s:19:"paragraph/style.css";i:283;s:23:"paragraph/style.min.css";i:284;s:35:"post-author-biography/style-rtl.css";i:285;s:39:"post-author-biography/style-rtl.min.css";i:286;s:31:"post-author-biography/style.css";i:287;s:35:"post-author-biography/style.min.css";i:288;s:30:"post-author-name/style-rtl.css";i:289;s:34:"post-author-name/style-rtl.min.css";i:290;s:26:"post-author-name/style.css";i:291;s:30:"post-author-name/style.min.css";i:292;s:26:"post-author/editor-rtl.css";i:293;s:30:"post-author/editor-rtl.min.css";i:294;s:22:"post-author/editor.css";i:295;s:26:"post-author/editor.min.css";i:296;s:25:"post-author/style-rtl.css";i:297;s:29:"post-author/style-rtl.min.css";i:298;s:21:"post-author/style.css";i:299;s:25:"post-author/style.min.css";i:300;s:33:"post-comments-form/editor-rtl.css";i:301;s:37:"post-comments-form/editor-rtl.min.css";i:302;s:29:"post-comments-form/editor.css";i:303;s:33:"post-comments-form/editor.min.css";i:304;s:32:"post-comments-form/style-rtl.css";i:305;s:36:"post-comments-form/style-rtl.min.css";i:306;s:28:"post-comments-form/style.css";i:307;s:32:"post-comments-form/style.min.css";i:308;s:26:"post-content/style-rtl.css";i:309;s:30:"post-content/style-rtl.min.css";i:310;s:22:"post-content/style.css";i:311;s:26:"post-content/style.min.css";i:312;s:23:"post-date/style-rtl.css";i:313;s:27:"post-date/style-rtl.min.css";i:314;s:19:"post-date/style.css";i:315;s:23:"post-date/style.min.css";i:316;s:27:"post-excerpt/editor-rtl.css";i:317;s:31:"post-excerpt/editor-rtl.min.css";i:318;s:23:"post-excerpt/editor.css";i:319;s:27:"post-excerpt/editor.min.css";i:320;s:26:"post-excerpt/style-rtl.css";i:321;s:30:"post-excerpt/style-rtl.min.css";i:322;s:22:"post-excerpt/style.css";i:323;s:26:"post-excerpt/style.min.css";i:324;s:34:"post-featured-image/editor-rtl.css";i:325;s:38:"post-featured-image/editor-rtl.min.css";i:326;s:30:"post-featured-image/editor.css";i:327;s:34:"post-featured-image/editor.min.css";i:328;s:33:"post-featured-image/style-rtl.css";i:329;s:37:"post-featured-image/style-rtl.min.css";i:330;s:29:"post-featured-image/style.css";i:331;s:33:"post-featured-image/style.min.css";i:332;s:34:"post-navigation-link/style-rtl.css";i:333;s:38:"post-navigation-link/style-rtl.min.css";i:334;s:30:"post-navigation-link/style.css";i:335;s:34:"post-navigation-link/style.min.css";i:336;s:27:"post-template/style-rtl.css";i:337;s:31:"post-template/style-rtl.min.css";i:338;s:23:"post-template/style.css";i:339;s:27:"post-template/style.min.css";i:340;s:24:"post-terms/style-rtl.css";i:341;s:28:"post-terms/style-rtl.min.css";i:342;s:20:"post-terms/style.css";i:343;s:24:"post-terms/style.min.css";i:344;s:24:"post-title/style-rtl.css";i:345;s:28:"post-title/style-rtl.min.css";i:346;s:20:"post-title/style.css";i:347;s:24:"post-title/style.min.css";i:348;s:26:"preformatted/style-rtl.css";i:349;s:30:"preformatted/style-rtl.min.css";i:350;s:22:"preformatted/style.css";i:351;s:26:"preformatted/style.min.css";i:352;s:24:"pullquote/editor-rtl.css";i:353;s:28:"pullquote/editor-rtl.min.css";i:354;s:20:"pullquote/editor.css";i:355;s:24:"pullquote/editor.min.css";i:356;s:23:"pullquote/style-rtl.css";i:357;s:27:"pullquote/style-rtl.min.css";i:358;s:19:"pullquote/style.css";i:359;s:23:"pullquote/style.min.css";i:360;s:23:"pullquote/theme-rtl.css";i:361;s:27:"pullquote/theme-rtl.min.css";i:362;s:19:"pullquote/theme.css";i:363;s:23:"pullquote/theme.min.css";i:364;s:39:"query-pagination-numbers/editor-rtl.css";i:365;s:43:"query-pagination-numbers/editor-rtl.min.css";i:366;s:35:"query-pagination-numbers/editor.css";i:367;s:39:"query-pagination-numbers/editor.min.css";i:368;s:31:"query-pagination/editor-rtl.css";i:369;s:35:"query-pagination/editor-rtl.min.css";i:370;s:27:"query-pagination/editor.css";i:371;s:31:"query-pagination/editor.min.css";i:372;s:30:"query-pagination/style-rtl.css";i:373;s:34:"query-pagination/style-rtl.min.css";i:374;s:26:"query-pagination/style.css";i:375;s:30:"query-pagination/style.min.css";i:376;s:25:"query-title/style-rtl.css";i:377;s:29:"query-title/style-rtl.min.css";i:378;s:21:"query-title/style.css";i:379;s:25:"query-title/style.min.css";i:380;s:25:"query-total/style-rtl.css";i:381;s:29:"query-total/style-rtl.min.css";i:382;s:21:"query-total/style.css";i:383;s:25:"query-total/style.min.css";i:384;s:20:"query/editor-rtl.css";i:385;s:24:"query/editor-rtl.min.css";i:386;s:16:"query/editor.css";i:387;s:20:"query/editor.min.css";i:388;s:19:"quote/style-rtl.css";i:389;s:23:"quote/style-rtl.min.css";i:390;s:15:"quote/style.css";i:391;s:19:"quote/style.min.css";i:392;s:19:"quote/theme-rtl.css";i:393;s:23:"quote/theme-rtl.min.css";i:394;s:15:"quote/theme.css";i:395;s:19:"quote/theme.min.css";i:396;s:23:"read-more/style-rtl.css";i:397;s:27:"read-more/style-rtl.min.css";i:398;s:19:"read-more/style.css";i:399;s:23:"read-more/style.min.css";i:400;s:18:"rss/editor-rtl.css";i:401;s:22:"rss/editor-rtl.min.css";i:402;s:14:"rss/editor.css";i:403;s:18:"rss/editor.min.css";i:404;s:17:"rss/style-rtl.css";i:405;s:21:"rss/style-rtl.min.css";i:406;s:13:"rss/style.css";i:407;s:17:"rss/style.min.css";i:408;s:21:"search/editor-rtl.css";i:409;s:25:"search/editor-rtl.min.css";i:410;s:17:"search/editor.css";i:411;s:21:"search/editor.min.css";i:412;s:20:"search/style-rtl.css";i:413;s:24:"search/style-rtl.min.css";i:414;s:16:"search/style.css";i:415;s:20:"search/style.min.css";i:416;s:20:"search/theme-rtl.css";i:417;s:24:"search/theme-rtl.min.css";i:418;s:16:"search/theme.css";i:419;s:20:"search/theme.min.css";i:420;s:24:"separator/editor-rtl.css";i:421;s:28:"separator/editor-rtl.min.css";i:422;s:20:"separator/editor.css";i:423;s:24:"separator/editor.min.css";i:424;s:23:"separator/style-rtl.css";i:425;s:27:"separator/style-rtl.min.css";i:426;s:19:"separator/style.css";i:427;s:23:"separator/style.min.css";i:428;s:23:"separator/theme-rtl.css";i:429;s:27:"separator/theme-rtl.min.css";i:430;s:19:"separator/theme.css";i:431;s:23:"separator/theme.min.css";i:432;s:24:"shortcode/editor-rtl.css";i:433;s:28:"shortcode/editor-rtl.min.css";i:434;s:20:"shortcode/editor.css";i:435;s:24:"shortcode/editor.min.css";i:436;s:24:"site-logo/editor-rtl.css";i:437;s:28:"site-logo/editor-rtl.min.css";i:438;s:20:"site-logo/editor.css";i:439;s:24:"site-logo/editor.min.css";i:440;s:23:"site-logo/style-rtl.css";i:441;s:27:"site-logo/style-rtl.min.css";i:442;s:19:"site-logo/style.css";i:443;s:23:"site-logo/style.min.css";i:444;s:27:"site-tagline/editor-rtl.css";i:445;s:31:"site-tagline/editor-rtl.min.css";i:446;s:23:"site-tagline/editor.css";i:447;s:27:"site-tagline/editor.min.css";i:448;s:26:"site-tagline/style-rtl.css";i:449;s:30:"site-tagline/style-rtl.min.css";i:450;s:22:"site-tagline/style.css";i:451;s:26:"site-tagline/style.min.css";i:452;s:25:"site-title/editor-rtl.css";i:453;s:29:"site-title/editor-rtl.min.css";i:454;s:21:"site-title/editor.css";i:455;s:25:"site-title/editor.min.css";i:456;s:24:"site-title/style-rtl.css";i:457;s:28:"site-title/style-rtl.min.css";i:458;s:20:"site-title/style.css";i:459;s:24:"site-title/style.min.css";i:460;s:26:"social-link/editor-rtl.css";i:461;s:30:"social-link/editor-rtl.min.css";i:462;s:22:"social-link/editor.css";i:463;s:26:"social-link/editor.min.css";i:464;s:27:"social-links/editor-rtl.css";i:465;s:31:"social-links/editor-rtl.min.css";i:466;s:23:"social-links/editor.css";i:467;s:27:"social-links/editor.min.css";i:468;s:26:"social-links/style-rtl.css";i:469;s:30:"social-links/style-rtl.min.css";i:470;s:22:"social-links/style.css";i:471;s:26:"social-links/style.min.css";i:472;s:21:"spacer/editor-rtl.css";i:473;s:25:"spacer/editor-rtl.min.css";i:474;s:17:"spacer/editor.css";i:475;s:21:"spacer/editor.min.css";i:476;s:20:"spacer/style-rtl.css";i:477;s:24:"spacer/style-rtl.min.css";i:478;s:16:"spacer/style.css";i:479;s:20:"spacer/style.min.css";i:480;s:20:"table/editor-rtl.css";i:481;s:24:"table/editor-rtl.min.css";i:482;s:16:"table/editor.css";i:483;s:20:"table/editor.min.css";i:484;s:19:"table/style-rtl.css";i:485;s:23:"table/style-rtl.min.css";i:486;s:15:"table/style.css";i:487;s:19:"table/style.min.css";i:488;s:19:"table/theme-rtl.css";i:489;s:23:"table/theme-rtl.min.css";i:490;s:15:"table/theme.css";i:491;s:19:"table/theme.min.css";i:492;s:24:"tag-cloud/editor-rtl.css";i:493;s:28:"tag-cloud/editor-rtl.min.css";i:494;s:20:"tag-cloud/editor.css";i:495;s:24:"tag-cloud/editor.min.css";i:496;s:23:"tag-cloud/style-rtl.css";i:497;s:27:"tag-cloud/style-rtl.min.css";i:498;s:19:"tag-cloud/style.css";i:499;s:23:"tag-cloud/style.min.css";i:500;s:28:"template-part/editor-rtl.css";i:501;s:32:"template-part/editor-rtl.min.css";i:502;s:24:"template-part/editor.css";i:503;s:28:"template-part/editor.min.css";i:504;s:27:"template-part/theme-rtl.css";i:505;s:31:"template-part/theme-rtl.min.css";i:506;s:23:"template-part/theme.css";i:507;s:27:"template-part/theme.min.css";i:508;s:30:"term-description/style-rtl.css";i:509;s:34:"term-description/style-rtl.min.css";i:510;s:26:"term-description/style.css";i:511;s:30:"term-description/style.min.css";i:512;s:27:"text-columns/editor-rtl.css";i:513;s:31:"text-columns/editor-rtl.min.css";i:514;s:23:"text-columns/editor.css";i:515;s:27:"text-columns/editor.min.css";i:516;s:26:"text-columns/style-rtl.css";i:517;s:30:"text-columns/style-rtl.min.css";i:518;s:22:"text-columns/style.css";i:519;s:26:"text-columns/style.min.css";i:520;s:19:"verse/style-rtl.css";i:521;s:23:"verse/style-rtl.min.css";i:522;s:15:"verse/style.css";i:523;s:19:"verse/style.min.css";i:524;s:20:"video/editor-rtl.css";i:525;s:24:"video/editor-rtl.min.css";i:526;s:16:"video/editor.css";i:527;s:20:"video/editor.min.css";i:528;s:19:"video/style-rtl.css";i:529;s:23:"video/style-rtl.min.css";i:530;s:15:"video/style.css";i:531;s:19:"video/style.min.css";i:532;s:19:"video/theme-rtl.css";i:533;s:23:"video/theme-rtl.min.css";i:534;s:15:"video/theme.css";i:535;s:19:"video/theme.min.css";}}','on');
INSERT INTO `wp_options` VALUES (102796,'wp_calendar_block_has_published_posts','1','auto');
INSERT INTO `wp_options` VALUES (102811,'category_children','a:0:{}','auto');
INSERT INTO `wp_options` VALUES (103188,'scan_unused_files_task','a:5:{s:10:"start_time";i:1742204005;s:12:"running_time";i:1742204019;s:6:"status";s:8:"finished";s:8:"progress";i:100;s:6:"offset";i:0;}','off');
INSERT INTO `wp_options` VALUES (103189,'unused_uploads_task','a:6:{s:10:"start_time";i:1742204006;s:12:"running_time";i:1742204008;s:6:"status";s:8:"finished";s:8:"progress";i:100;s:4:"size";i:195138147;s:6:"folder";a:31:{s:7:"2024/01";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:0;}s:7:"2024/02";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:0;}s:7:"2024/03";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:21;}s:7:"2024/04";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:0;}s:7:"2024/05";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:72;}s:7:"2024/06";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:11;}s:7:"2024/07";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:5;}s:7:"2024/08";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:68;}s:7:"2024/09";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:20;}s:7:"2024/10";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:5;}s:7:"2024/11";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:31;}s:7:"2024/12";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:11;}s:6:"wpcode";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:2;}s:7:"2023/06";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:2;}s:7:"2023/04";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:20;}s:7:"2023/05";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:5;}s:7:"2023/09";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:39;}s:7:"2023/03";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:26;}s:7:"2023/11";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:5;}s:7:"2023/08";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:2;}s:7:"2023/07";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:0;}s:7:"2023/12";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:0;}s:7:"2023/10";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:5;}s:5:"smush";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:1;}s:7:"2022/11";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:4;}s:7:"2025/01";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:19;}s:7:"2025/02";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:0;}s:7:"2025/03";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:260;}s:10:"wpmc-trash";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:3;}s:12:"nginx-helper";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:1;}s:1:".";a:3:{s:8:"finished";i:1;s:6:"offset";i:0;s:5:"total";i:0;}}}','off');
INSERT INTO `wp_options` VALUES (103193,'init_isolate_task','a:5:{s:10:"start_time";i:1742204018;s:12:"running_time";i:1742204018;s:6:"status";s:7:"running";s:8:"progress";i:0;s:6:"offset";i:0;}','off');
INSERT INTO `wp_options` VALUES (117207,'_site_transient_timeout_php_check_a0b03c46dbe37253c3391e32a7bb296f','1763214827','off');
INSERT INTO `wp_options` VALUES (117208,'_site_transient_php_check_a0b03c46dbe37253c3391e32a7bb296f','a:5:{s:19:"recommended_version";s:3:"8.3";s:15:"minimum_version";s:6:"7.2.24";s:12:"is_supported";b:1;s:9:"is_secure";b:1;s:13:"is_acceptable";b:1;}','off');
INSERT INTO `wp_options` VALUES (117400,'_site_transient_timeout_theme_roots','1762931685','off');
INSERT INTO `wp_options` VALUES (117401,'_site_transient_theme_roots','a:2:{s:16:"twentytwentyfive";s:7:"/themes";s:17:"twentytwentythree";s:7:"/themes";}','off');
INSERT INTO `wp_options` VALUES (117404,'_site_transient_timeout_fs_garbage_collection','1763016295','off');
INSERT INTO `wp_options` VALUES (117405,'_site_transient_fs_garbage_collection','1','off');
INSERT INTO `wp_options` VALUES (117408,'_site_transient_timeout_fs_clone_resolution','1763016295','off');
INSERT INTO `wp_options` VALUES (117409,'_site_transient_fs_clone_resolution','1','off');
INSERT INTO `wp_options` VALUES (117410,'_site_transient_timeout_available_translations','1762940695','off');
INSERT INTO `wp_options` VALUES (117411,'_site_transient_available_translations','a:131:{s:2:"af";a:8:{s:8:"language";s:2:"af";s:7:"version";s:8:"5.8-beta";s:7:"updated";s:19:"2021-05-13 15:59:22";s:12:"english_name";s:9:"Afrikaans";s:11:"native_name";s:9:"Afrikaans";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip";s:3:"iso";a:2:{i:1;s:2:"af";i:2;s:3:"afr";}s:7:"strings";a:1:{s:8:"continue";s:10:"Gaan voort";}}s:2:"am";a:8:{s:8:"language";s:2:"am";s:7:"version";s:6:"6.0.11";s:7:"updated";s:19:"2022-09-29 20:43:49";s:12:"english_name";s:7:"Amharic";s:11:"native_name";s:12:"አማርኛ";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/6.0.11/am.zip";s:3:"iso";a:2:{i:1;s:2:"am";i:2;s:3:"amh";}s:7:"strings";a:1:{s:8:"continue";s:9:"ቀጥል";}}s:3:"arg";a:8:{s:8:"language";s:3:"arg";s:7:"version";s:8:"6.2-beta";s:7:"updated";s:19:"2022-09-22 16:46:56";s:12:"english_name";s:9:"Aragonese";s:11:"native_name";s:9:"Aragonés";s:7:"package";s:65:"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip";s:3:"iso";a:3:{i:1;s:2:"an";i:2;s:3:"arg";i:3;s:3:"arg";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continar";}}s:2:"ar";a:8:{s:8:"language";s:2:"ar";s:7:"version";s:5:"6.4.7";s:7:"updated";s:19:"2024-02-13 12:49:38";s:12:"english_name";s:6:"Arabic";s:11:"native_name";s:14:"العربية";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.4.7/ar.zip";s:3:"iso";a:2:{i:1;s:2:"ar";i:2;s:3:"ara";}s:7:"strings";a:1:{s:8:"continue";s:12:"متابعة";}}s:3:"ary";a:8:{s:8:"language";s:3:"ary";s:7:"version";s:6:"4.8.27";s:7:"updated";s:19:"2017-01-26 15:42:35";s:12:"english_name";s:15:"Moroccan Arabic";s:11:"native_name";s:31:"العربية المغربية";s:7:"package";s:63:"https://downloads.wordpress.org/translation/core/4.8.27/ary.zip";s:3:"iso";a:2:{i:1;s:2:"ar";i:3;s:3:"ary";}s:7:"strings";a:1:{s:8:"continue";s:16:"المتابعة";}}s:2:"as";a:8:{s:8:"language";s:2:"as";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-07-10 08:09:09";s:12:"english_name";s:8:"Assamese";s:11:"native_name";s:21:"অসমীয়া";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.8.3/as.zip";s:3:"iso";a:3:{i:1;s:2:"as";i:2;s:3:"asm";i:3;s:3:"asm";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:3:"azb";a:8:{s:8:"language";s:3:"azb";s:7:"version";s:5:"6.4.7";s:7:"updated";s:19:"2024-01-19 08:58:31";s:12:"english_name";s:17:"South Azerbaijani";s:11:"native_name";s:29:"گؤنئی آذربایجان";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/6.4.7/azb.zip";s:3:"iso";a:2:{i:1;s:2:"az";i:3;s:3:"azb";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:2:"az";a:8:{s:8:"language";s:2:"az";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-11-06 00:09:27";s:12:"english_name";s:11:"Azerbaijani";s:11:"native_name";s:16:"Azərbaycan dili";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/az.zip";s:3:"iso";a:2:{i:1;s:2:"az";i:2;s:3:"aze";}s:7:"strings";a:1:{s:8:"continue";s:5:"Davam";}}s:3:"bel";a:8:{s:8:"language";s:3:"bel";s:7:"version";s:6:"4.9.28";s:7:"updated";s:19:"2024-12-26 00:37:42";s:12:"english_name";s:10:"Belarusian";s:11:"native_name";s:29:"Беларуская мова";s:7:"package";s:63:"https://downloads.wordpress.org/translation/core/4.9.28/bel.zip";s:3:"iso";a:2:{i:1;s:2:"be";i:2;s:3:"bel";}s:7:"strings";a:1:{s:8:"continue";s:20:"Працягнуць";}}s:5:"bg_BG";a:8:{s:8:"language";s:5:"bg_BG";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-06-26 09:35:39";s:12:"english_name";s:9:"Bulgarian";s:11:"native_name";s:18:"Български";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/bg_BG.zip";s:3:"iso";a:2:{i:1;s:2:"bg";i:2;s:3:"bul";}s:7:"strings";a:1:{s:8:"continue";s:12:"Напред";}}s:5:"bn_BD";a:8:{s:8:"language";s:5:"bn_BD";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-11-01 16:41:58";s:12:"english_name";s:20:"Bengali (Bangladesh)";s:11:"native_name";s:15:"বাংলা";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/bn_BD.zip";s:3:"iso";a:1:{i:1;s:2:"bn";}s:7:"strings";a:1:{s:8:"continue";s:28:"চালিয়ে যান";}}s:2:"bo";a:8:{s:8:"language";s:2:"bo";s:7:"version";s:8:"5.8-beta";s:7:"updated";s:19:"2020-10-30 03:24:38";s:12:"english_name";s:7:"Tibetan";s:11:"native_name";s:21:"བོད་ཡིག";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip";s:3:"iso";a:2:{i:1;s:2:"bo";i:2;s:3:"tib";}s:7:"strings";a:1:{s:8:"continue";s:33:"མུ་མཐུད་དུ།";}}s:5:"bs_BA";a:8:{s:8:"language";s:5:"bs_BA";s:7:"version";s:5:"6.2.8";s:7:"updated";s:19:"2023-02-22 20:45:53";s:12:"english_name";s:7:"Bosnian";s:11:"native_name";s:8:"Bosanski";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.2.8/bs_BA.zip";s:3:"iso";a:2:{i:1;s:2:"bs";i:2;s:3:"bos";}s:7:"strings";a:1:{s:8:"continue";s:7:"Nastavi";}}s:2:"ca";a:8:{s:8:"language";s:2:"ca";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-11-11 22:46:35";s:12:"english_name";s:7:"Catalan";s:11:"native_name";s:7:"Català";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.8.3/ca.zip";s:3:"iso";a:2:{i:1;s:2:"ca";i:2;s:3:"cat";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continua";}}s:3:"ceb";a:8:{s:8:"language";s:3:"ceb";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-03-02 17:25:51";s:12:"english_name";s:7:"Cebuano";s:11:"native_name";s:7:"Cebuano";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip";s:3:"iso";a:2:{i:2;s:3:"ceb";i:3;s:3:"ceb";}s:7:"strings";a:1:{s:8:"continue";s:7:"Padayun";}}s:5:"cs_CZ";a:8:{s:8:"language";s:5:"cs_CZ";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-09-09 08:25:54";s:12:"english_name";s:5:"Czech";s:11:"native_name";s:9:"Čeština";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/cs_CZ.zip";s:3:"iso";a:2:{i:1;s:2:"cs";i:2;s:3:"ces";}s:7:"strings";a:1:{s:8:"continue";s:11:"Pokračovat";}}s:2:"cy";a:8:{s:8:"language";s:2:"cy";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-05 08:42:11";s:12:"english_name";s:5:"Welsh";s:11:"native_name";s:7:"Cymraeg";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.8.3/cy.zip";s:3:"iso";a:2:{i:1;s:2:"cy";i:2;s:3:"cym";}s:7:"strings";a:1:{s:8:"continue";s:6:"Parhau";}}s:5:"da_DK";a:8:{s:8:"language";s:5:"da_DK";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-11-12 03:39:15";s:12:"english_name";s:6:"Danish";s:11:"native_name";s:5:"Dansk";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/da_DK.zip";s:3:"iso";a:2:{i:1;s:2:"da";i:2;s:3:"dan";}s:7:"strings";a:1:{s:8:"continue";s:8:"Fortsæt";}}s:5:"de_CH";a:8:{s:8:"language";s:5:"de_CH";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-07-28 10:25:03";s:12:"english_name";s:20:"German (Switzerland)";s:11:"native_name";s:17:"Deutsch (Schweiz)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/de_CH.zip";s:3:"iso";a:1:{i:1;s:2:"de";}s:7:"strings";a:1:{s:8:"continue";s:6:"Weiter";}}s:5:"de_AT";a:8:{s:8:"language";s:5:"de_AT";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-23 12:02:03";s:12:"english_name";s:16:"German (Austria)";s:11:"native_name";s:21:"Deutsch (Österreich)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/de_AT.zip";s:3:"iso";a:1:{i:1;s:2:"de";}s:7:"strings";a:1:{s:8:"continue";s:6:"Weiter";}}s:5:"de_DE";a:8:{s:8:"language";s:5:"de_DE";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-11-11 20:20:12";s:12:"english_name";s:6:"German";s:11:"native_name";s:7:"Deutsch";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/de_DE.zip";s:3:"iso";a:1:{i:1;s:2:"de";}s:7:"strings";a:1:{s:8:"continue";s:6:"Weiter";}}s:12:"de_DE_formal";a:8:{s:8:"language";s:12:"de_DE_formal";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-11-11 20:20:46";s:12:"english_name";s:15:"German (Formal)";s:11:"native_name";s:13:"Deutsch (Sie)";s:7:"package";s:71:"https://downloads.wordpress.org/translation/core/6.8.3/de_DE_formal.zip";s:3:"iso";a:1:{i:1;s:2:"de";}s:7:"strings";a:1:{s:8:"continue";s:6:"Weiter";}}s:14:"de_CH_informal";a:8:{s:8:"language";s:14:"de_CH_informal";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-07-28 10:25:24";s:12:"english_name";s:30:"German (Switzerland, Informal)";s:11:"native_name";s:21:"Deutsch (Schweiz, Du)";s:7:"package";s:73:"https://downloads.wordpress.org/translation/core/6.8.3/de_CH_informal.zip";s:3:"iso";a:1:{i:1;s:2:"de";}s:7:"strings";a:1:{s:8:"continue";s:6:"Weiter";}}s:3:"dsb";a:8:{s:8:"language";s:3:"dsb";s:7:"version";s:5:"6.2.8";s:7:"updated";s:19:"2022-07-16 12:13:09";s:12:"english_name";s:13:"Lower Sorbian";s:11:"native_name";s:16:"Dolnoserbšćina";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/6.2.8/dsb.zip";s:3:"iso";a:2:{i:2;s:3:"dsb";i:3;s:3:"dsb";}s:7:"strings";a:1:{s:8:"continue";s:5:"Dalej";}}s:3:"dzo";a:8:{s:8:"language";s:3:"dzo";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-06-29 08:59:03";s:12:"english_name";s:8:"Dzongkha";s:11:"native_name";s:18:"རྫོང་ཁ";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip";s:3:"iso";a:2:{i:1;s:2:"dz";i:2;s:3:"dzo";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:2:"el";a:8:{s:8:"language";s:2:"el";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-11-04 22:35:01";s:12:"english_name";s:5:"Greek";s:11:"native_name";s:16:"Ελληνικά";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.8.3/el.zip";s:3:"iso";a:2:{i:1;s:2:"el";i:2;s:3:"ell";}s:7:"strings";a:1:{s:8:"continue";s:16:"Συνέχεια";}}s:5:"en_ZA";a:8:{s:8:"language";s:5:"en_ZA";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-07-29 13:22:09";s:12:"english_name";s:22:"English (South Africa)";s:11:"native_name";s:22:"English (South Africa)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/en_ZA.zip";s:3:"iso";a:3:{i:1;s:2:"en";i:2;s:3:"eng";i:3;s:3:"eng";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:5:"en_GB";a:8:{s:8:"language";s:5:"en_GB";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-08 12:55:00";s:12:"english_name";s:12:"English (UK)";s:11:"native_name";s:12:"English (UK)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/en_GB.zip";s:3:"iso";a:3:{i:1;s:2:"en";i:2;s:3:"eng";i:3;s:3:"eng";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:5:"en_NZ";a:8:{s:8:"language";s:5:"en_NZ";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-05-22 11:56:25";s:12:"english_name";s:21:"English (New Zealand)";s:11:"native_name";s:21:"English (New Zealand)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/en_NZ.zip";s:3:"iso";a:3:{i:1;s:2:"en";i:2;s:3:"eng";i:3;s:3:"eng";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:5:"en_CA";a:8:{s:8:"language";s:5:"en_CA";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-21 17:41:39";s:12:"english_name";s:16:"English (Canada)";s:11:"native_name";s:16:"English (Canada)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/en_CA.zip";s:3:"iso";a:3:{i:1;s:2:"en";i:2;s:3:"eng";i:3;s:3:"eng";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:5:"en_AU";a:8:{s:8:"language";s:5:"en_AU";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-08-19 23:02:24";s:12:"english_name";s:19:"English (Australia)";s:11:"native_name";s:19:"English (Australia)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/en_AU.zip";s:3:"iso";a:3:{i:1;s:2:"en";i:2;s:3:"eng";i:3;s:3:"eng";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:2:"eo";a:8:{s:8:"language";s:2:"eo";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-08-19 08:40:47";s:12:"english_name";s:9:"Esperanto";s:11:"native_name";s:9:"Esperanto";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.8.3/eo.zip";s:3:"iso";a:2:{i:1;s:2:"eo";i:2;s:3:"epo";}s:7:"strings";a:1:{s:8:"continue";s:8:"Daŭrigi";}}s:5:"es_PE";a:8:{s:8:"language";s:5:"es_PE";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2024-10-16 21:04:12";s:12:"english_name";s:14:"Spanish (Peru)";s:11:"native_name";s:17:"Español de Perú";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/es_PE.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_CO";a:8:{s:8:"language";s:5:"es_CO";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-09 03:23:24";s:12:"english_name";s:18:"Spanish (Colombia)";s:11:"native_name";s:20:"Español de Colombia";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/es_CO.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_ES";a:8:{s:8:"language";s:5:"es_ES";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-11-02 11:18:01";s:12:"english_name";s:15:"Spanish (Spain)";s:11:"native_name";s:8:"Español";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/es_ES.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_VE";a:8:{s:8:"language";s:5:"es_VE";s:7:"version";s:5:"6.4.7";s:7:"updated";s:19:"2023-10-16 16:00:04";s:12:"english_name";s:19:"Spanish (Venezuela)";s:11:"native_name";s:21:"Español de Venezuela";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.4.7/es_VE.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_EC";a:8:{s:8:"language";s:5:"es_EC";s:7:"version";s:5:"6.2.8";s:7:"updated";s:19:"2023-04-21 13:32:10";s:12:"english_name";s:17:"Spanish (Ecuador)";s:11:"native_name";s:19:"Español de Ecuador";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.2.8/es_EC.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_DO";a:8:{s:8:"language";s:5:"es_DO";s:7:"version";s:6:"5.8.12";s:7:"updated";s:19:"2021-10-08 14:32:50";s:12:"english_name";s:28:"Spanish (Dominican Republic)";s:11:"native_name";s:33:"Español de República Dominicana";s:7:"package";s:65:"https://downloads.wordpress.org/translation/core/5.8.12/es_DO.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_UY";a:8:{s:8:"language";s:5:"es_UY";s:7:"version";s:8:"5.8-beta";s:7:"updated";s:19:"2021-03-31 18:33:26";s:12:"english_name";s:17:"Spanish (Uruguay)";s:11:"native_name";s:19:"Español de Uruguay";s:7:"package";s:67:"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_PR";a:8:{s:8:"language";s:5:"es_PR";s:7:"version";s:6:"5.4.18";s:7:"updated";s:19:"2020-04-29 15:36:59";s:12:"english_name";s:21:"Spanish (Puerto Rico)";s:11:"native_name";s:23:"Español de Puerto Rico";s:7:"package";s:65:"https://downloads.wordpress.org/translation/core/5.4.18/es_PR.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_GT";a:8:{s:8:"language";s:5:"es_GT";s:7:"version";s:6:"5.2.23";s:7:"updated";s:19:"2019-03-02 06:35:01";s:12:"english_name";s:19:"Spanish (Guatemala)";s:11:"native_name";s:21:"Español de Guatemala";s:7:"package";s:65:"https://downloads.wordpress.org/translation/core/5.2.23/es_GT.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_MX";a:8:{s:8:"language";s:5:"es_MX";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-09-30 21:17:40";s:12:"english_name";s:16:"Spanish (Mexico)";s:11:"native_name";s:19:"Español de México";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/es_MX.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_CR";a:8:{s:8:"language";s:5:"es_CR";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-01 22:54:47";s:12:"english_name";s:20:"Spanish (Costa Rica)";s:11:"native_name";s:22:"Español de Costa Rica";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/es_CR.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_CL";a:8:{s:8:"language";s:5:"es_CL";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-02 21:15:15";s:12:"english_name";s:15:"Spanish (Chile)";s:11:"native_name";s:17:"Español de Chile";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/es_CL.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_AR";a:8:{s:8:"language";s:5:"es_AR";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-08 01:26:01";s:12:"english_name";s:19:"Spanish (Argentina)";s:11:"native_name";s:21:"Español de Argentina";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/es_AR.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:2:"et";a:8:{s:8:"language";s:2:"et";s:7:"version";s:5:"6.5.5";s:7:"updated";s:19:"2024-06-06 09:50:37";s:12:"english_name";s:8:"Estonian";s:11:"native_name";s:5:"Eesti";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.5.5/et.zip";s:3:"iso";a:2:{i:1;s:2:"et";i:2;s:3:"est";}s:7:"strings";a:1:{s:8:"continue";s:6:"Jätka";}}s:2:"eu";a:8:{s:8:"language";s:2:"eu";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-11-05 21:53:17";s:12:"english_name";s:6:"Basque";s:11:"native_name";s:7:"Euskara";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.8.3/eu.zip";s:3:"iso";a:2:{i:1;s:2:"eu";i:2;s:3:"eus";}s:7:"strings";a:1:{s:8:"continue";s:8:"Jarraitu";}}s:5:"fa_AF";a:8:{s:8:"language";s:5:"fa_AF";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-02-14 17:29:08";s:12:"english_name";s:21:"Persian (Afghanistan)";s:11:"native_name";s:31:"(فارسی (افغانستان";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/fa_AF.zip";s:3:"iso";a:2:{i:1;s:2:"fa";i:2;s:3:"fas";}s:7:"strings";a:1:{s:8:"continue";s:10:"ادامه";}}s:5:"fa_IR";a:8:{s:8:"language";s:5:"fa_IR";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-02 18:18:37";s:12:"english_name";s:7:"Persian";s:11:"native_name";s:10:"فارسی";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/fa_IR.zip";s:3:"iso";a:2:{i:1;s:2:"fa";i:2;s:3:"fas";}s:7:"strings";a:1:{s:8:"continue";s:10:"ادامه";}}s:2:"fi";a:8:{s:8:"language";s:2:"fi";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-01 04:49:09";s:12:"english_name";s:7:"Finnish";s:11:"native_name";s:5:"Suomi";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.8.3/fi.zip";s:3:"iso";a:2:{i:1;s:2:"fi";i:2;s:3:"fin";}s:7:"strings";a:1:{s:8:"continue";s:5:"Jatka";}}s:5:"fr_CA";a:8:{s:8:"language";s:5:"fr_CA";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-09-25 05:20:17";s:12:"english_name";s:15:"French (Canada)";s:11:"native_name";s:19:"Français du Canada";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/fr_CA.zip";s:3:"iso";a:2:{i:1;s:2:"fr";i:2;s:3:"fra";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuer";}}s:5:"fr_FR";a:8:{s:8:"language";s:5:"fr_FR";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-11-04 16:55:42";s:12:"english_name";s:15:"French (France)";s:11:"native_name";s:9:"Français";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/fr_FR.zip";s:3:"iso";a:1:{i:1;s:2:"fr";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuer";}}s:5:"fr_BE";a:8:{s:8:"language";s:5:"fr_BE";s:7:"version";s:5:"6.5.7";s:7:"updated";s:19:"2024-02-01 23:56:53";s:12:"english_name";s:16:"French (Belgium)";s:11:"native_name";s:21:"Français de Belgique";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.5.7/fr_BE.zip";s:3:"iso";a:2:{i:1;s:2:"fr";i:2;s:3:"fra";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuer";}}s:3:"fur";a:8:{s:8:"language";s:3:"fur";s:7:"version";s:6:"4.8.27";s:7:"updated";s:19:"2023-04-30 13:56:46";s:12:"english_name";s:8:"Friulian";s:11:"native_name";s:8:"Friulian";s:7:"package";s:63:"https://downloads.wordpress.org/translation/core/4.8.27/fur.zip";s:3:"iso";a:2:{i:2;s:3:"fur";i:3;s:3:"fur";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:2:"fy";a:8:{s:8:"language";s:2:"fy";s:7:"version";s:5:"6.2.8";s:7:"updated";s:19:"2025-10-21 16:35:04";s:12:"english_name";s:7:"Frisian";s:11:"native_name";s:5:"Frysk";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.2.8/fy.zip";s:3:"iso";a:2:{i:1;s:2:"fy";i:2;s:3:"fry";}s:7:"strings";a:1:{s:8:"continue";s:9:"Trochgean";}}s:2:"gd";a:8:{s:8:"language";s:2:"gd";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-08-23 17:41:37";s:12:"english_name";s:15:"Scottish Gaelic";s:11:"native_name";s:9:"Gàidhlig";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip";s:3:"iso";a:3:{i:1;s:2:"gd";i:2;s:3:"gla";i:3;s:3:"gla";}s:7:"strings";a:1:{s:8:"continue";s:15:"Lean air adhart";}}s:5:"gl_ES";a:8:{s:8:"language";s:5:"gl_ES";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-29 21:50:08";s:12:"english_name";s:8:"Galician";s:11:"native_name";s:6:"Galego";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/gl_ES.zip";s:3:"iso";a:2:{i:1;s:2:"gl";i:2;s:3:"glg";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:2:"gu";a:8:{s:8:"language";s:2:"gu";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-08-29 04:27:18";s:12:"english_name";s:8:"Gujarati";s:11:"native_name";s:21:"ગુજરાતી";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.8.3/gu.zip";s:3:"iso";a:2:{i:1;s:2:"gu";i:2;s:3:"guj";}s:7:"strings";a:1:{s:8:"continue";s:25:"ચાલુ રાખો";}}s:3:"haz";a:8:{s:8:"language";s:3:"haz";s:7:"version";s:6:"4.4.34";s:7:"updated";s:19:"2015-12-05 00:59:09";s:12:"english_name";s:8:"Hazaragi";s:11:"native_name";s:15:"هزاره گی";s:7:"package";s:63:"https://downloads.wordpress.org/translation/core/4.4.34/haz.zip";s:3:"iso";a:1:{i:3;s:3:"haz";}s:7:"strings";a:1:{s:8:"continue";s:10:"ادامه";}}s:5:"he_IL";a:8:{s:8:"language";s:5:"he_IL";s:7:"version";s:5:"6.2.8";s:7:"updated";s:19:"2024-05-04 18:39:24";s:12:"english_name";s:6:"Hebrew";s:11:"native_name";s:16:"עִבְרִית";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.2.8/he_IL.zip";s:3:"iso";a:1:{i:1;s:2:"he";}s:7:"strings";a:1:{s:8:"continue";s:8:"המשך";}}s:5:"hi_IN";a:8:{s:8:"language";s:5:"hi_IN";s:7:"version";s:5:"6.4.7";s:7:"updated";s:19:"2025-02-06 05:17:11";s:12:"english_name";s:5:"Hindi";s:11:"native_name";s:18:"हिन्दी";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.4.7/hi_IN.zip";s:3:"iso";a:2:{i:1;s:2:"hi";i:2;s:3:"hin";}s:7:"strings";a:1:{s:8:"continue";s:25:"जारी रखें";}}s:2:"hr";a:8:{s:8:"language";s:2:"hr";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-18 08:52:05";s:12:"english_name";s:8:"Croatian";s:11:"native_name";s:8:"Hrvatski";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.8.3/hr.zip";s:3:"iso";a:2:{i:1;s:2:"hr";i:2;s:3:"hrv";}s:7:"strings";a:1:{s:8:"continue";s:7:"Nastavi";}}s:3:"hsb";a:8:{s:8:"language";s:3:"hsb";s:7:"version";s:5:"6.2.8";s:7:"updated";s:19:"2023-02-22 17:37:32";s:12:"english_name";s:13:"Upper Sorbian";s:11:"native_name";s:17:"Hornjoserbšćina";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/6.2.8/hsb.zip";s:3:"iso";a:2:{i:2;s:3:"hsb";i:3;s:3:"hsb";}s:7:"strings";a:1:{s:8:"continue";s:4:"Dale";}}s:5:"hu_HU";a:8:{s:8:"language";s:5:"hu_HU";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-18 06:36:37";s:12:"english_name";s:9:"Hungarian";s:11:"native_name";s:6:"Magyar";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/hu_HU.zip";s:3:"iso";a:2:{i:1;s:2:"hu";i:2;s:3:"hun";}s:7:"strings";a:1:{s:8:"continue";s:10:"Folytatás";}}s:2:"hy";a:8:{s:8:"language";s:2:"hy";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-12-03 16:21:10";s:12:"english_name";s:8:"Armenian";s:11:"native_name";s:14:"Հայերեն";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip";s:3:"iso";a:2:{i:1;s:2:"hy";i:2;s:3:"hye";}s:7:"strings";a:1:{s:8:"continue";s:20:"Շարունակել";}}s:5:"id_ID";a:8:{s:8:"language";s:5:"id_ID";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-23 03:46:40";s:12:"english_name";s:10:"Indonesian";s:11:"native_name";s:16:"Bahasa Indonesia";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/id_ID.zip";s:3:"iso";a:2:{i:1;s:2:"id";i:2;s:3:"ind";}s:7:"strings";a:1:{s:8:"continue";s:9:"Lanjutkan";}}s:5:"is_IS";a:8:{s:8:"language";s:5:"is_IS";s:7:"version";s:6:"4.9.28";s:7:"updated";s:19:"2018-12-11 10:40:02";s:12:"english_name";s:9:"Icelandic";s:11:"native_name";s:9:"Íslenska";s:7:"package";s:65:"https://downloads.wordpress.org/translation/core/4.9.28/is_IS.zip";s:3:"iso";a:2:{i:1;s:2:"is";i:2;s:3:"isl";}s:7:"strings";a:1:{s:8:"continue";s:6:"Áfram";}}s:5:"it_IT";a:8:{s:8:"language";s:5:"it_IT";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-14 17:47:58";s:12:"english_name";s:7:"Italian";s:11:"native_name";s:8:"Italiano";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/it_IT.zip";s:3:"iso";a:2:{i:1;s:2:"it";i:2;s:3:"ita";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continua";}}s:2:"ja";a:8:{s:8:"language";s:2:"ja";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-03 12:44:05";s:12:"english_name";s:8:"Japanese";s:11:"native_name";s:9:"日本語";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.8.3/ja.zip";s:3:"iso";a:1:{i:1;s:2:"ja";}s:7:"strings";a:1:{s:8:"continue";s:6:"次へ";}}s:5:"jv_ID";a:8:{s:8:"language";s:5:"jv_ID";s:7:"version";s:6:"4.9.28";s:7:"updated";s:19:"2019-02-16 23:58:56";s:12:"english_name";s:8:"Javanese";s:11:"native_name";s:9:"Basa Jawa";s:7:"package";s:65:"https://downloads.wordpress.org/translation/core/4.9.28/jv_ID.zip";s:3:"iso";a:2:{i:1;s:2:"jv";i:2;s:3:"jav";}s:7:"strings";a:1:{s:8:"continue";s:9:"Nerusaké";}}s:5:"ka_GE";a:8:{s:8:"language";s:5:"ka_GE";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-11-04 09:22:25";s:12:"english_name";s:8:"Georgian";s:11:"native_name";s:21:"ქართული";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/ka_GE.zip";s:3:"iso";a:2:{i:1;s:2:"ka";i:2;s:3:"kat";}s:7:"strings";a:1:{s:8:"continue";s:30:"გაგრძელება";}}s:3:"kab";a:8:{s:8:"language";s:3:"kab";s:7:"version";s:5:"6.2.8";s:7:"updated";s:19:"2023-07-05 11:40:39";s:12:"english_name";s:6:"Kabyle";s:11:"native_name";s:9:"Taqbaylit";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/6.2.8/kab.zip";s:3:"iso";a:2:{i:2;s:3:"kab";i:3;s:3:"kab";}s:7:"strings";a:1:{s:8:"continue";s:6:"Kemmel";}}s:2:"kk";a:8:{s:8:"language";s:2:"kk";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2024-07-18 02:49:24";s:12:"english_name";s:6:"Kazakh";s:11:"native_name";s:19:"Қазақ тілі";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.8.3/kk.zip";s:3:"iso";a:2:{i:1;s:2:"kk";i:2;s:3:"kaz";}s:7:"strings";a:1:{s:8:"continue";s:20:"Жалғастыру";}}s:2:"km";a:8:{s:8:"language";s:2:"km";s:7:"version";s:6:"5.2.23";s:7:"updated";s:19:"2019-06-10 16:18:28";s:12:"english_name";s:5:"Khmer";s:11:"native_name";s:27:"ភាសាខ្មែរ";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/5.2.23/km.zip";s:3:"iso";a:2:{i:1;s:2:"km";i:2;s:3:"khm";}s:7:"strings";a:1:{s:8:"continue";s:12:"បន្ត";}}s:2:"kn";a:8:{s:8:"language";s:2:"kn";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-29 19:46:21";s:12:"english_name";s:7:"Kannada";s:11:"native_name";s:15:"ಕನ್ನಡ";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.8.3/kn.zip";s:3:"iso";a:2:{i:1;s:2:"kn";i:2;s:3:"kan";}s:7:"strings";a:1:{s:8:"continue";s:30:"ಮುಂದುವರಿಸು";}}s:5:"ko_KR";a:8:{s:8:"language";s:5:"ko_KR";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-01 23:59:20";s:12:"english_name";s:6:"Korean";s:11:"native_name";s:9:"한국어";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/ko_KR.zip";s:3:"iso";a:2:{i:1;s:2:"ko";i:2;s:3:"kor";}s:7:"strings";a:1:{s:8:"continue";s:6:"계속";}}s:3:"ckb";a:8:{s:8:"language";s:3:"ckb";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-11-10 20:09:25";s:12:"english_name";s:16:"Kurdish (Sorani)";s:11:"native_name";s:13:"كوردی‎";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/6.8.3/ckb.zip";s:3:"iso";a:2:{i:1;s:2:"ku";i:3;s:3:"ckb";}s:7:"strings";a:1:{s:8:"continue";s:30:"به‌رده‌وام به‌";}}s:3:"kir";a:8:{s:8:"language";s:3:"kir";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-15 12:39:47";s:12:"english_name";s:6:"Kyrgyz";s:11:"native_name";s:16:"Кыргызча";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/6.8.3/kir.zip";s:3:"iso";a:3:{i:1;s:2:"ky";i:2;s:3:"kir";i:3;s:3:"kir";}s:7:"strings";a:1:{s:8:"continue";s:14:"Улантуу";}}s:2:"lo";a:8:{s:8:"language";s:2:"lo";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-11-12 09:59:23";s:12:"english_name";s:3:"Lao";s:11:"native_name";s:21:"ພາສາລາວ";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip";s:3:"iso";a:2:{i:1;s:2:"lo";i:2;s:3:"lao";}s:7:"strings";a:1:{s:8:"continue";s:18:"ຕໍ່​ໄປ";}}s:5:"lt_LT";a:8:{s:8:"language";s:5:"lt_LT";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-09-27 20:51:17";s:12:"english_name";s:10:"Lithuanian";s:11:"native_name";s:15:"Lietuvių kalba";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/lt_LT.zip";s:3:"iso";a:2:{i:1;s:2:"lt";i:2;s:3:"lit";}s:7:"strings";a:1:{s:8:"continue";s:6:"Tęsti";}}s:2:"lv";a:8:{s:8:"language";s:2:"lv";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-07-15 19:11:43";s:12:"english_name";s:7:"Latvian";s:11:"native_name";s:16:"Latviešu valoda";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.8.3/lv.zip";s:3:"iso";a:2:{i:1;s:2:"lv";i:2;s:3:"lav";}s:7:"strings";a:1:{s:8:"continue";s:9:"Turpināt";}}s:5:"mk_MK";a:8:{s:8:"language";s:5:"mk_MK";s:7:"version";s:6:"6.0.11";s:7:"updated";s:19:"2022-10-01 09:23:52";s:12:"english_name";s:10:"Macedonian";s:11:"native_name";s:31:"Македонски јазик";s:7:"package";s:65:"https://downloads.wordpress.org/translation/core/6.0.11/mk_MK.zip";s:3:"iso";a:2:{i:1;s:2:"mk";i:2;s:3:"mkd";}s:7:"strings";a:1:{s:8:"continue";s:16:"Продолжи";}}s:5:"ml_IN";a:8:{s:8:"language";s:5:"ml_IN";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-11-02 08:29:40";s:12:"english_name";s:9:"Malayalam";s:11:"native_name";s:18:"മലയാളം";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/ml_IN.zip";s:3:"iso";a:2:{i:1;s:2:"ml";i:2;s:3:"mal";}s:7:"strings";a:1:{s:8:"continue";s:18:"തുടരുക";}}s:2:"mn";a:8:{s:8:"language";s:2:"mn";s:7:"version";s:5:"6.5.7";s:7:"updated";s:19:"2024-06-20 17:22:06";s:12:"english_name";s:9:"Mongolian";s:11:"native_name";s:12:"Монгол";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.5.7/mn.zip";s:3:"iso";a:2:{i:1;s:2:"mn";i:2;s:3:"mon";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:2:"mr";a:8:{s:8:"language";s:2:"mr";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-08-26 17:30:52";s:12:"english_name";s:7:"Marathi";s:11:"native_name";s:15:"मराठी";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.8.3/mr.zip";s:3:"iso";a:2:{i:1;s:2:"mr";i:2;s:3:"mar";}s:7:"strings";a:1:{s:8:"continue";s:25:"सुरु ठेवा";}}s:5:"ms_MY";a:8:{s:8:"language";s:5:"ms_MY";s:7:"version";s:6:"5.5.17";s:7:"updated";s:19:"2022-03-11 13:52:22";s:12:"english_name";s:5:"Malay";s:11:"native_name";s:13:"Bahasa Melayu";s:7:"package";s:65:"https://downloads.wordpress.org/translation/core/5.5.17/ms_MY.zip";s:3:"iso";a:2:{i:1;s:2:"ms";i:2;s:3:"msa";}s:7:"strings";a:1:{s:8:"continue";s:8:"Teruskan";}}s:5:"my_MM";a:8:{s:8:"language";s:5:"my_MM";s:7:"version";s:6:"4.2.39";s:7:"updated";s:19:"2017-12-26 11:57:10";s:12:"english_name";s:17:"Myanmar (Burmese)";s:11:"native_name";s:15:"ဗမာစာ";s:7:"package";s:65:"https://downloads.wordpress.org/translation/core/4.2.39/my_MM.zip";s:3:"iso";a:2:{i:1;s:2:"my";i:2;s:3:"mya";}s:7:"strings";a:1:{s:8:"continue";s:54:"ဆက်လက်လုပ်ဆောင်ပါ။";}}s:5:"nb_NO";a:8:{s:8:"language";s:5:"nb_NO";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-09 19:23:11";s:12:"english_name";s:19:"Norwegian (Bokmål)";s:11:"native_name";s:13:"Norsk bokmål";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/nb_NO.zip";s:3:"iso";a:2:{i:1;s:2:"nb";i:2;s:3:"nob";}s:7:"strings";a:1:{s:8:"continue";s:8:"Fortsett";}}s:5:"ne_NP";a:8:{s:8:"language";s:5:"ne_NP";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-11-07 08:26:32";s:12:"english_name";s:6:"Nepali";s:11:"native_name";s:18:"नेपाली";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/ne_NP.zip";s:3:"iso";a:2:{i:1;s:2:"ne";i:2;s:3:"nep";}s:7:"strings";a:1:{s:8:"continue";s:43:"जारी राख्नुहोस्";}}s:5:"nl_BE";a:8:{s:8:"language";s:5:"nl_BE";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-01 07:26:29";s:12:"english_name";s:15:"Dutch (Belgium)";s:11:"native_name";s:20:"Nederlands (België)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/nl_BE.zip";s:3:"iso";a:2:{i:1;s:2:"nl";i:2;s:3:"nld";}s:7:"strings";a:1:{s:8:"continue";s:8:"Doorgaan";}}s:12:"nl_NL_formal";a:8:{s:8:"language";s:12:"nl_NL_formal";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-30 13:15:15";s:12:"english_name";s:14:"Dutch (Formal)";s:11:"native_name";s:20:"Nederlands (Formeel)";s:7:"package";s:71:"https://downloads.wordpress.org/translation/core/6.8.3/nl_NL_formal.zip";s:3:"iso";a:2:{i:1;s:2:"nl";i:2;s:3:"nld";}s:7:"strings";a:1:{s:8:"continue";s:8:"Doorgaan";}}s:5:"nl_NL";a:8:{s:8:"language";s:5:"nl_NL";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-11-11 21:32:23";s:12:"english_name";s:5:"Dutch";s:11:"native_name";s:10:"Nederlands";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/nl_NL.zip";s:3:"iso";a:2:{i:1;s:2:"nl";i:2;s:3:"nld";}s:7:"strings";a:1:{s:8:"continue";s:8:"Doorgaan";}}s:5:"nn_NO";a:8:{s:8:"language";s:5:"nn_NO";s:7:"version";s:8:"5.8-beta";s:7:"updated";s:19:"2021-03-18 10:59:16";s:12:"english_name";s:19:"Norwegian (Nynorsk)";s:11:"native_name";s:13:"Norsk nynorsk";s:7:"package";s:67:"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip";s:3:"iso";a:2:{i:1;s:2:"nn";i:2;s:3:"nno";}s:7:"strings";a:1:{s:8:"continue";s:9:"Hald fram";}}s:3:"oci";a:8:{s:8:"language";s:3:"oci";s:7:"version";s:6:"4.8.27";s:7:"updated";s:19:"2017-08-25 10:03:08";s:12:"english_name";s:7:"Occitan";s:11:"native_name";s:7:"Occitan";s:7:"package";s:63:"https://downloads.wordpress.org/translation/core/4.8.27/oci.zip";s:3:"iso";a:2:{i:1;s:2:"oc";i:2;s:3:"oci";}s:7:"strings";a:1:{s:8:"continue";s:9:"Contunhar";}}s:5:"pa_IN";a:8:{s:8:"language";s:5:"pa_IN";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2017-01-16 05:19:43";s:12:"english_name";s:15:"Panjabi (India)";s:11:"native_name";s:18:"ਪੰਜਾਬੀ";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip";s:3:"iso";a:2:{i:1;s:2:"pa";i:2;s:3:"pan";}s:7:"strings";a:1:{s:8:"continue";s:25:"ਜਾਰੀ ਰੱਖੋ";}}s:5:"pl_PL";a:8:{s:8:"language";s:5:"pl_PL";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-11-05 08:47:01";s:12:"english_name";s:6:"Polish";s:11:"native_name";s:6:"Polski";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/pl_PL.zip";s:3:"iso";a:2:{i:1;s:2:"pl";i:2;s:3:"pol";}s:7:"strings";a:1:{s:8:"continue";s:9:"Kontynuuj";}}s:2:"ps";a:8:{s:8:"language";s:2:"ps";s:7:"version";s:6:"4.3.35";s:7:"updated";s:19:"2015-12-02 21:41:29";s:12:"english_name";s:6:"Pashto";s:11:"native_name";s:8:"پښتو";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.3.35/ps.zip";s:3:"iso";a:2:{i:1;s:2:"ps";i:2;s:3:"pus";}s:7:"strings";a:1:{s:8:"continue";s:19:"دوام ورکړه";}}s:10:"pt_PT_ao90";a:8:{s:8:"language";s:10:"pt_PT_ao90";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-10 08:01:51";s:12:"english_name";s:27:"Portuguese (Portugal, AO90)";s:11:"native_name";s:17:"Português (AO90)";s:7:"package";s:69:"https://downloads.wordpress.org/translation/core/6.8.3/pt_PT_ao90.zip";s:3:"iso";a:1:{i:1;s:2:"pt";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"pt_BR";a:8:{s:8:"language";s:5:"pt_BR";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-27 23:52:28";s:12:"english_name";s:19:"Portuguese (Brazil)";s:11:"native_name";s:20:"Português do Brasil";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/pt_BR.zip";s:3:"iso";a:2:{i:1;s:2:"pt";i:2;s:3:"por";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"pt_PT";a:8:{s:8:"language";s:5:"pt_PT";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-11-12 02:01:38";s:12:"english_name";s:21:"Portuguese (Portugal)";s:11:"native_name";s:10:"Português";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/pt_PT.zip";s:3:"iso";a:1:{i:1;s:2:"pt";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"pt_AO";a:8:{s:8:"language";s:5:"pt_AO";s:7:"version";s:5:"6.4.7";s:7:"updated";s:19:"2023-08-21 12:15:00";s:12:"english_name";s:19:"Portuguese (Angola)";s:11:"native_name";s:20:"Português de Angola";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.4.7/pt_AO.zip";s:3:"iso";a:1:{i:1;s:2:"pt";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:3:"rhg";a:8:{s:8:"language";s:3:"rhg";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-03-16 13:03:18";s:12:"english_name";s:8:"Rohingya";s:11:"native_name";s:8:"Ruáinga";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip";s:3:"iso";a:1:{i:3;s:3:"rhg";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:5:"ro_RO";a:8:{s:8:"language";s:5:"ro_RO";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-11-07 10:57:31";s:12:"english_name";s:8:"Romanian";s:11:"native_name";s:8:"Română";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/ro_RO.zip";s:3:"iso";a:2:{i:1;s:2:"ro";i:2;s:3:"ron";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuă";}}s:5:"ru_RU";a:8:{s:8:"language";s:5:"ru_RU";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-09-30 19:16:19";s:12:"english_name";s:7:"Russian";s:11:"native_name";s:14:"Русский";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/ru_RU.zip";s:3:"iso";a:2:{i:1;s:2:"ru";i:2;s:3:"rus";}s:7:"strings";a:1:{s:8:"continue";s:20:"Продолжить";}}s:3:"sah";a:8:{s:8:"language";s:3:"sah";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2017-01-21 02:06:41";s:12:"english_name";s:5:"Sakha";s:11:"native_name";s:14:"Сахалыы";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip";s:3:"iso";a:2:{i:2;s:3:"sah";i:3;s:3:"sah";}s:7:"strings";a:1:{s:8:"continue";s:12:"Салҕаа";}}s:3:"snd";a:8:{s:8:"language";s:3:"snd";s:7:"version";s:6:"5.4.18";s:7:"updated";s:19:"2020-07-07 01:53:37";s:12:"english_name";s:6:"Sindhi";s:11:"native_name";s:8:"سنڌي";s:7:"package";s:63:"https://downloads.wordpress.org/translation/core/5.4.18/snd.zip";s:3:"iso";a:3:{i:1;s:2:"sd";i:2;s:3:"snd";i:3;s:3:"snd";}s:7:"strings";a:1:{s:8:"continue";s:15:"اڳتي هلو";}}s:5:"si_LK";a:8:{s:8:"language";s:5:"si_LK";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-11-12 06:00:52";s:12:"english_name";s:7:"Sinhala";s:11:"native_name";s:15:"සිංහල";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip";s:3:"iso";a:2:{i:1;s:2:"si";i:2;s:3:"sin";}s:7:"strings";a:1:{s:8:"continue";s:44:"දිගටම කරගෙන යන්න";}}s:5:"sk_SK";a:8:{s:8:"language";s:5:"sk_SK";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-13 06:23:32";s:12:"english_name";s:6:"Slovak";s:11:"native_name";s:11:"Slovenčina";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/sk_SK.zip";s:3:"iso";a:2:{i:1;s:2:"sk";i:2;s:3:"slk";}s:7:"strings";a:1:{s:8:"continue";s:12:"Pokračovať";}}s:3:"skr";a:8:{s:8:"language";s:3:"skr";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-04-24 16:58:02";s:12:"english_name";s:7:"Saraiki";s:11:"native_name";s:14:"سرائیکی";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/6.8.3/skr.zip";s:3:"iso";a:1:{i:3;s:3:"skr";}s:7:"strings";a:1:{s:8:"continue";s:17:"جاری رکھو";}}s:5:"sl_SI";a:8:{s:8:"language";s:5:"sl_SI";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-29 11:19:02";s:12:"english_name";s:9:"Slovenian";s:11:"native_name";s:13:"Slovenščina";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/sl_SI.zip";s:3:"iso";a:2:{i:1;s:2:"sl";i:2;s:3:"slv";}s:7:"strings";a:1:{s:8:"continue";s:8:"Nadaljuj";}}s:2:"sq";a:8:{s:8:"language";s:2:"sq";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-04-18 09:38:51";s:12:"english_name";s:8:"Albanian";s:11:"native_name";s:5:"Shqip";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.8.3/sq.zip";s:3:"iso";a:2:{i:1;s:2:"sq";i:2;s:3:"sqi";}s:7:"strings";a:1:{s:8:"continue";s:6:"Vazhdo";}}s:5:"sr_RS";a:8:{s:8:"language";s:5:"sr_RS";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-23 11:49:16";s:12:"english_name";s:7:"Serbian";s:11:"native_name";s:23:"Српски језик";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/sr_RS.zip";s:3:"iso";a:2:{i:1;s:2:"sr";i:2;s:3:"srp";}s:7:"strings";a:1:{s:8:"continue";s:14:"Настави";}}s:5:"sv_SE";a:8:{s:8:"language";s:5:"sv_SE";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-11-11 21:09:57";s:12:"english_name";s:7:"Swedish";s:11:"native_name";s:7:"Svenska";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/sv_SE.zip";s:3:"iso";a:2:{i:1;s:2:"sv";i:2;s:3:"swe";}s:7:"strings";a:1:{s:8:"continue";s:9:"Fortsätt";}}s:2:"sw";a:8:{s:8:"language";s:2:"sw";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-11-08 12:32:25";s:12:"english_name";s:7:"Swahili";s:11:"native_name";s:9:"Kiswahili";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.8.3/sw.zip";s:3:"iso";a:2:{i:1;s:2:"sw";i:2;s:3:"swa";}s:7:"strings";a:1:{s:8:"continue";s:7:"Endelea";}}s:3:"szl";a:8:{s:8:"language";s:3:"szl";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-09-24 19:58:14";s:12:"english_name";s:8:"Silesian";s:11:"native_name";s:17:"Ślōnskŏ gŏdka";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip";s:3:"iso";a:1:{i:3;s:3:"szl";}s:7:"strings";a:1:{s:8:"continue";s:13:"Kōntynuować";}}s:5:"ta_IN";a:8:{s:8:"language";s:5:"ta_IN";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2017-01-27 03:22:47";s:12:"english_name";s:5:"Tamil";s:11:"native_name";s:15:"தமிழ்";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip";s:3:"iso";a:2:{i:1;s:2:"ta";i:2;s:3:"tam";}s:7:"strings";a:1:{s:8:"continue";s:24:"தொடரவும்";}}s:5:"ta_LK";a:8:{s:8:"language";s:5:"ta_LK";s:7:"version";s:6:"4.2.39";s:7:"updated";s:19:"2015-12-03 01:07:44";s:12:"english_name";s:17:"Tamil (Sri Lanka)";s:11:"native_name";s:15:"தமிழ்";s:7:"package";s:65:"https://downloads.wordpress.org/translation/core/4.2.39/ta_LK.zip";s:3:"iso";a:2:{i:1;s:2:"ta";i:2;s:3:"tam";}s:7:"strings";a:1:{s:8:"continue";s:18:"தொடர்க";}}s:2:"te";a:8:{s:8:"language";s:2:"te";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2017-01-26 15:47:39";s:12:"english_name";s:6:"Telugu";s:11:"native_name";s:18:"తెలుగు";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/te.zip";s:3:"iso";a:2:{i:1;s:2:"te";i:2;s:3:"tel";}s:7:"strings";a:1:{s:8:"continue";s:30:"కొనసాగించు";}}s:2:"th";a:8:{s:8:"language";s:2:"th";s:7:"version";s:6:"5.8.12";s:7:"updated";s:19:"2022-06-08 04:30:30";s:12:"english_name";s:4:"Thai";s:11:"native_name";s:9:"ไทย";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/5.8.12/th.zip";s:3:"iso";a:2:{i:1;s:2:"th";i:2;s:3:"tha";}s:7:"strings";a:1:{s:8:"continue";s:15:"ต่อไป";}}s:2:"tl";a:8:{s:8:"language";s:2:"tl";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-10 17:38:55";s:12:"english_name";s:7:"Tagalog";s:11:"native_name";s:7:"Tagalog";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.8.3/tl.zip";s:3:"iso";a:2:{i:1;s:2:"tl";i:2;s:3:"tgl";}s:7:"strings";a:1:{s:8:"continue";s:10:"Magpatuloy";}}s:5:"tr_TR";a:8:{s:8:"language";s:5:"tr_TR";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-23 11:58:31";s:12:"english_name";s:7:"Turkish";s:11:"native_name";s:8:"Türkçe";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/tr_TR.zip";s:3:"iso";a:2:{i:1;s:2:"tr";i:2;s:3:"tur";}s:7:"strings";a:1:{s:8:"continue";s:5:"Devam";}}s:5:"tt_RU";a:8:{s:8:"language";s:5:"tt_RU";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-11-20 20:20:50";s:12:"english_name";s:5:"Tatar";s:11:"native_name";s:19:"Татар теле";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip";s:3:"iso";a:2:{i:1;s:2:"tt";i:2;s:3:"tat";}s:7:"strings";a:1:{s:8:"continue";s:17:"дәвам итү";}}s:3:"tah";a:8:{s:8:"language";s:3:"tah";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-03-06 18:39:39";s:12:"english_name";s:8:"Tahitian";s:11:"native_name";s:10:"Reo Tahiti";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip";s:3:"iso";a:3:{i:1;s:2:"ty";i:2;s:3:"tah";i:3;s:3:"tah";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:5:"ug_CN";a:8:{s:8:"language";s:5:"ug_CN";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-10 20:06:35";s:12:"english_name";s:6:"Uighur";s:11:"native_name";s:16:"ئۇيغۇرچە";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/ug_CN.zip";s:3:"iso";a:2:{i:1;s:2:"ug";i:2;s:3:"uig";}s:7:"strings";a:1:{s:8:"continue";s:26:"داۋاملاشتۇرۇش";}}s:2:"uk";a:8:{s:8:"language";s:2:"uk";s:7:"version";s:3:"6.8";s:7:"updated";s:19:"2025-04-18 21:10:00";s:12:"english_name";s:9:"Ukrainian";s:11:"native_name";s:20:"Українська";s:7:"package";s:59:"https://downloads.wordpress.org/translation/core/6.8/uk.zip";s:3:"iso";a:2:{i:1;s:2:"uk";i:2;s:3:"ukr";}s:7:"strings";a:1:{s:8:"continue";s:20:"Продовжити";}}s:2:"ur";a:8:{s:8:"language";s:2:"ur";s:7:"version";s:6:"5.4.18";s:7:"updated";s:19:"2020-04-09 11:17:33";s:12:"english_name";s:4:"Urdu";s:11:"native_name";s:8:"اردو";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/5.4.18/ur.zip";s:3:"iso";a:2:{i:1;s:2:"ur";i:2;s:3:"urd";}s:7:"strings";a:1:{s:8:"continue";s:19:"جاری رکھیں";}}s:5:"uz_UZ";a:8:{s:8:"language";s:5:"uz_UZ";s:7:"version";s:8:"5.8-beta";s:7:"updated";s:19:"2021-02-28 12:02:22";s:12:"english_name";s:5:"Uzbek";s:11:"native_name";s:11:"O‘zbekcha";s:7:"package";s:67:"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip";s:3:"iso";a:2:{i:1;s:2:"uz";i:2;s:3:"uzb";}s:7:"strings";a:1:{s:8:"continue";s:11:"Davom etish";}}s:2:"vi";a:8:{s:8:"language";s:2:"vi";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-09-01 09:12:13";s:12:"english_name";s:10:"Vietnamese";s:11:"native_name";s:14:"Tiếng Việt";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/6.8.3/vi.zip";s:3:"iso";a:2:{i:1;s:2:"vi";i:2;s:3:"vie";}s:7:"strings";a:1:{s:8:"continue";s:12:"Tiếp tục";}}s:5:"zh_TW";a:8:{s:8:"language";s:5:"zh_TW";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-01 08:48:55";s:12:"english_name";s:16:"Chinese (Taiwan)";s:11:"native_name";s:12:"繁體中文";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/zh_TW.zip";s:3:"iso";a:2:{i:1;s:2:"zh";i:2;s:3:"zho";}s:7:"strings";a:1:{s:8:"continue";s:6:"繼續";}}s:5:"zh_CN";a:8:{s:8:"language";s:5:"zh_CN";s:7:"version";s:5:"6.8.3";s:7:"updated";s:19:"2025-10-27 07:52:03";s:12:"english_name";s:15:"Chinese (China)";s:11:"native_name";s:12:"简体中文";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.8.3/zh_CN.zip";s:3:"iso";a:2:{i:1;s:2:"zh";i:2;s:3:"zho";}s:7:"strings";a:1:{s:8:"continue";s:6:"继续";}}s:5:"zh_HK";a:8:{s:8:"language";s:5:"zh_HK";s:7:"version";s:5:"6.2.8";s:7:"updated";s:19:"2022-07-15 15:25:03";s:12:"english_name";s:19:"Chinese (Hong Kong)";s:11:"native_name";s:12:"香港中文";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/6.2.8/zh_HK.zip";s:3:"iso";a:2:{i:1;s:2:"zh";i:2;s:3:"zho";}s:7:"strings";a:1:{s:8:"continue";s:6:"繼續";}}}','off');
INSERT INTO `wp_options` VALUES (117412,'_site_transient_timeout_browser_3c9fc7ddec9b58823c1c96756dbd45d8','1763534697','off');
INSERT INTO `wp_options` VALUES (117413,'_site_transient_browser_3c9fc7ddec9b58823c1c96756dbd45d8','a:10:{s:4:"name";s:6:"Chrome";s:7:"version";s:9:"142.0.0.0";s:8:"platform";s:7:"Windows";s:10:"update_url";s:29:"https://www.google.com/chrome";s:7:"img_src";s:43:"http://s.w.org/images/browsers/chrome.png?1";s:11:"img_src_ssl";s:44:"https://s.w.org/images/browsers/chrome.png?1";s:15:"current_version";s:2:"18";s:7:"upgrade";b:0;s:8:"insecure";b:0;s:6:"mobile";b:0;}','off');
INSERT INTO `wp_options` VALUES (117414,'can_compress_scripts','1','on');
INSERT INTO `wp_options` VALUES (117415,'_site_transient_timeout_community-events-c721d2be72af9c12ada163bca0e4e18e','1762973098','off');
INSERT INTO `wp_options` VALUES (117416,'_site_transient_community-events-c721d2be72af9c12ada163bca0e4e18e','a:4:{s:9:"sandboxed";b:0;s:5:"error";N;s:8:"location";a:1:{s:2:"ip";s:13:"193.160.149.0";}s:6:"events";a:0:{}}','off');
INSERT INTO `wp_options` VALUES (117417,'_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3','1762973098','off');
INSERT INTO `wp_options` VALUES (117418,'_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3','a:6:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n\n\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:52:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:8:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"WordPress News";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wordpress.org/news";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:59:"The latest news about WordPress and the WordPress community";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:13:"lastBuildDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 11 Nov 2025 15:40:08 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"en-US";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"generator";a:1:{i:0;a:5:{s:4:"data";s:38:"https://wordpress.org/?v=6.9-RC1-61214";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"image";a:1:{i:0;a:6:{s:4:"data";s:11:"\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:5:{s:3:"url";a:1:{i:0;a:5:{s:4:"data";s:29:"https://s.w.org/favicon.ico?2";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"WordPress News";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wordpress.org/news";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"width";a:1:{i:0;a:5:{s:4:"data";s:2:"32";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"height";a:1:{i:0;a:5:{s:4:"data";s:2:"32";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:4:"item";a:10:{i:0;a:6:{s:4:"data";s:75:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:33:"WordPress 6.9 Release Candidate 1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:69:"https://wordpress.org/news/2025/11/wordpress-6-9-release-candidate-1/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 11 Nov 2025 15:34:48 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:7:{i:0;a:5:{s:4:"data";s:11:"Development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"General";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:3:"6.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:11:"development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:18:"release candidates";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:6;a:5:{s:4:"data";s:8:"releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19317";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:364:"The first Release Candidate (“RC1”) for WordPress 6.9 is ready for download and testing! This version of the WordPress software is still under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended to evaluate RC1 on a test server and site. WordPress 6.9 RC1 [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"Amy Kamala";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:9479:"\n<p>The first Release Candidate (“RC1”) for WordPress 6.9 is ready for download and testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is still under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended to evaluate RC1 on a test server and site.</p>\n\n\n\n<p>WordPress 6.9 RC1 can be tested using any of the following methods:</p>\n\n\n\n<figure class="wp-block-table"><table class="has-fixed-layout"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the <a href="https://wordpress.org/plugins/wordpress-beta-tester/">WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream.)</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href="https://wordpress.org/wordpress-6.9-RC1.zip">RC1 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use this <a href="https://make.wordpress.org/cli/">WP-CLI</a> command: <br><code>wp core update --version=6.9-RC1</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href="https://playground.wordpress.net/?php=8.3&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn" data-type="link" data-id="https://playground.wordpress.net/?php=8.3&amp;wp=rc&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn">6.9 RC1 WordPress Playground instance</a> to test the software directly in your browser. No setup is required &#8211; just click and go! </td></tr></tbody></table></figure>\n\n\n\n<p>The scheduled final release date for WordPress 6.9 is <strong>December 2, 2025</strong>. The full <a href="https://make.wordpress.org/core/6-9/">release schedule can be found here</a>. Your help testing Beta and RC versions is vital to making this release as stable and powerful as possible.</p>\n\n\n\n<p>Please continue checking the <a href="https://make.wordpress.org/core/">Make WordPress Core blog</a> for <a href="https://make.wordpress.org/core/tag/6-9/">6.9-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<h2 class="wp-block-heading">What’s in WordPress 6.9 RC1?</h2>\n\n\n\n<p>Check out the <a href="https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/">Beta 1 announcement</a> for details on WordPress 6.9.</p>\n\n\n\n<p>You can browse the technical details for all issues addressed since Beta 4 using these links:</p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-11-07&amp;until=2025-11-11">Gutenberg commits for 6.9</a> since November 7, 2025</li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/log/?revs=61183-61203">Core commits for 6.9</a> since November 7, 2025</li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/query?status=closed&amp;changetime=11%2F07%2F2025..11%2F11%2F2025&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=changetime&amp;col=type&amp;order=id">Closed Trac tickets</a> since November 7, 2025</li>\n</ul>\n\n\n\n<p>Want to know more about this release? Here are some highlights:</p>\n\n\n\n<ul class="wp-block-list">\n<li>Site Editor improvements and Refined content creation\n<ul class="wp-block-list">\n<li>Ability to hide blocks</li>\n\n\n\n<li>New blocks </li>\n\n\n\n<li>Notes on blocks</li>\n\n\n\n<li>Universal command palette in wp-admin</li>\n</ul>\n</li>\n\n\n\n<li>Developer updates\n<ul class="wp-block-list">\n<li>Updates to dataviews and dataforms components</li>\n\n\n\n<li>New abilities API</li>\n\n\n\n<li>Updates to interactivity API </li>\n\n\n\n<li>Updates to block binding API</li>\n</ul>\n</li>\n\n\n\n<li>Performance Improvements\n<ul class="wp-block-list">\n<li>Improved script and style handling</li>\n\n\n\n<li>Optimized queries and caching</li>\n\n\n\n<li>Added ability to handle “fetchpriority” in ES Modules and Import Maps</li>\n\n\n\n<li>Standardizing output buffering</li>\n</ul>\n</li>\n</ul>\n\n\n\n<p>The final release is on track for December 2nd. As always, a successful release depends on your confirmation during testing. So please download and test!</p>\n\n\n\n<h2 class="wp-block-heading">How you can contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community of people collaborating on and contributing to its development. The resources below outline various ways you can help the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h3 class="wp-block-heading">Get involved in testing</h3>\n\n\n\n<p>Testing for issues is crucial to the development of any software. It’s also a meaningful way for anyone to contribute. </p>\n\n\n\n<p>Your help testing the WordPress 6.9 RC1 version is key to ensuring that the final release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important. This <a href="https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/">detailed guide</a> will walk you through testing features in WordPress 6.9.</p>\n\n\n\n<h4 class="wp-block-heading">Calls for testing</h4>\n\n\n\n<p>Thank you to everyone who helps test the following enhancements and bug fixes:</p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://make.wordpress.org/test/2025/10/06/call-for-testing-accordion-block/">Accordion Block</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/test/2025/10/04/call-for-testing-ability-to-hide-blocks/">Ability to Hide Blocks</a></li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/ticket/64099">Classic themes loading block styles on demand</a></li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/ticket/64204">Modified notes notifications</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/10/abilities-api-in-wordpress-6-9/">Abilities API</a></li>\n</ul>\n\n\n\n<p>If you encounter an issue, please report it to the <a href="https://wordpress.org/support/forum/alphabeta/">Alpha/Beta area</a> of the support forums, or directly to <a href="https://core.trac.wordpress.org/newticket">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href="https://core.trac.wordpress.org/tickets/major">known bugs</a>.</p>\n\n\n\n<p>Thank you to everyone who helps with testing!</p>\n\n\n\n<h3 class="wp-block-heading">Update your theme or plugin</h3>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.9 beta releases. With RC1, you’ll want to conclude your testing and update the <em>“Tested up to”</em> version in your <a href="https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/">plugin’s readme file</a> to 6.9. </p>\n\n\n\n<p>If you find compatibility issues, please post detailed information to the <a href="https://wordpress.org/support/forum/alphabeta/">support forum</a>.</p>\n\n\n\n<h3 class="wp-block-heading">Test on your hosting platforms</h3>\n\n\n\n<p>Web hosts provide vital infrastructure for supporting WordPress and its users. Testing on hosting systems helps inform the development process while ensuring that WordPress and hosting platforms are fully compatible, free of errors, optimized for the best possible user experience, and that updates roll out to customer sites without issue.</p>\n\n\n\n<p>Want to test WordPress on your hosting system? <a href="https://make.wordpress.org/hosting/test-results-getting-started/">Get started with configuring distributed hosting tests here</a>. Thank you to all <a href="https://make.wordpress.org/hosting/test-results/">web hosts who help test WordPress</a>!</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href="https://make.wordpress.org/test/">testing initiatives in Make Core</a> and join the <a href="https://wordpress.slack.com/messages/core-test/">#core-test channel</a> on <a href="https://wordpress.slack.com/">Making WordPress Slack</a>.</p>\n\n\n\n<h2 class="wp-block-heading">An RC1 haiku</h2>\n\n\n\n<p><em>As the sun rises</em>,</p>\n\n\n\n<p><em>RC1 breaks its cocoon</em></p>\n\n\n\n<p><em>and emerges strong</em>.</p>\n\n\n\n<p class="has-text-align-right"><em>Props to </em><a href=\'https://profiles.wordpress.org/akshayar/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>akshayar</a><em>, </em><a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a>, <a href=\'https://profiles.wordpress.org/desrosj/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>desrosj</a>, <a href=\'https://profiles.wordpress.org/westonruter/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>westonruter</a>, <a href=\'https://profiles.wordpress.org/ellatrix/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ellatrix</a>, <a href=\'https://profiles.wordpress.org/priethor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>priethor</a>, <a href=\'https://profiles.wordpress.org/krupajnanda/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>krupajnanda</a> <em>and</em> <a href=\'https://profiles.wordpress.org/cbravobernal/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbravobernal</a> <em>for proofreading and review.</em></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19317";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:72:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:20:"WordPress 6.9 Beta 3";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:56:"https://wordpress.org/news/2025/11/wordpress-6-9-beta-3/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 04 Nov 2025 15:34:27 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:6:{i:0;a:5:{s:4:"data";s:11:"Development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"General";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:3:"6.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:11:"development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:7:"release";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19263";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:347:"WordPress 6.9 Beta 3 is available for download and testing! This beta version of the WordPress software is still under development. Please don&#8217;t install, run, or test this version of WordPress on production or mission-critical websites. Instead, you can evaluate Beta 3 on a test server and site. WordPress 6.9 Beta 3 can be tested [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"Amy Kamala";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5454:"\n<p>WordPress 6.9 Beta 3 is available for download and testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is still under development</strong>. Please don&#8217;t install, run, or test this version of WordPress on production or mission-critical websites. Instead, you can evaluate Beta 3 on a test server and site.</p>\n\n\n\n<p>WordPress 6.9 Beta 3 can be tested using any of the following methods:</p>\n\n\n\n<figure class="wp-block-table"><table class="has-fixed-layout"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the<a href="https://wordpress.org/plugins/wordpress-beta-tester/"> WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream.)</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href="https://wordpress.org/wordpress-6.9-beta3.zip">Beta 3 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use this<a href="https://make.wordpress.org/cli/"> WP-CLI</a> command: <br><code>wp core update --version=6.9-beta3</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href="https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn">6.9 Beta 3 WordPress Playground instance</a> to test the software directly in your browser.&nbsp; No setup is required – just click and go!&nbsp;</td></tr></tbody></table></figure>\n\n\n\n<p></p>\n\n\n\n<p>The final release of WordPress 6.9 is scheduled for <strong>December 2, 2025</strong>, and the <a href="https://make.wordpress.org/core/6-9/">release schedule can be found here</a>. Your help testing Beta and RC versions is vital to making this release as stable and powerful as possible. Thank you to everyone who helps with testing!</p>\n\n\n\n<p>Please continue checking the <a href="https://make.wordpress.org/core/">Make WordPress Core blog</a> for <a href="https://make.wordpress.org/core/tag/6-9/">6.9-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<p><strong>Find out what’s new in WordPress 6.9</strong>: Read the <a href="https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/">Beta 1 announcement</a> for details and highlights.</p>\n\n\n\n<h2 class="wp-block-heading">How to test this release</h2>\n\n\n\n<p>Your help testing the WordPress 6.9 Beta 3 version is key to ensuring that everything in the release is the best it can be. While testing the upgrade process is essential, trying out new features is equally as important. This <a href="https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/">detailed guide</a> provides a walk through on testing features in WordPress 6.9.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href="https://wordpress.org/support/forum/alphabeta/">Alpha/Beta area</a> of the support forums, or directly to <a href="https://core.trac.wordpress.org/newticket">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href="https://core.trac.wordpress.org/tickets/major">known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href="https://make.wordpress.org/test/">testing initiatives in Make Core</a> and join the<a href="https://wordpress.slack.com/messages/core-test/"> #core-test channel</a> on<a href="https://wordpress.slack.com/"> Making WordPress Slack</a>.</p>\n\n\n\n<h2 class="wp-block-heading">Beta 3 updates and highlights</h2>\n\n\n\n<p>WordPress 6.9 Beta 3 contains more than 80 updates and fixes since the Beta 2 release.</p>\n\n\n\n<p>Each beta cycle focuses on bug fixes, and more are on the way with your testing! You can browse the technical details for all issues addressed since Beta 2 using these links:</p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-10-28&amp;until=2025-11-04">Gutenberg commits for 6.9</a> since October 28, 2025</li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F28%2F2025..11%2F04%2F2025&amp;milestone=6.9&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id">Closed Core Trac tickets for 6.9</a> since October 28, 2025</li>\n\n\n\n<li><a href="https://github.com/WordPress/wordpress-develop/compare/7dcb09c26a1d97c20dcceb866abbd0f3c128388b...81f755846c2d66ce7d21b01623f8163a9f7c6ef6">Comparing commit changes in Core for 6.9</a> since October 28, 2025</li>\n</ul>\n\n\n\n<h2 class="wp-block-heading">A Beta 3 haiku</h2>\n\n\n\n<p><em>Code is poetry,</em></p>\n\n\n\n<p><em>and poetry is magic.</em></p>\n\n\n\n<p><em>So code is magic.</em></p>\n\n\n\n<p class="has-text-align-right"><em>Props to </em><a href=\'https://profiles.wordpress.org/akshayar/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>akshayar</a> <em>, </em><a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a>, <a href=\'https://profiles.wordpress.org/krupajnanda/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>krupajnanda</a>, <a href=\'https://profiles.wordpress.org/mosescursor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mosescursor</a>,  <em>and</em> <a href=\'https://profiles.wordpress.org/westonruter/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>westonruter</a> <em>for proofreading and review.</em></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19263";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:69:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:20:"WordPress 6.9 Beta 2";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:56:"https://wordpress.org/news/2025/10/wordpress-6-9-beta-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 28 Oct 2025 15:23:27 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:5:{i:0;a:5:{s:4:"data";s:11:"Development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:3:"6-9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:11:"development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:7:"release";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19253";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:334:"WordPress 6.9 Beta 2 is now ready for testing! This beta version of the WordPress software is under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites.&#160; Instead, you should evaluate Beta 2 on a test server and site. You can test WordPress 6.9 Beta 2 in [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"Akshaya Rane";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5125:"\n<p>WordPress 6.9 Beta 2 is now ready for testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites.&nbsp; Instead, you should evaluate Beta 2 on a test server and site.</p>\n\n\n\n<p>You can test WordPress 6.9 Beta 2 in any of the following ways:<br></p>\n\n\n\n<figure class="wp-block-table"><table class="has-fixed-layout"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the<a href="https://wordpress.org/plugins/wordpress-beta-tester/"> WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream.)</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href="https://wordpress.org/wordpress-6.9-beta2.zip">Beta 2 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use this<a href="https://make.wordpress.org/cli/"> WP-CLI</a> command: <br><code>wp core update --version=6.9-beta2</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href="https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn">6.9 Beta 2 WordPress Playground instance</a> to test the software directly in your browser.&nbsp; No setup is required–just click and go!&nbsp;</td></tr></tbody></table></figure>\n\n\n\n<p>The scheduled final release date for WordPress 6.9 is <strong>December 2, 2025</strong>. &nbsp;The full <a href="https://make.wordpress.org/core/6-9/">release schedule can be found here</a>. Your help testing Beta and RC versions is vital to making this release as stable and powerful as possible. Do check the<a href="https://make.wordpress.org/core/"> Make WordPress Core blog</a> for <a href="https://make.wordpress.org/core/tag/6-9/">6.9-related posts</a> in the coming weeks for more information. Thank you to everyone who contributes by testing!&nbsp;</p>\n\n\n\n<p><strong>Catch up on what’s new in WordPress 6.9</strong>: Read the <a href="https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/">Beta 1 announcement</a> for details and highlights.</p>\n\n\n\n<h2 class="wp-block-heading">How to test this release</h2>\n\n\n\n<p>Your help testing the WordPress 6.9 Beta 2 version is key to ensuring everything in the release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important.&nbsp; This <a href="https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/">detailed guide</a> will walk you through testing features in WordPress 6.9.</p>\n\n\n\n<p>If you encounter an issue, please report it to the<a href="https://wordpress.org/support/forum/alphabeta/"> Alpha/Beta area</a> of the support forums or directly to<a href="https://core.trac.wordpress.org/newticket"> WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of<a href="https://core.trac.wordpress.org/tickets/major"> known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the<a href="https://make.wordpress.org/test/"> testing initiatives in Make Core</a> and join the<a href="https://wordpress.slack.com/messages/core-test/"> #core-test channel</a> on<a href="https://wordpress.slack.com/"> Making WordPress Slack</a>.</p>\n\n\n\n<h2 class="wp-block-heading">Beta 2 updates and highlights</h2>\n\n\n\n<p>WordPress 6.9 Beta 2 contains more than 33 Editor updates and fixes since the Beta 1 release, including 28 tickets for WordPress core.</p>\n\n\n\n<p>Each beta cycle focuses on bug fixes; more are on the way with your help through testing. You can browse the technical details for all issues addressed since Beta 1 using these links:</p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-10-22&amp;until=2025-10-28">GitHub commits for 6.9</a> since October 21, 2025</li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F22%2F2025..10%2F28%2F2025&amp;milestone=6.9&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id">Closed Trac tickets</a> since October 21, 2025</li>\n</ul>\n\n\n\n<h2 class="wp-block-heading">A Beta 2 haiku</h2>\n\n\n\n<p><em>Morning dew returns,</em></p>\n\n\n\n<p><em>Small fixes bloom in silence—</em></p>\n\n\n\n<p><em>Code finds its balance.</em></p>\n\n\n\n<p class="has-text-align-right"><em>Props to <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/wildworks/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>wildworks</a> , <a href=\'https://profiles.wordpress.org/krupajnanda/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>krupajnanda</a> &amp; <a href=\'https://profiles.wordpress.org/mosescursor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mosescursor</a></em> <em>for proofreading and review.</em></p>\n\n\n\n<p></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19253";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:63:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:23:"WordPress 6.8.3 Release";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:59:"https://wordpress.org/news/2025/09/wordpress-6-8-3-release/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 30 Sep 2025 19:31:04 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:3:{i:0;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:14:"minor-releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:8:"releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19204";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:372:"WordPress 6.8.3 is now available! This is a security release that features two fixes. Because this is a security release, it is recommended that you update your sites immediately. You can download WordPress 6.8.3 from WordPress.org, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. If you have sites that support automatic [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:15:"John Blackbourn";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:4937:"\n<p><strong>WordPress 6.8.3 is now available!</strong></p>\n\n\n\n<p>This is a security release that features two fixes.</p>\n\n\n\n<p>Because this is a security release,<strong> it is recommended that you update your sites immediately</strong>.</p>\n\n\n\n<p>You can <a href="https://wordpress.org/wordpress-6.8.3.zip">download WordPress 6.8.3 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>The next major release will be <a href="https://make.wordpress.org/core/6-9/">version 6.9</a>, which is planned for December 2nd, 2025.<br>For more information on WordPress 6.8.3, please visit the <a href="https://wordpress.org/documentation/wordpress-version/version-6-8-3/">version page on the HelpHub site</a>.</p>\n\n\n\n<h2 class="wp-block-heading">Security updates included in this release</h2>\n\n\n\n<p>The security team would like to thank the following people for <a href="https://hackerone.com/wordpress?type=team">responsibly reporting vulnerabilities</a>, and allowing them to be fixed in this release:</p>\n\n\n\n<ul class="wp-block-list">\n<li>A data exposure issue where authenticated users could access some restricted content. Independently reported by <a href="https://hackerone.com/mnelson4">Mike Nelson</a>, <a href="https://hackerone.com/hurayraiit">Abu Hurayra</a>, <a href="https://profiles.wordpress.org/timothyblynjacobs/">Timothy Jacobs</a>, and <a href="https://profiles.wordpress.org/peterwilsoncc/">Peter Wilson</a>.</li>\n\n\n\n<li>A cross-site scripting (XSS) vulnerability requiring an authenticated user role that affects the nav menus. Reported by <a href="https://x.com/Savphill">Phill Savage</a>.</li>\n</ul>\n\n\n\n<p>As a courtesy, these fixes have also been made available to all branches eligible to receive security fixes (currently through 4.7). As a reminder, <strong>only the most recent version of WordPress is actively supported</strong>.</p>\n\n\n\n<h2 class="wp-block-heading">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by <a href="https://profiles.wordpress.org/johnbillion/">John Blackbourn</a>.</p>\n\n\n\n<p>In addition to the security researchers and release squad members mentioned above, WordPress 6.8.3 would not have been possible without the contributions of the following people:</p>\n\n\n\n<p><a href="https://profiles.wordpress.org/jorbin">Aaron Jorbin</a>, <a href="https://profiles.wordpress.org/hurayraiit">Abu Hurayra</a>, <a href="https://profiles.wordpress.org/zieladam">Adam Zieliński</a>, <a href="https://profiles.wordpress.org/xknown">Alex Concha</a>, <a href="https://profiles.wordpress.org/andraganescu%20">Andrei Draganescu</a>, <a href="https://profiles.wordpress.org/davidbaumwald/">David Baumwald</a>, <a href="https://profiles.wordpress.org/ehtis">Ehtisham Siddiqui</a>, <a href="https://profiles.wordpress.org/iandunn">Ian Dunn</a>, <a href="https://profiles.wordpress.org/whyisjake">Jake Spurlock</a>, <a href="https://profiles.wordpress.org/audrasjb">Jb Audras</a>, <a href="https://profiles.wordpress.org/joehoyle">Joe Hoyle</a>, <a href="https://profiles.wordpress.org/johnbillion">John Blackbourn</a>, <a href="https://profiles.wordpress.org/jonsurrell">Jon Surrell</a>, <a href="https://profiles.wordpress.org/desrosj">Jonathan Desrosiers</a>, <a href="https://profiles.wordpress.org/mnelson4">Michael Nelson</a>, <a href="https://profiles.wordpress.org/peterwilsoncc">Peter Wilson</a>, <a href="https://profiles.wordpress.org/phillsav">Phill</a>, <a href="https://profiles.wordpress.org/noisysocks">Robert Anderson</a>, <a href="https://profiles.wordpress.org/rmccue">Ryan McCue</a>, <a href="https://profiles.wordpress.org/coffee2code/">Scott Reilly</a>, <a href="https://profiles.wordpress.org/timothyblynjacobs">Timothy Jacobs</a>, <a href="https://profiles.wordpress.org/vortfu">vortfu</a>, <a href="https://profiles.wordpress.org/westonruter">Weston Ruter</a></p>\n\n\n\n<h2 class="wp-block-heading">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac, <a href="https://core.trac.wordpress.org/report/6">pick a ticket</a>, and join the conversation in the <a href="https://app.slack.com/client/T024MFP4J/C02RQBWTW">#core</a> Slack channel. Need help? Check out the <a href="https://make.wordpress.org/core/handbook/tutorials/faq-for-new-contributors/">Core Contributor Handbook</a>.</p>\n\n\n\n<p>Props to <a href="https://profiles.wordpress.org/ehtis/">Ehtisham Siddiqui</a>, <a href="https://profiles.wordpress.org/johnbillion/">John Blackbourn</a>, <a href="https://profiles.wordpress.org/paulkevan/">Paul Kevan</a>, <a href="https://profiles.wordpress.org/desrosj/">Jonathan Desrosiers</a>, <a href="https://profiles.wordpress.org/jorbin/">Aaron Jorbin</a>, <a href="https://profiles.wordpress.org/westonruter">Weston Ruter</a> for reviewing.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19204";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:63:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:57:"Portland Welcomes WordCamp US 2025: A Community Gathering";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:63:"https://wordpress.org/news/2025/08/portland-welcomes-wcus-2025/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 30 Aug 2025 03:03:52 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:3:{i:0;a:5:{s:4:"data";s:6:"Events";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"General";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:8:"WordCamp";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19074";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:405:"A full house of attendees gathered in Portland, Oregon, for WordCamp US 2025, with thousands more tuning in online. Over four days, the flagship WordPress event brought together contributors, innovators, and community members for collaboration, inspiration, and discovery. WordPress is so unique because we&#8217;re not just a product; we&#8217;re a movement. Matt Mullenweg, WordPress Cofounder [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Brett McSherry";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:66040:"\n\n\n<p>A full house of attendees gathered in Portland, Oregon, for WordCamp US 2025, with thousands more tuning in online. Over four days, the flagship WordPress event brought together contributors, innovators, and community members for collaboration, inspiration, and discovery.</p>\n\n\n\n<div class="wp-block-group is-nowrap is-layout-flex wp-container-core-group-is-layout-6c531013 wp-block-group-is-layout-flex">\n<figure class="wp-block-pullquote"><blockquote><p>WordPress is so unique because we&#8217;re not just a product; we&#8217;re a movement.</p><cite>Matt Mullenweg, WordPress Cofounder</cite></blockquote></figure>\n</div>\n\n\n\n<p>The WordPress event began with a dedicated Contributor Day and continued with a Showcase Day and two days of sessions filled with talks, panels, workshops, and community celebrations. WordPress Cofounder Matt Mullenweg joined a diverse lineup of speakers, panelists, and workshop leaders who brought fresh perspectives to the open web from across the globe.</p>\n\n\n\n<p>Set against the vibrant backdrop of Portland — with its iconic bridges, coffee culture, and creative energy — the Sponsor Hall buzzed as companies across the WordPress ecosystem demoed new products, shared insights, and connected with attendees. Each day offered opportunities to refuel with local flavors and international favorites, turning mealtimes into lively hubs of networking and idea-sharing.</p>\n\n\n\n<h2 class="wp-block-heading">A Global Gathering in Portland</h2>\n\n\n\n<p>WordCamp US is the annual gathering point for the WordPress community — where collaboration, creativity, and innovation intersect. This year in Portland, the event delivered an expansive program that reached every corner of the ecosystem.</p>\n\n\n\n<p>Here’s what attendees experienced:</p>\n\n\n\n<ul class="wp-block-list">\n<li><strong>Engaging Sessions Across Tracks</strong> – Keynotes, presentations, and discussions explored the evolving web and the role of open source in shaping it.</li>\n\n\n\n<li><strong>A Global Speaker Lineup</strong> – Voices from across continents brought local stories and global visions to the stage.</li>\n\n\n\n<li><strong>Wide-Ranging Topics</strong> – From AI in WordPress development to accessibility, design systems, content strategy, education, and case studies of WordPress at scale.</li>\n\n\n\n<li><strong>Hands-On Learning Opportunities</strong> – Workshops provided practical takeaways, empowering attendees to apply new skills immediately.</li>\n\n\n\n<li><strong>A Community Built on Collaboration</strong> – Whether contributing code, exploring business strategies, or sharing creative projects, attendees found space to learn, grow, and celebrate open source together.</li>\n</ul>\n\n\n\n<p>New contributors took their first steps into open source, seasoned developers explored cutting-edge AI integrations, and agencies and product teams shared strategies for scaling WordPress to meet modern needs. Beyond the technical, conversations around inclusivity, sustainability, and education underscored WordPress’s role as a tool for empowerment and positive change.</p>\n\n\n\n<p>In hallways, coffee lines, and evening meetups, attendees found the “hallway track” alive and well, spontaneous moments of connection that often became the most memorable part of the experience. Whether reconnecting with longtime collaborators or meeting someone new, these small interactions reinforced the heart of WordCamp US: a community that thrives on openness, generosity, and shared purpose.</p>\n\n\n\n<h2 class="wp-block-heading">Contributor Day: Collaboration at the Core</h2>\n\n\n\n<p>The conference opened on Tuesday, August 26, with a vibrant Contributor Day. Nearly 300 contributors filled the space, including more than 120 first-time participants who were onboarded across 19 teams. Developers, designers, translators, marketers, and community organizers worked side by side, representing WordPress expertise.</p>\n\n\n\n<p>Throughout the day, contributors tackled everything from improving accessibility and performance to refining documentation to enhancing translation tools. Beyond technical contributions, teams like Marketing and Community focused on outreach, mentoring, and shaping future-facing initiatives. Remote participants joined via dedicated channels, reinforcing the inclusive nature of WordPress’s global community. By day’s end, the collective energy was clear: WordPress continues to be built by and for everyone.</p>\n\n\n\n<figure class="wp-block-gallery has-nested-images columns-default is-cropped has-black-background-color has-background wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex" style="border-width:20px;border-radius:2px">\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6914297fc33b3&quot;}" data-wp-interactive="core/image" data-wp-key="6914297fc33b3" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" fetchpriority="high" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on-async--click="actions.showLightbox" data-wp-on-async--load="callbacks.setButtonStyles" data-wp-on-async-window--resize="callbacks.setButtonStyles" data-id="19080" src="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19080" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="(max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on-async--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6914297fc384b&quot;}" data-wp-interactive="core/image" data-wp-key="6914297fc384b" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on-async--click="actions.showLightbox" data-wp-on-async--load="callbacks.setButtonStyles" data-wp-on-async-window--resize="callbacks.setButtonStyles" data-id="19081" src="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19081" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="(max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on-async--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6914297fc3c52&quot;}" data-wp-interactive="core/image" data-wp-key="6914297fc3c52" class="wp-block-image size-large wp-lightbox-container"><img decoding="async" width="1707" height="2560" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on-async--click="actions.showLightbox" data-wp-on-async--load="callbacks.setButtonStyles" data-wp-on-async-window--resize="callbacks.setButtonStyles" data-id="19087" src="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?fit=683%2C1024&amp;ssl=1" alt="" class="wp-image-19087" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?w=1707&amp;ssl=1 1707w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=200%2C300&amp;ssl=1 200w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=683%2C1024&amp;ssl=1 683w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=768%2C1152&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=1024%2C1536&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=1365%2C2048&amp;ssl=1 1365w" sizes="(max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on-async--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6914297fc404e&quot;}" data-wp-interactive="core/image" data-wp-key="6914297fc404e" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on-async--click="actions.showLightbox" data-wp-on-async--load="callbacks.setButtonStyles" data-wp-on-async-window--resize="callbacks.setButtonStyles" data-id="19084" src="https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19084" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on-async--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6914297fc4442&quot;}" data-wp-interactive="core/image" data-wp-key="6914297fc4442" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on-async--click="actions.showLightbox" data-wp-on-async--load="callbacks.setButtonStyles" data-wp-on-async-window--resize="callbacks.setButtonStyles" data-id="19082" src="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19082" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on-async--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6914297fc481b&quot;}" data-wp-interactive="core/image" data-wp-key="6914297fc481b" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on-async--click="actions.showLightbox" data-wp-on-async--load="callbacks.setButtonStyles" data-wp-on-async-window--resize="callbacks.setButtonStyles" data-id="19085" src="https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19085" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on-async--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6914297fc4c0e&quot;}" data-wp-interactive="core/image" data-wp-key="6914297fc4c0e" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on-async--click="actions.showLightbox" data-wp-on-async--load="callbacks.setButtonStyles" data-wp-on-async-window--resize="callbacks.setButtonStyles" data-id="19086" src="https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19086" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on-async--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6914297fc4ff4&quot;}" data-wp-interactive="core/image" data-wp-key="6914297fc4ff4" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on-async--click="actions.showLightbox" data-wp-on-async--load="callbacks.setButtonStyles" data-wp-on-async-window--resize="callbacks.setButtonStyles" data-id="19090" src="https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19090" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on-async--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6914297fc53d9&quot;}" data-wp-interactive="core/image" data-wp-key="6914297fc53d9" class="wp-block-image size-large wp-lightbox-container"><img loading="lazy" decoding="async" width="2560" height="1707" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on-async--click="actions.showLightbox" data-wp-on-async--load="callbacks.setButtonStyles" data-wp-on-async-window--resize="callbacks.setButtonStyles" data-id="19089" src="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?fit=1024%2C683&amp;ssl=1" alt="" class="wp-image-19089" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?w=2560&amp;ssl=1 2560w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on-async--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6914297fc57e7&quot;}" data-wp-interactive="core/image" data-wp-key="6914297fc57e7" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on-async--click="actions.showLightbox" data-wp-on-async--load="callbacks.setButtonStyles" data-wp-on-async-window--resize="callbacks.setButtonStyles" data-id="19092" src="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19092" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on-async--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6914297fc5bdf&quot;}" data-wp-interactive="core/image" data-wp-key="6914297fc5bdf" class="wp-block-image size-large wp-lightbox-container"><img loading="lazy" decoding="async" width="2560" height="1707" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on-async--click="actions.showLightbox" data-wp-on-async--load="callbacks.setButtonStyles" data-wp-on-async-window--resize="callbacks.setButtonStyles" data-id="19088" src="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?fit=1024%2C683&amp;ssl=1" alt="" class="wp-image-19088" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?w=2560&amp;ssl=1 2560w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on-async--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6914297fc6019&quot;}" data-wp-interactive="core/image" data-wp-key="6914297fc6019" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on-async--click="actions.showLightbox" data-wp-on-async--load="callbacks.setButtonStyles" data-wp-on-async-window--resize="callbacks.setButtonStyles" data-id="19091" src="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19091" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on-async--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6914297fc640e&quot;}" data-wp-interactive="core/image" data-wp-key="6914297fc640e" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on-async--click="actions.showLightbox" data-wp-on-async--load="callbacks.setButtonStyles" data-wp-on-async-window--resize="callbacks.setButtonStyles" data-id="19083" src="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19083" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on-async--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>The mix of experience in the room made this year especially notable. First-time contributors were paired with seasoned table leads who guided them through their first steps into open source contribution. Longtime contributors reconnected with their teams and advanced ongoing initiatives, while new voices added fresh perspectives and momentum. The spirit of mentorship was woven throughout, ensuring that Contributor Day was productive and welcoming.</p>\n\n\n\n<p>The results spoke for themselves:</p>\n\n\n\n<ul class="wp-block-list">\n<li><strong>Polyglots</strong> translated more than 12,000 strings, expanding WordPress’s accessibility worldwide.</li>\n\n\n\n<li>The <strong>Community team</strong> celebrated the approval of two brand-new local meetups.</li>\n\n\n\n<li>The <strong>Training team</strong> achieved its objective of updating outdated course thumbnails.</li>\n\n\n\n<li>The <strong>Core team</strong> worked through a live bug scrub, with 9 committers and 16 contributors collaborating on improvements.</li>\n\n\n\n<li>The <strong>Documentation team</strong> completed numerous content updates to keep resources fresh and reliable.</li>\n</ul>\n\n\n\n<p>Momentum carried through every table, with participants reporting measurable progress and a renewed sense of shared purpose. Contributor Day once again highlighted the unique power of collaboration in shaping the open web, proving that every contribution matters through code, translations, training, or community building.</p>\n\n\n\n<h2 class="wp-block-heading">Showcase Day: WordPress in Action</h2>\n\n\n\n<p>Wednesday, August 27, was the popular Showcase Day, spotlighting real-world innovation in WordPress. Initially expected to draw about 250 participants, Showcase Day welcomed more than 800 attendees — a powerful sign of how much energy and curiosity the community brought to Portland. The sessions demonstrated how WordPress powers meaningful work across industries from nonprofits to newsrooms, agencies to global enterprises, while staying true to open source values.</p>\n\n\n\n<p>The day opened with a keynote by Amy Sample Ward: <em>The Tech That Comes Next</em>. Drawing from their co-authored book with Afua Bruce, Amy highlighted the inequities embedded in today’s technologies — from dataset bias to accessibility gaps — and challenged attendees to rethink how tools are funded, built, and deployed. Their talk invited technologists, funders, and community leaders to imagine a more equitable digital future, rooted in collaboration and shared responsibility.</p>\n\n\n\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n<iframe loading="lazy" title="WordCamp US 2025 - Amy Sample Ward &quot;The Tech That Comes Next&quot;" width="500" height="281" src="https://www.youtube.com/embed/RKnM75GFZxw?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>From there, <a href="https://youtu.be/PGvh7fCOUk0">Joeleen Kennedy</a> of Human Made shared how Full Site Editing (FSE) shapes the refresh of Wikimedia’s ongoing user experience. Her session <em>Modernizing at Scale</em> detailed how FSE is simplifying workflows, improving accessibility, and making the multilingual platform more sustainable for the long term. Attendees gained a behind-the-scenes look at how one of the world’s largest open knowledge platforms is leveraging WordPress innovation.</p>\n\n\n\n<p><a href="https://youtu.be/F4NEPcwGRCI">Josh Bryant</a> took the stage to explore what happens when Gutenberg leaves the WP-Admin dashboard. His talk, <em>Reimagining WordPress Editing</em>, walked through embedding the block editor into a standalone React application to support Dow Jones’s newsroom workflows. From decoupling Gutenberg to managing custom data stores, the session showcased advanced techniques for scaling editorial tools while maintaining the flexibility of the WordPress ecosystem.</p>\n\n\n\n<p>Hands-on learning was a hallmark of Showcase Day, with Jamie Marsland’s workshop leading participants through building and launching their own professional portfolio sites — no coding required. Attendees left with a fully functioning site, demonstrating WordPress’s continued ability to empower anyone, anywhere, to publish online.</p>\n\n\n\n<p>In the afternoon, Jeffrey Paul’s session <em>Scalable, Ethical AI</em> addressed one of the most pressing topics in today’s digital world: how to integrate AI without sacrificing ownership, privacy, or open standards. Walking participants through practical use cases with ClassifAI and local LLMs, Paul emphasized how WordPress can help content creators harness AI while maintaining autonomy over their data.</p>\n\n\n\n<p>The day closed with a forward-looking community highlight: <a href="https://events.wordpress.org/campusconnect/">WordPress Campus Connect</a>. Panelists <a href="https://youtu.be/ARqM9U0ESvo">Destiny Kanno, Andrés Parra, Javier Montes de Blas, Mauricio Barrantes, and Elineth Morera Campos</a> shared how this initiative brings WordPress into classrooms and universities worldwide. Student Andrés Parra received a scholarship to attend WordCamp. During the panel, Elineth also announced that Fidélitas University will begin offering its students a <a href="https://wordpress.org/news/2025/07/introducing-wordpress-credits-a-new-contribution-internship-program-for-university-students/">WordPress Credits</a> program starting in October 2025, making it a mandatory addition sometime in 2026, enabling them to contribute directly to WordPress as part of their studies.</p>\n\n\n\n<p>By connecting students and educators with the open web, Campus Connect is building the next generation of contributors and innovators, ensuring that WordPress remains both a learning tool and a pathway to opportunity.</p>\n\n\n\n<p>Taken together, Showcase Day affirmed that WordPress is more than just a CMS — it is a platform for equitable technology, global collaboration, cutting-edge enterprise solutions, and the future of digital education. WordPress has the power to be both a platform and a community tool for education, equity, and innovation.</p>\n\n\n\n<h2 class="wp-block-heading">Presentation Days: Learning, Inspiration, and Connection</h2>\n\n\n\n<p>The first full day of sessions at WordCamp US 2025 opened with warm remarks from the organizing team, who reminded attendees: <em>“The most important thanks goes to all of you. The mix of new energy and veteran experience is what makes WordCamp so special, so thank you for being here.”</em> That spirit of gratitude and community carried throughout the event.</p>\n\n\n\n<p>The Sponsor Hall became a hub of activity, complete with raffles, the return of Career Corner, and even a Voodoo Donut Truck parked outside. Attendees lined up to test their luck at a claw machine stuffed with plush Wapuus, while others sought guidance at the Happiness Bar — a hands-on help desk for WordPress questions big and small. Between these activities, the steady buzz of conversations made it clear: the “hallway track” remained one of WordCamp’s most valuable experiences.</p>\n\n\n\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n<iframe loading="lazy" title="WordCamp US - Danny Sullivan &quot;How (and why!) Google Search Keeps Evolving&quot;" width="500" height="281" src="https://www.youtube.com/embed/ZF_sxLdfTbY?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>The program itself set a high bar. Danny Sullivan’s keynote shed light on how search has evolved to meet the needs of new generations, from 24/7 demand and mobile expectations to short-form video and AI. His session gave attendees a deeper understanding of how search intersects with publishing today and sparked conversations about how WordPress can continue adapting in an era where AI shapes discovery and content.</p>\n\n\n\n<p>From there, the schedule unfolded across multiple tracks. The Core AI panel — featuring <a href="https://youtu.be/v_0O6dQ4Q4E">James LePage, Felix Arntz, and Jeffrey Paul</a> — offered a look into how AI tools are woven into WordPress core. Emphasizing ethics, transparency, and user empowerment, the panel painted a roadmap for how WordPress can adopt new technologies without compromising its open-source values.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1024%2C576&#038;ssl=1" alt="" class="wp-image-19103" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?w=1600&amp;ssl=1 1600w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<p>Hands-on learning played a significant role throughout the conference. Ryan Welcher’s interactive <em>Block Developer Cookbook</em> drew a packed room as participants worked through community-selected code recipes built on the latest WordPress APIs. By the end, attendees left with working examples and practical strategies they could bring back to their projects.</p>\n\n\n\n<p>The program also highlighted diverse technical perspectives. <a href="https://youtu.be/vBjNqdacbh4">Jemima Abu’s</a> session, <em>A PHP Developer’s Guide to ReactJS</em>, bridged the gap between classic and modern web development. At the same time, Adam Gazzaley’s keynote, <em>A New Era of Experiential Medicine – AI and the Brain</em>, invited attendees to consider the human side of technology, exploring how digital tools can advance health and well-being.</p>\n\n\n\n<p>The second day of presentations, Friday, August 29, opened with creativity and imagination. <a href="https://youtu.be/O7FPiFpRI3o">John Maeda’s</a> keynote, <em>Cozy AI Cooking: WordCamp Edition</em>, used the metaphor of a kitchen to demystify AI, blending storytelling with technical insight to show how curiosity and care can guide builders in integrating AI into their work.</p>\n\n\n\n<p>Later in the day, <a href="https://youtu.be/ORnJTpjA-4w">Tammie Lister’s</a> <em>The System is the Strategy</em> illustrated how design systems provide structure and scalability for growing WordPress projects. At the same time, Adam Silverstein’s Unlock Developer Superpowers with AI showcased new ways developers can use emerging tools to speed up workflows and problem-solving.</p>\n\n\n\n<p>Community stories also took center stage. In Creators around a Campfire, Anne McCarthy, Jamie Marsland, Christian Taylor, Mark Szymanski, and Michael Cunningham reflected on how YouTubers and content creators shape the WordPress ecosystem. Their session highlighted the role of storytelling and education in expanding WordPress’s reach to new audiences worldwide.</p>\n\n\n\n<p>The Sponsor Hall remained lively between sessions — with attendees meeting companies, testing demos, and swapping ideas that extended far beyond the conference halls. They also shared moments together at the arcade built for the event and added smiles, hugs, and laughter, which underscored the atmosphere: WordCamp US was as much about connection as code.</p>\n\n\n\n<h2 class="wp-block-heading">Together Into the Future</h2>\n\n\n\n<p>As the event drew to a close, WordPress Cofounder Matt Mullenweg took the stage to share the current state of WordPress and a vision for its future. He highlighted the growth in social media for WordPress with 124,726 new followers since last WCUS — and the WordPress.org website growing over 10% in users along with almost 20% in new users. </p>\n\n\n\n<p>Matt also spotlighted community initiatives shaping the future of open source education and diversity: WordPress Campus Connect, which has already reached 570 students across 11 events. Combined with the growth in overall events (77) which is a 32.76% increase over 2024. Each effort reinforced the message that WordPress is more than software; it is a global movement driven by people.</p>\n\n\n\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n<iframe loading="lazy" title="WordCamp US 2025 - Ma.tt Mullenweg &quot;Keynote Address &amp; Q&amp;A&quot;" width="500" height="281" src="https://www.youtube.com/embed/45HRzzc0waU?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>He concluded with a live Q&amp;A, fielding questions from the audience on the direction of WordPress, its role in an AI-driven web, and the importance of keeping the project open, inclusive, and adaptable. The final notes of the keynote carried into a closing party in downtown Portland, where attendees capped off the week with music, conversation, and the unmistakable joy of a community coming together.</p>\n\n\n\n<h2 class="wp-block-heading">Closing</h2>\n\n\n\n<p>WordCamp US 2025 once again demonstrated what makes the WordPress ecosystem extraordinary: a community committed to building tools, resources, and opportunities that empower people everywhere.</p>\n\n\n\n<p>This year also marked the debut of the <a href="https://airtable.com/appWF6hdXuEOFQMvV/shrV5RZIv0aJjjU00">Open Horizons Scholarship</a>, which funded six recipients — two organizers, three volunteers, and one speaker — from five countries. A total of $14,670 supported their journeys to WCUS. The scholarship, which also supports participation at WordCamp Asia and WordCamp Europe, is designed to make flagship events more accessible to contributors worldwide.</p>\n\n\n\n<p>A heartfelt thank you goes to the organizers, volunteers, sponsors, and speakers who brought the Portland edition to life — and to every attendee who joined us in person or followed along online. We hope you leave with fresh ideas, meaningful connections, and renewed energy to help shape the future of the open web.</p>\n\n\n\n<figure class="wp-block-gallery has-nested-images columns-default is-cropped has-black-background-color has-background wp-block-gallery-2 is-layout-flex wp-block-gallery-is-layout-flex" style="border-width:20px">\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6914297fc7811&quot;}" data-wp-interactive="core/image" data-wp-key="6914297fc7811" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="577" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on-async--click="actions.showLightbox" data-wp-on-async--load="callbacks.setButtonStyles" data-wp-on-async-window--resize="callbacks.setButtonStyles" data-id="19112" src="https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948.jpg?resize=1024%2C577&#038;ssl=1" alt="" class="wp-image-19112" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=1024%2C577&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=1536%2C865&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=2048%2C1153&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on-async--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button><figcaption class="wp-element-caption">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6914297fc7c5d&quot;}" data-wp-interactive="core/image" data-wp-key="6914297fc7c5d" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on-async--click="actions.showLightbox" data-wp-on-async--load="callbacks.setButtonStyles" data-wp-on-async-window--resize="callbacks.setButtonStyles" data-id="19124" src="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997.jpeg?resize=1024%2C576&#038;ssl=1" alt="" class="wp-image-19124" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on-async--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button><figcaption class="wp-element-caption">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6914297fc7f86&quot;}" data-wp-interactive="core/image" data-wp-key="6914297fc7f86" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on-async--click="actions.showLightbox" data-wp-on-async--load="callbacks.setButtonStyles" data-wp-on-async-window--resize="callbacks.setButtonStyles" data-id="19122" src="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014.jpeg?resize=1024%2C576&#038;ssl=1" alt="" class="wp-image-19122" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on-async--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button><figcaption class="wp-element-caption">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6914297fc8263&quot;}" data-wp-interactive="core/image" data-wp-key="6914297fc8263" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="577" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on-async--click="actions.showLightbox" data-wp-on-async--load="callbacks.setButtonStyles" data-wp-on-async-window--resize="callbacks.setButtonStyles" data-id="19107" src="https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752.jpg?resize=1024%2C577&#038;ssl=1" alt="" class="wp-image-19107" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=1024%2C577&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=1536%2C865&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=2048%2C1153&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on-async--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button><figcaption class="wp-element-caption">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6914297fc8615&quot;}" data-wp-interactive="core/image" data-wp-key="6914297fc8615" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="675" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on-async--click="actions.showLightbox" data-wp-on-async--load="callbacks.setButtonStyles" data-wp-on-async-window--resize="callbacks.setButtonStyles" data-id="19108" src="https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1024%2C675&#038;ssl=1" alt="" class="wp-image-19108" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1024%2C675&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=300%2C198&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=768%2C506&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1536%2C1012&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?w=1764&amp;ssl=1 1764w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on-async--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button><figcaption class="wp-element-caption">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6914297fc8a20&quot;}" data-wp-interactive="core/image" data-wp-key="6914297fc8a20" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on-async--click="actions.showLightbox" data-wp-on-async--load="callbacks.setButtonStyles" data-wp-on-async-window--resize="callbacks.setButtonStyles" data-id="19113" src="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076.jpeg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19113" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on-async--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6914297fc8da4&quot;}" data-wp-interactive="core/image" data-wp-key="6914297fc8da4" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="433" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on-async--click="actions.showLightbox" data-wp-on-async--load="callbacks.setButtonStyles" data-wp-on-async-window--resize="callbacks.setButtonStyles" data-id="19106" src="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809.jpeg?resize=1024%2C433&#038;ssl=1" alt="" class="wp-image-19106" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=1024%2C433&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=300%2C127&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=768%2C325&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=1536%2C650&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=2048%2C866&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on-async--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button><figcaption class="wp-element-caption">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6914297fc9099&quot;}" data-wp-interactive="core/image" data-wp-key="6914297fc9099" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on-async--click="actions.showLightbox" data-wp-on-async--load="callbacks.setButtonStyles" data-wp-on-async-window--resize="callbacks.setButtonStyles" data-id="19110" src="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19110" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?w=2048&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on-async--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6914297fc9387&quot;}" data-wp-interactive="core/image" data-wp-key="6914297fc9387" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on-async--click="actions.showLightbox" data-wp-on-async--load="callbacks.setButtonStyles" data-wp-on-async-window--resize="callbacks.setButtonStyles" data-id="19119" src="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827.jpeg?resize=1024%2C576&#038;ssl=1" alt="" class="wp-image-19119" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on-async--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button><figcaption class="wp-element-caption">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6914297fc96a4&quot;}" data-wp-interactive="core/image" data-wp-key="6914297fc96a4" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on-async--click="actions.showLightbox" data-wp-on-async--load="callbacks.setButtonStyles" data-wp-on-async-window--resize="callbacks.setButtonStyles" data-id="19133" src="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1024%2C576&#038;ssl=1" alt="" class="wp-image-19133" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?w=2048&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on-async--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>Be sure to mark your calendars for the next global gatherings: <a href="https://asia.wordcamp.org/2026/">WordCamp Asia 2026</a>&nbsp; in Mumbai, India, <a href="https://europe.wordcamp.org/2026/">WordCamp Europe 2026</a>&nbsp; in Kraków, Poland, and WordCamp US 2026 in Phoenix, Arizona. We can’t wait to see you at the next chapter of the WordPress story.</p>\n\n\n\n<p></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19074";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:69:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:60:"Portland, Are You Ready? The WCUS 2025 Schedule Has Arrived!";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:93:"https://wordpress.org/news/2025/08/portland-are-you-ready-the-wcus-2025-schedule-has-arrived/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 06 Aug 2025 20:03:43 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:5:{i:0;a:5:{s:4:"data";s:9:"Community";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:6:"Events";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:8:"WordCamp";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:4:"WCUS";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:9:"WordCamps";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19004";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:402:"We’re excited to announce that the full schedule for WordCamp US 2025 has been published! From August 26–29 in Portland, Oregon, join web creators, innovators, and community leaders for four days of learning, collaboration, and inspiration. This year’s lineup brings together sessions on everything from cutting-edge AI to hands-on workshops, performance, accessibility, design, and the [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Brett McSherry";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5698:"\n<p>We’re excited to announce that the full schedule for WordCamp US 2025 has been published! From August 26–29 in Portland, Oregon, join web creators, innovators, and community leaders for four days of learning, collaboration, and inspiration. This year’s lineup brings together sessions on everything from cutting-edge AI to hands-on workshops, performance, accessibility, design, and the future of WordPress.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader.png?resize=1024%2C576&#038;ssl=1" alt="" class="wp-image-19026" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=2048%2C1152&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<p class="has-text-align-center" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><strong>Check out the full schedule and start planning your WordCamp experience.</strong></p>\n\n\n\n<div class="wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex">\n<div class="wp-block-button is-style-fill"><a class="wp-block-button__link has-blue-1-background-color has-background wp-element-button" href="https://us.wordcamp.org/2025/schedule/">View The Schedule</a></div>\n</div>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity" />\n\n\n\n<h2 class="wp-block-heading">Contributor Day — Connect, Collaborate, and Give Back</h2>\n\n\n\n<p>Kicking off the week on Tuesday, August 26 is Contributor Day, it is your chance to roll up your sleeves and make a direct impact on WordPress. Whether you’re a seasoned developer, creative designer, translator, marketer, or simply passionate about open source, there’s a place for you to get involved. Join WordPress teams working on real projects, share your skills, and connect with people across the global community. Contributor Day is also a fantastic place for hiring managers or business owners to meet emerging talent and see contributors in action. Lunch is provided, and both in-person and select remote participation options are available. If you’ve ever wanted to help shape the future of WordPress, this is your moment!<br></p>\n\n\n\n<p>Read more: <a href="https://us.wordcamp.org/2025/schedule/#contributor-day">Start planning your Contributor Day activities &gt;&gt;</a></p>\n\n\n\n<h2 class="wp-block-heading">Showcase Day — See WordPress in Action</h2>\n\n\n\n<p>Showcase Day on Wednesday, August 27, shines a spotlight on what&#8217;s possible with WordPress. Get inspired by live demos, case studies, and actionable presentations from experts and innovators using WordPress in creative and impactful ways. You’ll see how changemakers, nonprofits, publishers, and agencies use WordPress to solve real-world problems, build new products, and drive the web forward. Highlights include hands-on workshops, technical talks, and practical sessions covering everything from design systems to modern AI. It’s a full day dedicated to celebrating the talent, creativity, and innovation of the WordPress community.</p>\n\n\n\n<p>Read more: <a href="https://us.wordcamp.org/2025/schedule/#showcase-day">See where these inspirational showcases take you &gt;&gt;</a></p>\n\n\n\n<h2 class="wp-block-heading">Conference Days — Learn, Connect, and Level Up</h2>\n\n\n\n<p>The main event days for Thursday and Friday, August 28-29, feature a robust mix of technical deep-dives, product masterclasses, and sessions designed for all experience levels. Whether you’re a developer, designer, business owner, or just starting out, you’ll find plenty to explore—from future-focused discussions on AI and performance to hands-on workshops and networking events that bring the community together.</p>\n\n\n\n<p><strong>Keynote Highlights:</strong></p>\n\n\n\n<ul class="wp-block-list">\n<li><strong>Amy Sample Ward, CEO of NTEN:</strong> The Tech That Comes Next: How Changemakers, Philanthropists, and Technologists Can Build an Equitable World. Featured Wednesday, August 27.</li>\n\n\n\n<li><strong>Danny Sullivan, from Google Search</strong>: Industry leader, featured Thursday, August 28.</li>\n\n\n\n<li><strong>Matt Mullenweg, Co-founder of WordPress:</strong> Featured Friday, August 29.</li>\n\n\n\n<li>More keynotes announcing soon!</li>\n</ul>\n\n\n\n<p>With dozens of sessions across multiple tracks, plus workshops and networking opportunities, WordCamp US is set to be an unforgettable experience. Don’t miss your chance to connect, share ideas, and help shape the future of the web.</p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity" />\n\n\n\n<p class="has-text-align-center"><strong>Check out the full schedule and start planning your WordCamp experience.</strong></p>\n\n\n\n<div class="wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex">\n<div class="wp-block-button is-style-fill"><a class="wp-block-button__link has-blue-1-background-color has-background wp-element-button" href="https://us.wordcamp.org/2025/schedule/">View The Schedule</a></div>\n</div>\n\n\n\n<p></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19004";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:63:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:54:"Maintenance Releases for WordPress branches 4.7 to 6.7";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:90:"https://wordpress.org/news/2025/08/maintenance-releases-for-wordpress-branches-4-7-to-6-7/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 05 Aug 2025 19:11:05 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:3:{i:0;a:5:{s:4:"data";s:7:"General";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:14:"minor-releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:8:"releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=18997";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:374:"Following on from the WordPress 6.8.2 maintenance release last month, the included update to the root security certificate bundle has been backported to all branches back to 4.7. This ensures that when your site performs server-side HTTP requests, the most up-to-date information about trusted security certificates is used. Further information can be found on the [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:15:"John Blackbourn";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:2119:"\n<p>Following on from <a href="https://wordpress.org/news/2025/07/wordpress-6-8-2-maintenance-release/">the WordPress 6.8.2 maintenance release last month</a>, the included update to the root security certificate bundle has been backported to all branches back to 4.7. This ensures that when your site performs server-side HTTP requests, the most up-to-date information about trusted security certificates is used. Further information can be found on <a href="https://core.trac.wordpress.org/ticket/62811">the Core Trac ticket</a>.</p>\n\n\n\n<p>A new maintenance release for each branch from 4.7 to 6.7 is now available. If you have sites on these branches and they support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>The latest and only supported version of WordPress remains as 6.8.2. This is being done as a courtesy for sites still running older versions of WordPress. You can <a href="https://wordpress.org/wordpress-6.8.2.zip">download WordPress 6.8.2 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”.</p>\n\n\n\n<h2 class="wp-block-heading">Thank you to these WordPress contributors</h2>\n\n\n\n<p>Special thanks to <a href=\'https://profiles.wordpress.org/desrosj/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>desrosj</a>, <a href=\'https://profiles.wordpress.org/ocean90/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ocean90</a>, <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/peterwilsoncc/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>peterwilsoncc</a>, <a href=\'https://profiles.wordpress.org/jorbin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jorbin</a>, <a href=\'https://profiles.wordpress.org/estelaris/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>estelaris</a>, and <a href=\'https://profiles.wordpress.org/johnbillion/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>johnbillion</a> for backporting and releasing this update.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"18997";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:63:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:35:"WordPress 6.8.2 Maintenance Release";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:71:"https://wordpress.org/news/2025/07/wordpress-6-8-2-maintenance-release/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 15 Jul 2025 15:41:50 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:3:{i:0;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:14:"minor-releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:8:"releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=18903";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:357:"WordPress 6.8.2 is now available! This minor release includes fixes for 20 Core tickets and 15 Block Editor issues. For a full list of bug fixes, please refer to the release candidate announcement. WordPress 6.8.2 is a short-cycle maintenance release. More maintenance releases may be made available throughout 2025. If you have sites that support [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:9:"Jb Audras";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:10720:"\n<h2 class="wp-block-heading">WordPress 6.8.2 is now available!</h2>\n\n\n\n<p>This minor release includes fixes for <a href="https://core.trac.wordpress.org/query?resolution=fixed&amp;milestone=6.8.2&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority">20 Core tickets</a> and <a href="https://github.com/WordPress/gutenberg/pull/70557">15 Block Editor issues</a>. For a full list of bug fixes, please refer to the <a href="https://make.wordpress.org/core/2025/07/08/wordpress-6-8-2-rc1-is-now-available/">release candidate announcement.</a></p>\n\n\n\n<p>WordPress 6.8.2 is a short-cycle maintenance release. More maintenance releases may be made available throughout 2025.</p>\n\n\n\n<p>If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>You can <a href="https://wordpress.org/wordpress-6.8.2.zip">download WordPress 6.8.2 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. For more information on this release, please <a href="https://wordpress.org/support/wordpress-version/version-6-8-2">visit the HelpHub version page</a>.</p>\n\n\n\n<h2 class="wp-block-heading">Dropping security updates for WordPress versions 4.1 through 4.6</h2>\n\n\n\n<p>This is not directly related to the 6.8.2 maintenance release, but <a href="https://wordpress.org/news/2025/06/dropping-security-updates-for-wordpress-versions-4-1-through-4-6/">branches 4.1 to 4.6 had their final release today</a>. These branches won&#8217;t receive any security update anymore.</p>\n\n\n\n<h2 class="wp-block-heading">Thank you to these WordPress contributors</h2>\n\n\n\n<p>WordPress 6.8.2 was led by <a href="https://profiles.wordpress.org/audrasjb/">Jb Audras</a>,&nbsp;<a href="https://profiles.wordpress.org/estelaris/">Estela Rueda</a>&nbsp;and&nbsp;<a href="https://profiles.wordpress.org/zunaid321/">Zunaid Amin</a>.</p>\n\n\n\n<p>Special thanks to <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/sergeybiryukov/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>sergeybiryukov</a>, <a href=\'https://profiles.wordpress.org/mamaduka/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mamaduka</a>, <a href=\'https://profiles.wordpress.org/wildworks/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>wildworks</a> and <a href=\'https://profiles.wordpress.org/jorbin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jorbin</a> for their help on specific release tasks.</p>\n\n\n\n<p>WordPress 6.8.2 would not have been possible without the contributions of the following 96 people. Their asynchronous coordination to deliver maintenance fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p class="is-style-wporg-props-medium has-white-color has-midnight-gradient-background has-text-color has-background has-link-color has-normal-font-size wp-elements-2ad7deb15a87fd29427f001e4c18a1ac"><a href="https://profiles.wordpress.org/jorbin">Aaron Jorbin</a>, <a href="https://profiles.wordpress.org/adamsilverstein">Adam Silverstein</a>, <a href="https://profiles.wordpress.org/zieladam">Adam Zieliński</a>, <a href="https://profiles.wordpress.org/wildworks">Aki Hamano</a>, <a href="https://profiles.wordpress.org/alexstine">Alex Stine</a>, <a href="https://profiles.wordpress.org/anatolbroder">Anatol Broder</a>, <a href="https://profiles.wordpress.org/afercia">Andrea Fercia</a>, <a href="https://profiles.wordpress.org/nacin">Andrew Nacin</a>, <a href="https://profiles.wordpress.org/ankitkumarshah">Ankit Kumar Shah</a>, <a href="https://profiles.wordpress.org/annezazu">annezazu</a>, <a href="https://profiles.wordpress.org/azharderaiya">Azhar Deraiya</a>, <a href="https://profiles.wordpress.org/benjamingosset">Benjamin Gosset</a>, <a href="https://profiles.wordpress.org/bhubbard">Brandon Hubbard</a>, <a href="https://profiles.wordpress.org/kraftbj">Brandon Kraft</a>, <a href="https://profiles.wordpress.org/brhodes">brhodes</a>, <a href="https://profiles.wordpress.org/poena">Carolina Nymark</a>, <a href="https://profiles.wordpress.org/czarate">Chris Zarate</a>, <a href="https://profiles.wordpress.org/courane01">Courtney Robertson</a>, <a href="https://profiles.wordpress.org/talldanwp">Daniel Richards</a>, <a href="https://profiles.wordpress.org/darshitrajyaguru97">Darshit Rajyaguru</a>, <a href="https://profiles.wordpress.org/davidbaumwald">David Baumwald</a>, <a href="https://profiles.wordpress.org/dmsnell">Dennis Snell</a>, <a href="https://profiles.wordpress.org/dhruvang21">Dhruvang21</a>, <a href="https://profiles.wordpress.org/dilipbheda">Dilip Bheda</a>, <a href="https://profiles.wordpress.org/dd32">Dion Hulse</a>, <a href="https://profiles.wordpress.org/divinenephron">divinenephron</a>, <a href="https://profiles.wordpress.org/dustintechsmith">dustintechsmith</a>, <a href="https://profiles.wordpress.org/ericlewis">Eric Andrew Lewis</a>, <a href="https://profiles.wordpress.org/im3dabasia1">Eshaan Dabasiya</a>, <a href="https://profiles.wordpress.org/estelaris">Estela Rueda</a>, <a href="https://profiles.wordpress.org/eherman24">Evan Herman</a>, <a href="https://profiles.wordpress.org/fabiankaegy">Fabian Kägy</a>, <a href="https://profiles.wordpress.org/faisalahammad">Faisal Ahammad</a>, <a href="https://profiles.wordpress.org/flixos90">Felix Arntz</a>, <a href="https://profiles.wordpress.org/pento">Gary Pendergast</a>, <a href="https://profiles.wordpress.org/guddu1315">Gaurang Dabhi</a>, <a href="https://profiles.wordpress.org/mamaduka">George Mamadashvili</a>, <a href="https://profiles.wordpress.org/gernberg">gernberg</a>, <a href="https://profiles.wordpress.org/gziolo">Greg Ziółkowski</a>, <a href="https://profiles.wordpress.org/harshgajipara">Harsh Gajipara</a>, <a href="https://profiles.wordpress.org/helgatheviking">HelgaTheViking</a>, <a href="https://profiles.wordpress.org/abcd95">Himanshu Pathak</a>, <a href="https://profiles.wordpress.org/audrasjb">Jb Audras</a>, <a href="https://profiles.wordpress.org/JeffPaul">Jeffrey Paul</a>, <a href="https://profiles.wordpress.org/jdy68">Jenny Dupuy</a>, <a href="https://profiles.wordpress.org/luminuu">Jessica Lyschik</a>, <a href="https://profiles.wordpress.org/jigarpanchal">Jigar Panchal</a>, <a href="https://profiles.wordpress.org/joedolson">Joe Dolson</a>, <a href="https://profiles.wordpress.org/joemcgill">Joe McGill</a>, <a href="https://profiles.wordpress.org/johnbillion">John Blackbourn</a>, <a href="https://profiles.wordpress.org/mindctrl">John Parris</a>, <a href="https://profiles.wordpress.org/jonsurrell">Jon Surrell</a>, <a href="https://profiles.wordpress.org/desrosj">Jonathan Desrosiers</a>, <a href="https://profiles.wordpress.org/spacedmonkey">Jonny Harris</a>, <a href="https://profiles.wordpress.org/kausaralm">Kausar Alam</a>, <a href="https://profiles.wordpress.org/kishanjasani">Kishan Jasani</a>, <a href="https://profiles.wordpress.org/tyxla">Marin Atanasov</a>, <a href="https://profiles.wordpress.org/matt">Matt Mullenweg</a>, <a href="https://profiles.wordpress.org/pfefferle">Matthias Pfefferle</a>, <a href="https://profiles.wordpress.org/megane9988">megane9988</a>, <a href="https://profiles.wordpress.org/mosescursor">Moses Cursor Ssebunya</a>, <a href="https://profiles.wordpress.org/mukesh27">Mukesh Panchal</a>, <a href="https://profiles.wordpress.org/mwillman1991">mwillman1991</a>, <a href="https://profiles.wordpress.org/bugnumber9">Nazar Hotsa</a>, <a href="https://profiles.wordpress.org/nidhidhandhukiya">nidhidhandhukiya</a>, <a href="https://profiles.wordpress.org/nikunj8866">Nikunj Hatkar</a>, <a href="https://profiles.wordpress.org/oferlaor">oferlaor</a>, <a href="https://profiles.wordpress.org/oglekler">Olga Gleckler</a>, <a href="https://profiles.wordpress.org/swissspidy">Pascal Birchler</a>, <a href="https://profiles.wordpress.org/paulstanos">paulstanos</a>, <a href="https://profiles.wordpress.org/peterwilsoncc">Peter Wilson</a>, <a href="https://profiles.wordpress.org/puggan">puggan</a>, <a href="https://profiles.wordpress.org/ravigadhiyawp">Ravi Gadhiya</a>, <a href="https://profiles.wordpress.org/youknowriad">Riad Benguella</a>, <a href="https://profiles.wordpress.org/rollybueno">Rolly Bueno</a>, <a href="https://profiles.wordpress.org/room34">room34</a>, <a href="https://profiles.wordpress.org/sainathpoojary">Sainath Poojary</a>, <a href="https://profiles.wordpress.org/sajjad67">Sajjad Hossain Sagor</a>, <a href="https://profiles.wordpress.org/Sam_a">sam_a</a>, <a href="https://profiles.wordpress.org/sandeepdahiya">Sandeep Dahiya</a>, <a href="https://profiles.wordpress.org/SergeyBiryukov">Sergey Biryukov</a>, <a href="https://profiles.wordpress.org/shanemuir">Shane Muirhead</a>, <a href="https://profiles.wordpress.org/siliconforks">siliconforks</a>, <a href="https://profiles.wordpress.org/sirlouen">SirLouen</a>, <a href="https://profiles.wordpress.org/sabernhardt">Stephen Bernhardt</a>, <a href="https://profiles.wordpress.org/sukhendu2002">Sukhendu Sekhar Guria</a>, <a href="https://profiles.wordpress.org/karmatosed">Tammie Lister</a>, <a href="https://profiles.wordpress.org/TobiasBg">Tobias Bäthge</a>, <a href="https://profiles.wordpress.org/wpsmith">Travis Smith</a>, <a href="https://profiles.wordpress.org/ugyensupport">Ugyen Dorji</a>, <a href="https://profiles.wordpress.org/uxl">uxl</a>, <a href="https://profiles.wordpress.org/westonruter">Weston Ruter</a>, <a href="https://profiles.wordpress.org/whaze">whaze</a>, <a href="https://profiles.wordpress.org/getsyash">Yash B</a>, <a href="https://profiles.wordpress.org/yogeshbhutkar">Yogesh Bhutkar</a>, and <a href="https://profiles.wordpress.org/zunaid321">Zunaid Amin</a></p>\n\n\n\n<h2 class="wp-block-heading">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac, <a href="https://core.trac.wordpress.org/report/6">pick a ticket</a>, and join the conversation on Slack, in the <a href="https://wordpress.slack.com/archives/C02RQBWTW">#core</a> and <a href="https://wordpress.slack.com/archives/C080HLPP2Q6">#6-8-release-leads</a> channels. Need help? Check out the <a href="https://make.wordpress.org/core/handbook/">Core Contributor Handbook</a>.</p>\n\n\n\n<p class="has-text-align-right"><em>Thanks to <a href=\'https://profiles.wordpress.org/estelaris/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>estelaris</a> and <a href=\'https://profiles.wordpress.org/zunaid321/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>zunaid321</a> for proofreading.</em></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"18903";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:60:"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:71:"Celebrating Kim Parsell: 2025 WordCamp US Scholarship Applications Open";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:87:"https://wordpress.org/news/2025/07/kim-parsell-2025-wcus-scholarship-applications-open/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 14 Jul 2025 18:57:47 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:9:"Community";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:8:"WordCamp";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=18911";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:364:"The WordPress Foundation is pleased to announce the return of the Kim Parsell Memorial Scholarship for WordCamp US 2025. Applications are being accepted until July 25, 2025. Remembering Kim Parsell Kim Parsell was a dedicated contributor and a beloved member of the WordPress community. Her passion for open source and her welcoming spirit inspired many, [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Brett McSherry";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:6224:"\n<p>The WordPress Foundation is pleased to announce the return of the <strong>Kim Parsell Memorial Scholarship</strong> for WordCamp US 2025. Applications are being accepted until <strong>July 25, 2025</strong>.</p>\n\n\n\n<figure class="wp-block-image aligncenter size-full has-custom-border"><img data-recalc-dims="1" loading="lazy" decoding="async" width="604" height="370" src="https://i0.wp.com/wordpress.org/news/files/2025/07/wpdocs-team-1.webp?resize=604%2C370&#038;ssl=1" alt="" class="wp-image-18912" style="border-width:25px;border-radius:40px" srcset="https://i0.wp.com/wordpress.org/news/files/2025/07/wpdocs-team-1.webp?w=604&amp;ssl=1 604w, https://i0.wp.com/wordpress.org/news/files/2025/07/wpdocs-team-1.webp?resize=300%2C184&amp;ssl=1 300w" sizes="auto, (max-width: 604px) 100vw, 604px" /></figure>\n\n\n\n<div class="wp-block-group has-off-white-2-background-color has-background is-layout-constrained wp-container-core-group-is-layout-6cbf45de wp-block-group-is-layout-constrained" style="margin-top:48px;margin-bottom:48px;padding-top:24px;padding-bottom:24px">\n<div class="wp-block-columns is-not-stacked-on-mobile is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex">\n<div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow" style="flex-basis:2%"></div>\n\n\n\n<div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow" style="flex-basis:96%">\n<h2 class="wp-block-heading">Remembering Kim Parsell</h2>\n\n\n\n<div class="wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex">\n<div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow" style="flex-basis:40%">\n<figure class="wp-block-image size-full"><img data-recalc-dims="1" loading="lazy" decoding="async" width="400" height="400" src="https://i0.wp.com/wordpress.org/news/files/2025/07/Kim-parsell-twitter-image-2.jpeg?resize=400%2C400&#038;ssl=1" alt="" class="wp-image-18956" srcset="https://i0.wp.com/wordpress.org/news/files/2025/07/Kim-parsell-twitter-image-2.jpeg?w=400&amp;ssl=1 400w, https://i0.wp.com/wordpress.org/news/files/2025/07/Kim-parsell-twitter-image-2.jpeg?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/07/Kim-parsell-twitter-image-2.jpeg?resize=150%2C150&amp;ssl=1 150w" sizes="auto, (max-width: 400px) 100vw, 400px" /></figure>\n</div>\n\n\n\n<div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow" style="flex-basis:60%">\n<p>Kim Parsell was a dedicated contributor and a beloved member of the WordPress community. Her passion for open source and her welcoming spirit inspired many, both online and in person. Each year at WordCamp US, the WordPress Foundation celebrates Kim’s legacy by supporting contributors who share her commitment and enthusiasm. The Kim Parsell Memorial Scholarship aims to make it easier for deserving community members to attend WordCamp US, reflecting Kim’s belief in making WordPress accessible and inclusive for all.</p>\n</div>\n</div>\n\n\n\n<p style="padding-top:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10)">If you’re unfamiliar with Kim’s story or her invaluable role in the community, we encourage you to <a href="https://us.wordcamp.org/2019/memories-of-kim-parsell/">read these heartfelt tributes</a> collected from friends and colleagues.</p>\n</div>\n\n\n\n<div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow" style="flex-basis:2%"></div>\n</div>\n</div>\n\n\n\n<h2 class="wp-block-heading">Scholarship Eligibility</h2>\n\n\n\n<p>This year, a single scholarship will be awarded. To qualify, applicants must:</p>\n\n\n\n<ul class="wp-block-list">\n<li>Identify as a woman</li>\n\n\n\n<li>Be actively involved as a contributor to WordPress</li>\n\n\n\n<li>Have never attended WordCamp US before</li>\n\n\n\n<li>Demonstrate a need for financial support to attend the event</li>\n</ul>\n\n\n\n<p>If you meet these qualifications, we invite you to apply before the July 25 deadline. All applicants will be notified of the decision by August 7, 2025.</p>\n\n\n\n<p>For additional information, visit the <a href="https://wordpressfoundation.org/projects/kim-parsell-memorial-scholarship/">Kim Parsell Memorial Scholarship page</a> hosted by the WordPress Foundation.</p>\n\n\n\n<div class="wp-block-group has-off-white-2-background-color has-background is-layout-constrained wp-container-core-group-is-layout-8503c47b wp-block-group-is-layout-constrained">\n<div style="height:50px" aria-hidden="true" class="wp-block-spacer"></div>\n\n\n\n<p class="has-text-align-center has-large-font-size"><strong>Ready to Apply?</strong></p>\n\n\n\n<div style="height:25px" aria-hidden="true" class="wp-block-spacer"></div>\n\n\n\n<div class="wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex">\n<div class="wp-block-button"><a class="wp-block-button__link has-text-align-center wp-element-button" href="https://wordcampcentral.survey.fm/wcus-2025-kim-parsell-scholarship-application">Submit Your Application Today</a></div>\n</div>\n\n\n\n<div style="height:50px" aria-hidden="true" class="wp-block-spacer"></div>\n</div>\n\n\n\n<figure class="wp-block-image aligncenter size-full has-custom-border"><img data-recalc-dims="1" loading="lazy" decoding="async" width="500" height="333" src="https://i0.wp.com/wordpress.org/news/files/2025/07/kim-jose.jpeg?resize=500%2C333&#038;ssl=1" alt="" class="wp-image-18917" style="border-width:25px;border-radius:40px" srcset="https://i0.wp.com/wordpress.org/news/files/2025/07/kim-jose.jpeg?w=500&amp;ssl=1 500w, https://i0.wp.com/wordpress.org/news/files/2025/07/kim-jose.jpeg?resize=300%2C200&amp;ssl=1 300w" sizes="auto, (max-width: 500px) 100vw, 500px" /></figure>\n\n\n\n<h2 class="wp-block-heading">Join the Celebration</h2>\n\n\n\n<ul class="wp-block-list">\n<li>Tickets for WordCamp US 2025 are now available—secure yours soon!</li>\n\n\n\n<li>Volunteer applications are open until July 11, 2025</li>\n\n\n\n<li>Interested in supporting the event? Explore our <a>sponsorship opportunities</a></li>\n</ul>\n\n\n\n<p>Help us spread the word about this opportunity and make WordCamp US 2025 even more special.</p>\n\n\n\n<p></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"18911";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:63:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:92:"Introducing WordPress Credits: A New Contribution Internship Program for University Students";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:127:"https://wordpress.org/news/2025/07/introducing-wordpress-credits-a-new-contribution-internship-program-for-university-students/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 10 Jul 2025 16:56:52 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:3:{i:0;a:5:{s:4:"data";s:9:"Community";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:9:"community";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:17:"WordPress Credits";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=18913";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:393:"The WordPress Foundation is proud to launch WordPress Credits, a contribution-focused internship program that brings university students into the heart of the WordPress open source project. While WordPress thrives on contributions from a global volunteer community, many students and newcomers face barriers to entry, such as a lack of structured guidance or real-world experience in [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"Isotta Peira";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:4712:"\n<p>The WordPress Foundation is proud to launch WordPress Credits, a contribution-focused internship program that brings university students into the heart of the WordPress open source project. While WordPress thrives on contributions from a global volunteer community, many students and newcomers face barriers to entry, such as a lack of structured guidance or real-world experience in open source projects. This new program is designed to bridge that gap, nurturing future contributors and ensuring WordPress remains innovative, inclusive, and sustainable for years to come.</p>\n\n\n\n<p>The <a href="https://gamma.app/docs/EN-WordPress-Credits-vz0k2vr1ulg91qq?mode=doc">pilot program</a>, developed in partnership with the University of Pisa, was announced on stage at WordCamp Europe 2025 by Matt Mullenweg and Mary Hubbard. Since then, it has attracted interest from students across various fields of study, including humanities, computer science, and communication. Companies in the WordPress ecosystem have also expressed support and interest in contributing to the project. In response to the growing interest from both community members and academic institutions, we are now inviting more universities to join the initiative.</p>\n\n\n\n<p>Open to students from all fields of study, the program blends structured onboarding with a personalized contribution project. Activities are adapted to each student’s degree program and familiarity with WordPress, aiming to develop transferable skills, academic-related competencies, and active participation in the WordPress community. Internship durations may vary depending on the university or educational institution. Some may align with academic semesters (typically 3–4 months), while others, like the University of Pisa, allow students to sign up year-round with a requirement to complete a set number of contribution hours (e.g. 150 hours). Flexible arrangements can be discussed to meet the specific requirements of each institution.</p>\n\n\n\n<p>Foundational Training includes:</p>\n\n\n\n<ul class="wp-block-list">\n<li>An introduction to open source principles and the WordPress Foundation</li>\n\n\n\n<li>Getting familiar with community tools (Slack, Make blogs, Learn platform, GitHub)</li>\n\n\n\n<li>Setting up a personal WordPress site and publishing content</li>\n</ul>\n\n\n\n<p>Each student will choose a contribution area and design their own personal project within that area. Examples of possible projects include:</p>\n\n\n\n<ul class="wp-block-list">\n<li>Translating interfaces or documentation</li>\n\n\n\n<li>Creating multilingual subtitles for educational videos</li>\n\n\n\n<li>Contributing code or performing testing</li>\n\n\n\n<li>Supporting product development or design</li>\n\n\n\n<li>Writing or editing content</li>\n\n\n\n<li>Assisting with community event organization</li>\n\n\n\n<li>Developing training materials for Learn WordPress</li>\n\n\n\n<li>Creating open source tools</li>\n\n\n\n<li>And much more…<br></li>\n</ul>\n\n\n\n<p>Interns are guided by an experienced mentor specific to their chosen area and supported by a dedicated WordPress Foundation contact person throughout the program. All student contributions, whether code, translations, documentation, or educational materials, will be publicly visible and integrated into official WordPress projects and resources, directly benefiting the wider community.</p>\n\n\n\n<p><strong>Interested universities and educational institutions</strong> interested in participating can reach out by filling <a href="https://airtable.com/appIzQKfwTn5dyPVp/shrYvY0CDNIkILIre">the interest form</a>.</p>\n\n\n\n<p>We also invite companies in the WordPress ecosystem to support this initiative by sponsoring mentors who will guide and empower the next generation of contributors, or by providing tools and resources that help students succeed in their contribution journey.&nbsp;</p>\n\n\n\n<p><strong>If your company is interested in getting involved</strong>, please visit the <a href="https://make.wordpress.org/handbook/wordpress-credits-contribution-internship-program/get-involved-company-guide/">Company Guide</a> to learn more and <a href="https://airtable.com/appIzQKfwTn5dyPVp/shrKDkjeUdw8Fof34">fill out the form</a> to join the program.</p>\n\n\n\n<p><em>By welcoming students, mentors, sponsors, and volunteers into this initiative, we are building a stronger and more connected WordPress community. Each person who takes part, whether they guide a student, share their experiences, provide sponsorship, or simply help spread the word, helps ensure that open source remains vibrant and accessible for all. Together, we are not just supporting individual contributors; we are shaping the future of WordPress and open source itself.</em></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"18913";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:4:"href";s:32:"https://wordpress.org/news/feed/";s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:44:"http://purl.org/rss/1.0/modules/syndication/";a:2:{s:12:"updatePeriod";a:1:{i:0;a:5:{s:4:"data";s:9:"\n	hourly	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:15:"updateFrequency";a:1:{i:0;a:5:{s:4:"data";s:4:"\n	1	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:4:"site";a:1:{i:0;a:5:{s:4:"data";s:8:"14607090";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";O:48:"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary":1:{s:7:"\0*\0data";a:12:{s:6:"server";s:5:"nginx";s:4:"date";s:29:"Wed, 12 Nov 2025 06:44:58 GMT";s:12:"content-type";s:34:"application/rss+xml; charset=UTF-8";s:4:"vary";s:37:"Accept-Encoding, accept, content-type";s:25:"strict-transport-security";s:12:"max-age=3600";s:6:"x-olaf";s:3:"⛄";s:13:"last-modified";s:29:"Tue, 11 Nov 2025 15:40:08 GMT";s:4:"link";s:63:"<https://wordpress.org/news/wp-json/>; rel="https://api.w.org/"";s:15:"x-frame-options";s:10:"SAMEORIGIN";s:16:"content-encoding";s:2:"br";s:7:"alt-svc";s:19:"h3=":443"; ma=86400";s:4:"x-nc";s:9:"HIT ord 2";}}s:5:"build";i:1731693726;s:21:"cache_expiration_time";i:1762973098;s:23:"__cache_expiration_time";i:1762973098;}','off');
INSERT INTO `wp_options` VALUES (117419,'_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3','1762973098','off');
INSERT INTO `wp_options` VALUES (117420,'_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3','1762929898','off');
INSERT INTO `wp_options` VALUES (117421,'_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9','1762973099','off');
INSERT INTO `wp_options` VALUES (117422,'_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9','a:6:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n\n\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:112:"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:16:"WordPress Planet";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:28:"http://planet.wordpress.org/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:2:"en";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:47:"WordPress Planet - http://planet.wordpress.org/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"item";a:50:{i:0;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:53:"WordPress.org blog: WordPress 6.9 Release Candidate 1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19317";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:69:"https://wordpress.org/news/2025/11/wordpress-6-9-release-candidate-1/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:9329:"<p>The first Release Candidate (“RC1”) for WordPress 6.9 is ready for download and testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is still under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended to evaluate RC1 on a test server and site.</p>\n\n\n\n<p>WordPress 6.9 RC1 can be tested using any of the following methods:</p>\n\n\n\n<figure class="wp-block-table"><table class="has-fixed-layout"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the <a href="https://wordpress.org/plugins/wordpress-beta-tester/">WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream.)</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href="https://wordpress.org/wordpress-6.9-RC1.zip">RC1 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use this <a href="https://make.wordpress.org/cli/">WP-CLI</a> command: <br /><code>wp core update --version=6.9-RC1</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href="https://playground.wordpress.net/?php=8.3&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn">6.9 RC1 WordPress Playground instance</a> to test the software directly in your browser. No setup is required &#8211; just click and go! </td></tr></tbody></table></figure>\n\n\n\n<p>The scheduled final release date for WordPress 6.9 is <strong>December 2, 2025</strong>. The full <a href="https://make.wordpress.org/core/6-9/">release schedule can be found here</a>. Your help testing Beta and RC versions is vital to making this release as stable and powerful as possible.</p>\n\n\n\n<p>Please continue checking the <a href="https://make.wordpress.org/core/">Make WordPress Core blog</a> for <a href="https://make.wordpress.org/core/tag/6-9/">6.9-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<h2 class="wp-block-heading">What’s in WordPress 6.9 RC1?</h2>\n\n\n\n<p>Check out the <a href="https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/">Beta 1 announcement</a> for details on WordPress 6.9.</p>\n\n\n\n<p>You can browse the technical details for all issues addressed since Beta 4 using these links:</p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-11-07&amp;until=2025-11-11">Gutenberg commits for 6.9</a> since November 7, 2025</li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/log/?revs=61183-61203">Core commits for 6.9</a> since November 7, 2025</li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/query?status=closed&amp;changetime=11%2F07%2F2025..11%2F11%2F2025&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=changetime&amp;col=type&amp;order=id">Closed Trac tickets</a> since November 7, 2025</li>\n</ul>\n\n\n\n<p>Want to know more about this release? Here are some highlights:</p>\n\n\n\n<ul class="wp-block-list">\n<li>Site Editor improvements and Refined content creation\n<ul class="wp-block-list">\n<li>Ability to hide blocks</li>\n\n\n\n<li>New blocks </li>\n\n\n\n<li>Notes on blocks</li>\n\n\n\n<li>Universal command palette in wp-admin</li>\n</ul>\n</li>\n\n\n\n<li>Developer updates\n<ul class="wp-block-list">\n<li>Updates to dataviews and dataforms components</li>\n\n\n\n<li>New abilities API</li>\n\n\n\n<li>Updates to interactivity API </li>\n\n\n\n<li>Updates to block binding API</li>\n</ul>\n</li>\n\n\n\n<li>Performance Improvements\n<ul class="wp-block-list">\n<li>Improved script and style handling</li>\n\n\n\n<li>Optimized queries and caching</li>\n\n\n\n<li>Added ability to handle “fetchpriority” in ES Modules and Import Maps</li>\n\n\n\n<li>Standardizing output buffering</li>\n</ul>\n</li>\n</ul>\n\n\n\n<p>The final release is on track for December 2nd. As always, a successful release depends on your confirmation during testing. So please download and test!</p>\n\n\n\n<h2 class="wp-block-heading">How you can contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community of people collaborating on and contributing to its development. The resources below outline various ways you can help the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h3 class="wp-block-heading">Get involved in testing</h3>\n\n\n\n<p>Testing for issues is crucial to the development of any software. It’s also a meaningful way for anyone to contribute. </p>\n\n\n\n<p>Your help testing the WordPress 6.9 RC1 version is key to ensuring that the final release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important. This <a href="https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/">detailed guide</a> will walk you through testing features in WordPress 6.9.</p>\n\n\n\n<h4 class="wp-block-heading">Calls for testing</h4>\n\n\n\n<p>Thank you to everyone who helps test the following enhancements and bug fixes:</p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://make.wordpress.org/test/2025/10/06/call-for-testing-accordion-block/">Accordion Block</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/test/2025/10/04/call-for-testing-ability-to-hide-blocks/">Ability to Hide Blocks</a></li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/ticket/64099">Classic themes loading block styles on demand</a></li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/ticket/64204">Modified notes notifications</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/10/abilities-api-in-wordpress-6-9/">Abilities API</a></li>\n</ul>\n\n\n\n<p>If you encounter an issue, please report it to the <a href="https://wordpress.org/support/forum/alphabeta/">Alpha/Beta area</a> of the support forums, or directly to <a href="https://core.trac.wordpress.org/newticket">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href="https://core.trac.wordpress.org/tickets/major">known bugs</a>.</p>\n\n\n\n<p>Thank you to everyone who helps with testing!</p>\n\n\n\n<h3 class="wp-block-heading">Update your theme or plugin</h3>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.9 beta releases. With RC1, you’ll want to conclude your testing and update the <em>“Tested up to”</em> version in your <a href="https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/">plugin’s readme file</a> to 6.9. </p>\n\n\n\n<p>If you find compatibility issues, please post detailed information to the <a href="https://wordpress.org/support/forum/alphabeta/">support forum</a>.</p>\n\n\n\n<h3 class="wp-block-heading">Test on your hosting platforms</h3>\n\n\n\n<p>Web hosts provide vital infrastructure for supporting WordPress and its users. Testing on hosting systems helps inform the development process while ensuring that WordPress and hosting platforms are fully compatible, free of errors, optimized for the best possible user experience, and that updates roll out to customer sites without issue.</p>\n\n\n\n<p>Want to test WordPress on your hosting system? <a href="https://make.wordpress.org/hosting/test-results-getting-started/">Get started with configuring distributed hosting tests here</a>. Thank you to all <a href="https://make.wordpress.org/hosting/test-results/">web hosts who help test WordPress</a>!</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href="https://make.wordpress.org/test/">testing initiatives in Make Core</a> and join the <a href="https://wordpress.slack.com/messages/core-test/">#core-test channel</a> on <a href="https://wordpress.slack.com/">Making WordPress Slack</a>.</p>\n\n\n\n<h2 class="wp-block-heading">An RC1 haiku</h2>\n\n\n\n<p><em>As the sun rises</em>,</p>\n\n\n\n<p><em>RC1 breaks its cocoon</em></p>\n\n\n\n<p><em>and emerges strong</em>.</p>\n\n\n\n<p class="has-text-align-right"><em>Props to </em><a class="mention" href="https://profiles.wordpress.org/akshayar/"><span class="mentions-prefix">@</span>akshayar</a><em>, </em><a class="mention" href="https://profiles.wordpress.org/davidbaumwald/"><span class="mentions-prefix">@</span>davidbaumwald</a>, <a class="mention" href="https://profiles.wordpress.org/jeffpaul/"><span class="mentions-prefix">@</span>jeffpaul</a>, <a class="mention" href="https://profiles.wordpress.org/desrosj/"><span class="mentions-prefix">@</span>desrosj</a>, <a class="mention" href="https://profiles.wordpress.org/westonruter/"><span class="mentions-prefix">@</span>westonruter</a>, <a class="mention" href="https://profiles.wordpress.org/ellatrix/"><span class="mentions-prefix">@</span>ellatrix</a>, <a class="mention" href="https://profiles.wordpress.org/priethor/"><span class="mentions-prefix">@</span>priethor</a>, <a class="mention" href="https://profiles.wordpress.org/krupajnanda/"><span class="mentions-prefix">@</span>krupajnanda</a> <em>and</em> <a class="mention" href="https://profiles.wordpress.org/cbravobernal/"><span class="mentions-prefix">@</span>cbravobernal</a> <em>for proofreading and review.</em></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 11 Nov 2025 15:34:48 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"Amy Kamala";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:68:"Open Channels FM: Insights Into Successfully Rebranding Your Podcast";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"https://openchannels.fm/?p=111842";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:75:"https://openchannels.fm/insights-into-successfully-rebranding-your-podcast/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:346:"Rebranding a podcast involves much more than updating a logo or picking a new name. It is a transformative process that requires thoughtful planning, flexibility, and perseverance. One of the most revealing parts of the journey is the way it encourages you to reevaluate how each piece fits together, from your website structure to your [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 11 Nov 2025 11:43:05 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"BobWP";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:20:"Matt: Bending Spoons";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150536";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:37:"https://ma.tt/2025/11/bending-spoons/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1275:"<p>The story of what <a href="https://bendingspoons.com/">Bending Spoons</a> has built is very impressive, and I&#8217;m a customer of theirs through <a href="https://evernote.com/">Evernote</a>, WordPress uses <a href="https://www.meetup.com/">Meetup</a> a ton. I think Automattic&#8217;s <a href="https://automattic.space/">Noho office</a> used to belong to Meetup. They&#8217;ve built an incredible engineering and product culture that can terraform technology stacks into something much more efficient. I think their acquisitions of <a href="https://techcrunch.com/2025/09/10/vimeo-to-be-acquired-by-bending-spoons-in-1-38b-all-cash-deal/">Vimeo</a> and <a href="https://techcrunch.com/2025/10/29/bending-spoons-to-acquire-aol/">AOL</a> are brilliant. This interview with Luca Ferrari on Invest Like The Best goes into their story and unique culture. I also always love a good <a href="https://en.wikipedia.org/wiki/The_Matrix">Matrix</a> reference. <img alt="🙂" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/1f642.png" style="height: 1em;" /></p>\n\n\n\n<figure class="wp-block-embed alignwide is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n\n</div></figure>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 11 Nov 2025 01:34:00 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:114:"WordCamp Central: WordPress Udupi Community Empowers 300+ Students Across Coastal Karnataka Through Campus Connect";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:40:"https://central.wordcamp.org/?p=12520949";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:138:"https://central.wordcamp.org/news/2025/11/wordpress-udupi-community-empowers-300-students-across-coastal-karnataka-through-campus-connect/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:19930:"<p>As the lead organiser representing the <strong>WordPress Udupi Community</strong>, I had the incredible opportunity to bring <em>WordPress Campus Connect</em> to college campuses across <strong>Coastal Karnataka</strong>.<br />What began as a small idea soon became a mission &#8211; to introduce WordPress, open source, and digital opportunities to the next generation of creators.</p>\n\n\n\n<p>Across all our sessions, we interacted with <strong>over 300+ students</strong> from four institutions:</p>\n\n\n\n<ul class="wp-block-list">\n<li><strong><a href="https://events.wordpress.org/campusconnect/2025/udupi/partner-colleges/shree-guru-sudhindra-college-bhatkal/" rel="noreferrer noopener" target="_blank">S.G.S. College, Bhatkal</a></strong> – 50 students</li>\n\n\n\n<li><strong><a href="https://events.wordpress.org/campusconnect/2025/udupi/partner-colleges/bhandarkars-arts-and-science-college-kundapura/" rel="noreferrer noopener" target="_blank">Bhandarkar’s College, Kundapura</a></strong> – 120 students</li>\n\n\n\n<li><strong><a href="https://events.wordpress.org/campusconnect/2025/udupi/partner-colleges/dr-b-b-hegde-first-grade-college-kundapura/" rel="noreferrer noopener" target="_blank">Dr. B. B. Hegde College, Kundapura</a></strong> – 65 students</li>\n\n\n\n<li><strong><a href="https://events.wordpress.org/campusconnect/2025/udupi/imj-institute-of-science-commerce-moodlakatte/" rel="noreferrer noopener" target="_blank">IMJ Institute of Science &amp; Commerce, Moodlakatte</a></strong> – 70 students</li>\n</ul>\n\n\n\n<figure class="wp-block-image size-large"><img alt="" src="https://events.wordpress.org/campusconnect/2025/udupi/files/2025/10/wordpress-campus-connect-udupi-sgs-college-bhatkal-scaled.jpg" /></figure>\n\n\n\n<figure class="wp-block-image size-large"><img alt="" src="https://events.wordpress.org/campusconnect/2025/udupi/files/2025/10/wordpress-campus-connect-udupi-bhandarkars-college-kundapura-min-edited-scaled.jpg" /></figure>\n\n\n\n<figure class="wp-block-image size-large"><img alt="" src="https://events.wordpress.org/campusconnect/2025/udupi/files/2025/10/wordpress-campus-connect-IMJ-Institute-of-Science-1.jpeg" /></figure>\n\n\n\n<p>Each campus had its own energy and challenges. Most students were in their final year, just months away from entering the professional world, yet many still lacked basic digital readiness. Some didn’t have LinkedIn profiles but had multiple Instagram accounts. Others were hesitant to speak on the mic, and a few genuinely didn’t know what to enter in the <em>PIN code</em> field while creating a WordPress.com account. Out of 300+ students, more than 250 had forgotten their Gmail passwords, so each session began with a mini Gmail recovery workshop before we even reached WordPress!</p>\n\n\n\n<p>At first, it was challenging. But soon our team switched gears, we weren’t just there as WordPress community members; we became mentors. We realised this wasn’t only about teaching WordPress; it was about building <strong>digital literacy</strong>. If not us, then who would help them take their first confident step into the web world?</p>\n\n\n\n<div class="wp-block-columns is-layout-flex wp-container-core-columns-is-layout-9d6595d7 wp-block-columns-is-layout-flex">\n<div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow">\n<figure class="wp-block-image size-large"><img alt="" src="https://events.wordpress.org/campusconnect/2025/udupi/files/2025/09/wordpress-campus-connect-udupi-4-scaled.jpg" /></figure>\n</div>\n\n\n\n<div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow">\n<figure class="wp-block-image size-large"><img alt="" src="https://events.wordpress.org/campusconnect/2025/udupi/files/2025/09/wordpress-campus-connect-udupi-1-1.jpg" /></figure>\n</div>\n</div>\n\n\n\n<div class="wp-block-columns is-layout-flex wp-container-core-columns-is-layout-9d6595d7 wp-block-columns-is-layout-flex">\n<div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow">\n<figure class="wp-block-image size-large"><img alt="" src="https://events.wordpress.org/campusconnect/2025/udupi/files/2025/09/wordpress-campus-connect-udupi-team-members-scaled.jpg" /></figure>\n</div>\n\n\n\n<div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow">\n<figure class="wp-block-image size-large"><img alt="" src="https://events.wordpress.org/campusconnect/2025/udupi/files/2025/10/wordpress-campus-connect-udupi-bb-hegde-college-kundapura-4.jpeg" /></figure>\n</div>\n</div>\n\n\n\n<p>By the end, we witnessed real transformation, shy students asking questions, first-time creators proudly launching their sites, and a spark of curiosity lighting up across classrooms.</p>\n\n\n\n<p>We’re grateful to all the colleges, their management, and faculty for the warm welcome, and to every student who showed curiosity and enthusiasm once they got started.</p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity" />\n\n\n\n<h3 class="wp-block-heading"><strong>Organising Team</strong></h3>\n\n\n\n<p><strong>Organisers:</strong> <a href="https://profiles.wordpress.org/arbishashishetty" rel="noreferrer noopener" target="_blank">Shashikanth Shetty</a>, <a href="https://profiles.wordpress.org/kkeerthiprabhu/" rel="noreferrer noopener" target="_blank">Keerthi Prabhu</a> &amp; <a href="https://profiles.wordpress.org/vgnavada" rel="noreferrer noopener" target="_blank">V Gautham Navada</a><br /><strong>Facilitators:</strong> <a href="https://profiles.wordpress.org/omkarudupa" rel="noreferrer noopener" target="_blank">Omkar Udupa</a>, <a href="https://profiles.wordpress.org/manjunathmm" rel="noreferrer noopener" target="_blank">Manjunath M M</a>, <a href="https://profiles.wordpress.org/chandanagm/" rel="noreferrer noopener" target="_blank">Chandana G M</a><br /><strong>Social Media Designs &amp; Reels:</strong> <a href="https://profiles.wordpress.org/ranjithacgowda/" rel="noreferrer noopener" target="_blank">Ranjitha GC</a></p>\n\n\n\n<figure class="wp-block-image size-large"><img alt="" src="https://events.wordpress.org/campusconnect/2025/udupi/files/2025/10/wordpress-campus-connect-wordpress-udupi-community-team-members-scaled.jpg" /><figcaption class="wp-element-caption">The WP UDUPI TEAM &#8211; From left to right &#8211; Omkar, Shashikanth, Manjunath, Gautham, Keerthi, and Chandana.</figcaption></figure>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity" />\n\n\n\n<h3 class="wp-block-heading"><strong>Sponsors</strong></h3>\n\n\n\n<p><strong>Global Sponsors:</strong> <a href="https://automattic.com" rel="noreferrer noopener" target="_blank">Automattic</a>, <a href="https://bluehost.com" rel="noreferrer noopener" target="_blank">Bluehost</a>, <a href="https://hosting.com" rel="noreferrer noopener" target="_blank">Hosting.com</a>, <a href="https://kinsta.com/" rel="noreferrer noopener" target="_blank">Kinsta</a>, <a href="https://WooCommerce.com/" rel="noreferrer noopener" target="_blank">WooCommerce</a><br /><strong>Local Sponsors:</strong> <a href="https://sabweb.in/" rel="noreferrer noopener" target="_blank">SabWeb</a>, <a href="https://forthfocus.com/" rel="noreferrer noopener" target="_blank">ForthFocus</a>, <a href="https://yukthadigital.com/" rel="noreferrer noopener" target="_blank">Yuktha Digital</a>, <a href="https://kotisoftsolutions.com" rel="noreferrer noopener" target="_blank">Koti Soft Solutions</a></p>\n\n\n\n<p>A heartfelt thanks to <a href="https://wordpress.com/" rel="noreferrer noopener" target="_blank">WordPress.com</a> for sponsoring free one-year website plans for students from our last two campuses, an initiative that has already helped many of them start blogging and showcasing their work online.</p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity" />\n\n\n\n<h3 class="wp-block-heading"><strong>Student Testimonials</strong></h3>\n\n\n\n<div class="wp-block-columns is-layout-flex wp-container-core-columns-is-layout-9d6595d7 wp-block-columns-is-layout-flex">\n<div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow">\n<figure class="wp-block-embed is-type-rich is-provider-instagram wp-block-embed-instagram"><div class="wp-block-embed__wrapper">\n<blockquote class="instagram-media"><div style="padding: 16px;"> <a href="https://www.instagram.com/reel/DPoBui1k4ba/?utm_source=ig_embed&amp;utm_campaign=loading" style="line-height: 0; padding: 0 0; text-align: center; text-decoration: none; width: 100%;" target="_blank"> <div style="display: flex;"> <div style="background-color: #F4F4F4; border-radius: 50%; height: 40px; margin-right: 14px; width: 40px;"></div> <div style="display: flex;"> <div style="background-color: #F4F4F4; border-radius: 4px; height: 14px; margin-bottom: 6px; width: 100px;"></div> <div style="background-color: #F4F4F4; border-radius: 4px; height: 14px; width: 60px;"></div></div></div><div style="padding: 19% 0;"></div> <div style="display: block; height: 50px; margin: 0 auto 12px; width: 50px;"></div><div style="padding-top: 8px;"> <div style="color: #3897f0; font-family: Arial,sans-serif; font-size: 14px; font-style: normal; font-weight: 550; line-height: 18px;">View this post on Instagram</div></div><div style="padding: 12.5% 0;"></div> <div style="display: flex; margin-bottom: 14px;"><div> <div></div> <div></div> <div></div></div><div style="margin-left: 8px;"> <div style="background-color: #F4F4F4; border-radius: 50%; height: 20px; width: 20px;"></div> <div></div></div><div style="margin-left: auto;"> <div></div> <div></div> <div></div></div></div> <div style="display: flex; margin-bottom: 24px;"> <div style="background-color: #F4F4F4; border-radius: 4px; height: 14px; margin-bottom: 6px; width: 224px;"></div> <div style="background-color: #F4F4F4; border-radius: 4px; height: 14px; width: 144px;"></div></div></a></div></blockquote>\n</div></figure>\n</div>\n\n\n\n<div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow">\n<figure class="wp-block-embed is-type-rich is-provider-instagram wp-block-embed-instagram"><div class="wp-block-embed__wrapper">\n<blockquote class="instagram-media"><div style="padding: 16px;"> <a href="https://www.instagram.com/reel/DPDnPevk_Ib/?utm_source=ig_embed&amp;utm_campaign=loading" style="line-height: 0; padding: 0 0; text-align: center; text-decoration: none; width: 100%;" target="_blank"> <div style="display: flex;"> <div style="background-color: #F4F4F4; border-radius: 50%; height: 40px; margin-right: 14px; width: 40px;"></div> <div style="display: flex;"> <div style="background-color: #F4F4F4; border-radius: 4px; height: 14px; margin-bottom: 6px; width: 100px;"></div> <div style="background-color: #F4F4F4; border-radius: 4px; height: 14px; width: 60px;"></div></div></div><div style="padding: 19% 0;"></div> <div style="display: block; height: 50px; margin: 0 auto 12px; width: 50px;"></div><div style="padding-top: 8px;"> <div style="color: #3897f0; font-family: Arial,sans-serif; font-size: 14px; font-style: normal; font-weight: 550; line-height: 18px;">View this post on Instagram</div></div><div style="padding: 12.5% 0;"></div> <div style="display: flex; margin-bottom: 14px;"><div> <div></div> <div></div> <div></div></div><div style="margin-left: 8px;"> <div style="background-color: #F4F4F4; border-radius: 50%; height: 20px; width: 20px;"></div> <div></div></div><div style="margin-left: auto;"> <div></div> <div></div> <div></div></div></div> <div style="display: flex; margin-bottom: 24px;"> <div style="background-color: #F4F4F4; border-radius: 4px; height: 14px; margin-bottom: 6px; width: 224px;"></div> <div style="background-color: #F4F4F4; border-radius: 4px; height: 14px; width: 144px;"></div></div></a></div></blockquote>\n</div></figure>\n</div>\n</div>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity" />\n\n\n\n<h3 class="wp-block-heading"><strong>College Testimonial</strong></h3>\n\n\n\n<figure class="wp-block-embed is-type-rich is-provider-instagram wp-block-embed-instagram"><div class="wp-block-embed__wrapper">\n<blockquote class="instagram-media"><div style="padding: 16px;"> <a href="https://www.instagram.com/reel/DO8p57yk4cm/?utm_source=ig_embed&amp;utm_campaign=loading" style="line-height: 0; padding: 0 0; text-align: center; text-decoration: none; width: 100%;" target="_blank"> <div style="display: flex;"> <div style="background-color: #F4F4F4; border-radius: 50%; height: 40px; margin-right: 14px; width: 40px;"></div> <div style="display: flex;"> <div style="background-color: #F4F4F4; border-radius: 4px; height: 14px; margin-bottom: 6px; width: 100px;"></div> <div style="background-color: #F4F4F4; border-radius: 4px; height: 14px; width: 60px;"></div></div></div><div style="padding: 19% 0;"></div> <div style="display: block; height: 50px; margin: 0 auto 12px; width: 50px;"></div><div style="padding-top: 8px;"> <div style="color: #3897f0; font-family: Arial,sans-serif; font-size: 14px; font-style: normal; font-weight: 550; line-height: 18px;">View this post on Instagram</div></div><div style="padding: 12.5% 0;"></div> <div style="display: flex; margin-bottom: 14px;"><div> <div></div> <div></div> <div></div></div><div style="margin-left: 8px;"> <div style="background-color: #F4F4F4; border-radius: 50%; height: 20px; width: 20px;"></div> <div></div></div><div style="margin-left: auto;"> <div></div> <div></div> <div></div></div></div> <div style="display: flex; margin-bottom: 24px;"> <div style="background-color: #F4F4F4; border-radius: 4px; height: 14px; margin-bottom: 6px; width: 224px;"></div> <div style="background-color: #F4F4F4; border-radius: 4px; height: 14px; width: 144px;"></div></div></a></div></blockquote>\n</div></figure>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity" />\n\n\n\n<h3 class="wp-block-heading"><strong>Media Coverage </strong></h3>\n\n\n\n<p>We were also featured in several local and regional media outlets that recognized the impact of the initiative. You can read the articles and see coverage highlights below:<br /></p>\n\n\n\n<ul class="wp-block-list">\n<li><strong>UdupiTimes:</strong> <a href="https://udupitimes.com/udupi-times-21221/" rel="noreferrer noopener" target="_blank">ವರ್ಡ್‌ಪ್ರೆಸ್ ಕ್ಯಾಂಪಸ್ ಕನೆಕ್ಟ್ ಉಡುಪಿ: ವಿದ್ಯಾರ್ಥಿಗಳಿಗೆ ಡಿಜಿಟಲ್ ಪ್ರೇರಣೆ</a></li>\n\n\n\n<li><strong>Kundapraa.com:</strong> <em><a href="https://kundapraa.com/?p=91248" rel="noreferrer noopener" target="_blank">ಕುಂದಾಪುರ: ವರ್ಡ್‌ಪ್ರೆಸ್ ಕ್ಯಾಂಪಸ್ ಕನೆಕ್ಟ್: 120 ವಿದ್ಯಾರ್ಥಿಗಳಿಗೆ ಪ್ರಾಯೋಗಿಕ ತರಬೇತಿ</a></em></li>\n\n\n\n<li><strong>NewsNext</strong>: <em><strong><a href="https://newsnext.live/technology/wordpress-campus-connect-udupi-empowers-65-students-at-dr-b-b-hegde-college-kundapura/" rel="noreferrer noopener" target="_blank">WordPress Campus Connect Udupi Empowers 65 Students at Dr. B.B. Hegde College, Kundapura</a></strong></em></li>\n\n\n\n<li><strong>Tulunada Dhwani: </strong><em><a href="https://tulunadadhwani.com/news/wordpress-4/" rel="noreferrer noopener" target="_blank">ಮೂಡ್ಲಕಟ್ಟೆದ ಐಎಂಜೆ ಕಾಲೇಜಿಡ್ ವರ್ಡ್ ಪ್ರೆಸ್ ಕ್ಯಾಂಪ್..</a></em></li>\n</ul>\n\n\n\n<div class="wp-block-columns is-layout-flex wp-container-core-columns-is-layout-9d6595d7 wp-block-columns-is-layout-flex">\n<div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow">\n<figure class="wp-block-embed is-type-rich is-provider-instagram wp-block-embed-instagram"><div class="wp-block-embed__wrapper">\n<blockquote class="instagram-media"><div style="padding: 16px;"> <a href="https://www.instagram.com/p/DPie-qQkwBF/?utm_source=ig_embed&amp;utm_campaign=loading" style="line-height: 0; padding: 0 0; text-align: center; text-decoration: none; width: 100%;" target="_blank"> <div style="display: flex;"> <div style="background-color: #F4F4F4; border-radius: 50%; height: 40px; margin-right: 14px; width: 40px;"></div> <div style="display: flex;"> <div style="background-color: #F4F4F4; border-radius: 4px; height: 14px; margin-bottom: 6px; width: 100px;"></div> <div style="background-color: #F4F4F4; border-radius: 4px; height: 14px; width: 60px;"></div></div></div><div style="padding: 19% 0;"></div> <div style="display: block; height: 50px; margin: 0 auto 12px; width: 50px;"></div><div style="padding-top: 8px;"> <div style="color: #3897f0; font-family: Arial,sans-serif; font-size: 14px; font-style: normal; font-weight: 550; line-height: 18px;">View this post on Instagram</div></div><div style="padding: 12.5% 0;"></div> <div style="display: flex; margin-bottom: 14px;"><div> <div></div> <div></div> <div></div></div><div style="margin-left: 8px;"> <div style="background-color: #F4F4F4; border-radius: 50%; height: 20px; width: 20px;"></div> <div></div></div><div style="margin-left: auto;"> <div></div> <div></div> <div></div></div></div> <div style="display: flex; margin-bottom: 24px;"> <div style="background-color: #F4F4F4; border-radius: 4px; height: 14px; margin-bottom: 6px; width: 224px;"></div> <div style="background-color: #F4F4F4; border-radius: 4px; height: 14px; width: 144px;"></div></div></a></div></blockquote>\n</div></figure>\n</div>\n\n\n\n<div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow">\n<figure class="wp-block-embed is-type-rich is-provider-instagram wp-block-embed-instagram"><div class="wp-block-embed__wrapper">\n<blockquote class="instagram-media"><div style="padding: 16px;"> <a href="https://www.instagram.com/p/DQbnp7mk8Mt/?utm_source=ig_embed&amp;utm_campaign=loading" style="line-height: 0; padding: 0 0; text-align: center; text-decoration: none; width: 100%;" target="_blank"> <div style="display: flex;"> <div style="background-color: #F4F4F4; border-radius: 50%; height: 40px; margin-right: 14px; width: 40px;"></div> <div style="display: flex;"> <div style="background-color: #F4F4F4; border-radius: 4px; height: 14px; margin-bottom: 6px; width: 100px;"></div> <div style="background-color: #F4F4F4; border-radius: 4px; height: 14px; width: 60px;"></div></div></div><div style="padding: 19% 0;"></div> <div style="display: block; height: 50px; margin: 0 auto 12px; width: 50px;"></div><div style="padding-top: 8px;"> <div style="color: #3897f0; font-family: Arial,sans-serif; font-size: 14px; font-style: normal; font-weight: 550; line-height: 18px;">View this post on Instagram</div></div><div style="padding: 12.5% 0;"></div> <div style="display: flex; margin-bottom: 14px;"><div> <div></div> <div></div> <div></div></div><div style="margin-left: 8px;"> <div style="background-color: #F4F4F4; border-radius: 50%; height: 20px; width: 20px;"></div> <div></div></div><div style="margin-left: auto;"> <div></div> <div></div> <div></div></div></div> <div style="display: flex; margin-bottom: 24px;"> <div style="background-color: #F4F4F4; border-radius: 4px; height: 14px; margin-bottom: 6px; width: 224px;"></div> <div style="background-color: #F4F4F4; border-radius: 4px; height: 14px; width: 144px;"></div></div></a></div></blockquote>\n</div></figure>\n</div>\n</div>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity" />\n\n\n\n<p>For the <strong>WordPress Udupi Community</strong>, this journey was much more than a series of campus sessions. It was a reminder that true change starts with awareness and sometimes, the first step toward digital empowerment is simply helping someone log in.</p>\n\n\n\n<blockquote class="wp-block-quote is-layout-flow wp-block-quote-is-layout-flow">\n<p><strong>To any student or job seeker reading this:</strong><br />Don’t wait for the syllabus to teach you what the world already expects you to know. Curiosity is your real qualification!</p>\n</blockquote>\n\n\n\n<p><em>WordPress Campus Connect Udupi 2025 </em>turned out to be more than an event, it became a movement, proving that communities like ours can make a real-world impact, one campus at a time.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 10 Nov 2025 13:19:09 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:8:"vgnavada";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:16:"Matt: Meshtastic";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150524";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:33:"https://ma.tt/2025/11/meshtastic/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:942:"<p>I&#8217;ve been following this cool open source project called <a href="https://meshtastic.org/">Meshtastic</a>, which is &#8220;An open source, off-grid, decentralized, mesh network built to run on affordable, low-power devices.&#8221; I finally got some time to set it up tonight. It was super easy; <a href="https://flasher.meshtastic.org/">you just flash the Meshtastic firmware in your browser</a> to any of the compatible devices. I got a Heltec v3 device for $35 bucks on Amazon. (I&#8217;d link but it&#8217;s out of stock, and I think there&#8217;s a newer version.) Apparently, there are enough people running nodes that you can bounce a message from Portland to San Francisco! I love the idea of parallel to the internet networks, and I&#8217;ve been meaning to <a href="https://www.fcc.gov/wireless/bureau-divisions/mobility-division/amateur-radio-service">get a HAM license</a>, but in the meantime, this looks pretty fun.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 10 Nov 2025 01:37:44 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:78:"Gutenberg Times: Gutenberg Changelog #124 – Gutenberg 22.0 and WordPress 6.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:53:"https://gutenbergtimes.com/?post_type=podcast&p=42753";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:86:"https://gutenbergtimes.com/podcast/gutenberg-changelog-124-gutenberg-22-wordpress-6-9/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:52553:"<p>In episode 124 of the Gutenberg Changelog podcast, Birgit Pauli-Haack and guest Ellen Bauer discuss the latest WordPress and Gutenberg updates, including the upcoming WordPress 6.9 release and Gutenberg 22.0. Highlights include insights on AI-powered site building, the importance of collaboration tools like block comments, new blocks such as accordion and stretchy text, and the enhanced plugin security review. </p>\n\n\n\n<p>Ellen Bauer shares her experiences from WordCamp Kansai and speaks on the impact of AI in making WordPress site building more accessible. They also touch on improvements for theme authors, plugin developers, and the upcoming WordCamp Asia. The episode wraps up with community announcements and a look ahead to features planned for WordPress 7.0.</p>\n\n\n\n<p></p>\n\n\n\n<p><a href="https://gutenbergtimes.com/podcast/gutenberg-changelog-124-gutenberg-22-wordpress-6-9/#shownotes">Show Notes</a> / <a href="https://gutenbergtimes.com/podcast/gutenberg-changelog-124-gutenberg-22-wordpress-6-9//#transcript">Transcript</a></p>\n\n\n\n<ul class="wp-block-list">\n<li>Editor: <a href="https://www.linkedin.com/in/sandy-reed/">Sandy Reed</a></li>\n\n\n\n<li>Logo: <a href="https://markuraine.com/">Mark Uraine</a></li>\n\n\n\n<li>Production: <a href="https://icodeforapurpose.com">Birgit Pauli-Haack</a></li>\n</ul>\n\n\n\n<p class="has-larger-font-size" id="shownotes"><strong>Show Notes</strong></p>\n\n\n\n<h2 class="wp-block-heading">Special Guest: Ellen Bauer</h2>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://x.com/ellenbauer">On X (former Twitter) @ellenbauer</a></li>\n\n\n\n<li><a href="https://bsky.app/profile/ellenbauer.bsky.social">Bluesky</a></li>\n\n\n\n<li><a href="https://www.elmastudio.de/en/">ElmaStudio</a></li>\n\n\n\n<li>Previews appearances on the show\n<ul class="wp-block-list">\n<li><a href="https://gutenbergtimes.com/podcast/gutenberg-changelog-117-woocommerce-starter-theme-and-blocks/">Gutenberg Changelog 117 – WooCommerce Starter Theme and Blocks, WordCamp Europe, and Gutenberg 20.7 and 20.8</a></li>\n\n\n\n<li><a href="https://gutenbergtimes.com/podcast/gutenberg-changelog-105-gutenberg-18-9-block-themes-and-woocommerce/">Gutenberg Changelog #105 – Gutenberg 18.9, Block Themes and WooCommerce</a></li>\n\n\n\n<li><a href="https://gutenbergtimes.com/podcast/gutenberg-changelog-88-wordpress-6-4-and-gutenberg-16-5/">Gutenberg Changelog #88 – WordPress 6.4 and Gutenberg 16.4 and 16.5.</a></li>\n</ul>\n</li>\n\n\n\n<li>Talk at WordCamp Kansai: <a href="https://kansai.wordcamp.org/2025/session/building-a-woocommerce-store-using-block-themes-and-ai-site-building/">Building a WooCommerce Store Using Block Themes and AI Site Building</a></li>\n</ul>\n\n\n\n<h2 class="wp-block-heading">Announcements &amp; Community</h2>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://make.wordpress.org/core/2025/11/06/update-on-phase-3-2025/">Update on Phase 3: Collaboration efforts (Nov 2025)</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/plugins/2025/10/29/plugin-check-plugin-now-creates-automatic-security-reports-update/">The Plugin Check Plugin now creates automatic security reports after each plugin update</a>. </li>\n\n\n\n<li><a href="https://wordpress.org/plugins/internet-archive-wayback-machine-link-fixer/">Internet Archive Wayback Machine Link Fixer</a> </li>\n\n\n\n<li><a href="https://ma.tt/2025/10/wayback/">Wayback Machine Joint</a></li>\n\n\n\n<li><a href="https://wordpress.com/blog/2025/10/08/introducing-blueprints-in-wordpress-studio-1-6-0/">Introducing Blueprints in WordPress Studio 1.6.0</a></li>\n\n\n\n<li>Talks about Playground Blueprings by Birgit Pauli-Haack\n<ul class="wp-block-list">\n<li><a href="https://wordpress.tv/2025/09/30/streamlined-block-theme-development-using-wordpress-playground-and-github-for-no-code-version-contr/">Streamlined Block Theme Development: Using WordPress Playground and GitHub for No-Code Version Control of Site Editor Changes</a></li>\n\n\n\n<li><a href="https://wordpress.tv/2025/06/07/from-zero-to-demo-mastering-wordpress-playground-blueprints/">From Zero to Demo: Mastering WordPress Playground Blueprints</a></li>\n\n\n\n<li><a href="https://wordpress.tv/2025/04/30/create-a-demo-with-playground/">Create a demo with Playground</a><br /></li>\n</ul>\n</li>\n</ul>\n\n\n\n<h2 class="wp-block-heading">What&#8217;s Released</h2>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://make.wordpress.org/core/2025/11/07/wordpress-6-9-beta-4/">WordPress 6.9 Beta 4</a></li>\n\n\n\n<li>Tutorials on WordPress Developer Blog\n<ul class="wp-block-list">\n<li><a href="https://developer.wordpress.org/news/2025/11/how-wordpress-6-9-gives-forms-a-theme-json-makeover/">How WordPress 6.9 gives forms a theme.json makeover</a></li>\n\n\n\n<li><a href="https://developer.wordpress.org/news/2025/10/styling-accordions-in-wordpress-6-9/">Styling accordions in WordPress 6.9</a> </li>\n\n\n\n<li><a href="https://developer.wordpress.org/news/2025/09/border-radius-size-presets-in-wordpress-6-9/">Border radius size presets in WordPress 6.9</a></li>\n\n\n\n<li><a href="https://developer.wordpress.org/news/2025/08/registering-custom-social-icons-in-wordpress-6-9/">Registering custom social icons in WordPress 6.9</a></li>\n</ul>\n</li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/05/whats-new-in-gutenberg-22-0-05-november/">What’s new in Gutenberg 22.0? (5 November)</a></li>\n</ul>\n\n\n\n<h2 class="wp-block-heading">What&#8217;s in the works or discussed?</h2>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://github.com/WordPress/gutenberg/issues/72032">WordPress Scripts: A vision for a v2 version</a></li>\n\n\n\n<li>Developer Hours: <a href="https://www.meetup.com/learn-wordpress-online-workshops/events/311854653/"><strong>WordPress 6.9: developer updates</strong></a></li>\n</ul>\n\n\n\n<p class="has-large-font-size">Stay in Touch</p>\n\n\n\n<div class="wp-block-group"><div class="wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow">\n<ul class="wp-block-list">\n<li>Did you like this episode? <a href="https://lovethepodcast.com/gutenbergchangelog"><strong>Please write us a review </strong></a></li>\n\n\n\n<li>Ping us on X (formerly known as Twitter) or send DMs with questions. <a href="https://twitter.com/gutenbergtimes">@gutenbergtimes </a>and <a href="https://twitter.com/bph">@bph</a>.</li>\n\n\n\n<li><em>If you have questions or suggestions, or news you want us to include, send them to <a href="mailto:changelog@gutenbergtimes.com">changelog@gutenbergtimes.com</a>. </em></li>\n\n\n\n<li><em>Please write us a review on iTunes! <a href="https://gutenbergtimes.com/itunes/">(Click here to learn how)</a></em></li>\n</ul>\n</div></div>\n\n\n\n<p class="has-large-font-size" id="transcript"><strong>Transcript</strong></p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Welcome to our 124th episode of the Gutenberg Changelog podcast. In today&#8217;s episode, we will talk about Gutenberg 22.0 and WordPress 6.9 and so much more. I&#8217;m your host, Birgit Pauli-Haack, curator at the Gutenberg Times and a full-time core contributor for the WordPress open source project sponsored by Automattic. </p>\n\n\n\n<p>Today on a Saturday morning, Ellen Bauer joins us from New Zealand. She works for Automattic as a product manager, works with themes, blocks and the AI site building tool. And as a former agency owner and professional theme builder and designer, she brings important perspectives to the software powering millions of merchants at WooCommerce of the World. She&#8217;s also a longtime friend and I&#8217;m delighted you join me again, Ellen, to the show. Welcome and how are you today?</p>\n\n\n\n<p><em>Ellen Bauer: </em>Thank you very much. That was a lovely introduction. I should copy that for my who I am. I actually like that. Thanks, Birgit. I&#8217;m very well. It&#8217;s very early in the morning for me, so please bear with me everyone. If I&#8217;m babbling a little bit. I yeah, I&#8217;m very well. I&#8217;m actually very recharged because I just returned from Botkin Kansai in Japan, and I added a little personal holiday on top of that with my family. So yeah, that was a lovely time away and it&#8217;s always good to connect to the community and attend WordCamps because yeah, you just feel recharged and inspired. So yeah, I&#8217;m feeling really excited and I&#8217;m happy to be on that podcast here again.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Always so glad you&#8217;re here. So don&#8217;t worry as long as you don&#8217;t snore. We are, we take anything that you want to say.</p>\n\n\n\n<p><em>Ellen Bauer: </em>Inspired my by my Japan travels. I&#8217;m having a green tea next to me so that should keep me running.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, and I have green tea too, but that&#8217;s now from a shop that I saw in Taipei two years ago at WordCamp Asia. So I&#8217;m really kind of every time I have a cup of tea, I&#8217;m thinking back on that. </p>\n\n\n\n<h3 class="wp-block-heading">WordCamp Kansai, WordCamp Asia</h3>\n\n\n\n<p>So you gave a talk at WordCamp Kansai about building a WooCommerce store using block themes and AI site building. So how did it go and what did you learn from putting it together actually.</p>\n\n\n\n<p><em>Ellen Bauer: </em>So I was again, it&#8217;s a very new topic for me, so I was like, oh, what did I do to myself presenting that. But it was very exciting and there were a few AI talks that were really, really cool at the WordCamp. So it&#8217;s a good idea to check out the YouTube stream from the WordCamp other videos there. It was really cool to talk about a topic that I&#8217;m very excited about and just kind of getting into more and more with my work at Automatic as well. So I learned a lot. I looked at a lot of competitors and what they&#8217;re doing and obviously AI inside. It&#8217;s pretty wild what is happening and fast paced. So I think it was good to also bring the topic to a WordCamp and I had really, really positive feedback. Everyone was excited. The room was packed which I didn&#8217;t expect with an English speaking talk at a WordCamp. They had a live translation which worked really well and that was cool. A lot of questions in the end as well and a good conversation and yeah, just an exciting new opportunity for me. I see it as just AI is a possibility to help us fix or help us with the problems users have with site building because it&#8217;s not easy to do us to build your front end site for WordPress Store or any website. So if AI tools can help users, our WordPress users, us to do these things a little easier and faster and maybe more inspirational with real content, like more related content and images that relate to the site you actually want to build. I think that&#8217;s just very exciting. And yeah helps for me seeing users struggle with our themes as well and finding the right theme for what they wanted to build over the years. I think it&#8217;s just a great opportunity to make it easier for users and also kind of then yeah make WordPress attractive on another level to very beginner users and can just do so much. It&#8217;s an exciting time, honestly I think.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah, no, I hear you. Yeah, There is this. WordPress.com has started with the AI site builder and I find it really helps with the onboarding of users that just want to get a site built. You still have to make the decisions about what&#8217;s your content about and what are the images that you want to do but. But it kind of gets out of the way in putting those things in and you don&#8217;t have to search for things too much. I think that WordPress 6.9 also and we&#8217;re going to talk a little bit later about the whole release that&#8217;s coming up with a command palette. Yeah, you can really shortcut some of the things, but you still need to know what you want to do to put the command in to get to where you want. But it&#8217;s also, yeah, there&#8217;s a lot of help out there. And I&#8217;m really excited also for the AI site building that ends up with a block theme and with a really fast site. So it&#8217;s a really cool thing.</p>\n\n\n\n<p><em>Ellen Bauer</em>: Yeah. What I like about it too, that it&#8217;s on the blocks patterns. Block theme foundation. What you can test. I really like it for something that is difficult for nonvisual users is you can get color palettes, ideas, you get template ideas. Because one of the things I always hear also with patterns from users, it&#8217;s like how do I decide which. You maybe have a pattern library in a theme, but it&#8217;s like how do you decide to put a page together with these patterns? It&#8217;s very challenging. Users don&#8217;t really know should I have testimonials in the bottom or at the top or what is most important? So there&#8217;s template page templates, suggestions shown and you can just pick one. It makes it way easier and more appealing. Same with like fonts. How should I know if the font is a professional font or a classic or more modern? It&#8217;s very difficult to tell. That&#8217;s like very advanced decisions you need to make on the design side as well. So if we can give suggestions and help, I think that makes it just easier and also more fun to build sites. Yeah. Another thing I probably have mentioned on the podcast is the word telex and doing. And you can test about it. Probably. Yeah. Because that&#8217;s also another thing I was like, oh, that&#8217;s so exciting because you can build blocks with AI and it&#8217;s so difficult to build blocks, but now it&#8217;s easy to have an idea and build a block.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. There was this blocktober fund by Tammie Lister which is now came to end. But there are 31, I think blocks that she built and she had some great ideas. I will put a link to it in the show notes again, but because what you can learn from there is also how you prompt the telex to actually get something out of it. So it was a really cool thing. And other people did also some, some great thing with Telex, the experimental block builder. Yeah.</p>\n\n\n\n<p><em>Ellen Bauer:</em> So that was also part of my talk prompting tips. And I think you could do a whole talk just about that and it will be way more important moving on how we. Yeah. How we talk to AI to actually make it efficient.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, absolutely. </p>\n\n\n\n<p><em>Ellen Bauer: </em>Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>And I&#8217;m really looking forward to the next flagship WordCamp where that will probably be even more prominent because the next one is WordCamp Asia in Mumbai. And I submitted some Talks there, not AI talks, but I&#8217;m still in the you build it yourself kind of block theme. I will do a workshop on block themes and how the different workflows work together. And so the good news was that the WordCamp Asia speaker team extended the deadline for speaker submission to December 15, which is kind of another month out.</p>\n\n\n\n<p><em>Ellen Bauer:</em> So I thought it was November, right?</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. And that was. They made a mistake on their Twitter account. I clarified that in the WC Asia channel on WordPress Slack so you can read up about it. But because there was a discrepancy between what the website said under speaker submission, what the tweet said. And it&#8217;s actually December 15th. Yeah, you don&#8217;t have to worry. Hurry next week.</p>\n\n\n\n<p><em>Ellen Bauer:</em> Oh, that is nice. The WordCamp Asia in Mumbai is. I just checked the date April 9 to 11 for everyone looking for travel dates and I submitted a talk as well. I will submit maybe a better version, improved version if I now have more time, which is great because it was a rushed application. But yeah, I&#8217;m really excited for that outcome and really, really hope I can make it there.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah. It&#8217;s the week after Easter so if you want to go a little bit earlier, you have some Easter holidays to cover your vacation, not to have to take. Well, in Germany we have three days, no two days vacation or holidays that are around Easter. So it&#8217;s a Good Friday as well as the Easter Monday they are off in Germany. So we have another holiday weekend that we could go there. So we plan to be a little bit ahead of time in Mumbai in India. So yeah, it&#8217;s going to be interesting. They also have a schedule of when they release tickets so you can go on the website and see that at the WordCamp Asia website, I think November 11th and then they have two more dates where they release tickets because the first one actually sold out within an hour or something like that. Yeah, yeah, I think it&#8217;s going to be a huge bootcamp.</p>\n\n\n\n<p><em>Ellen Bauer: </em>I think I got my tickets already for us, so. Yeah, but that&#8217;s nice that they released the dates.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah. The Guternberg Times, I also applied for media partners, so either speaker or media partner, maybe I will get my tickets that way. </p>\n\n\n\n<h3 class="wp-block-heading">Announcements</h3>\n\n\n\n<p>So yeah, so we&#8217;re coming through the announcements. The first one that I wanted to talk about is that Anne McCarthy updated us in her post update on phase three collaboration efforts November 2025 on the state of the phase three, the progress made, what&#8217;s in the works for the Future and especially WordPress 7.0. Now we&#8217;re talking 7.0 on the eve of release candidate for 6.9; there is not a whole lot of more information out there and the post is talking about the real time collaboration with multiple authors. Edit the content simultaneously without conflict. Now this feature has been tested with a small group of clients from WordPress VIP, but they&#8217;re loving it it seems, and they are bringing things to Core WordPress 6.9 has the asynchronous notes of collaboration. That&#8217;s the commenting on blocks that comes to WordPress December, but it allows you to add comments directly on the content blocks and there will be refinements and additional features kind of coming in the future. And what&#8217;s also prepared for WordPress 10.0 is behind the scenes the contributors are rebuilding the admin screens with a new Data View and Data Forms tools. There&#8217;s a whole new Fields API that kind of runs the data form components and then you organize and display information on admin pages. Part of it is also Media Library revamp and the extensibility for plugin developers. So that&#8217;s pretty much kind of a short rundown of what&#8217;s in the post. It&#8217;s much more detailed information with links to GitHub issues and PRs and all that. Any comments?</p>\n\n\n\n<p><em>Ellen Bauer: </em>I&#8217;m actually really, really excited about that and the start of that. It&#8217;s cool to see that in 6.9 already. I think just collaboration in general within WordPress is one of the things missing to have this thing like in Google Docs we all kind of love it. It&#8217;s so easy and yeah, I&#8217;m just so, so excited to get that in because we have always run our Elmo Studio blog with two people and at some point like even we had guest authors. So yeah that just makes it so much easier to actually work together in WordPress.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah and well we use Google Docs for any of the articles be it on the developer blog or internally at Automattic or for the Gutenberg Times. And this would just eliminate one step because you still have that step left that you need to copy paste things over and put the images in. And if you can start drafting already in WordPress it eliminates so much time that you kind of win there. It&#8217;s really cool.</p>\n\n\n\n<p><em>Ellen Bauer: </em>I never, I can&#8217;t even write in Google Docs, and I&#8217;m actually I&#8217;m using Notion as a drafting tool because it just doesn&#8217;t look as nice so. And yeah just easier if you can just collaborate within your save so much time and effort and it just, it&#8217;s just Nice to see the people you&#8217;re working with in your post and kind of work together there, the comments and feedback and I think even also for design stuff like I love Figma comments as well. It&#8217;s just. Hello, it&#8217;s so good to give feedback. So even if we can have a block section or even on patterns, we can comment on design topics as well there.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Ellen Bauer:</em> So yeah, even for the visual part of feedback on pattern designs and stuff, it will be really exciting to use that too.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, absolutely.</p>\n\n\n\n<p><em>Ellen Bauer: </em>For writers and content creators.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. So what is probably coming to WordPress 7.0 is that you also can highlight text. Not right now, you only can comment in the notes, just on single blocks. Yeah. So if the block is a long paragraph, you cannot just highlight things and then comment on that. So it&#8217;s not like Google Docs yet. But I think that&#8217;s the aim that developers have to make that work as well. I&#8217;m really excited for what&#8217;s to come. We&#8217;ll see. But it&#8217;s a lot of work. But the last half a year there has been some great progress there. </p>\n\n\n\n<p>All right, so the next thing that I wanted to point out here is the new the plugin review team has this plugin check plugin that you can as a plugin developer kind of use and check your plugins before you submit it. So you don&#8217;t get a whole lot of back and forth with the review team until they approve your plugin. That plugin also has a new version and the review team announced it just last week that they now not only screen new plugins that come to the repository, but also will screen updated plugins or plugin updates for security, compatibility and compliance. Right now it&#8217;s in testing form so currently the team evaluates the information only internally and sends reports to authors if needed. And they want to kind of. It&#8217;s like the normal WordPress way, you kind of look what it does and then you iterate on it. Yeah, they want to observe the behavior during updates and put in some refinements. </p>\n\n\n\n<p>And after that initial testing phase, automated security reports will be emailed to authors right after the plugin updates. This is such a huge progress because plugins account for 96% of WordPress vulnerabilities in 2024 in a report. And that increased scrutiny on the WordPress plugins repository is really a huge impact on the health of the whole WordPress ecosystem and it definitely will make the web a better place with 43% of all websites being WordPress having that additional layer There is really going to be huge.</p>\n\n\n\n<p><em>Ellen Bauer:</em> I love that too because yeah, it&#8217;s funny, I just remembered when you said that most of the. As a theme author, I can&#8217;t even count the number of times I get support requests for something is broken. And first thing I always said, oh yeah, I kind of sensed, oh, it&#8217;s, it&#8217;s a plugin. It&#8217;s most of the time the theme is not affected because there&#8217;s not much to a theme. You have to deactivate all your plugins and check the list when the error occurs. I think. I don&#8217;t know how much time I spend on plugin support actually as a theme author.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. I mean security, if you put a point to it, is actually something the server or the hosting company should really implement as well as an agency. When we were dealing with other websites from other people that actually support their businesses. Yeah. We made sure that they are on a hosting company that actually has their own security screening and the automating, removing of malware if that occurs. The plan might be a little bit more expensive, but it&#8217;s kind of that peace of mind for all of us is really important. But yeah, even then things could get through.</p>\n\n\n\n<p><em>Ellen Bauer: </em>So yeah, yeah, this is like very important help.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Absolutely.</p>\n\n\n\n<p><em>Ellen Bauer: </em>I think that if the offerings also for Hostess got better over the years, I think and more awareness. But yeah, just funny. It&#8217;s like part of my WordPress history is fixing plugin update issues.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Ellen Bauer:</em> Gosh.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. But I, I, that was work that I really hated.</p>\n\n\n\n<p><em>Ellen Bauer: </em>Yeah. Although it&#8217;s money because I was like, I&#8217;m just. It&#8217;s a theme, but it&#8217;s not the theme.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>No, no. It wasn&#8217;t something I thought or something like that. Or it was more like it&#8217;s not work that I would like to do. Yeah.</p>\n\n\n\n<p><em>Ellen Bauer: </em>So it was also work that we weren&#8217;t paid for. It was a lot of support. We did.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>But even if you get paid, it&#8217;s not work you want to do.</p>\n\n\n\n<p><em>Ellen Bauer: </em>That&#8217;s true.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Well, some people do, but yeah.</p>\n\n\n\n<p><em>Ellen Bauer: </em>So yeah, I didn&#8217;t like it either, but I had kind of. It&#8217;s funny if you do it like for so many years, like 10 years or so, you get a sense of. Also if you see the plugin that you already kind of know, like it&#8217;s like a six, then do you get on where the problem is? It&#8217;s kind of weird.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Absolutely. Yeah. Yeah. I think also the site health plugin that the WordPress contributors put together is really helpful in just kind of eliminating the plugins and that kind of. Yeah, that really helped with the research. But yeah, that can also happen. Not in a security context. It&#8217;s just kind of. Yeah, it broke my site. Yeah. So some update because it was a plugin conflict and the site health plugin is really helpful for that. </p>\n\n\n\n<h3 class="wp-block-heading">Community Contributions</h3>\n\n\n\n<p>So there&#8217;s WordPress Studio. I think I&#8217;m not sure if we ever mentioned it here at the podcast. It&#8217;s an open source local development tool and it now can handle blueprints and those are Playground blueprints. So they&#8217;re lightweight and they&#8217;re fast to implement and it&#8217;s a topic close to my heart. This year I did many talks about Playground and the blueprints and you can watch three of them on WordPress TV and I will have the link in the show notes. They are now available also to be used in Studio because Studio is based on Playground so it makes spinning up new sites so much faster. You can select three pre-built blueprints. One is just a quickstart WordPress.com website or a site for building plugins or themes, or creating an online store with WooCommerce and companion plugins pre-installed. But you could also kind of build your own and have all the plugins that you ever want to need for any site and spin up a new site with the theme or with some standards that you in an agency or as a freelancer always use and then can work on it. And I love this local development tool and paired with Playground CLI. Yeah it made my testing and development so much easier. It&#8217;s really great.</p>\n\n\n\n<p><em>Ellen Bauer: </em>I use it every day as well. Yeah, I didn&#8217;t. I wasn&#8217;t aware that there&#8217;s a WooCommerce version of the blueprint as well. That is cool because you don&#8217;t need to go ahead and test. Sometimes you just need to test a store and you don&#8217;t want to install all the plugins yourself a little bit annoying. So that can be.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>It&#8217;s absolutely handy.</p>\n\n\n\n<p><em>Ellen Bauer: </em>The next update I will cover that and it&#8217;s actually kind of an interesting thing and Matt blogged about it on his personal blog as well. So you can check out that link. It&#8217;s that a new plugin called the Internet Archive Wayback Machine Link Fixer. That&#8217;s a long name for plugin, but it helps to get an archived link to any kind of broken link that you have. Which for a lot of us who have older WordPress blogs or websites that is probably the case. And I actually I haven&#8217;t installed the plugin yet, but I will go to do that this weekend because yeah, that&#8217;s exciting. You can just get a link to any, any broken link to the Wayback Machine version, archived version of that website or blog post. And yeah, check out that post on Matt&#8217;s blog where he talks about it quickly and introduces it and yeah, I think that&#8217;s a really cool additional plugin that we have available to help with broken links. Really exciting. I love that. I will, I will test it and then maybe I blog about it too.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah. So go ahead. The plugin is free, but you need a free account on the Internet Archive site to obtain an API key because you tap in right into this and to connect your site to the interactor Archive. And then step two and three, you just have to make some additional decisions. But they&#8217;re very well explained about if you want automatically your site kind of put into the Wayback Machine and all that. </p>\n\n\n\n<p>Just for people who don&#8217;t know, the Internet Archive is a nonprofit library of millions of free text, movies, software, music, websites and more. And they run the Wayback Machine which pretty much surfaces previous versions of websites. So if you are new to a company and you want to do a redesign of the website, you probably want to go back and see what have they done in previous redesigns to kind of go back to see what&#8217;s important to them. And it&#8217;s probably a better way than to ask 15,000 questions.</p>\n\n\n\n<p><em>Ellen Bauer: </em>Yeah, that&#8217;s a nice idea. I haven&#8217;t thought about that. I actually love to go sometimes on the Wayback Machine with Manu. Just kind of looking at the old designs we had for our own website. It&#8217;s so fun to do that. Old designs of other sites that you loved and really, really fun. You can check out the old WordPress. Org versions or even like the Google Google site. It&#8217;s just fun to do that. And you kind of get a little bit of a nostalgic feeling. Oh yes, I remember that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. So when I started Gutenberg Times I had the 2019 default theme on it. And then somewhere in 2020 I think I switched to the Excel theme by Anders Noren and there were a few things that didn&#8217;t work that way in the other themes. So I just kind of adopted. And then now I come back and kind of compare what was the old one and what was the new one. It was, it was really interesting because I&#8217;m now building the third theme for, for the site and I want to do it myself and now I can do whatever I want with it without having to follow a theme, but I still wanted to make sure that I have all the things that I thought were important also in the new theme. So we&#8217;ll see. I&#8217;m definitely going to share my journey.</p>\n\n\n\n<p><em>Ellen Bauer: </em>You plan to update that soon?</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Soon as a relative term.</p>\n\n\n\n<p><em>Ellen Bauer: </em>When do you do it?</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> I&#8217;d like to have it by the end of the year, but we&#8217;ll see how that comes out. Yeah. I built it already. I needed an additional plugin for my podcast because I wanted to have the social icons from the podcast directories where our podcast is in. And only the 6.9 now has the possibilities that you can do custom social icons. So I tested that and it works. But I need to wait till it&#8217;s out too. So the plugin is available but it&#8217;s in the plugin repository. But I have one fix that I need to do. But also I wanted to have a better template for the podcast and the plugin API to register templates. That was in 6.8, but I needed to figure out how that works as well. Not all the things that I talk about. I know how to do it when I want to do it. It&#8217;s kind of really interesting.</p>\n\n\n\n<p><em>Ellen Bauer: </em>Yeah. And it&#8217;s always just finding the time for these on the side things.</p>\n\n\n\n<h3 class="wp-block-heading">What’s Released &#8211; WordPress 6.9 Beta 4</h3>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. So now we&#8217;re coming to the what&#8217;s released section of our podcast and the first one is today, Friday, November 7, WordPress 6.9 beta 4 was released. It&#8217;s a quiet beta. It has a release post, but that&#8217;s on the make blog. Just because there was one thing that they needed to reverse and so they wanted before the release candidate on Tuesday, November 11, they wanted to have another beta to make sure everything works all right or the thing that they changed works all right. Let me put it this way. Yeah. So this is also a good place to talk about last minute WordPress 6.9 feature decisions. Contributors have decided to not move ahead with the enhanced template management feature for this version. The content only editing was also punted to 7.0 as well as the updated block binding UI for external sources, there were a few issues with all three of them during testing sessions and that can&#8217;t be While the content only editing was earlier decided that it&#8217;s not going to come to 6.9, but the other two, there were issues that couldn&#8217;t be resolved in the remaining time before the strength freeze in release candidate one, which is Tuesday. So yeah. Ellen, what are your favorite features for 6.9? Anything standing out for you?</p>\n\n\n\n<p><em>Ellen Bauer: </em>Yes, I was looking forward to the template management feature of course we have to wait. We have to wait for that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> It&#8217;s still in Gutenberg. Yeah, it&#8217;s still in the plugin. It&#8217;s just not.</p>\n\n\n\n<p><em>Ellen Bauer: </em>Then second pick. I still am super excited that at least we start with the commenting option on post. Like on blocks and posts. I&#8217;m excited to just have this in there. Like that&#8217;s something we haven&#8217;t had in WordPress. So yeah, that&#8217;s. I think I would pick that as my favorite. And then instead.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Are you getting excited about the new blocks?</p>\n\n\n\n<p><em>Ellen Bauer: </em>Oh, yes, new blocks as well. So the accordion, it&#8217;s actually nice to see that come in because we have started using that in WooCommerce for an update on the. Having the tabs for a description, like a product description, additional information and comments in there. So I think I&#8217;m a little bit semi proud. Maybe that pushed it, the accordion block into more attention, into Core and then the. I&#8217;m not sure if I have the name right. Is it called Sticky? Sticky Sketchy text? Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>No, Stretchy. Stretchy.</p>\n\n\n\n<p><em>Ellen Bauer:</em> Stretchy. Stretchy. That makes more sense. Yeah, just that&#8217;s from a designer perspective. It&#8217;s interesting actually to see that in Core because that&#8217;s like just a design tool and a fun kind of block. I love seeing that in Core. Yeah. Just nice to see this kind of more fun not experimental, but like just design tool core blocks coming in and then icons block. Really, really nice to have that. But that&#8217;s not like needed, wanted. Oh, no, that&#8217;s seven.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, the icons block didn&#8217;t make it.</p>\n\n\n\n<p><em>Ellen Bauer: </em>Oh, no. Oh, sorry.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Okay.</p>\n\n\n\n<p><em>Ellen Bauer: </em>We have to wait. Well, next year then we will get more excited. Yeah, I want that so badly.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, the icons block as well as the. The block visibility is there as well, but it&#8217;s more like the basic kind of feature, the foundation for what&#8217;s to come in 7.0. But it&#8217;s good to have it in talking about the accordions if you want to kind of get a little bit of a head start on styling accordions. Justin Tadlock just published last week a tutorial on how to style accordions with WordPress 6.9. And he walks you through how to do it in theme JSON and how to do a style variation as well as how to do the pattern for an accordion pattern. So that gives you a head start on updating your theme or your own site with it. </p>\n\n\n\n<p>What&#8217;s coming to the developer blog? We have just the editorial meeting yesterday. We just approved a snippet how you can also add structured data to your FAQ accordion. So it gets right into the SEO kind of thing because Google treats the FAQs differently. It kind of does answer question answers quite nicely. So you can make that also with the accordion. And he will publish that probably in about two weeks or three. We&#8217;ll see how that comes. Yeah. There&#8217;s also on the developer blog where additional theme related things like the border radius, size presets that come into WordPress 6.9 and also I mentioned it, the social icons, custom icons that you want if you want them. Also a tutorial on the developer blog register custom social icons and we have one more that is the how to style forms with theme JSON that comes also with six point nine.</p>\n\n\n\n<p><em>Ellen Bauer: </em>That&#8217;s a big one. Oh, that&#8217;s cool.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Absolutely.</p>\n\n\n\n<p><em>Ellen Bauer: </em>Very exciting because that&#8217;s one of the things you miss that was missing always for themes and our custom icons. Actually I think it&#8217;s a bigger feature than you think because that was always for years one of the requests like how do I get my own icon in there? Like, oh, it&#8217;s missing. Like maybe certain countries have their big individual icons that were not what kind of icons icons, but tools, social.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> I can. Websites. Yeah, yeah, yeah, absolutely.</p>\n\n\n\n<p><em>Ellen Bauer: </em>I remember there was a German one we were always asked for. I don&#8217;t remember what it was, but from different communities you get different requests.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. In Germany there was this ext or next or something like that was a social one. Right. But that kind of folded into LinkedIn now. So. All right, I&#8217;ll put the links to the developer blog posts into the show notes and so you can all follow along on that. </p>\n\n\n\n<h3 class="wp-block-heading">Gutenberg 22.0</h3>\n\n\n\n<p>And that brings US to Gutenberg 22.0, and Carlos Bravo was the release lead on that and he kind of said that it was a relatively quiet Gutenberg release because it followed the WordPress point release and it normally prioritizes core quality and bug fixes over new enhancements. So we probably get here pretty quickly go through that. </p>\n\n\n\n<h3 class="wp-block-heading">Enhancements</h3>\n\n\n\n<p>Well, I’ll start with the block library changes in the navigation block. You can have a button create a new page, but you create it and then what happened. Now you have a notice that there was a page created and how to find it. So that&#8217;s really cool. It&#8217;s a quality of life improvement that. Yeah, you only notice that it&#8217;s there or that it&#8217;s not there, but it&#8217;s missing all the time.</p>\n\n\n\n<p><em>Ellen Bauer:</em> And the second one was that breadcrumbs now get support for archives. That was missing, just missing before, Birgit.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, so breadcrumbs came in actually with this Release out of experimentation, but it will not make it to 6.9. But the breadcrumbs block is a new block and the archive support was. There were kinds of discussions about how deep does the first version has to go. And now that it&#8217;s not getting into 6.9, it just gets. Just ongoing improvements. So it gets into WordPress 7.0.</p>\n\n\n\n<p><em>Ellen Bauer: </em>Yeah, I love that. For blogs, that makes a huge difference.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Absolutely. That&#8217;s one thing. Also, when you have a huge site and you have 50 pages or something like that, your visitors most very often get lost. Unless you have additional navigation in there, and breadcrumbs help you so you don&#8217;t have to do this all manually and kind of think about how to get back to other places. I really love that. That and that the team actually takes time to get to work on this a little longer. And so the version is actually delightful and not just like an MVP or something like that. Yeah. The next one is that the categories block has a taxonomy CSS class now. So that&#8217;s probably only interesting for people that were looking for that and had to do custom CSS to kind of figure that out. But that&#8217;s definitely now in Gutenberg 22.0.</p>\n\n\n\n<p><em>Ellen Bauer: </em>I think having CSS classes for pretty specific things from theme author perspective, just helpful. A lot of time to just have that in there. So I like that. The next one was that I think that&#8217;s just added an explanation to the fit text feature that it gets just a description is added, that it overrides the default font settings.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Ellen Bauer: </em>So that&#8217;s what I wasn&#8217;t visible just for users being aware of that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>I think so. Yeah. That&#8217;s just a mix. Users are aware that sometimes you don&#8217;t get the connection, that if you have one option, the other option goes away. Yeah. So.</p>\n\n\n\n<p><em>Ellen Bauer: </em>And I think that helps. So I think yeah, they just added it fit into the container and then overrides your font&#8217;s default font setting. That helps to just explain it better.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, absolutely. And just now that we&#8217;re talking about it, the stretchy text, they are still not sure if the font size or the font option or separate blocks. So they&#8217;re now getting into a variation for 6.9. I have not seen that issue or the pull request actually be merged, but we&#8217;ll see if it&#8217;s going to be in Release candidate one or it still stays as it is and comes in 5.7, 7.0. Why 5.7? That&#8217;s wrong. Yeah. The latest comments block now has an option to display full comments so there were only two versions. One was just the title and then an excerpt. And then now you can have all the full comments displayed in your post template or page template. So that&#8217;s also pretty cool.</p>\n\n\n\n<p><em>Ellen Bauer:</em> One additional new update is also in the global styles and actually Birgit had to help me figure that out. Global styles are now, can now be accessed in the post editor. But you need to have. What is it? You need to have Active show template template. Yeah, show template. And it&#8217;s like, okay, where is show template Burgundy? Had to help me out with that one. It was under preview.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> It was the preview of the test.</p>\n\n\n\n<p><em>Ellen Bauer: </em>So where you, where you look for the tablet and the mobile version of the preview, you also have the show template and I couldn&#8217;t find it. And then you get the little icon for global styles.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah. And then you can make changes. Yeah, you can make changes to, to your template on the global level, which really helps with. You don&#8217;t have to go back and go through the templates and all that. So it&#8217;s really interesting. I haven&#8217;t really worked with that yet because I didn&#8217;t find a need for that. But I, I can see that then all of a sudden post in the template when it says, oh, this is wrong, you just want to go in and make a small change of things. So this is helpful to not have to get out of your post and then have to go into the site editor and the template. And yeah, it&#8217;s kind of just a shortcut for.</p>\n\n\n\n<p><em>Ellen Bauer: </em>I think it also builds like having that connection also builds a little bit more awareness for users of the connection between where what a template actually is and that you can. What global styles are that you have that connection of. Oh, the global styles are connected to the template of this post and if I change something there, it&#8217;s changed in the post. I think there&#8217;s still difficulty for users to understand that connection if the templates are hidden and the global styles are hidden in just the site editor.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So that&#8217;s a good point.</p>\n\n\n\n<p><em>Ellen Bauer: </em>It just builds that connection.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>That&#8217;s a good point. Yeah. Thank you. I haven&#8217;t even thought about it, but that helps people figure out because the template, new WordPress users might not have that problem, but long time WordPress users, they never had to deal with templates because it was all, it was all something that the theme developer would do for them and they were just using it. But now that they have control over it, they also kind of need to be aware what they&#8217;re doing with it. And the enhanced template management is Also part of it, that it needs to be a little bit less confusing. And also follow some. Some things that they say if I change something on a template, I don&#8217;t want it to go public without me knowing. So I want a draft section there and keep the other template going until the other one, the new one is finished. So that is something that comes with enhanced template management and I&#8217;m really looking forward to that.</p>\n\n\n\n<p><em>Ellen Bauer:</em> That will be exciting also to make templates more exciting to play with because. Yeah, I think there&#8217;s still an amazing amount of confusion of what a template versus a page actually is. So just if users play more with custom templates and build their own, I think that builds more awareness of that. The difference between these two.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, definitely. Yeah. So I think one of the last things that we want to talk about here is the. That the math block, which is a new block coming to 6.9. Yeah. Yeah. I&#8217;m love it. I actually was in school, I had all these big formulas to talk about. To write and. Yeah. And I was never kind of thinking, oh, I could do a blog post about things that. Because I had no way of knowing how to do the formulas. Yeah.</p>\n\n\n\n<p><em>Ellen Bauer: </em>And you can&#8217;t really output them.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. And they follow the mathwork, follows latex formatting, which is the math kind of language, and then puts it into your site. And now it also. It&#8217;s now enabled. Horizontal scrolling is now enabled because those formulas can be really, really long. And so you can kind of have a horizontal scrolling on your formula so you don&#8217;t have to kind of put line breaks in there where no line breaks. I want that.</p>\n\n\n\n<p><em>Ellen Bauer:</em> I want to start a blog to blog about math. I was never good at math, but I always. It&#8217;s admiring too. I love it. So maybe we should all start blogging about math now.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Yeah.</p>\n\n\n\n<p><em>Ellen Bauer:</em> Problems.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Math problems. Yeah. Especially fractions and all that kind of. What was it? Five. You&#8217;re very long.</p>\n\n\n\n<p><em>Ellen Bauer: </em>So we need the scrolling.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, we can do the scrolling. Yeah.</p>\n\n\n\n<h3 class="wp-block-heading">Experiments</h3>\n\n\n\n<p>And I&#8217;m gonna scroll further through the changelog and I&#8217;m stopping at the experiments because the real time collaboration experiment is still on in Gutenberg and we talked about it, but there have also been some changes now. And one is that it&#8217;s supporting synced post data and it also the YJS import is actually behind the experimental flag, which is actually a code quality thing. And they implemented CRDT persistence for collaborative editing. And that just means that&#8217;s the. The saving of your immediate changes and then the sync part that works persistently on your collaborative editing plane. It&#8217;s a really complicated thing to do. But they seem to have figured it out with that library, the YJS and Kevin, who is the maintainer of that, was part of the initial MVP of the collaborative editing and now. Yeah, so it&#8217;s really cool. </p>\n\n\n\n<p>And you need to go install 2020.0 Gutenberg plugin and then go to the Gutenberg menu item and enable the look at the experiments page and enable real time collaboration. So there are a few steps there to get to that, but that&#8217;s good. So it all stays behind the experimental flag as long as it&#8217;s in development. Good. </p>\n\n\n\n<h3 class="wp-block-heading">What’s in Active Development or Discussed</h3>\n\n\n\n<p>So for the developers amongst you listener, there is. I&#8217;m sharing an issue about the version 2 of the build WordPress scripts where Riad Benguella, one of the lead architects of Gutenberg has opened this issue about kind of making scripts a little bit more flexible and also have the point that it comes easier and feels a little bit more simple. But that&#8217;s all is good. Good goals I would say but I think the technology is a little bit more complicated. But I will share that for all the developers on the show or who listen here to check out because Riad needs people who build plugins and have a build process and use the WordPress scripts to actually test the version 2 so they can catch all the edge cases and all the use cases before they actually migrate that all over. So that&#8217;s my thing. Alan, is there something that you want to remind people about upcoming events or releases.</p>\n\n\n\n<p><em>Ellen Bauer: </em>Actually I can&#8217;t think of anything at the moment.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> So if people want to connect with you, where would they find you on the.</p>\n\n\n\n<p><em>Ellen Bauer: </em>I&#8217;m definitely on the Slack WordPress Developer Slack or on social. I think I&#8217;m moving more and more to Blue Sky.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Okay.</p>\n\n\n\n<p><em>Ellen Bauer: </em>And yeah also on X and there and YouTube is like a thing I want to be more present and add more content to. So yeah, I have a YouTube channel. I think you can find me just under my name on all of these or maybe Elmer studio on the YouTube. I&#8217;m not sure. I think both is possible.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Okay. Yeah I will share share this all in the show notes and as always. Oh I wanted to announce something. Sorry on November 13th. That&#8217;s next week. If you listen to this over the weekend you get the chance to see the developer hours come back to the online workshops on Learn on Meetup and JuanMa and Jonathan Bosinger are going over the developer parts of WordPress 6.9 one is the Data Views and Data Forms and Fields API. The other one is the Abilities API and they might even be covering Interactivity API, seeing what kind of time they have. But that&#8217;s on meetup on November 13, just to let you know.</p>\n\n\n\n<p><em>Ellen Bauer: </em>Exciting.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yes. As always, the show notes will be published on GutenbergTimes.com/podcast. This is episode 124. 124. And if you have questions and suggestions or news you want us to include, send them to <a href="http://changelogutenbergtimes.com">changelogutenbergtimes.com</a> that&#8217;s <a href="http://changelogutenbergtimes.com">changelogutenbergtimes.com</a> and if you want to leave a review on Apple or podcast or Pocketcast or any other of your favorite podcast, only.</p>\n\n\n\n<p><em>Ellen Bauer: </em>Five star, of course.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Well, I, I take anyone. Yeah, that, that&#8217;s kind of how I connect with the listeners and if you can improve.</p>\n\n\n\n<p><em>Ellen Bauer: </em>But you deserve the best.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Well, thank you. Thank you. I think so. But yeah, maybe other people have a different opinion and my, my opinion only counts when I&#8217;m home alone. So. Yeah. So thanks everyone. And until the next time, be well. And we see we hear each other just before Thanksgiving. And thanks to Ellen Bauer for coming to us.</p>\n\n\n\n<p><em>Ellen Bauer: </em>Thank you. Bye, everyone.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Take care.</p>\n\n\n\n<p><em>Ellen Bauer: </em>Bye. Bye.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 09 Nov 2025 13:22:38 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:18:"Birgit Pauli-Haack";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:20:"Matt: Ben on Bubbles";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150519";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:37:"https://ma.tt/2025/11/ben-on-bubbles/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:181:"<p>Check out Ben Thompson of Stratechery (one of the most valuable subscriptions) on <a href="https://stratechery.com/2025/the-benefits-of-bubbles/">The Benefits of Bubbles</a>.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 09 Nov 2025 04:45:06 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:117:"Gutenberg Times: State of the Word, WordPress 6.9, Forms styling, Interactivity API, and more — Weekend Edition 348";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://gutenbergtimes.com/?p=42665";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:120:"https://gutenbergtimes.com/state-of-the-word-wordpress-6-9-forms-styling-interactivity-api-and-more-weekend-edition-348/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:23879:"<p>Hi there, </p>\n\n\n\n<p>Next week is Release Candidate 1 week! Subscribe to the <a href="https://make.wordpress.org/core/">Make Core Blog</a>, if you haven&#8217;t yet, to get all the Dev Notes and the Fieldguide notifications. &#8220;String freeze&#8221; is this state of the release called until the final release on December 2, 2025. It&#8217;s also the start of the last four weeks when the wonderful translators of the <a href="https://make.wordpress.org/polyglots/teams/">Polyglots team</a> work to bring the new version to many dozens of languages. </p>\n\n\n\n<p>This week was busy, too, though. I hope you enjoy all the good things below.</p>\n\n\n\n<p>Yours, <img alt="💕" class="wp-smiley" src="https://s.w.org/images/core/emoji/16.0.1/72x72/1f495.png" style="height: 1em;" /><br /><em>Birgit</em></p>\n\n\n<section class="wp-block-newsletterglue-group" style="padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;">\n<div class="wp-block-group has-light-background-background-color has-background"><div class="wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<nav class="wp-block-table-of-contents"><ol><li><a class="wp-block-table-of-contents__entry" href="https://gutenbergtimes.com/state-of-the-word-wordpress-6-9-forms-styling-interactivity-api-and-more-weekend-edition-348/#0-word-press-release-information">Developing Gutenberg and WordPress</a><ol><li><a class="wp-block-table-of-contents__entry" href="https://gutenbergtimes.com/state-of-the-word-wordpress-6-9-forms-styling-interactivity-api-and-more-weekend-edition-348/#wordpress-6-9">WordPress 6.9</a></li></ol></li><li><a class="wp-block-table-of-contents__entry" href="https://gutenbergtimes.com/state-of-the-word-wordpress-6-9-forms-styling-interactivity-api-and-more-weekend-edition-348/#0-p">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a class="wp-block-table-of-contents__entry" href="https://gutenbergtimes.com/state-of-the-word-wordpress-6-9-forms-styling-interactivity-api-and-more-weekend-edition-348/#2-word-press-6-0-1-and-6-1-scheduled">Theme Development for Full Site Editing and Blocks</a></li><li><a class="wp-block-table-of-contents__entry" href="https://gutenbergtimes.com/state-of-the-word-wordpress-6-9-forms-styling-interactivity-api-and-more-weekend-edition-348/#3-building-themes-for-fse-and-word-press">Building Blocks and Tools for the Block editor.</a></li></ol></nav>\n</div></div>\n</section>\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n<div class="wp-block-newsletterglue-showhide ng-block" width="100%"></div>\n\n\n<p>WordPress 6.9 is not the only major WordPress event on <strong>December 2, 2025</strong>. On this day, <strong>Matt Mullenweg</strong>&#8216;s annual keynote, <strong><a href="https://wordpress.org/state-of-the-word/">State of the Word</a></strong>, will be livestreamed from San Francisco, CA. It will take place around noon Pacific Time and will be recorded so the other half of the World can watch it on the rerun, so to speak. Being there in person is also possible with limited seating. You can request a ticket on the landing page. You might find a watch party near you or you can register your own party. </p>\n\n\n\n<figure class="wp-block-image size-large"><a href="https://wordpress.org/state-of-the-word/"><img alt="Matt Mullenweg announced Gutenberg Roadmap at WordCamp Europe 2018" class="wp-image-11856" height="435" src="https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2019/07/WordCamp-Europe-2018.jpg?resize=652%2C435&#038;ssl=1" width="652" /></a></figure>\n\n\n\n<h2 class="wp-block-heading" id="0-word-press-release-information">Developing Gutenberg and WordPress</h2>\n\n\n\n<p><strong>Carlos Bravo</strong> released Gutenberg 22.0, and in his post <a href="https://make.wordpress.org/core/2025/11/05/whats-new-in-gutenberg-22-0-05-november/"><strong>What’s new in Gutenberg 22.0? (5 November)</strong></a>, he noted &#8220;Typically, the Gutenberg release following a WordPress point release focuses on core quality and bug fixes over new enhancements. As such, this will be a relatively quiet release.&#8221; He highlighted two things, both already slated for WordPress 7.0 and later. </p>\n\n\n\n<ol class="wp-block-list">\n<li><a href="https://make.wordpress.org/core/2025/11/05/whats-new-in-gutenberg-22-0-05-november/#real-time-collab-post-meta">Real-time Collaboration: Post Meta Synchronization</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/05/whats-new-in-gutenberg-22-0-05-november/#new-theme-package">A new theme package</a></li>\n</ol>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p><strong>Anne McCarthy</strong> published an <a href="https://make.wordpress.org/core/2025/11/06/update-on-phase-3-2025/"><strong>Update on Phase 3: Collaboration efforts (Nov 2025)</strong></a> and noted that WordPress Phase 3 focuses on making teamwork easier.</p>\n\n\n\n<ul class="wp-block-list">\n<li>Real-time collaboration lets multiple authors edit content simultaneously without conflicts. </li>\n\n\n\n<li>Block Notes, arriving in WordPress 6.9, allows users to add comments directly on content blocks. </li>\n\n\n\n<li>Behind the scenes, WordPress is rebuilding admin screens with new DataView and DataForm tools, which organize and display information better while letting developers customize them easily across different admin pages.</li>\n</ul>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p><strong>Rae Morey</strong> expands on this update in her article, <a href="https://www.therepository.email/real-time-collaboration-flagged-for-wordpress-7-0-amid-ongoing-technical-challenges"><strong>Real-Time Collaboration Flagged for WordPress 7.0 Amid Ongoing Technical Challenges</strong></a> and includes additional information about the VIP plugin as well as this year&#8217;s progress.</p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p><strong>Ellen Bauer</strong> joined me from New Zealand to record the next podcast episode with me Gutenberg Changelog #124. We talked a lot about WordPress 6.9, WordCamps, Block Themes and more. It&#8217;ll arrive at your favorite podcast app over the weekend. </p>\n\n\n\n<figure class="wp-block-image size-full"><img alt="Gutenberg Changelog 124 with Ellen Bauer and Birgit Pauli-Haack " class="wp-image-42695" height="185" src="https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/11/Screenshot-2025-11-07-at-18.56.39.png?resize=652%2C185&#038;ssl=1" width="652" /></figure>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<div class="wp-block-group has-light-background-background-color has-background"><div class="wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained">\n<p><img alt="🎙" class="wp-smiley" src="https://s.w.org/images/core/emoji/16.0.1/72x72/1f399.png" style="height: 1em;" /> The latest episode is <a href="https://gutenbergtimes.com/podcast/gutenberg-changelog-123-wordpress-6-9-and-gutenberg-21-9/">Gutenberg Changelog #123 – WordPress 6.9 and Gutenberg 21.9</a> with <strong>Isabel Brison</strong>, core contributor. and JavaScript developer at Automattic. </p>\n\n\n\n<figure class="wp-block-image size-full is-style-no-vertical-margin"><a href="https://gutenbergtimes.com/podcast/gutenberg-changelog-123-wordpress-6-9-and-gutenberg-21-9/"><img alt="" class="wp-image-42384" height="185" src="https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-23-at-17.20.50.png?resize=652%2C185&#038;ssl=1" width="652" /></a></figure>\n\n\n<div class="wp-block-newsletterglue-showhide ng-block" width="100%">\n<figure class="wp-block-embed is-type-rich is-provider-pocket-casts wp-block-embed-pocket-casts"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n</div></div></div>\n\n\n\n<h3 class="wp-block-heading" id="wordpress-6-9">WordPress 6.9</h3>\n\n\n\n<p><a href="https://make.wordpress.org/core/2025/11/07/wordpress-6-9-beta-4/"><strong>WordPress 6.9 Beta 4</strong></a> is now available for testing. As always, the post shows you four different ways how you can start with your testing sessions.</p>\n\n\n\n<p>Contributors decided on punting the <em>enhanced template management</em> features to WordPress 7.0. A few issues surfaced during testing sessions that can’t be resolved in the remaining time before string freeze with Release Candidate 1.  </p>\n\n\n\n<p>WordPress 6.9 Release Candidate 1 is scheduled for November 11, 2025, and so are the Dev Notes, updates for developers about the relevant changes: </p>\n\n\n\n<ul class="wp-block-list">\n<li>Interactivity API</li>\n\n\n\n<li>Abilities API</li>\n\n\n\n<li>Block Bindings API</li>\n\n\n\n<li>Streaming Block Parser </li>\n\n\n\n<li>Modernizing UTF-8  support</li>\n\n\n\n<li>Updates to the HTML API</li>\n</ul>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p><strong>JuanMa Garrido</strong> and <strong>Jonathan Bossenger</strong>, developer advocates at Automattic,  invite you to join them for a Developer Hour: <a href="https://www.meetup.com/learn-wordpress-online-workshops/events/311854653/"><strong>WordPress 6.9: developer updates</strong></a> on <strong>November 13, 2025, at 10 am UTC</strong> &#8211; It&#8217;s a bit early for US timezone&#8217;s though. The session will be recorded and appear shortly after on WordPressTV. </p>\n\n\n\n<figure class="wp-block-image size-large"><a href="https://www.meetup.com/learn-wordpress-online-workshops/events/311854653/"><img alt="" class="wp-image-42709" height="576" src="https://gutenbergtimes.com/wp-content/uploads/2025/11/Devhours-1024x576.avif" width="1024" /></a></figure>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p>Styling form elements with the Block editor becomes much easier. <strong>Justin Tadlock</strong> posted a tutorial on the WordPress Developer Blog on <a href="https://developer.wordpress.org/news/2025/11/how-wordpress-6-9-gives-forms-a-theme-json-makeover/"><strong>How WordPress 6.9 gives forms a theme.json makeover</strong></a>. WordPress 6.9 introduces theme.json support for form styling on text inputs and select dropdowns, enabling designers to apply border, color, shadow, and spacing properties globally. However, focus states, labels, checkboxes, and other form elements still require custom CSS. This is just the beginning. Contributors are working on releasing more form styling options in the future. </p>\n\n\n\n<p>Other articles on WordPress 6.9 features to come: </p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://developer.wordpress.org/news/2025/10/styling-accordions-in-wordpress-6-9/">Styling accordions in WordPress 6.9</a></li>\n\n\n\n<li><a href="https://developer.wordpress.org/news/2025/09/border-radius-size-presets-in-wordpress-6-9/">Border radius size presets in WordPress 6.9</a></li>\n\n\n\n<li><a href="https://developer.wordpress.org/news/2025/08/registering-custom-social-icons-in-wordpress-6-9/">Registering custom social icons in WordPress 6.9</a></li>\n</ul>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p><strong>Dave Smith</strong>, core contributor on Gutenberg, explains in his video <a href="https://www.youtube.com/watch?v=2F9jWikYkec"><strong>WordPress 6.9 FIXES Navigation Links</strong></a> the main change to the Navigation block in WordPress 6.9. Now the navigation links are dynamic and adopt automatically when you change a slug. </p>\n\n\n<div class="wp-block-newsletterglue-showhide ng-block" width="100%">\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n</div>\n\n\n<h2 class="wp-block-heading" id="0-p">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p><strong>Steve Burge</strong>, Publish Press, <a href="https://bsky.app/profile/steveburge.com/post/3m4tk5cjpks22">announced</a> the new version of <a href="https://wordpress.org/plugins/advanced-gutenberg/"><strong>Gutenberg Blocks</strong></a> (v 3.5.2). It brings a new feature to the block editor. &#8220;You can just create your own styles for any block.&#8221; A socalled Style builder is now available to create these style all no-code.</p>\n\n\n\n<figure class="wp-block-image size-large"><img alt="" class="wp-image-42691" height="366" src="https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/11/PublishPress-Block-Style-builder-edited.jpg?resize=652%2C366&#038;ssl=1" width="652" /></figure>\n\n\n\n<p><strong>Velda Christiansen</strong>, member of the training team and support engineer at Automattic, held another workshop to teach WordPress users about <a href="https://wordpress.tv/2025/11/04/landing-pages-posts-more-strategies-for-a-stronger-site/"><strong>Landing Pages, Posts &amp; More: Strategies for a Stronger Site</strong></a>. It was a workshop on WordPress content strategies, demonstrating how to create effective landing pages through template customization. Christiansen addressed attendees&#8217; technical questions and concluded by discussing hosting, email strategies, monetization options, and resources for further learning.</p>\n\n\n\n<h2 class="wp-block-heading" id="2-word-press-6-0-1-and-6-1-scheduled">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p><strong>Iliana Mustafa</strong>, Digital Marketing Manager at HumanMade, shared by <strong><a href="https://humanmade.com/full-site-editing/building-smarter-not-harder-why-we-embraced-fse-for-our-own-website-redesign/">Why we embraced FSE for our own website redesign</a></strong>. &#8220;One of the biggest wins of the redesign has been how much ownership our marketing and content team now has over the site.&#8221; She wrote. </p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p><strong>Johanne Courtright</strong> addressed a challenge with forms: providing styling controls for Gravity Forms in the block editor. In her blog post <a href="https://groundworx.dev/resources/making-gravity-forms-inputs-play-nice-with-block-themes/"><strong>Making Gravity Forms Inputs Play Nice with Block Themes</strong></a>, she outlines her method, which includes converting Gravity Forms buttons to standard WordPress block buttons using PHP, applying scalable input styling with CSS custom properties, and offering nine color customization options in Gutenberg. This system keeps form input elements intact while enhancing Gravity Forms&#8217; structure, allowing for proportional scaling through font-size changes and easy use as standalone styles or complete plugin integration.</p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p>On the WPTavern Jukebox, <strong>Nathan Wrigley</strong> interviewed <a href="https://wptavern.com/podcast/192-joshua-bryant-on-how-dow-jones-is-supercharging-wordpress-editorial-workflows"><strong>Joshua Bryant on How Dow Jones Is Supercharging WordPress Editorial Workflows</strong></a>. They discussed  how Dow Jones decoupled Gutenberg from WordPress Admin, embedding it into a standalone React application to accelerate breaking news publication.  Bryant explained that Dow Jones operates Wall Street Journal, Barron&#8217;s, and MarketWatch on WordPress Multisite but needed faster editorial workflows for time-sensitive content. He emphasized that discovering WordPress&#8217;s global WP object handling was challenging but revealed how well-engineered WordPress truly is.</p>\n\n\n<div class="wp-block-newsletterglue-showhide ng-block" width="100%">\n<figure class="wp-block-embed is-type-rich is-provider-pocket-casts wp-block-embed-pocket-casts"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n</div>\n\n<section class="wp-block-newsletterglue-callout undefined not-color-set" style="border-color: #f9f9e5; border-radius: 22px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f9f9e5;">\n<p><strong> <a href="https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/" rel="noreferrer noopener" target="_blank">&#8220;Keeping up with Gutenberg &#8211; Index 2025&#8221;</a> </strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href="https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/">2020</a> | <a href="https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/">2021</a></strong> | <strong><a href="https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/">2022</a></strong></strong> | <strong><a href="https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023">2023</a></strong> | <a href="https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2024/"><strong>2024</strong></a></p>\n</section>\n\n\n<h2 class="wp-block-heading" id="3-building-themes-for-fse-and-word-press">Building Blocks and Tools for the Block editor.</h2>\n\n\n\n<p><strong>Carlo Daniele</strong>, Kinsta, helps you <a href="https://kinsta.com/blog/wordpress-interactivity-api/"><strong>unlock new possibilities with the WordPress Interactivity API</strong></a>. &#8220;This API enables you to create blocks that react in real time to user interactions, allowing you to create rich user experiences and make your sites attractive, dynamic, and engaging.&#8221;, he wrote Daniele guides readers through the WordPress Interactivity API by explaining its core concepts, breaking down technical file structures, and then demonstrating practical application by building an interactive shopping cart block from scratch. He moves from theory to hands-on implementation with code examples and visual aids. <br /></p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p><strong>JuanMa Garrido</strong> introduced <a href="https://juanma.codes/2025/11/02/a-dataviews-powered-explorer-for-the-abilities-api/"><strong>A DataViews-powered explorer for the Abilities API</strong></a> on his personal blog. He created an Abilities Dashboard prototype that combines WordPress&#8217;s Abilities API with DataViews, a React component system. </p>\n\n\n\n<p>The <a href="https://make.wordpress.org/ai/2025/07/17/abilities-api/">Abilities API</a> allows plugins to describe their capabilities in a machine-readable format for AI tools and automation. Building on <a href="https://github.com/karmatosed/abilitiesexplorer"><strong>Tammie Lister&#8217;s Abilities Explorer plugin</strong></a>, Garrido developed a client-side dashboard using DataViews, aligning with modern WordPress admin interfaces. His project demonstrates how DataViews can effectively display and interact with Abilities data, serving as a reference for this emerging intersection of AI and data management in WordPress.</p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p><strong>Troy Chaplin,</strong> web developer from Ottawa, shared the <a href="https://developer.wordpress.org/news/snippets/limiting-allowed-blocks-without-breaking-the-site-editor/" rel="noreferrer noopener" target="_blank"><strong>Snippet: Limiting allowed blocks without breaking the Site Editor</strong></a> on the WordPress Developer Blog. &#8220;By scoping the <code>allowed_block_types_all</code> filter to post types and editor context, you keep the best of both worlds: editorial consistency for authors and full creative control for designers. A small change, but one that can save hours of confusion down the road.&#8221; he wrote in his conclusion. </p>\n\n\n<section class="wp-block-newsletterglue-callout undefined not-color-set" style="border-color: #eeeeee; border-radius: 26px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f3efe9;">\n<p><strong><a href="https://gutenbergtimes.com/need-a-zip-from-master/">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href="https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href="mailto:pauli@gutenbergtimes.com">Email me </a>with your experience</p>\n\n\n\n<p><img alt="GitHub all releases" src="https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge" /></p>\n</section>\n\n\n<p class="has-text-align-center has-small-font-size"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href="mailto:pauli@gutenbergtimes.com">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity" />\n\n\n\n<p class="has-text-align-center has-small-font-size">For questions to be answered on the <a href="http://gutenbergtimes.com/podcast">Gutenberg Changelog</a>, <br />send them to <a href="mailto:changelog@gutenbergtimes.com">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n<section class="wp-block-newsletterglue-group" style="padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;">\n<p>Featured Image: Image generated with <a href="https://jetpack.com/ai/">Jetpack AI assistant. </a></p>\n\n\n\n<hr class="wp-block-separator has-css-opacity is-style-wide" />\n\n\n\n<p class="has-text-align-left"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form action="https://gutenbergtimes.com/feed/" autocomplete="on" class="wp-block-newsletterglue-form ngl-form ngl-portrait" method="post"><div class="ngl-form-container"><div class="ngl-form-field" style="margin-bottom: 25px;"><label class="ngl-form-label" for="ngl_email"><br />Type in your Email address to subscribe.</label><div class="ngl-form-input"><input autocomplete="email" class="ngl-form-input-text" id="ngl_email" name="ngl_email" required="required" style="border-radius: 21px;" type="email" /></div></div><button class="ngl-form-button" style="background-color: #005075; border-color: #005075; border-width: 1px; border-style: solid; color: #ffffff; border-radius: 21px;" type="submit">Subscribe</button><p class="ngl-form-text">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class="ngl-message-overlay"><div class="ngl-message-svg-wrap"><svg fill="none" height="24" stroke="#fff" stroke-width="2" viewBox="0 0 24 24" width="24" xmlns="http://www.w3.org/2000/svg"><polyline points="20 6 9 17 4 12"></polyline></svg></div><div class="ngl-message-overlay-text">Thanks for subscribing.</div></div><input id="ngl_list_id" name="ngl_list_id" type="hidden" value="26f81bd8ae" /><input id="ngl_double_optin" name="ngl_double_optin" type="hidden" value="yes" /></form>\n\n\n<hr class="wp-block-separator has-css-opacity is-style-wide" />\n</section>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 08 Nov 2025 04:31:00 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:18:"Birgit Pauli-Haack";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:19:"Matt: Kaycee Nicole";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150513";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:36:"https://ma.tt/2025/11/kaycee-nicole/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:409:"<p>Mimi Lamarre at Switchboard Magazine has a delightful long read in <a href="https://www.switchboardmagazine.com/monthly/the-curious-case-of-kaycee-nicole">The Curious Case of Kaycee Nicole</a>, where, in the early days of online communities and blogging, a fake person claimed to have leukemia. The blogging community was relatively small back then, and I recall some of this happening contemporarily. </p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 07 Nov 2025 23:36:21 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:38:"Matt: Conversation with John Borthwick";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150504";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:37:"https://ma.tt/2025/11/john-borthwick/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1089:"<p>I&#8217;m often on the other side, but it&#8217;s such a delight to be an interviewer, I really enjoy it and put a lot of work into coming up with questions and shaping a conversation I think will draw out something novel from the person. Besides the <a href="https://distributed.blog/">Distributed Podcast</a>, I&#8217;ve had a chance at events to interview great minds such as Steve Jurvetson, <a href="https://patrickcollison.com/">Patrick Collison</a>, <a href="https://dri.es/">Dries Buytaert</a>, and now John Borthwick.</p>\n\n\n\n<p>We discussed his early investments in Airbnb and Tumblr, what made the NYC tech scene so special back then, and how it has evolved since. We also touched on the recent mayoral race, where Betaworks fits into the city&#8217;s tech ecosystem, and delved into one of my favorite topics: the comparison between open-source and proprietary models in AI.</p>\n\n\n\n<figure class="wp-block-embed alignwide is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n\n</div></figure>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 07 Nov 2025 06:45:51 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:10;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:20:"Matt: Post-talk Recs";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150494";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:37:"https://ma.tt/2025/11/post-talk-recs/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:913:"<p>I just got off stage from the <a href="https://luma.com/fy86k4w5">great dev/ai/nyc event with John Borthwick</a>, we had a wide-ranging discussion that we&#8217;ll post online soon. We had hundreds of people in the room and hundreds on the waitlist&#8230; the energy in NYC is electric! </p>\n\n\n\n<figure class="wp-block-image size-large"><img alt="" class="wp-image-150495" height="805" src="https://i0.wp.com/ma.tt/files/2025/11/borthwick-mullenweg-768x1024.jpeg?resize=604%2C805&#038;quality=89&#038;ssl=1" width="604" /></figure>\n\n\n\n<p>As a few recommendations from the event, I recommended revisiting the <a href="https://en.wikipedia.org/wiki/Her_(2013_film)">movie Her</a> and <a href="https://en.wikipedia.org/wiki/Culture_series">Iain M. Banks Culture series</a>, John recommended <a href="https://amzn.to/47LYJ7D">The MANIAC about John von Neumann</a>, which I&#8217;ll add to my reading queue now.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 06 Nov 2025 01:55:39 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:11;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:96:"WPTavern: #192 – Joshua Bryant on How Dow Jones Is Supercharging WordPress Editorial Workflows";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:48:"https://wptavern.com/?post_type=podcast&p=200562";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:110:"https://wptavern.com/podcast/192-joshua-bryant-on-how-dow-jones-is-supercharging-wordpress-editorial-workflows";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:56442:"<details>Transcription<div>\n<p>[00:00:19] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress, the people, the events, the plugins, the blocks, the themes, and in this case, how Dow Jones is supercharging WordPress editorial workflows.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today we have Joshua Bryant. Joshua works at Dow Jones, helping power some of the world&#8217;s largest publishing sites, including the Wall Street Journal, Barron&#8217;s, and MarketWatch, all on a WordPress Multisite platform.</p>\n\n\n\n<p>His background with WordPress started, as it does for so many, by inheriting a site and slowly peeling back the layers of what the CMS can do, from page building to infrastructure and custom workflows.</p>\n\n\n\n<p>At Word Camp US, he delivered a presentation called Reimagining WordPress Editing: How We Embedded Gutenberg Into Our Product Ecosystem, which digs into how his team decoupled the Gutenberg block editor from WP Admin. And embedded it in a standalone React application, all while keeping content stored in a traditional WordPress database.</p>\n\n\n\n<p>This episode is a journey into why time, down to the second, matters in the publishing world, and how headless solutions can address those needs.</p>\n\n\n\n<p>Joshua explains how editorial workflows were rebuilt so that breaking news can be published, or updated, with lightning fast speeds, removing distractions and page reloads for editors, while retaining the full power and extensibility of WordPress behind the scenes.</p>\n\n\n\n<p>We talk through the technical architecture, planning, editing, and rendering are split into separate applications with Gutenberg customized down to just two or three essential blocks, living outside the typical WordPress environment.</p>\n\n\n\n<p>Joshua talks about the challenge of simulating the global WP object, keeping business logic and proprietary plugins intact, and interacting with the rest API for Instantaneous content publishing.</p>\n\n\n\n<p>If you&#8217;re interested in headless WordPress, editorial workflows at scale, or how Enterprise newsrooms leverage open source tech for real world speed, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Joshua Bryant.</p>\n\n\n\n<p>I am joined on the podcast by Joshua Bryant. Hello.</p>\n\n\n\n<p>[00:03:25] <strong>Joshua Bryant:</strong> Hi.</p>\n\n\n\n<p>[00:03:26] <strong>Nathan Wrigley:</strong> Nice to meet you. This is the first time that we&#8217;ve ever met. We&#8217;re going to be talking today about, well, the Dow Jones website, but also about headless, I guess is probably the best way to sum it up. So strap in. This is going to be a tinfoil hat episode. I am also going to say at the beginning that this is an episode for which I am supremely unqualified. So I hope that you are going to be able to shepherd me and call me out when I ask a silly question. So let&#8217;s hope for the best.</p>\n\n\n\n<p>The reason that I&#8217;ve got you on is because headless is an interesting subject, there&#8217;s that, but also the fact that it&#8217;s Dow Jones that you are dealing with, and the profound importance of that. The fact that, of all the websites I can imagine, there&#8217;s not many which have that requirement to be alive a hundred percent of the time. So that whole piece is going to fit in as well.</p>\n\n\n\n<p>Before we get into that, would you mind just telling us a bit about you? I mean, we know where you work now, but other than that, tell us about your experience with WordPress and so on.</p>\n\n\n\n<p>[00:04:18] <strong>Joshua Bryant:</strong> Right. So, I mean, I started, I think like most WordPress people started, I inherited a WordPress website knowing nothing about web development at all. And so I struggled my way through Googling, what is DNS? What does that even mean?</p>\n\n\n\n<p>And the WordPress offered me the opportunity to grow, and there&#8217;s always something new to learn. So from day one, I started learning about building pages, and then themes, and then plugins. And then I got a job where I was building themes and plugins. And then I got a job where I was really working on the infrastructure behind it.</p>\n\n\n\n<p>As I continue to grow, I keep learning that there&#8217;s always another layer to WordPress. And I think I&#8217;m getting close to the bottom, but that&#8217;s what I thought every layer. So I did a little bit of contributing last year when I was here at WordCamp, and I&#8217;m just excited to keep growing and keep learning more about the power that we have in that WordPress environment.</p>\n\n\n\n<p>[00:05:18] <strong>Nathan Wrigley:</strong> Thank you for that. So you&#8217;re at WordCamp US, obviously, you&#8217;re talking to me, we&#8217;re in the same room. Presentation that you did or doing?</p>\n\n\n\n<p>[00:05:26] <strong>Joshua Bryant:</strong> Did.</p>\n\n\n\n<p>[00:05:26] <strong>Nathan Wrigley:</strong> Did. We&#8217;ll get to that in a minute. It was called Reimagining WordPress Editing: How We Embedded Gutenberg Into Our Product Ecosystem. I might read some of the blurb in a little bit, but first of all, how did it go?</p>\n\n\n\n<p>[00:05:37] <strong>Joshua Bryant:</strong> I think it went well.</p>\n\n\n\n<p>[00:05:38] <strong>Nathan Wrigley:</strong> Good.</p>\n\n\n\n<p>[00:05:39] <strong>Joshua Bryant:</strong> Yeah. I told the story in the presentation that I teach teenagers a lot. And it was a couple years ago, I&#8217;m in the middle of a lesson and I looked down and nobody&#8217;s paying attention to me because one of the students had gotten so bored, he had started ripping apart his styrofoam cup and he had been eating it. He was halfway through eating the cup. Halfway through my presentation, I look and nobody had done anything sort of like that. So I felt like the presentation went well, people were paying attention. That&#8217;s kind of my benchmark.</p>\n\n\n\n<p>[00:06:08] <strong>Nathan Wrigley:</strong> That&#8217;s a good one.</p>\n\n\n\n<p>[00:06:08] <strong>Joshua Bryant:</strong> I think I&#8217;ve gotten better.</p>\n\n\n\n<p>[00:06:10] <strong>Nathan Wrigley:</strong> So here&#8217;s the blurb. And I won&#8217;t do it all, I&#8217;ll get maybe through the first paragraph and hopefully, dear listener, it&#8217;ll give you some context for what&#8217;s going to come in the next 40 minutes, half an hour or so.</p>\n\n\n\n<p>What happens when you take the Gutenberg editor out of WordPress? This talk explores how we decouple the block editor from WP Admin and the Loop, embedding it in a standalone React application to power custom editorial workflows, while still saving to a traditional WordPress database.</p>\n\n\n\n<p>Now there&#8217;s a lot in there. And I think that subject would be curious if it was just, you know, the mom and pop website, but the fact that you are actually dealing with, forgive me if I get this wrong, dowjones.com. I don&#8217;t know if it is dowjones.com, but it&#8217;s certainly the Dow Jones.</p>\n\n\n\n<p>[00:06:50] <strong>Joshua Bryant:</strong> So Dow Jones as an entity, a fun fact, they no longer own the Dow Jones market. They sold it. But they do own a lot of publishing websites. So they own websites like the Wall Street Journal, Barron&#8217;s, Mansion Global. We&#8217;ve purchased more, I don&#8217;t know if I can say any of the other names right now, but we own all of those entities and so they are on a Multisite.</p>\n\n\n\n<p>And so right now our publishing system, all of our editors publish from those websites in our WordPress Multisite environment. And all of that, we can talk about headless, but all of that actually goes into this all knowing database in the sky, where our front end systems pick them up. So WordPress itself doesn&#8217;t render wsj.com. We have a mobile team that does that. One way, we have a web team that does it a different way, and they all read from this all knowing database.</p>\n\n\n\n<p>But we use WordPress and our editors use it, we call it NewsPress, and we use it to publish all of our content. Our editors find it easy to use, and we like all of the features that WordPress offers. So we&#8217;ve leveraged the power of WordPress to do those things.</p>\n\n\n\n<p>[00:08:03] <strong>Nathan Wrigley:</strong> Some of those names were really enormous entities. Did you say the Wall Street Journal, or?</p>\n\n\n\n<p>[00:08:08] <strong>Joshua Bryant:</strong> Yeah.</p>\n\n\n\n<p>[00:08:09] <strong>Nathan Wrigley:</strong> Yeah, I mean, these are ones that I&#8217;ve heard of and I don&#8217;t live in this country, so that&#8217;s pretty profound. So I guess they&#8217;ve got an incredible appetite for traffic, but also an incredible need to be there a hundred percent. Not this 99.8% of the time. This is 100% of the time, I&#8217;m guessing.</p>\n\n\n\n<p>[00:08:26] <strong>Joshua Bryant:</strong> Right. And the topic that we&#8217;re going to talk about today, and it applies to all news, but when there&#8217;s breaking news, being first to market matters. Being 10 seconds ahead of your competitor when Taylor Swift gets engaged is an important amount of time when you&#8217;re sending out a push notification. Or in the case of MarketWatch, when there are going to be fluctuations in the market and we have editors listening in on board meetings, being able to send that information out and get that to our readers as soon as possible is the most important thing to our publications.</p>\n\n\n\n<p>[00:08:59] <strong>Nathan Wrigley:</strong> So is this a project, or an infrastructure, let&#8217;s go with that, that you inherited or were you bought in to build this?</p>\n\n\n\n<p>[00:09:06] <strong>Joshua Bryant:</strong> Both. In the most simple terms, I can explain it, we&#8217;ll say we have three systems. We have a React based planning tool. We have a WordPress editing tool, where we actually write the articles, save the content, control user permissions, lock and unlock posts. And then we have the front end that then takes what they publish and display it in any way that they need across all of our publications. So we have planning, editing and rendering. And those are three completely separate buckets that have been there for quite some time.</p>\n\n\n\n<p>[00:09:43] <strong>Nathan Wrigley:</strong> So we&#8217;re at a WordPress event and we&#8217;re surrounded by WordPressers, so it is kind of a bit of a bubble that we&#8217;re in at the minute. Everybody in this hall, in this place, kind of would understand what you&#8217;ve just described. However, dear listener, hopefully I&#8217;m not besmirching you, but there&#8217;s going to be a bunch of people listening to this who, what you just said went completely over their head.</p>\n\n\n\n<p>They download WordPress, they pay a few dollars a month to pop it on a host that they believe is reliable, and they know there&#8217;s a database somewhere but they&#8217;re kind of using the front end. And that&#8217;s all that they need to concern themselves about. Just explain in more detail what you just said. This React, this editing and this front end. What even is that?</p>\n\n\n\n<p>[00:10:20] <strong>Joshua Bryant:</strong> Right. I mean you can think of them as three separate applications on your phone. You might use one app, like your calendar, to plan things out. That&#8217;s what our planning tool is. It essentially lets us coordinate with each other and say, hey, we need to have a steady stream of stories. And we also want to attach, our photographers are going to put some images in those stories, so we might add that to the calendar invite description. Those are the kind of things we do in the planning tool.</p>\n\n\n\n<p>And then in the WordPress tool, it&#8217;s a lot like what anybody does in WordPress. We&#8217;re writing posts, we&#8217;re adding images, and in the case of the newsroom, they might do a couple things around SEO, and add some metadata that we want to show up on Google. And I think everybody should be familiar with creating posts.</p>\n\n\n\n<p>And then a completely different system picks it up and says, okay, I&#8217;m going to show everybody what it looks like. And that part is not really important because that&#8217;s the headless part. But you don&#8217;t really need to understand that there&#8217;s another system that does this thing differently, to understand what we&#8217;re going to talk about as far as, we moved our editor into, let&#8217;s say, a very simplified tool.</p>\n\n\n\n<p>One example that I like to think about is, when we have done this project, we did it very specifically for the newsroom&#8217;s needs. So we tailored it very, very specifically. But I like to think of the applications of, I like to collect people who have great quotes. When I hear a great quote, I&#8217;m like, oh, I need to write that down. I don&#8217;t want to forget it. I like to think of it as, I want to pull up something like Twitter or Bluesky, and I want to just type in a field, hit send, and then it publishes a post on my WordPress dashboard. It&#8217;s a custom post that says, here&#8217;s a notable tweet. And it posted it.</p>\n\n\n\n<p>That way I don&#8217;t lose that and I can have it in my WordPress, which is where I keep most of like, I keep my recipes, and my notes, and my blogs, and everything that I want to remember. It&#8217;s like my personal online notebook. But now we&#8217;ve created a mechanism where we can kind of take that and extend it anywhere we want outside of just the WP Editor, and be able to pull something up and say, hey, there&#8217;s a different application. You type it in, you hit send, and then it all runs through WordPress itself.</p>\n\n\n\n<p>[00:12:48] <strong>Nathan Wrigley:</strong> What are the reasons why that needed to be done? So just sort of going backwards a bit, really. Obviously that is what is possible, but why is just a default version of WordPress on red hot hosting not something that is suitable in this situation? What affordances does it get you? What performance does it buy you? What UI does it allow you to create that makes this possible? And I think you said you built your own proprietary system. What did you call it, press news or news?</p>\n\n\n\n<p>[00:13:15] <strong>Joshua Bryant:</strong> NewsPress.</p>\n\n\n\n<p>[00:13:15] <strong>Nathan Wrigley:</strong> NewsPress, sorry. Wrong way around. So, why? What are the limitations in WordPress that were unignorable that required this?</p>\n\n\n\n<p>[00:13:22] <strong>Joshua Bryant:</strong> I don&#8217;t think there were necessarily limitations. We are talking about shaving seconds off the editor process. And so there are a lot of things in our WordPress system that we want editors to do before they publish a normal article. We want them to have certain SEO titles listed. We want them to have fallback images for headline videos. We are okay with the way everything operates inside of WordPress, but we&#8217;re talking about shaving seconds off by putting it, first of all, in a tool that the editors are already in. They&#8217;re planning their day, they&#8217;re planning their month in the planning tool. And it&#8217;s a single page application. There&#8217;s no page reload. It&#8217;s all in React. There&#8217;s no calling a database that we have to worry about.</p>\n\n\n\n<p>We&#8217;re literally just pulling up the Gutenberg editor, typing out a breaking news or a market watch, we call them pulse, some update that we need to get to our readers. And if there&#8217;s a bunch of information that comes in, we need to be able to hit 10 posts with as limited information as possible and get it to publish all the way to the front end, and do 10 in a row as quickly as possible.</p>\n\n\n\n<p>[00:14:37] <strong>Nathan Wrigley:</strong> So the raison d&#8217;etre there then is time. It&#8217;s all about shaving seconds off because in the industry that you are in, if you&#8217;re five seconds late, you might as well not publish.</p>\n\n\n\n<p>[00:14:46] <strong>Joshua Bryant:</strong> Right. It&#8217;s time, and it&#8217;s also distraction for our editors. They don&#8217;t have the full editor experience anymore. They don&#8217;t have the sidebar, and all the tabs because we have a lot of stuff in our editor.</p>\n\n\n\n<p>[00:14:58] <strong>Nathan Wrigley:</strong> Okay, so in this three step process where you&#8217;ve got the React, and we&#8217;ll talk about ripping out Gutenberg and pushing it to this React app in a minute. But we&#8217;ve got the React app where the planning is done, then presumably when the planning is finished, and I&#8217;m going to use the word publish, maybe it&#8217;s not publish, but you hit a button, presumably that pushes it down the funnel towards the WordPress install, which then pushes it to the front end. So there&#8217;s this kind of like one way cycle.</p>\n\n\n\n<p>But the idea of the React, Gutenberg bit is that it&#8217;s fast, really fast and distraction free. There&#8217;s just no clutter. It&#8217;s just, you&#8217;re familiar with that interface. Because with the best one in the world, WordPress, there&#8217;s a lot of things going on. When you click publish, quite a lot can happen at that moment. You don&#8217;t want any of that. You just want publish. Boom. Done.</p>\n\n\n\n<p>[00:15:39] <strong>Joshua Bryant:</strong> Right.</p>\n\n\n\n<p>[00:15:40] <strong>Nathan Wrigley:</strong> Okay. So you&#8217;ve pulled the Gutenberg editor out of WordPress. And, okay, I think it&#8217;s important at this point to say, Gutenberg is an open source project. We&#8217;re mostly familiar with it sitting inside of WordPress, but it doesn&#8217;t belong there. And you&#8217;ve put it inside of this React app. How have you customised it to get it there, and what have you stripped out, what have you added in?</p>\n\n\n\n<p>[00:16:01] <strong>Joshua Bryant:</strong> Yeah, great question because part of the reason we decided to continue to use Gutenberg instead of some other React tool is that we&#8217;ve already invested so much time and effort into the business logic around our custom plugins and around the workflow, and we&#8217;ve put so much into our WordPress environment that we asked ourselves, how can we maintain all the equity we have in WordPress and leverage the power of WordPress, but put it in a slightly different place where we can take care of all of our editor&#8217;s needs? And so that was really the driving factor behind, okay, we&#8217;re going to move it here, but we still want all the things we have there.</p>\n\n\n\n<p>And so what we did is we limited the number of blocks. While we might have most of the Core blocks in our regular editor, we have the paragraph and list block in our planning.</p>\n\n\n\n<p>[00:17:01] <strong>Nathan Wrigley:</strong> That&#8217;s it?</p>\n\n\n\n<p>[00:17:01] <strong>Joshua Bryant:</strong> Yeah, because that&#8217;s all we needed. That&#8217;s all we needed. And we have a couple custom plugins that we&#8217;ve moved in